//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/nsdataassetname?language=objc)
pub type NSDataAssetName = NSString;

extern_class!(
    /// NSDataAsset represents the contents of data entries in your asset catalog.
    /// Data assets are not in the same class of stored content as images, so you cannot use a data asset to get image data for an image.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/nsdataasset?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSDataAsset;
);

unsafe impl Send for NSDataAsset {}

unsafe impl Sync for NSDataAsset {}

extern_conformance!(
    unsafe impl NSCopying for NSDataAsset {}
);

unsafe impl CopyingHelper for NSDataAsset {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSDataAsset {}
);

impl NSDataAsset {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        /// Equivalent to -initWithName:name bundle:[NSBundle mainBundle];
        #[unsafe(method(initWithName:))]
        #[unsafe(method_family = init)]
        pub fn initWithName(
            this: Allocated<Self>,
            name: &NSDataAssetName,
        ) -> Option<Retained<Self>>;

        /// Create a data asset with the given name from the given bundle. Returns nil if the asset was not found.
        #[unsafe(method(initWithName:bundle:))]
        #[unsafe(method_family = init)]
        pub fn initWithName_bundle(
            this: Allocated<Self>,
            name: &NSDataAssetName,
            bundle: &NSBundle,
        ) -> Option<Retained<Self>>;

        /// The name used to reference the data asset
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(name))]
        #[unsafe(method_family = none)]
        pub unsafe fn name(&self) -> Retained<NSDataAssetName>;

        /// The data for this asset, as stored in the asset catalog
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(data))]
        #[unsafe(method_family = none)]
        pub unsafe fn data(&self) -> Retained<NSData>;

        /// The Uniform Type Identifier for this data object.
        ///
        /// This property is not atomic.
        ///
        /// # Safety
        ///
        /// This might not be thread-safe.
        #[unsafe(method(typeIdentifier))]
        #[unsafe(method_family = none)]
        pub unsafe fn typeIdentifier(&self) -> Retained<NSString>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSDataAsset {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
