searchData={"items":[{"type":"module","title":"eunit","doc":"This module is the main EUnit user interface.","ref":"eunit.html"},{"type":"function","title":"eunit.start/0","doc":"Starts the EUnit server. Normally, you don't need to call this function; it is\nstarted automatically.","ref":"eunit.html#start/0"},{"type":"function","title":"eunit.stop/0","doc":"Stops the EUnit server. Normally, you don't need to call this function.","ref":"eunit.html#stop/0"},{"type":"function","title":"eunit.test/1","doc":"","ref":"eunit.html#test/1"},{"type":"function","title":"eunit.test/2","doc":"Runs a set of tests. The format of `Tests` is described in the section\n[EUnit test representation](chapter.md#EUnit_test_representation) of the\noverview.\n\nExample:\n\n```text\n  eunit:test(fred)\n```\n\nruns all tests in the module `fred` and also any tests in the module\n`fred_tests`, if that module exists.\n\nOptions:\n\n- **`verbose`** - Displays more details about the running tests.\n\n- **`print_depth`** - Maximum depth to which terms are printed in case of error.\n\n- **`exact_execution`** - If this boolean flag is set to `true` framework will\n  not automatically execute tests found in related module suffixed with\n  \"\\_tests\". This behaviour might be unwanted if execution of modules found in a\n  folder is ordered while it contains both source and test modules.\n\n- **`scale_timeouts`** - If this numeric value is set, timeouts will get scaled\n  accordingly. It may be useful when running a set of tests on a slower host.\n  Examples: `{scale_timeouts,10}` make the timeouts 10 times longer, while\n  `{scale_timeouts,0.1}` would shorten them by a factor of 10.\n\nOptions in the environment variable EUNIT are also included last in the option\nlist, i.e., have lower precedence than those in `Options`.\n\n_See also: _`test/1`.","ref":"eunit.html#test/2"},{"type":"module","title":"eunit_surefire","doc":"Surefire reports for EUnit (Format used by Maven and Atlassian Bamboo for\nexample to integrate test results). Based on initial code from Paul Guyot.\n\nExample: Generate XML result file in the current directory:\n\n```text\n     eunit:test([fib, eunit_examples],\n                [{report,{eunit_surefire,[{dir,\".\"}]}}]).\n```\n\n_See also: _`m:eunit`.","ref":"eunit_surefire.html"},{"type":"extras","title":"EUnit Release Notes","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# EUnit Release Notes\n\nThis document describes the changes made to the EUnit application.","ref":"notes.html"},{"type":"extras","title":"Eunit 2.9.1 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-9-1"},{"type":"extras","title":"Improvements and New Features - EUnit Release Notes","doc":"- The documentation has been migrated to use Markdown and ExDoc.\n\n  Own Id: OTP-18955 Aux Id: [PR-8026]\n\n[PR-8026]: https://github.com/erlang/otp/pull/8026","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eunit 2.9 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-9"},{"type":"extras","title":"Improvements and New Features - EUnit Release Notes","doc":"- With this change, EUnit timetraps can be scaled with the use of scale_timeouts\n  option.\n\n  Own Id: OTP-18771 Aux Id: PR-7635","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eunit 2.8.2 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-8-2"},{"type":"extras","title":"Improvements and New Features - EUnit Release Notes","doc":"- Replace size/1 with either tuple_size/1 or byte_size/1\n\n  The [`size/1`](`size/1`) BIF is not optimized by the JIT, and its use can\n  result in worse types for Dialyzer.\n\n  When one knows that the value being tested must be a tuple,\n  [`tuple_size/1`](`tuple_size/1`) should always be preferred.\n\n  When one knows that the value being tested must be a binary,\n  [`byte_size/1`](`byte_size/1`) should be preferred. However,\n  [`byte_size/1`](`byte_size/1`) also accepts a bitstring (rounding up size to a\n  whole number of bytes), so one must make sure that the call to `byte_size/` is\n  preceded by a call to [`is_binary/1`](`is_binary/1`) to ensure that bitstrings\n  are rejected. Note that the compiler removes redundant calls to\n  [`is_binary/1`](`is_binary/1`), so if one is not sure whether previous code\n  had made sure that the argument is a binary, it does not harm to add an\n  [`is_binary/1`](`is_binary/1`) test immediately before the call to\n  [`byte_size/1`](`byte_size/1`).\n\n  Own Id: OTP-18432 Aux Id:\n  GH-6672,PR-6793,PR-6784,PR-6787,PR-6785,PR-6682,PR-6800,PR-6797,PR-6798,PR-6799,PR-6796,PR-6813,PR-6671,PR-6673,PR-6684,PR-6694,GH-6677,PR-6696,PR-6670,PR-6674","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eunit 2.8.1 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-8-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EUnit Release Notes","doc":"- With this change, eunit exact_execution option works with application\n  primitive.\n\n  Own Id: OTP-18264 Aux Id: PR-6322, GH-6320","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Eunit 2.8 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-8"},{"type":"extras","title":"Improvements and New Features - EUnit Release Notes","doc":"- With this change, Eunit can optionally not try to execute related module with\n  \"\\_tests\" suffix. This might be used for avoiding duplicated executions when\n  source and test modules are located in the same folder.\n\n  Own Id: OTP-18181 Aux Id: ERL-97, GH-3064, PR-5461","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eunit 2.7.1 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-7-1"},{"type":"extras","title":"Improvements and New Features - EUnit Release Notes","doc":"- Minor internal improvements.\n\n  Own Id: OTP-17884 Aux Id: GH-5617","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eunit 2.7 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-7"},{"type":"extras","title":"Improvements and New Features - EUnit Release Notes","doc":"- In an eunit test, when a test case times out, include a stacktrace.\n\n  Own Id: OTP-17613 Aux Id: PR-5185","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eunit 2.6.1 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-6-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EUnit Release Notes","doc":"- The `m:eunit_surefire` report handler has been updated to automatically create\n  the directories needed to store the surefire xml file.\n\n  Own Id: OTP-17300 Aux Id: PR-4695","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Eunit 2.6 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-6"},{"type":"extras","title":"Improvements and New Features - EUnit Release Notes","doc":"- Fixed compiler warning.\n\n  Own Id: OTP-16674","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eunit 2.5 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-5"},{"type":"extras","title":"Improvements and New Features - EUnit Release Notes","doc":"- Let `eunit_surefire` skip invalid XML 1.0 characters.\n\n  Own Id: OTP-15950 Aux Id: PR-2316, ERL-991\n\n- Add new macro ?capturedOutput for enabling to write test cases that verify\n  data printed to standard out\n\n  Own Id: OTP-16275 Aux Id: PR-2424\n\n- Add option to limit print depth of exceptions generated by eunit test suites.\n\n  Own Id: OTP-16549 Aux Id: PR-2532","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eunit 2.4.1 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-4-1"},{"type":"extras","title":"Improvements and New Features - EUnit Release Notes","doc":"- Backport of PR-2316: Strip control codes from eunit_surefire output to avoid\n  generation of invalid xml\n\n  Own Id: OTP-16380 Aux Id: ERL-991, PR-2316, PR-2487","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eunit 2.4 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-4"},{"type":"extras","title":"Improvements and New Features - EUnit Release Notes","doc":"- Remove compiler warnings from eunit.\n\n  Own Id: OTP-16313","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eunit 2.3.8 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-3-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EUnit Release Notes","doc":"- Handle `get_until` request with explicit encoding in the implementation of the\n  I/O protocol.\n\n  Own Id: OTP-16000","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Eunit 2.3.7 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-3-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EUnit Release Notes","doc":"- Improved documentation.\n\n  Own Id: OTP-15190","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Eunit 2.3.6 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-3-6"},{"type":"extras","title":"Improvements and New Features - EUnit Release Notes","doc":"- Calls to `erlang:get_stacktrace()` are removed.\n\n  Own Id: OTP-14861","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eunit 2.3.5 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-3-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EUnit Release Notes","doc":"- Removed all old unused files in the documentation.\n\n  Own Id: OTP-14475 Aux Id: ERL-409, PR-1493","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Eunit 2.3.4 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-3-4"},{"type":"extras","title":"Improvements and New Features - EUnit Release Notes","doc":"- Tools are updated to show Unicode atoms correctly.\n\n  Own Id: OTP-14464","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eunit 2.3.3 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-3-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EUnit Release Notes","doc":"- The surefire reports from `eunit` will no longer have names with embedded\n  double quotes.\n\n  Own Id: OTP-14287","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Eunit 2.3.2 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-3-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EUnit Release Notes","doc":"- The address to the FSF in the license header has been updated.\n\n  Own Id: OTP-14084","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Eunit 2.3.1 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EUnit Release Notes","doc":"- When asserts were moved out to a separate header file, the automatic enabling\n  of asserts when testing is enabled stopped working.\n\n  Own Id: OTP-13892","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Eunit 2.3 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-3"},{"type":"extras","title":"Improvements and New Features - EUnit Release Notes","doc":"- There is a new `debugVal/2` that gives control over the truncation depth.\n\n  Own Id: OTP-13612","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eunit 2.2.13 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-2-13"},{"type":"extras","title":"Improvements and New Features - EUnit Release Notes","doc":"- Suppress Dialyzer warnings.\n\n  Own Id: OTP-12862","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eunit 2.2.12 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-2-12"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EUnit Release Notes","doc":"- Small documentation fixes\n\n  Own Id: OTP-13017","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Eunit 2.2.11 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-2-11"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EUnit Release Notes","doc":"- Improve success message when 2 tests have passed\n\n  Own Id: OTP-12952","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Eunit 2.2.10 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-2-10"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EUnit Release Notes","doc":"- The `eunit` application is now unicode safe.\n\n  Own Id: OTP-11660","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Eunit 2.2.9 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-2-9"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EUnit Release Notes","doc":"- Make sure to install .hrl files when needed\n\n  Own Id: OTP-12197\n\n- Make sure the clean rule for ssh, ssl, eunit and otp_mibs actually removes\n  generated files.\n\n  Own Id: OTP-12200","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Eunit 2.2.8 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-2-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EUnit Release Notes","doc":"- Minor refactoring.\n\n  Own Id: OTP-12051","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Eunit 2.2.7 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-2-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EUnit Release Notes","doc":"- Application upgrade (appup) files are corrected for the following\n  applications:\n\n  `asn1, common_test, compiler, crypto, debugger, dialyzer, edoc, eldap, erl_docgen, et, eunit, gs, hipe, inets, observer, odbc, os_mon, otp_mibs, parsetools, percept, public_key, reltool, runtime_tools, ssh, syntax_tools, test_server, tools, typer, webtool, wx, xmerl`\n\n  A new test utility for testing appup files is added to test_server. This is\n  now used by most applications in OTP.\n\n  (Thanks to Tobias Schlager)\n\n  Own Id: OTP-11744","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Eunit 2.2.6 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-2-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EUnit Release Notes","doc":"- Fix I/O-protocol error handling in eunit. Thanks to Yuki Ito.\n\n  Own Id: OTP-11373\n\n- Do not attempt to detect lists of printable characters in format. Thanks to\n  Roberto Aloi.\n\n  Own Id: OTP-11467\n\n- Fix silent make rule (Thanks to Anthony Ramine )\n\n  Own Id: OTP-11516","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Eunit 2.2.5 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-2-5"},{"type":"extras","title":"Improvements and New Features - EUnit Release Notes","doc":"- Wrap eunit macros into begin ... end blocks. Thanks to Anthony Ramine.\n\n  Own Id: OTP-11217","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eunit 2.2.4 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-2-4"},{"type":"extras","title":"Improvements and New Features - EUnit Release Notes","doc":"- Where necessary a comment stating encoding has been added to Erlang files. The\n  comment is meant to be removed in Erlang/OTP R17B when UTF-8 becomes the\n  default encoding.\n\n  Own Id: OTP-10630","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eunit 2.2.3 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-2-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EUnit Release Notes","doc":"- New option 'no_tty' to silent the default tty report.\n\n  Recognize the new stacktrace format introduced in R15, adding location\n  information. (Thanks to Klas Johansson.)\n\n  Improve layout of error messages, printing the stack trace before the error\n  term.\n\n  Heuristically detect and report bad return values from generators and\n  instantiators. E.g., \"ok\" will not be interpreted as a module name, and a\n  warning will be printed.\n\n  New test representation \\{test,M,F\\} for completeness along with\n  \\{generator,M,F\\}. Tuples \\{M,F\\} are deprecated.\n\n  Use UTF-8 as encoding in Surefire output files. (Thanks to Lukas Larsson.)\n\n  Own Id: OTP-10173","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Eunit 2.2.2 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-2-2"},{"type":"extras","title":"Improvements and New Features - EUnit Release Notes","doc":"- Erlang/OTP can now be built using parallel make if you limit the number of\n  jobs, for instance using '`make -j6`' or '`make -j10`'. '`make -j`' does not\n  work at the moment because of some missing dependencies.\n\n  Own Id: OTP-9451","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eunit 2.2.1 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-2-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EUnit Release Notes","doc":"- Generate separate surefire XMLs for each test suite\n\n  Previously the test cases of all test suites (=modules) were put in one and\n  the same surefire report XML thereby breaking the principle of least\n  astonishment and making post analysis harder. Assume the following layout:\n\n  src/x.erl src/y.erl test/x_tests.erl test/y_tests.erl\n\n  The results for both x_tests and y_tests were written to only one report\n  grouped under either module x or y (seemingly randomly).\n\n  Now two reports, one for module x and one for y are generated. (Thanks to Klas\n  Johansson)\n\n  Own Id: OTP-9465\n\n- Updated to EUnit version 2.2.0\n\n  New macros assertNotMatch(Guard, Expr), assertNotEqual(Unexpected, Expr), and\n  assertNotException(Class, Term, Expr).\n\n  The debugMsg macro now also prints the pid of the current process.\n\n  When testing all modules in a directory, tests in Module_tests.erl are no\n  longer executed twice.\n\n  The use of regexp internally has been replaced with re. (Thanks to Richard\n  Carlsson)\n\n  Own Id: OTP-9505\n\n- Removed some never-matching clauses reported by dialyzer Updated author\n  e-mails and homepages Removed cvs keywords from files Removed files that\n  should not be checked in (Thanks to Richard Carlsson)\n\n  Own Id: OTP-9591","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Eunit 2.1.7 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-1-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EUnit Release Notes","doc":"- Increase depth of error messages in Eunit Surefire reports\n\n  Currently, error messages in Eunit Surefire reports are shortened just like\n  when written to a terminal. However, the space limitations that constrain\n  terminal output do not apply here, so it's more useful to include more of the\n  error message. The new depth of 100 should be enough for most cases, while\n  protecting against runaway errors. (Thanks to Magnus Henoch)\n\n  Own Id: OTP-9220\n\n- Don't let eunit_surefire report back to eunit when stopping\n\n  When eunit is terminating, a stop message is sent to all listeners and eunit\n  then waits for _one_ result message but previously both eunit_tty and\n  eunit_surefire sent a response on error. Don't send a result message from\n  eunit_surefire; let eunit_tty take care of all result reporting, both positive\n  and negative to avoid race conditions and inconsistencies. (Thanks to Klas\n  Johansson)\n\n  Own Id: OTP-9269","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Eunit 2.1.6 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-1-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EUnit Release Notes","doc":"- Fix format_man_pages so it handles all man sections and remove warnings/errors\n  in various man pages.\n\n  Own Id: OTP-8600","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Eunit 2.1.5 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-1-5"},{"type":"extras","title":"Improvements and New Features - EUnit Release Notes","doc":"- The documentation is now possible to build in an open source environment after\n  a number of bugs are fixed and some features are added in the documentation\n  build process.\n\n  \\- The arity calculation is updated.\n\n  \\- The module prefix used in the function names for bif's are removed in the\n  generated links so the links will look like\n  \"http://www.erlang.org/doc/man/erlang.html#append_element-2\" instead of\n  \"http://www.erlang.org/doc/man/erlang.html#erlang:append_element-2\".\n\n  \\- Enhanced the menu positioning in the html documentation when a new page is\n  loaded.\n\n  \\- A number of corrections in the generation of man pages (thanks to Sergei\n  Golovan)\n\n  \\- The legal notice is taken from the xml book file so OTP's build process can\n  be used for non OTP applications.\n\n  Own Id: OTP-8343","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eunit 2.1.4 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-1-4"},{"type":"extras","title":"Improvements and New Features - EUnit Release Notes","doc":"- The documentation is now built with open source tools (xsltproc and fop) that\n  exists on most platforms. One visible change is that the frames are removed.\n\n  Own Id: OTP-8201","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eunit 2.1.3 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-1-3"},{"type":"extras","title":"Improvements and New Features - EUnit Release Notes","doc":"- Miscellaneous updates.\n\n  Own Id: OTP-8190","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eunit 2.1.2 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-1-2"},{"type":"extras","title":"Improvements and New Features - EUnit Release Notes","doc":"- Miscellaneous updates.\n\n  Own Id: OTP-8038","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Eunit 2.1.1 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-1-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - EUnit Release Notes","doc":"- eunit was broken in R13B.\n\n  Own Id: OTP-8018","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Eunit 2.1 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-1"},{"type":"extras","title":"Improvements and New Features - EUnit Release Notes","doc":"- Mostly internal changes, in particular to the event protocol; fixes problems\n  with timeouts that could cause eunit to hang, and makes it much easier to\n  write new reporting back-ends.\n\n  New \"surefire\" report backend for Maven and Bamboo.\n\n  The test representation is no longer traversed twice (the first pass was for\n  enumeration only). This eliminates some strange restrictions on how generators\n  can be written, but it also means that reports cannot be quite as complete as\n  before in the event of skipped tests.\n\n  Own Id: OTP-7964","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"EUnit 2.0.1 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-0-1"},{"type":"extras","title":"Improvements and New Features - EUnit Release Notes","doc":"- Corrected the documentation build.","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"EUnit 2.0 - EUnit Release Notes","doc":"","ref":"notes.html#eunit-2-0"},{"type":"extras","title":"Improvements and New Features - EUnit Release Notes","doc":"- This is the first version of EUnit (for unit testing of Erlang modules) by\n  Richard Carlsson released in OTP.","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"EUnit - a Lightweight Unit Testing Framework for Erlang","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# EUnit - a Lightweight Unit Testing Framework for Erlang\n\nEUnit is a unit testing framework for Erlang. It is very powerful and flexible,\nis easy to use, and has small syntactical overhead.\n\n- [Unit testing](chapter.md#Unit_testing)\n- [Terminology](chapter.md#terminology)\n- [Getting started](chapter.md#Getting_started)\n- [EUnit macros](chapter.md#EUnit_macros)\n- [EUnit test representation](chapter.md#EUnit_test_representation)\n\nEUnit builds on ideas from the family of unit testing frameworks for Object\nOriented languages that originated with JUnit by Beck and Gamma (and Beck's\nprevious framework SUnit for Smalltalk). However, EUnit uses techniques more\nadapted to functional and concurrent programming, and is typically less verbose\nthan its relatives.\n\nAlthough EUnit uses many preprocessor macros, they have been designed to be as\nnonintrusive as possible, and should not cause conflicts with existing code.\nAdding EUnit tests to a module should thus not normally require changing\nexisting code. Furthermore, tests that only exercise the exported functions of a\nmodule can always be placed in a completely separate module, avoiding any\nconflicts entirely.\n\n[](){: #Unit_testing }","ref":"chapter.html"},{"type":"extras","title":"Unit testing - EUnit - a Lightweight Unit Testing Framework for Erlang","doc":"Unit Testing is testing of individual program \"units\" in relative isolation.\nThere is no particular size requirement: a unit can be a function, a module, a\nprocess, or even a whole application, but the most typical testing units are\nindividual functions or modules. In order to test a unit, you specify a set of\nindividual tests, set up the smallest necessary environment for being able to\nrun those tests (often, you don't need to do any setup at all), you run the\ntests and collect the results, and finally you do any necessary cleanup so that\nthe test can be run again later. A Unit Testing Framework tries to help you in\neach stage of this process, so that it is easy to write tests, easy to run them,\nand easy to see which tests failed (so you can fix the bugs).\n\n[](){: #Advantages_of_unit_testing }","ref":"chapter.html#unit-testing"},{"type":"extras","title":"Advantages of unit testing - EUnit - a Lightweight Unit Testing Framework for Erlang","doc":"- **Reduces the risks of changing the program** - Most programs will be modified\n  during their lifetime: bugs will be fixed, features will be added,\n  optimizations may become necessary, or the code will need to be refactored or\n  cleaned up in other ways to make it easier to work with. But every change to a\n  working program is a risk of introducing new bugs - or reintroducing bugs that\n  had previously been fixed. Having a set of unit tests that you can run with\n  very little effort makes it easy to know that the code still works as it\n  should (this use is called _regression testing_; see\n  [Terminology](chapter.md#terminology)). This goes a long way to reduce the\n  resistance to changing and refactoring code.\n\n- **Helps guide and speed up the development process** - By focusing on getting\n  the code to pass the tests, the programmer can become more productive, not\n  overspecify or get lost in premature optimizations, and create code that is\n  correct from the very beginning (so-called _test-driven development_; see\n  [Terminology](chapter.md#terminology)).\n\n- **Helps separate interface from implementation** - When writing tests, the\n  programmer may discover dependencies (in order to get the tests to run) that\n  ought not to be there, and which need to be abstracted away to get a cleaner\n  design. This helps eliminate bad dependencies before they spread throughout\n  the code.\n\n- **Makes component integration easier** - By testing in a bottom-up fashion,\n  beginning with the smallest program units and creating a confidence in that\n  they work as they should, it becomes easier to test that a higher-level\n  component, consisting of several such units, also behaves according to\n  specification (known as _integration testing_; see\n  [Terminology](chapter.md#terminology)).\n\n- **Is self-documenting** - The tests can be read as documentation, typically\n  showing both examples of correct and incorrect usage, along with the expected\n  consequences.","ref":"chapter.html#advantages-of-unit-testing"},{"type":"extras","title":"Terminology - EUnit - a Lightweight Unit Testing Framework for Erlang","doc":"- **Unit testing** - Testing that a program unit behaves as it is supposed to do\n  (in itself), according to its specifications. Unit tests have an important\n  function as regression tests, when the program later is modified for some\n  reason, since they check that the program still behaves according to\n  specification.\n\n- **Regression testing** - Running a set of tests after making changes to a\n  program, to check that the program behaves as it did before the changes\n  (except, of course, for any intentional changes in behaviour). Unit tests are\n  important as regression tests, but regression testing can involve more than\n  just unit testing, and may also test behaviour that might not be part of the\n  normal specification (such as bug-for-bug-compatibility).\n\n- **Integration testing** - Testing that a number of individually developed\n  program units (assumed to already have been separately unit tested) work\n  together as expected. Depending on the system being developed, integration\n  testing may be as simple as \"just another level of unit testing\", but might\n  also involve other kinds of tests (compare _system testing_).\n\n- **System testing** - Testing that a complete system behaves according to its\n  specification. Specifically, system testing should not require knowing any\n  details about the implementation. It typically involves testing many different\n  aspects of the system behaviour apart from the basic functionality, such as\n  performance, usability, and reliability.\n\n- **Test-driven development** - A program development technique where you\n  continuously write tests _before_ you implement the code that is supposed to\n  pass those tests. This can help you focus on solving the right problems, and\n  not make a more complicated implementation than necessary, by letting the unit\n  tests determine when a program is \"done\": if it fulfils its specifications,\n  there is no need to keep adding functionality.\n\n- **Mock object** - Sometimes, testing some unit `A` (e.g., a function) requires\n  that it collaborates somehow with some other unit `B` (perhaps being passed as\n  an argument, or by reference) - but `B` has not been implemented yet. A \"mock\n  object\" - an object which, for the purposes of testing `A`, looks and behaves\n  like a real `B` \\- might then be used instead. (This is of course only useful\n  if it would be significantly more work to implement a real `B` than to create\n  a mock object.)\n\n- **Test case** - A single, well-defined test, that somehow can be uniquely\n  identified. When executed, the test case either _passes_ or _fails_; the test\n  report should identify exactly which test cases failed.\n\n- **Test suite** - A collection of test cases, generally with a specific, common\n  target for testing, such as a single function, module, or subsystem. A test\n  suite may also be recursively composed by smaller test suites.\n\n[](){: #Getting_started }","ref":"chapter.html#terminology"},{"type":"extras","title":"Getting started - EUnit - a Lightweight Unit Testing Framework for Erlang","doc":"- [Including the EUnit header file](chapter.md#Including_the_EUnit_header_file)\n- [Writing simple test functions](chapter.md#Writing_simple_test_functions)\n- [Running EUnit](chapter.md#Running_EUnit)\n- [Writing test generating functions](chapter.md#Writing_test_generating_functions)\n- [An example](chapter.md#An_example)\n- [Disabling testing](chapter.md#Disabling_testing)\n- [Avoiding compile-time dependency on EUnit](chapter.md#Avoiding_compile-time_dependency_on_EUnit)\n\n[](){: #Including_the_EUnit_header_file }","ref":"chapter.html#getting-started"},{"type":"extras","title":"Including the EUnit header file - EUnit - a Lightweight Unit Testing Framework for Erlang","doc":"The simplest way to use EUnit in an Erlang module is to add the following line\nat the beginning of the module (after the `-module` declaration, but before any\nfunction definitions):\n\n```text\n   -include_lib(\"eunit/include/eunit.hrl\").\n```\n\nThis will have the following effect:\n\n- Creates an exported function `test()` (unless testing is turned off, and the\n  module does not already contain a test() function), that can be used to run\n  all the unit tests defined in the module\n- Causes all functions whose names match `..._test()` or `..._test_()` to be\n  automatically exported from the module (unless testing is turned off, or the\n  `EUNIT_NOAUTO` macro is defined)\n- Makes all the preprocessor macros of EUnit available, to help writing tests\n\n_Note:_ For `-include_lib(...)` to work, the Erlang module search path _must_\ncontain a directory whose name ends in `eunit/ebin` (pointing to the `ebin`\nsubdirectory of the EUnit installation directory). If EUnit is installed as\n`lib/eunit` under your Erlang/OTP system directory, its `ebin` subdirectory will\nbe automatically added to the search path when Erlang starts. Otherwise, you\nneed to add the directory explicitly, by passing a `-pa` flag to the `erl` or\n`erlc` command. For example, a Makefile could contain the following action for\ncompiling `.erl` files:\n\n```text\n   erlc -pa \"path/to/eunit/ebin\" $(ERL_COMPILE_FLAGS) -o$(EBIN) $<\n```\n\nor if you want Eunit to always be available when you run Erlang interactively,\nyou can add a line like the following to your `$HOME/.erlang` file:\n\n```text\n   code:add_path(\"/path/to/eunit/ebin\").\n```\n\n[](){: #Writing_simple_test_functions }","ref":"chapter.html#including-the-eunit-header-file"},{"type":"extras","title":"Writing simple test functions - EUnit - a Lightweight Unit Testing Framework for Erlang","doc":"The EUnit framework makes it extremely easy to write unit tests in Erlang. There\nare a few different ways of writing them, though, so we start with the simplest:\n\nA function with a name ending in `..._test()` is recognized by EUnit as a simple\ntest function - it takes no arguments, and its execution either succeeds\n(returning some arbitrary value that EUnit will throw away), or fails by\nthrowing an exception of some kind (or by not terminating, in which case it will\nbe aborted after a while).\n\nAn example of a simple test function could be the following:\n\n```text\n   reverse_test() -> lists:reverse([1,2,3]).\n```\n\nThis just tests that the function `lists:reverse(List)` does not crash when\n`List` is `[1,2,3]`. It is not a great test, but many people write simple\nfunctions like this one to test the basic functionality of their code, and those\ntests can be used directly by EUnit, without changes, as long as their function\nnames match.\n\n_Use exceptions to signal failure_{: #Use_exceptions_to_signal_failure } To\nwrite more interesting tests, we need to make them crash (throw an exception)\nwhen they don't get the result they expect. A simple way of doing this is to use\npattern matching with `=`, as in the following examples:\n\n```text\n   reverse_nil_test() -> [] = lists:reverse([]).\n   reverse_one_test() -> [1] = lists:reverse([1]).\n   reverse_two_test() -> [2,1] = lists:reverse([1,2]).\n```\n\nIf there was some bug in `lists:reverse/1` that made it return something other\nthan `[2,1]` when it got `[1,2]` as input, then the last test above would throw\na `badmatch` error. The first two (we assume they do not get a `badmatch`) would\nsimply return `[]` and `[1]`, respectively, so both succeed. (Note that EUnit is\nnot psychic: if you write a test that returns a value, even if it is the wrong\nvalue, EUnit will consider it a success. You must make sure that the test is\nwritten so that it causes a crash if the result is not what it should be.)\n\n_Using assert macros_{: #Using_assert_macros } If you want to use Boolean\noperators for your tests, the `assert` macro comes in handy (see\n[EUnit macros](chapter.md#EUnit_macros) for details):\n\n```text\n   length_test() -> ?assert(length([1,2,3]) =:= 3).\n```\n\nThe `?assert(Expression)` macro will evaluate `Expression`, and if that does not\nevaluate to `true`, it will throw an exception; otherwise it just returns `ok`.\nIn the above example, the test will thus fail if the call to `length` does not\nreturn 3.\n\n[](){: #Running_EUnit }","ref":"chapter.html#writing-simple-test-functions"},{"type":"extras","title":"Running EUnit - EUnit - a Lightweight Unit Testing Framework for Erlang","doc":"If you have added the declaration `-include_lib(\"eunit/include/eunit.hrl\")` to\nyour module, as described above, you only need to compile the module, and run\nthe automatically exported function `test()`. For example, if your module was\nnamed `m`, then calling `\\m:test()` will run EUnit on all the tests defined in\nthe module. You do not need to write `-export` declarations for the test\nfunctions. This is all done by magic.\n\nYou can also use the function `eunit:test/1` to run arbitrary tests, for example\nto try out some more advanced test descriptors (see\n[EUnit test representation](chapter.md#EUnit_test_representation)). For example,\nrunning `eunit:test(m)` does the same thing as the auto-generated function\n`\\m:test()`, while `eunit:test({inparallel, m})` runs the same test cases but\nexecutes them all in parallel.\n\n_Putting tests in separate modules_{: #Putting_tests_in_separate_modules }\n\nIf you want to separate your test code from your normal code (at least for\ntesting the exported functions), you can simply write the test functions in a\nmodule named `m_tests` (note: not `m_test`), if your module is named `m`. Then,\nwhenever you ask EUnit to test the module `m`, it will also look for the module\n`m_tests` and run those tests as well. See `ModuleName` in the section\n[Primitives](chapter.md#primitives) for details.\n\n_EUnit captures standard output_{: #EUnit_captures_standard_output }\n\nIf your test code writes to the standard output, you may be surprised to see\nthat the text does not appear on the console when the tests are running. This is\nbecause EUnit captures all standard output from test functions (this also\nincludes setup and cleanup functions, but not generator functions), so that it\ncan be included in the test report if errors occur. To bypass EUnit and print\ntext directly to the console while testing, you can write to the `user` output\nstream, as in `io:format(user, \"~w\", [Term])`. The recommended way of doing this\nis to use the EUnit [Debugging macros](chapter.md#Debugging_macros), which make\nit much simpler.\n\nFor checking the output produced by the unit under test, see\n[Macros for checking output](chapter.md#Macros_for_checking_output).\n\n[](){: #Writing_test_generating_functions }","ref":"chapter.html#running-eunit"},{"type":"extras","title":"Writing test generating functions - EUnit - a Lightweight Unit Testing Framework for Erlang","doc":"A drawback of simple test functions is that you must write a separate function\n(with a separate name) for each test case. A more compact way of writing tests\n(and much more flexible, as we shall see), is to write functions that _return_\ntests, instead of _being_ tests.\n\nA function with a name ending in `..._test_()` (note the final underscore) is\nrecognized by EUnit as a _test generator_ function. Test generators return a\n_representation_ of a _set of tests_ to be executed by EUnit.\n\n_Representing a test as data_{: #Representing_a_test_as_data } The most basic\nrepresentation of a test is a single fun-expression that takes no arguments. For\nexample, the following test generator:\n\n```text\n   basic_test_() ->\n       fun () -> ?assert(1 + 1 =:= 2) end.\n```\n\nwill have the same effect as the following simple test:\n\n```text\n   simple_test() ->\n       ?assert(1 + 1 =:= 2).\n```\n\n(in fact, EUnit will handle all simple tests just like it handles\nfun-expressions: it will put them in a list, and run them one by one).\n\n_Using macros to write tests_{: #Using_macros_to_write_tests } To make tests\nmore compact and readable, as well as automatically add information about the\nline number in the source code where a test occurred (and reduce the number of\ncharacters you have to type), you can use the `_test` macro (note the initial\nunderscore character), like this:\n\n```text\n   basic_test_() ->\n       ?_test(?assert(1 + 1 =:= 2)).\n```\n\nThe `_test` macro takes any expression (the \"body\") as argument, and places it\nwithin a fun-expression (along with some extra information). The body can be any\nkind of test expression, just like the body of a simple test function.\n\n_Underscore-prefixed macros create test objects_{:\n#Underscore-prefixed_macros_create_test_objects } But this example can be made\neven shorter\\! Most test macros, such as the family of `assert` macros, have a\ncorresponding form with an initial underscore character, which automatically\nadds a `?_test(...)` wrapper. The above example can then simply be written:\n\n```text\n   basic_test_() ->\n       ?_assert(1 + 1 =:= 2).\n```\n\nwhich has exactly the same meaning (note the `_assert` instead of `assert`). You\ncan think of the initial underscore as signalling _test object_.\n\n[](){: #An_example }","ref":"chapter.html#writing-test-generating-functions"},{"type":"extras","title":"An example - EUnit - a Lightweight Unit Testing Framework for Erlang","doc":"Sometimes, an example says more than a thousand words. The following small\nErlang module shows how EUnit can be used in practice.\n\n```text\n   -module(fib).\n   -export([fib/1]).\n   -include_lib(\"eunit/include/eunit.hrl\").\n\n   fib(0) -> 1;\n   fib(1) -> 1;\n   fib(N) when N > 1 -> fib(N-1) + fib(N-2).\n\n   fib_test_() ->\n       [?_assert(fib(0) =:= 1),\n\t?_assert(fib(1) =:= 1),\n\t?_assert(fib(2) =:= 2),\n\t?_assert(fib(3) =:= 3),\n\t?_assert(fib(4) =:= 5),\n\t?_assert(fib(5) =:= 8),\n\t?_assertException(error, function_clause, fib(-1)),\n\t?_assert(fib(31) =:= 2178309)\n       ].\n```\n\n(Author's note: When I first wrote this example, I happened to write a `*`\ninstead of `+` in the `fib` function. Of course, this showed up immediately when\nI ran the tests.)\n\nSee [EUnit test representation](chapter.md#EUnit_test_representation) for a full\nlist of all the ways you can specify test sets in EUnit.\n\n[](){: #Disabling_testing }","ref":"chapter.html#an-example"},{"type":"extras","title":"Disabling testing - EUnit - a Lightweight Unit Testing Framework for Erlang","doc":"Testing can be turned off by defining the `NOTEST` macro when compiling, for\nexample as an option to `erlc`, as in:\n\n```text\n   erlc -DNOTEST my_module.erl\n```\n\nor by adding a macro definition to the code, _before the EUnit header file is\nincluded_:\n\n```text\n   -define(NOTEST, 1).\n```\n\n(the value is not important, but should typically be 1 or `true`). Note that\nunless the `EUNIT_NOAUTO` macro is defined, disabling testing will also\nautomatically strip all test functions from the code, except for any that are\nexplicitly declared as exported.\n\nFor instance, to use EUnit in your application, but with testing turned off by\ndefault, put the following lines in a header file:\n\n```text\n   -define(NOTEST, true).\n   -include_lib(\"eunit/include/eunit.hrl\").\n```\n\nand then make sure that every module of your application includes that header\nfile. This means that you have a single place to modify in order to change the\ndefault setting for testing. To override the `NOTEST` setting without modifying\nthe code, you can define `TEST` in a compiler option, like this:\n\n```text\n   erlc -DTEST my_module.erl\n```\n\nSee [Compilation control macros](chapter.md#Compilation_control_macros) for\ndetails about these macros.\n\n[](){: #Avoiding_compile-time_dependency_on_EUnit }","ref":"chapter.html#disabling-testing"},{"type":"extras","title":"Avoiding compile-time dependency on EUnit - EUnit - a Lightweight Unit Testing Framework for Erlang","doc":"If you are distributing the source code for your application for other people to\ncompile and run, you probably want to ensure that the code compiles even if\nEUnit is not available. Like the example in the previous section, you can put\nthe following lines in a common header file:\n\n```text\n   -ifdef(TEST).\n   -include_lib(\"eunit/include/eunit.hrl\").\n   -endif.\n```\n\nand, of course, also make sure that you place all test code that uses EUnit\nmacros within `-ifdef(TEST)` or `-ifdef(EUNIT)` sections.\n\n[](){: #EUnit_macros }","ref":"chapter.html#avoiding-compile-time-dependency-on-eunit"},{"type":"extras","title":"EUnit macros - EUnit - a Lightweight Unit Testing Framework for Erlang","doc":"Although all the functionality of EUnit is available even without the use of\npreprocessor macros, the EUnit header file defines a number of such macros in\norder to make it as easy as possible to write unit tests as compactly as\npossible and without getting too many details in the way.\n\nExcept where explicitly stated, using EUnit macros will never introduce run-time\ndependencies on the EUnit library code, regardless of whether your code is\ncompiled with testing enabled or disabled.\n\n- [Basic macros](chapter.md#Basic_macros)\n- [Compilation control macros](chapter.md#Compilation_control_macros)\n- [Utility macros](chapter.md#Utility_macros)\n- [Assert macros](chapter.md#Assert_macros)\n- [Macros for checking output](chapter.md#Macros_for_checking_output)\n- [Macros for running external commands](chapter.md#Macros_for_running_external_commands)\n- [Debugging macros](chapter.md#Debugging_macros)\n\n[](){: #Basic_macros }","ref":"chapter.html#eunit-macros"},{"type":"extras","title":"Basic macros - EUnit - a Lightweight Unit Testing Framework for Erlang","doc":"- **`_test(Expr)`** - Turns `Expr` into a \"test object\", by wrapping it in a\n  fun-expression and a source line number. Technically, this is the same as\n  `{?LINE, fun () -> (Expr) end}`.\n\n[](){: #Compilation_control_macros }","ref":"chapter.html#basic-macros"},{"type":"extras","title":"Compilation control macros - EUnit - a Lightweight Unit Testing Framework for Erlang","doc":"- **`EUNIT`** - This macro is always defined to `true` whenever EUnit is enabled\n  at compile time. This is typically used to place testing code within\n  conditional compilation, as in:\n\n  ```text\n     -ifdef(EUNIT).\n         % test code here\n         ...\n     -endif.\n  ```\n\n  e.g., to ensure that the code can be compiled without including the EUnit\n  header file, when testing is disabled. See also the macros `TEST` and\n  `NOTEST`.\n\n- **`EUNIT_NOAUTO`** - If this macro is defined, the automatic exporting or\n  stripping of test functions will be disabled.\n\n- **`TEST`** - This macro is always defined (to `true`, unless previously\n  defined by the user to have another value) whenever EUnit is enabled at\n  compile time. This can be used to place testing code within conditional\n  compilation; see also the macros `NOTEST` and `EUNIT`.\n\n  For testing code that is strictly dependent on EUnit, it may be preferable to\n  use the `EUNIT` macro for this purpose, while for code that uses more generic\n  testing conventions, using the `TEST` macro may be preferred.\n\n  The `TEST` macro can also be used to override the `NOTEST` macro. If `TEST` is\n  defined _before_ the EUnit header file is included (even if `NOTEST` is also\n  defined), then the code will be compiled with EUnit enabled.\n\n- **`NOTEST`** - This macro is always defined (to `true`, unless previously\n  defined by the user to have another value) whenever EUnit is _disabled_ at\n  compile time. (Compare the `TEST` macro.)\n\n  This macro can also be used for conditional compilation, but is more typically\n  used to disable testing: If `NOTEST` is defined _before_ the EUnit header file\n  is included, and `TEST` is _not_ defined, then the code will be compiled with\n  EUnit disabled. See also [Disabling testing](chapter.md#Disabling_testing).\n\n- **`NOASSERT`** - If this macro is defined, the assert macros will have no\n  effect, when testing is also disabled. See\n  [Assert macros](chapter.md#Assert_macros). When testing is enabled, the assert\n  macros are always enabled automatically and cannot be disabled.\n\n- **`ASSERT`** - If this macro is defined, it overrides the NOASSERT macro,\n  forcing the assert macros to always be enabled regardless of other settings.\n\n- **`NODEBUG`** - If this macro is defined, the debugging macros will have no\n  effect. See [Debugging macros](chapter.md#Debugging_macros). `NODEBUG` also\n  implies `NOASSERT`, unless testing is enabled.\n\n- **`DEBUG`** - If this macro is defined, it overrides the NODEBUG macro,\n  forcing the debugging macros to be enabled.\n\n[](){: #Utility_macros }","ref":"chapter.html#compilation-control-macros"},{"type":"extras","title":"Utility macros - EUnit - a Lightweight Unit Testing Framework for Erlang","doc":"The following macros can make tests more compact and readable:\n\n- **`LET(Var,Arg,Expr)`** - Creates a local binding `Var = Arg` in `Expr`. (This\n  is the same as `(fun(Var)->(Expr)end)(Arg)`.) Note that the binding is not\n  exported outside of `Expr`, and that within `Expr`, this binding of `Var` will\n  shadow any binding of `Var` in the surrounding scope.\n\n- **`IF(Cond,TrueCase,FalseCase)`** - Evaluates `TrueCase` if `Cond` evaluates\n  to `true`, or otherwise evaluates `FalseCase` if `Cond` evaluates to `false`.\n  (This is the same as\n  `(case (Cond) of true->(TrueCase); false->(FalseCase) end)`.) Note that it is\n  an error if `Cond` does not yield a boolean value.\n\n[](){: #Assert_macros }","ref":"chapter.html#utility-macros"},{"type":"extras","title":"Assert macros - EUnit - a Lightweight Unit Testing Framework for Erlang","doc":"(Note that these macros also have corresponding forms which start with an \"`_`\"\n(underscore) character, as in `?_assert(BoolExpr)`, that create a \"test object\"\ninstead of performing the test immediately. This is equivalent to writing\n`?_test(assert(BoolExpr))`, etc.)\n\nIf the macro `NOASSERT` is defined before the EUnit header file is included,\nthese macros have no effect when testing is also disabled; see\n[Compilation control macros](chapter.md#Compilation_control_macros) for details.\n\n- **`assert(BoolExpr)`** - Evaluates the expression `BoolExpr`, if testing is\n  enabled. Unless the result is `true`, an informative exception will be\n  generated. If there is no exception, the result of the macro expression is the\n  atom `ok`, and the value of `BoolExpr` is discarded. If testing is disabled,\n  the macro will not generate any code except the atom `ok`, and `BoolExpr` will\n  not be evaluated.\n\n  Typical usage:\n\n  ```text\n     ?assert(f(X, Y) =:= [])\n  ```\n\n  The `assert` macro can be used anywhere in a program, not just in unit tests,\n  to check pre/postconditions and invariants. For example:\n\n  ```text\n     some_recursive_function(X, Y, Z) ->\n         ?assert(X + Y > Z),\n         ...\n  ```\n\n- **`assertNot(BoolExpr)`** - Equivalent to `assert(not (BoolExpr))`.\n\n- **`assertMatch(GuardedPattern, Expr)`** - Evaluates `Expr` and matches the\n  result against `GuardedPattern`, if testing is enabled. If the match fails, an\n  informative exception will be generated; see the `assert` macro for further\n  details. `GuardedPattern` can be anything that you can write on the left hand\n  side of the `->` symbol in a case-clause, except that it cannot contain\n  comma-separated guard tests.\n\n  The main reason for using `assertMatch` also for simple matches, instead of\n  matching with `=`, is that it produces more detailed error messages.\n\n  Examples:\n\n  ```text\n     ?assertMatch({found, {fred, _}}, lookup(bloggs, Table))\n  ```\n\n  ```text\n     ?assertMatch([X|_] when X > 0, binary_to_list(B))\n  ```\n\n- **`assertNotMatch(GuardedPattern, Expr)`** - The inverse case of assertMatch,\n  for convenience.\n\n- **`assertEqual(Expect, Expr)`** - Evaluates the expressions `Expect` and\n  `Expr` and compares the results for equality, if testing is enabled. If the\n  values are not equal, an informative exception will be generated; see the\n  `assert` macro for further details.\n\n  `assertEqual` is more suitable than `assertMatch` when the left-hand side is a\n  computed value rather than a simple pattern, and gives more details than\n  `?assert(Expect =:= Expr)`.\n\n  Examples:\n\n  ```text\n     ?assertEqual(\"b\" ++ \"a\", lists:reverse(\"ab\"))\n  ```\n\n  ```text\n     ?assertEqual(foo(X), bar(Y))\n  ```\n\n- **`assertNotEqual(Unexpected, Expr)`** - The inverse case of assertEqual, for\n  convenience.\n\n- **`assertException(ClassPattern, TermPattern, Expr)`**\n\n- **`assertError(TermPattern, Expr)`**\n\n- **`assertExit(TermPattern, Expr)`**\n\n- **`assertThrow(TermPattern, Expr)`** - Evaluates `Expr`, catching any\n  exception and testing that it matches the expected `ClassPattern:TermPattern`.\n  If the match fails, or if no exception is thrown by `Expr`, an informative\n  exception will be generated; see the `assert` macro for further details. The\n  `assertError`, `assertExit`, and `assertThrow` macros, are equivalent to using\n  `assertException` with a `ClassPattern` of `error`, `exit`, or `throw`,\n  respectively.\n\n  Examples:\n\n  ```text\n     ?assertError(badarith, X/0)\n  ```\n\n  ```text\n     ?assertExit(normal, exit(normal))\n  ```\n\n  ```text\n     ?assertException(throw, {not_found,_}, throw({not_found,42}))\n  ```\n\n[](){: #Macros_for_checking_output }","ref":"chapter.html#assert-macros"},{"type":"extras","title":"Macros for checking output - EUnit - a Lightweight Unit Testing Framework for Erlang","doc":"The following macro can be used within a test case to retrieve the output\nwritten to standard output.\n\n- **`capturedOutput`** - The output captured by EUnit in the current test case,\n  as a string.\n\n  Examples:\n\n  ```text\n     io:format(\"Hello~n\"),\n     ?assertEqual(\"Hello\\n\", ?capturedOutput)\n  ```\n\n[](){: #Macros_for_running_external_commands }","ref":"chapter.html#macros-for-checking-output"},{"type":"extras","title":"Macros for running external commands - EUnit - a Lightweight Unit Testing Framework for Erlang","doc":"Keep in mind that external commands are highly dependent on the operating\nsystem. You can use the standard library function `os:type()` in test generator\nfunctions, to produce different sets of tests depending on the current operating\nsystem.\n\nNote: these macros introduce a run-time dependency on the EUnit library code, if\ncompiled with testing enabled.\n\n- **`assertCmd(CommandString)`** - Runs `CommandString` as an external command,\n  if testing is enabled. Unless the returned status value is 0, an informative\n  exception will be generated. If there is no exception, the result of the macro\n  expression is the atom `ok`. If testing is disabled, the macro will not\n  generate any code except the atom `ok`, and the command will not be executed.\n\n  Typical usage:\n\n  ```text\n     ?assertCmd(\"mkdir foo\")\n  ```\n\n- **`assertCmdStatus(N, CommandString)`** - Like the `assertCmd(CommandString)`\n  macro, but generates an exception unless the returned status value is `N`.\n\n- **`assertCmdOutput(Text, CommandString)`** - Runs `CommandString` as an\n  external command, if testing is enabled. Unless the output produced by the\n  command exactly matches the specified string `Text`, an informative exception\n  will be generated. (Note that the output is normalized to use a single LF\n  character as line break on all platforms.) If there is no exception, the\n  result of the macro expression is the atom `ok`. If testing is disabled, the\n  macro will not generate any code except the atom `ok`, and the command will\n  not be executed.\n\n- **`cmd(CommandString)`** - Runs `CommandString` as an external command. Unless\n  the returned status value is 0 (indicating success), an informative exception\n  will be generated; otherwise, the result of the macro expression is the output\n  produced by the command, as a flat string. The output is normalized to use a\n  single LF character as line break on all platforms.\n\n  This macro is useful in the setup and cleanup sections of fixtures, e.g., for\n  creating and deleting files or perform similar operating system specific\n  tasks, to make sure that the test system is informed of any failures.\n\n  A Unix-specific example:\n\n  ```text\n     {setup,\n      fun () -> ?cmd(\"mktemp\") end,\n      fun (FileName) -> ?cmd(\"rm \" ++ FileName) end,\n      ...}\n  ```\n\n[](){: #Debugging_macros }","ref":"chapter.html#macros-for-running-external-commands"},{"type":"extras","title":"Debugging macros - EUnit - a Lightweight Unit Testing Framework for Erlang","doc":"To help with debugging, EUnit defines several useful macros for printing\nmessages directly to the console (rather than to the standard output).\nFurthermore, these macros all use the same basic format, which includes the file\nand line number where they occur, making it possible in some development\nenvironments (e.g., when running Erlang in an Emacs buffer) to simply click on\nthe message and jump directly to the corresponding line in the code.\n\nIf the macro `NODEBUG` is defined before the EUnit header file is included,\nthese macros have no effect; see\n[Compilation control macros](chapter.md#Compilation_control_macros) for details.\n\n- **`debugHere`** - Just prints a marker showing the current file and line\n  number. Note that this is an argument-less macro. The result is always `ok`.\n\n- **`debugMsg(Text)`** - Outputs the message `Text` (which can be a plain\n  string, an IO-list, or just an atom). The result is always `ok`.\n\n- **`debugFmt(FmtString, Args)`** - This formats the text like\n  `io:format(FmtString, Args)` and outputs it like `debugMsg`. The result is\n  always `ok`.\n\n- **`debugVal(Expr)`** - Prints both the source code for `Expr` and its current\n  value. E.g., `?debugVal(f(X))` might be displayed as \"`f(X) = 42`\". (Large\n  terms are truncated to the depth given by the macro `EUNIT_DEBUG_VAL_DEPTH`,\n  which defaults to 15 but can be overridden by the user.) The result is always\n  the value of `Expr`, so this macro can be wrapped around any expression to\n  display its value when the code is compiled with debugging enabled.\n\n- **`debugVal(Expr, Depth)`** - Like `debugVal(Expr)`, but prints terms\n  truncated to the given depth.\n\n- **`debugTime(Text,Expr)`** - Prints `Text` and the wall clock time for\n  evaluation of `Expr`. The result is always the value of `Expr`, so this macro\n  can be wrapped around any expression to show its run time when the code is\n  compiled with debugging enabled. For example,\n  `List1 = ?debugTime(\"sorting\", lists:sort(List))` might show as\n  \"`sorting: 0.015 s`\".\n\n[](){: #EUnit_test_representation }","ref":"chapter.html#debugging-macros"},{"type":"extras","title":"EUnit test representation - EUnit - a Lightweight Unit Testing Framework for Erlang","doc":"The way EUnit represents tests and test sets as data is flexible, powerful, and\nconcise. This section describes the representation in detail.\n\n- [Simple test objects](chapter.md#Simple_test_objects)\n- [Test sets and deep lists](chapter.md#Test_sets_and_deep_lists)\n- [Titles](chapter.md#titles)\n- [Primitives](chapter.md#primitives)\n- [Control](chapter.md#control)\n- [Fixtures](chapter.md#fixtures)\n- [Lazy generators](chapter.md#Lazy_generators)\n\n[](){: #Simple_test_objects }","ref":"chapter.html#eunit-test-representation"},{"type":"extras","title":"Simple test objects - EUnit - a Lightweight Unit Testing Framework for Erlang","doc":"A _simple test object_ is one of the following:\n\n- A nullary functional value (i.e., a fun that takes zero arguments). Examples:\n\n  ```text\n     fun () -> ... end\n  ```\n\n  ```text\n     fun some_function/0\n  ```\n\n  ```text\n     fun some_module:some_function/0\n  ```\n\n- A tuple `{test, ModuleName, FunctionName}`, where `ModuleName` and\n  `FunctionName` are atoms, referring to the function\n  `ModuleName:FunctionName/0`\n- (Obsolete) A pair of atoms `{ModuleName, FunctionName}`, equivalent to\n  `{test, ModuleName, FunctionName}` if nothing else matches first. This might\n  be removed in a future version.\n- A pair `{LineNumber, SimpleTest}`, where `LineNumber` is a nonnegative integer\n  and `SimpleTest` is another simple test object. `LineNumber` should indicate\n  the source line of the test. Pairs like this are usually only created via\n  `?_test(...)` macros; see [Basic macros](chapter.md#Basic_macros).\n\nIn brief, a simple test object consists of a single function that takes no\narguments (possibly annotated with some additional metadata, i.e., a line\nnumber). Evaluation of the function either _succeeds_, by returning some value\n(which is ignored), or _fails_, by throwing an exception.\n\n[](){: #Test_sets_and_deep_lists }","ref":"chapter.html#simple-test-objects"},{"type":"extras","title":"Test sets and deep lists - EUnit - a Lightweight Unit Testing Framework for Erlang","doc":"A test set can be easily created by placing a sequence of test objects in a\nlist. If `T_1`, ..., `T_N` are individual test objects, then `[T_1, ..., T_N]`\nis a test set consisting of those objects (in that order).\n\nTest sets can be joined in the same way: if `S_1`, ..., `S_K` are test sets,\nthen `[S_1, ..., S_K]` is also a test set, where the tests of `S_i` are ordered\nbefore those of `S_(i+1)`, for each subset `S_i`.\n\nThus, the main representation of test sets is _deep lists_, and a simple test\nobject can be viewed as a test set containing only a single test; there is no\ndifference between `T` and `[T]`.\n\nA module can also be used to represent a test set; see `ModuleName` under\n[Primitives](chapter.md#primitives) below.","ref":"chapter.html#test-sets-and-deep-lists"},{"type":"extras","title":"Titles - EUnit - a Lightweight Unit Testing Framework for Erlang","doc":"Any test or test set `T` can be annotated with a title, by wrapping it in a pair\n`{Title, T}`, where `Title` is a string. For convenience, any test which is\nnormally represented using a tuple can simply be given a title string as the\nfirst element, i.e., writing `{\"The Title\", ...}` instead of adding an extra\ntuple wrapper as in `{\"The Title\", {...}}`.","ref":"chapter.html#titles"},{"type":"extras","title":"Primitives - EUnit - a Lightweight Unit Testing Framework for Erlang","doc":"The following are primitives, which do not contain other test sets as arguments:\n\n- **`ModuleName::atom()`** - A single atom represents a module name, and is\n  equivalent to `{module, ModuleName}`. This is often used as in the call\n  `eunit:test(some_module)`.\n\n- **`{module, ModuleName::atom()}`** - This composes a test set from the\n  exported test functions of the named module, i.e., those functions with arity\n  zero whose names end with `_test` or `_test_`. Basically, the `..._test()`\n  functions become simple tests, while the `..._test_()` functions become\n  generators.\n\n  In addition, EUnit will also look for another module whose name is\n  `ModuleName` plus the suffix `_tests`, and if it exists, all the tests from\n  that module will also be added. (If `ModuleName` already contains the suffix\n  `_tests`, this is not done.) E.g., the specification `{module, mymodule}` will\n  run all tests in the modules `mymodule` and `mymodule_tests`. Typically, the\n  `_tests` module should only contain test cases that use the public interface\n  of the main module (and no other code).\n\n- **`{application, AppName::atom(), Info::list()}`** - This is a normal\n  Erlang/OTP application descriptor, as found in an `.app` file. The resulting\n  test set consists of the modules listed in the `modules` entry in `Info`.\n\n- **`{application, AppName::atom()}`** - This creates a test set from all the\n  modules belonging to the specified application, by consulting the\n  application's `.app` file (see `{file, FileName}`), or if no such file exists,\n  by testing all object files in the application's `ebin`\\-directory (see\n  `{dir, Path}`); if that does not exist, the `code:lib_dir(AppName)` directory\n  is used.\n\n- **`Path::string()`** - A single string represents the path of a file or\n  directory, and is equivalent to `{file, Path}`, or `{dir, Path}`,\n  respectively, depending on what `Path` refers to in the file system.\n\n- **`{file, FileName::string()}`** - If `FileName` has a suffix that indicates\n  an object file (`.beam`), EUnit will try to reload the module from the\n  specified file and test it. Otherwise, the file is assumed to be a text file\n  containing test specifications, which will be read using the standard library\n  function `file:path_consult/2`.\n\n  Unless the file name is absolute, the file is first searched for relative to\n  the current directory, and then using the normal search path\n  (`code:get_path()`). This means that the names of typical \"app\" files can be\n  used directly, without a path, e.g., `\"mnesia.app\"`.\n\n- **`{dir, Path::string()}`** - This tests all object files in the specified\n  directory, as if they had been individually specified using\n  `{file, FileName}`.\n\n- **`{generator, GenFun::(() -> Tests)}`** - The generator function `GenFun` is\n  called to produce a test set.\n\n- **`{generator, ModuleName::atom(), FunctionName::atom()}`** - The function\n  `ModuleName:FunctionName()` is called to produce a test set.\n\n- **`{with, X::any(), [AbstractTestFun::((any()) -> any())]}`** - Distributes\n  the value `X` over the unary functions in the list, turning them into nullary\n  test functions. An `AbstractTestFun` is like an ordinary test fun, but takes\n  one argument instead of zero - it's basically missing some information before\n  it can be a proper test. In practice, `{with, X, [F_1, ..., F_N]}` is\n  equivalent to `[fun () -> F_1(X) end, ..., fun () -> F_N(X) end]`. This is\n  particularly useful if your abstract test functions are already implemented as\n  proper functions:\n  `{with, FD, [fun filetest_a/1, fun filetest_b/1, fun filetest_c/1]}` is\n  equivalent to\n  `[fun () -> filetest_a(FD) end, fun () -> filetest_b(FD) end, fun () -> filetest_c(FD) end]`,\n  but much more compact. See also [Fixtures](chapter.md#fixtures), below.","ref":"chapter.html#primitives"},{"type":"extras","title":"Control - EUnit - a Lightweight Unit Testing Framework for Erlang","doc":"The following representations control how and where tests are executed:\n\n- **`{spawn, Tests}`** - Runs the specified tests in a separate subprocess,\n  while the current test process waits for it to finish. This is useful for\n  tests that need a fresh, isolated process state. (Note that EUnit always\n  starts at least one such a subprocess automatically; tests are never executed\n  by the caller's own process.)\n\n- **`{spawn, Node::atom(), Tests}`** - Like `{spawn, Tests}`, but runs the\n  specified tests on the given Erlang node.\n\n- **`{timeout, Time::number(), Tests}`** - Runs the specified tests under the\n  given timeout. Time is in seconds; e.g., 60 means one minute and 0.1 means\n  1/10th of a second. If the timeout is exceeded, the unfinished tests will be\n  forced to terminate. Note that if a timeout is set around a fixture, it\n  includes the time for setup and cleanup, and if the timeout is triggered, the\n  entire fixture is abruptly terminated (without running the cleanup). The\n  default timeout for an individual test is 5 seconds.\n\n- **`{inorder, Tests}`** - Runs the specified tests in strict order. Also see\n  `{inparallel, Tests}`. By default, tests are neither marked as `inorder` or\n  `inparallel`, but may be executed as the test framework chooses.\n\n- **`{inparallel, Tests}`** - Runs the specified tests in parallel (if\n  possible). Also see `{inorder, Tests}`.\n\n- **`{inparallel, N::integer(), Tests}`** - Like `{inparallel, Tests}`, but\n  running no more than `N` subtests simultaneously.","ref":"chapter.html#control"},{"type":"extras","title":"Fixtures - EUnit - a Lightweight Unit Testing Framework for Erlang","doc":"A \"fixture\" is some state that is necessary for a particular set of tests to\nrun. EUnit's support for fixtures makes it easy to set up such state locally for\na test set, and automatically tear it down again when the test set is finished,\nregardless of the outcome (success, failures, timeouts, etc.).\n\nTo make the descriptions simpler, we first list some definitions:\n\n| `Setup`        | `() -> (R::any())`              |\n| -------------- | ------------------------------- | ---------------------------------------------- | ---------------------- |\n| `SetupX`       | `(X::any()) -> (R::any())`      |\n| `Cleanup`      | `(R::any()) -> any()`           |\n| `CleanupX`     | `(X::any(), R::any()) -> any()` |\n| `Instantiator` | `((R::any()) -> Tests)          | {with, [AbstractTestFun::((any()) -> any())]}` |\n| `Where`        | `local                          | spawn                                          | {spawn, Node::atom()}` |\n\n(these are explained in more detail further below.)\n\nThe following representations specify fixture handling for test sets:\n\n- **`{setup, Setup, Tests | Instantiator}`**\n\n- **`{setup, Setup, Cleanup, Tests | Instantiator}`**\n\n- **`{setup, Where, Setup, Tests | Instantiator}`**\n\n- **`{setup, Where, Setup, Cleanup, Tests | Instantiator}`** - `setup` sets up a\n  single fixture for running all of the specified tests, with optional teardown\n  afterwards. The arguments are described in detail below.\n\n- **`{node, Node::atom(), Tests | Instantiator}`**\n\n- **`{node, Node::atom(), Args::string(), Tests | Instantiator}`** - `node` is\n  like `setup`, but with a built-in behaviour: it starts a slave node for the\n  duration of the tests. The atom `Node` should have the format\n  `nodename@full.machine.name`, and `Args` are the optional arguments to the new\n  node; see `slave:start_link/3` for details.\n\n- **`{foreach, Where, Setup, Cleanup, [Tests | Instantiator]}`**\n\n- **`{foreach, Setup, Cleanup, [Tests | Instantiator]}`**\n\n- **`{foreach, Where, Setup, [Tests | Instantiator]}`**\n\n- **`{foreach, Setup, [Tests | Instantiator]}`** - `foreach` is used to set up a\n  fixture and optionally tear it down afterwards, repeated for each single one\n  of the specified test sets.\n\n- **`{foreachx, Where, SetupX, CleanupX, Pairs::[{X::any(), ((X::any(), R::any()) -> Tests)}]}`**\n\n- **`{foreachx, SetupX, CleanupX, Pairs}`**\n\n- **`{foreachx, Where, SetupX, Pairs}`**\n\n- **`{foreachx, SetupX, Pairs}`** - `foreachx` is like `foreach`, but uses a\n  list of pairs, each containing an extra argument `X` and an extended\n  instantiator function.\n\nA `Setup` function is executed just before any of the specified tests are run,\nand a `Cleanup` function is executed when no more of the specified tests will be\nrun, regardless of the reason. A `Setup` function takes no argument, and returns\nsome value which will be passed as it is to the `Cleanup` function. A `Cleanup`\nfunction should do whatever necessary and return some arbitrary value, such as\nthe atom `ok`. (`SetupX` and `CleanupX` functions are similar, but receive one\nadditional argument: some value `X`, which depends on the context.) When no\n`Cleanup` function is specified, a dummy function is used which has no effect.\n\nAn `Instantiator` function receives the same value as the `Cleanup` function,\ni.e., the value returned by the `Setup` function. It should then behave much\nlike a generator (see [Primitives](chapter.md#primitives)), and return a test\nset whose tests have been _instantiated_ with the given value. A special case is\nthe syntax `{with, [AbstractTestFun]}` which represents an instantiator function\nthat distributes the value over a list of unary functions; see\n[Primitives](chapter.md#primitives): `{with, X, [...]}` for more details.\n\nA `Where` term controls how the specified tests are executed. The default is\n`spawn`, which means that the current process handles the setup and teardown,\nwhile the tests are executed in a subprocess. `{spawn, Node}` is like `spawn`,\nbut runs the subprocess on the specified node. `local` means that the current\nprocess will handle both setup/teardown and running the tests - the drawback is\nthat if a test times out so that the process is killed, the _cleanup will not be\nperformed_; hence, avoid this for persistent fixtures such as file operations.\nIn general, `local` should only be used when:\n\n- the setup/teardown needs to be executed by the process that will run the\n  tests;\n- no further teardown needs to be done if the process is killed (i.e., no state\n  outside the process was affected by the setup)\n\n[](){: #Lazy_generators }","ref":"chapter.html#fixtures"},{"type":"extras","title":"Lazy generators - EUnit - a Lightweight Unit Testing Framework for Erlang","doc":"Sometimes, it can be convenient not to produce the whole set of test\ndescriptions before the testing begins; for example, if you want to generate a\nhuge amount of tests that would take up too much space to keep in memory all at\nonce.\n\nIt is fairly easy to write a generator which, each time it is called, either\nproduces an empty list if it is done, or otherwise produces a list containing a\nsingle test case plus a new generator which will produce the rest of the tests.\nThis demonstrates the basic pattern:\n\n```text\n   lazy_test_() ->\n       lazy_gen(10000).\n\n   lazy_gen(N) ->\n       {generator,\n        fun () ->\n            if N > 0 ->\n                   [?_test(...)\n                    | lazy_gen(N-1)];\n               true ->\n                   []\n            end\n        end}.\n```\n\nWhen EUnit traverses the test representation in order to run the tests, the new\ngenerator will not be called to produce the next test until the previous test\nhas been executed.\n\nNote that it is easiest to write this kind of recursive generator using a help\nfunction, like the `lazy_gen/1` function above. It can also be written using a\nrecursive fun, if you prefer to not clutter your function namespace and are\ncomfortable with writing that kind of code.","ref":"chapter.html#lazy-generators"}],"proglang":"erlang","content_type":"text/markdown","producer":{"name":"ex_doc","version":"0.37.0-rc.2"}}