package reid

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBaseStatistics invokes the reid.DescribeBaseStatistics API synchronously
// api document: https://help.aliyun.com/api/reid/describebasestatistics.html
func (client *Client) DescribeBaseStatistics(request *DescribeBaseStatisticsRequest) (response *DescribeBaseStatisticsResponse, err error) {
	response = CreateDescribeBaseStatisticsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBaseStatisticsWithChan invokes the reid.DescribeBaseStatistics API asynchronously
// api document: https://help.aliyun.com/api/reid/describebasestatistics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeBaseStatisticsWithChan(request *DescribeBaseStatisticsRequest) (<-chan *DescribeBaseStatisticsResponse, <-chan error) {
	responseChan := make(chan *DescribeBaseStatisticsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBaseStatistics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBaseStatisticsWithCallback invokes the reid.DescribeBaseStatistics API asynchronously
// api document: https://help.aliyun.com/api/reid/describebasestatistics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeBaseStatisticsWithCallback(request *DescribeBaseStatisticsRequest, callback func(response *DescribeBaseStatisticsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBaseStatisticsResponse
		var err error
		defer close(result)
		response, err = client.DescribeBaseStatistics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBaseStatisticsRequest is the request struct for api DescribeBaseStatistics
type DescribeBaseStatisticsRequest struct {
	*requests.RpcRequest
	Date                string           `position:"Body" name:"Date"`
	ExtraStatisticTypes string           `position:"Body" name:"ExtraStatisticTypes"`
	StoreId             requests.Integer `position:"Body" name:"StoreId"`
	SummaryType         string           `position:"Body" name:"SummaryType"`
	LocationId          requests.Integer `position:"Body" name:"LocationId"`
}

// DescribeBaseStatisticsResponse is the response struct for api DescribeBaseStatistics
type DescribeBaseStatisticsResponse struct {
	*responses.BaseResponse
	ErrorCode      string         `json:"ErrorCode" xml:"ErrorCode"`
	CursorTime     string         `json:"CursorTime" xml:"CursorTime"`
	ErrorMessage   string         `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	Success        bool           `json:"Success" xml:"Success"`
	BaseStatistics BaseStatistics `json:"BaseStatistics" xml:"BaseStatistics"`
}

// CreateDescribeBaseStatisticsRequest creates a request to invoke DescribeBaseStatistics API
func CreateDescribeBaseStatisticsRequest() (request *DescribeBaseStatisticsRequest) {
	request = &DescribeBaseStatisticsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("reid", "2019-09-28", "DescribeBaseStatistics", "1.1.8.2", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeBaseStatisticsResponse creates a response to parse from DescribeBaseStatistics response
func CreateDescribeBaseStatisticsResponse() (response *DescribeBaseStatisticsResponse) {
	response = &DescribeBaseStatisticsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
