package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SelectGatewaySlb invokes the mse.SelectGatewaySlb API synchronously
func (client *Client) SelectGatewaySlb(request *SelectGatewaySlbRequest) (response *SelectGatewaySlbResponse, err error) {
	response = CreateSelectGatewaySlbResponse()
	err = client.DoAction(request, response)
	return
}

// SelectGatewaySlbWithChan invokes the mse.SelectGatewaySlb API asynchronously
func (client *Client) SelectGatewaySlbWithChan(request *SelectGatewaySlbRequest) (<-chan *SelectGatewaySlbResponse, <-chan error) {
	responseChan := make(chan *SelectGatewaySlbResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SelectGatewaySlb(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SelectGatewaySlbWithCallback invokes the mse.SelectGatewaySlb API asynchronously
func (client *Client) SelectGatewaySlbWithCallback(request *SelectGatewaySlbRequest, callback func(response *SelectGatewaySlbResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SelectGatewaySlbResponse
		var err error
		defer close(result)
		response, err = client.SelectGatewaySlb(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SelectGatewaySlbRequest is the request struct for api SelectGatewaySlb
type SelectGatewaySlbRequest struct {
	*requests.RpcRequest
	GatewayUniqueId string `position:"Query" name:"GatewayUniqueId"`
	Type            string `position:"Query" name:"Type"`
	Name            string `position:"Query" name:"Name"`
	AcceptLanguage  string `position:"Query" name:"AcceptLanguage"`
}

// SelectGatewaySlbResponse is the response struct for api SelectGatewaySlb
type SelectGatewaySlbResponse struct {
	*responses.BaseResponse
	RequestId      string    `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int       `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string    `json:"Message" xml:"Message"`
	Code           int       `json:"Code" xml:"Code"`
	Success        bool      `json:"Success" xml:"Success"`
	Data           []Sources `json:"Data" xml:"Data"`
}

// CreateSelectGatewaySlbRequest creates a request to invoke SelectGatewaySlb API
func CreateSelectGatewaySlbRequest() (request *SelectGatewaySlbRequest) {
	request = &SelectGatewaySlbRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "SelectGatewaySlb", "", "")
	request.Method = requests.GET
	return
}

// CreateSelectGatewaySlbResponse creates a response to parse from SelectGatewaySlb response
func CreateSelectGatewaySlbResponse() (response *SelectGatewaySlbResponse) {
	response = &SelectGatewaySlbResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
