package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CompleteBoardRecord invokes the live.CompleteBoardRecord API synchronously
func (client *Client) CompleteBoardRecord(request *CompleteBoardRecordRequest) (response *CompleteBoardRecordResponse, err error) {
	response = CreateCompleteBoardRecordResponse()
	err = client.DoAction(request, response)
	return
}

// CompleteBoardRecordWithChan invokes the live.CompleteBoardRecord API asynchronously
func (client *Client) CompleteBoardRecordWithChan(request *CompleteBoardRecordRequest) (<-chan *CompleteBoardRecordResponse, <-chan error) {
	responseChan := make(chan *CompleteBoardRecordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CompleteBoardRecord(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CompleteBoardRecordWithCallback invokes the live.CompleteBoardRecord API asynchronously
func (client *Client) CompleteBoardRecordWithCallback(request *CompleteBoardRecordRequest, callback func(response *CompleteBoardRecordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CompleteBoardRecordResponse
		var err error
		defer close(result)
		response, err = client.CompleteBoardRecord(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CompleteBoardRecordRequest is the request struct for api CompleteBoardRecord
type CompleteBoardRecordRequest struct {
	*requests.RpcRequest
	EndTime  string           `position:"Query" name:"EndTime"`
	OwnerId  requests.Integer `position:"Query" name:"OwnerId"`
	RecordId string           `position:"Query" name:"RecordId"`
	AppId    string           `position:"Query" name:"AppId"`
}

// CompleteBoardRecordResponse is the response struct for api CompleteBoardRecord
type CompleteBoardRecordResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	OssPath   string `json:"OssPath" xml:"OssPath"`
}

// CreateCompleteBoardRecordRequest creates a request to invoke CompleteBoardRecord API
func CreateCompleteBoardRecordRequest() (request *CompleteBoardRecordRequest) {
	request = &CompleteBoardRecordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "CompleteBoardRecord", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCompleteBoardRecordResponse creates a response to parse from CompleteBoardRecord response
func CreateCompleteBoardRecordResponse() (response *CompleteBoardRecordResponse) {
	response = &CompleteBoardRecordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
