package dyplsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InitFaceVerify invokes the dyplsapi.InitFaceVerify API synchronously
func (client *Client) InitFaceVerify(request *InitFaceVerifyRequest) (response *InitFaceVerifyResponse, err error) {
	response = CreateInitFaceVerifyResponse()
	err = client.DoAction(request, response)
	return
}

// InitFaceVerifyWithChan invokes the dyplsapi.InitFaceVerify API asynchronously
func (client *Client) InitFaceVerifyWithChan(request *InitFaceVerifyRequest) (<-chan *InitFaceVerifyResponse, <-chan error) {
	responseChan := make(chan *InitFaceVerifyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InitFaceVerify(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InitFaceVerifyWithCallback invokes the dyplsapi.InitFaceVerify API asynchronously
func (client *Client) InitFaceVerifyWithCallback(request *InitFaceVerifyRequest, callback func(response *InitFaceVerifyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InitFaceVerifyResponse
		var err error
		defer close(result)
		response, err = client.InitFaceVerify(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InitFaceVerifyRequest is the request struct for api InitFaceVerify
type InitFaceVerifyRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	MetaInfo             string           `position:"Query" name:"MetaInfo"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ProdCode             string           `position:"Query" name:"ProdCode"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// InitFaceVerifyResponse is the response struct for api InitFaceVerify
type InitFaceVerifyResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateInitFaceVerifyRequest creates a request to invoke InitFaceVerify API
func CreateInitFaceVerifyRequest() (request *InitFaceVerifyRequest) {
	request = &InitFaceVerifyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyplsapi", "2017-05-25", "InitFaceVerify", "", "")
	request.Method = requests.POST
	return
}

// CreateInitFaceVerifyResponse creates a response to parse from InitFaceVerify response
func CreateInitFaceVerifyResponse() (response *InitFaceVerifyResponse) {
	response = &InitFaceVerifyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
