package amqp_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListBindings invokes the amqp_open.ListBindings API synchronously
// api document: https://help.aliyun.com/api/amqp-open/listbindings.html
func (client *Client) ListBindings(request *ListBindingsRequest) (response *ListBindingsResponse, err error) {
	response = CreateListBindingsResponse()
	err = client.DoAction(request, response)
	return
}

// ListBindingsWithChan invokes the amqp_open.ListBindings API asynchronously
// api document: https://help.aliyun.com/api/amqp-open/listbindings.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListBindingsWithChan(request *ListBindingsRequest) (<-chan *ListBindingsResponse, <-chan error) {
	responseChan := make(chan *ListBindingsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListBindings(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListBindingsWithCallback invokes the amqp_open.ListBindings API asynchronously
// api document: https://help.aliyun.com/api/amqp-open/listbindings.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListBindingsWithCallback(request *ListBindingsRequest, callback func(response *ListBindingsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListBindingsResponse
		var err error
		defer close(result)
		response, err = client.ListBindings(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListBindingsRequest is the request struct for api ListBindings
type ListBindingsRequest struct {
	*requests.RpcRequest
	InstanceId  string           `position:"Query" name:"InstanceId"`
	NextToken   string           `position:"Query" name:"NextToken"`
	MaxResults  requests.Integer `position:"Query" name:"MaxResults"`
	VirtualHost string           `position:"Query" name:"VirtualHost"`
}

// ListBindingsResponse is the response struct for api ListBindings
type ListBindingsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListBindingsRequest creates a request to invoke ListBindings API
func CreateListBindingsRequest() (request *ListBindingsRequest) {
	request = &ListBindingsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("amqp-open", "2019-12-12", "ListBindings", "onsproxy", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListBindingsResponse creates a response to parse from ListBindings response
func CreateListBindingsResponse() (response *ListBindingsResponse) {
	response = &ListBindingsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
