/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.loader;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.FetchMode;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.engine.RowSelection;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.engine.TypedValue;
import net.sf.hibernate.expression.Expression;
import net.sf.hibernate.expression.Order;
import net.sf.hibernate.impl.CriteriaImpl;
import net.sf.hibernate.loader.AbstractEntityLoader;
import net.sf.hibernate.persister.Loadable;
import net.sf.hibernate.type.Type;

public class CriteriaLoader
extends AbstractEntityLoader {
    private CriteriaImpl criteria;
    private static final Type[] NO_TYPES = new Type[0];

    public CriteriaLoader(Loadable persister, SessionFactoryImplementor factory, CriteriaImpl criteria) throws HibernateException {
        super(persister, factory);
        this.criteria = criteria;
        StringBuffer condition = new StringBuffer(30);
        Iterator iter = criteria.iterateExpressions();
        if (!iter.hasNext()) {
            condition.append("1=1");
        }
        while (iter.hasNext()) {
            Expression expr = (Expression)iter.next();
            condition.append(expr.toSqlString(factory, criteria.getPersistentClass(), this.alias));
            if (!iter.hasNext()) continue;
            condition.append(" and ");
        }
        StringBuffer orderBy = new StringBuffer(30);
        iter = criteria.iterateOrderings();
        while (iter.hasNext()) {
            Order ord = (Order)iter.next();
            orderBy.append(ord.toSqlString(factory, criteria.getPersistentClass(), this.alias));
            if (!iter.hasNext()) continue;
            orderBy.append(", ");
        }
        this.renderStatement(condition.toString(), orderBy.toString(), factory);
        this.postInstantiate();
    }

    public List list(SessionImplementor session) throws HibernateException, SQLException {
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<Type> types = new ArrayList<Type>();
        Iterator iter = this.criteria.iterateExpressions();
        while (iter.hasNext()) {
            Expression expr = (Expression)iter.next();
            TypedValue[] tv = expr.getTypedValues(session.getFactory(), this.criteria.getPersistentClass());
            int i = 0;
            while (i < tv.length) {
                values.add(tv[i].getValue());
                types.add(tv[i].getType());
                ++i;
            }
        }
        Object[] valueArray = values.toArray();
        Type[] typeArray = types.toArray(NO_TYPES);
        RowSelection selection = new RowSelection();
        selection.setFirstRow(this.criteria.getFirstResult());
        selection.setMaxRows(this.criteria.getMaxResults());
        selection.setTimeout(this.criteria.getTimeout());
        return this.find(session, valueArray, typeArray, true, selection, null, null);
    }

    protected Object getResultColumnOrRow(Object[] row, ResultSet rs, SessionImplementor session) throws SQLException, HibernateException {
        return row[row.length - 1];
    }

    public String[] toColumns(String pathExpression) {
        return null;
    }

    protected boolean enableJoinedFetch(boolean mappingDefault, String path, String table, String[] foreignKeyColumns) {
        FetchMode fm = this.criteria.getFetchMode(path);
        if (fm == null || fm == FetchMode.DEFAULT) {
            return mappingDefault;
        }
        return fm == FetchMode.EAGER;
    }
}

