// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// All possible error types for this service.
#[non_exhaustive]
#[derive(::std::fmt::Debug)]
pub enum Error {
    /// <p>Indicates that a problem occurred with the input to the request. For example, a required parameter might be missing or out of range.</p>
    InvalidRequestException(crate::types::error::InvalidRequestException),
    /// <p>The specified resource doesn't exist.</p>
    ResourceNotFoundException(crate::types::error::ResourceNotFoundException),
    /// <p>Indicates that the request is being made too frequently and is more than what the server can handle.</p>
    TooManyRequestsException(crate::types::error::TooManyRequestsException),
    /// <p>Indicates that the request is not authorized. This can happen due to an invalid access token in the request.</p>
    UnauthorizedException(crate::types::error::UnauthorizedException),
    /// An unexpected error occurred (e.g., invalid JSON returned by the service or an unknown error code).
    #[deprecated(note = "Matching `Unhandled` directly is not forwards compatible. Instead, match using a \
    variable wildcard pattern and check `.code()`:
     \
    &nbsp;&nbsp;&nbsp;`err if err.code() == Some(\"SpecificExceptionCode\") => { /* handle the error */ }`
     \
    See [`ProvideErrorMetadata`](#impl-ProvideErrorMetadata-for-Error) for what information is available for the error.")]
    Unhandled(crate::error::sealed_unhandled::Unhandled),
}
impl ::std::fmt::Display for Error {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        match self {
            Error::InvalidRequestException(inner) => inner.fmt(f),
            Error::ResourceNotFoundException(inner) => inner.fmt(f),
            Error::TooManyRequestsException(inner) => inner.fmt(f),
            Error::UnauthorizedException(inner) => inner.fmt(f),
            Error::Unhandled(_) => {
                if let ::std::option::Option::Some(code) = ::aws_smithy_types::error::metadata::ProvideErrorMetadata::code(self) {
                    write!(f, "unhandled error ({code})")
                } else {
                    f.write_str("unhandled error")
                }
            }
        }
    }
}
impl From<::aws_smithy_types::error::operation::BuildError> for Error {
    fn from(value: ::aws_smithy_types::error::operation::BuildError) -> Self {
        Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
            source: value.into(),
            meta: ::std::default::Default::default(),
        })
    }
}
impl ::aws_smithy_types::error::metadata::ProvideErrorMetadata for Error {
    fn meta(&self) -> &::aws_smithy_types::error::metadata::ErrorMetadata {
        match self {
            Self::InvalidRequestException(inner) => inner.meta(),
            Self::ResourceNotFoundException(inner) => inner.meta(),
            Self::TooManyRequestsException(inner) => inner.meta(),
            Self::UnauthorizedException(inner) => inner.meta(),
            Self::Unhandled(inner) => &inner.meta,
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_role_credentials::GetRoleCredentialsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::get_role_credentials::GetRoleCredentialsError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::get_role_credentials::GetRoleCredentialsError> for Error {
    fn from(err: crate::operation::get_role_credentials::GetRoleCredentialsError) -> Self {
        match err {
            crate::operation::get_role_credentials::GetRoleCredentialsError::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
            crate::operation::get_role_credentials::GetRoleCredentialsError::ResourceNotFoundException(inner) => {
                Error::ResourceNotFoundException(inner)
            }
            crate::operation::get_role_credentials::GetRoleCredentialsError::TooManyRequestsException(inner) => {
                Error::TooManyRequestsException(inner)
            }
            crate::operation::get_role_credentials::GetRoleCredentialsError::UnauthorizedException(inner) => Error::UnauthorizedException(inner),
            crate::operation::get_role_credentials::GetRoleCredentialsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_account_roles::ListAccountRolesError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_account_roles::ListAccountRolesError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_account_roles::ListAccountRolesError> for Error {
    fn from(err: crate::operation::list_account_roles::ListAccountRolesError) -> Self {
        match err {
            crate::operation::list_account_roles::ListAccountRolesError::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
            crate::operation::list_account_roles::ListAccountRolesError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::list_account_roles::ListAccountRolesError::TooManyRequestsException(inner) => Error::TooManyRequestsException(inner),
            crate::operation::list_account_roles::ListAccountRolesError::UnauthorizedException(inner) => Error::UnauthorizedException(inner),
            crate::operation::list_account_roles::ListAccountRolesError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_accounts::ListAccountsError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::list_accounts::ListAccountsError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::list_accounts::ListAccountsError> for Error {
    fn from(err: crate::operation::list_accounts::ListAccountsError) -> Self {
        match err {
            crate::operation::list_accounts::ListAccountsError::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
            crate::operation::list_accounts::ListAccountsError::ResourceNotFoundException(inner) => Error::ResourceNotFoundException(inner),
            crate::operation::list_accounts::ListAccountsError::TooManyRequestsException(inner) => Error::TooManyRequestsException(inner),
            crate::operation::list_accounts::ListAccountsError::UnauthorizedException(inner) => Error::UnauthorizedException(inner),
            crate::operation::list_accounts::ListAccountsError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl<R> From<::aws_smithy_runtime_api::client::result::SdkError<crate::operation::logout::LogoutError, R>> for Error
where
    R: Send + Sync + std::fmt::Debug + 'static,
{
    fn from(err: ::aws_smithy_runtime_api::client::result::SdkError<crate::operation::logout::LogoutError, R>) -> Self {
        match err {
            ::aws_smithy_runtime_api::client::result::SdkError::ServiceError(context) => Self::from(context.into_err()),
            _ => Error::Unhandled(crate::error::sealed_unhandled::Unhandled {
                meta: ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(&err).clone(),
                source: err.into(),
            }),
        }
    }
}
impl From<crate::operation::logout::LogoutError> for Error {
    fn from(err: crate::operation::logout::LogoutError) -> Self {
        match err {
            crate::operation::logout::LogoutError::InvalidRequestException(inner) => Error::InvalidRequestException(inner),
            crate::operation::logout::LogoutError::TooManyRequestsException(inner) => Error::TooManyRequestsException(inner),
            crate::operation::logout::LogoutError::UnauthorizedException(inner) => Error::UnauthorizedException(inner),
            crate::operation::logout::LogoutError::Unhandled(inner) => Error::Unhandled(inner),
        }
    }
}
impl ::std::error::Error for Error {
    fn source(&self) -> std::option::Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            Error::InvalidRequestException(inner) => inner.source(),
            Error::ResourceNotFoundException(inner) => inner.source(),
            Error::TooManyRequestsException(inner) => inner.source(),
            Error::UnauthorizedException(inner) => inner.source(),
            Error::Unhandled(inner) => ::std::option::Option::Some(&*inner.source),
        }
    }
}
impl ::aws_types::request_id::RequestId for Error {
    fn request_id(&self) -> Option<&str> {
        match self {
            Self::InvalidRequestException(e) => e.request_id(),
            Self::ResourceNotFoundException(e) => e.request_id(),
            Self::TooManyRequestsException(e) => e.request_id(),
            Self::UnauthorizedException(e) => e.request_id(),
            Self::Unhandled(e) => e.meta.request_id(),
        }
    }
}
