/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.jvm.java.metrics.linesOfCode;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.jvm.java.metrics.PsiKt;
import org.jetbrains.qodana.jvm.java.metrics.linesOfCode.JvmLinesOfCodeInspection;
import org.jetbrains.qodana.jvm.java.metrics.linesOfCode.LocWhitespaceVisitor;
import org.jetbrains.qodana.staticAnalysis.inspections.metrics.MetricFileData;
import org.jetbrains.qodana.staticAnalysis.inspections.metrics.database.rowData.LinesOfCodeMetricTableRowData;
import org.jetbrains.qodana.staticAnalysis.inspections.metrics.database.rowData.MetricTableRowData;
import org.jetbrains.qodana.staticAnalysis.inspections.metrics.database.tables.MetricTable;
import org.jetbrains.qodana.staticAnalysis.inspections.metrics.problemDescriptors.MetricCodeDescriptor;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/qodana/jvm/java/metrics/linesOfCode/JvmLinesOfCodeInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "intellij.qodana.jvm.java"})
public final class JvmLinesOfCodeInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return new PsiElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitFile(PsiFile psiFile2) {
                Intrinsics.checkNotNullParameter((Object)psiFile2, (String)"psiFile");
                Document document = PsiDocumentManager.getInstance((Project)psiFile2.getProject()).getDocument(psiFile2);
                if (document == null) {
                    return;
                }
                int numberOfLinesInDocument = document.getLineCount();
                LocWhitespaceVisitor locWhitespaceVisitor = new LocWhitespaceVisitor(document);
                Ref.IntRef commentLines = new Ref.IntRef();
                org.jetbrains.qodana.staticAnalysis.inspections.metrics.PsiKt.iterateFileContents(psiFile2, locWhitespaceVisitor, (Function1<? super PsiElement, Boolean>)((Function1)arg_0 -> buildVisitor.1.visitFile$lambda$0(document, arg_0)), (Function1<? super PsiElement, Unit>)((Function1)arg_0 -> buildVisitor.1.visitFile$lambda$1(commentLines, document, arg_0)));
                int whitespaceLines = locWhitespaceVisitor.getWhitespaceLines();
                int totalLines = numberOfLinesInDocument - commentLines.element - whitespaceLines;
                String string = psiFile2.getVirtualFile().getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                String filePath = string;
                MetricTableRowData tableRowData = new LinesOfCodeMetricTableRowData(filePath, totalLines);
                List list2 = CollectionsKt.listOf((Object)tableRowData);
                MetricTable metricTable = tableRowData.getMetricTable();
                MetricFileData metricFileData = new MetricFileData(filePath, metricTable, list2);
                this.$holder.registerProblem((ProblemDescriptor)new MetricCodeDescriptor(metricFileData, (PsiElement)psiFile2, null, null, null, false, new LocalQuickFix[0], 60, null));
            }

            private static final boolean visitFile$lambda$0(Document $document, PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                return element instanceof PsiComment ? true : PsiKt.hasFirstAndLastChildOnTheSameLine(element, $document);
            }

            private static final Unit visitFile$lambda$1(Ref.IntRef $commentLines, Document $document, PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof PsiComment) {
                    $commentLines.element += PsiKt.getNumberOfLinesWhereOnlyElementOnALine(element, $document, true);
                }
                return Unit.INSTANCE;
            }
        };
    }
}

