pub const ext = @import("ext.zig");
const appstream = @This();

const std = @import("std");
const compat = @import("compat");
const gio = @import("gio2");
const gobject = @import("gobject2");
const glib = @import("glib2");
const gmodule = @import("gmodule2");
pub const Agreement = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstream.AgreementClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `appstream.Agreement`.
    extern fn as_agreement_new() *appstream.Agreement;
    pub const new = as_agreement_new;

    extern fn as_agreement_add_section(p_agreement: *Agreement, p_agreement_section: *appstream.AgreementSection) void;
    pub const addSection = as_agreement_add_section;

    /// Gets the agreement kind.
    extern fn as_agreement_get_kind(p_agreement: *Agreement) appstream.AgreementKind;
    pub const getKind = as_agreement_get_kind;

    /// Gets the first section in the agreement.
    extern fn as_agreement_get_section_default(p_agreement: *Agreement) ?*appstream.AgreementSection;
    pub const getSectionDefault = as_agreement_get_section_default;

    /// Gets all the sections in the agreement.
    extern fn as_agreement_get_sections(p_agreement: *Agreement) *glib.PtrArray;
    pub const getSections = as_agreement_get_sections;

    /// Gets the agreement version_id.
    extern fn as_agreement_get_version_id(p_agreement: *Agreement) [*:0]const u8;
    pub const getVersionId = as_agreement_get_version_id;

    /// Sets the agreement kind.
    extern fn as_agreement_set_kind(p_agreement: *Agreement, p_kind: appstream.AgreementKind) void;
    pub const setKind = as_agreement_set_kind;

    /// Sets the agreement version identifier.
    extern fn as_agreement_set_version_id(p_agreement: *Agreement, p_version_id: [*:0]const u8) void;
    pub const setVersionId = as_agreement_set_version_id;

    extern fn as_agreement_get_type() usize;
    pub const getGObjectType = as_agreement_get_type;

    extern fn g_object_ref(p_self: *appstream.Agreement) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstream.Agreement) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Agreement, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const AgreementSection = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstream.AgreementSectionClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `appstream.AgreementSection`.
    extern fn as_agreement_section_new() *appstream.AgreementSection;
    pub const new = as_agreement_section_new;

    /// Returns the `appstream.Context` associated with this section.
    /// This function may return `NULL` if no context is set.
    extern fn as_agreement_section_get_context(p_agreement_section: *AgreementSection) ?*appstream.Context;
    pub const getContext = as_agreement_section_get_context;

    /// Gets the agreement section desc.
    extern fn as_agreement_section_get_description(p_agreement_section: *AgreementSection) [*:0]const u8;
    pub const getDescription = as_agreement_section_get_description;

    /// Gets the agreement section kind.
    extern fn as_agreement_section_get_kind(p_agreement_section: *AgreementSection) [*:0]const u8;
    pub const getKind = as_agreement_section_get_kind;

    /// Gets the agreement section name.
    extern fn as_agreement_section_get_name(p_agreement_section: *AgreementSection) [*:0]const u8;
    pub const getName = as_agreement_section_get_name;

    /// Sets the document context this release is associated
    /// with.
    extern fn as_agreement_section_set_context(p_agreement_section: *AgreementSection, p_context: *appstream.Context) void;
    pub const setContext = as_agreement_section_set_context;

    /// Sets the agreement section desc.
    extern fn as_agreement_section_set_description(p_agreement_section: *AgreementSection, p_desc: [*:0]const u8, p_locale: ?[*:0]const u8) void;
    pub const setDescription = as_agreement_section_set_description;

    /// Sets the agreement section kind.
    extern fn as_agreement_section_set_kind(p_agreement_section: *AgreementSection, p_kind: [*:0]const u8) void;
    pub const setKind = as_agreement_section_set_kind;

    /// Sets the agreement section name.
    extern fn as_agreement_section_set_name(p_agreement_section: *AgreementSection, p_name: [*:0]const u8, p_locale: ?[*:0]const u8) void;
    pub const setName = as_agreement_section_set_name;

    extern fn as_agreement_section_get_type() usize;
    pub const getGObjectType = as_agreement_section_get_type;

    extern fn g_object_ref(p_self: *appstream.AgreementSection) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstream.AgreementSection) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *AgreementSection, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const Artifact = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstream.ArtifactClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `appstream.Artifact`.
    extern fn as_artifact_new() *appstream.Artifact;
    pub const new = as_artifact_new;

    /// Add a checksum for the file associated with this artifact.
    extern fn as_artifact_add_checksum(p_artifact: *Artifact, p_cs: *appstream.Checksum) void;
    pub const addChecksum = as_artifact_add_checksum;

    /// Adds a artifact location.
    extern fn as_artifact_add_location(p_artifact: *Artifact, p_location: [*:0]const u8) void;
    pub const addLocation = as_artifact_add_location;

    /// Gets the bundle kind of this artifact.
    extern fn as_artifact_get_bundle_kind(p_artifact: *Artifact) appstream.BundleKind;
    pub const getBundleKind = as_artifact_get_bundle_kind;

    /// Gets the artifact checksum
    extern fn as_artifact_get_checksum(p_artifact: *Artifact, p_kind: appstream.ChecksumKind) ?*appstream.Checksum;
    pub const getChecksum = as_artifact_get_checksum;

    /// Get a list of all checksums we have for this artifact.
    extern fn as_artifact_get_checksums(p_artifact: *Artifact) *glib.PtrArray;
    pub const getChecksums = as_artifact_get_checksums;

    /// Gets a suggested filename for the downloaded artifact,
    /// or `NULL` if none is suggested.
    extern fn as_artifact_get_filename(p_artifact: *Artifact) [*:0]const u8;
    pub const getFilename = as_artifact_get_filename;

    /// Gets the artifact kind.
    extern fn as_artifact_get_kind(p_artifact: *Artifact) appstream.ArtifactKind;
    pub const getKind = as_artifact_get_kind;

    /// Gets the artifact locations, typically URLs.
    extern fn as_artifact_get_locations(p_artifact: *Artifact) *glib.PtrArray;
    pub const getLocations = as_artifact_get_locations;

    /// Gets the artifact platform string (e.g. a triplet like "x86_64-linux-gnu").
    extern fn as_artifact_get_platform(p_artifact: *Artifact) [*:0]const u8;
    pub const getPlatform = as_artifact_get_platform;

    /// Gets the artifact size.
    extern fn as_artifact_get_size(p_artifact: *Artifact, p_kind: appstream.SizeKind) u64;
    pub const getSize = as_artifact_get_size;

    /// Sets the bundle kind for this release artifact.
    extern fn as_artifact_set_bundle_kind(p_artifact: *Artifact, p_kind: appstream.BundleKind) void;
    pub const setBundleKind = as_artifact_set_bundle_kind;

    /// Sets a suggested filename for this artifact after it has been downloaded.
    extern fn as_artifact_set_filename(p_artifact: *Artifact, p_filename: [*:0]const u8) void;
    pub const setFilename = as_artifact_set_filename;

    /// Sets the artifact kind.
    extern fn as_artifact_set_kind(p_artifact: *Artifact, p_kind: appstream.ArtifactKind) void;
    pub const setKind = as_artifact_set_kind;

    /// Sets the artifact platform triplet or identifier string.
    extern fn as_artifact_set_platform(p_artifact: *Artifact, p_platform: [*:0]const u8) void;
    pub const setPlatform = as_artifact_set_platform;

    /// Sets the artifact size for the given kind.
    extern fn as_artifact_set_size(p_artifact: *Artifact, p_size: u64, p_kind: appstream.SizeKind) void;
    pub const setSize = as_artifact_set_size;

    extern fn as_artifact_get_type() usize;
    pub const getGObjectType = as_artifact_get_type;

    extern fn g_object_ref(p_self: *appstream.Artifact) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstream.Artifact) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Artifact, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const Branding = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstream.BrandingClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `appstream.Branding`.
    extern fn as_branding_new() *appstream.Branding;
    pub const new = as_branding_new;

    /// Retrieve a color of the given `kind` that matches `scheme_kind`.
    /// If a color has no scheme preference defined, it will be returned for either scheme type,
    /// unless a more suitable color was found.
    extern fn as_branding_get_color(p_branding: *Branding, p_kind: appstream.ColorKind, p_scheme_kind: appstream.ColorSchemeKind) ?[*:0]const u8;
    pub const getColor = as_branding_get_color;

    /// Deletes a color that matches the given type and scheme preference.
    extern fn as_branding_remove_color(p_branding: *Branding, p_kind: appstream.ColorKind, p_scheme_preference: appstream.ColorSchemeKind) void;
    pub const removeColor = as_branding_remove_color;

    /// Sets a new accent color. If a color of the given kind with the given scheme preference already exists,
    /// it will be overriden with the new color code.
    extern fn as_branding_set_color(p_branding: *Branding, p_kind: appstream.ColorKind, p_scheme_preference: appstream.ColorSchemeKind, p_colorcode: [*:0]const u8) void;
    pub const setColor = as_branding_set_color;

    extern fn as_branding_get_type() usize;
    pub const getGObjectType = as_branding_get_type;

    extern fn g_object_ref(p_self: *appstream.Branding) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstream.Branding) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Branding, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const Bundle = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstream.BundleClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `appstream.Bundle`.
    extern fn as_bundle_new() *appstream.Bundle;
    pub const new = as_bundle_new;

    /// Gets the ID for this bundle.
    extern fn as_bundle_get_id(p_bundle: *Bundle) [*:0]const u8;
    pub const getId = as_bundle_get_id;

    /// Gets the bundle kind.
    extern fn as_bundle_get_kind(p_bundle: *Bundle) appstream.BundleKind;
    pub const getKind = as_bundle_get_kind;

    /// Sets the ID for this bundle.
    extern fn as_bundle_set_id(p_bundle: *Bundle, p_id: [*:0]const u8) void;
    pub const setId = as_bundle_set_id;

    /// Sets the bundle kind.
    extern fn as_bundle_set_kind(p_bundle: *Bundle, p_kind: appstream.BundleKind) void;
    pub const setKind = as_bundle_set_kind;

    extern fn as_bundle_get_type() usize;
    pub const getGObjectType = as_bundle_get_type;

    extern fn g_object_ref(p_self: *appstream.Bundle) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstream.Bundle) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Bundle, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const Category = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstream.CategoryClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const children = struct {
            pub const name = "children";

            pub const Type = ?*anyopaque;
        };

        pub const icon = struct {
            pub const name = "icon";

            pub const Type = ?[*:0]u8;
        };

        pub const id = struct {
            pub const name = "id";

            pub const Type = ?[*:0]u8;
        };

        pub const name = struct {
            pub const name = "name";

            pub const Type = ?[*:0]u8;
        };

        pub const summary = struct {
            pub const name = "summary";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    /// Creates a new `appstream.Category`.
    extern fn as_category_new() *appstream.Category;
    pub const new = as_category_new;

    /// Add a subcategory to this category.
    extern fn as_category_add_child(p_category: *Category, p_subcat: *appstream.Category) void;
    pub const addChild = as_category_add_child;

    /// Add a component to this category.
    extern fn as_category_add_component(p_category: *Category, p_cpt: *appstream.Component) void;
    pub const addComponent = as_category_add_component;

    /// Add a desktop-file category to this `appstream.Category`.
    extern fn as_category_add_desktop_group(p_category: *Category, p_group_name: [*:0]const u8) void;
    pub const addDesktopGroup = as_category_add_desktop_group;

    extern fn as_category_get_children(p_category: *Category) *glib.PtrArray;
    pub const getChildren = as_category_get_children;

    /// Get list of components which have been sorted into this category.
    extern fn as_category_get_components(p_category: *Category) *glib.PtrArray;
    pub const getComponents = as_category_get_components;

    extern fn as_category_get_desktop_groups(p_category: *Category) *glib.PtrArray;
    pub const getDesktopGroups = as_category_get_desktop_groups;

    /// Get the stock icon name for this category.
    extern fn as_category_get_icon(p_category: *Category) [*:0]const u8;
    pub const getIcon = as_category_get_icon;

    /// Get the ID of this category.
    extern fn as_category_get_id(p_category: *Category) [*:0]const u8;
    pub const getId = as_category_get_id;

    /// Get the name of this category.
    extern fn as_category_get_name(p_category: *Category) [*:0]const u8;
    pub const getName = as_category_get_name;

    /// Get the summary (short description) of this category.
    extern fn as_category_get_summary(p_category: *Category) [*:0]const u8;
    pub const getSummary = as_category_get_summary;

    /// Test for sub-categories.
    extern fn as_category_has_children(p_category: *Category) c_int;
    pub const hasChildren = as_category_has_children;

    /// Check if the exact `appstream.Component` `cpt` is a member of this
    /// category already.
    extern fn as_category_has_component(p_category: *Category, p_cpt: *appstream.Component) c_int;
    pub const hasComponent = as_category_has_component;

    /// Drop a subcategory from this `appstream.Category`.
    extern fn as_category_remove_child(p_category: *Category, p_subcat: *appstream.Category) void;
    pub const removeChild = as_category_remove_child;

    /// Set the stock icon name for this category.
    extern fn as_category_set_icon(p_category: *Category, p_value: [*:0]const u8) void;
    pub const setIcon = as_category_set_icon;

    /// Set the ID of this category.
    extern fn as_category_set_id(p_category: *Category, p_id: [*:0]const u8) void;
    pub const setId = as_category_set_id;

    /// Set the name of this category.
    extern fn as_category_set_name(p_category: *Category, p_value: [*:0]const u8) void;
    pub const setName = as_category_set_name;

    /// Get the summary (short description) of this category.
    extern fn as_category_set_summary(p_category: *Category, p_value: [*:0]const u8) void;
    pub const setSummary = as_category_set_summary;

    extern fn as_category_get_type() usize;
    pub const getGObjectType = as_category_get_type;

    extern fn g_object_ref(p_self: *appstream.Category) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstream.Category) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Category, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const Checksum = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstream.ChecksumClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `appstream.Checksum`.
    extern fn as_checksum_new() *appstream.Checksum;
    pub const new = as_checksum_new;

    /// Creates a new `appstream.Checksum` with the given hash
    /// function and hash value.
    extern fn as_checksum_new_with_value(p_kind: appstream.ChecksumKind, p_value: [*:0]const u8) *appstream.Checksum;
    pub const newWithValue = as_checksum_new_with_value;

    /// Gets the checksum type.
    extern fn as_checksum_get_kind(p_cs: *Checksum) appstream.ChecksumKind;
    pub const getKind = as_checksum_get_kind;

    /// Gets the checksum, usually in its hexadecimal form.
    extern fn as_checksum_get_value(p_cs: *Checksum) [*:0]const u8;
    pub const getValue = as_checksum_get_value;

    /// Sets the checksum type.
    extern fn as_checksum_set_kind(p_cs: *Checksum, p_kind: appstream.ChecksumKind) void;
    pub const setKind = as_checksum_set_kind;

    /// Sets the checksum value filename.
    extern fn as_checksum_set_value(p_cs: *Checksum, p_value: [*:0]const u8) void;
    pub const setValue = as_checksum_set_value;

    extern fn as_checksum_get_type() usize;
    pub const getGObjectType = as_checksum_get_type;

    extern fn g_object_ref(p_self: *appstream.Checksum) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstream.Checksum) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Checksum, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const Component = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstream.ComponentClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        /// string array of categories
        pub const categories = struct {
            pub const name = "categories";

            pub const Type = ?[*]*anyopaque;
        };

        /// the description
        pub const description = struct {
            pub const name = "description";

            pub const Type = ?[*:0]u8;
        };

        /// hash map of icon urls and sizes
        pub const icons = struct {
            pub const name = "icons";

            pub const Type = ?**glib.List;
        };

        /// the unique identifier
        pub const id = struct {
            pub const name = "id";

            pub const Type = ?[*:0]u8;
        };

        /// string array of keywords
        pub const keywords = struct {
            pub const name = "keywords";

            pub const Type = ?[*][*:0]u8;
        };

        /// the `appstream.ComponentKind` of this component
        pub const kind = struct {
            pub const name = "kind";

            pub const Type = appstream.ComponentKind;
        };

        /// the name
        pub const name = struct {
            pub const name = "name";

            pub const Type = ?[*:0]u8;
        };

        /// string array of packages name
        pub const pkgnames = struct {
            pub const name = "pkgnames";

            pub const Type = ?[*][*:0]u8;
        };

        /// the project group
        pub const project_group = struct {
            pub const name = "project-group";

            pub const Type = ?[*:0]u8;
        };

        /// the project license
        pub const project_license = struct {
            pub const name = "project-license";

            pub const Type = ?[*:0]u8;
        };

        /// An array of `appstream.Screenshot` instances
        pub const screenshots = struct {
            pub const name = "screenshots";

            pub const Type = ?[*]*appstream.Screenshot;
        };

        /// the summary
        pub const summary = struct {
            pub const name = "summary";

            pub const Type = ?[*:0]u8;
        };

        /// the urls associated with this component
        pub const urls = struct {
            pub const name = "urls";

            pub const Type = ?*glib.HashTable;
        };
    };

    pub const signals = struct {};

    /// Creates a new `appstream.Component`.
    extern fn as_component_new() *appstream.Component;
    pub const new = as_component_new;

    /// Add a reference to the addon that is enhancing this component.
    extern fn as_component_add_addon(p_cpt: *Component, p_addon: *appstream.Component) void;
    pub const addAddon = as_component_add_addon;

    /// Adds an agreement to the software component.
    extern fn as_component_add_agreement(p_cpt: *Component, p_agreement: *appstream.Agreement) void;
    pub const addAgreement = as_component_add_agreement;

    /// Adds a bundle to the component.
    extern fn as_component_add_bundle(p_cpt: *Component, p_bundle: *appstream.Bundle) void;
    pub const addBundle = as_component_add_bundle;

    /// Add a category.
    extern fn as_component_add_category(p_cpt: *Component, p_category: [*:0]const u8) void;
    pub const addCategory = as_component_add_category;

    /// Adds a content rating to this component.
    extern fn as_component_add_content_rating(p_cpt: *Component, p_content_rating: *appstream.ContentRating) void;
    pub const addContentRating = as_component_add_content_rating;

    /// Add a reference to the extended component
    extern fn as_component_add_extends(p_cpt: *Component, p_cpt_id: [*:0]const u8) void;
    pub const addExtends = as_component_add_extends;

    /// Add an icon to this component.
    extern fn as_component_add_icon(p_cpt: *Component, p_icon: *appstream.Icon) void;
    pub const addIcon = as_component_add_icon;

    /// Add a new keyword to the keywords list for the given locale. This function does not
    /// check for duplicate keywords.
    extern fn as_component_add_keyword(p_cpt: *Component, p_keyword: [*:0]const u8, p_locale: ?[*:0]const u8) void;
    pub const addKeyword = as_component_add_keyword;

    /// Adds a language to the component.
    extern fn as_component_add_language(p_cpt: *Component, p_locale: ?[*:0]const u8, p_percentage: c_int) void;
    pub const addLanguage = as_component_add_language;

    /// Adds a `appstream.Launchable` containing launchables entries for this component.
    extern fn as_component_add_launchable(p_cpt: *Component, p_launchable: *appstream.Launchable) void;
    pub const addLaunchable = as_component_add_launchable;

    /// Add a set of provided items to this component.
    extern fn as_component_add_provided(p_cpt: *Component, p_prov: *appstream.Provided) void;
    pub const addProvided = as_component_add_provided;

    /// Adds a provided item to the component with the given `kind`, creating a new
    /// `AsProvided` for this kind internally if necessary.
    extern fn as_component_add_provided_item(p_cpt: *Component, p_kind: appstream.ProvidedKind, p_item: [*:0]const u8) void;
    pub const addProvidedItem = as_component_add_provided_item;

    /// Adds an external reference to the software component.
    extern fn as_component_add_reference(p_cpt: *Component, p_reference: *appstream.Reference) void;
    pub const addReference = as_component_add_reference;

    /// Adds a `appstream.Relation` to set a recommends or requires relation of
    /// component `cpt` on the item mentioned in the `appstream.Relation`.
    extern fn as_component_add_relation(p_cpt: *Component, p_relation: *appstream.Relation) void;
    pub const addRelation = as_component_add_relation;

    /// Add an `appstream.Release` to this component.
    extern fn as_component_add_release(p_cpt: *Component, p_release: *appstream.Release) void;
    pub const addRelease = as_component_add_release;

    /// Add the component ID of a component that gets replaced by the current component.
    extern fn as_component_add_replaces(p_cpt: *Component, p_cid: [*:0]const u8) void;
    pub const addReplaces = as_component_add_replaces;

    /// Adds a user review to a software component.
    extern fn as_component_add_review(p_cpt: *Component, p_review: *appstream.Review) void;
    pub const addReview = as_component_add_review;

    /// Add an `appstream.Screenshot` to this component.
    extern fn as_component_add_screenshot(p_cpt: *Component, p_sshot: *appstream.Screenshot) void;
    pub const addScreenshot = as_component_add_screenshot;

    /// Add an `appstream.Suggested` to this component.
    extern fn as_component_add_suggested(p_cpt: *Component, p_suggested: *appstream.Suggested) void;
    pub const addSuggested = as_component_add_suggested;

    /// Add a tag to this component.
    extern fn as_component_add_tag(p_cpt: *Component, p_ns: [*:0]const u8, p_tag: [*:0]const u8) c_int;
    pub const addTag = as_component_add_tag;

    /// Assign an `appstream.Translation` object describing the translation system used
    /// by this component.
    extern fn as_component_add_translation(p_cpt: *Component, p_tr: *appstream.Translation) void;
    pub const addTranslation = as_component_add_translation;

    /// Adds some URL data to the component.
    extern fn as_component_add_url(p_cpt: *Component, p_url_kind: appstream.UrlKind, p_url: [*:0]const u8) void;
    pub const addUrl = as_component_add_url;

    /// Verifies the respective relations and presents whether the system specified
    /// in `appstream.SystemInfo` `sysinfo` and data from `pool` supply the requested facilities.
    extern fn as_component_check_relations(p_cpt: *Component, p_sysinfo: ?*appstream.SystemInfo, p_pool: ?*appstream.Pool, p_rel_kind: appstream.RelationKind) *glib.PtrArray;
    pub const checkRelations = as_component_check_relations;

    /// Remove all keywords for the given locale.
    extern fn as_component_clear_keywords(p_cpt: *Component, p_locale: ?[*:0]const u8) void;
    pub const clearKeywords = as_component_clear_keywords;

    /// Remove all registered language translation information.
    extern fn as_component_clear_languages(p_cpt: *Component) void;
    pub const clearLanguages = as_component_clear_languages;

    /// Remove all tags associated with this component.
    extern fn as_component_clear_tags(p_cpt: *Component) void;
    pub const clearTags = as_component_clear_tags;

    /// Returns a list of `appstream.Component` objects which
    /// are addons extending this component in functionality.
    ///
    /// This is the reverse of `appstream.Component.getExtends``appstream.Component.getExtends`
    extern fn as_component_get_addons(p_cpt: *Component) *glib.PtrArray;
    pub const getAddons = as_component_get_addons;

    /// Gets an agreement the component has specified for the particular kind.
    extern fn as_component_get_agreement_by_kind(p_cpt: *Component, p_kind: appstream.AgreementKind) ?*appstream.Agreement;
    pub const getAgreementByKind = as_component_get_agreement_by_kind;

    /// Get a list of all agreements registered with this software component.
    extern fn as_component_get_agreements(p_cpt: *Component) *glib.PtrArray;
    pub const getAgreements = as_component_get_agreements;

    /// Gets the branch for the application.
    extern fn as_component_get_branch(p_cpt: *Component) [*:0]const u8;
    pub const getBranch = as_component_get_branch;

    /// Get the branding associated with this component, or `NULL`
    /// in case this component has no special branding.
    extern fn as_component_get_branding(p_cpt: *Component) ?*appstream.Branding;
    pub const getBranding = as_component_get_branding;

    /// Gets a bundle identifier string.
    extern fn as_component_get_bundle(p_cpt: *Component, p_bundle_kind: appstream.BundleKind) ?*appstream.Bundle;
    pub const getBundle = as_component_get_bundle;

    /// Get a list of all software bundles associated with this component.
    extern fn as_component_get_bundles(p_cpt: *Component) *glib.PtrArray;
    pub const getBundles = as_component_get_bundles;

    extern fn as_component_get_categories(p_cpt: *Component) *glib.PtrArray;
    pub const getCategories = as_component_get_categories;

    extern fn as_component_get_compulsory_for_desktops(p_cpt: *Component) *glib.PtrArray;
    pub const getCompulsoryForDesktops = as_component_get_compulsory_for_desktops;

    /// Gets a content ratings of a specific type that are defined for this component.
    extern fn as_component_get_content_rating(p_cpt: *Component, p_kind: [*:0]const u8) ?*appstream.ContentRating;
    pub const getContentRating = as_component_get_content_rating;

    /// Gets all content ratings defined for this software.
    extern fn as_component_get_content_ratings(p_cpt: *Component) *glib.PtrArray;
    pub const getContentRatings = as_component_get_content_ratings;

    /// Get the `appstream.Context` associated with this component.
    /// This function may return `NULL` if no context is set
    /// (which will be the case if the component was not loaded from
    /// a file or cache but constructed in memory).
    extern fn as_component_get_context(p_cpt: *Component) ?*appstream.Context;
    pub const getContext = as_component_get_context;

    extern fn as_component_get_custom(p_cpt: *Component) *glib.HashTable;
    pub const getCustom = as_component_get_custom;

    /// Retrieve value for a custom data entry with the given key.
    extern fn as_component_get_custom_value(p_cpt: *Component, p_key: [*:0]const u8) [*:0]const u8;
    pub const getCustomValue = as_component_get_custom_value;

    /// Get a unique identifier for this metadata set.
    /// This unique ID is only valid for the current session,
    /// as opposed to the AppStream ID which uniquely identifies
    /// a software component.
    ///
    /// The format of the unique id usually is:
    /// %{scope}/%{origin}/%{distribution_system}/%{appstream_id}
    ///
    /// For example:
    /// system/os/package/org.example.FooBar
    extern fn as_component_get_data_id(p_cpt: *Component) [*:0]const u8;
    pub const getDataId = as_component_get_data_id;

    /// Gets the end-of-life date for the entire component.
    extern fn as_component_get_date_eol(p_cpt: *Component) [*:0]const u8;
    pub const getDateEol = as_component_get_date_eol;

    /// Get the localized long description of this component.
    extern fn as_component_get_description(p_cpt: *Component) [*:0]const u8;
    pub const getDescription = as_component_get_description;

    /// Get information about the component's developer or development team.
    /// The returned object may be empty if no developer information was
    /// available.
    extern fn as_component_get_developer(p_cpt: *Component) *appstream.Developer;
    pub const getDeveloper = as_component_get_developer;

    /// Returns a string list of IDs of components which
    /// are extended by this addon.
    ///
    /// See `appstream.Component.getExtends``appstream.Component.getExtends` for the reverse.
    extern fn as_component_get_extends(p_cpt: *Component) ?*glib.PtrArray;
    pub const getExtends = as_component_get_extends;

    /// Gets an icon matching the size constraints.
    /// The icons are not filtered by type, and the first icon
    /// which matches the size is returned.
    /// If you want more control over which icons you use for displaying,
    /// use the `appstream.Component.getIcons``appstream.Component.getIcons` function to get a list of all icons.
    ///
    /// Note that this function is not HiDPI aware! It will never return an icon with
    /// a scaling factor > 1.
    extern fn as_component_get_icon_by_size(p_cpt: *Component, p_width: c_uint, p_height: c_uint) ?*appstream.Icon;
    pub const getIconBySize = as_component_get_icon_by_size;

    /// Gets a stock icon for this component if one is associated with it.
    /// Will return `NULL` otherwise.
    extern fn as_component_get_icon_stock(p_cpt: *Component) ?*appstream.Icon;
    pub const getIconStock = as_component_get_icon_stock;

    extern fn as_component_get_icons(p_cpt: *Component) *glib.PtrArray;
    pub const getIcons = as_component_get_icons;

    /// Get the unique AppStream identifier for this component.
    /// This ID is unique for the described component, but does
    /// not uniquely identify the metadata set.
    ///
    /// For a unique ID for this metadata set in the current
    /// session, use `appstream.Component.getDataId``appstream.Component.getDataId`
    extern fn as_component_get_id(p_cpt: *Component) [*:0]const u8;
    pub const getId = as_component_get_id;

    extern fn as_component_get_keywords(p_cpt: *Component) *glib.PtrArray;
    pub const getKeywords = as_component_get_keywords;

    /// Retrieve the internal hash table mapping languages to
    /// keword arrays.
    extern fn as_component_get_keywords_table(p_cpt: *Component) *glib.HashTable;
    pub const getKeywordsTable = as_component_get_keywords_table;

    /// Returns the `appstream.ComponentKind` of this component.
    extern fn as_component_get_kind(p_cpt: *Component) appstream.ComponentKind;
    pub const getKind = as_component_get_kind;

    /// Gets the translation coverage in percent for a specific locale
    extern fn as_component_get_language(p_cpt: *Component, p_locale: ?[*:0]const u8) c_int;
    pub const getLanguage = as_component_get_language;

    /// Get a list of all languages.
    extern fn as_component_get_languages(p_cpt: *Component) *glib.List;
    pub const getLanguages = as_component_get_languages;

    /// Gets a `appstream.Launchable` of a specific type that contains launchable entries for
    /// this component.
    extern fn as_component_get_launchable(p_cpt: *Component, p_kind: appstream.LaunchableKind) ?*appstream.Launchable;
    pub const getLaunchable = as_component_get_launchable;

    extern fn as_component_get_launchables(p_cpt: *Component) *glib.PtrArray;
    pub const getLaunchables = as_component_get_launchables;

    /// Get the merge method which should apply to duplicate components
    /// with this ID.
    extern fn as_component_get_merge_kind(p_cpt: *Component) appstream.MergeKind;
    pub const getMergeKind = as_component_get_merge_kind;

    /// The license the metadata iself is subjected to.
    extern fn as_component_get_metadata_license(p_cpt: *Component) [*:0]const u8;
    pub const getMetadataLicense = as_component_get_metadata_license;

    /// A human-readable name for this component.
    extern fn as_component_get_name(p_cpt: *Component) [*:0]const u8;
    pub const getName = as_component_get_name;

    /// Get the internal locale to component name
    /// mapping table.
    extern fn as_component_get_name_table(p_cpt: *Component) *glib.HashTable;
    pub const getNameTable = as_component_get_name_table;

    /// Get variant suffix for the component name
    /// (only to be displayed if two components have the same name).
    extern fn as_component_get_name_variant_suffix(p_cpt: *Component) [*:0]const u8;
    pub const getNameVariantSuffix = as_component_get_name_variant_suffix;

    extern fn as_component_get_origin(p_cpt: *Component) [*:0]const u8;
    pub const getOrigin = as_component_get_origin;

    /// Get the first package name of the list of packages that need to be installed
    /// for this component to be present on the system.
    /// Since most components consist of only one package, this is safe to use for
    /// about 90% of all cases.
    ///
    /// However, to support a component fully, please use `appstream.Component.getPkgnames``appstream.Component.getPkgnames` for
    /// getting all packages that need to be installed, and use this method only to
    /// e.g. get the main package to perform a quick "is it installed?" check.
    extern fn as_component_get_pkgname(p_cpt: *Component) [*:0]u8;
    pub const getPkgname = as_component_get_pkgname;

    /// Get a list of package names which this component consists of.
    /// This usually is just one package name.
    extern fn as_component_get_pkgnames(p_cpt: *Component) [*][*:0]u8;
    pub const getPkgnames = as_component_get_pkgnames;

    /// Returns the priority of this component.
    /// This method is used internally.
    extern fn as_component_get_priority(p_cpt: *Component) c_int;
    pub const getPriority = as_component_get_priority;

    /// Get the component's project group.
    extern fn as_component_get_project_group(p_cpt: *Component) [*:0]const u8;
    pub const getProjectGroup = as_component_get_project_group;

    /// Get the license of the project this component belongs to.
    extern fn as_component_get_project_license(p_cpt: *Component) [*:0]const u8;
    pub const getProjectLicense = as_component_get_project_license;

    /// Get a list of `appstream.Provided` objects associated with this component.
    extern fn as_component_get_provided(p_cpt: *Component) *glib.PtrArray;
    pub const getProvided = as_component_get_provided;

    /// Get an `appstream.Provided` object for the given interface type,
    /// containing information about the public interfaces (mimetypes, firmware, DBus services, ...)
    /// this component provides.
    extern fn as_component_get_provided_for_kind(p_cpt: *Component, p_kind: appstream.ProvidedKind) ?*appstream.Provided;
    pub const getProvidedForKind = as_component_get_provided_for_kind;

    /// Get an array of items that are recommended by this component.
    extern fn as_component_get_recommends(p_cpt: *Component) *glib.PtrArray;
    pub const getRecommends = as_component_get_recommends;

    /// Get a list of external references and citation information for this component.
    extern fn as_component_get_references(p_cpt: *Component) *glib.PtrArray;
    pub const getReferences = as_component_get_references;

    /// Get release information for this component,
    /// without downloading or loading any data from external sources.
    extern fn as_component_get_releases_plain(p_cpt: *Component) *appstream.ReleaseList;
    pub const getReleasesPlain = as_component_get_releases_plain;

    /// Get a list of component IDs of components that this software replaces entirely.
    extern fn as_component_get_replaces(p_cpt: *Component) *glib.PtrArray;
    pub const getReplaces = as_component_get_replaces;

    /// Get an array of items that are required by this component.
    extern fn as_component_get_requires(p_cpt: *Component) *glib.PtrArray;
    pub const getRequires = as_component_get_requires;

    /// Gets any reviews associated with the component.
    extern fn as_component_get_reviews(p_cpt: *Component) *glib.PtrArray;
    pub const getReviews = as_component_get_reviews;

    extern fn as_component_get_scope(p_cpt: *Component) appstream.ComponentScope;
    pub const getScope = as_component_get_scope;

    /// Get a list of all associated screenshots, for all environments.
    extern fn as_component_get_screenshots_all(p_cpt: *Component) *glib.PtrArray;
    pub const getScreenshotsAll = as_component_get_screenshots_all;

    /// Returns all search tokens for this component.
    extern fn as_component_get_search_tokens(p_cpt: *Component) *glib.PtrArray;
    pub const getSearchTokens = as_component_get_search_tokens;

    /// Returns the sorting priority of this component.
    ///
    /// This will only return a valid value if this component
    /// was the result of or involved in a search operation which
    /// returned sorted results.
    /// In most cases you will not need to access this value explicitly,
    /// as all results of search operations in AppStream are already sorted
    /// from best match to worst.
    ///
    /// The returned value is an arbitrary integer value, valid only for
    /// the search terms involved in the search operation that yielded
    /// this component as a result.
    extern fn as_component_get_sort_score(p_cpt: *Component) c_uint;
    pub const getSortScore = as_component_get_sort_score;

    extern fn as_component_get_source_pkgname(p_cpt: *Component) [*:0]const u8;
    pub const getSourcePkgname = as_component_get_source_pkgname;

    /// Get a list of associated suggestions.
    extern fn as_component_get_suggested(p_cpt: *Component) *glib.PtrArray;
    pub const getSuggested = as_component_get_suggested;

    /// Get a short description of this component.
    extern fn as_component_get_summary(p_cpt: *Component) [*:0]const u8;
    pub const getSummary = as_component_get_summary;

    /// Get the internal locale to component summary
    /// mapping table.
    extern fn as_component_get_summary_table(p_cpt: *Component) *glib.HashTable;
    pub const getSummaryTable = as_component_get_summary_table;

    /// Get an array of items that are supported by this component,
    /// e.g. to indicate support for a specific piece of hardware.
    extern fn as_component_get_supports(p_cpt: *Component) *glib.PtrArray;
    pub const getSupports = as_component_get_supports;

    /// Return a score between 0 and 100 determining how compatible the component
    /// is with the system configuration provided as parameter.
    ///
    /// 0 means the componsnt will not work at all, while 100 is best compatibility.
    extern fn as_component_get_system_compatibility_score(p_cpt: *Component, p_sysinfo: *appstream.SystemInfo, p_is_template: c_int, p_results: ?**glib.PtrArray) c_int;
    pub const getSystemCompatibilityScore = as_component_get_system_compatibility_score;

    /// Gets the UNIX timestamp for the date when this component
    /// is out of support (end-of-life) and will receive no more
    /// updates, not even security fixes.
    extern fn as_component_get_timestamp_eol(p_cpt: *Component) u64;
    pub const getTimestampEol = as_component_get_timestamp_eol;

    /// Get a `glib.PtrArray` of `appstream.Translation` objects describing the
    /// translation systems and translation-ids (e.g. Gettext domains) used
    /// by this software component.
    ///
    /// Only set for metainfo files.
    extern fn as_component_get_translations(p_cpt: *Component) *glib.PtrArray;
    pub const getTranslations = as_component_get_translations;

    /// Gets a URL.
    extern fn as_component_get_url(p_cpt: *Component, p_url_kind: appstream.UrlKind) ?[*:0]const u8;
    pub const getUrl = as_component_get_url;

    extern fn as_component_has_bundle(p_cpt: *Component) c_int;
    pub const hasBundle = as_component_has_bundle;

    /// Check if component is in the specified category.
    extern fn as_component_has_category(p_cpt: *Component, p_category: [*:0]const u8) c_int;
    pub const hasCategory = as_component_has_category;

    /// Test if the component is tagged with the selected
    /// tag.
    extern fn as_component_has_tag(p_cpt: *Component, p_ns: [*:0]const u8, p_tag: [*:0]const u8) c_int;
    pub const hasTag = as_component_has_tag;

    /// Add a key and value pair to the custom data table.
    extern fn as_component_insert_custom_value(p_cpt: *Component, p_key: [*:0]const u8, p_value: [*:0]const u8) c_int;
    pub const insertCustomValue = as_component_insert_custom_value;

    /// Check if this component is compulsory for the given desktop.
    extern fn as_component_is_compulsory_for_desktop(p_cpt: *Component, p_desktop: [*:0]const u8) c_int;
    pub const isCompulsoryForDesktop = as_component_is_compulsory_for_desktop;

    /// Returns `TRUE` if this component is free and open source software.
    /// To determine this status, this function will check if it comes
    /// from a vetted free-software-only source or whether its licenses
    /// are only free software licenses.
    extern fn as_component_is_floss(p_cpt: *Component) c_int;
    pub const isFloss = as_component_is_floss;

    extern fn as_component_is_ignored(p_cpt: *Component) c_int;
    pub const isIgnored = as_component_is_ignored;

    /// Test if the component `cpt` is a member of category `category`.
    extern fn as_component_is_member_of_category(p_cpt: *Component, p_category: *appstream.Category) c_int;
    pub const isMemberOfCategory = as_component_is_member_of_category;

    /// Check if the essential properties of this Component are
    /// populated with useful data.
    extern fn as_component_is_valid(p_cpt: *Component) c_int;
    pub const isValid = as_component_is_valid;

    /// Load metadata for this component from an XML string.
    /// You normally do not want to use this method directly and instead use the more
    /// convenient API of `appstream.Metadata` to create and update components.
    ///
    /// If this function returns `TRUE`, a valid component is returned unless the selected
    /// format was `AS_FORMAT_KIND_DESKTOP_ENTRY`, in which case a component ID will have to
    /// be set explicitly by the caller in order to make the component valid.
    extern fn as_component_load_from_bytes(p_cpt: *Component, p_context: *appstream.Context, p_format: appstream.FormatKind, p_bytes: *glib.Bytes, p_error: ?*?*glib.Error) c_int;
    pub const loadFromBytes = as_component_load_from_bytes;

    /// Get release information for this component, download it
    /// if necessary.
    extern fn as_component_load_releases(p_cpt: *Component, p_allow_net: c_int, p_error: ?*?*glib.Error) ?*appstream.ReleaseList;
    pub const loadReleases = as_component_load_releases;

    /// Remove a tag from this component
    extern fn as_component_remove_tag(p_cpt: *Component, p_ns: [*:0]const u8, p_tag: [*:0]const u8) c_int;
    pub const removeTag = as_component_remove_tag;

    /// Searches component data for a specific keyword.
    extern fn as_component_search_matches(p_cpt: *Component, p_term: [*:0]const u8) c_uint;
    pub const searchMatches = as_component_search_matches;

    /// Searches component data for all the specific keywords.
    extern fn as_component_search_matches_all(p_cpt: *Component, p_terms: *[*:0]u8) c_uint;
    pub const searchMatchesAll = as_component_search_matches_all;

    /// Set the branch that the component instance was sourced from.
    extern fn as_component_set_branch(p_cpt: *Component, p_branch: [*:0]const u8) void;
    pub const setBranch = as_component_set_branch;

    /// Set branding for this component.
    extern fn as_component_set_branding(p_cpt: *Component, p_branding: *appstream.Branding) void;
    pub const setBranding = as_component_set_branding;

    /// Mark this component to be compulsory for the specified desktop environment.
    extern fn as_component_set_compulsory_for_desktop(p_cpt: *Component, p_desktop: [*:0]const u8) void;
    pub const setCompulsoryForDesktop = as_component_set_compulsory_for_desktop;

    /// Sets the document context this component is associated
    /// with.
    extern fn as_component_set_context(p_cpt: *Component, p_context: *appstream.Context) void;
    pub const setContext = as_component_set_context;

    /// Set the active locale on the context assoaiacted with this component,
    /// creating a new context for the component if none exists yet.
    ///
    /// Please not that this will flip the locale of all other components and
    /// entities that use the same context as well!
    /// This function is just a convenience method, and does not replace
    /// proper `appstream.Context` management.
    extern fn as_component_set_context_locale(p_cpt: *Component, p_locale: [*:0]const u8) void;
    pub const setContextLocale = as_component_set_context_locale;

    /// Set the session-specific unique metadata identifier for this
    /// component.
    /// If two components have a different data_id but the same ID,
    /// they will be treated as independent sets of metadata describing
    /// the same component type.
    extern fn as_component_set_data_id(p_cpt: *Component, p_value: [*:0]const u8) void;
    pub const setDataId = as_component_set_data_id;

    /// Sets an end-of-life date for this component.
    extern fn as_component_set_date_eol(p_cpt: *Component, p_date: [*:0]const u8) void;
    pub const setDateEol = as_component_set_date_eol;

    /// Set long description for this component.
    extern fn as_component_set_description(p_cpt: *Component, p_value: [*:0]const u8, p_locale: ?[*:0]const u8) void;
    pub const setDescription = as_component_set_description;

    /// Set the the component's developer.
    extern fn as_component_set_developer(p_cpt: *Component, p_developer: *appstream.Developer) void;
    pub const setDeveloper = as_component_set_developer;

    /// Set the AppStream identifier for this component.
    extern fn as_component_set_id(p_cpt: *Component, p_value: [*:0]const u8) void;
    pub const setId = as_component_set_id;

    /// Set keywords for this component, replacing all existing ones for the selected locale.
    extern fn as_component_set_keywords(p_cpt: *Component, p_new_keywords: *glib.PtrArray, p_locale: ?[*:0]const u8, p_deep_copy: c_int) void;
    pub const setKeywords = as_component_set_keywords;

    /// Sets the `appstream.ComponentKind` of this component.
    extern fn as_component_set_kind(p_cpt: *Component, p_value: appstream.ComponentKind) void;
    pub const setKind = as_component_set_kind;

    /// Sets the `appstream.MergeKind` for this component.
    extern fn as_component_set_merge_kind(p_cpt: *Component, p_kind: appstream.MergeKind) void;
    pub const setMergeKind = as_component_set_merge_kind;

    /// Set the license this metadata is licensed under.
    extern fn as_component_set_metadata_license(p_cpt: *Component, p_value: [*:0]const u8) void;
    pub const setMetadataLicense = as_component_set_metadata_license;

    /// Set a human-readable name for this component.
    extern fn as_component_set_name(p_cpt: *Component, p_value: [*:0]const u8, p_locale: ?[*:0]const u8) void;
    pub const setName = as_component_set_name;

    /// Set a variant suffix for the component name
    /// (only to be displayed if components have the same name).
    extern fn as_component_set_name_variant_suffix(p_cpt: *Component, p_value: [*:0]const u8, p_locale: ?[*:0]const u8) void;
    pub const setNameVariantSuffix = as_component_set_name_variant_suffix;

    extern fn as_component_set_origin(p_cpt: *Component, p_origin: [*:0]const u8) void;
    pub const setOrigin = as_component_set_origin;

    /// Set the package name that provides this component.
    extern fn as_component_set_pkgname(p_cpt: *Component, p_pkgname: [*:0]const u8) void;
    pub const setPkgname = as_component_set_pkgname;

    /// Set a list of package names this component consists of.
    /// (This should usually be just one package name)
    extern fn as_component_set_pkgnames(p_cpt: *Component, p_packages: [*][*:0]u8) void;
    pub const setPkgnames = as_component_set_pkgnames;

    /// Sets the priority of this component.
    /// This method is used internally.
    extern fn as_component_set_priority(p_cpt: *Component, p_priority: c_int) void;
    pub const setPriority = as_component_set_priority;

    /// Set the component's project group.
    extern fn as_component_set_project_group(p_cpt: *Component, p_value: [*:0]const u8) void;
    pub const setProjectGroup = as_component_set_project_group;

    /// Set the project license.
    extern fn as_component_set_project_license(p_cpt: *Component, p_value: [*:0]const u8) void;
    pub const setProjectLicense = as_component_set_project_license;

    /// Set a new set of releases for this component.
    extern fn as_component_set_releases(p_cpt: *Component, p_releases: *appstream.ReleaseList) void;
    pub const setReleases = as_component_set_releases;

    /// Sets the `appstream.ComponentScope` of this component.
    extern fn as_component_set_scope(p_cpt: *Component, p_scope: appstream.ComponentScope) void;
    pub const setScope = as_component_set_scope;

    /// Sets the sorting score of this component.
    extern fn as_component_set_sort_score(p_cpt: *Component, p_score: c_uint) void;
    pub const setSortScore = as_component_set_sort_score;

    extern fn as_component_set_source_pkgname(p_cpt: *Component, p_spkgname: [*:0]const u8) void;
    pub const setSourcePkgname = as_component_set_source_pkgname;

    /// Set a short description for this component.
    extern fn as_component_set_summary(p_cpt: *Component, p_value: [*:0]const u8, p_locale: ?[*:0]const u8) void;
    pub const setSummary = as_component_set_summary;

    /// Reorder the screenshots to prioritize a certain environment or style, instead of using the default
    /// screenshot order.
    ///
    /// If both "environment" and "style" are `NULL`, the previous default order is restored.
    extern fn as_component_sort_screenshots(p_cpt: *Component, p_environment: ?[*:0]const u8, p_style: ?[*:0]const u8, p_prioritize_style: c_int) void;
    pub const sortScreenshots = as_component_sort_screenshots;

    /// Returns a string identifying this component.
    /// (useful for debugging)
    extern fn as_component_to_string(p_cpt: *Component) [*:0]u8;
    pub const toString = as_component_to_string;

    /// Serialize this component into an XML string.
    /// You normally do not want to use this method directly and instead use the more
    /// convenient API of `appstream.Metadata` to serialize components.
    extern fn as_component_to_xml_data(p_cpt: *Component, p_context: *appstream.Context, p_error: ?*?*glib.Error) ?[*:0]u8;
    pub const toXmlData = as_component_to_xml_data;

    extern fn as_component_get_type() usize;
    pub const getGObjectType = as_component_get_type;

    extern fn g_object_ref(p_self: *appstream.Component) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstream.Component) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Component, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ComponentBox = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstream.ComponentBoxClass;
    f_parent_instance: gobject.Object,
    f_cpts: ?*glib.PtrArray,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const flags = struct {
            pub const name = "flags";

            pub const Type = c_uint;
        };
    };

    pub const signals = struct {};

    /// Creates a new `appstream.ComponentBox`.
    extern fn as_component_box_new(p_flags: appstream.ComponentBoxFlags) *appstream.ComponentBox;
    pub const new = as_component_box_new;

    /// Creates a new `appstream.ComponentBox` with the simplest parameters,
    /// so it is basically an array storage without overhead.
    ///
    /// Only the most basic checks on inserted components will be performed,
    /// and it is assumed that the inserted components have been checked
    /// already prior to insertion.
    extern fn as_component_box_new_simple() *appstream.ComponentBox;
    pub const newSimple = as_component_box_new_simple;

    /// Add a component to the box. Returns an error if we could not add it
    /// (most likely due to component box constraints).
    extern fn as_component_box_add(p_cbox: *ComponentBox, p_cpt: *appstream.Component, p_error: ?*?*glib.Error) c_int;
    pub const add = as_component_box_add;

    /// Get the contents of this component box as `glib.PtrArray`.
    extern fn as_component_box_as_array(p_cbox: *ComponentBox) *glib.PtrArray;
    pub const asArray = as_component_box_as_array;

    /// Remove all contents of this component box.
    extern fn as_component_box_clear(p_cbox: *ComponentBox) void;
    pub const clear = as_component_box_clear;

    /// Get the flags this component box was constructed with.
    extern fn as_component_box_get_flags(p_cbox: *ComponentBox) appstream.ComponentBoxFlags;
    pub const getFlags = as_component_box_get_flags;

    /// Get the amount of components in this box.
    extern fn as_component_box_get_size(p_cbox: *ComponentBox) c_uint;
    pub const getSize = as_component_box_get_size;

    /// Retrieve a component at the respective index from the internal
    /// component array.
    extern fn as_component_box_index_safe(p_cbox: *ComponentBox, p_index: c_uint) *appstream.Component;
    pub const indexSafe = as_component_box_index_safe;

    /// Check if there are any components present.
    extern fn as_component_box_is_empty(p_cbox: *ComponentBox) c_int;
    pub const isEmpty = as_component_box_is_empty;

    /// Remove a component at the specified index.
    /// Please ensure that the index is not larger than
    /// `appstream.ComponentBox.getSize``appstream.ComponentBox.getSize` - 1
    extern fn as_component_box_remove_at(p_cbox: *ComponentBox, p_index: c_uint) void;
    pub const removeAt = as_component_box_remove_at;

    /// Sort components to bring them into a deterministic order.
    extern fn as_component_box_sort(p_cbox: *ComponentBox) void;
    pub const sort = as_component_box_sort;

    /// Sort components by their (search) match score.
    extern fn as_component_box_sort_by_score(p_cbox: *ComponentBox) void;
    pub const sortByScore = as_component_box_sort_by_score;

    extern fn as_component_box_get_type() usize;
    pub const getGObjectType = as_component_box_get_type;

    extern fn g_object_ref(p_self: *appstream.ComponentBox) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstream.ComponentBox) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ComponentBox, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ContentRating = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstream.ContentRatingClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Gets the highest `appstream.ContentRatingValue` which is allowed to be seen by the
    /// given Common Sense Media `age` for the given subsection `id`.
    ///
    /// For example, if the CSM age mappings for `violence-bloodshed` are:
    ///  * age ≥ 0 for `AS_CONTENT_RATING_VALUE_NONE`
    ///  * age ≥ 9 for `AS_CONTENT_RATING_VALUE_MILD`
    ///  * age ≥ 11 for `AS_CONTENT_RATING_VALUE_MODERATE`
    ///  * age ≥ 18 for `AS_CONTENT_RATING_VALUE_INTENSE`
    /// then calling this function with `violence-bloodshed` and `age` set to 17 would
    /// return `AS_CONTENT_RATING_VALUE_MODERATE`. Calling it with age 18 would
    /// return `AS_CONTENT_RATING_VALUE_INTENSE`.
    extern fn as_content_rating_attribute_from_csm_age(p_id: [*:0]const u8, p_age: c_uint) appstream.ContentRatingValue;
    pub const attributeFromCsmAge = as_content_rating_attribute_from_csm_age;

    /// Get a human-readable description of what content would be expected to
    /// require the content rating attribute given by `id` and `value`.
    extern fn as_content_rating_attribute_get_description(p_id: [*:0]const u8, p_value: appstream.ContentRatingValue) [*:0]const u8;
    pub const attributeGetDescription = as_content_rating_attribute_get_description;

    /// Gets the Common Sense Media approved age for a specific rating level.
    extern fn as_content_rating_attribute_to_csm_age(p_id: [*:0]const u8, p_value: appstream.ContentRatingValue) c_uint;
    pub const attributeToCsmAge = as_content_rating_attribute_to_csm_age;

    /// Returns a list of all the valid OARS content rating attribute IDs as could
    /// be passed to `appstream.ContentRating.addAttribute` or
    /// `appstream.ContentRating.attributeToCsmAge`.
    extern fn as_content_rating_get_all_rating_ids() [*][*:0]const u8;
    pub const getAllRatingIds = as_content_rating_get_all_rating_ids;

    /// Creates a new `appstream.ContentRating`.
    extern fn as_content_rating_new() *appstream.ContentRating;
    pub const new = as_content_rating_new;

    /// Adds an attribute value to the content rating.
    extern fn as_content_rating_add_attribute(p_content_rating: *ContentRating, p_id: [*:0]const u8, p_value: appstream.ContentRatingValue) void;
    pub const addAttribute = as_content_rating_add_attribute;

    /// Gets the content_rating kind.
    extern fn as_content_rating_get_kind(p_content_rating: *ContentRating) [*:0]const u8;
    pub const getKind = as_content_rating_get_kind;

    /// Gets the lowest Common Sense Media approved age for the content_rating block.
    /// NOTE: these numbers are based on the data and descriptions available from
    /// https://www.commonsensemedia.org/about-us/our-mission/about-our-ratings and
    /// you may disagree with them.
    ///
    /// You're free to disagree with these, and of course you should use your own
    /// brain to work our if your child is able to cope with the concepts enumerated
    /// here. Some 13 year olds may be fine with the concept of mutilation of body
    /// parts; others may get nightmares.
    extern fn as_content_rating_get_minimum_age(p_content_rating: *ContentRating) c_uint;
    pub const getMinimumAge = as_content_rating_get_minimum_age;

    /// Gets the set of ratings IDs which are present in this `content_rating`. An
    /// example of a ratings ID is `violence-bloodshed`.
    ///
    /// The IDs are returned in lexicographical order.
    extern fn as_content_rating_get_rating_ids(p_content_rating: *ContentRating) [*][*:0]const u8;
    pub const getRatingIds = as_content_rating_get_rating_ids;

    /// Gets the value of a content rating key.
    extern fn as_content_rating_get_value(p_content_rating: *ContentRating, p_id: [*:0]const u8) appstream.ContentRatingValue;
    pub const getValue = as_content_rating_get_value;

    /// Sets the content rating kind.
    extern fn as_content_rating_set_kind(p_content_rating: *ContentRating, p_kind: [*:0]const u8) void;
    pub const setKind = as_content_rating_set_kind;

    /// Sets the value of a content rating key.
    extern fn as_content_rating_set_value(p_content_rating: *ContentRating, p_id: [*:0]const u8, p_value: appstream.ContentRatingValue) void;
    pub const setValue = as_content_rating_set_value;

    extern fn as_content_rating_get_type() usize;
    pub const getGObjectType = as_content_rating_get_type;

    extern fn g_object_ref(p_self: *appstream.ContentRating) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstream.ContentRating) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ContentRating, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const Context = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstream.ContextClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `appstream.Context`.
    extern fn as_context_new() *appstream.Context;
    pub const new = as_context_new;

    extern fn as_context_get_filename(p_ctx: *Context) [*:0]const u8;
    pub const getFilename = as_context_get_filename;

    extern fn as_context_get_format_version(p_ctx: *Context) appstream.FormatVersion;
    pub const getFormatVersion = as_context_get_format_version;

    extern fn as_context_get_locale(p_ctx: *Context) [*:0]const u8;
    pub const getLocale = as_context_get_locale;

    extern fn as_context_get_locale_use_all(p_ctx: *Context) c_int;
    pub const getLocaleUseAll = as_context_get_locale_use_all;

    extern fn as_context_get_media_baseurl(p_ctx: *Context) [*:0]const u8;
    pub const getMediaBaseurl = as_context_get_media_baseurl;

    extern fn as_context_get_origin(p_ctx: *Context) [*:0]const u8;
    pub const getOrigin = as_context_get_origin;

    extern fn as_context_get_priority(p_ctx: *Context) c_int;
    pub const getPriority = as_context_get_priority;

    extern fn as_context_get_style(p_ctx: *Context) appstream.FormatStyle;
    pub const getStyle = as_context_get_style;

    extern fn as_context_get_value_flags(p_ctx: *Context) appstream.ValueFlags;
    pub const getValueFlags = as_context_get_value_flags;

    extern fn as_context_has_media_baseurl(p_ctx: *Context) c_int;
    pub const hasMediaBaseurl = as_context_has_media_baseurl;

    /// Sets the file name we are loading data from.
    extern fn as_context_set_filename(p_ctx: *Context, p_fname: [*:0]const u8) void;
    pub const setFilename = as_context_set_filename;

    /// Sets the AppStream format version.
    extern fn as_context_set_format_version(p_ctx: *Context, p_ver: appstream.FormatVersion) void;
    pub const setFormatVersion = as_context_set_format_version;

    /// Sets the active locale.
    /// If the magic value "ALL" is used, the current system locale will be used
    /// for data reading, but when writing data all locale will be written.
    extern fn as_context_set_locale(p_ctx: *Context, p_locale: ?[*:0]const u8) void;
    pub const setLocale = as_context_set_locale;

    /// Sets the media base URL.
    extern fn as_context_set_media_baseurl(p_ctx: *Context, p_value: [*:0]const u8) void;
    pub const setMediaBaseurl = as_context_set_media_baseurl;

    /// Sets the data origin.
    extern fn as_context_set_origin(p_ctx: *Context, p_value: [*:0]const u8) void;
    pub const setOrigin = as_context_set_origin;

    /// Sets the data priority.
    extern fn as_context_set_priority(p_ctx: *Context, p_priority: c_int) void;
    pub const setPriority = as_context_set_priority;

    /// Sets the AppStream document style.
    extern fn as_context_set_style(p_ctx: *Context, p_style: appstream.FormatStyle) void;
    pub const setStyle = as_context_set_style;

    extern fn as_context_set_value_flags(p_ctx: *Context, p_flags: appstream.ValueFlags) void;
    pub const setValueFlags = as_context_set_value_flags;

    extern fn as_context_get_type() usize;
    pub const getGObjectType = as_context_get_type;

    extern fn g_object_ref(p_self: *appstream.Context) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstream.Context) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Context, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const Developer = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstream.DeveloperClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `appstream.Developer`.
    extern fn as_developer_new() *appstream.Developer;
    pub const new = as_developer_new;

    /// Gets a unique ID for this particular developer, e.g. "gnome" or "mozilla.org"
    extern fn as_developer_get_id(p_devp: *Developer) [*:0]const u8;
    pub const getId = as_developer_get_id;

    /// Get a localized developer, or development team name.
    extern fn as_developer_get_name(p_devp: *Developer) [*:0]const u8;
    pub const getName = as_developer_get_name;

    /// Sets the unique ID of this developer.
    extern fn as_developer_set_id(p_devp: *Developer, p_id: [*:0]const u8) void;
    pub const setId = as_developer_set_id;

    /// Set the the developer or development team name.
    extern fn as_developer_set_name(p_devp: *Developer, p_value: [*:0]const u8, p_locale: ?[*:0]const u8) void;
    pub const setName = as_developer_set_name;

    extern fn as_developer_get_type() usize;
    pub const getGObjectType = as_developer_get_type;

    extern fn g_object_ref(p_self: *appstream.Developer) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstream.Developer) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Developer, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const Icon = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstream.IconClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `appstream.Icon`.
    extern fn as_icon_new() *appstream.Icon;
    pub const new = as_icon_new;

    extern fn as_icon_get_filename(p_icon: *Icon) [*:0]const u8;
    pub const getFilename = as_icon_get_filename;

    extern fn as_icon_get_height(p_icon: *Icon) c_uint;
    pub const getHeight = as_icon_get_height;

    /// Gets the icon kind.
    extern fn as_icon_get_kind(p_icon: *Icon) appstream.IconKind;
    pub const getKind = as_icon_get_kind;

    extern fn as_icon_get_name(p_icon: *Icon) [*:0]const u8;
    pub const getName = as_icon_get_name;

    extern fn as_icon_get_scale(p_icon: *Icon) c_uint;
    pub const getScale = as_icon_get_scale;

    /// Gets the icon URL, pointing at a remote location. HTTPS and FTP urls are allowed.
    /// This property is only set for icons of type `AS_ICON_KIND_REMOTE`
    extern fn as_icon_get_url(p_icon: *Icon) [*:0]const u8;
    pub const getUrl = as_icon_get_url;

    extern fn as_icon_get_width(p_icon: *Icon) c_uint;
    pub const getWidth = as_icon_get_width;

    /// Sets the icon absolute filename.
    extern fn as_icon_set_filename(p_icon: *Icon, p_filename: [*:0]const u8) void;
    pub const setFilename = as_icon_set_filename;

    /// Sets the icon height.
    extern fn as_icon_set_height(p_icon: *Icon, p_height: c_uint) void;
    pub const setHeight = as_icon_set_height;

    /// Sets the icon kind.
    extern fn as_icon_set_kind(p_icon: *Icon, p_kind: appstream.IconKind) void;
    pub const setKind = as_icon_set_kind;

    /// Sets the stock name or basename to use for the icon.
    extern fn as_icon_set_name(p_icon: *Icon, p_name: [*:0]const u8) void;
    pub const setName = as_icon_set_name;

    /// Sets the icon scaling factor used for HiDPI displays.
    extern fn as_icon_set_scale(p_icon: *Icon, p_scale: c_uint) void;
    pub const setScale = as_icon_set_scale;

    /// Sets the icon URL.
    extern fn as_icon_set_url(p_icon: *Icon, p_url: [*:0]const u8) void;
    pub const setUrl = as_icon_set_url;

    /// Sets the icon width.
    extern fn as_icon_set_width(p_icon: *Icon, p_width: c_uint) void;
    pub const setWidth = as_icon_set_width;

    extern fn as_icon_get_type() usize;
    pub const getGObjectType = as_icon_get_type;

    extern fn g_object_ref(p_self: *appstream.Icon) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstream.Icon) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Icon, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const Image = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstream.ImageClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `appstream.Image`.
    extern fn as_image_new() *appstream.Image;
    pub const new = as_image_new;

    /// Gets the image height.
    extern fn as_image_get_height(p_image: *Image) c_uint;
    pub const getHeight = as_image_get_height;

    /// Gets the image kind.
    extern fn as_image_get_kind(p_image: *Image) appstream.ImageKind;
    pub const getKind = as_image_get_kind;

    /// Get locale for this image.
    extern fn as_image_get_locale(p_image: *Image) [*:0]const u8;
    pub const getLocale = as_image_get_locale;

    /// Gets the image integer scale factor.
    extern fn as_image_get_scale(p_image: *Image) c_uint;
    pub const getScale = as_image_get_scale;

    /// Gets the full qualified URL for the image, usually pointing at some mirror.
    extern fn as_image_get_url(p_image: *Image) [*:0]const u8;
    pub const getUrl = as_image_get_url;

    /// Gets the image width.
    extern fn as_image_get_width(p_image: *Image) c_uint;
    pub const getWidth = as_image_get_width;

    /// Sets the image height.
    extern fn as_image_set_height(p_image: *Image, p_height: c_uint) void;
    pub const setHeight = as_image_set_height;

    /// Sets the image kind.
    extern fn as_image_set_kind(p_image: *Image, p_kind: appstream.ImageKind) void;
    pub const setKind = as_image_set_kind;

    /// Sets the locale for this image.
    extern fn as_image_set_locale(p_image: *Image, p_locale: [*:0]const u8) void;
    pub const setLocale = as_image_set_locale;

    /// Sets the image scale factor.
    extern fn as_image_set_scale(p_image: *Image, p_scale: c_uint) void;
    pub const setScale = as_image_set_scale;

    /// Sets the fully-qualified mirror URL to use for the image.
    extern fn as_image_set_url(p_image: *Image, p_url: [*:0]const u8) void;
    pub const setUrl = as_image_set_url;

    /// Sets the image width.
    extern fn as_image_set_width(p_image: *Image, p_width: c_uint) void;
    pub const setWidth = as_image_set_width;

    extern fn as_image_get_type() usize;
    pub const getGObjectType = as_image_get_type;

    extern fn g_object_ref(p_self: *appstream.Image) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstream.Image) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Image, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const Issue = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstream.IssueClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `appstream.Issue`.
    extern fn as_issue_new() *appstream.Issue;
    pub const new = as_issue_new;

    /// Gets the issue ID (usually a bug number or CVE ID)
    extern fn as_issue_get_id(p_issue: *Issue) [*:0]const u8;
    pub const getId = as_issue_get_id;

    /// Gets the issue type.
    extern fn as_issue_get_kind(p_issue: *Issue) appstream.IssueKind;
    pub const getKind = as_issue_get_kind;

    /// Gets the URL associacted with this issue, usually
    /// referencing a bug report or issue description.
    extern fn as_issue_get_url(p_issue: *Issue) [*:0]const u8;
    pub const getUrl = as_issue_get_url;

    /// Sets the issue ID.
    extern fn as_issue_set_id(p_issue: *Issue, p_id: [*:0]const u8) void;
    pub const setId = as_issue_set_id;

    /// Sets the issue type.
    extern fn as_issue_set_kind(p_issue: *Issue, p_kind: appstream.IssueKind) void;
    pub const setKind = as_issue_set_kind;

    /// Sets an URL describing this issue.
    extern fn as_issue_set_url(p_issue: *Issue, p_url: [*:0]const u8) void;
    pub const setUrl = as_issue_set_url;

    extern fn as_issue_get_type() usize;
    pub const getGObjectType = as_issue_get_type;

    extern fn g_object_ref(p_self: *appstream.Issue) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstream.Issue) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Issue, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const Launchable = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstream.LaunchableClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `appstream.Launchable`.
    extern fn as_launchable_new() *appstream.Launchable;
    pub const new = as_launchable_new;

    /// Add a new launchable entry.
    extern fn as_launchable_add_entry(p_launch: *Launchable, p_entry: [*:0]const u8) void;
    pub const addEntry = as_launchable_add_entry;

    /// Get an array of launchable entries.
    extern fn as_launchable_get_entries(p_launch: *Launchable) *glib.PtrArray;
    pub const getEntries = as_launchable_get_entries;

    /// The launch system for the entries this `appstream.Launchable`
    /// object stores.
    extern fn as_launchable_get_kind(p_launch: *Launchable) appstream.LaunchableKind;
    pub const getKind = as_launchable_get_kind;

    /// Set the launch system for the entries this `appstream.Launchable`
    /// object stores.
    extern fn as_launchable_set_kind(p_launch: *Launchable, p_kind: appstream.LaunchableKind) void;
    pub const setKind = as_launchable_set_kind;

    extern fn as_launchable_get_type() usize;
    pub const getGObjectType = as_launchable_get_type;

    extern fn g_object_ref(p_self: *appstream.Launchable) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstream.Launchable) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Launchable, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const Metadata = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstream.MetadataClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Guesses the AppStream metadata style (metainfo or catalog) based on
    /// the filename.
    extern fn as_metadata_file_guess_style(p_filename: [*:0]const u8) appstream.FormatStyle;
    pub const fileGuessStyle = as_metadata_file_guess_style;

    /// Creates a new `appstream.Metadata`.
    extern fn as_metadata_new() *appstream.Metadata;
    pub const new = as_metadata_new;

    /// Add an `appstream.Component` to the list of components.
    /// This can be used to add multiple components in order to
    /// produce a distro-XML AppStream metadata file.
    extern fn as_metadata_add_component(p_metad: *Metadata, p_cpt: *appstream.Component) void;
    pub const addComponent = as_metadata_add_component;

    /// Remove all previously parsed or manually added components.
    extern fn as_metadata_clear_components(p_metad: *Metadata) void;
    pub const clearComponents = as_metadata_clear_components;

    /// Remove all previously parsed releases entries.
    extern fn as_metadata_clear_releases(p_metad: *Metadata) void;
    pub const clearReleases = as_metadata_clear_releases;

    /// Convert an `appstream.Component` to metainfo data.
    /// This will always be XML, YAML is no valid format for metainfo files.
    ///
    /// The amount of localization included in the metadata depends on how the `appstream.Component`
    /// was initially loaded and whether it contains data for all locale.
    ///
    /// The first `appstream.Component` added to the internal list will be transformed.
    /// In case no component is present, `NULL` is returned.
    extern fn as_metadata_component_to_metainfo(p_metad: *Metadata, p_format: appstream.FormatKind, p_error: ?*?*glib.Error) ?[*:0]u8;
    pub const componentToMetainfo = as_metadata_component_to_metainfo;

    /// Serialize all `appstream.Component` instances into AppStream
    /// catalog metadata.
    /// `NULL` is returned if there is nothing to serialize.
    extern fn as_metadata_components_to_catalog(p_metad: *Metadata, p_format: appstream.FormatKind, p_error: ?*?*glib.Error) ?[*:0]u8;
    pub const componentsToCatalog = as_metadata_components_to_catalog;

    extern fn as_metadata_get_architecture(p_metad: *Metadata) [*:0]const u8;
    pub const getArchitecture = as_metadata_get_architecture;

    /// Gets the `appstream.Component` which has been parsed from the XML.
    /// If the AppStream XML contained multiple components, return the last
    /// component that has been parsed.
    extern fn as_metadata_get_component(p_metad: *Metadata) ?*appstream.Component;
    pub const getComponent = as_metadata_get_component;

    extern fn as_metadata_get_components(p_metad: *Metadata) *appstream.ComponentBox;
    pub const getComponents = as_metadata_get_components;

    /// Get the metadata parsing mode.
    extern fn as_metadata_get_format_style(p_metad: *Metadata) appstream.FormatStyle;
    pub const getFormatStyle = as_metadata_get_format_style;

    extern fn as_metadata_get_format_version(p_metad: *Metadata) appstream.FormatVersion;
    pub const getFormatVersion = as_metadata_get_format_version;

    /// Gets the current active locale for parsing metadata,
    /// or "ALL" if all locales are read.
    extern fn as_metadata_get_locale(p_metad: *Metadata) [*:0]const u8;
    pub const getLocale = as_metadata_get_locale;

    extern fn as_metadata_get_media_baseurl(p_metad: *Metadata) [*:0]const u8;
    pub const getMediaBaseurl = as_metadata_get_media_baseurl;

    extern fn as_metadata_get_origin(p_metad: *Metadata) [*:0]const u8;
    pub const getOrigin = as_metadata_get_origin;

    /// Get the metadata parse flags.
    extern fn as_metadata_get_parse_flags(p_metad: *Metadata) appstream.ParseFlags;
    pub const getParseFlags = as_metadata_get_parse_flags;

    /// Gets the recently parsed `appstream.ReleaseList` entry.
    extern fn as_metadata_get_release_list(p_metad: *Metadata) ?*appstream.ReleaseList;
    pub const getReleaseList = as_metadata_get_release_list;

    extern fn as_metadata_get_release_lists(p_metad: *Metadata) *glib.PtrArray;
    pub const getReleaseLists = as_metadata_get_release_lists;

    extern fn as_metadata_get_update_existing(p_metad: *Metadata) c_int;
    pub const getUpdateExisting = as_metadata_get_update_existing;

    extern fn as_metadata_get_write_header(p_metad: *Metadata) c_int;
    pub const getWriteHeader = as_metadata_get_write_header;

    /// Parses any AppStream metadata into one or more `appstream.Component` instances.
    extern fn as_metadata_parse_bytes(p_metad: *Metadata, p_bytes: *glib.Bytes, p_format: appstream.FormatKind, p_error: ?*?*glib.Error) c_int;
    pub const parseBytes = as_metadata_parse_bytes;

    /// Parses any AppStream metadata into one or more `appstream.Component` instances.
    extern fn as_metadata_parse_data(p_metad: *Metadata, p_data: [*:0]const u8, p_data_len: isize, p_format: appstream.FormatKind, p_error: ?*?*glib.Error) c_int;
    pub const parseData = as_metadata_parse_data;

    /// Parses XDG Desktop Entry metadata and adds it to the list of parsed entities.
    ///
    /// Please note that not every desktop-entry file will result in a valid component
    /// being generated, even if parsing succeeds without error (The desktiop-entry file
    /// may be valid but not generate a component on purpose).
    extern fn as_metadata_parse_desktop_data(p_metad: *Metadata, p_cid: [*:0]const u8, p_data: [*:0]const u8, p_data_len: isize, p_error: ?*?*glib.Error) c_int;
    pub const parseDesktopData = as_metadata_parse_desktop_data;

    /// Parses an AppStream upstream metadata file.
    ///
    /// If `file` does not exist, `G_IO_ERROR_NOT_FOUND` will be returned. Other
    /// `GIOErrors` and `AsMetadataErrors` may be returned as appropriate.
    extern fn as_metadata_parse_file(p_metad: *Metadata, p_file: *gio.File, p_format: appstream.FormatKind, p_error: ?*?*glib.Error) c_int;
    pub const parseFile = as_metadata_parse_file;

    /// Parses any AppStream release metadata into `appstream.Release` objects.
    /// You can retrieve the last parsed `appstream.ReleaseList` using `appstream.Metadata.getReleaseList`.
    extern fn as_metadata_parse_releases_bytes(p_metad: *Metadata, p_bytes: *glib.Bytes, p_error: ?*?*glib.Error) c_int;
    pub const parseReleasesBytes = as_metadata_parse_releases_bytes;

    /// Parses any AppStream release metadata into `appstream.Release` objects
    /// using the provided file.
    /// You can retrieve the last parsed `appstream.ReleaseList` using `appstream.Metadata.getReleaseList`.
    extern fn as_metadata_parse_releases_file(p_metad: *Metadata, p_file: *gio.File, p_error: ?*?*glib.Error) c_int;
    pub const parseReleasesFile = as_metadata_parse_releases_file;

    /// Convert a releases of an `appstream.ReleaseList` entity into a release metadata XML representation.
    extern fn as_metadata_releases_to_data(p_metad: *Metadata, p_releases: *appstream.ReleaseList, p_error: ?*?*glib.Error) ?[*:0]u8;
    pub const releasesToData = as_metadata_releases_to_data;

    /// Serialize all `appstream.Component` instances to XML or YAML metadata and save
    /// the data to a file.
    /// An existing file at the same location will be overridden.
    extern fn as_metadata_save_catalog(p_metad: *Metadata, p_fname: [*:0]const u8, p_format: appstream.FormatKind, p_error: ?*?*glib.Error) c_int;
    pub const saveCatalog = as_metadata_save_catalog;

    /// Serialize `appstream.Component` instance to XML and save it to file.
    /// An existing file at the same location will be overridden.
    extern fn as_metadata_save_metainfo(p_metad: *Metadata, p_fname: [*:0]const u8, p_format: appstream.FormatKind, p_error: ?*?*glib.Error) c_int;
    pub const saveMetainfo = as_metadata_save_metainfo;

    /// Set the architecture the components in this metadata belong to.
    extern fn as_metadata_set_architecture(p_metad: *Metadata, p_arch: [*:0]const u8) void;
    pub const setArchitecture = as_metadata_set_architecture;

    /// Sets the current metadata parsing mode.
    extern fn as_metadata_set_format_style(p_metad: *Metadata, p_mode: appstream.FormatStyle) void;
    pub const setFormatStyle = as_metadata_set_format_style;

    /// Set the current AppStream format version that we should generate data for
    /// or be able to read.
    extern fn as_metadata_set_format_version(p_metad: *Metadata, p_version: appstream.FormatVersion) void;
    pub const setFormatVersion = as_metadata_set_format_version;

    /// Sets the locale which should be read when processing metadata.
    /// All other locales are ignored, which increases parsing speed and
    /// reduces memory usage.
    /// If you set the locale to "ALL", all locales will be read.
    extern fn as_metadata_set_locale(p_metad: *Metadata, p_locale: [*:0]const u8) void;
    pub const setLocale = as_metadata_set_locale;

    /// Set the base URL for all media links referenced in the metadata,
    /// or `NULL` if every component has absolute URLs.
    extern fn as_metadata_set_media_baseurl(p_metad: *Metadata, p_url: [*:0]const u8) void;
    pub const setMediaBaseurl = as_metadata_set_media_baseurl;

    /// Set the origin of AppStream distro metadata
    extern fn as_metadata_set_origin(p_metad: *Metadata, p_origin: [*:0]const u8) void;
    pub const setOrigin = as_metadata_set_origin;

    /// Sets the current metadata parse flags.
    extern fn as_metadata_set_parse_flags(p_metad: *Metadata, p_flags: appstream.ParseFlags) void;
    pub const setParseFlags = as_metadata_set_parse_flags;

    /// If set to `TRUE`, the parser will not create new components but
    /// instead update existing components in the pool with new metadata.
    ///
    /// NOTE: Right now, this feature is only implemented for metainfo XML parsing!
    extern fn as_metadata_set_update_existing(p_metad: *Metadata, p_update: c_int) void;
    pub const setUpdateExisting = as_metadata_set_update_existing;

    /// If set to `TRUE`, tehe metadata writer will omit writing a DEP-11
    /// header document when in YAML mode, and will not write a root components node
    /// when writing XML data.
    /// Please keep in mind that this will create an invalid DEP-11 YAML AppStream
    /// catalog metadata file, and an invalid XML file.
    /// This parameter should only be changed e.g. by the appstream-generator tool.
    ///
    /// NOTE: Right now, this feature is only implemented for YAML!
    extern fn as_metadata_set_write_header(p_metad: *Metadata, p_wheader: c_int) void;
    pub const setWriteHeader = as_metadata_set_write_header;

    extern fn as_metadata_get_type() usize;
    pub const getGObjectType = as_metadata_get_type;

    extern fn g_object_ref(p_self: *appstream.Metadata) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstream.Metadata) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Metadata, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const Pool = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstream.PoolClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {
        pub const changed = struct {
            pub fn call(p_class: anytype, p_pool: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) void {
                return gobject.ext.as(Pool.Class, p_class).f_changed.?(gobject.ext.as(Pool, p_pool));
            }

            pub fn implement(p_class: anytype, p_implementation: *const fn (p_pool: *compat.typeInfo(@TypeOf(p_class)).pointer.child.Instance) callconv(.C) void) void {
                gobject.ext.as(Pool.Class, p_class).f_changed = @ptrCast(p_implementation);
            }
        };
    };

    pub const properties = struct {};

    pub const signals = struct {
        /// The ::changed signal is emitted when components have been added
        /// or removed from the metadata pool.
        pub const changed = struct {
            pub const name = "changed";

            pub fn connect(p_instance: anytype, comptime P_Data: type, p_callback: *const fn (@TypeOf(p_instance), P_Data) callconv(.C) void, p_data: P_Data, p_options: gobject.ext.ConnectSignalOptions(P_Data)) c_ulong {
                return gobject.signalConnectClosureById(
                    @ptrCast(@alignCast(gobject.ext.as(Pool, p_instance))),
                    gobject.signalLookup("changed", Pool.getGObjectType()),
                    glib.quarkFromString(p_options.detail orelse null),
                    gobject.CClosure.new(@ptrCast(p_callback), p_data, @ptrCast(p_options.destroyData)),
                    @intFromBool(p_options.after),
                );
            }
        };
    };

    /// Creates a new `appstream.Pool`.
    extern fn as_pool_new() *appstream.Pool;
    pub const new = as_pool_new;

    /// Register a set of components with the pool temporarily.
    /// Data from components added like this will not be cached.
    extern fn as_pool_add_components(p_pool: *Pool, p_cbox: *appstream.ComponentBox, p_error: ?*?*glib.Error) c_int;
    pub const addComponents = as_pool_add_components;

    /// Add an additional non-standard location to the metadata pool where metadata will be read from.
    /// If `directory` contains a "xml", "xmls", "yaml" or "icons" subdirectory (or all of them),
    /// those paths will be added to the search paths instead.
    extern fn as_pool_add_extra_data_location(p_pool: *Pool, p_directory: [*:0]const u8, p_format_style: appstream.FormatStyle) void;
    pub const addExtraDataLocation = as_pool_add_extra_data_location;

    /// Convenience function to add one or multiple `appstream.PoolFlags` to
    /// the flag set of this data pool.
    extern fn as_pool_add_flags(p_pool: *Pool, p_flags: appstream.PoolFlags) void;
    pub const addFlags = as_pool_add_flags;

    /// Splits up a string into an array of tokens that are suitable for searching.
    /// This includes stripping whitespaces, casefolding the terms and removing greylist words.
    ///
    /// This function is usually called automatically when needed, you will only need to
    /// run it explicitly when you need to check which search tokens the pool will actually
    /// use internally for a given phrase.
    extern fn as_pool_build_search_tokens(p_pool: *Pool, p_search: [*:0]const u8) [*][*:0]u8;
    pub const buildSearchTokens = as_pool_build_search_tokens;

    /// Remove all metadata from the pool, data will be reloaded
    /// once `appstream.Pool.load` is called again.
    extern fn as_pool_clear(p_pool: *Pool) void;
    pub const clear = as_pool_clear;

    /// Get a list of found components.
    extern fn as_pool_get_components(p_pool: *Pool) *appstream.ComponentBox;
    pub const getComponents = as_pool_get_components;

    /// Find components that are provided by a bundle with a specific ID by its prefix.
    /// For example, given a AS_BUNDLE_KIND_FLATPAK and a bundle_id "org.kde.dolphin/",
    /// it will list all the components that bundle dolphin. If the bundle_id is
    /// "org.kde.dolphin/x86_64" it will give those with also the architecture.
    extern fn as_pool_get_components_by_bundle_id(p_pool: *Pool, p_kind: appstream.BundleKind, p_bundle_id: [*:0]const u8, p_match_prefix: c_int) *appstream.ComponentBox;
    pub const getComponentsByBundleId = as_pool_get_components_by_bundle_id;

    /// Return a list of components which are in all of the categories.
    extern fn as_pool_get_components_by_categories(p_pool: *Pool, p_categories: [*][*:0]u8) *appstream.ComponentBox;
    pub const getComponentsByCategories = as_pool_get_components_by_categories;

    /// Find components extending the component with the given ID. They can then be registered to the
    /// `appstream.Component` they extend via `appstream.Component.addAddon`.
    /// If the `AS_POOL_FLAG_RESOLVE_ADDONS` pool flag is set, addons are automatically resolved and
    /// this explicit function is not needed, but overall query time will be increased (so only use
    /// this flag if you will be resolving addon information later anyway).
    extern fn as_pool_get_components_by_extends(p_pool: *Pool, p_extended_id: [*:0]const u8) *appstream.ComponentBox;
    pub const getComponentsByExtends = as_pool_get_components_by_extends;

    /// Get a specific component by its ID.
    /// This function may contain multiple results if we have
    /// data describing this component from multiple scopes/origin types.
    extern fn as_pool_get_components_by_id(p_pool: *Pool, p_cid: [*:0]const u8) *appstream.ComponentBox;
    pub const getComponentsById = as_pool_get_components_by_id;

    /// Return a list of all components in the pool which are of a certain kind.
    extern fn as_pool_get_components_by_kind(p_pool: *Pool, p_kind: appstream.ComponentKind) *appstream.ComponentBox;
    pub const getComponentsByKind = as_pool_get_components_by_kind;

    /// Find components in the AppStream data pool which provide a specific launchable.
    /// See `appstream.Launchable` for details on launchables, or refer to the AppStream specification.
    extern fn as_pool_get_components_by_launchable(p_pool: *Pool, p_kind: appstream.LaunchableKind, p_id: [*:0]const u8) *appstream.ComponentBox;
    pub const getComponentsByLaunchable = as_pool_get_components_by_launchable;

    /// Find components in the AppStream data pool which provide a certain item.
    extern fn as_pool_get_components_by_provided_item(p_pool: *Pool, p_kind: appstream.ProvidedKind, p_item: [*:0]const u8) *appstream.ComponentBox;
    pub const getComponentsByProvidedItem = as_pool_get_components_by_provided_item;

    /// Get the `appstream.PoolFlags` for this data pool.
    extern fn as_pool_get_flags(p_pool: *Pool) appstream.PoolFlags;
    pub const getFlags = as_pool_get_flags;

    /// Gets the currently used locale.
    extern fn as_pool_get_locale(p_pool: *Pool) [*:0]const u8;
    pub const getLocale = as_pool_get_locale;

    /// Check if this pool contains any data.
    extern fn as_pool_is_empty(p_pool: *Pool) c_int;
    pub const isEmpty = as_pool_is_empty;

    /// Builds an index of all found components in the watched locations.
    /// The function will try to get as much data into the pool as possible, so even if
    /// the update completes with `FALSE`, it might still have added components to the pool.
    ///
    /// The function will load from all possible data sources, preferring caches if they
    /// are up to date.
    extern fn as_pool_load(p_pool: *Pool, p_cancellable: ?*gio.Cancellable, p_error: ?*?*glib.Error) c_int;
    pub const load = as_pool_load;

    /// Asynchronously loads data from all registered locations.
    /// Equivalent to `appstream.Pool.load` (but asynchronous)
    extern fn as_pool_load_async(p_pool: *Pool, p_cancellable: ?*gio.Cancellable, p_callback: ?gio.AsyncReadyCallback, p_user_data: ?*anyopaque) void;
    pub const loadAsync = as_pool_load_async;

    /// Retrieve the result of `appstream.Pool.loadAsync`.
    extern fn as_pool_load_finish(p_pool: *Pool, p_result: *gio.AsyncResult, p_error: ?*?*glib.Error) c_int;
    pub const loadFinish = as_pool_load_finish;

    /// Convenience function to remove one or multiple `appstream.PoolFlags` from
    /// the flag set of this data pool.
    extern fn as_pool_remove_flags(p_pool: *Pool, p_flags: appstream.PoolFlags) void;
    pub const removeFlags = as_pool_remove_flags;

    /// Remove all explicitly added metadata locations.
    extern fn as_pool_reset_extra_data_locations(p_pool: *Pool) void;
    pub const resetExtraDataLocations = as_pool_reset_extra_data_locations;

    /// Search for a list of components matching the search term.
    /// The list will be ordered by match score.
    extern fn as_pool_search(p_pool: *Pool, p_search: [*:0]const u8) *appstream.ComponentBox;
    pub const search = as_pool_search;

    /// Set the `appstream.PoolFlags` for this data pool.
    extern fn as_pool_set_flags(p_pool: *Pool, p_flags: appstream.PoolFlags) void;
    pub const setFlags = as_pool_set_flags;

    /// This is a convenience function that enables or disables loading of metadata
    /// from well-known standard locations by configuring the `appstream.PoolFlags` of this
    /// `appstream.Pool` accordingly.
    /// Data affected by this includes the OS data catalog, metainfo, desktop-entry
    /// files and Flatpak data.
    /// If you need more fine-grained control, set the `appstream.PoolFlags` explicitly.
    extern fn as_pool_set_load_std_data_locations(p_pool: *Pool, p_enabled: c_int) void;
    pub const setLoadStdDataLocations = as_pool_set_load_std_data_locations;

    /// Sets the current locale which should be used when parsing metadata.
    extern fn as_pool_set_locale(p_pool: *Pool, p_locale: [*:0]const u8) void;
    pub const setLocale = as_pool_set_locale;

    extern fn as_pool_get_type() usize;
    pub const getGObjectType = as_pool_get_type;

    extern fn g_object_ref(p_self: *appstream.Pool) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstream.Pool) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Pool, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const Provided = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstream.ProvidedClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `appstream.Provided`.
    extern fn as_provided_new() *appstream.Provided;
    pub const new = as_provided_new;

    /// Add a new provided item.
    extern fn as_provided_add_item(p_prov: *Provided, p_item: [*:0]const u8) void;
    pub const addItem = as_provided_add_item;

    /// Get an array of provided data.
    extern fn as_provided_get_items(p_prov: *Provided) *glib.PtrArray;
    pub const getItems = as_provided_get_items;

    /// The kind of items this `appstream.Provided` object stores.
    extern fn as_provided_get_kind(p_prov: *Provided) appstream.ProvidedKind;
    pub const getKind = as_provided_get_kind;

    /// Check if the current `appstream.Provided` contains an item
    /// of the given name.
    extern fn as_provided_has_item(p_prov: *Provided, p_item: [*:0]const u8) c_int;
    pub const hasItem = as_provided_has_item;

    /// Set the kind of items this `appstream.Provided` object stores.
    extern fn as_provided_set_kind(p_prov: *Provided, p_kind: appstream.ProvidedKind) void;
    pub const setKind = as_provided_set_kind;

    extern fn as_provided_get_type() usize;
    pub const getGObjectType = as_provided_get_type;

    extern fn g_object_ref(p_self: *appstream.Provided) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstream.Provided) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Provided, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const Reference = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstream.ReferenceClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `appstream.Reference`.
    extern fn as_reference_new() *appstream.Reference;
    pub const new = as_reference_new;

    /// Gets the reference kind.
    extern fn as_reference_get_kind(p_reference: *Reference) appstream.ReferenceKind;
    pub const getKind = as_reference_get_kind;

    /// Gets the name of the registry this reference is for,
    /// if the reference is of type `AS_REFERENCE_KIND_REGISTRY`.
    /// Otherwise return `NULL`.
    extern fn as_reference_get_registry_name(p_reference: *Reference) ?[*:0]const u8;
    pub const getRegistryName = as_reference_get_registry_name;

    /// Gets the value of this reference, e.g. a DOI if the
    /// reference kind is `AS_REFERENCE_KIND_DOI` or an URL
    /// for `AS_REFERENCE_KIND_CITATION_CFF`.
    extern fn as_reference_get_value(p_reference: *Reference) [*:0]const u8;
    pub const getValue = as_reference_get_value;

    /// Sets the reference kind.
    extern fn as_reference_set_kind(p_reference: *Reference, p_kind: appstream.ReferenceKind) void;
    pub const setKind = as_reference_set_kind;

    /// Sets a name of a registry if this reference is of
    /// type `AS_REFERENCE_KIND_REGISTRY`.
    extern fn as_reference_set_registry_name(p_reference: *Reference, p_name: [*:0]const u8) void;
    pub const setRegistryName = as_reference_set_registry_name;

    /// Sets a value for this reference.
    extern fn as_reference_set_value(p_reference: *Reference, p_value: [*:0]const u8) void;
    pub const setValue = as_reference_set_value;

    extern fn as_reference_get_type() usize;
    pub const getGObjectType = as_reference_get_type;

    extern fn g_object_ref(p_self: *appstream.Reference) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstream.Reference) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Reference, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const Relation = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstream.RelationClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Calculate a compatibility sore between 0 and 100 based on the given set of
    /// AsRelationCheckResults.
    ///
    /// A compatibility of 100 means all requirements are satisfied and the component will
    /// run perfectly on the confoguration it was tested agains, while 0 means it will not run at all.
    extern fn as_relation_check_results_get_compatibility_score(p_rc_results: *glib.PtrArray) c_int;
    pub const checkResultsGetCompatibilityScore = as_relation_check_results_get_compatibility_score;

    /// Creates a new `appstream.Relation`.
    extern fn as_relation_new() *appstream.Relation;
    pub const new = as_relation_new;

    /// The version comparison type.
    extern fn as_relation_get_compare(p_relation: *Relation) appstream.RelationCompare;
    pub const getCompare = as_relation_get_compare;

    /// Gets the display side kind, in case this item is of
    /// kind `AS_RELATION_ITEM_KIND_DISPLAY_LENGTH`
    extern fn as_relation_get_display_side_kind(p_relation: *Relation) appstream.DisplaySideKind;
    pub const getDisplaySideKind = as_relation_get_display_side_kind;

    /// The kind of the item of this `appstream.Relation`.
    extern fn as_relation_get_item_kind(p_relation: *Relation) appstream.RelationItemKind;
    pub const getItemKind = as_relation_get_item_kind;

    /// The type (and thereby strength) of this `appstream.Relation`.
    extern fn as_relation_get_kind(p_relation: *Relation) appstream.RelationKind;
    pub const getKind = as_relation_get_kind;

    /// Get the value of this `appstream.Relation` item as `appstream.ControlKind` if the
    /// type of this relation is `AS_RELATION_ITEM_KIND_CONTROL`.
    /// Otherwise return `AS_CONTROL_KIND_UNKNOWN`
    extern fn as_relation_get_value_control_kind(p_relation: *Relation) appstream.ControlKind;
    pub const getValueControlKind = as_relation_get_value_control_kind;

    extern fn as_relation_get_value_int(p_relation: *Relation) c_int;
    pub const getValueInt = as_relation_get_value_int;

    /// If this `appstream.Relation` is of kind `AS_RELATION_ITEM_KIND_INTERNET`, return the
    /// minimum bandwidth requirement of the component, if set.
    ///
    /// If the relation is of a different kind, or the requirement isn’t set, this
    /// returns `0`.
    extern fn as_relation_get_value_internet_bandwidth(p_relation: *Relation) c_uint;
    pub const getValueInternetBandwidth = as_relation_get_value_internet_bandwidth;

    /// Get the value of this `appstream.Relation` item as `appstream.InternetKind` if the
    /// type of this relation is `AS_RELATION_ITEM_KIND_INTERNET`.
    /// Otherwise return `AS_INTERNET_KIND_UNKNOWN`
    extern fn as_relation_get_value_internet_kind(p_relation: *Relation) appstream.InternetKind;
    pub const getValueInternetKind = as_relation_get_value_internet_kind;

    /// In case this `appstream.Relation` is of kind `AS_RELATION_ITEM_KIND_DISPLAY_LENGTH`,
    /// return the set logical pixel amount.
    extern fn as_relation_get_value_px(p_relation: *Relation) c_int;
    pub const getValuePx = as_relation_get_value_px;

    extern fn as_relation_get_value_str(p_relation: *Relation) [*:0]const u8;
    pub const getValueStr = as_relation_get_value_str;

    extern fn as_relation_get_version(p_relation: *Relation) [*:0]const u8;
    pub const getVersion = as_relation_get_version;

    /// Test if this relation is satisfied on the current system or with the
    /// provided `appstream.Pool`. If no `appstream.SystemInfo` is found, a temporary one will be
    /// created. If no `appstream.Pool` is provided, any component relationships can not
    /// be validated and an error will be thrown.
    extern fn as_relation_is_satisfied(p_relation: *Relation, p_system_info: ?*appstream.SystemInfo, p_pool: ?*appstream.Pool, p_error: ?*?*glib.Error) ?*appstream.RelationCheckResult;
    pub const isSatisfied = as_relation_is_satisfied;

    /// Set the version comparison type of this `appstream.Relation`.
    extern fn as_relation_set_compare(p_relation: *Relation, p_compare: appstream.RelationCompare) void;
    pub const setCompare = as_relation_set_compare;

    /// Sets the display side kind, in case this item is of
    /// kind `AS_RELATION_ITEM_KIND_DISPLAY_LENGTH`
    extern fn as_relation_set_display_side_kind(p_relation: *Relation, p_kind: appstream.DisplaySideKind) void;
    pub const setDisplaySideKind = as_relation_set_display_side_kind;

    /// Set the kind of the item this `appstream.Relation` is about.
    extern fn as_relation_set_item_kind(p_relation: *Relation, p_kind: appstream.RelationItemKind) void;
    pub const setItemKind = as_relation_set_item_kind;

    /// Set the kind of this `appstream.Relation`.
    extern fn as_relation_set_kind(p_relation: *Relation, p_kind: appstream.RelationKind) void;
    pub const setKind = as_relation_set_kind;

    /// Set relation item value from an `appstream.ControlKind`.
    extern fn as_relation_set_value_control_kind(p_relation: *Relation, p_kind: appstream.ControlKind) void;
    pub const setValueControlKind = as_relation_set_value_control_kind;

    /// Sets the item value as an integer, if the given item type
    /// of this `appstream.Relation` permits integer values.
    extern fn as_relation_set_value_int(p_relation: *Relation, p_value: c_int) void;
    pub const setValueInt = as_relation_set_value_int;

    extern fn as_relation_set_value_internet_bandwidth(p_relation: *Relation, p_bandwidth_mbitps: c_uint) void;
    pub const setValueInternetBandwidth = as_relation_set_value_internet_bandwidth;

    /// Set relation item value from an `appstream.InternetKind`.
    extern fn as_relation_set_value_internet_kind(p_relation: *Relation, p_kind: appstream.InternetKind) void;
    pub const setValueInternetKind = as_relation_set_value_internet_kind;

    /// Sets the item value as logical pixel count. This requires the relation
    /// to be of item kind `AS_RELATION_ITEM_KIND_DISPLAY_LENGTH`.
    extern fn as_relation_set_value_px(p_relation: *Relation, p_logical_px: c_int) void;
    pub const setValuePx = as_relation_set_value_px;

    /// Sets the item value as a string, if the given item type
    /// of this `appstream.Relation` permits string values.
    extern fn as_relation_set_value_str(p_relation: *Relation, p_value: [*:0]const u8) void;
    pub const setValueStr = as_relation_set_value_str;

    /// Sets the item version.
    extern fn as_relation_set_version(p_relation: *Relation, p_version: [*:0]const u8) void;
    pub const setVersion = as_relation_set_version;

    /// Tests whether the version number of this `appstream.Relation` is fulfilled by
    /// `version`. Whether the given version is sufficient to fulfill the version
    /// requirement of this `appstream.Relation` is determined by its comparison resraint.
    extern fn as_relation_version_compare(p_relation: *Relation, p_version: [*:0]const u8, p_error: ?*?*glib.Error) c_int;
    pub const versionCompare = as_relation_version_compare;

    extern fn as_relation_get_type() usize;
    pub const getGObjectType = as_relation_get_type;

    extern fn g_object_ref(p_self: *appstream.Relation) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstream.Relation) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Relation, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const RelationCheckResult = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstream.RelationCheckResultClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `appstream.RelationCheckResult`.
    extern fn as_relation_check_result_new() *appstream.RelationCheckResult;
    pub const new = as_relation_check_result_new;

    /// Retrieve the error code, in case this result represents an error.
    extern fn as_relation_check_result_get_error_code(p_relcr: *RelationCheckResult) appstream.RelationError;
    pub const getErrorCode = as_relation_check_result_get_error_code;

    /// Get a human-readable message about the state of this relation.
    /// May be `NULL` in case the relation is satisfied and there is no further information about it.
    extern fn as_relation_check_result_get_message(p_relcr: *RelationCheckResult) ?[*:0]const u8;
    pub const getMessage = as_relation_check_result_get_message;

    /// Get the relation that this check result was generated for.
    extern fn as_relation_check_result_get_relation(p_relcr: *RelationCheckResult) ?*appstream.Relation;
    pub const getRelation = as_relation_check_result_get_relation;

    /// Returns the status of this relation check result.
    /// If the status is `AS_RELATION_STATUS_ERROR`, an error message will
    /// have been set as message.
    extern fn as_relation_check_result_get_status(p_relcr: *RelationCheckResult) appstream.RelationStatus;
    pub const getStatus = as_relation_check_result_get_status;

    /// Set the error code in case this result represents an error.
    extern fn as_relation_check_result_set_error_code(p_relcr: *RelationCheckResult, p_ecode: appstream.RelationError) void;
    pub const setErrorCode = as_relation_check_result_set_error_code;

    /// Set a human-readable information message about the satisfaction state
    /// of the dependency under the checked system configuration.
    extern fn as_relation_check_result_set_message(p_relcr: *RelationCheckResult, p_format: [*:0]const u8, ...) void;
    pub const setMessage = as_relation_check_result_set_message;

    /// Set an `appstream.Relation` to associate with this check result.
    extern fn as_relation_check_result_set_relation(p_relcr: *RelationCheckResult, p_relation: *appstream.Relation) void;
    pub const setRelation = as_relation_check_result_set_relation;

    /// Set the outcome of this relation check result.
    extern fn as_relation_check_result_set_status(p_relcr: *RelationCheckResult, p_status: appstream.RelationStatus) void;
    pub const setStatus = as_relation_check_result_set_status;

    extern fn as_relation_check_result_get_type() usize;
    pub const getGObjectType = as_relation_check_result_get_type;

    extern fn g_object_ref(p_self: *appstream.RelationCheckResult) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstream.RelationCheckResult) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *RelationCheckResult, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const Release = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstream.ReleaseClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `appstream.Release`.
    extern fn as_release_new() *appstream.Release;
    pub const new = as_release_new;

    /// Add an artifact (binary / source download) for this release.
    extern fn as_release_add_artifact(p_release: *Release, p_artifact: *appstream.Artifact) void;
    pub const addArtifact = as_release_add_artifact;

    /// Add information about a (resolved) issue to this release.
    extern fn as_release_add_issue(p_release: *Release, p_issue: *appstream.Issue) void;
    pub const addIssue = as_release_add_issue;

    /// Add a tag to this release.
    extern fn as_release_add_tag(p_release: *Release, p_ns: [*:0]const u8, p_tag: [*:0]const u8) c_int;
    pub const addTag = as_release_add_tag;

    /// Remove all tags associated with this release.
    extern fn as_release_clear_tags(p_release: *Release) void;
    pub const clearTags = as_release_clear_tags;

    /// Get a list of all downloadable artifacts that are associated with
    /// this release.
    extern fn as_release_get_artifacts(p_release: *Release) *glib.PtrArray;
    pub const getArtifacts = as_release_get_artifacts;

    extern fn as_release_get_context(p_release: *Release) ?*appstream.Context;
    pub const getContext = as_release_get_context;

    /// Gets the release date.
    extern fn as_release_get_date(p_release: *Release) ?[*:0]const u8;
    pub const getDate = as_release_get_date;

    /// Gets the end-of-life date for this release.
    extern fn as_release_get_date_eol(p_release: *Release) ?[*:0]const u8;
    pub const getDateEol = as_release_get_date_eol;

    /// Gets the release description markup for a given locale.
    extern fn as_release_get_description(p_release: *Release) ?[*:0]const u8;
    pub const getDescription = as_release_get_description;

    /// Get a list of all issues resolved by this release.
    extern fn as_release_get_issues(p_release: *Release) *glib.PtrArray;
    pub const getIssues = as_release_get_issues;

    /// Gets the type of the release.
    /// (development or stable release)
    extern fn as_release_get_kind(p_release: *Release) appstream.ReleaseKind;
    pub const getKind = as_release_get_kind;

    /// Gets the release timestamp.
    extern fn as_release_get_timestamp(p_release: *Release) u64;
    pub const getTimestamp = as_release_get_timestamp;

    /// Gets the UNIX timestamp for the date when this
    /// release is out of support (end-of-life).
    extern fn as_release_get_timestamp_eol(p_release: *Release) u64;
    pub const getTimestampEol = as_release_get_timestamp_eol;

    /// Gets the urgency of the release
    /// (showing how important it is to update to a more recent release)
    extern fn as_release_get_urgency(p_release: *Release) appstream.UrgencyKind;
    pub const getUrgency = as_release_get_urgency;

    /// Gets an URL.
    extern fn as_release_get_url(p_release: *Release, p_url_kind: appstream.ReleaseUrlKind) ?[*:0]const u8;
    pub const getUrl = as_release_get_url;

    /// Gets the release version.
    extern fn as_release_get_version(p_release: *Release) ?[*:0]const u8;
    pub const getVersion = as_release_get_version;

    /// Test if the release is tagged with the selected tag.
    extern fn as_release_has_tag(p_release: *Release, p_ns: [*:0]const u8, p_tag: [*:0]const u8) c_int;
    pub const hasTag = as_release_has_tag;

    /// Remove a tag from this release
    extern fn as_release_remove_tag(p_release: *Release, p_ns: [*:0]const u8, p_tag: [*:0]const u8) c_int;
    pub const removeTag = as_release_remove_tag;

    /// Sets the document context this release is associated
    /// with.
    extern fn as_release_set_context(p_release: *Release, p_context: *appstream.Context) void;
    pub const setContext = as_release_set_context;

    /// Sets the release date.
    extern fn as_release_set_date(p_release: *Release, p_date: [*:0]const u8) void;
    pub const setDate = as_release_set_date;

    /// Sets the end-of-life date for this release.
    extern fn as_release_set_date_eol(p_release: *Release, p_date: [*:0]const u8) void;
    pub const setDateEol = as_release_set_date_eol;

    /// Sets the description release markup.
    extern fn as_release_set_description(p_release: *Release, p_description: [*:0]const u8, p_locale: ?[*:0]const u8) void;
    pub const setDescription = as_release_set_description;

    /// Sets the release kind to distinguish between end-user ready
    /// stable releases and development prereleases..
    extern fn as_release_set_kind(p_release: *Release, p_kind: appstream.ReleaseKind) void;
    pub const setKind = as_release_set_kind;

    /// Sets the release timestamp.
    extern fn as_release_set_timestamp(p_release: *Release, p_timestamp: u64) void;
    pub const setTimestamp = as_release_set_timestamp;

    /// Sets the UNIX timestamp for the date when this
    /// release is out of support (end-of-life).
    extern fn as_release_set_timestamp_eol(p_release: *Release, p_timestamp: u64) void;
    pub const setTimestampEol = as_release_set_timestamp_eol;

    /// Sets the release urgency.
    extern fn as_release_set_urgency(p_release: *Release, p_urgency: appstream.UrgencyKind) void;
    pub const setUrgency = as_release_set_urgency;

    /// Sets an URL for this release.
    extern fn as_release_set_url(p_release: *Release, p_url_kind: appstream.ReleaseUrlKind, p_url: [*:0]const u8) void;
    pub const setUrl = as_release_set_url;

    /// Sets the release version.
    extern fn as_release_set_version(p_release: *Release, p_version: [*:0]const u8) void;
    pub const setVersion = as_release_set_version;

    /// Compare the version numbers of two releases.
    extern fn as_release_vercmp(p_rel1: *Release, p_rel2: *appstream.Release) c_int;
    pub const vercmp = as_release_vercmp;

    extern fn as_release_get_type() usize;
    pub const getGObjectType = as_release_get_type;

    extern fn g_object_ref(p_self: *appstream.Release) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstream.Release) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Release, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ReleaseList = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstream.ReleaseListClass;
    f_parent_instance: gobject.Object,
    f_entries: ?*glib.PtrArray,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `appstream.ReleaseList`.
    extern fn as_release_list_new() *appstream.ReleaseList;
    pub const new = as_release_list_new;

    /// Append a release entry to this `appstream.ReleaseList` container.
    extern fn as_release_list_add(p_rels: *ReleaseList, p_release: *appstream.Release) void;
    pub const add = as_release_list_add;

    /// Remove all release entries from this releases object.
    extern fn as_release_list_clear(p_rels: *ReleaseList) void;
    pub const clear = as_release_list_clear;

    /// Get the `appstream.Context` associated with these releases.
    /// This function may return `NULL` if no context is set
    extern fn as_release_list_get_context(p_rels: *ReleaseList) ?*appstream.Context;
    pub const getContext = as_release_list_get_context;

    /// Get the release entries as `glib.PtrArray`.
    extern fn as_release_list_get_entries(p_rels: *ReleaseList) *glib.PtrArray;
    pub const getEntries = as_release_list_get_entries;

    /// Returns the `appstream.ReleaseListKind` of the release metadata
    /// associated with this component.
    extern fn as_release_list_get_kind(p_rels: *ReleaseList) appstream.ReleaseListKind;
    pub const getKind = as_release_list_get_kind;

    /// Get the amount of components in this box.
    extern fn as_release_list_get_size(p_rels: *ReleaseList) c_uint;
    pub const getSize = as_release_list_get_size;

    /// Get the remote URL to obtain release information from.
    extern fn as_release_list_get_url(p_rels: *ReleaseList) ?[*:0]const u8;
    pub const getUrl = as_release_list_get_url;

    /// Retrieve a release entry at the respective index from the
    /// release entry list.
    extern fn as_release_list_index_safe(p_rels: *ReleaseList, p_index: c_uint) *appstream.Release;
    pub const indexSafe = as_release_list_index_safe;

    /// Check if there are any components present.
    extern fn as_release_list_is_empty(p_rels: *ReleaseList) c_int;
    pub const isEmpty = as_release_list_is_empty;

    /// Load release information from XML bytes.
    extern fn as_release_list_load_from_bytes(p_rels: *ReleaseList, p_context: ?*appstream.Context, p_bytes: *glib.Bytes, p_error: ?*?*glib.Error) c_int;
    pub const loadFromBytes = as_release_list_load_from_bytes;

    /// Sets the document context these releases are associated with.
    extern fn as_release_list_set_context(p_rels: *ReleaseList, p_context: *appstream.Context) void;
    pub const setContext = as_release_list_set_context;

    /// Sets the `appstream.ReleaseListKind` of the release metadata
    /// associated with this component.
    extern fn as_release_list_set_kind(p_rels: *ReleaseList, p_kind: appstream.ReleaseListKind) void;
    pub const setKind = as_release_list_set_kind;

    /// Set the amount of release entries stored.
    extern fn as_release_list_set_size(p_rels: *ReleaseList, p_size: c_uint) void;
    pub const setSize = as_release_list_set_size;

    /// Set a remote URL pointing to an AppStream release info file.
    extern fn as_release_list_set_url(p_rels: *ReleaseList, p_url: [*:0]const u8) void;
    pub const setUrl = as_release_list_set_url;

    /// Sort releases by their release version,
    /// starting with the most recent release.
    extern fn as_release_list_sort(p_rels: *ReleaseList) void;
    pub const sort = as_release_list_sort;

    extern fn as_release_list_get_type() usize;
    pub const getGObjectType = as_release_list_get_type;

    extern fn g_object_ref(p_self: *appstream.ReleaseList) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstream.ReleaseList) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ReleaseList, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const Review = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstream.ReviewClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {
        pub const date = struct {
            pub const name = "date";

            pub const Type = ?*appstream.Review;
        };

        pub const description = struct {
            pub const name = "description";

            pub const Type = ?[*:0]u8;
        };

        pub const flags = struct {
            pub const name = "flags";

            pub const Type = u64;
        };

        pub const id = struct {
            pub const name = "id";

            pub const Type = ?[*:0]u8;
        };

        pub const locale = struct {
            pub const name = "locale";

            pub const Type = ?[*:0]u8;
        };

        /// The priority for the review, where positive numbers indicate
        /// a better review for the specific user.
        pub const priority = struct {
            pub const name = "priority";

            pub const Type = c_int;
        };

        pub const rating = struct {
            pub const name = "rating";

            pub const Type = c_int;
        };

        pub const reviewer_id = struct {
            pub const name = "reviewer-id";

            pub const Type = ?[*:0]u8;
        };

        pub const reviewer_name = struct {
            pub const name = "reviewer-name";

            pub const Type = ?[*:0]u8;
        };

        pub const summary = struct {
            pub const name = "summary";

            pub const Type = ?[*:0]u8;
        };

        pub const version = struct {
            pub const name = "version";

            pub const Type = ?[*:0]u8;
        };
    };

    pub const signals = struct {};

    /// Creates a new `appstream.Review`.
    extern fn as_review_new() *appstream.Review;
    pub const new = as_review_new;

    /// Adds flags to an existing review without replacing the other flags.
    extern fn as_review_add_flags(p_review: *Review, p_flags: appstream.ReviewFlags) void;
    pub const addFlags = as_review_add_flags;

    /// Adds metadata to the review object.
    /// It is left for the the plugin to use this method as required, but a
    /// typical use would be to store some secure authentication token.
    extern fn as_review_add_metadata(p_review: *Review, p_key: [*:0]const u8, p_value: [*:0]const u8) void;
    pub const addMetadata = as_review_add_metadata;

    /// Checks if two reviews are the same.
    extern fn as_review_equal(p_review1: *Review, p_review2: *appstream.Review) c_int;
    pub const equal = as_review_equal;

    /// Gets the date the review was originally submitted.
    extern fn as_review_get_date(p_review: *Review) *glib.DateTime;
    pub const getDate = as_review_get_date;

    /// Gets the multi-line review text that forms the body of the review.
    extern fn as_review_get_description(p_review: *Review) [*:0]const u8;
    pub const getDescription = as_review_get_description;

    /// Gets any flags set on the review, for example if the user has already
    /// voted on the review or if the user wrote the review themselves.
    extern fn as_review_get_flags(p_review: *Review) appstream.ReviewFlags;
    pub const getFlags = as_review_get_flags;

    /// Gets the review id.
    extern fn as_review_get_id(p_review: *Review) [*:0]const u8;
    pub const getId = as_review_get_id;

    /// Gets the locale for the review.
    extern fn as_review_get_locale(p_review: *Review) [*:0]const u8;
    pub const getLocale = as_review_get_locale;

    /// Gets some metadata from a review object.
    /// It is left for the the plugin to use this method as required, but a
    /// typical use would be to retrieve some secure authentication token.
    extern fn as_review_get_metadata_item(p_review: *Review, p_key: [*:0]const u8) [*:0]const u8;
    pub const getMetadataItem = as_review_get_metadata_item;

    /// This allows the UI to sort reviews into the correct order.
    /// Higher numbers indicate a more important or relevant review.
    extern fn as_review_get_priority(p_review: *Review) c_int;
    pub const getPriority = as_review_get_priority;

    /// Gets the star rating of the review, where 100 is 5 stars.
    extern fn as_review_get_rating(p_review: *Review) c_int;
    pub const getRating = as_review_get_rating;

    /// Gets the name of the reviewer.
    extern fn as_review_get_reviewer_id(p_review: *Review) [*:0]const u8;
    pub const getReviewerId = as_review_get_reviewer_id;

    /// Gets the name of the reviewer.
    extern fn as_review_get_reviewer_name(p_review: *Review) [*:0]const u8;
    pub const getReviewerName = as_review_get_reviewer_name;

    /// Gets the review summary.
    extern fn as_review_get_summary(p_review: *Review) [*:0]const u8;
    pub const getSummary = as_review_get_summary;

    /// Gets the version string for the application being reviewed..
    extern fn as_review_get_version(p_review: *Review) [*:0]const u8;
    pub const getVersion = as_review_get_version;

    /// Sets the date the review was originally submitted.
    extern fn as_review_set_date(p_review: *Review, p_date: *glib.DateTime) void;
    pub const setDate = as_review_set_date;

    /// Sets the multi-line review text that forms the body of the review.
    extern fn as_review_set_description(p_review: *Review, p_description: [*:0]const u8) void;
    pub const setDescription = as_review_set_description;

    /// Gets any flags set on the review, for example if the user has already
    /// voted on the review or if the user wrote the review themselves.
    extern fn as_review_set_flags(p_review: *Review, p_flags: appstream.ReviewFlags) void;
    pub const setFlags = as_review_set_flags;

    /// Sets the review identifier that is unique to each review.
    extern fn as_review_set_id(p_review: *Review, p_id: [*:0]const u8) void;
    pub const setId = as_review_set_id;

    /// Sets the locale for the review.
    extern fn as_review_set_locale(p_review: *Review, p_locale: [*:0]const u8) void;
    pub const setLocale = as_review_set_locale;

    /// Sets the priority for the review, where positive numbers indicate
    /// a better review for the specific user.
    extern fn as_review_set_priority(p_review: *Review, p_priority: c_int) void;
    pub const setPriority = as_review_set_priority;

    /// Sets the star rating of the review, where 100 is 5 stars..
    extern fn as_review_set_rating(p_review: *Review, p_rating: c_int) void;
    pub const setRating = as_review_set_rating;

    /// Sets the name of the reviewer, which can be left unset.
    extern fn as_review_set_reviewer_id(p_review: *Review, p_reviewer_id: [*:0]const u8) void;
    pub const setReviewerId = as_review_set_reviewer_id;

    /// Sets the name of the reviewer, which can be left unset.
    extern fn as_review_set_reviewer_name(p_review: *Review, p_reviewer_name: [*:0]const u8) void;
    pub const setReviewerName = as_review_set_reviewer_name;

    /// Sets the one-line summary that may be displayed in bold.
    extern fn as_review_set_summary(p_review: *Review, p_summary: [*:0]const u8) void;
    pub const setSummary = as_review_set_summary;

    /// Sets the version string for the application being reviewed.
    extern fn as_review_set_version(p_review: *Review, p_version: [*:0]const u8) void;
    pub const setVersion = as_review_set_version;

    extern fn as_review_get_type() usize;
    pub const getGObjectType = as_review_get_type;

    extern fn g_object_ref(p_self: *appstream.Review) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstream.Review) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Review, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const Screenshot = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstream.ScreenshotClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `appstream.Screenshot`.
    extern fn as_screenshot_new() *appstream.Screenshot;
    pub const new = as_screenshot_new;

    /// Adds an image to the screenshot.
    extern fn as_screenshot_add_image(p_screenshot: *Screenshot, p_image: *appstream.Image) void;
    pub const addImage = as_screenshot_add_image;

    /// Adds a video to the screenshot.
    extern fn as_screenshot_add_video(p_screenshot: *Screenshot, p_video: *appstream.Video) void;
    pub const addVideo = as_screenshot_add_video;

    /// Remove all images associated with this screenshot.
    extern fn as_screenshot_clear_images(p_screenshot: *Screenshot) void;
    pub const clearImages = as_screenshot_clear_images;

    /// Gets the image caption
    extern fn as_screenshot_get_caption(p_screenshot: *Screenshot) [*:0]const u8;
    pub const getCaption = as_screenshot_get_caption;

    /// Returns the `appstream.Context` associated with this screenshot.
    /// This function may return `NULL` if no context is set.
    extern fn as_screenshot_get_context(p_screenshot: *Screenshot) ?*appstream.Context;
    pub const getContext = as_screenshot_get_context;

    /// Get the GUI environment ID of this screenshot, if any
    /// is associated with it. E.g. "plasma-mobile" or "gnome:dark".
    extern fn as_screenshot_get_environment(p_screenshot: *Screenshot) ?[*:0]const u8;
    pub const getEnvironment = as_screenshot_get_environment;

    /// Gets the AsImage closest to the target size. The `appstream.Image` may not actually
    /// be the requested size, and the application may have to pad / rescale the
    /// image to make it fit.
    /// Only images for the current active locale (or fallback, if images are not localized)
    /// are considered.
    extern fn as_screenshot_get_image(p_screenshot: *Screenshot, p_width: c_uint, p_height: c_uint, p_scale: c_uint) ?*appstream.Image;
    pub const getImage = as_screenshot_get_image;

    /// Gets the images for this screenshots. Only images valid for the current
    /// language are returned. We return all sizes.
    extern fn as_screenshot_get_images(p_screenshot: *Screenshot) *glib.PtrArray;
    pub const getImages = as_screenshot_get_images;

    /// Returns an array of all images we have, regardless of their
    /// size and language.
    extern fn as_screenshot_get_images_all(p_screenshot: *Screenshot) *glib.PtrArray;
    pub const getImagesAll = as_screenshot_get_images_all;

    /// Gets the screenshot kind.
    extern fn as_screenshot_get_kind(p_screenshot: *Screenshot) appstream.ScreenshotKind;
    pub const getKind = as_screenshot_get_kind;

    /// Gets the screenshot media kind.
    extern fn as_screenshot_get_media_kind(p_screenshot: *Screenshot) appstream.ScreenshotMediaKind;
    pub const getMediaKind = as_screenshot_get_media_kind;

    /// Gets the videos for this screenshots. Only videos valid for the current
    /// language selection are returned. We return all sizes.
    extern fn as_screenshot_get_videos(p_screenshot: *Screenshot) *glib.PtrArray;
    pub const getVideos = as_screenshot_get_videos;

    /// Returns an array of all screencast videos we have, regardless of their
    /// size and locale.
    extern fn as_screenshot_get_videos_all(p_screenshot: *Screenshot) *glib.PtrArray;
    pub const getVideosAll = as_screenshot_get_videos_all;

    /// Performs a quick validation on this screenshot
    extern fn as_screenshot_is_valid(p_screenshot: *Screenshot) c_int;
    pub const isValid = as_screenshot_is_valid;

    /// Sets a caption on the screenshot
    extern fn as_screenshot_set_caption(p_screenshot: *Screenshot, p_caption: [*:0]const u8, p_locale: [*:0]const u8) void;
    pub const setCaption = as_screenshot_set_caption;

    /// Sets the document context this screenshot is associated
    /// with.
    extern fn as_screenshot_set_context(p_screenshot: *Screenshot, p_context: *appstream.Context) void;
    pub const setContext = as_screenshot_set_context;

    /// Sets the GUI environment ID of this screenshot.
    extern fn as_screenshot_set_environment(p_screenshot: *Screenshot, p_env_id: ?[*:0]const u8) void;
    pub const setEnvironment = as_screenshot_set_environment;

    /// Sets the screenshot kind.
    extern fn as_screenshot_set_kind(p_screenshot: *Screenshot, p_kind: appstream.ScreenshotKind) void;
    pub const setKind = as_screenshot_set_kind;

    extern fn as_screenshot_get_type() usize;
    pub const getGObjectType = as_screenshot_get_type;

    extern fn g_object_ref(p_self: *appstream.Screenshot) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstream.Screenshot) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Screenshot, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const Suggested = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstream.SuggestedClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `appstream.Suggested`.
    extern fn as_suggested_new() *appstream.Suggested;
    pub const new = as_suggested_new;

    /// Add a component id to this suggested object.
    extern fn as_suggested_add_id(p_suggested: *Suggested, p_cid: [*:0]const u8) void;
    pub const addId = as_suggested_add_id;

    /// Get a list of components id that generated the suggestion
    extern fn as_suggested_get_ids(p_suggested: *Suggested) *glib.PtrArray;
    pub const getIds = as_suggested_get_ids;

    /// Gets the suggested kind.
    extern fn as_suggested_get_kind(p_suggested: *Suggested) appstream.SuggestedKind;
    pub const getKind = as_suggested_get_kind;

    /// Check if the essential properties of this suggestion are
    /// populated with useful data.
    extern fn as_suggested_is_valid(p_suggested: *Suggested) c_int;
    pub const isValid = as_suggested_is_valid;

    /// Sets the suggested kind.
    extern fn as_suggested_set_kind(p_suggested: *Suggested, p_kind: appstream.SuggestedKind) void;
    pub const setKind = as_suggested_set_kind;

    extern fn as_suggested_get_type() usize;
    pub const getGObjectType = as_suggested_get_type;

    extern fn g_object_ref(p_self: *appstream.Suggested) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstream.Suggested) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Suggested, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const SystemInfo = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstream.SystemInfoClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `appstream.SystemInfo`.
    extern fn as_system_info_new() *appstream.SystemInfo;
    pub const new = as_system_info_new;

    /// Creates a new `appstream.SystemInfo` that can be used as a mock system
    /// for the given chassis type, reading (mostly) no information
    /// from the current system.
    ///
    /// This function will try to generate a device most representative of
    /// the given chassis class. This can be useful when testing compatibility
    /// for other devices on a different device that is not of the same chassis
    /// type as the one to be tested.
    extern fn as_system_info_new_template_for_chassis(p_chassis: appstream.ChassisKind, p_error: ?*?*glib.Error) ?*appstream.SystemInfo;
    pub const newTemplateForChassis = as_system_info_new_template_for_chassis;

    /// Return a human readable device name for the given modalias.
    /// Will return the modalias again if no device name could be found,
    /// and returns `NULL` on error.
    /// If `allow_fallback` is set to `FALSE`, this function will return `NULL` and error
    /// `AS_SYSTEM_INFO_ERROR_NOT_FOUND` in case no suitable description could be found.
    extern fn as_system_info_get_device_name_for_modalias(p_sysinfo: *SystemInfo, p_modalias: [*:0]const u8, p_allow_fallback: c_int, p_error: ?*?*glib.Error) ?[*:0]u8;
    pub const getDeviceNameForModalias = as_system_info_get_device_name_for_modalias;

    /// Get the current display length for the given side kind.
    /// If the display size is unknown, this function will return 0.
    extern fn as_system_info_get_display_length(p_sysinfo: *SystemInfo, p_side: appstream.DisplaySideKind) c_ulong;
    pub const getDisplayLength = as_system_info_get_display_length;

    /// Check whether graphical applications can be displayed via X11 or Wayland.
    extern fn as_system_info_get_gui_available(p_sysinfo: *SystemInfo) c_int;
    pub const getGuiAvailable = as_system_info_get_gui_available;

    /// Get the name of the current kernel, e.g. "Linux"
    extern fn as_system_info_get_kernel_name(p_sysinfo: *SystemInfo) [*:0]const u8;
    pub const getKernelName = as_system_info_get_kernel_name;

    /// Get the version of the current kernel, e.g. "6.2.0-2"
    extern fn as_system_info_get_kernel_version(p_sysinfo: *SystemInfo) [*:0]const u8;
    pub const getKernelVersion = as_system_info_get_kernel_version;

    /// Get the current total amount of physical memory in MiB.
    extern fn as_system_info_get_memory_total(p_sysinfo: *SystemInfo) c_ulong;
    pub const getMemoryTotal = as_system_info_get_memory_total;

    /// Get a list of modaliases for all the hardware on this system that has them.
    extern fn as_system_info_get_modaliases(p_sysinfo: *SystemInfo) *glib.PtrArray;
    pub const getModaliases = as_system_info_get_modaliases;

    /// Get the AppStream component ID of the current operating system.
    extern fn as_system_info_get_os_cid(p_sysinfo: *SystemInfo) [*:0]const u8;
    pub const getOsCid = as_system_info_get_os_cid;

    /// Get the homepage URL of the current operating system.
    extern fn as_system_info_get_os_homepage(p_sysinfo: *SystemInfo) [*:0]const u8;
    pub const getOsHomepage = as_system_info_get_os_homepage;

    /// Get the ID of the current operating system.
    extern fn as_system_info_get_os_id(p_sysinfo: *SystemInfo) [*:0]const u8;
    pub const getOsId = as_system_info_get_os_id;

    /// Get the humen-readable name of the current operating system.
    extern fn as_system_info_get_os_name(p_sysinfo: *SystemInfo) [*:0]const u8;
    pub const getOsName = as_system_info_get_os_name;

    /// Get the version string of the current operating system.
    extern fn as_system_info_get_os_version(p_sysinfo: *SystemInfo) [*:0]const u8;
    pub const getOsVersion = as_system_info_get_os_version;

    /// Check if there is a device on this system that matches the given modalias glob.
    extern fn as_system_info_has_device_matching_modalias(p_sysinfo: *SystemInfo, p_modalias_glob: [*:0]const u8) c_int;
    pub const hasDeviceMatchingModalias = as_system_info_has_device_matching_modalias;

    /// Test if the current system has a specific user input control method.
    /// Returns `AS_CHECK_RESULT_UNKNOWN` if we could not test for an input control method,
    /// `AS_CHECK_RESULT_ERROR` on error and `AS_CHECK_RESULT_FALSE` if the control was not found.
    extern fn as_system_info_has_input_control(p_sysinfo: *SystemInfo, p_kind: appstream.ControlKind, p_error: ?*?*glib.Error) appstream.CheckResult;
    pub const hasInputControl = as_system_info_has_input_control;

    /// Receive a path in /sys for the devices with the given modalias.
    extern fn as_system_info_modalias_to_syspath(p_sysinfo: *SystemInfo, p_modalias: [*:0]const u8) [*:0]const u8;
    pub const modaliasToSyspath = as_system_info_modalias_to_syspath;

    /// Set the current display length for the given side kind.
    /// The size needs to be in device-independent pixels, see the
    /// AppStream documentation for more information:
    /// https://freedesktop.org/software/appstream/docs/chap-Metadata.html`tag`-relations-display_length
    extern fn as_system_info_set_display_length(p_sysinfo: *SystemInfo, p_side: appstream.DisplaySideKind, p_value_dip: c_ulong) void;
    pub const setDisplayLength = as_system_info_set_display_length;

    /// Set whether this system has a GUI / desktop environment available.
    extern fn as_system_info_set_gui_available(p_sysinfo: *SystemInfo, p_available: c_int) void;
    pub const setGuiAvailable = as_system_info_set_gui_available;

    /// Explicitly mark a user input control as present or not present on this system.
    extern fn as_system_info_set_input_control(p_sysinfo: *SystemInfo, p_kind: appstream.ControlKind, p_found: c_int) void;
    pub const setInputControl = as_system_info_set_input_control;

    extern fn as_system_info_get_type() usize;
    pub const getGObjectType = as_system_info_get_type;

    extern fn g_object_ref(p_self: *appstream.SystemInfo) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstream.SystemInfo) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *SystemInfo, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const Translation = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstream.TranslationClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `appstream.Translation`.
    extern fn as_translation_new() *appstream.Translation;
    pub const new = as_translation_new;

    /// The ID (e.g. Gettext translation domain) of this translation.
    extern fn as_translation_get_id(p_tr: *Translation) [*:0]const u8;
    pub const getId = as_translation_get_id;

    /// The translation system type.
    extern fn as_translation_get_kind(p_tr: *Translation) appstream.TranslationKind;
    pub const getKind = as_translation_get_kind;

    /// The locale of the source strings for this component. If this has not been
    /// explicitly specified, `en_US` will be returned.
    extern fn as_translation_get_source_locale(p_tr: *Translation) [*:0]const u8;
    pub const getSourceLocale = as_translation_get_source_locale;

    /// Set the ID (e.g. Gettext domain) of this translation.
    extern fn as_translation_set_id(p_tr: *Translation, p_id: [*:0]const u8) void;
    pub const setId = as_translation_set_id;

    /// Set the translation system type.
    extern fn as_translation_set_kind(p_tr: *Translation, p_kind: appstream.TranslationKind) void;
    pub const setKind = as_translation_set_kind;

    /// Set the locale of the source strings for this component. In gettext, this is
    /// referred to as the `C` locale. It’s almost always `en_US`, but for some
    /// components it may not be.
    extern fn as_translation_set_source_locale(p_tr: *Translation, p_locale: ?[*:0]const u8) void;
    pub const setSourceLocale = as_translation_set_source_locale;

    extern fn as_translation_get_type() usize;
    pub const getGObjectType = as_translation_get_type;

    extern fn g_object_ref(p_self: *appstream.Translation) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstream.Translation) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Translation, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const Validator = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstream.ValidatorClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `appstream.Validator`.
    extern fn as_validator_new() *appstream.Validator;
    pub const new = as_validator_new;

    /// Override the severity of a selected tag. For most tags, the severity
    /// can not be lowered to a value that makes a validation
    /// that would otherwise fail pass (so e.g. an ERROR can not become an INFO).
    /// Some tags are explicitly allowed to have their severity lowered to enable
    /// validation of e.g. incomplete metadata during development.
    /// Increasing the severity of any tag is always allowed.
    extern fn as_validator_add_override(p_validator: *Validator, p_tag: [*:0]const u8, p_severity_override: appstream.IssueSeverity, p_error: ?*?*glib.Error) c_int;
    pub const addOverride = as_validator_add_override;

    /// Add release metadata explicitly from bytes.
    extern fn as_validator_add_release_bytes(p_validator: *Validator, p_release_fname: [*:0]const u8, p_release_metadata: *glib.Bytes, p_error: ?*?*glib.Error) c_int;
    pub const addReleaseBytes = as_validator_add_release_bytes;

    /// Add a release metadata file to the validation process.
    extern fn as_validator_add_release_file(p_validator: *Validator, p_release_file: *gio.File, p_error: ?*?*glib.Error) c_int;
    pub const addReleaseFile = as_validator_add_release_file;

    /// Check the current registered values again and return `TRUE`
    /// if no issues were found that would make the previously validated
    /// files fail validation.
    ///
    /// Usually you do not need to call this function explicitly, as
    /// the as_validator_validate_* functions will already return whether
    /// data was valid as return value.
    extern fn as_validator_check_success(p_validator: *Validator) c_int;
    pub const checkSuccess = as_validator_check_success;

    /// Clear all release information that was explicitly added to the
    /// validation process.
    extern fn as_validator_clear_release_data(p_validator: *Validator) void;
    pub const clearReleaseData = as_validator_clear_release_data;

    extern fn as_validator_get_allow_net(p_validator: *Validator) c_int;
    pub const getAllowNet = as_validator_get_allow_net;

    /// Get the number of files for which issues have been found.
    extern fn as_validator_get_issue_files_count(p_validator: *Validator) c_uint;
    pub const getIssueFilesCount = as_validator_get_issue_files_count;

    /// Get a list of found metadata format issues.
    extern fn as_validator_get_issues(p_validator: *Validator) *glib.List;
    pub const getIssues = as_validator_get_issues;

    /// Get a hash table of filenames mapped to lists of issues.
    /// This is useful if validation was requested for multiple files and
    /// a list of issues per-file is desired without prior explicit sorting.
    extern fn as_validator_get_issues_per_file(p_validator: *Validator) *glib.HashTable;
    pub const getIssuesPerFile = as_validator_get_issues_per_file;

    extern fn as_validator_get_report_yaml(p_validator: *Validator, p_error: ?*?*glib.Error) ?[*:0]u8;
    pub const getReportYaml = as_validator_get_report_yaml;

    extern fn as_validator_get_strict(p_validator: *Validator) c_int;
    pub const getStrict = as_validator_get_strict;

    /// Get the explanatory text for a given issue tag.
    extern fn as_validator_get_tag_explanation(p_validator: *Validator, p_tag: [*:0]const u8) [*:0]const u8;
    pub const getTagExplanation = as_validator_get_tag_explanation;

    /// Get the severity for a given issue tag.
    extern fn as_validator_get_tag_severity(p_validator: *Validator, p_tag: [*:0]const u8) appstream.IssueSeverity;
    pub const getTagSeverity = as_validator_get_tag_severity;

    /// Get an array of all tags known to the validator.
    extern fn as_validator_get_tags(p_validator: *Validator) [*][*:0]u8;
    pub const getTags = as_validator_get_tags;

    /// If set to `TRUE`, the validator will be allowed to connect
    /// to the internet to e.g. check URLs for validity.
    extern fn as_validator_set_allow_net(p_validator: *Validator, p_value: c_int) void;
    pub const setAllowNet = as_validator_set_allow_net;

    /// Enable or disable strict mode. In strict mode, any found issue will result
    /// in a failed validation (except for issues of "pedantic" severity).
    /// Otherwise, only a "warning" or "error" will cause the validation to fail.
    extern fn as_validator_set_strict(p_validator: *Validator, p_is_strict: c_int) void;
    pub const setStrict = as_validator_set_strict;

    /// Validate AppStream XML data from a byte array.
    /// Remember to run `as_validator_clear_issues` if you do not want previous
    /// validation runs to affect the outcome of this validation.
    extern fn as_validator_validate_bytes(p_validator: *Validator, p_metadata: *glib.Bytes) c_int;
    pub const validateBytes = as_validator_validate_bytes;

    /// Validate AppStream XML data.
    extern fn as_validator_validate_data(p_validator: *Validator, p_metadata: [*:0]const u8) c_int;
    pub const validateData = as_validator_validate_data;

    /// Validate an AppStream XML file.
    extern fn as_validator_validate_file(p_validator: *Validator, p_metadata_file: *gio.File) c_int;
    pub const validateFile = as_validator_validate_file;

    /// Validate a full directory tree for issues in AppStream metadata.
    extern fn as_validator_validate_tree(p_validator: *Validator, p_root_dir: [*:0]const u8) c_int;
    pub const validateTree = as_validator_validate_tree;

    extern fn as_validator_get_type() usize;
    pub const getGObjectType = as_validator_get_type;

    extern fn g_object_ref(p_self: *appstream.Validator) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstream.Validator) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Validator, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ValidatorIssue = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstream.ValidatorIssueClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `appstream.ValidatorIssue`.
    extern fn as_validator_issue_new() *appstream.ValidatorIssue;
    pub const new = as_validator_issue_new;

    /// The component-id this issue is about.
    extern fn as_validator_issue_get_cid(p_issue: *ValidatorIssue) [*:0]const u8;
    pub const getCid = as_validator_issue_get_cid;

    /// Get an extended explanation on this issue, or return `NULL`
    /// if none is available.
    extern fn as_validator_issue_get_explanation(p_issue: *ValidatorIssue) [*:0]const u8;
    pub const getExplanation = as_validator_issue_get_explanation;

    /// The name of the file this issue was found in.
    extern fn as_validator_issue_get_filename(p_issue: *ValidatorIssue) [*:0]const u8;
    pub const getFilename = as_validator_issue_get_filename;

    /// Get a short context hint for this issue.
    extern fn as_validator_issue_get_hint(p_issue: *ValidatorIssue) [*:0]const u8;
    pub const getHint = as_validator_issue_get_hint;

    /// Gets the line number where this issue was found.
    extern fn as_validator_issue_get_line(p_issue: *ValidatorIssue) c_long;
    pub const getLine = as_validator_issue_get_line;

    /// Builds a string containing all information about the location
    /// where this issue occured that we know about.
    extern fn as_validator_issue_get_location(p_issue: *ValidatorIssue) [*:0]u8;
    pub const getLocation = as_validator_issue_get_location;

    /// Gets the severity of this issue.
    extern fn as_validator_issue_get_severity(p_issue: *ValidatorIssue) appstream.IssueSeverity;
    pub const getSeverity = as_validator_issue_get_severity;

    /// Gets the issue tag string for this issue.
    extern fn as_validator_issue_get_tag(p_issue: *ValidatorIssue) [*:0]const u8;
    pub const getTag = as_validator_issue_get_tag;

    /// Sets the component-id this issue is about.
    extern fn as_validator_issue_set_cid(p_issue: *ValidatorIssue, p_cid: [*:0]const u8) void;
    pub const setCid = as_validator_issue_set_cid;

    /// Set explanatory text for this issue.
    extern fn as_validator_issue_set_explanation(p_issue: *ValidatorIssue, p_explanation: [*:0]const u8) void;
    pub const setExplanation = as_validator_issue_set_explanation;

    /// Sets the name of the file the issue was found in.
    extern fn as_validator_issue_set_filename(p_issue: *ValidatorIssue, p_fname: [*:0]const u8) void;
    pub const setFilename = as_validator_issue_set_filename;

    /// Sets short issue hint.
    extern fn as_validator_issue_set_hint(p_issue: *ValidatorIssue, p_hint: [*:0]const u8) void;
    pub const setHint = as_validator_issue_set_hint;

    /// Sets the line number where this issue was found.
    extern fn as_validator_issue_set_line(p_issue: *ValidatorIssue, p_line: c_long) void;
    pub const setLine = as_validator_issue_set_line;

    /// Sets the severity for this issue.
    extern fn as_validator_issue_set_severity(p_issue: *ValidatorIssue, p_severity: appstream.IssueSeverity) void;
    pub const setSeverity = as_validator_issue_set_severity;

    /// Sets the issue tag.
    extern fn as_validator_issue_set_tag(p_issue: *ValidatorIssue, p_tag: [*:0]const u8) void;
    pub const setTag = as_validator_issue_set_tag;

    extern fn as_validator_issue_get_type() usize;
    pub const getGObjectType = as_validator_issue_get_type;

    extern fn g_object_ref(p_self: *appstream.ValidatorIssue) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstream.ValidatorIssue) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *ValidatorIssue, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const Video = extern struct {
    pub const Parent = gobject.Object;
    pub const Implements = [_]type{};
    pub const Class = appstream.VideoClass;
    f_parent_instance: gobject.Object,

    pub const virtual_methods = struct {};

    pub const properties = struct {};

    pub const signals = struct {};

    /// Creates a new `appstream.Video`.
    extern fn as_video_new() *appstream.Video;
    pub const new = as_video_new;

    /// Gets the video codec, if known.
    extern fn as_video_get_codec_kind(p_video: *Video) appstream.VideoCodecKind;
    pub const getCodecKind = as_video_get_codec_kind;

    /// Gets the video container format, if known.
    extern fn as_video_get_container_kind(p_video: *Video) appstream.VideoContainerKind;
    pub const getContainerKind = as_video_get_container_kind;

    /// Gets the video height, if known.
    extern fn as_video_get_height(p_video: *Video) c_uint;
    pub const getHeight = as_video_get_height;

    /// Get locale for this video.
    extern fn as_video_get_locale(p_video: *Video) [*:0]const u8;
    pub const getLocale = as_video_get_locale;

    /// Gets the full qualified URL for the video, usually pointing at a mirror or CDN server.
    extern fn as_video_get_url(p_video: *Video) [*:0]const u8;
    pub const getUrl = as_video_get_url;

    /// Gets the video width, if known.
    extern fn as_video_get_width(p_video: *Video) c_uint;
    pub const getWidth = as_video_get_width;

    /// Sets the video codec.
    extern fn as_video_set_codec_kind(p_video: *Video, p_kind: appstream.VideoCodecKind) void;
    pub const setCodecKind = as_video_set_codec_kind;

    /// Sets the video container.
    extern fn as_video_set_container_kind(p_video: *Video, p_kind: appstream.VideoContainerKind) void;
    pub const setContainerKind = as_video_set_container_kind;

    /// Sets the video height.
    extern fn as_video_set_height(p_video: *Video, p_height: c_uint) void;
    pub const setHeight = as_video_set_height;

    /// Sets the locale for this video.
    extern fn as_video_set_locale(p_video: *Video, p_locale: [*:0]const u8) void;
    pub const setLocale = as_video_set_locale;

    /// Sets the fully-qualified URL to use for the video.
    extern fn as_video_set_url(p_video: *Video, p_url: [*:0]const u8) void;
    pub const setUrl = as_video_set_url;

    /// Sets the video width.
    extern fn as_video_set_width(p_video: *Video, p_width: c_uint) void;
    pub const setWidth = as_video_set_width;

    extern fn as_video_get_type() usize;
    pub const getGObjectType = as_video_get_type;

    extern fn g_object_ref(p_self: *appstream.Video) void;
    pub const ref = g_object_ref;

    extern fn g_object_unref(p_self: *appstream.Video) void;
    pub const unref = g_object_unref;

    pub fn as(p_instance: *Video, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const AgreementClass = extern struct {
    pub const Instance = appstream.Agreement;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,
    f__as_reserved5: ?*const fn () callconv(.C) void,
    f__as_reserved6: ?*const fn () callconv(.C) void,
    f__as_reserved7: ?*const fn () callconv(.C) void,
    f__as_reserved8: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *AgreementClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const AgreementSectionClass = extern struct {
    pub const Instance = appstream.AgreementSection;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,
    f__as_reserved5: ?*const fn () callconv(.C) void,
    f__as_reserved6: ?*const fn () callconv(.C) void,
    f__as_reserved7: ?*const fn () callconv(.C) void,
    f__as_reserved8: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *AgreementSectionClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ArtifactClass = extern struct {
    pub const Instance = appstream.Artifact;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,
    f__as_reserved5: ?*const fn () callconv(.C) void,
    f__as_reserved6: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *ArtifactClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const BrandingClass = extern struct {
    pub const Instance = appstream.Branding;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,
    f__as_reserved5: ?*const fn () callconv(.C) void,
    f__as_reserved6: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *BrandingClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// A `appstream.BrandingColorIter` structure represents an iterator that can be used
/// to iterate over the accent colors of an `appstream.Branding` object.
/// `appstream.BrandingColorIter` structures are typically allocated on the stack and
/// then initialized with `appstream.BrandingColorIter.init`.
pub const BrandingColorIter = extern struct {
    f_dummy1: ?*anyopaque,
    f_dummy2: c_uint,
    f_dummy3: ?*anyopaque,
    f_dummy4: ?*anyopaque,
    f_dummy5: ?*anyopaque,
    f_dummy6: ?*anyopaque,

    /// Initializes a color iterator for the accent color list and associates it
    /// it with `branding`.
    /// The `appstream.BrandingColorIter` structure is typically allocated on the stack
    /// and does not need to be freed explicitly.
    extern fn as_branding_color_iter_init(p_iter: *BrandingColorIter, p_branding: *appstream.Branding) void;
    pub const init = as_branding_color_iter_init;

    /// Returns the current color entry and advances the iterator.
    /// Example:
    /// ```
    /// AsBrandingColorIter iter;
    /// AsColorKind ckind;
    /// AsColorSchemeKind scheme_preference;
    /// const gchar *color_value;
    ///
    /// as_branding_color_iter_init (&iter, branding);
    /// while (as_branding_color_iter_next (&iter, &ckind, &scheme_preference, &color_value)) {
    ///     // do something with the color data
    /// }
    /// ```
    extern fn as_branding_color_iter_next(p_iter: *BrandingColorIter, p_kind: ?*appstream.ColorKind, p_scheme_preference: ?*appstream.ColorSchemeKind, p_value: ?*[*:0]const u8) c_int;
    pub const next = as_branding_color_iter_next;
};

pub const BundleClass = extern struct {
    pub const Instance = appstream.Bundle;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,
    f__as_reserved5: ?*const fn () callconv(.C) void,
    f__as_reserved6: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *BundleClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const CategoryClass = extern struct {
    pub const Instance = appstream.Category;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *CategoryClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ChecksumClass = extern struct {
    pub const Instance = appstream.Checksum;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,
    f__as_reserved5: ?*const fn () callconv(.C) void,
    f__as_reserved6: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *ChecksumClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ComponentBoxClass = extern struct {
    pub const Instance = appstream.ComponentBox;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,
    f__as_reserved5: ?*const fn () callconv(.C) void,
    f__as_reserved6: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *ComponentBoxClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ComponentClass = extern struct {
    pub const Instance = appstream.Component;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,
    f__as_reserved5: ?*const fn () callconv(.C) void,
    f__as_reserved6: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *ComponentClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ContentRatingClass = extern struct {
    pub const Instance = appstream.ContentRating;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,
    f__as_reserved5: ?*const fn () callconv(.C) void,
    f__as_reserved6: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *ContentRatingClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ContextClass = extern struct {
    pub const Instance = appstream.Context;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,
    f__as_reserved5: ?*const fn () callconv(.C) void,
    f__as_reserved6: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *ContextClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const DeveloperClass = extern struct {
    pub const Instance = appstream.Developer;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,
    f__as_reserved5: ?*const fn () callconv(.C) void,
    f__as_reserved6: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *DeveloperClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const IconClass = extern struct {
    pub const Instance = appstream.Icon;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,
    f__as_reserved5: ?*const fn () callconv(.C) void,
    f__as_reserved6: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *IconClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ImageClass = extern struct {
    pub const Instance = appstream.Image;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,
    f__as_reserved5: ?*const fn () callconv(.C) void,
    f__as_reserved6: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *ImageClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const IssueClass = extern struct {
    pub const Instance = appstream.Issue;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,
    f__as_reserved5: ?*const fn () callconv(.C) void,
    f__as_reserved6: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *IssueClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const LaunchableClass = extern struct {
    pub const Instance = appstream.Launchable;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,
    f__as_reserved5: ?*const fn () callconv(.C) void,
    f__as_reserved6: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *LaunchableClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const MetadataClass = extern struct {
    pub const Instance = appstream.Metadata;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,
    f__as_reserved5: ?*const fn () callconv(.C) void,
    f__as_reserved6: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *MetadataClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const PoolClass = extern struct {
    pub const Instance = appstream.Pool;

    f_parent_class: gobject.ObjectClass,
    f_changed: ?*const fn (p_pool: *appstream.Pool) callconv(.C) void,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,
    f__as_reserved5: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *PoolClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ProvidedClass = extern struct {
    pub const Instance = appstream.Provided;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,
    f__as_reserved5: ?*const fn () callconv(.C) void,
    f__as_reserved6: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *ProvidedClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ReferenceClass = extern struct {
    pub const Instance = appstream.Reference;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,
    f__as_reserved5: ?*const fn () callconv(.C) void,
    f__as_reserved6: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *ReferenceClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const RelationCheckResultClass = extern struct {
    pub const Instance = appstream.RelationCheckResult;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,
    f__as_reserved5: ?*const fn () callconv(.C) void,
    f__as_reserved6: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *RelationCheckResultClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const RelationClass = extern struct {
    pub const Instance = appstream.Relation;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,
    f__as_reserved5: ?*const fn () callconv(.C) void,
    f__as_reserved6: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *RelationClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ReleaseClass = extern struct {
    pub const Instance = appstream.Release;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,
    f__as_reserved5: ?*const fn () callconv(.C) void,
    f__as_reserved6: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *ReleaseClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ReleaseListClass = extern struct {
    pub const Instance = appstream.ReleaseList;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,
    f__as_reserved5: ?*const fn () callconv(.C) void,
    f__as_reserved6: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *ReleaseListClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ReviewClass = extern struct {
    pub const Instance = appstream.Review;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,
    f__as_reserved5: ?*const fn () callconv(.C) void,
    f__as_reserved6: ?*const fn () callconv(.C) void,
    f__as_reserved7: ?*const fn () callconv(.C) void,
    f__as_reserved8: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *ReviewClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ScreenshotClass = extern struct {
    pub const Instance = appstream.Screenshot;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,
    f__as_reserved5: ?*const fn () callconv(.C) void,
    f__as_reserved6: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *ScreenshotClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const SuggestedClass = extern struct {
    pub const Instance = appstream.Suggested;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,
    f__as_reserved5: ?*const fn () callconv(.C) void,
    f__as_reserved6: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *SuggestedClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const SystemInfoClass = extern struct {
    pub const Instance = appstream.SystemInfo;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,
    f__as_reserved5: ?*const fn () callconv(.C) void,
    f__as_reserved6: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *SystemInfoClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const TranslationClass = extern struct {
    pub const Instance = appstream.Translation;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,
    f__as_reserved5: ?*const fn () callconv(.C) void,
    f__as_reserved6: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *TranslationClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ValidatorClass = extern struct {
    pub const Instance = appstream.Validator;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,
    f__as_reserved5: ?*const fn () callconv(.C) void,
    f__as_reserved6: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *ValidatorClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const ValidatorIssueClass = extern struct {
    pub const Instance = appstream.ValidatorIssue;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,
    f__as_reserved5: ?*const fn () callconv(.C) void,
    f__as_reserved6: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *ValidatorIssueClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

pub const VideoClass = extern struct {
    pub const Instance = appstream.Video;

    f_parent_class: gobject.ObjectClass,
    f__as_reserved1: ?*const fn () callconv(.C) void,
    f__as_reserved2: ?*const fn () callconv(.C) void,
    f__as_reserved3: ?*const fn () callconv(.C) void,
    f__as_reserved4: ?*const fn () callconv(.C) void,
    f__as_reserved5: ?*const fn () callconv(.C) void,
    f__as_reserved6: ?*const fn () callconv(.C) void,

    pub fn as(p_instance: *VideoClass, comptime P_T: type) *P_T {
        return gobject.ext.as(P_T, p_instance);
    }
};

/// The kind of the agreement.
pub const AgreementKind = enum(c_int) {
    unknown = 0,
    generic = 1,
    eula = 2,
    privacy = 3,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_agreement_kind_from_string(p_value: [*:0]const u8) appstream.AgreementKind;
    pub const fromString = as_agreement_kind_from_string;

    /// Converts the enumerated value to an text representation.
    extern fn as_agreement_kind_to_string(p_value: appstream.AgreementKind) [*:0]const u8;
    pub const toString = as_agreement_kind_to_string;

    extern fn as_agreement_kind_get_type() usize;
    pub const getGObjectType = as_agreement_kind_get_type;
};

/// The artifact type.
pub const ArtifactKind = enum(c_int) {
    unknown = 0,
    source = 1,
    binary = 2,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_artifact_kind_from_string(p_kind: [*:0]const u8) appstream.ArtifactKind;
    pub const fromString = as_artifact_kind_from_string;

    /// Converts the enumerated value to an text representation.
    extern fn as_artifact_kind_to_string(p_kind: appstream.ArtifactKind) [*:0]const u8;
    pub const toString = as_artifact_kind_to_string;

    extern fn as_artifact_kind_get_type() usize;
    pub const getGObjectType = as_artifact_kind_get_type;
};

/// The bundle type.
pub const BundleKind = enum(c_int) {
    unknown = 0,
    package = 1,
    limba = 2,
    flatpak = 3,
    appimage = 4,
    snap = 5,
    tarball = 6,
    cabinet = 7,
    linglong = 8,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_bundle_kind_from_string(p_bundle_str: [*:0]const u8) appstream.BundleKind;
    pub const fromString = as_bundle_kind_from_string;

    /// Converts the enumerated value to an text representation.
    extern fn as_bundle_kind_to_string(p_kind: appstream.BundleKind) [*:0]const u8;
    pub const toString = as_bundle_kind_to_string;

    extern fn as_bundle_kind_get_type() usize;
    pub const getGObjectType = as_bundle_kind_get_type;
};

/// The type of chassis a computing device is built into.
pub const ChassisKind = enum(c_int) {
    unknown = 0,
    desktop = 1,
    laptop = 2,
    server = 3,
    tablet = 4,
    handset = 5,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_chassis_kind_from_string(p_kind_str: [*:0]const u8) appstream.ChassisKind;
    pub const fromString = as_chassis_kind_from_string;

    /// Converts the enumerated value to a text representation.
    extern fn as_chassis_kind_to_string(p_kind: appstream.ChassisKind) [*:0]const u8;
    pub const toString = as_chassis_kind_to_string;

    extern fn as_chassis_kind_get_type() usize;
    pub const getGObjectType = as_chassis_kind_get_type;
};

/// Result of a check operation.
pub const CheckResult = enum(c_int) {
    @"error" = 0,
    unknown = 1,
    false = 2,
    true = 3,
    _,

    extern fn as_check_result_get_type() usize;
    pub const getGObjectType = as_check_result_get_type;
};

/// Checksums supported by `appstream.Release`
pub const ChecksumKind = enum(c_int) {
    none = 0,
    sha1 = 1,
    sha256 = 2,
    sha512 = 3,
    blake2b = 4,
    blake3 = 5,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_checksum_kind_from_string(p_kind_str: [*:0]const u8) appstream.ChecksumKind;
    pub const fromString = as_checksum_kind_from_string;

    /// Converts the enumerated value to an text representation.
    extern fn as_checksum_kind_to_string(p_kind: appstream.ChecksumKind) [*:0]const u8;
    pub const toString = as_checksum_kind_to_string;

    extern fn as_checksum_kind_get_type() usize;
    pub const getGObjectType = as_checksum_kind_get_type;
};

/// A branding color type.
pub const ColorKind = enum(c_int) {
    unknown = 0,
    primary = 1,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_color_kind_from_string(p_str: [*:0]const u8) appstream.ColorKind;
    pub const fromString = as_color_kind_from_string;

    /// Converts the enumerated value to an text representation.
    extern fn as_color_kind_to_string(p_kind: appstream.ColorKind) [*:0]const u8;
    pub const toString = as_color_kind_to_string;

    extern fn as_color_kind_get_type() usize;
    pub const getGObjectType = as_color_kind_get_type;
};

/// A color scheme type.
pub const ColorSchemeKind = enum(c_int) {
    unknown = 0,
    light = 1,
    dark = 2,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_color_scheme_kind_from_string(p_str: [*:0]const u8) appstream.ColorSchemeKind;
    pub const fromString = as_color_scheme_kind_from_string;

    /// Converts the enumerated value to an text representation.
    extern fn as_color_scheme_kind_to_string(p_kind: appstream.ColorSchemeKind) [*:0]const u8;
    pub const toString = as_color_scheme_kind_to_string;

    extern fn as_color_scheme_kind_get_type() usize;
    pub const getGObjectType = as_color_scheme_kind_get_type;
};

/// The type of an `appstream.Component`.
pub const ComponentKind = enum(c_int) {
    unknown = 0,
    generic = 1,
    desktop_app = 2,
    console_app = 3,
    web_app = 4,
    service = 5,
    addon = 6,
    runtime = 7,
    font = 8,
    codec = 9,
    input_method = 10,
    operating_system = 11,
    firmware = 12,
    driver = 13,
    localization = 14,
    repository = 15,
    icon_theme = 16,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_component_kind_from_string(p_kind_str: [*:0]const u8) appstream.ComponentKind;
    pub const fromString = as_component_kind_from_string;

    /// Converts the enumerated value to an text representation.
    extern fn as_component_kind_to_string(p_kind: appstream.ComponentKind) [*:0]const u8;
    pub const toString = as_component_kind_to_string;

    extern fn as_component_kind_get_type() usize;
    pub const getGObjectType = as_component_kind_get_type;
};

/// Scope of the `appstream.Component` (system-wide or user-scope)
pub const ComponentScope = enum(c_int) {
    unknown = 0,
    system = 1,
    user = 2,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_component_scope_from_string(p_scope_str: [*:0]const u8) appstream.ComponentScope;
    pub const fromString = as_component_scope_from_string;

    /// Converts the enumerated value to an text representation.
    extern fn as_component_scope_to_string(p_scope: appstream.ComponentScope) [*:0]const u8;
    pub const toString = as_component_scope_to_string;

    extern fn as_component_scope_get_type() usize;
    pub const getGObjectType = as_component_scope_get_type;
};

/// A content rating system for a particular territory.
pub const ContentRatingSystem = enum(c_int) {
    unknown = 0,
    incaa = 1,
    acb = 2,
    djctq = 3,
    gsrr = 4,
    pegi = 5,
    kavi = 6,
    usk = 7,
    esra = 8,
    cero = 9,
    oflcnz = 10,
    russia = 11,
    mda = 12,
    grac = 13,
    esrb = 14,
    iarc = 15,
    _,

    /// Format `age` as a human-readable string in the given rating `system`. This is
    /// the way to present system-specific strings in a UI.
    extern fn as_content_rating_system_format_age(p_system: appstream.ContentRatingSystem, p_age: c_uint) ?[*:0]u8;
    pub const formatAge = as_content_rating_system_format_age;

    /// Determine the most appropriate `appstream.ContentRatingSystem` for the given `locale`.
    /// Content rating systems are selected by territory. If no content rating system
    /// seems suitable, `AS_CONTENT_RATING_SYSTEM_IARC` is returned.
    extern fn as_content_rating_system_from_locale(p_locale: [*:0]const u8) appstream.ContentRatingSystem;
    pub const fromLocale = as_content_rating_system_from_locale;

    /// Get the CSM ages corresponding to the entries returned by
    /// `appstream.contentRatingSystemGetFormattedAges` for this `system`.
    extern fn as_content_rating_system_get_csm_ages(p_system: appstream.ContentRatingSystem, p_length_out: *usize) [*]const c_uint;
    pub const getCsmAges = as_content_rating_system_get_csm_ages;

    /// Get an array of all the possible return values of
    /// `appstream.contentRatingSystemFormatAge` for the given `system`. The array is
    /// sorted with youngest CSM age first.
    extern fn as_content_rating_system_get_formatted_ages(p_system: appstream.ContentRatingSystem) [*][*:0]u8;
    pub const getFormattedAges = as_content_rating_system_get_formatted_ages;

    /// Get a human-readable string to identify `system`. `NULL` will be returned for
    /// `AS_CONTENT_RATING_SYSTEM_UNKNOWN`.
    extern fn as_content_rating_system_to_string(p_system: appstream.ContentRatingSystem) ?[*:0]const u8;
    pub const toString = as_content_rating_system_to_string;

    extern fn as_content_rating_system_get_type() usize;
    pub const getGObjectType = as_content_rating_system_get_type;
};

/// The specified level of an content_rating rating ID.
pub const ContentRatingValue = enum(c_int) {
    unknown = 0,
    none = 1,
    mild = 2,
    moderate = 3,
    intense = 4,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_content_rating_value_from_string(p_value: [*:0]const u8) appstream.ContentRatingValue;
    pub const fromString = as_content_rating_value_from_string;

    /// Converts the enumerated value to an text representation.
    extern fn as_content_rating_value_to_string(p_value: appstream.ContentRatingValue) [*:0]const u8;
    pub const toString = as_content_rating_value_to_string;

    extern fn as_content_rating_value_get_type() usize;
    pub const getGObjectType = as_content_rating_value_get_type;
};

/// Kind of an input method for users to control software
pub const ControlKind = enum(c_int) {
    unknown = 0,
    pointing = 1,
    keyboard = 2,
    console = 3,
    touch = 4,
    gamepad = 5,
    voice = 6,
    vision = 7,
    tv_remote = 8,
    tablet = 9,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_control_kind_from_string(p_kind_str: [*:0]const u8) appstream.ControlKind;
    pub const fromString = as_control_kind_from_string;

    /// Converts the enumerated value to a text representation.
    extern fn as_control_kind_to_string(p_kind: appstream.ControlKind) [*:0]const u8;
    pub const toString = as_control_kind_to_string;

    extern fn as_control_kind_get_type() usize;
    pub const getGObjectType = as_control_kind_get_type;
};

/// Side a display_length requirement is for.
pub const DisplaySideKind = enum(c_int) {
    unknown = 0,
    shortest = 1,
    longest = 2,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_display_side_kind_from_string(p_kind_str: [*:0]const u8) appstream.DisplaySideKind;
    pub const fromString = as_display_side_kind_from_string;

    /// Converts the enumerated value to a text representation.
    extern fn as_display_side_kind_to_string(p_kind: appstream.DisplaySideKind) [*:0]const u8;
    pub const toString = as_display_side_kind_to_string;

    extern fn as_display_side_kind_get_type() usize;
    pub const getGObjectType = as_display_side_kind_get_type;
};

/// Format of the AppStream metadata.
pub const FormatKind = enum(c_int) {
    unknown = 0,
    xml = 1,
    yaml = 2,
    desktop_entry = 3,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_format_kind_from_string(p_kind_str: [*:0]const u8) appstream.FormatKind;
    pub const fromString = as_format_kind_from_string;

    /// Converts the enumerated value to an text representation.
    extern fn as_format_kind_to_string(p_kind: appstream.FormatKind) [*:0]const u8;
    pub const toString = as_format_kind_to_string;

    extern fn as_format_kind_get_type() usize;
    pub const getGObjectType = as_format_kind_get_type;
};

/// There are a few differences between AppStream's metainfo files (shipped by upstream projects)
/// and the catalog metadata (shipped by distributors).
/// The data source kind indicates which style we should process.
/// Usually you do not want to set this explicitly.
pub const FormatStyle = enum(c_int) {
    unknown = 0,
    metainfo = 1,
    catalog = 2,
    _,

    extern fn as_format_style_get_type() usize;
    pub const getGObjectType = as_format_style_get_type;
};

/// Format version / API level of the AppStream metadata.
pub const FormatVersion = enum(c_int) {
    unknown = 0,
    v1_0 = 1,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_format_version_from_string(p_version_str: [*:0]const u8) appstream.FormatVersion;
    pub const fromString = as_format_version_from_string;

    /// Converts the enumerated value to an text representation.
    extern fn as_format_version_to_string(p_version: appstream.FormatVersion) [*:0]const u8;
    pub const toString = as_format_version_to_string;

    extern fn as_format_version_get_type() usize;
    pub const getGObjectType = as_format_version_get_type;
};

/// The icon type.
pub const IconKind = enum(c_int) {
    unknown = 0,
    stock = 1,
    cached = 2,
    local = 3,
    remote = 4,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_icon_kind_from_string(p_kind_str: [*:0]const u8) appstream.IconKind;
    pub const fromString = as_icon_kind_from_string;

    /// Converts the enumerated value to an text representation.
    extern fn as_icon_kind_to_string(p_kind: appstream.IconKind) [*:0]const u8;
    pub const toString = as_icon_kind_to_string;

    extern fn as_icon_kind_get_type() usize;
    pub const getGObjectType = as_icon_kind_get_type;
};

/// The image type.
pub const ImageKind = enum(c_int) {
    unknown = 0,
    source = 1,
    thumbnail = 2,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_image_kind_from_string(p_kind: [*:0]const u8) appstream.ImageKind;
    pub const fromString = as_image_kind_from_string;

    /// Converts the enumerated value to an text representation.
    extern fn as_image_kind_to_string(p_kind: appstream.ImageKind) [*:0]const u8;
    pub const toString = as_image_kind_to_string;

    extern fn as_image_kind_get_type() usize;
    pub const getGObjectType = as_image_kind_get_type;
};

/// Different internet connectivity requirements or recommendations for an
/// application.
pub const InternetKind = enum(c_int) {
    unknown = 0,
    always = 1,
    offline_only = 2,
    first_run = 3,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_internet_kind_from_string(p_kind_str: [*:0]const u8) appstream.InternetKind;
    pub const fromString = as_internet_kind_from_string;

    /// Converts the enumerated value to a text representation.
    extern fn as_internet_kind_to_string(p_kind: appstream.InternetKind) [*:0]const u8;
    pub const toString = as_internet_kind_to_string;

    extern fn as_internet_kind_get_type() usize;
    pub const getGObjectType = as_internet_kind_get_type;
};

/// Checksums supported by `appstream.Release`
pub const IssueKind = enum(c_int) {
    unknown = 0,
    generic = 1,
    cve = 2,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_issue_kind_from_string(p_kind_str: [*:0]const u8) appstream.IssueKind;
    pub const fromString = as_issue_kind_from_string;

    /// Converts the enumerated value to an text representation.
    extern fn as_issue_kind_to_string(p_kind: appstream.IssueKind) [*:0]const u8;
    pub const toString = as_issue_kind_to_string;

    extern fn as_issue_kind_get_type() usize;
    pub const getGObjectType = as_issue_kind_get_type;
};

/// The severity of an issue found by `appstream.Validator`
pub const IssueSeverity = enum(c_int) {
    unknown = 0,
    pedantic = 1,
    info = 2,
    warning = 3,
    @"error" = 4,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_issue_severity_from_string(p_str: [*:0]const u8) appstream.IssueSeverity;
    pub const fromString = as_issue_severity_from_string;

    /// Converts the enumerated value to an text representation.
    extern fn as_issue_severity_to_string(p_severity: appstream.IssueSeverity) [*:0]const u8;
    pub const toString = as_issue_severity_to_string;

    extern fn as_issue_severity_get_type() usize;
    pub const getGObjectType = as_issue_severity_get_type;
};

/// Type of launch system the entries belong to.
pub const LaunchableKind = enum(c_int) {
    unknown = 0,
    desktop_id = 1,
    service = 2,
    cockpit_manifest = 3,
    url = 4,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_launchable_kind_from_string(p_kind_str: [*:0]const u8) appstream.LaunchableKind;
    pub const fromString = as_launchable_kind_from_string;

    /// Converts the enumerated value to a text representation.
    extern fn as_launchable_kind_to_string(p_kind: appstream.LaunchableKind) [*:0]const u8;
    pub const toString = as_launchable_kind_to_string;

    extern fn as_launchable_kind_get_type() usize;
    pub const getGObjectType = as_launchable_kind_get_type;
};

/// Text markup types.
pub const MarkupKind = enum(c_int) {
    unknown = 0,
    xml = 1,
    text = 2,
    markdown = 3,
    _,

    extern fn as_markup_kind_get_type() usize;
    pub const getGObjectType = as_markup_kind_get_type;
};

/// Defines how `appstream.Component` data should be merged if the component is
/// set for merge.
pub const MergeKind = enum(c_int) {
    none = 0,
    replace = 1,
    append = 2,
    remove_component = 3,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_merge_kind_from_string(p_kind_str: [*:0]const u8) appstream.MergeKind;
    pub const fromString = as_merge_kind_from_string;

    /// Converts the enumerated value to an text representation.
    extern fn as_merge_kind_to_string(p_kind: appstream.MergeKind) [*:0]const u8;
    pub const toString = as_merge_kind_to_string;

    extern fn as_merge_kind_get_type() usize;
    pub const getGObjectType = as_merge_kind_get_type;
};

/// A metadata processing error.
pub const MetadataError = enum(c_int) {
    failed = 0,
    parse = 1,
    format_unexpected = 2,
    no_component = 3,
    value_missing = 4,
    _,

    extern fn as_metadata_error_quark() glib.Quark;
    pub const quark = as_metadata_error_quark;

    extern fn as_metadata_error_get_type() usize;
    pub const getGObjectType = as_metadata_error_get_type;
};

/// The flags used when installing and removing metadata files.
pub const MetadataLocation = enum(c_int) {
    unknown = 0,
    shared = 1,
    state = 2,
    cache = 3,
    user = 4,
    _,

    extern fn as_metadata_location_get_type() usize;
    pub const getGObjectType = as_metadata_location_get_type;
};

/// A metadata pool error.
pub const PoolError = enum(c_int) {
    failed = 0,
    incomplete = 1,
    collision = 2,
    cache_write_failed = 3,
    cache_damaged = 4,
    _,

    extern fn as_pool_error_quark() glib.Quark;
    pub const quark = as_pool_error_quark;

    extern fn as_pool_error_get_type() usize;
    pub const getGObjectType = as_pool_error_get_type;
};

/// Type of the public interface components can provide.
pub const ProvidedKind = enum(c_int) {
    unknown = 0,
    library = 1,
    binary = 2,
    mediatype = 3,
    font = 4,
    modalias = 5,
    python = 6,
    dbus_system = 7,
    dbus_user = 8,
    firmware_runtime = 9,
    firmware_flashed = 10,
    id = 11,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_provided_kind_from_string(p_kind_str: [*:0]const u8) appstream.ProvidedKind;
    pub const fromString = as_provided_kind_from_string;

    /// Converts the enumerated value to a localized text representation,
    /// using the plural forms (e.g. "Libraries" instead of "Library").
    ///
    /// This can be useful when displaying provided items in GUI dialogs.
    extern fn as_provided_kind_to_l10n_string(p_kind: appstream.ProvidedKind) [*:0]const u8;
    pub const toL10nString = as_provided_kind_to_l10n_string;

    /// Converts the enumerated value to a text representation.
    extern fn as_provided_kind_to_string(p_kind: appstream.ProvidedKind) [*:0]const u8;
    pub const toString = as_provided_kind_to_string;

    extern fn as_provided_kind_get_type() usize;
    pub const getGObjectType = as_provided_kind_get_type;
};

/// A reference type.
pub const ReferenceKind = enum(c_int) {
    unknown = 0,
    doi = 1,
    citation_cff = 2,
    registry = 3,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_reference_kind_from_string(p_str: [*:0]const u8) appstream.ReferenceKind;
    pub const fromString = as_reference_kind_from_string;

    /// Converts the enumerated value to an text representation.
    extern fn as_reference_kind_to_string(p_kind: appstream.ReferenceKind) [*:0]const u8;
    pub const toString = as_reference_kind_to_string;

    extern fn as_reference_kind_get_type() usize;
    pub const getGObjectType = as_reference_kind_get_type;
};

/// The relational comparison type.
pub const RelationCompare = enum(c_int) {
    unknown = 0,
    eq = 1,
    ne = 2,
    lt = 3,
    gt = 4,
    le = 5,
    ge = 6,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_relation_compare_from_string(p_compare_str: [*:0]const u8) appstream.RelationCompare;
    pub const fromString = as_relation_compare_from_string;

    /// Converts the enumerated value to an text representation.
    /// The enum is converted into a two-letter identifier ("eq", "ge", etc.)
    /// for use in the XML representation.
    extern fn as_relation_compare_to_string(p_compare: appstream.RelationCompare) [*:0]const u8;
    pub const toString = as_relation_compare_to_string;

    /// Converts the enumerated value to an text representation.
    /// The enum is converted into an identifier consisting of two
    /// mathematical comparison operators ("==", ">=", etc.)
    /// for use in the YAML representation and user interfaces.
    extern fn as_relation_compare_to_symbols_string(p_compare: appstream.RelationCompare) [*:0]const u8;
    pub const toSymbolsString = as_relation_compare_to_symbols_string;

    extern fn as_relation_compare_get_type() usize;
    pub const getGObjectType = as_relation_compare_get_type;
};

/// The error type.
pub const RelationError = enum(c_int) {
    failed = 0,
    bad_value = 1,
    not_implemented = 2,
    _,

    extern fn as_relation_error_quark() glib.Quark;
    pub const quark = as_relation_error_quark;

    extern fn as_relation_error_get_type() usize;
    pub const getGObjectType = as_relation_error_get_type;
};

/// Type of the item an `appstream.Relation` is for.
pub const RelationItemKind = enum(c_int) {
    unknown = 0,
    id = 1,
    modalias = 2,
    kernel = 3,
    memory = 4,
    firmware = 5,
    control = 6,
    display_length = 7,
    hardware = 8,
    internet = 9,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_relation_item_kind_from_string(p_kind_str: [*:0]const u8) appstream.RelationItemKind;
    pub const fromString = as_relation_item_kind_from_string;

    /// Converts the enumerated value to a text representation.
    extern fn as_relation_item_kind_to_string(p_kind: appstream.RelationItemKind) [*:0]const u8;
    pub const toString = as_relation_item_kind_to_string;

    extern fn as_relation_item_kind_get_type() usize;
    pub const getGObjectType = as_relation_item_kind_get_type;
};

/// Type of a component's relation to other items.
pub const RelationKind = enum(c_int) {
    unknown = 0,
    requires = 1,
    recommends = 2,
    supports = 3,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_relation_kind_from_string(p_kind_str: [*:0]const u8) appstream.RelationKind;
    pub const fromString = as_relation_kind_from_string;

    /// Converts the enumerated value to a text representation.
    extern fn as_relation_kind_to_string(p_kind: appstream.RelationKind) [*:0]const u8;
    pub const toString = as_relation_kind_to_string;

    extern fn as_relation_kind_get_type() usize;
    pub const getGObjectType = as_relation_kind_get_type;
};

/// Status of a relation check result.
pub const RelationStatus = enum(c_int) {
    unknown = 0,
    @"error" = 1,
    not_satisfied = 2,
    satisfied = 3,
    _,

    extern fn as_relation_status_get_type() usize;
    pub const getGObjectType = as_relation_status_get_type;
};

/// The release kind.
pub const ReleaseKind = enum(c_int) {
    unknown = 0,
    stable = 1,
    development = 2,
    snapshot = 3,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_release_kind_from_string(p_kind_str: [*:0]const u8) appstream.ReleaseKind;
    pub const fromString = as_release_kind_from_string;

    /// Converts the enumerated value to an text representation.
    extern fn as_release_kind_to_string(p_kind: appstream.ReleaseKind) [*:0]const u8;
    pub const toString = as_release_kind_to_string;

    extern fn as_release_kind_get_type() usize;
    pub const getGObjectType = as_release_kind_get_type;
};

/// The kind of a releases block.
pub const ReleaseListKind = enum(c_int) {
    unknown = 0,
    embedded = 1,
    external = 2,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_release_list_kind_from_string(p_kind_str: [*:0]const u8) appstream.ReleaseListKind;
    pub const fromString = as_release_list_kind_from_string;

    /// Converts the enumerated value to an text representation.
    extern fn as_release_list_kind_to_string(p_kind: appstream.ReleaseListKind) [*:0]const u8;
    pub const toString = as_release_list_kind_to_string;

    extern fn as_release_list_kind_get_type() usize;
    pub const getGObjectType = as_release_list_kind_get_type;
};

/// `AS_RELEASE_URL_KIND_UNKNOWN`        Unknown release web URL type
/// The release URL kinds.
pub const ReleaseUrlKind = enum(c_int) {
    unknown = 0,
    details = 1,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_release_url_kind_from_string(p_kind_str: [*:0]const u8) appstream.ReleaseUrlKind;
    pub const fromString = as_release_url_kind_from_string;

    /// Converts the enumerated value to an text representation.
    extern fn as_release_url_kind_to_string(p_kind: appstream.ReleaseUrlKind) [*:0]const u8;
    pub const toString = as_release_url_kind_to_string;

    extern fn as_release_url_kind_get_type() usize;
    pub const getGObjectType = as_release_url_kind_get_type;
};

/// The screenshot type.
pub const ScreenshotKind = enum(c_int) {
    unknown = 0,
    default = 1,
    extra = 2,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_screenshot_kind_from_string(p_kind: [*:0]const u8) appstream.ScreenshotKind;
    pub const fromString = as_screenshot_kind_from_string;

    /// Converts the enumerated value to an text representation.
    extern fn as_screenshot_kind_to_string(p_kind: appstream.ScreenshotKind) [*:0]const u8;
    pub const toString = as_screenshot_kind_to_string;

    extern fn as_screenshot_kind_get_type() usize;
    pub const getGObjectType = as_screenshot_kind_get_type;
};

/// The media kind contained in this screenshot.
pub const ScreenshotMediaKind = enum(c_int) {
    unknown = 0,
    image = 1,
    video = 2,
    _,

    extern fn as_screenshot_media_kind_get_type() usize;
    pub const getGObjectType = as_screenshot_media_kind_get_type;
};

/// The artifact size kind.
pub const SizeKind = enum(c_int) {
    unknown = 0,
    download = 1,
    installed = 2,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_size_kind_from_string(p_size_kind: [*:0]const u8) appstream.SizeKind;
    pub const fromString = as_size_kind_from_string;

    /// Converts the enumerated value to an text representation.
    extern fn as_size_kind_to_string(p_size_kind: appstream.SizeKind) [*:0]const u8;
    pub const toString = as_size_kind_to_string;

    extern fn as_size_kind_get_type() usize;
    pub const getGObjectType = as_size_kind_get_type;
};

/// The suggested type.
pub const SuggestedKind = enum(c_int) {
    unknown = 0,
    upstream = 1,
    heuristic = 2,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_suggested_kind_from_string(p_kind_str: [*:0]const u8) appstream.SuggestedKind;
    pub const fromString = as_suggested_kind_from_string;

    /// Converts the enumerated value to an text representation.
    extern fn as_suggested_kind_to_string(p_kind: appstream.SuggestedKind) [*:0]const u8;
    pub const toString = as_suggested_kind_to_string;

    extern fn as_suggested_kind_get_type() usize;
    pub const getGObjectType = as_suggested_kind_get_type;
};

/// The error type.
pub const SystemInfoError = enum(c_int) {
    failed = 0,
    not_found = 1,
    _,

    extern fn as_system_info_error_quark() glib.Quark;
    pub const quark = as_system_info_error_quark;

    extern fn as_system_info_error_get_type() usize;
    pub const getGObjectType = as_system_info_error_get_type;
};

/// The translation type.
pub const TranslationKind = enum(c_int) {
    unknown = 0,
    gettext = 1,
    qt = 2,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_translation_kind_from_string(p_kind_str: [*:0]const u8) appstream.TranslationKind;
    pub const fromString = as_translation_kind_from_string;

    /// Converts the enumerated value to a text representation.
    extern fn as_translation_kind_to_string(p_kind: appstream.TranslationKind) [*:0]const u8;
    pub const toString = as_translation_kind_to_string;

    extern fn as_translation_kind_get_type() usize;
    pub const getGObjectType = as_translation_kind_get_type;
};

/// The urgency of an `appstream.Release`
pub const UrgencyKind = enum(c_int) {
    unknown = 0,
    low = 1,
    medium = 2,
    high = 3,
    critical = 4,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_urgency_kind_from_string(p_urgency_kind: [*:0]const u8) appstream.UrgencyKind;
    pub const fromString = as_urgency_kind_from_string;

    /// Converts the enumerated value to an text representation.
    extern fn as_urgency_kind_to_string(p_urgency_kind: appstream.UrgencyKind) [*:0]const u8;
    pub const toString = as_urgency_kind_to_string;

    extern fn as_urgency_kind_get_type() usize;
    pub const getGObjectType = as_urgency_kind_get_type;
};

/// The URL type.
pub const UrlKind = enum(c_int) {
    unknown = 0,
    homepage = 1,
    bugtracker = 2,
    faq = 3,
    help = 4,
    donation = 5,
    translate = 6,
    contact = 7,
    vcs_browser = 8,
    contribute = 9,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_url_kind_from_string(p_url_kind: [*:0]const u8) appstream.UrlKind;
    pub const fromString = as_url_kind_from_string;

    /// Converts the enumerated value to an text representation.
    extern fn as_url_kind_to_string(p_url_kind: appstream.UrlKind) [*:0]const u8;
    pub const toString = as_url_kind_to_string;

    extern fn as_url_kind_get_type() usize;
    pub const getGObjectType = as_url_kind_get_type;
};

/// The error type.
pub const UtilsError = enum(c_int) {
    failed = 0,
    _,

    extern fn as_utils_error_quark() glib.Quark;
    pub const quark = as_utils_error_quark;

    extern fn as_utils_error_get_type() usize;
    pub const getGObjectType = as_utils_error_get_type;
};

/// The error type.
pub const ValidatorError = enum(c_int) {
    failed = 0,
    invalid_override = 1,
    invalid_filename = 2,
    _,

    extern fn as_validator_error_quark() glib.Quark;
    pub const quark = as_validator_error_quark;

    extern fn as_validator_error_get_type() usize;
    pub const getGObjectType = as_validator_error_get_type;
};

/// Supported video codecs.
pub const VideoCodecKind = enum(c_int) {
    unknown = 0,
    vp9 = 1,
    av1 = 2,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_video_codec_kind_from_string(p_str: [*:0]const u8) appstream.VideoCodecKind;
    pub const fromString = as_video_codec_kind_from_string;

    /// Converts the enumerated value to an text representation.
    extern fn as_video_codec_kind_to_string(p_kind: appstream.VideoCodecKind) [*:0]const u8;
    pub const toString = as_video_codec_kind_to_string;

    extern fn as_video_codec_kind_get_type() usize;
    pub const getGObjectType = as_video_codec_kind_get_type;
};

/// Supported video codecs.
pub const VideoContainerKind = enum(c_int) {
    unknown = 0,
    mkv = 1,
    webm = 2,
    _,

    /// Converts the text representation to an enumerated value.
    extern fn as_video_container_kind_from_string(p_str: [*:0]const u8) appstream.VideoContainerKind;
    pub const fromString = as_video_container_kind_from_string;

    /// Converts the enumerated value to an text representation.
    extern fn as_video_container_kind_to_string(p_kind: appstream.VideoContainerKind) [*:0]const u8;
    pub const toString = as_video_container_kind_to_string;

    extern fn as_video_container_kind_get_type() usize;
    pub const getGObjectType = as_video_container_kind_get_type;
};

/// Flags on how caching should be used.
pub const CacheFlags = packed struct(c_uint) {
    use_user: bool = false,
    use_system: bool = false,
    no_clear: bool = false,
    refresh_system: bool = false,
    _padding4: bool = false,
    _padding5: bool = false,
    _padding6: bool = false,
    _padding7: bool = false,
    _padding8: bool = false,
    _padding9: bool = false,
    _padding10: bool = false,
    _padding11: bool = false,
    _padding12: bool = false,
    _padding13: bool = false,
    _padding14: bool = false,
    _padding15: bool = false,
    _padding16: bool = false,
    _padding17: bool = false,
    _padding18: bool = false,
    _padding19: bool = false,
    _padding20: bool = false,
    _padding21: bool = false,
    _padding22: bool = false,
    _padding23: bool = false,
    _padding24: bool = false,
    _padding25: bool = false,
    _padding26: bool = false,
    _padding27: bool = false,
    _padding28: bool = false,
    _padding29: bool = false,
    _padding30: bool = false,
    _padding31: bool = false,

    const flags_none: CacheFlags = @bitCast(@as(c_uint, 0));
    const flags_use_user: CacheFlags = @bitCast(@as(c_uint, 1));
    const flags_use_system: CacheFlags = @bitCast(@as(c_uint, 2));
    const flags_no_clear: CacheFlags = @bitCast(@as(c_uint, 4));
    const flags_refresh_system: CacheFlags = @bitCast(@as(c_uint, 8));
    extern fn as_cache_flags_get_type() usize;
    pub const getGObjectType = as_cache_flags_get_type;
};

/// Flags controlling the component box behavior.
pub const ComponentBoxFlags = packed struct(c_uint) {
    no_checks: bool = false,
    _padding1: bool = false,
    _padding2: bool = false,
    _padding3: bool = false,
    _padding4: bool = false,
    _padding5: bool = false,
    _padding6: bool = false,
    _padding7: bool = false,
    _padding8: bool = false,
    _padding9: bool = false,
    _padding10: bool = false,
    _padding11: bool = false,
    _padding12: bool = false,
    _padding13: bool = false,
    _padding14: bool = false,
    _padding15: bool = false,
    _padding16: bool = false,
    _padding17: bool = false,
    _padding18: bool = false,
    _padding19: bool = false,
    _padding20: bool = false,
    _padding21: bool = false,
    _padding22: bool = false,
    _padding23: bool = false,
    _padding24: bool = false,
    _padding25: bool = false,
    _padding26: bool = false,
    _padding27: bool = false,
    _padding28: bool = false,
    _padding29: bool = false,
    _padding30: bool = false,
    _padding31: bool = false,

    const flags_none: ComponentBoxFlags = @bitCast(@as(c_uint, 0));
    const flags_no_checks: ComponentBoxFlags = @bitCast(@as(c_uint, 1));
    extern fn as_component_box_flags_get_type() usize;
    pub const getGObjectType = as_component_box_flags_get_type;
};

/// The flags used when matching unique IDs.
pub const DataIdMatchFlags = packed struct(c_uint) {
    scope: bool = false,
    bundle_kind: bool = false,
    origin: bool = false,
    id: bool = false,
    branch: bool = false,
    _padding5: bool = false,
    _padding6: bool = false,
    _padding7: bool = false,
    _padding8: bool = false,
    _padding9: bool = false,
    _padding10: bool = false,
    _padding11: bool = false,
    _padding12: bool = false,
    _padding13: bool = false,
    _padding14: bool = false,
    _padding15: bool = false,
    _padding16: bool = false,
    _padding17: bool = false,
    _padding18: bool = false,
    _padding19: bool = false,
    _padding20: bool = false,
    _padding21: bool = false,
    _padding22: bool = false,
    _padding23: bool = false,
    _padding24: bool = false,
    _padding25: bool = false,
    _padding26: bool = false,
    _padding27: bool = false,
    _padding28: bool = false,
    _padding29: bool = false,
    _padding30: bool = false,
    _padding31: bool = false,

    const flags_none: DataIdMatchFlags = @bitCast(@as(c_uint, 0));
    const flags_scope: DataIdMatchFlags = @bitCast(@as(c_uint, 1));
    const flags_bundle_kind: DataIdMatchFlags = @bitCast(@as(c_uint, 2));
    const flags_origin: DataIdMatchFlags = @bitCast(@as(c_uint, 4));
    const flags_id: DataIdMatchFlags = @bitCast(@as(c_uint, 8));
    const flags_branch: DataIdMatchFlags = @bitCast(@as(c_uint, 16));
    extern fn as_data_id_match_flags_get_type() usize;
    pub const getGObjectType = as_data_id_match_flags_get_type;
};

/// Influence certain aspects of how AppStream metadata is parsed.
pub const ParseFlags = packed struct(c_uint) {
    ignore_mediabaseurl: bool = false,
    _padding1: bool = false,
    _padding2: bool = false,
    _padding3: bool = false,
    _padding4: bool = false,
    _padding5: bool = false,
    _padding6: bool = false,
    _padding7: bool = false,
    _padding8: bool = false,
    _padding9: bool = false,
    _padding10: bool = false,
    _padding11: bool = false,
    _padding12: bool = false,
    _padding13: bool = false,
    _padding14: bool = false,
    _padding15: bool = false,
    _padding16: bool = false,
    _padding17: bool = false,
    _padding18: bool = false,
    _padding19: bool = false,
    _padding20: bool = false,
    _padding21: bool = false,
    _padding22: bool = false,
    _padding23: bool = false,
    _padding24: bool = false,
    _padding25: bool = false,
    _padding26: bool = false,
    _padding27: bool = false,
    _padding28: bool = false,
    _padding29: bool = false,
    _padding30: bool = false,
    _padding31: bool = false,

    const flags_none: ParseFlags = @bitCast(@as(c_uint, 0));
    const flags_ignore_mediabaseurl: ParseFlags = @bitCast(@as(c_uint, 1));
    extern fn as_parse_flags_get_type() usize;
    pub const getGObjectType = as_parse_flags_get_type;
};

/// Flags controlling the metadata pool behavior.
pub const PoolFlags = packed struct(c_uint) {
    load_os_catalog: bool = false,
    load_os_metainfo: bool = false,
    load_os_desktop_files: bool = false,
    load_flatpak: bool = false,
    ignore_cache_age: bool = false,
    resolve_addons: bool = false,
    prefer_os_metainfo: bool = false,
    monitor: bool = false,
    _padding8: bool = false,
    _padding9: bool = false,
    _padding10: bool = false,
    _padding11: bool = false,
    _padding12: bool = false,
    _padding13: bool = false,
    _padding14: bool = false,
    _padding15: bool = false,
    _padding16: bool = false,
    _padding17: bool = false,
    _padding18: bool = false,
    _padding19: bool = false,
    _padding20: bool = false,
    _padding21: bool = false,
    _padding22: bool = false,
    _padding23: bool = false,
    _padding24: bool = false,
    _padding25: bool = false,
    _padding26: bool = false,
    _padding27: bool = false,
    _padding28: bool = false,
    _padding29: bool = false,
    _padding30: bool = false,
    _padding31: bool = false,

    const flags_none: PoolFlags = @bitCast(@as(c_uint, 0));
    const flags_load_os_catalog: PoolFlags = @bitCast(@as(c_uint, 1));
    const flags_load_os_metainfo: PoolFlags = @bitCast(@as(c_uint, 2));
    const flags_load_os_desktop_files: PoolFlags = @bitCast(@as(c_uint, 4));
    const flags_load_flatpak: PoolFlags = @bitCast(@as(c_uint, 8));
    const flags_ignore_cache_age: PoolFlags = @bitCast(@as(c_uint, 16));
    const flags_resolve_addons: PoolFlags = @bitCast(@as(c_uint, 32));
    const flags_prefer_os_metainfo: PoolFlags = @bitCast(@as(c_uint, 64));
    const flags_monitor: PoolFlags = @bitCast(@as(c_uint, 128));
    extern fn as_pool_flags_get_type() usize;
    pub const getGObjectType = as_pool_flags_get_type;
};

/// The flags for the review.
pub const ReviewFlags = packed struct(c_uint) {
    self: bool = false,
    voted: bool = false,
    _padding2: bool = false,
    _padding3: bool = false,
    _padding4: bool = false,
    _padding5: bool = false,
    _padding6: bool = false,
    _padding7: bool = false,
    _padding8: bool = false,
    _padding9: bool = false,
    _padding10: bool = false,
    _padding11: bool = false,
    _padding12: bool = false,
    _padding13: bool = false,
    _padding14: bool = false,
    _padding15: bool = false,
    _padding16: bool = false,
    _padding17: bool = false,
    _padding18: bool = false,
    _padding19: bool = false,
    _padding20: bool = false,
    _padding21: bool = false,
    _padding22: bool = false,
    _padding23: bool = false,
    _padding24: bool = false,
    _padding25: bool = false,
    _padding26: bool = false,
    _padding27: bool = false,
    _padding28: bool = false,
    _padding29: bool = false,
    _padding30: bool = false,
    _padding31: bool = false,

    const flags_none: ReviewFlags = @bitCast(@as(c_uint, 0));
    const flags_self: ReviewFlags = @bitCast(@as(c_uint, 1));
    const flags_voted: ReviewFlags = @bitCast(@as(c_uint, 2));
    extern fn as_review_flags_get_type() usize;
    pub const getGObjectType = as_review_flags_get_type;
};

/// Set how values assigned to an `appstream.Component` should be treated when
/// they are set or retrieved.
pub const ValueFlags = packed struct(c_uint) {
    duplicate_check: bool = false,
    no_translation_fallback: bool = false,
    _padding2: bool = false,
    _padding3: bool = false,
    _padding4: bool = false,
    _padding5: bool = false,
    _padding6: bool = false,
    _padding7: bool = false,
    _padding8: bool = false,
    _padding9: bool = false,
    _padding10: bool = false,
    _padding11: bool = false,
    _padding12: bool = false,
    _padding13: bool = false,
    _padding14: bool = false,
    _padding15: bool = false,
    _padding16: bool = false,
    _padding17: bool = false,
    _padding18: bool = false,
    _padding19: bool = false,
    _padding20: bool = false,
    _padding21: bool = false,
    _padding22: bool = false,
    _padding23: bool = false,
    _padding24: bool = false,
    _padding25: bool = false,
    _padding26: bool = false,
    _padding27: bool = false,
    _padding28: bool = false,
    _padding29: bool = false,
    _padding30: bool = false,
    _padding31: bool = false,

    const flags_none: ValueFlags = @bitCast(@as(c_uint, 0));
    const flags_duplicate_check: ValueFlags = @bitCast(@as(c_uint, 1));
    const flags_no_translation_fallback: ValueFlags = @bitCast(@as(c_uint, 2));
    extern fn as_value_flags_get_type() usize;
    pub const getGObjectType = as_value_flags_get_type;
};

/// The flags used when matching unique IDs.
pub const VercmpFlags = packed struct(c_uint) {
    ignore_epoch: bool = false,
    _padding1: bool = false,
    _padding2: bool = false,
    _padding3: bool = false,
    _padding4: bool = false,
    _padding5: bool = false,
    _padding6: bool = false,
    _padding7: bool = false,
    _padding8: bool = false,
    _padding9: bool = false,
    _padding10: bool = false,
    _padding11: bool = false,
    _padding12: bool = false,
    _padding13: bool = false,
    _padding14: bool = false,
    _padding15: bool = false,
    _padding16: bool = false,
    _padding17: bool = false,
    _padding18: bool = false,
    _padding19: bool = false,
    _padding20: bool = false,
    _padding21: bool = false,
    _padding22: bool = false,
    _padding23: bool = false,
    _padding24: bool = false,
    _padding25: bool = false,
    _padding26: bool = false,
    _padding27: bool = false,
    _padding28: bool = false,
    _padding29: bool = false,
    _padding30: bool = false,
    _padding31: bool = false,

    const flags_none: VercmpFlags = @bitCast(@as(c_uint, 0));
    const flags_ignore_epoch: VercmpFlags = @bitCast(@as(c_uint, 1));
    extern fn as_vercmp_flags_get_type() usize;
    pub const getGObjectType = as_vercmp_flags_get_type;
};

/// Returns the component-ID of the current distribution based on contents
/// of the `/etc/os-release` file.
/// This function is a shorthand for `as_distro_details_get_cid`
extern fn as_get_current_distro_component_id() [*:0]u8;
pub const getCurrentDistroComponentId = as_get_current_distro_component_id;

/// Get a list of the default Freedesktop and AppStream categories
/// that software components (especially GUI applications) can be sorted
/// into in software centers.
extern fn as_get_default_categories(p_with_special: c_int) *glib.PtrArray;
pub const getDefaultCategories = as_get_default_categories;

/// Get a list of the default Freedesktop and AppStream categories
/// that software components (especially GUI applications) can be sorted
/// into in software centers.
///
/// This function fully transfers ownership of the returned container,
/// to be used in GIR bindings.
extern fn as_get_default_categories_gi(p_with_special: c_int) *glib.PtrArray;
pub const getDefaultCategoriesGi = as_get_default_categories_gi;

/// Get a translated license name for the given SPDX ID.
extern fn as_get_license_name(p_license: [*:0]const u8) ?[*:0]u8;
pub const getLicenseName = as_get_license_name;

/// Get a web URL to the license text and more license information for an SPDX
/// license identifier.
extern fn as_get_license_url(p_license: [*:0]const u8) ?[*:0]u8;
pub const getLicenseUrl = as_get_license_url;

/// Replaces the string `find` with the string `replace` in a `glib.String` up to
/// `limit` times. If the number of instances of `find` in the `glib.String` is
/// less than `limit`, all instances are replaced. If `limit` is `0`,
/// all instances of `find` are replaced.
extern fn as_gstring_replace(p_string: *glib.String, p_find: [*:0]const u8, p_replace: [*:0]const u8, p_limit: c_uint) c_uint;
pub const gstringReplace = as_gstring_replace;

/// Searches the known list of SPDX license exception IDs.
extern fn as_is_spdx_license_exception_id(p_exception_id: [*:0]const u8) c_int;
pub const isSpdxLicenseExceptionId = as_is_spdx_license_exception_id;

/// Checks the licence string to check it being a valid licence.
/// NOTE: SPDX licenses can't typically contain brackets.
extern fn as_is_spdx_license_expression(p_license: [*:0]const u8) c_int;
pub const isSpdxLicenseExpression = as_is_spdx_license_expression;

/// Searches the known list of SPDX license IDs.
extern fn as_is_spdx_license_id(p_license_id: [*:0]const u8) c_int;
pub const isSpdxLicenseId = as_is_spdx_license_id;

/// Check if the given license is for free-as-in-freedom software.
/// A free software license is either approved by the Free Software Foundation
/// or the Open Source Initiative.
///
/// This function does *not* yet handle complex license expressions with AND and OR.
/// If the expression contains any of these, it will still simply check if all mentioned
/// licenses are Free licenses.
/// Currently, any license exception recognized by SPDX is assumed to not impact the free-ness
/// status of a software component.
///
/// Please note that this function does not give any legal advice. Please read the license texts
/// to learn more about the individual licenses and their conditions.
extern fn as_license_is_free_license(p_license: [*:0]const u8) c_int;
pub const licenseIsFreeLicense = as_license_is_free_license;

/// Check if the metadata license is suitable for mixing with other
/// metadata and redistributing the bundled result (this means we
/// prefer permissive licenses here, to not require people shipping
/// catalog metadata to perform a full license review).
///
/// This method checks against a hardcoded list of permissive licenses
/// commonly used to license metadata under.
extern fn as_license_is_metadata_license(p_license: [*:0]const u8) c_int;
pub const licenseIsMetadataLicense = as_license_is_metadata_license;

/// Tests license ID against the vetted list of licenses that
/// can be used for metainfo metadata.
/// This function will not work for license expressions, if you need
/// to test an SPDX license expression for compliance, please
/// use `appstream.licenseIsMetadataLicense` insread.
extern fn as_license_is_metadata_license_id(p_license_id: [*:0]const u8) c_int;
pub const licenseIsMetadataLicenseId = as_license_is_metadata_license_id;

/// Converts a non-SPDX license into an SPDX format string where possible.
extern fn as_license_to_spdx_id(p_license: [*:0]const u8) [*:0]u8;
pub const licenseToSpdxId = as_license_to_spdx_id;

/// Converts XML description markup into other forms of text.
extern fn as_markup_convert(p_markup: [*:0]const u8, p_to_kind: appstream.MarkupKind, p_error: ?*?*glib.Error) ?[*:0]u8;
pub const markupConvert = as_markup_convert;

/// Splits up a long line into an array of smaller strings, each being no longer
/// than `line_len`. Words are not split.
extern fn as_markup_strsplit_words(p_text: [*:0]const u8, p_line_len: c_uint) [*][*:0]u8;
pub const markupStrsplitWords = as_markup_strsplit_words;

/// De-tokenizes the SPDX licenses into a string.
extern fn as_spdx_license_detokenize(p_license_tokens: *[*:0]u8) ?[*:0]u8;
pub const spdxLicenseDetokenize = as_spdx_license_detokenize;

/// Tokenizes the SPDX license string (or any simarly formatted string)
/// into parts. Any license parts of the string e.g. "LGPL-2.0+" are prefexed
/// with "@", the conjunctive replaced with "&", the disjunctive replaced
/// with "|" and the WITH operator for license exceptions replaced with "^".
/// Brackets are added as indervidual tokens and other strings are
/// appended into single tokens where possible.
extern fn as_spdx_license_tokenize(p_license: [*:0]const u8) ?[*][*:0]u8;
pub const spdxLicenseTokenize = as_spdx_license_tokenize;

/// Builds an identifier string unique to the individual dataset using the supplied information.
extern fn as_utils_build_data_id(p_scope: appstream.ComponentScope, p_bundle_kind: appstream.BundleKind, p_origin: [*:0]const u8, p_cid: [*:0]const u8, p_branch: [*:0]const u8) [*:0]u8;
pub const utilsBuildDataId = as_utils_build_data_id;

/// Checks two component data IDs for equality allowing globs to match.
extern fn as_utils_data_id_equal(p_data_id1: [*:0]const u8, p_data_id2: [*:0]const u8) c_int;
pub const utilsDataIdEqual = as_utils_data_id_equal;

/// Get the component-id part of the data-id.
extern fn as_utils_data_id_get_cid(p_data_id: [*:0]const u8) [*:0]u8;
pub const utilsDataIdGetCid = as_utils_data_id_get_cid;

/// Converts a data-id to a hash value.
///
/// This function implements the widely used DJB hash on the ID subset of the
/// data-id string.
///
/// It can be passed to `glib.HashTable.new` as the hash_func parameter,
/// when using non-NULL strings or unique_ids as keys in a GHashTable.
extern fn as_utils_data_id_hash(p_data_id: [*:0]const u8) c_uint;
pub const utilsDataIdHash = as_utils_data_id_hash;

/// Checks two data IDs for equality allowing globs to match, whilst also
/// allowing clients to whitelist sections that have to match.
extern fn as_utils_data_id_match(p_data_id1: [*:0]const u8, p_data_id2: [*:0]const u8, p_match_flags: appstream.DataIdMatchFlags) c_int;
pub const utilsDataIdMatch = as_utils_data_id_match;

/// Checks if a data ID is valid i.e. has the correct number of
/// sections.
extern fn as_utils_data_id_valid(p_data_id: [*:0]const u8) c_int;
pub const utilsDataIdValid = as_utils_data_id_valid;

/// Get a human-readable, translated name of the desktop environment
/// represented by the given ID.
extern fn as_utils_get_desktop_environment_name(p_de_id: [*:0]const u8) [*:0]const u8;
pub const utilsGetDesktopEnvironmentName = as_utils_get_desktop_environment_name;

/// Get a human-readable, translated name of the combination
/// of GUI environment and style. E.g. "plasma:dark" becomes "Plasma (Dark)".
extern fn as_utils_get_gui_environment_style_name(p_env_style: [*:0]const u8) [*:0]const u8;
pub const utilsGetGuiEnvironmentStyleName = as_utils_get_gui_environment_style_name;

/// Retrieve the raw search token weight for the given tag name that AppStream uses
/// internally for searching.
/// This can be used to implement separate, but compatible search logic.
extern fn as_utils_get_tag_search_weight(p_tag_name: [*:0]const u8) u16;
pub const utilsGetTagSearchWeight = as_utils_get_tag_search_weight;

/// Guess the `appstream.ComponentScope` that applies to a given path.
extern fn as_utils_guess_scope_from_path(p_path: [*:0]const u8) appstream.ComponentScope;
pub const utilsGuessScopeFromPath = as_utils_guess_scope_from_path;

/// Installs an AppStream MetaInfo, AppStream Metadata Catalog or AppStream Icon tarball file
/// to the right place on the filesystem.
/// Please note that this function does almost no validation and may guess missing values such
/// as icon sizes and origin names.
/// Ensure your metadata is good before installing it.
extern fn as_utils_install_metadata_file(p_location: appstream.MetadataLocation, p_filename: [*:0]const u8, p_origin: [*:0]const u8, p_destdir: [*:0]const u8, p_error: ?*?*glib.Error) c_int;
pub const utilsInstallMetadataFile = as_utils_install_metadata_file;

/// Searches the known list of registered XDG category names.
/// See https://specifications.freedesktop.org/menu-spec/menu-spec-1.0.html`category`-registry
/// for a reference.
extern fn as_utils_is_category_name(p_category_name: [*:0]const u8) c_int;
pub const utilsIsCategoryName = as_utils_is_category_name;

/// Checks if the submitted desktop environment ID is
/// known and valid.
extern fn as_utils_is_desktop_environment(p_de_id: [*:0]const u8) c_int;
pub const utilsIsDesktopEnvironment = as_utils_is_desktop_environment;

/// Checks if the given identifier is a valid, known GUI environment style.
extern fn as_utils_is_gui_environment_style(p_env_style: [*:0]const u8) c_int;
pub const utilsIsGuiEnvironmentStyle = as_utils_is_gui_environment_style;

/// Test if the given string is a valid platform triplet recognized by
/// AppStream.
extern fn as_utils_is_platform_triplet(p_triplet: [*:0]const u8) c_int;
pub const utilsIsPlatformTriplet = as_utils_is_platform_triplet;

/// Searches the known list of TLDs we allow for AppStream IDs.
/// This excludes internationalized names.
extern fn as_utils_is_tld(p_tld: [*:0]const u8) c_int;
pub const utilsIsTld = as_utils_is_tld;

/// Calculates if one locale is compatible with another.
/// When doing the calculation the locale and language code is taken into
/// account if possible.
extern fn as_utils_locale_is_compatible(p_locale1: ?[*:0]const u8, p_locale2: ?[*:0]const u8) c_int;
pub const utilsLocaleIsCompatible = as_utils_locale_is_compatible;

/// Converts a POSIX locale string to the corresponding IETF BCP47 format.
/// If the given locale is already in BCP47 format, no change will be done.
extern fn as_utils_posix_locale_to_bcp47(p_locale: [*:0]const u8) [*:0]u8;
pub const utilsPosixLocaleToBcp47 = as_utils_posix_locale_to_bcp47;

/// Sorts all components in `cpts` into the `appstream.Category` categories listed in `categories`.
extern fn as_utils_sort_components_into_categories(p_cpts: *glib.PtrArray, p_categories: *glib.PtrArray, p_check_duplicates: c_int) void;
pub const utilsSortComponentsIntoCategories = as_utils_sort_components_into_categories;

/// Compare alpha and numeric segments of two software versions,
/// considering `flags`.
extern fn as_vercmp(p_a: [*:0]const u8, p_b: [*:0]const u8, p_flags: appstream.VercmpFlags) c_int;
pub const vercmp = as_vercmp;

/// Compare alpha and numeric segments of two software versions.
extern fn as_vercmp_simple(p_a: [*:0]const u8, p_b: [*:0]const u8) c_int;
pub const vercmpSimple = as_vercmp_simple;

/// Compare two version numbers and check if the given version comparator matches.
extern fn as_vercmp_test_match(p_ver1: [*:0]const u8, p_compare: appstream.RelationCompare, p_ver2: [*:0]const u8, p_flags: appstream.VercmpFlags) c_int;
pub const vercmpTestMatch = as_vercmp_test_match;

/// Get the version of the AppStream library that is currently used
/// at runtime as a string.
extern fn as_version_string() [*:0]const u8;
pub const versionString = as_version_string;

pub const MAJOR_VERSION = 1;
pub const MICRO_VERSION = 3;
pub const MINOR_VERSION = 0;
