/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.Constants;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class NormalizeFilter
extends AbstractXMLFilter {
    private final Pattern whitespace = Pattern.compile("\\s+");
    private Configuration.Mode processingMode;
    private int depth = 0;

    public void setProcessingMode(Configuration.Mode processingMode) {
        this.processingMode = processingMode;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        ++this.depth;
        if (this.depth == 1) {
            super.startPrefixMapping("dita-ot", "http://dita-ot.sourceforge.net/ns/201007/dita-ot");
        }
        AttributesImpl res = null;
        String cls = atts.getValue("class");
        if (Constants.MAP_MAP.matches(cls) && atts.getIndex("cascade") == -1) {
            if (res == null) {
                res = new AttributesImpl(atts);
            }
            XMLUtils.addOrSetAttribute(res, "cascade", Configuration.configuration.getOrDefault("default.cascade", "merge"));
        }
        if (Constants.MAP_MAP.matches(cls) || Constants.TOPIC_TOPIC.matches(cls)) {
            String specializations;
            String domains = atts.getValue("domains");
            if (domains != null) {
                String normalized = this.whitespace.matcher(domains.trim()).replaceAll(" ");
                if (res == null) {
                    res = new AttributesImpl(atts);
                }
                XMLUtils.addOrSetAttribute(res, "domains", normalized);
                XMLUtils.addOrSetAttribute(res, "specializations", this.domainsToSpecializations(normalized));
            }
            if ((specializations = atts.getValue("specializations")) != null) {
                String normalized = this.whitespace.matcher(specializations.trim()).replaceAll(" ");
                if (res == null) {
                    res = new AttributesImpl(atts);
                }
                XMLUtils.addOrSetAttribute(res, "specializations", normalized);
                XMLUtils.addOrSetAttribute(res, "domains", this.specializationsToDomains(normalized));
            }
        }
        this.getContentHandler().startElement(uri, localName, qName, res != null ? res : atts);
    }

    private String domainsToSpecializations(String domains) {
        return Arrays.stream(domains.trim().replaceAll("(\\))\\s+(a?\\()", "$1\n$2").split("\n")).filter(token -> token.startsWith("a(")).map(token -> "@" + token.substring(2, token.length() - 1).replace(' ', '/')).collect(Collectors.joining(" "));
    }

    private String specializationsToDomains(String specializations) {
        return Arrays.stream(specializations.trim().split("\\s+")).map(token -> token.replaceAll("^@(.+)/(.+)$", "a($1 $2)")).collect(Collectors.joining(" "));
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.getContentHandler().endElement(uri, localName, qName);
        if (this.depth == 1) {
            super.endPrefixMapping("dita-ot");
        }
        --this.depth;
    }
}

