'use client';
import { jsx, jsxs } from 'react/jsx-runtime';
import { createElement } from 'react';
import cx from 'clsx';
import hljs from 'highlight.js';
import { rem, createVarsResolver, factory, useProps, useStyles, UnstyledButton, Box, ScrollArea, Tooltip, ActionIcon, CopyButton } from '@mantine/core';
import { useUncontrolled } from '@mantine/hooks';
import { CopyIcon } from './CopyIcon.mjs';
import { ExpandIcon } from './ExpandIcon.mjs';
import { FileIcon } from './FileIcon.mjs';
import _classes from './CodeHighlight.module.css.mjs';
import themeClasses from './CodeHighlight.theme.module.css.mjs';

const classes = { ..._classes, root: cx(_classes.root, themeClasses.theme) };
const defaultProps = {
  withHeader: true,
  copyLabel: "Copy code",
  copiedLabel: "Copied",
  maxCollapsedHeight: rem("8rem"),
  expandCodeLabel: "Expand code",
  collapseCodeLabel: "Collapse code",
  withCopyButton: true
};
const varsResolver = createVarsResolver((_, { maxCollapsedHeight }) => ({
  root: { "--ch-max-collapsed-height": rem(maxCollapsedHeight) }
}));
const CodeHighlightTabs = factory((_props, ref) => {
  const props = useProps("CodeHighlightTabs", defaultProps, _props);
  const {
    classNames,
    className,
    style,
    styles,
    unstyled,
    vars,
    children,
    code,
    defaultActiveTab,
    activeTab,
    onTabChange,
    withHeader,
    copiedLabel,
    copyLabel,
    getFileIcon,
    maxCollapsedHeight,
    expanded,
    defaultExpanded,
    onExpandedChange,
    expandCodeLabel,
    collapseCodeLabel,
    withExpandButton,
    withCopyButton,
    mod,
    ...others
  } = props;
  const getStyles = useStyles({
    name: "CodeHighlightTabs",
    props,
    classes,
    className,
    style,
    classNames,
    styles,
    unstyled,
    vars,
    varsResolver
  });
  const [value, setValue] = useUncontrolled({
    defaultValue: defaultActiveTab,
    value: activeTab,
    finalValue: 0,
    onChange: onTabChange
  });
  const [_expanded, setExpanded] = useUncontrolled({
    defaultValue: defaultExpanded,
    value: expanded,
    finalValue: true,
    onChange: onExpandedChange
  });
  const nodes = Array.isArray(code) ? code : [code];
  const currentCode = nodes[value];
  const highlighted = hljs.highlight(currentCode.code.trim(), {
    language: currentCode.language || "plaintext"
  }).value;
  const files = nodes.map((node, index) => /* @__PURE__ */ createElement(
    UnstyledButton,
    {
      ...getStyles("file"),
      key: node.fileName,
      mod: { active: index === value },
      onClick: () => setValue(index)
    },
    /* @__PURE__ */ jsx(
      FileIcon,
      {
        fileIcon: node.icon,
        getFileIcon,
        fileName: node.fileName,
        ...getStyles("fileIcon")
      }
    ),
    /* @__PURE__ */ jsx("span", { children: node.fileName })
  ));
  return /* @__PURE__ */ jsxs(
    Box,
    {
      ...getStyles("root"),
      mod: [{ collapsed: !_expanded }, mod],
      ref,
      ...others,
      dir: "ltr",
      children: [
        withHeader && /* @__PURE__ */ jsxs("div", { ...getStyles("header"), children: [
          /* @__PURE__ */ jsx(ScrollArea, { type: "never", dir: "ltr", offsetScrollbars: false, children: /* @__PURE__ */ jsx("div", { ...getStyles("files"), children: files }) }),
          /* @__PURE__ */ jsxs("div", { ...getStyles("controls"), children: [
            withExpandButton && /* @__PURE__ */ jsx(
              Tooltip,
              {
                label: _expanded ? collapseCodeLabel : expandCodeLabel,
                fz: "sm",
                position: "left",
                children: /* @__PURE__ */ jsx(
                  ActionIcon,
                  {
                    onClick: () => setExpanded(!_expanded),
                    variant: "none",
                    "aria-label": _expanded ? collapseCodeLabel : expandCodeLabel,
                    ...getStyles("control"),
                    children: /* @__PURE__ */ jsx(ExpandIcon, { expanded: _expanded })
                  }
                )
              }
            ),
            withCopyButton && /* @__PURE__ */ jsx(CopyButton, { value: currentCode.code.trim(), children: ({ copied, copy }) => /* @__PURE__ */ jsx(Tooltip, { label: copied ? copiedLabel : copyLabel, fz: "sm", position: "left", children: /* @__PURE__ */ jsx(
              ActionIcon,
              {
                onClick: copy,
                variant: "none",
                ...getStyles("control"),
                "aria-label": copied ? copiedLabel : copyLabel,
                children: /* @__PURE__ */ jsx(CopyIcon, { copied })
              }
            ) }) })
          ] })
        ] }),
        /* @__PURE__ */ jsx(ScrollArea, { type: "auto", dir: "ltr", offsetScrollbars: false, children: /* @__PURE__ */ jsx(Box, { ...getStyles("codeWrapper"), mod: { expanded: _expanded }, children: /* @__PURE__ */ jsx("pre", { ...getStyles("pre"), children: /* @__PURE__ */ jsx("code", { ...getStyles("code"), dangerouslySetInnerHTML: { __html: highlighted } }) }) }) }),
        /* @__PURE__ */ jsx(
          UnstyledButton,
          {
            ...getStyles("showCodeButton"),
            mod: { hidden: _expanded },
            onClick: () => setExpanded(true),
            children: expandCodeLabel
          }
        )
      ]
    }
  );
});
CodeHighlightTabs.displayName = "@mantine/core/CodeHighlightTabs";
CodeHighlightTabs.classes = classes;

export { CodeHighlightTabs };
//# sourceMappingURL=CodeHighlightTabs.mjs.map
