/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_syr extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_018 = "ܬܝܡܢ ܐܦܪܝܩܐ";
        final String metaValue_DE = "ܐܠܡܢܝܐ";
        final String metaValue_ar = "ܥܪܒܝܬ";
        final String metaValue_hy = "ܐܪܡܢܝܬ";
        final String metaValue_gu = "ܓܘܓܐܪܝܬ";
        final String metaValue_ko = "ܟܘܪܝܐܝܬ";
        final String metaValue_type_hc_h23 = "ܛܟ݂ܣܐ 24 ܫܥܬ݂ܐ (0–23)";
        final Object[][] data = new Object[][] {
            { "001", "ܥܠܡܐ" },
            { "002", "ܐܦܪܝܩܐ" },
            { "003", "ܐܡܪܝܟܐ ܓܪܒܝܝܬܐ" },
            { "005", "ܐܡܪܝܟܐ ܬܝܡܢܝܬܐ" },
            { "009", "ܐܘܩܝܢܘܣܝܐ" },
            { "011", "ܡܥܪܒ ܐܦܪܝܩܐ" },
            { "013", "ܐܡܪܝܟܐ ܡܨܥܝܬܐ" },
            { "014", "ܡܕܢܚ ܐܦܪܝܩܐ" },
            { "015", "ܓܪܒܐ ܐܦܪܝܩܐ" },
            { "017", "ܡܨܥܬ ܐܦܪܝܩܐ" },
            { "018", metaValue_018 },
            { "019", "ܐܡܪ̈ܝܟܐ" },
            { "021", "ܓܪܒܐ ܐܡܪܝܟܐ" },
            { "029", "ܟܐܪܝܒܐ" },
            { "030", "ܡܕܢܚ ܐܣܝܐ" },
            { "034", "ܬܝܡܢ ܐܣܝܐ" },
            { "035", "ܬܝܡܢ ܡܕܢܚ ܐܣܝܐ" },
            { "039", "ܬܝܡܢ ܐܘܪܘܦܐ" },
            { "053", "ܐܘܣܛܪܐܠܐܣܝܐ" },
            { "054", "ܡܝܠܐܢܝܣܝܐ" },
            { "057", "ܡܝܟܪܘܢܝܙܝܐ" },
            { "061", "ܦܘܠܢܝܣܝܐ" },
            { "142", "ܐܣܝܐ" },
            { "143", "ܡܨܥܬ ܐܣܝܐ" },
            { "145", "ܡܥܪܒ ܐܣܝܐ" },
            { "150", "ܐܘܪܘܦܐ" },
            { "151", "ܡܕܢܚ ܐܘܪܘܦܐ" },
            { "154", "ܓܪܒܐ ܐܘܪܘܦܐ" },
            { "155", "ܡܥܪܒ ܐܘܪܘܦܐ" },
            { "202", "ܐܦܪܝܩܐ ܬܝܡܢ ܨܚܪܐ" },
            { "419", "ܐܡܪܝܟܐ ܠܬܝܢܝܬܐ" },
            { "AC", "ܓܙܪܬܐ ܕܣܘܠܩܐ" },
            { "AD", "ܐܢܕܘܪܐ" },
            { "AE", "ܐܡܝܪ̈ܘܬܐ ܥܪ̈ܒܝܬܐ ܡܚܝ̈ܕܬܐ" },
            { "AF", "ܐܦܓܐܢܣܬܐܢ" },
            { "AG", "ܐܢܬܝܓܘܐ ܘܒܐܪܒܘܕܐ" },
            { "AI", "ܐܢܓܘܝܠܐ" },
            { "AL", "ܐܠܒܢܝܐ" },
            { "AM", "ܐܪܡܢܝܐ" },
            { "AO", "ܐܢܓܘܠܐ" },
            { "AQ", "ܐܢܬܪܬܝܟܐ" },
            { "AR", "ܐܪܓܢܬܝܢܐ" },
            { "AS", "ܣܡܘܐ ܐܡܪܝܟܝܬܐ" },
            { "AT", "ܐܘܣܛܪܝܐ" },
            { "AU", "ܐܘܣܬܪܠܝܐ" },
            { "AW", "ܐܪܘܒܐ" },
            { "AX", "ܓܙܪ̈ܬܐ ܕܐܠܐܢܕ" },
            { "AZ", "ܐܙܪܒܝܓܐܢ" },
            { "BA", "ܒܘܣܢܐ ܘܗܪܬܣܓܘܒܝܢܐ" },
            { "BB", "ܒܪܒܐܕܘܣ" },
            { "BD", "ܒܢܓܠܐܕܝܫ" },
            { "BE", "ܒܠܓܝܩܐ" },
            { "BF", "ܒܘܪܩܝܢܐ ܦܐܣܘ" },
            { "BG", "ܒܘܠܓܐܪܝܐ" },
            { "BH", "ܒܚܪܝܢ" },
            { "BI", "ܒܘܪܘܢܕܝ" },
            { "BJ", "ܒܢܝܢ" },
            { "BL", "ܡܪܝ ܒܪ ܬܘܠܡܝ" },
            { "BM", "ܒܝܪܡܘܕܐ" },
            { "BN", "ܒܪܘܢܐܝ" },
            { "BO", "ܒܘܠܝܒܝܐ" },
            { "BQ", "ܟܐܪܝܒܐ ܕܢܝܬܝܪܠܐܢܕܣ" },
            { "BR", "ܒܪܐܙܝܠ" },
            { "BS", "ܒܗܐܡܣ" },
            { "BT", "ܒܘܬܐܢ" },
            { "BV", "ܓܙܪܬܐ ܕܒܘܒܝܬ" },
            { "BW", "ܒܘܛܣܘܐܢܐ" },
            { "BY", "ܒܠܐܪܘܣ" },
            { "BZ", "ܒܠܝܙ" },
            { "CA", "ܟܢܕܐ" },
            { "CC", "ܓܙܪ̈ܬܐ ܕܟܘܟܘܣ" },
            { "CD", "ܟܘܢܓܘ - ܟܝܢܫܐܣܐ" },
            { "CF", "ܩܘܛܢܝܘܬܐ ܕܐܦܪܝܩܐ ܡܨܥܝܬܐ" },
            { "CG", "ܟܘܢܓܘ - ܒܪܐܙܐܒܝܠ" },
            { "CH", "ܣܘܝܣܪܐ" },
            { "CI", "ܩܘܛ ܕܝܒܘܐܪ" },
            { "CK", "ܓܙܪ̈ܬܐ ܟܘܟ" },
            { "CL", "ܬܫܝܠܝ" },
            { "CM", "ܟܐܡܪܘܢ" },
            { "CN", "ܨܝܢ" },
            { "CO", "ܟܘܠܘܡܒܝܐ" },
            { "CP", "ܓܙܪܬܐ ܕܟܠܝܦܝܪܬܘܢ" },
            { "CQ", "ܣܐܪܟ" },
            { "CR", "ܟܘܣܬܐ ܪܝܟܐ" },
            { "CU", "ܩܘܒܐ" },
            { "CV", "ܟܐܦ ܒܝܪܕܝ (ܪܝܫܐ ܝܘܪܩܐ)" },
            { "CW", "ܟܘܪܐܟܘ" },
            { "CX", "ܓܙܪܬܐ ܕܟܪܝܣܬܡܣ" },
            { "CY", "ܩܘܦܪܘܣ" },
            { "CZ", "ܬܫܝܟܝܐ" },
            { "DE", metaValue_DE },
            { "DG", "ܕܝܐܓܘ ܓܐܪܣܝܐ" },
            { "DJ", "ܓܝܒܘܛܝ" },
            { "DK", "ܕܐܢܡܐܪܩ" },
            { "DM", "ܕܘܡܝܢܝܩܐ" },
            { "DO", "ܩܘܛܢܝܘܬܐ ܕܘܡܝܢܝܩܐܢܝܬܐ" },
            { "DZ", "ܓܙܐܪ" },
            { "EA", "ܟܘܝܛܐ ܘܡܝܠܝܐ" },
            { "EC", "ܐܩܘܐܕܘܪ" },
            { "EE", "ܐܣܛܘܢܝܐ" },
            { "EG", "ܡܨܪܝܢ" },
            { "EH", "ܨܚܪܐ ܡܥܪܒܝܬܐ" },
            { "ER", "ܐܪܬܪܝܐ" },
            { "ES", "ܐܣܦܢܝܐ" },
            { "ET", "ܟܘܫ" },
            { "EU", "ܚܘܝܕܐ ܐܘܪܘܦܝܐ" },
            { "EZ", "ܩܠܝܡܐ ܕܐܘܪܘ" },
            { "FI", "ܦܝܢܠܢܕ" },
            { "FJ", "ܦܝܓܝ" },
            { "FK", "ܓܙܪ̈ܬܐ ܕܦܠܟܠܢܕ" },
            { "FM", "ܐܬܪ̈ܘܬܐ ܦܕܪܠܝܐ ܕܡܝܩܪܘܢܝܣܝܐ" },
            { "FO", "ܓܙܪ̈ܬܐ ܕܦܪܘ" },
            { "FR", "ܦܪܢܣܐ" },
            { "GA", "ܓܒܘܢ" },
            { "GB", "ܡܠܟܘܬܐ ܡܚܝܕܬܐ" },
            { "GD", "ܓܪܝܢܐܕܐ" },
            { "GE", "ܓܘܪܓܝܐ" },
            { "GF", "ܓܘܝܐܢܐ ܦܪܢܣܝܬܐ" },
            { "GG", "ܓܘܪܢܙܝ" },
            { "GH", "ܓܐܢܐ" },
            { "GI", "ܓܒܪܠܛܪ" },
            { "GL", "ܓܪܝܢܠܢܕ" },
            { "GM", "ܓܡܒܝܐ" },
            { "GN", "ܓܝܢܝܐ" },
            { "GP", "ܓܘܐܕܘܠܘܦܐܝ" },
            { "GQ", "ܓܝܢܝܐ ܫܘܝܬܐ" },
            { "GR", "ܝܘܢ" },
            { "GS", "ܓܙܪ̈ܬܐ ܕܓܘܪܓܝܐ ܘܣܐܢܕܘܝܟ ܬܝܡܢܝ̈ܐ" },
            { "GT", "ܓܘܐܬܝܡܐܠܐ" },
            { "GU", "ܓܘܐܡ" },
            { "GW", "ܓܝܢܝܐ ܒܝܣܐܘ" },
            { "GY", "ܓܘܝܐܢܐ" },
            { "HK", "ܗܘܢܓ ܟܘܢܓ" },
            { "HM", "ܓܙܪ̈ܬܐ ܕܗܪܕ ܘܡܟܕܘܢܠܕ" },
            { "HN", "ܗܘܢܕܘܪܣ" },
            { "HR", "ܩܪܘܐܛܝܐ" },
            { "HT", "ܗܐܝܬܝ" },
            { "HU", "ܡܓܪ" },
            { "IC", "ܓܙܝܪ̈ܐ ܕܟܐܢܪܝ" },
            { "ID", "ܐܝܢܕܘܢܝܣܝܐ" },
            { "IE", "ܐܝܪܠܢܕ" },
            { "IL", "ܐܝܣܪܐܝܠ" },
            { "IM", "ܓܙܪܬܐ ܕܡܐܢ" },
            { "IN", "ܗܢܕܘ" },
            { "IO", "ܐܬܪܐ ܕܐܘܩܝܢܘܣ ܗܢܕܘܝܐ ܕܒܪܝܛܢܝܐ" },
            { "IQ", "ܥܝܪܩ" },
            { "IR", "ܐܝܪܐܢ" },
            { "IS", "ܐܝܣܠܢܕ" },
            { "IT", "ܐܝܛܠܝܐ" },
            { "JE", "ܓܝܪܙܝ" },
            { "JM", "ܓܡܝܟܐ" },
            { "JO", "ܝܘܪܕܢܢ" },
            { "JP", "ܝܦܢ" },
            { "KE", "ܟܝܢܝܐ" },
            { "KG", "ܩܝܪܓܝܙܣܬܐܢ" },
            { "KH", "ܟܡܒܘܕܝܐ" },
            { "KI", "ܟܝܪܝܒܬܝ" },
            { "KM", "ܓܙܪܬܐ ܕܩܡܪ" },
            { "KN", "ܣܐܢܬ ܟܝܬܣ ܘܢܝܒܝܣ" },
            { "KP", "ܟܘܪܝܐ ܓܪܒܝܝܬܐ" },
            { "KR", "ܟܘܪܝܐ ܬܝܡܢܝܬܐ" },
            { "KW", "ܟܘܝܬ" },
            { "KY", "ܓܙܪ̈ܬܐ ܕܟܐܝܡܐܢ" },
            { "KZ", "ܟܙܩܣܬܐܢ" },
            { "LA", "ܠܐܘܣ" },
            { "LB", "ܠܒܢܢ" },
            { "LC", "ܡܪܬܝ ܠܘܫܐ" },
            { "LI", "ܠܝܟܛܢܫܛܝܢ" },
            { "LK", "ܫܪܝ ܠܐܢܟܐ" },
            { "LR", "ܠܝܒܝܪܝܐ" },
            { "LS", "ܠܣܘܛܘ" },
            { "LT", "ܠܬܘܢܝܐ" },
            { "LU", "ܠܘܟܣܡܒܘܪܓ" },
            { "LV", "ܠܐܛܒܝܐ" },
            { "LY", "ܠܘܒܐ" },
            { "MA", "ܡܓܪܒ" },
            { "MC", "ܡܘܢܐܩܘ" },
            { "MD", "ܡܘܠܕܘܒܐ" },
            { "ME", "ܡܘܢܛܝܢܝܓܪܘ" },
            { "MF", "ܣܐܢܬ ܡܐܪܬܝܢ" },
            { "MG", "ܡܕܓܣܩܪ" },
            { "MH", "ܓܙܪ̈ܬܐ ܡܐܪܫܐܠ" },
            { "MK", "ܓܪܒܝ ܡܩܕܘܢܝܐ" },
            { "ML", "ܡܐܠܝ" },
            { "MM", "ܡܝܐܢܡܐܪ (ܒܘܪܡܐ)" },
            { "MN", "ܡܘܓܠܝܐ" },
            { "MO", "ܐܬܪܐ ܡܕܒܪܢܝܐ ܦܪܝܫܐ ܕܡܐܟܐܘ" },
            { "MP", "ܓܙܪ̈ܬܐ ܕܡܪܝܢܐ ܓܪ̈ܒܝܝܬܐ" },
            { "MQ", "ܡܐܪܬܝܢܝܩ" },
            { "MR", "ܡܘܪܝܛܢܝܐ" },
            { "MS", "ܡܘܢܣܝܪܐܬ" },
            { "MT", "ܡܝܠܛܐ" },
            { "MU", "ܡܘܪܝܛܝܘܣ" },
            { "MV", "ܓܙܪܬܐ ܡܐܠܕܝܒܝܬܐ" },
            { "MW", "ܡܠܐܘܝ" },
            { "MX", "ܡܟܣܝܟܘ" },
            { "MY", "ܡܠܝܙܝܐ" },
            { "MZ", "ܡܘܙܡܒܝܩ" },
            { "NA", "ܢܡܝܒܝܐ" },
            { "NC", "ܢܝܘ ܟܠܝܕܘܢܝܐ" },
            { "NE", "ܢܝܓܪ" },
            { "NF", "ܓܙܪܬܐ ܕܢܘܪܦܘܠܟ" },
            { "NG", "ܢܝܓܝܪܝܐ" },
            { "NI", "ܢܝܟܪܐܓܘܐ" },
            { "NL", "ܗܘܠܢܕܐ" },
            { "NO", "ܢܘܪܒܝܓ" },
            { "NP", "ܢܝܦܐܠ" },
            { "NR", "ܢܐܘܪܘ" },
            { "NU", "ܢܝܘܐܝ" },
            { "NZ", "ܢܝܘ ܙܝܠܢܕ" },
            { "OM", "ܥܘܡܐܢ" },
            { "PA", "ܦܢܡܐ" },
            { "PE", "ܦܝܪܘ" },
            { "PF", "ܦܘܠܝܢܝܣܝܐ ܦܪܢܣܝܬܐ" },
            { "PG", "ܦܐܦܘܐ ܓܝܢܝܐ ܚܕܬܐ" },
            { "PH", "ܦܝܠܝܦܝܢܝܐ" },
            { "PK", "ܦܐܟܣܬܐܢ" },
            { "PL", "ܦܘܠܢܕ" },
            { "PM", "ܡܪܝ ܦܛܪܘܣ ܘܡܝܩܝܠܘܢ" },
            { "PN", "ܓܙܝܪ̈ܬܐ ܕܦܝܬܟܐܪܢ" },
            { "PR", "ܦܘܐܪܛܘ ܪܝܩܘ" },
            { "PS", "ܐܬܪ̈ܘܬܐ ܕܦܠܣܛܝܢ" },
            { "PT", "ܦܘܪܛܘܓܠ" },
            { "PW", "ܦܠܐܘ" },
            { "PY", "ܦܪܓܘܐܝ" },
            { "QA", "ܩܛܪ" },
            { "QO", "ܐܘܩܝܢܘܣܝܐ ܒܪܝܬܐ" },
            { "RE", "ܪܝܘܢܝܘܢ" },
            { "RO", "ܪܘܡܢܝܐ" },
            { "RS", "ܣܪܒܝܐ" },
            { "RU", "ܪܘܣܝܐ" },
            { "RW", "ܪܘܐܢܕܐ" },
            { "SA", "ܣܥܘܕܝܐ" },
            { "SB", "ܓܙܪܬܐ ܕܫܠܝܡܘܢ" },
            { "SC", "ܣܐܝܫܝܠ" },
            { "SD", "ܣܘܕܐܢ" },
            { "SE", "ܣܘܝܕ" },
            { "SG", "ܣܝܢܓܐܦܘܪ" },
            { "SH", "ܡܪܬܝ ܗܝܠܝܢܐ" },
            { "SI", "ܣܠܘܒܢܝܐ" },
            { "SJ", "ܣܒܠܕܒܪܕ ܘܓܐܢ ܡܐܝܝܢ" },
            { "SK", "ܣܠܘܒܩܝܐ" },
            { "SL", "ܣܝܝܪܐ ܠܝܐܘܢܝ" },
            { "SM", "ܣܢ ܡܪܝܢܘ" },
            { "SN", "ܣܢܓܐܠ" },
            { "SO", "ܨܘܡܐܠ" },
            { "SR", "ܣܘܪܝܢܐܡ" },
            { "SS", "ܬܝܡܢ ܣܘܕܐܢ" },
            { "ST", "ܣܐܘ ܛܘܡܝ ܘܦܪܝܢܣܝܦܝ" },
            { "SV", "ܐܠ ܣܠܒܐܕܘܪ" },
            { "SX", "ܣܢܬ ܡܐܪܬܝܢ" },
            { "SY", "ܣܘܪܝܐ" },
            { "SZ", "ܐܣܘܐܛܝܢܝ" },
            { "TA", "ܬܪܝܣܬܢ ܕܟܘܢܗܐ" },
            { "TC", "ܓܙܝܪ̈ܐ ܕܬܘܪܟܣ ܘܟܐܝܟܘܣ" },
            { "TD", "ܬܫܐܕ" },
            { "TF", "ܐܬܪ̈ܘܬܐ ܬܝܡܢܝ̈ܬܐ ܕܦܪܢܣܐ" },
            { "TG", "ܬܘܓܘ" },
            { "TH", "ܬܐܝܠܢܕ" },
            { "TJ", "ܬܐܓܝܟܣܬܐܢ" },
            { "TK", "ܬܘܟܝܠܐܘ" },
            { "TL", "ܡܕܢܚ ܬܝܡܘܪ" },
            { "TM", "ܬܘܪܟܡܢܣܬܐܢ" },
            { "TN", "ܬܘܢܣ" },
            { "TO", "ܬܘܢܓܐ" },
            { "TR", "ܬܘܪܟܝܐ" },
            { "TT", "ܬܪܝܢܝܕܐܕ ܘܬܘܒܐܓܘ" },
            { "TV", "ܬܘܒܐܠܘ" },
            { "TW", "ܬܐܝܘܐܢ" },
            { "TZ", "ܛܢܙܢܝܐ" },
            { "UA", "ܐܘܩܪܐܝܢܐ" },
            { "UG", "ܐܘܓܢܕܐ" },
            { "UM", "ܓܙܪ̈ܬܐ ܒܪ̈ܝܬܐ ܕܐܘܚܕ̈ܢܐ ܡܚܝܕ̈ܐ" },
            { "UN", "ܐܡ̈ܘܬܐ ܡܚܝ̈ܕܬܐ" },
            { "US", "ܐܘܚܕ̈ܢܐ ܡܚܝܕ̈ܐ" },
            { "UY", "ܐܘܪܘܓܘܐܝ" },
            { "UZ", "ܐܘܙܒܟܣܬܐܢ" },
            { "VA", "ܡܕܝܢܬܐ ܕܘܛܝܩܢ" },
            { "VC", "ܣܐܢܬ ܒܝܢܣܝܢܬ ܘܓܪܝܢܐܕܝܢܐܣ" },
            { "VE", "ܒܢܙܘܝܠܐ" },
            { "VG", "ܓܙܪ̈ܬܐ ܕܒܬܘ̈ܠܐ ܕܒܪܝܛܢܝܐ" },
            { "VI", "ܓܙܪ̈ܬܐ ܕܒܬܘ̈ܠܐ ܕܐܡܪܝܟܐ" },
            { "VN", "ܒܝܬܢܐܡ" },
            { "VU", "ܒܐܢܘܐܛܘ" },
            { "WF", "ܘܐܠܝܣ ܘܦܘܬܘܢܐ" },
            { "WS", "ܣܡܘܐ" },
            { "XK", "ܩܘܣܘܒܘ" },
            { "YE", "ܝܡܢ" },
            { "YT", "ܡܐܝܘܛ" },
            { "ZA", metaValue_018 },
            { "ZM", "ܙܐܡܒܝܐ" },
            { "ZW", "ܙܝܡܒܐܒܘܝ" },
            { "ZZ", "ܐܬܪܐ ܠܐ ܝܕܝܥܐ" },
            { "ab", "ܐܒܟܐܙܝܬ" },
            { "am", "ܐܡܪܢܝܬ" },
            { "an", "ܐܪܐܓܘܢܝܬ" },
            { "ar", metaValue_ar },
            { "az", "ܐܙܪܒܝܓܐܢܝܬ" },
            { "bn", "ܒܢܓܐܠܝܐ" },
            { "de", metaValue_DE },
            { "el", "ܝܘܢܐܝܬ" },
            { "en", "ܐܢܓܠܝܬ" },
            { "es", "ܣܦܢܝܝܐ" },
            { "fa", "ܦܪܣܝܬ" },
            { "ff", "ܦܘܠܐܗܝܬ" },
            { "fi", "ܦܝܢܠܢܕܝܬ" },
            { "fr", "ܦܪܢܣܝܬ" },
            { "gl", "ܓܠܝܩܝܬ" },
            { "gu", metaValue_gu },
            { "he", "ܥܒܪܐܝܬ" },
            { "hi", "ܗܢܕܝܐ" },
            { "hy", metaValue_hy },
            { "id", "ܐܢܕܘܢܝܬ" },
            { "it", "ܐܝܛܠܝܬ" },
            { "ja", "ܝܦܢܝܐ" },
            { "ka", "ܓܘܪܓܝܐܝܬ" },
            { "ko", metaValue_ko },
            { "ku", "ܩܘܪܕܝܬ" },
            { "la", "ܠܬܝܢܝܬ" },
            { "lg", "ܓܢܕܝܬ" },
            { "nl", "ܗܘܠܢܕܝܬ" },
            { "no", "ܢܘܪܒܝܓܐܝܬ" },
            { "om", "ܐܘܪܘܡܘܐܝܬ" },
            { "pl", "ܦܘܠܢܕܐܝܬ" },
            { "pt", "ܦܘܪܛܘܓܠܐܝܬ" },
            { "ro", "ܪܘܡܢܐܝܬ" },
            { "ru", "ܐܘܪܘܣܢܝܬ" },
            { "sq", "ܐܠܒܢܝܬ" },
            { "sv", "ܣܘܝܕܐܝܬ" },
            { "sw", "ܣܘܐܗܝܠܐܝܬ" },
            { "th", "ܬܝܠܢܕܐܝܬ" },
            { "tr", "ܬܘܪܟܝܬ" },
            { "uk", "ܐܘܟܪܐܝܢܐܝܬ" },
            { "ur", "ܐܘܪܕܘܝܬ" },
            { "vi", "ܒܝܬܢܐܡܐܝܬ" },
            { "yi", "ܝܕܝܬܝܬ" },
            { "zh", "ܨܝܢܐܝܬ" },
            { "arp", "ܐܪܐܦܗܝܬ" },
            { "ckb", "ܩܪܕܝܬ ܩܢܛܪܘܢܝܐ" },
            { "fil", "ܦܝܠܝܦܝܢܝܬ" },
            { "fon", "ܦܘܢܝܬ" },
            { "gaa", "ܓܐܝܬ" },
            { "mul", "ܠܫ̈ܢܐ ܦܖ̈ܝܫܐ" },
            { "nds", "ܐܠܡܢܝܐ ܠܐܠܬܚܬ" },
            { "pis", "ܦܝܓܝܢܝܬ" },
            { "sco", "ܣܟܘܬܠܢܕܐܝܬ" },
            { "syr", "ܣܘܪܝܝܐ" },
            { "und", "ܠܫܢܐ ܠܐ ܝܕܝܥܐ" },
            { "Arab", metaValue_ar },
            { "Armi", "ܐܪܡܝܐ" },
            { "Armn", metaValue_hy },
            { "Cyrl", "ܩܘܪܠܝܐ" },
            { "Geor", "ܓܘܪܓܝܬ" },
            { "Grek", "ܝܘܢܝܬ" },
            { "Gujr", metaValue_gu },
            { "Hans", "ܦܫܝܛܐ" },
            { "Hant", "ܝܘܒܠܝܐ" },
            { "Hebr", "ܥܒܪܝܬ" },
            { "Jpan", "ܝܦܢܐܝܬ" },
            { "Kore", metaValue_ko },
            { "Latn", "ܪܗܘܡܝܐ" },
            { "Syrc", "ܣܘܪܝܬ" },
            { "Zsye", "ܐܝܡܘܓܝ" },
            { "Zxxx", "ܕܠܐ ܟܬܒܐ" },
            { "Zzzz", "ܟܬܝܒܘܬܐ ܠܐ ܝܕܝܥܬܐ" },
            { "nl_BE", "ܦܠܡܝܫܝܬ" },
            { "ar_001", "ܥܪܒܝܬ ܪܘܫܡܝܐ ܚܕܬܐ" },
            { "key.ca", "ܣܘܪܓܕܐ" },
            { "key.cf", "ܛܘܦܣܐ ܕܙܘ̈ܙܐ" },
            { "key.co", "ܛܟܣܐ ܕܦܘܪܫܢܝܐ" },
            { "key.cu", "ܙܘ̈ܙܐ" },
            { "key.hc", "ܛܟ݂ܣܐ ܥܕܢܘܬܐ (12 ܠܘܩܒܠ 24)" },
            { "key.ms", "ܛܟܣܐ ܕܟܝܠܬܐ" },
            { "key.nu", "ܡܢܝ̈ܢܐ" },
            { "nds_NL", "ܗܘܠܢܕܐ ܠܐܠܬܚܬ" },
            { "hi_Latn", "ܗܢܕܝܐ (ܪܗܘܡܝܐ)" },
            { "zh_Hans", "ܨܝܢܐܝܬ ܦܫܝܛܐ" },
            { "zh_Hant", "ܨܝܢܐܝܬ ܝܘܒܠܝܐ" },
            { "type.ca.roc", "ܣܘܪܓܕܐ ܡܝܢܓܘ" },
            { "type.hc.h11", "ܛܟ݂ܣܐ 12 ܫܥܬ݂ܐ (0–11)" },
            { "type.hc.h12", "ܛܟ݂ܣܐ 12 ܫܥܬ݂ܐ (1–12)" },
            { "type.hc.h23", metaValue_type_hc_h23 },
            { "type.hc.h24", metaValue_type_hc_h23 },
            { "type.nu.arab", "ܡܢܝ̈ܢܐ ܕܥܖ̈ܒܝܐ ܗܢܕܘܝܐ" },
            { "type.nu.armn", "ܡܢܝ̈ܢܐ ܕܐܖ̈ܡܢܝܐ" },
            { "type.nu.ethi", "ܡܢܝ̈ܢܐ ܟܘܫܝܐ" },
            { "type.nu.geor", "ܡܢܝ̈ܢܐ ܓܘܪܓܝܐ" },
            { "type.nu.grek", "ܡܢܝ̈ܢܐ ܕܝܘܢܝ̈ܐ" },
            { "type.nu.hebr", "ܡܢܝ̈ܢܐ ܕܝܗܘܕܝ̈ܐ" },
            { "type.nu.jpan", "ܡܢܝ̈ܢܐ ܕܝܦܢܝ̈ܐ" },
            { "type.nu.latn", "ܡܢܝ̈ܢܐ ܡܥܪ̈ܒܝܐ" },
            { "type.nu.mong", "ܡܢܝ̈ܢܐ ܕܡܘܢܓܘܠܢܝ̈ܐ" },
            { "type.ca.dangi", "ܣܘܪܓܕܐ ܕܢܓܝ" },
            { "type.nu.roman", "ܡܢܝ̈ܢܐ ܪܗܘܡܝܐ" },
            { "type.ca.coptic", "ܣܘܪܓܕܐ ܐܓܒܛܝܐ" },
            { "type.ca.hebrew", "ܣܘܪܓܕܐ ܝܗܘܕܝܐ" },
            { "type.ca.indian", "ܣܘܪܓܕܐ ܐܘܡܬܢܝܐ ܗܢܕܘܝܐ" },
            { "type.ms.metric", "ܛܟܣܐ ܡܝܬܪܝܐ" },
            { "type.ca.chinese", "ܣܘܪܓܕܐ ܨܝܢܝܐ" },
            { "type.ca.islamic", "ܣܘܪܓܕܐ ܡܫܠܡܢܐ" },
            { "type.ca.iso8601", "ܣܘܪܓܕܐ ISO-8601" },
            { "type.ca.persian", "ܣܘܪܓܕܐ ܦܪܣܝܐ" },
            { "type.cf.account", "ܛܘܦܣܐ ܕܙܘ̈ܙܐ ܡܚܫܒܢܘܬܝܐ" },
            { "type.ca.buddhist", "ܣܘܪܓܕܐ ܒܘܕܗܝܝܐ" },
            { "type.ca.ethiopic", "ܣܘܪܓܕܐ ܟܘܫܝܐ" },
            { "type.ca.japanese", "ܣܘܪܓܕܐ ܝܦܢܝܐ" },
            { "type.cf.standard", "ܛܘܦܣܐ ܕܙܘ̈ܙܐ ܫܪܫܝܐ" },
            { "type.co.standard", "ܛܟ݂ܣܐ ܦܘܪܫܢܝܐ ܫܪܫܝܐ" },
            { "type.ms.uksystem", "ܛܟܣܐ ܕܟܝܠܬܐ ܒܪܝܛܢܝܝܐ" },
            { "type.ms.ussystem", "ܛܟܣܐ ܕܟܝܠܬܐ ܐܡܪܝܟܝܐ" },
            { "type.ca.gregorian", "ܣܘܪܓܕܐ ܓܪܝܓܘܪܝܐ" },
            { "type.co.phonebook", "ܟܬܒܐ ܕܡܢܝ̈ܢܐ ܕܬܝܠܝܦܘܢ" },
            { "type.co.dictionary", "ܛܟ݂ܣܐ ܦܘܪܫܢܝܐ ܕܠܟܣܝܩܘܢ" },
            { "type.co.traditional", "ܛܟ݂ܣܐ ܦܘܪܫܢܝܐ ܥܝܕ݂ܝܐ" },
            { "type.ca.islamic-civil", "ܣܘܪܓܕܐ ܡܫܠܡܢܐ ܡܕܝܢܝܐ" },
            { "ListCompositionPattern", "{0}، {1}" },
        };
        return data;
    }
}
