/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl.jetty;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.BytesContentProvider;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.jupnp.http.Headers;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.UpnpHeaders;
import org.jupnp.model.message.UpnpMessage;
import org.jupnp.model.message.UpnpOperation;
import org.jupnp.model.message.UpnpRequest;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.transport.impl.jetty.HeaderUtil;
import org.jupnp.transport.impl.jetty.StreamClientConfigurationImpl;
import org.jupnp.transport.spi.AbstractStreamClient;
import org.jupnp.transport.spi.InitializationException;
import org.jupnp.transport.spi.StreamClient;
import org.jupnp.util.SpecificationViolationReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyStreamClientImpl
extends AbstractStreamClient<StreamClientConfigurationImpl, Request> {
    private final Logger logger = LoggerFactory.getLogger(StreamClient.class);
    protected final StreamClientConfigurationImpl configuration;
    protected final HttpClient httpClient;
    protected final HttpFields defaultHttpFields = new HttpFields();

    public JettyStreamClientImpl(StreamClientConfigurationImpl configuration) throws InitializationException {
        this.configuration = configuration;
        this.httpClient = new HttpClient();
        this.httpClient.setConnectTimeout((long)((this.getConfiguration().getTimeoutSeconds() + 5) * 1000));
        this.httpClient.setMaxConnectionsPerDestination(2);
        int cpus = Runtime.getRuntime().availableProcessors();
        int maxThreads = 5 * cpus;
        QueuedThreadPool queuedThreadPool = this.createThreadPool("jupnp-jetty-client", 5, maxThreads, 60000);
        this.httpClient.setExecutor((Executor)queuedThreadPool);
        if (this.getConfiguration().getSocketBufferSize() != -1) {
            this.httpClient.setRequestBufferSize(this.getConfiguration().getSocketBufferSize());
            this.httpClient.setResponseBufferSize(this.getConfiguration().getSocketBufferSize());
        }
        try {
            this.httpClient.start();
        }
        catch (Exception e) {
            this.logger.error("Failed to instantiate HTTP client", (Throwable)e);
            throw new InitializationException("Failed to instantiate HTTP client", e);
        }
    }

    @Override
    public StreamClientConfigurationImpl getConfiguration() {
        return this.configuration;
    }

    @Override
    protected Request createRequest(StreamRequestMessage requestMessage) {
        Request request;
        UpnpRequest upnpRequest = (UpnpRequest)requestMessage.getOperation();
        this.logger.trace("Creating HTTP request. URI: '{}' method: '{}'", (Object)upnpRequest.getURI(), (Object)upnpRequest.getMethod());
        switch (upnpRequest.getMethod()) {
            case GET: 
            case SUBSCRIBE: 
            case UNSUBSCRIBE: 
            case POST: 
            case NOTIFY: {
                try {
                    request = this.httpClient.newRequest(upnpRequest.getURI()).method(upnpRequest.getHttpMethodName());
                    break;
                }
                catch (IllegalArgumentException e) {
                    this.logger.debug("Cannot create request because URI '{}' is invalid", (Object)upnpRequest.getURI(), (Object)e);
                    return null;
                }
            }
            default: {
                throw new RuntimeException("Unknown HTTP method: " + upnpRequest.getHttpMethodName());
            }
        }
        switch (upnpRequest.getMethod()) {
            case POST: 
            case NOTIFY: {
                request.content((ContentProvider)this.createContentProvider(requestMessage));
                break;
            }
        }
        request.getHeaders().add(this.defaultHttpFields);
        if (((UpnpRequest)requestMessage.getOperation()).getHttpMinorVersion() == 0) {
            request.version(HttpVersion.HTTP_1_0);
        } else {
            request.version(HttpVersion.HTTP_1_1);
            request.header(HttpHeader.CONNECTION, "close");
        }
        if (!requestMessage.getHeaders().containsKey(UpnpHeader.Type.USER_AGENT)) {
            request.agent(this.getConfiguration().getUserAgentValue(requestMessage.getUdaMajorVersion(), requestMessage.getUdaMinorVersion()));
        }
        HeaderUtil.add(request, (Headers)requestMessage.getHeaders());
        return request;
    }

    @Override
    protected Callable<StreamResponseMessage> createCallable(StreamRequestMessage requestMessage, Request request) {
        return () -> {
            this.logger.trace("Sending HTTP request: {}", (Object)requestMessage);
            try {
                ContentResponse httpResponse = request.send();
                this.logger.trace("Received HTTP response: {}", (Object)httpResponse.getReason());
                UpnpResponse responseOperation = new UpnpResponse(httpResponse.getStatus(), httpResponse.getReason());
                StreamResponseMessage responseMessage = new StreamResponseMessage(responseOperation);
                responseMessage.setHeaders(new UpnpHeaders(HeaderUtil.get((Response)httpResponse)));
                byte[] bytes = httpResponse.getContent();
                if (bytes == null || 0 == bytes.length) {
                    this.logger.trace("HTTP response message has no entity");
                    return responseMessage;
                }
                if (responseMessage.isContentTypeMissingOrText()) {
                    this.logger.trace("HTTP response message contains text entity");
                } else {
                    this.logger.trace("HTTP response message contains binary entity");
                }
                responseMessage.setBodyCharacters(bytes);
                return responseMessage;
            }
            catch (RuntimeException e) {
                this.logger.error("Request: {} failed", (Object)request, (Object)e);
                throw e;
            }
        };
    }

    @Override
    protected void abort(Request request) {
        request.abort((Throwable)new Exception("Request aborted by API"));
    }

    @Override
    protected boolean logExecutionException(Throwable t) {
        if (t == null) {
            return false;
        }
        if (t instanceof IllegalStateException) {
            this.logger.trace("Illegal state: {}", (Object)t.getMessage());
            return true;
        }
        String msg = t.getMessage();
        if (msg != null && msg.contains("HTTP protocol violation")) {
            SpecificationViolationReporter.report(msg, new Object[0]);
            return true;
        }
        return false;
    }

    @Override
    public void stop() {
        this.logger.trace("Shutting down HTTP client connection manager/pool");
        try {
            this.httpClient.stop();
        }
        catch (Exception e) {
            this.logger.info("Shutting down of HTTP client throwed exception", (Throwable)e);
        }
    }

    protected <O extends UpnpOperation> ContentProvider.Typed createContentProvider(UpnpMessage<O> upnpMessage) {
        if (upnpMessage.getBodyType().equals((Object)UpnpMessage.BodyType.STRING)) {
            this.logger.trace("Preparing HTTP request entity as String");
            return new StringContentProvider(upnpMessage.getBodyString(), upnpMessage.getContentTypeCharset());
        }
        this.logger.trace("Preparing HTTP request entity as byte[]");
        return new BytesContentProvider((byte[][])new byte[][]{upnpMessage.getBodyBytes()});
    }

    private QueuedThreadPool createThreadPool(String consumerName, int minThreads, int maxThreads, int keepAliveTimeout) {
        QueuedThreadPool queuedThreadPool = new QueuedThreadPool(maxThreads, minThreads, keepAliveTimeout);
        queuedThreadPool.setName(consumerName);
        queuedThreadPool.setDaemon(true);
        return queuedThreadPool;
    }
}

