/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.impl.async;

import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jupnp.model.message.Connection;
import org.jupnp.transport.Router;
import org.jupnp.transport.impl.ServletConnection;
import org.jupnp.transport.impl.ServletStreamServerConfigurationImpl;
import org.jupnp.transport.impl.async.AsyncServletUpnpStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncServlet
extends HttpServlet {
    private static final long serialVersionUID = -5751553619541219814L;
    private final Logger logger = LoggerFactory.getLogger(AsyncServlet.class);
    private final Router router;
    private int mCounter = 0;
    private final ServletStreamServerConfigurationImpl configuration;

    public AsyncServlet(Router router, ServletStreamServerConfigurationImpl configuration) {
        this.router = router;
        this.configuration = configuration;
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        final long startTime = System.currentTimeMillis();
        final int counter = this.mCounter++;
        this.logger.info("{}", (Object)String.format("HttpServlet.service(): id: %3d, request URI: %s", counter, req.getRequestURI()));
        this.logger.debug("Handling Servlet request asynchronously: {}", (Object)req);
        AsyncContext async = req.startAsync();
        async.setTimeout((long)(this.configuration.getAsyncTimeoutSeconds() * 1000));
        async.addListener(new AsyncListener(){
            final /* synthetic */ AsyncServlet this$0;
            {
                this.this$0 = this$0;
            }

            public void onTimeout(AsyncEvent arg0) throws IOException {
                long duration = System.currentTimeMillis() - startTime;
                this.this$0.logger.debug("{}", (Object)String.format("AsyncListener.onTimeout(): id: %3d, duration: %,4d, request: %s", counter, duration, arg0.getSuppliedRequest()));
            }

            public void onStartAsync(AsyncEvent arg0) throws IOException {
                this.this$0.logger.debug("{}", (Object)String.format("AsyncListener.onStartAsync(): id: %3d, request: %s", counter, arg0.getSuppliedRequest()));
            }

            public void onError(AsyncEvent arg0) throws IOException {
                long duration = System.currentTimeMillis() - startTime;
                this.this$0.logger.debug("{}", (Object)String.format("AsyncListener.onError(): id: %3d, duration: %,4d, response: %s", counter, duration, arg0.getSuppliedResponse()));
            }

            public void onComplete(AsyncEvent arg0) throws IOException {
                long duration = System.currentTimeMillis() - startTime;
                this.this$0.logger.debug("{}", (Object)String.format("AsyncListener.onComplete(): id: %3d, duration: %,4d, response: %s", counter, duration, arg0.getSuppliedResponse()));
            }
        });
        AsyncServletUpnpStream stream = new AsyncServletUpnpStream(this.router.getProtocolFactory(), async, req){

            @Override
            protected Connection createConnection() {
                return new ServletConnection(this.getRequest());
            }
        };
        this.router.received(stream);
    }
}

