/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.model;

import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.io.JBBPBitNumber;
import com.igormaznitsa.jbbp.model.BitEntity;
import com.igormaznitsa.jbbp.model.JBBPAbstractArrayField;
import com.igormaznitsa.jbbp.model.JBBPFieldBit;
import com.igormaznitsa.jbbp.model.JBBPNumericArray;
import com.igormaznitsa.jbbp.utils.JBBPUtils;

public final class JBBPFieldArrayBit
extends JBBPAbstractArrayField<JBBPFieldBit>
implements BitEntity,
JBBPNumericArray {
    private static final long serialVersionUID = -4589044511663149591L;
    private final JBBPBitNumber bitNumber;
    private final byte[] array;

    public JBBPFieldArrayBit(JBBPNamedFieldInfo name, byte[] array, JBBPBitNumber bitNumber) {
        super(name);
        JBBPUtils.assertNotNull(array, "Array must not be null");
        JBBPUtils.assertNotNull((Object)bitNumber, "Bit number must not be null");
        this.array = array;
        this.bitNumber = bitNumber;
    }

    public byte[] getArray() {
        return (byte[])this.array.clone();
    }

    @Override
    public JBBPBitNumber getBitWidth() {
        return this.bitNumber;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public JBBPFieldBit getElementAt(int index) {
        JBBPFieldBit result = new JBBPFieldBit(this.fieldNameInfo, this.getAsInt(index), this.bitNumber);
        result.payload = this.payload;
        return result;
    }

    @Override
    public int getAsInt(int index) {
        return this.array[index] & 0xFF;
    }

    @Override
    public long getAsLong(int index) {
        return this.getAsInt(index);
    }

    @Override
    public boolean getAsBool(int index) {
        return this.array[index] != 0;
    }

    @Override
    public Object getValueArrayAsObject(boolean reverseBits) {
        byte[] result;
        if (reverseBits) {
            result = (byte[])this.array.clone();
            for (int i = 0; i < result.length; ++i) {
                result[i] = (byte)JBBPFieldBit.reverseBits(result[i], this.bitNumber);
            }
        } else {
            result = (byte[])this.array.clone();
        }
        return result;
    }

    @Override
    public String getTypeAsString() {
        return "bit:" + this.bitNumber.getBitNumber() + " [" + this.array.length + "]";
    }
}

