/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.jbosh;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.igniterealtime.jbosh.AbstractBody;
import org.igniterealtime.jbosh.BOSHException;
import org.igniterealtime.jbosh.BodyParser;
import org.igniterealtime.jbosh.BodyParserResults;
import org.igniterealtime.jbosh.BodyQName;
import org.igniterealtime.jbosh.ServiceLib;

public final class StaticBody
extends AbstractBody {
    private static final BodyParser PARSER = ServiceLib.loadService(BodyParser.class);
    private static final int BUFFER_SIZE = 1024;
    private final Map<BodyQName, String> attrs;
    private final String raw;

    private StaticBody(Map<BodyQName, String> attrMap, String rawXML) {
        this.attrs = attrMap;
        this.raw = rawXML;
    }

    public static StaticBody fromStream(InputStream inStream) throws BOSHException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            int read2;
            byte[] buffer = new byte[1024];
            do {
                if ((read2 = inStream.read(buffer)) <= 0) continue;
                byteOut.write(buffer, 0, read2);
            } while (read2 >= 0);
        }
        catch (IOException iox) {
            throw new BOSHException("Could not read body data", iox);
        }
        return StaticBody.fromString(byteOut.toString());
    }

    public static StaticBody fromString(String rawXML) throws BOSHException {
        BodyParserResults results = PARSER.parse(rawXML);
        return new StaticBody(results.getAttributes(), rawXML);
    }

    @Override
    public Map<BodyQName, String> getAttributes() {
        return Collections.unmodifiableMap(this.attrs);
    }

    @Override
    public String toXML() {
        return this.raw;
    }
}

