// Code generated by smithy-go-codegen DO NOT EDIT.

package ecr

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/ecr/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpBatchCheckLayerAvailability struct {
}

func (*validateOpBatchCheckLayerAvailability) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpBatchCheckLayerAvailability) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*BatchCheckLayerAvailabilityInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpBatchCheckLayerAvailabilityInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpBatchDeleteImage struct {
}

func (*validateOpBatchDeleteImage) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpBatchDeleteImage) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*BatchDeleteImageInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpBatchDeleteImageInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpBatchGetImage struct {
}

func (*validateOpBatchGetImage) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpBatchGetImage) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*BatchGetImageInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpBatchGetImageInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpBatchGetRepositoryScanningConfiguration struct {
}

func (*validateOpBatchGetRepositoryScanningConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpBatchGetRepositoryScanningConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*BatchGetRepositoryScanningConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpBatchGetRepositoryScanningConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCompleteLayerUpload struct {
}

func (*validateOpCompleteLayerUpload) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCompleteLayerUpload) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CompleteLayerUploadInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCompleteLayerUploadInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreatePullThroughCacheRule struct {
}

func (*validateOpCreatePullThroughCacheRule) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreatePullThroughCacheRule) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreatePullThroughCacheRuleInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreatePullThroughCacheRuleInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateRepository struct {
}

func (*validateOpCreateRepository) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateRepository) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateRepositoryInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateRepositoryInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteLifecyclePolicy struct {
}

func (*validateOpDeleteLifecyclePolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteLifecyclePolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteLifecyclePolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteLifecyclePolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeletePullThroughCacheRule struct {
}

func (*validateOpDeletePullThroughCacheRule) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeletePullThroughCacheRule) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeletePullThroughCacheRuleInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeletePullThroughCacheRuleInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteRepository struct {
}

func (*validateOpDeleteRepository) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteRepository) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteRepositoryInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteRepositoryInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteRepositoryPolicy struct {
}

func (*validateOpDeleteRepositoryPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteRepositoryPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteRepositoryPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteRepositoryPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeImageReplicationStatus struct {
}

func (*validateOpDescribeImageReplicationStatus) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeImageReplicationStatus) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeImageReplicationStatusInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeImageReplicationStatusInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeImageScanFindings struct {
}

func (*validateOpDescribeImageScanFindings) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeImageScanFindings) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeImageScanFindingsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeImageScanFindingsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeImages struct {
}

func (*validateOpDescribeImages) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeImages) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeImagesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeImagesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetDownloadUrlForLayer struct {
}

func (*validateOpGetDownloadUrlForLayer) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetDownloadUrlForLayer) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetDownloadUrlForLayerInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetDownloadUrlForLayerInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetLifecyclePolicy struct {
}

func (*validateOpGetLifecyclePolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetLifecyclePolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetLifecyclePolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetLifecyclePolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetLifecyclePolicyPreview struct {
}

func (*validateOpGetLifecyclePolicyPreview) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetLifecyclePolicyPreview) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetLifecyclePolicyPreviewInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetLifecyclePolicyPreviewInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetRepositoryPolicy struct {
}

func (*validateOpGetRepositoryPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetRepositoryPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetRepositoryPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetRepositoryPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpInitiateLayerUpload struct {
}

func (*validateOpInitiateLayerUpload) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpInitiateLayerUpload) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*InitiateLayerUploadInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpInitiateLayerUploadInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListImages struct {
}

func (*validateOpListImages) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListImages) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListImagesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListImagesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutImage struct {
}

func (*validateOpPutImage) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutImage) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutImageInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutImageInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutImageScanningConfiguration struct {
}

func (*validateOpPutImageScanningConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutImageScanningConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutImageScanningConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutImageScanningConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutImageTagMutability struct {
}

func (*validateOpPutImageTagMutability) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutImageTagMutability) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutImageTagMutabilityInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutImageTagMutabilityInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutLifecyclePolicy struct {
}

func (*validateOpPutLifecyclePolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutLifecyclePolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutLifecyclePolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutLifecyclePolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutRegistryPolicy struct {
}

func (*validateOpPutRegistryPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutRegistryPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutRegistryPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutRegistryPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutRegistryScanningConfiguration struct {
}

func (*validateOpPutRegistryScanningConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutRegistryScanningConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutRegistryScanningConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutRegistryScanningConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutReplicationConfiguration struct {
}

func (*validateOpPutReplicationConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutReplicationConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutReplicationConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutReplicationConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpSetRepositoryPolicy struct {
}

func (*validateOpSetRepositoryPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpSetRepositoryPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*SetRepositoryPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpSetRepositoryPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartImageScan struct {
}

func (*validateOpStartImageScan) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartImageScan) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartImageScanInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartImageScanInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartLifecyclePolicyPreview struct {
}

func (*validateOpStartLifecyclePolicyPreview) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartLifecyclePolicyPreview) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartLifecyclePolicyPreviewInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartLifecyclePolicyPreviewInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdatePullThroughCacheRule struct {
}

func (*validateOpUpdatePullThroughCacheRule) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdatePullThroughCacheRule) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdatePullThroughCacheRuleInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdatePullThroughCacheRuleInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUploadLayerPart struct {
}

func (*validateOpUploadLayerPart) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUploadLayerPart) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UploadLayerPartInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUploadLayerPartInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpValidatePullThroughCacheRule struct {
}

func (*validateOpValidatePullThroughCacheRule) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpValidatePullThroughCacheRule) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ValidatePullThroughCacheRuleInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpValidatePullThroughCacheRuleInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpBatchCheckLayerAvailabilityValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpBatchCheckLayerAvailability{}, middleware.After)
}

func addOpBatchDeleteImageValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpBatchDeleteImage{}, middleware.After)
}

func addOpBatchGetImageValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpBatchGetImage{}, middleware.After)
}

func addOpBatchGetRepositoryScanningConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpBatchGetRepositoryScanningConfiguration{}, middleware.After)
}

func addOpCompleteLayerUploadValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCompleteLayerUpload{}, middleware.After)
}

func addOpCreatePullThroughCacheRuleValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreatePullThroughCacheRule{}, middleware.After)
}

func addOpCreateRepositoryValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateRepository{}, middleware.After)
}

func addOpDeleteLifecyclePolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteLifecyclePolicy{}, middleware.After)
}

func addOpDeletePullThroughCacheRuleValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeletePullThroughCacheRule{}, middleware.After)
}

func addOpDeleteRepositoryValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteRepository{}, middleware.After)
}

func addOpDeleteRepositoryPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteRepositoryPolicy{}, middleware.After)
}

func addOpDescribeImageReplicationStatusValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeImageReplicationStatus{}, middleware.After)
}

func addOpDescribeImageScanFindingsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeImageScanFindings{}, middleware.After)
}

func addOpDescribeImagesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeImages{}, middleware.After)
}

func addOpGetDownloadUrlForLayerValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetDownloadUrlForLayer{}, middleware.After)
}

func addOpGetLifecyclePolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetLifecyclePolicy{}, middleware.After)
}

func addOpGetLifecyclePolicyPreviewValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetLifecyclePolicyPreview{}, middleware.After)
}

func addOpGetRepositoryPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetRepositoryPolicy{}, middleware.After)
}

func addOpInitiateLayerUploadValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpInitiateLayerUpload{}, middleware.After)
}

func addOpListImagesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListImages{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpPutImageValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutImage{}, middleware.After)
}

func addOpPutImageScanningConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutImageScanningConfiguration{}, middleware.After)
}

func addOpPutImageTagMutabilityValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutImageTagMutability{}, middleware.After)
}

func addOpPutLifecyclePolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutLifecyclePolicy{}, middleware.After)
}

func addOpPutRegistryPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutRegistryPolicy{}, middleware.After)
}

func addOpPutRegistryScanningConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutRegistryScanningConfiguration{}, middleware.After)
}

func addOpPutReplicationConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutReplicationConfiguration{}, middleware.After)
}

func addOpSetRepositoryPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpSetRepositoryPolicy{}, middleware.After)
}

func addOpStartImageScanValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartImageScan{}, middleware.After)
}

func addOpStartLifecyclePolicyPreviewValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartLifecyclePolicyPreview{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdatePullThroughCacheRuleValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdatePullThroughCacheRule{}, middleware.After)
}

func addOpUploadLayerPartValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUploadLayerPart{}, middleware.After)
}

func addOpValidatePullThroughCacheRuleValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpValidatePullThroughCacheRule{}, middleware.After)
}

func validateEncryptionConfiguration(v *types.EncryptionConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EncryptionConfiguration"}
	if len(v.EncryptionType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("EncryptionType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRegistryScanningRule(v *types.RegistryScanningRule) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RegistryScanningRule"}
	if len(v.ScanFrequency) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ScanFrequency"))
	}
	if v.RepositoryFilters == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RepositoryFilters"))
	} else if v.RepositoryFilters != nil {
		if err := validateScanningRepositoryFilterList(v.RepositoryFilters); err != nil {
			invalidParams.AddNested("RepositoryFilters", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRegistryScanningRuleList(v []types.RegistryScanningRule) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RegistryScanningRuleList"}
	for i := range v {
		if err := validateRegistryScanningRule(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateReplicationConfiguration(v *types.ReplicationConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ReplicationConfiguration"}
	if v.Rules == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Rules"))
	} else if v.Rules != nil {
		if err := validateReplicationRuleList(v.Rules); err != nil {
			invalidParams.AddNested("Rules", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateReplicationDestination(v *types.ReplicationDestination) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ReplicationDestination"}
	if v.Region == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Region"))
	}
	if v.RegistryId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RegistryId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateReplicationDestinationList(v []types.ReplicationDestination) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ReplicationDestinationList"}
	for i := range v {
		if err := validateReplicationDestination(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateReplicationRule(v *types.ReplicationRule) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ReplicationRule"}
	if v.Destinations == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Destinations"))
	} else if v.Destinations != nil {
		if err := validateReplicationDestinationList(v.Destinations); err != nil {
			invalidParams.AddNested("Destinations", err.(smithy.InvalidParamsError))
		}
	}
	if v.RepositoryFilters != nil {
		if err := validateRepositoryFilterList(v.RepositoryFilters); err != nil {
			invalidParams.AddNested("RepositoryFilters", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateReplicationRuleList(v []types.ReplicationRule) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ReplicationRuleList"}
	for i := range v {
		if err := validateReplicationRule(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRepositoryFilter(v *types.RepositoryFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RepositoryFilter"}
	if v.Filter == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Filter"))
	}
	if len(v.FilterType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("FilterType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRepositoryFilterList(v []types.RepositoryFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RepositoryFilterList"}
	for i := range v {
		if err := validateRepositoryFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateScanningRepositoryFilter(v *types.ScanningRepositoryFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ScanningRepositoryFilter"}
	if v.Filter == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Filter"))
	}
	if len(v.FilterType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("FilterType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateScanningRepositoryFilterList(v []types.ScanningRepositoryFilter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ScanningRepositoryFilterList"}
	for i := range v {
		if err := validateScanningRepositoryFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTag(v *types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Tag"}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTagList(v []types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagList"}
	for i := range v {
		if err := validateTag(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpBatchCheckLayerAvailabilityInput(v *BatchCheckLayerAvailabilityInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BatchCheckLayerAvailabilityInput"}
	if v.RepositoryName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RepositoryName"))
	}
	if v.LayerDigests == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LayerDigests"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpBatchDeleteImageInput(v *BatchDeleteImageInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BatchDeleteImageInput"}
	if v.RepositoryName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RepositoryName"))
	}
	if v.ImageIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ImageIds"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpBatchGetImageInput(v *BatchGetImageInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BatchGetImageInput"}
	if v.RepositoryName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RepositoryName"))
	}
	if v.ImageIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ImageIds"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpBatchGetRepositoryScanningConfigurationInput(v *BatchGetRepositoryScanningConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "BatchGetRepositoryScanningConfigurationInput"}
	if v.RepositoryNames == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RepositoryNames"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCompleteLayerUploadInput(v *CompleteLayerUploadInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CompleteLayerUploadInput"}
	if v.RepositoryName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RepositoryName"))
	}
	if v.UploadId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("UploadId"))
	}
	if v.LayerDigests == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LayerDigests"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreatePullThroughCacheRuleInput(v *CreatePullThroughCacheRuleInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreatePullThroughCacheRuleInput"}
	if v.EcrRepositoryPrefix == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EcrRepositoryPrefix"))
	}
	if v.UpstreamRegistryUrl == nil {
		invalidParams.Add(smithy.NewErrParamRequired("UpstreamRegistryUrl"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateRepositoryInput(v *CreateRepositoryInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateRepositoryInput"}
	if v.RepositoryName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RepositoryName"))
	}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if v.EncryptionConfiguration != nil {
		if err := validateEncryptionConfiguration(v.EncryptionConfiguration); err != nil {
			invalidParams.AddNested("EncryptionConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteLifecyclePolicyInput(v *DeleteLifecyclePolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteLifecyclePolicyInput"}
	if v.RepositoryName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RepositoryName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeletePullThroughCacheRuleInput(v *DeletePullThroughCacheRuleInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeletePullThroughCacheRuleInput"}
	if v.EcrRepositoryPrefix == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EcrRepositoryPrefix"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteRepositoryInput(v *DeleteRepositoryInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteRepositoryInput"}
	if v.RepositoryName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RepositoryName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteRepositoryPolicyInput(v *DeleteRepositoryPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteRepositoryPolicyInput"}
	if v.RepositoryName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RepositoryName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeImageReplicationStatusInput(v *DescribeImageReplicationStatusInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeImageReplicationStatusInput"}
	if v.RepositoryName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RepositoryName"))
	}
	if v.ImageId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ImageId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeImageScanFindingsInput(v *DescribeImageScanFindingsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeImageScanFindingsInput"}
	if v.RepositoryName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RepositoryName"))
	}
	if v.ImageId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ImageId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeImagesInput(v *DescribeImagesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeImagesInput"}
	if v.RepositoryName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RepositoryName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetDownloadUrlForLayerInput(v *GetDownloadUrlForLayerInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetDownloadUrlForLayerInput"}
	if v.RepositoryName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RepositoryName"))
	}
	if v.LayerDigest == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LayerDigest"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetLifecyclePolicyInput(v *GetLifecyclePolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetLifecyclePolicyInput"}
	if v.RepositoryName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RepositoryName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetLifecyclePolicyPreviewInput(v *GetLifecyclePolicyPreviewInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetLifecyclePolicyPreviewInput"}
	if v.RepositoryName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RepositoryName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetRepositoryPolicyInput(v *GetRepositoryPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetRepositoryPolicyInput"}
	if v.RepositoryName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RepositoryName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpInitiateLayerUploadInput(v *InitiateLayerUploadInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InitiateLayerUploadInput"}
	if v.RepositoryName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RepositoryName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListImagesInput(v *ListImagesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListImagesInput"}
	if v.RepositoryName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RepositoryName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutImageInput(v *PutImageInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutImageInput"}
	if v.RepositoryName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RepositoryName"))
	}
	if v.ImageManifest == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ImageManifest"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutImageScanningConfigurationInput(v *PutImageScanningConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutImageScanningConfigurationInput"}
	if v.RepositoryName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RepositoryName"))
	}
	if v.ImageScanningConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ImageScanningConfiguration"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutImageTagMutabilityInput(v *PutImageTagMutabilityInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutImageTagMutabilityInput"}
	if v.RepositoryName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RepositoryName"))
	}
	if len(v.ImageTagMutability) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ImageTagMutability"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutLifecyclePolicyInput(v *PutLifecyclePolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutLifecyclePolicyInput"}
	if v.RepositoryName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RepositoryName"))
	}
	if v.LifecyclePolicyText == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LifecyclePolicyText"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutRegistryPolicyInput(v *PutRegistryPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutRegistryPolicyInput"}
	if v.PolicyText == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PolicyText"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutRegistryScanningConfigurationInput(v *PutRegistryScanningConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutRegistryScanningConfigurationInput"}
	if v.Rules != nil {
		if err := validateRegistryScanningRuleList(v.Rules); err != nil {
			invalidParams.AddNested("Rules", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutReplicationConfigurationInput(v *PutReplicationConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutReplicationConfigurationInput"}
	if v.ReplicationConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ReplicationConfiguration"))
	} else if v.ReplicationConfiguration != nil {
		if err := validateReplicationConfiguration(v.ReplicationConfiguration); err != nil {
			invalidParams.AddNested("ReplicationConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpSetRepositoryPolicyInput(v *SetRepositoryPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SetRepositoryPolicyInput"}
	if v.RepositoryName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RepositoryName"))
	}
	if v.PolicyText == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PolicyText"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartImageScanInput(v *StartImageScanInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartImageScanInput"}
	if v.RepositoryName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RepositoryName"))
	}
	if v.ImageId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ImageId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartLifecyclePolicyPreviewInput(v *StartLifecyclePolicyPreviewInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartLifecyclePolicyPreviewInput"}
	if v.RepositoryName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RepositoryName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	} else if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdatePullThroughCacheRuleInput(v *UpdatePullThroughCacheRuleInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdatePullThroughCacheRuleInput"}
	if v.EcrRepositoryPrefix == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EcrRepositoryPrefix"))
	}
	if v.CredentialArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CredentialArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUploadLayerPartInput(v *UploadLayerPartInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UploadLayerPartInput"}
	if v.RepositoryName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RepositoryName"))
	}
	if v.UploadId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("UploadId"))
	}
	if v.PartFirstByte == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PartFirstByte"))
	}
	if v.PartLastByte == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PartLastByte"))
	}
	if v.LayerPartBlob == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LayerPartBlob"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpValidatePullThroughCacheRuleInput(v *ValidatePullThroughCacheRuleInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ValidatePullThroughCacheRuleInput"}
	if v.EcrRepositoryPrefix == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EcrRepositoryPrefix"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
