// This code is automatically generated. DO NOT MODIFY.
//
// Instead, modify `crates/stdarch-gen-arm/spec/` and run the following command to re-generate this file:
//
// ```
// cargo run --bin=stdarch-gen-arm -- crates/stdarch-gen-arm/spec
// ```
#![allow(improper_ctypes)]

#[cfg(test)]
use stdarch_test::assert_instr;

use super::*;

#[doc = "CRC32 single round checksum for bytes (8 bits)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/__crc32b)"]
#[inline]
#[target_feature(enable = "crc")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(test, assert_instr(crc32b))]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_aarch32_crc32", issue = "125085")
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_aarch64_crc32", since = "1.80.0")
)]
pub fn __crc32b(crc: u32, data: u8) -> u32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crc32b"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.crc32b")]
        fn ___crc32b(crc: u32, data: u32) -> u32;
    }
    unsafe { ___crc32b(crc, data as u32) }
}
#[doc = "CRC32-C single round checksum for bytes (8 bits)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/__crc32cb)"]
#[inline]
#[target_feature(enable = "crc")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(test, assert_instr(crc32cb))]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_aarch32_crc32", issue = "125085")
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_aarch64_crc32", since = "1.80.0")
)]
pub fn __crc32cb(crc: u32, data: u8) -> u32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crc32cb"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.crc32cb")]
        fn ___crc32cb(crc: u32, data: u32) -> u32;
    }
    unsafe { ___crc32cb(crc, data as u32) }
}
#[doc = "CRC32-C single round checksum for quad words (64 bits)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/__crc32cd)"]
#[inline]
#[target_feature(enable = "crc")]
#[cfg(target_arch = "arm")]
#[cfg_attr(test, assert_instr(crc32cw))]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_aarch32_crc32", issue = "125085")
)]
pub fn __crc32cd(crc: u32, data: u64) -> u32 {
    let b: u32 = (data & 0xFFFFFFFF) as u32;
    let c: u32 = (data >> 32) as u32;
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.crc32cw")]
        fn ___crc32cw(crc: u32, data: u32) -> u32;
    }
    unsafe { ___crc32cw(___crc32cw(crc, b), c) }
}
#[doc = "CRC32-C single round checksum for bytes (16 bits)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/__crc32ch)"]
#[inline]
#[target_feature(enable = "crc")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(test, assert_instr(crc32ch))]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_aarch32_crc32", issue = "125085")
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_aarch64_crc32", since = "1.80.0")
)]
pub fn __crc32ch(crc: u32, data: u16) -> u32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crc32ch"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.crc32ch")]
        fn ___crc32ch(crc: u32, data: u32) -> u32;
    }
    unsafe { ___crc32ch(crc, data as u32) }
}
#[doc = "CRC32-C single round checksum for bytes (32 bits)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/__crc32cw)"]
#[inline]
#[target_feature(enable = "crc")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(test, assert_instr(crc32cw))]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_aarch32_crc32", issue = "125085")
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_aarch64_crc32", since = "1.80.0")
)]
pub fn __crc32cw(crc: u32, data: u32) -> u32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crc32cw"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.crc32cw")]
        fn ___crc32cw(crc: u32, data: u32) -> u32;
    }
    unsafe { ___crc32cw(crc, data) }
}
#[doc = "CRC32 single round checksum for quad words (64 bits)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/__crc32d)"]
#[inline]
#[target_feature(enable = "crc")]
#[cfg(target_arch = "arm")]
#[cfg_attr(test, assert_instr(crc32w))]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_aarch32_crc32", issue = "125085")
)]
pub fn __crc32d(crc: u32, data: u64) -> u32 {
    let b: u32 = (data & 0xFFFFFFFF) as u32;
    let c: u32 = (data >> 32) as u32;
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.crc32w")]
        fn ___crc32w(crc: u32, data: u32) -> u32;
    }
    unsafe { ___crc32w(___crc32w(crc, b), c) }
}
#[doc = "CRC32 single round checksum for bytes (16 bits)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/__crc32h)"]
#[inline]
#[target_feature(enable = "crc")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(test, assert_instr(crc32h))]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_aarch32_crc32", issue = "125085")
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_aarch64_crc32", since = "1.80.0")
)]
pub fn __crc32h(crc: u32, data: u16) -> u32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crc32h"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.crc32h")]
        fn ___crc32h(crc: u32, data: u32) -> u32;
    }
    unsafe { ___crc32h(crc, data as u32) }
}
#[doc = "CRC32 single round checksum for bytes (32 bits)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/__crc32w)"]
#[inline]
#[target_feature(enable = "crc")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(test, assert_instr(crc32w))]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_aarch32_crc32", issue = "125085")
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_aarch64_crc32", since = "1.80.0")
)]
pub fn __crc32w(crc: u32, data: u32) -> u32 {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crc32w"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.crc32w")]
        fn ___crc32w(crc: u32, data: u32) -> u32;
    }
    unsafe { ___crc32w(crc, data) }
}
#[doc = "Signed Add and Accumulate Long Pairwise."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/priv_vpadal_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(target_arch = "arm")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vpadal.s8"))]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
fn priv_vpadal_s8(a: int16x4_t, b: int8x8_t) -> int16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vpadals.v4i16.v8i8")]
        fn _priv_vpadal_s8(a: int16x4_t, b: int8x8_t) -> int16x4_t;
    }
    unsafe { _priv_vpadal_s8(a, b) }
}
#[doc = "Signed Add and Accumulate Long Pairwise."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/priv_vpadalq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(target_arch = "arm")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vpadal.s8"))]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
fn priv_vpadalq_s8(a: int16x8_t, b: int8x16_t) -> int16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vpadals.v8i16.v16i8")]
        fn _priv_vpadalq_s8(a: int16x8_t, b: int8x16_t) -> int16x8_t;
    }
    unsafe { _priv_vpadalq_s8(a, b) }
}
#[doc = "Signed Add and Accumulate Long Pairwise."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/priv_vpadal_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(target_arch = "arm")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vpadal.s16"))]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
fn priv_vpadal_s16(a: int32x2_t, b: int16x4_t) -> int32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vpadals.v2i32.v4i16")]
        fn _priv_vpadal_s16(a: int32x2_t, b: int16x4_t) -> int32x2_t;
    }
    unsafe { _priv_vpadal_s16(a, b) }
}
#[doc = "Signed Add and Accumulate Long Pairwise."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/priv_vpadalq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(target_arch = "arm")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vpadal.s16"))]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
fn priv_vpadalq_s16(a: int32x4_t, b: int16x8_t) -> int32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vpadals.v4i32.v8i16")]
        fn _priv_vpadalq_s16(a: int32x4_t, b: int16x8_t) -> int32x4_t;
    }
    unsafe { _priv_vpadalq_s16(a, b) }
}
#[doc = "Signed Add and Accumulate Long Pairwise."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/priv_vpadal_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(target_arch = "arm")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vpadal.s32"))]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
fn priv_vpadal_s32(a: int64x1_t, b: int32x2_t) -> int64x1_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vpadals.v1i64.v2i32")]
        fn _priv_vpadal_s32(a: int64x1_t, b: int32x2_t) -> int64x1_t;
    }
    unsafe { _priv_vpadal_s32(a, b) }
}
#[doc = "Signed Add and Accumulate Long Pairwise."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/priv_vpadalq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(target_arch = "arm")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vpadal.s32"))]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
fn priv_vpadalq_s32(a: int64x2_t, b: int32x4_t) -> int64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vpadals.v2i64.v4i32")]
        fn _priv_vpadalq_s32(a: int64x2_t, b: int32x4_t) -> int64x2_t;
    }
    unsafe { _priv_vpadalq_s32(a, b) }
}
#[doc = "Signed Add and Accumulate Long Pairwise."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/priv_vpadal_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(target_arch = "arm")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vpadal.u8"))]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
fn priv_vpadal_u8(a: uint16x4_t, b: uint8x8_t) -> uint16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vpadalu.v4i16.v8i8")]
        fn _priv_vpadal_u8(a: uint16x4_t, b: uint8x8_t) -> uint16x4_t;
    }
    unsafe { _priv_vpadal_u8(a, b) }
}
#[doc = "Signed Add and Accumulate Long Pairwise."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/priv_vpadalq_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(target_arch = "arm")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vpadal.u8"))]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
fn priv_vpadalq_u8(a: uint16x8_t, b: uint8x16_t) -> uint16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vpadalu.v8i16.v16i8")]
        fn _priv_vpadalq_u8(a: uint16x8_t, b: uint8x16_t) -> uint16x8_t;
    }
    unsafe { _priv_vpadalq_u8(a, b) }
}
#[doc = "Signed Add and Accumulate Long Pairwise."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/priv_vpadal_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(target_arch = "arm")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vpadal.u16"))]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
fn priv_vpadal_u16(a: uint32x2_t, b: uint16x4_t) -> uint32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vpadalu.v2i32.v4i16")]
        fn _priv_vpadal_u16(a: uint32x2_t, b: uint16x4_t) -> uint32x2_t;
    }
    unsafe { _priv_vpadal_u16(a, b) }
}
#[doc = "Signed Add and Accumulate Long Pairwise."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/priv_vpadalq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(target_arch = "arm")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vpadal.u16"))]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
fn priv_vpadalq_u16(a: uint32x4_t, b: uint16x8_t) -> uint32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vpadalu.v4i32.v8i16")]
        fn _priv_vpadalq_u16(a: uint32x4_t, b: uint16x8_t) -> uint32x4_t;
    }
    unsafe { _priv_vpadalq_u16(a, b) }
}
#[doc = "Signed Add and Accumulate Long Pairwise."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/priv_vpadal_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(target_arch = "arm")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vpadal.u32"))]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
fn priv_vpadal_u32(a: uint64x1_t, b: uint32x2_t) -> uint64x1_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vpadalu.v1i64.v2i32")]
        fn _priv_vpadal_u32(a: uint64x1_t, b: uint32x2_t) -> uint64x1_t;
    }
    unsafe { _priv_vpadal_u32(a, b) }
}
#[doc = "Signed Add and Accumulate Long Pairwise."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/priv_vpadalq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(target_arch = "arm")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vpadal.u32"))]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
fn priv_vpadalq_u32(a: uint64x2_t, b: uint32x4_t) -> uint64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vpadalu.v2i64.v4i32")]
        fn _priv_vpadalq_u32(a: uint64x2_t, b: uint32x4_t) -> uint64x2_t;
    }
    unsafe { _priv_vpadalq_u32(a, b) }
}
#[doc = "Absolute difference and accumulate (64-bit)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaba_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vaba.s16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(saba)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaba_s16(a: int16x4_t, b: int16x4_t, c: int16x4_t) -> int16x4_t {
    unsafe { simd_add(a, vabd_s16(b, c)) }
}
#[doc = "Absolute difference and accumulate (64-bit)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaba_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vaba.s32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(saba)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaba_s32(a: int32x2_t, b: int32x2_t, c: int32x2_t) -> int32x2_t {
    unsafe { simd_add(a, vabd_s32(b, c)) }
}
#[doc = "Absolute difference and accumulate (64-bit)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaba_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vaba.s8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(saba)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaba_s8(a: int8x8_t, b: int8x8_t, c: int8x8_t) -> int8x8_t {
    unsafe { simd_add(a, vabd_s8(b, c)) }
}
#[doc = "Absolute difference and accumulate (64-bit)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaba_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vaba.u16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uaba)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaba_u16(a: uint16x4_t, b: uint16x4_t, c: uint16x4_t) -> uint16x4_t {
    unsafe { simd_add(a, vabd_u16(b, c)) }
}
#[doc = "Absolute difference and accumulate (64-bit)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaba_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vaba.u32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uaba)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaba_u32(a: uint32x2_t, b: uint32x2_t, c: uint32x2_t) -> uint32x2_t {
    unsafe { simd_add(a, vabd_u32(b, c)) }
}
#[doc = "Absolute difference and accumulate (64-bit)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaba_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vaba.u8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uaba)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaba_u8(a: uint8x8_t, b: uint8x8_t, c: uint8x8_t) -> uint8x8_t {
    unsafe { simd_add(a, vabd_u8(b, c)) }
}
#[doc = "Signed Absolute difference and Accumulate Long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabal_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vabal.s8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(sabal)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabal_s8(a: int16x8_t, b: int8x8_t, c: int8x8_t) -> int16x8_t {
    let d: int8x8_t = vabd_s8(b, c);
    unsafe {
        let e: uint8x8_t = simd_cast(d);
        simd_add(a, simd_cast(e))
    }
}
#[doc = "Signed Absolute difference and Accumulate Long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabal_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vabal.s16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(sabal)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabal_s16(a: int32x4_t, b: int16x4_t, c: int16x4_t) -> int32x4_t {
    let d: int16x4_t = vabd_s16(b, c);
    unsafe {
        let e: uint16x4_t = simd_cast(d);
        simd_add(a, simd_cast(e))
    }
}
#[doc = "Signed Absolute difference and Accumulate Long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabal_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vabal.s32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(sabal)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabal_s32(a: int64x2_t, b: int32x2_t, c: int32x2_t) -> int64x2_t {
    let d: int32x2_t = vabd_s32(b, c);
    unsafe {
        let e: uint32x2_t = simd_cast(d);
        simd_add(a, simd_cast(e))
    }
}
#[doc = "Unsigned Absolute difference and Accumulate Long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabal_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vabal.u8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uabal)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabal_u8(a: uint16x8_t, b: uint8x8_t, c: uint8x8_t) -> uint16x8_t {
    let d: uint8x8_t = vabd_u8(b, c);
    unsafe { simd_add(a, simd_cast(d)) }
}
#[doc = "Unsigned Absolute difference and Accumulate Long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabal_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vabal.u16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uabal)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabal_u16(a: uint32x4_t, b: uint16x4_t, c: uint16x4_t) -> uint32x4_t {
    let d: uint16x4_t = vabd_u16(b, c);
    unsafe { simd_add(a, simd_cast(d)) }
}
#[doc = "Unsigned Absolute difference and Accumulate Long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabal_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vabal.u32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uabal)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabal_u32(a: uint64x2_t, b: uint32x2_t, c: uint32x2_t) -> uint64x2_t {
    let d: uint32x2_t = vabd_u32(b, c);
    unsafe { simd_add(a, simd_cast(d)) }
}
#[doc = "Absolute difference and accumulate (128-bit)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabaq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vaba.s16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(saba)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabaq_s16(a: int16x8_t, b: int16x8_t, c: int16x8_t) -> int16x8_t {
    unsafe { simd_add(a, vabdq_s16(b, c)) }
}
#[doc = "Absolute difference and accumulate (128-bit)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabaq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vaba.s32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(saba)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabaq_s32(a: int32x4_t, b: int32x4_t, c: int32x4_t) -> int32x4_t {
    unsafe { simd_add(a, vabdq_s32(b, c)) }
}
#[doc = "Absolute difference and accumulate (128-bit)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabaq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vaba.s8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(saba)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabaq_s8(a: int8x16_t, b: int8x16_t, c: int8x16_t) -> int8x16_t {
    unsafe { simd_add(a, vabdq_s8(b, c)) }
}
#[doc = "Absolute difference and accumulate (128-bit)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabaq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vaba.u16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uaba)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabaq_u16(a: uint16x8_t, b: uint16x8_t, c: uint16x8_t) -> uint16x8_t {
    unsafe { simd_add(a, vabdq_u16(b, c)) }
}
#[doc = "Absolute difference and accumulate (128-bit)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabaq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vaba.u32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uaba)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabaq_u32(a: uint32x4_t, b: uint32x4_t, c: uint32x4_t) -> uint32x4_t {
    unsafe { simd_add(a, vabdq_u32(b, c)) }
}
#[doc = "Absolute difference and accumulate (128-bit)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabaq_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vaba.u8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uaba)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabaq_u8(a: uint8x16_t, b: uint8x16_t, c: uint8x16_t) -> uint8x16_t {
    unsafe { simd_add(a, vabdq_u8(b, c)) }
}
#[doc = "Absolute difference between the arguments of Floating"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabd_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vabd.f16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fabd)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vabd_f16(a: float16x4_t, b: float16x4_t) -> float16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vabds.v4f16")]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fabd.v4f16"
        )]
        fn _vabd_f16(a: float16x4_t, b: float16x4_t) -> float16x4_t;
    }
    unsafe { _vabd_f16(a, b) }
}
#[doc = "Absolute difference between the arguments of Floating"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabdq_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vabd.f16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fabd)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vabdq_f16(a: float16x8_t, b: float16x8_t) -> float16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vabds.v8f16")]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fabd.v8f16"
        )]
        fn _vabdq_f16(a: float16x8_t, b: float16x8_t) -> float16x8_t;
    }
    unsafe { _vabdq_f16(a, b) }
}
#[doc = "Absolute difference between the arguments of Floating"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabd_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vabd.f32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fabd)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabd_f32(a: float32x2_t, b: float32x2_t) -> float32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vabds.v2f32")]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fabd.v2f32"
        )]
        fn _vabd_f32(a: float32x2_t, b: float32x2_t) -> float32x2_t;
    }
    unsafe { _vabd_f32(a, b) }
}
#[doc = "Absolute difference between the arguments of Floating"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabdq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vabd.f32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fabd)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabdq_f32(a: float32x4_t, b: float32x4_t) -> float32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vabds.v4f32")]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.fabd.v4f32"
        )]
        fn _vabdq_f32(a: float32x4_t, b: float32x4_t) -> float32x4_t;
    }
    unsafe { _vabdq_f32(a, b) }
}
#[doc = "Absolute difference between the arguments"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabd_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vabd.s8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(sabd)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabd_s8(a: int8x8_t, b: int8x8_t) -> int8x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sabd.v8i8"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vabds.v8i8")]
        fn _vabd_s8(a: int8x8_t, b: int8x8_t) -> int8x8_t;
    }
    unsafe { _vabd_s8(a, b) }
}
#[doc = "Absolute difference between the arguments"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabdq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vabd.s8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(sabd)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabdq_s8(a: int8x16_t, b: int8x16_t) -> int8x16_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sabd.v16i8"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vabds.v16i8")]
        fn _vabdq_s8(a: int8x16_t, b: int8x16_t) -> int8x16_t;
    }
    unsafe { _vabdq_s8(a, b) }
}
#[doc = "Absolute difference between the arguments"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabd_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vabd.s16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(sabd)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabd_s16(a: int16x4_t, b: int16x4_t) -> int16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sabd.v4i16"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vabds.v4i16")]
        fn _vabd_s16(a: int16x4_t, b: int16x4_t) -> int16x4_t;
    }
    unsafe { _vabd_s16(a, b) }
}
#[doc = "Absolute difference between the arguments"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabdq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vabd.s16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(sabd)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabdq_s16(a: int16x8_t, b: int16x8_t) -> int16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sabd.v8i16"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vabds.v8i16")]
        fn _vabdq_s16(a: int16x8_t, b: int16x8_t) -> int16x8_t;
    }
    unsafe { _vabdq_s16(a, b) }
}
#[doc = "Absolute difference between the arguments"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabd_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vabd.s32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(sabd)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabd_s32(a: int32x2_t, b: int32x2_t) -> int32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sabd.v2i32"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vabds.v2i32")]
        fn _vabd_s32(a: int32x2_t, b: int32x2_t) -> int32x2_t;
    }
    unsafe { _vabd_s32(a, b) }
}
#[doc = "Absolute difference between the arguments"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabdq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vabd.s32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(sabd)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabdq_s32(a: int32x4_t, b: int32x4_t) -> int32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sabd.v4i32"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vabds.v4i32")]
        fn _vabdq_s32(a: int32x4_t, b: int32x4_t) -> int32x4_t;
    }
    unsafe { _vabdq_s32(a, b) }
}
#[doc = "Absolute difference between the arguments"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabd_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vabd.u8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uabd)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabd_u8(a: uint8x8_t, b: uint8x8_t) -> uint8x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uabd.v8i8"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vabdu.v8i8")]
        fn _vabd_u8(a: uint8x8_t, b: uint8x8_t) -> uint8x8_t;
    }
    unsafe { _vabd_u8(a, b) }
}
#[doc = "Absolute difference between the arguments"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabdq_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vabd.u8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uabd)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabdq_u8(a: uint8x16_t, b: uint8x16_t) -> uint8x16_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uabd.v16i8"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vabdu.v16i8")]
        fn _vabdq_u8(a: uint8x16_t, b: uint8x16_t) -> uint8x16_t;
    }
    unsafe { _vabdq_u8(a, b) }
}
#[doc = "Absolute difference between the arguments"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabd_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vabd.u16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uabd)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabd_u16(a: uint16x4_t, b: uint16x4_t) -> uint16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uabd.v4i16"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vabdu.v4i16")]
        fn _vabd_u16(a: uint16x4_t, b: uint16x4_t) -> uint16x4_t;
    }
    unsafe { _vabd_u16(a, b) }
}
#[doc = "Absolute difference between the arguments"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabdq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vabd.u16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uabd)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabdq_u16(a: uint16x8_t, b: uint16x8_t) -> uint16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uabd.v8i16"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vabdu.v8i16")]
        fn _vabdq_u16(a: uint16x8_t, b: uint16x8_t) -> uint16x8_t;
    }
    unsafe { _vabdq_u16(a, b) }
}
#[doc = "Absolute difference between the arguments"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabd_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vabd.u32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uabd)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabd_u32(a: uint32x2_t, b: uint32x2_t) -> uint32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uabd.v2i32"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vabdu.v2i32")]
        fn _vabd_u32(a: uint32x2_t, b: uint32x2_t) -> uint32x2_t;
    }
    unsafe { _vabd_u32(a, b) }
}
#[doc = "Absolute difference between the arguments"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabdq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vabd.u32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uabd)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabdq_u32(a: uint32x4_t, b: uint32x4_t) -> uint32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uabd.v4i32"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vabdu.v4i32")]
        fn _vabdq_u32(a: uint32x4_t, b: uint32x4_t) -> uint32x4_t;
    }
    unsafe { _vabdq_u32(a, b) }
}
#[doc = "Signed Absolute difference Long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabdl_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vabdl.s8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(sabdl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabdl_s8(a: int8x8_t, b: int8x8_t) -> int16x8_t {
    unsafe {
        let c: uint8x8_t = simd_cast(vabd_s8(a, b));
        simd_cast(c)
    }
}
#[doc = "Signed Absolute difference Long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabdl_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vabdl.s16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(sabdl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabdl_s16(a: int16x4_t, b: int16x4_t) -> int32x4_t {
    unsafe {
        let c: uint16x4_t = simd_cast(vabd_s16(a, b));
        simd_cast(c)
    }
}
#[doc = "Signed Absolute difference Long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabdl_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vabdl.s32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(sabdl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabdl_s32(a: int32x2_t, b: int32x2_t) -> int64x2_t {
    unsafe {
        let c: uint32x2_t = simd_cast(vabd_s32(a, b));
        simd_cast(c)
    }
}
#[doc = "Unsigned Absolute difference Long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabdl_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vabdl.u8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uabdl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabdl_u8(a: uint8x8_t, b: uint8x8_t) -> uint16x8_t {
    unsafe { simd_cast(vabd_u8(a, b)) }
}
#[doc = "Unsigned Absolute difference Long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabdl_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vabdl.u16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uabdl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabdl_u16(a: uint16x4_t, b: uint16x4_t) -> uint32x4_t {
    unsafe { simd_cast(vabd_u16(a, b)) }
}
#[doc = "Unsigned Absolute difference Long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabdl_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vabdl.u32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uabdl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabdl_u32(a: uint32x2_t, b: uint32x2_t) -> uint64x2_t {
    unsafe { simd_cast(vabd_u32(a, b)) }
}
#[doc = "Floating-point absolute value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabs_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vabs))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fabs)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vabs_f16(a: float16x4_t) -> float16x4_t {
    unsafe { simd_fabs(a) }
}
#[doc = "Floating-point absolute value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabsq_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vabs))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fabs)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vabsq_f16(a: float16x8_t) -> float16x8_t {
    unsafe { simd_fabs(a) }
}
#[doc = "Floating-point absolute value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabs_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vabs))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fabs)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabs_f32(a: float32x2_t) -> float32x2_t {
    unsafe { simd_fabs(a) }
}
#[doc = "Floating-point absolute value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabsq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vabs))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fabs)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabsq_f32(a: float32x4_t) -> float32x4_t {
    unsafe { simd_fabs(a) }
}
#[doc = "Absolute value (wrapping)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabs_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vabs))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(abs)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabs_s8(a: int8x8_t) -> int8x8_t {
    unsafe {
        let neg: int8x8_t = simd_neg(a);
        let mask: int8x8_t = simd_ge(a, neg);
        simd_select(mask, a, neg)
    }
}
#[doc = "Absolute value (wrapping)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabsq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vabs))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(abs)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabsq_s8(a: int8x16_t) -> int8x16_t {
    unsafe {
        let neg: int8x16_t = simd_neg(a);
        let mask: int8x16_t = simd_ge(a, neg);
        simd_select(mask, a, neg)
    }
}
#[doc = "Absolute value (wrapping)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabs_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vabs))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(abs)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabs_s16(a: int16x4_t) -> int16x4_t {
    unsafe {
        let neg: int16x4_t = simd_neg(a);
        let mask: int16x4_t = simd_ge(a, neg);
        simd_select(mask, a, neg)
    }
}
#[doc = "Absolute value (wrapping)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabsq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vabs))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(abs)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabsq_s16(a: int16x8_t) -> int16x8_t {
    unsafe {
        let neg: int16x8_t = simd_neg(a);
        let mask: int16x8_t = simd_ge(a, neg);
        simd_select(mask, a, neg)
    }
}
#[doc = "Absolute value (wrapping)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabs_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vabs))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(abs)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabs_s32(a: int32x2_t) -> int32x2_t {
    unsafe {
        let neg: int32x2_t = simd_neg(a);
        let mask: int32x2_t = simd_ge(a, neg);
        simd_select(mask, a, neg)
    }
}
#[doc = "Absolute value (wrapping)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabsq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vabs))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(abs)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vabsq_s32(a: int32x4_t) -> int32x4_t {
    unsafe {
        let neg: int32x4_t = simd_neg(a);
        let mask: int32x4_t = simd_ge(a, neg);
        simd_select(mask, a, neg)
    }
}
#[doc = "Floating-point absolute value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vabsh_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vabs))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fabs)
)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vabsh_f16(a: f16) -> f16 {
    unsafe { simd_extract!(vabs_f16(vdup_n_f16(a)), 0) }
}
#[doc = "Floating-point Add (vector)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vadd_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vadd.f16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fadd)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vadd_f16(a: float16x4_t, b: float16x4_t) -> float16x4_t {
    unsafe { simd_add(a, b) }
}
#[doc = "Floating-point Add (vector)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddq_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vadd.f16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fadd)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vaddq_f16(a: float16x8_t, b: float16x8_t) -> float16x8_t {
    unsafe { simd_add(a, b) }
}
#[doc = "Vector add."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vadd_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vadd))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fadd)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vadd_f32(a: float32x2_t, b: float32x2_t) -> float32x2_t {
    unsafe { simd_add(a, b) }
}
#[doc = "Vector add."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vadd_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vadd))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(add)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vadd_s16(a: int16x4_t, b: int16x4_t) -> int16x4_t {
    unsafe { simd_add(a, b) }
}
#[doc = "Vector add."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vadd_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vadd))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(add)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vadd_s32(a: int32x2_t, b: int32x2_t) -> int32x2_t {
    unsafe { simd_add(a, b) }
}
#[doc = "Vector add."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vadd_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vadd))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(add)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vadd_s8(a: int8x8_t, b: int8x8_t) -> int8x8_t {
    unsafe { simd_add(a, b) }
}
#[doc = "Vector add."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vadd_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vadd))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(add)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vadd_u16(a: uint16x4_t, b: uint16x4_t) -> uint16x4_t {
    unsafe { simd_add(a, b) }
}
#[doc = "Vector add."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vadd_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vadd))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(add)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vadd_u32(a: uint32x2_t, b: uint32x2_t) -> uint32x2_t {
    unsafe { simd_add(a, b) }
}
#[doc = "Vector add."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vadd_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vadd))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(add)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vadd_u8(a: uint8x8_t, b: uint8x8_t) -> uint8x8_t {
    unsafe { simd_add(a, b) }
}
#[doc = "Vector add."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vadd))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fadd)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddq_f32(a: float32x4_t, b: float32x4_t) -> float32x4_t {
    unsafe { simd_add(a, b) }
}
#[doc = "Vector add."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vadd))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(add)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddq_s16(a: int16x8_t, b: int16x8_t) -> int16x8_t {
    unsafe { simd_add(a, b) }
}
#[doc = "Vector add."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vadd))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(add)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddq_s32(a: int32x4_t, b: int32x4_t) -> int32x4_t {
    unsafe { simd_add(a, b) }
}
#[doc = "Vector add."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddq_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vadd))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(add)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddq_s64(a: int64x2_t, b: int64x2_t) -> int64x2_t {
    unsafe { simd_add(a, b) }
}
#[doc = "Vector add."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vadd))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(add)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddq_s8(a: int8x16_t, b: int8x16_t) -> int8x16_t {
    unsafe { simd_add(a, b) }
}
#[doc = "Vector add."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vadd))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(add)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddq_u16(a: uint16x8_t, b: uint16x8_t) -> uint16x8_t {
    unsafe { simd_add(a, b) }
}
#[doc = "Vector add."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vadd))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(add)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddq_u32(a: uint32x4_t, b: uint32x4_t) -> uint32x4_t {
    unsafe { simd_add(a, b) }
}
#[doc = "Vector add."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddq_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vadd))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(add)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddq_u64(a: uint64x2_t, b: uint64x2_t) -> uint64x2_t {
    unsafe { simd_add(a, b) }
}
#[doc = "Vector add."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddq_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vadd))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(add)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddq_u8(a: uint8x16_t, b: uint8x16_t) -> uint8x16_t {
    unsafe { simd_add(a, b) }
}
#[doc = "Bitwise exclusive OR"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vadd_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vadd_p8(a: poly8x8_t, b: poly8x8_t) -> poly8x8_t {
    unsafe { simd_xor(a, b) }
}
#[doc = "Bitwise exclusive OR"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddq_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddq_p8(a: poly8x16_t, b: poly8x16_t) -> poly8x16_t {
    unsafe { simd_xor(a, b) }
}
#[doc = "Bitwise exclusive OR"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vadd_p16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vadd_p16(a: poly16x4_t, b: poly16x4_t) -> poly16x4_t {
    unsafe { simd_xor(a, b) }
}
#[doc = "Bitwise exclusive OR"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddq_p16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddq_p16(a: poly16x8_t, b: poly16x8_t) -> poly16x8_t {
    unsafe { simd_xor(a, b) }
}
#[doc = "Bitwise exclusive OR"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vadd_p64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vadd_p64(a: poly64x1_t, b: poly64x1_t) -> poly64x1_t {
    unsafe { simd_xor(a, b) }
}
#[doc = "Bitwise exclusive OR"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddq_p64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddq_p64(a: poly64x2_t, b: poly64x2_t) -> poly64x2_t {
    unsafe { simd_xor(a, b) }
}
#[doc = "Add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddh_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vadd.f16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fadd)
)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vaddh_f16(a: f16, b: f16) -> f16 {
    a + b
}
#[doc = "Add returning High Narrow (high half)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddhn_high_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddhn))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(addhn2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddhn_high_s16(r: int8x8_t, a: int16x8_t, b: int16x8_t) -> int8x16_t {
    unsafe {
        let x = simd_cast(simd_shr(simd_add(a, b), int16x8_t::splat(8)));
        simd_shuffle!(r, x, [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15])
    }
}
#[doc = "Add returning High Narrow (high half)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddhn_high_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddhn))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(addhn2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddhn_high_s32(r: int16x4_t, a: int32x4_t, b: int32x4_t) -> int16x8_t {
    unsafe {
        let x = simd_cast(simd_shr(simd_add(a, b), int32x4_t::splat(16)));
        simd_shuffle!(r, x, [0, 1, 2, 3, 4, 5, 6, 7])
    }
}
#[doc = "Add returning High Narrow (high half)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddhn_high_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddhn))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(addhn2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddhn_high_s64(r: int32x2_t, a: int64x2_t, b: int64x2_t) -> int32x4_t {
    unsafe {
        let x = simd_cast(simd_shr(simd_add(a, b), int64x2_t::splat(32)));
        simd_shuffle!(r, x, [0, 1, 2, 3])
    }
}
#[doc = "Add returning High Narrow (high half)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddhn_high_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddhn))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(addhn2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddhn_high_u16(r: uint8x8_t, a: uint16x8_t, b: uint16x8_t) -> uint8x16_t {
    unsafe {
        let x = simd_cast(simd_shr(simd_add(a, b), uint16x8_t::splat(8)));
        simd_shuffle!(r, x, [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15])
    }
}
#[doc = "Add returning High Narrow (high half)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddhn_high_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddhn))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(addhn2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddhn_high_u32(r: uint16x4_t, a: uint32x4_t, b: uint32x4_t) -> uint16x8_t {
    unsafe {
        let x = simd_cast(simd_shr(simd_add(a, b), uint32x4_t::splat(16)));
        simd_shuffle!(r, x, [0, 1, 2, 3, 4, 5, 6, 7])
    }
}
#[doc = "Add returning High Narrow (high half)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddhn_high_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddhn))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(addhn2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddhn_high_u64(r: uint32x2_t, a: uint64x2_t, b: uint64x2_t) -> uint32x4_t {
    unsafe {
        let x = simd_cast(simd_shr(simd_add(a, b), uint64x2_t::splat(32)));
        simd_shuffle!(r, x, [0, 1, 2, 3])
    }
}
#[doc = "Add returning High Narrow."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddhn_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddhn))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(addhn)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddhn_s16(a: int16x8_t, b: int16x8_t) -> int8x8_t {
    unsafe { simd_cast(simd_shr(simd_add(a, b), int16x8_t::splat(8))) }
}
#[doc = "Add returning High Narrow."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddhn_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddhn))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(addhn)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddhn_s32(a: int32x4_t, b: int32x4_t) -> int16x4_t {
    unsafe { simd_cast(simd_shr(simd_add(a, b), int32x4_t::splat(16))) }
}
#[doc = "Add returning High Narrow."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddhn_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddhn))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(addhn)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddhn_s64(a: int64x2_t, b: int64x2_t) -> int32x2_t {
    unsafe { simd_cast(simd_shr(simd_add(a, b), int64x2_t::splat(32))) }
}
#[doc = "Add returning High Narrow."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddhn_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddhn))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(addhn)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddhn_u16(a: uint16x8_t, b: uint16x8_t) -> uint8x8_t {
    unsafe { simd_cast(simd_shr(simd_add(a, b), uint16x8_t::splat(8))) }
}
#[doc = "Add returning High Narrow."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddhn_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddhn))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(addhn)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddhn_u32(a: uint32x4_t, b: uint32x4_t) -> uint16x4_t {
    unsafe { simd_cast(simd_shr(simd_add(a, b), uint32x4_t::splat(16))) }
}
#[doc = "Add returning High Narrow."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddhn_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddhn))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(addhn)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddhn_u64(a: uint64x2_t, b: uint64x2_t) -> uint32x2_t {
    unsafe { simd_cast(simd_shr(simd_add(a, b), uint64x2_t::splat(32))) }
}
#[doc = "Signed Add Long (vector, high half)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddl_high_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(saddl2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddl_high_s16(a: int16x8_t, b: int16x8_t) -> int32x4_t {
    unsafe {
        let a: int16x4_t = simd_shuffle!(a, a, [4, 5, 6, 7]);
        let b: int16x4_t = simd_shuffle!(b, b, [4, 5, 6, 7]);
        let a: int32x4_t = simd_cast(a);
        let b: int32x4_t = simd_cast(b);
        simd_add(a, b)
    }
}
#[doc = "Signed Add Long (vector, high half)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddl_high_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(saddl2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddl_high_s32(a: int32x4_t, b: int32x4_t) -> int64x2_t {
    unsafe {
        let a: int32x2_t = simd_shuffle!(a, a, [2, 3]);
        let b: int32x2_t = simd_shuffle!(b, b, [2, 3]);
        let a: int64x2_t = simd_cast(a);
        let b: int64x2_t = simd_cast(b);
        simd_add(a, b)
    }
}
#[doc = "Signed Add Long (vector, high half)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddl_high_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(saddl2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddl_high_s8(a: int8x16_t, b: int8x16_t) -> int16x8_t {
    unsafe {
        let a: int8x8_t = simd_shuffle!(a, a, [8, 9, 10, 11, 12, 13, 14, 15]);
        let b: int8x8_t = simd_shuffle!(b, b, [8, 9, 10, 11, 12, 13, 14, 15]);
        let a: int16x8_t = simd_cast(a);
        let b: int16x8_t = simd_cast(b);
        simd_add(a, b)
    }
}
#[doc = "Signed Add Long (vector, high half)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddl_high_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uaddl2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddl_high_u16(a: uint16x8_t, b: uint16x8_t) -> uint32x4_t {
    unsafe {
        let a: uint16x4_t = simd_shuffle!(a, a, [4, 5, 6, 7]);
        let b: uint16x4_t = simd_shuffle!(b, b, [4, 5, 6, 7]);
        let a: uint32x4_t = simd_cast(a);
        let b: uint32x4_t = simd_cast(b);
        simd_add(a, b)
    }
}
#[doc = "Signed Add Long (vector, high half)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddl_high_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uaddl2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddl_high_u32(a: uint32x4_t, b: uint32x4_t) -> uint64x2_t {
    unsafe {
        let a: uint32x2_t = simd_shuffle!(a, a, [2, 3]);
        let b: uint32x2_t = simd_shuffle!(b, b, [2, 3]);
        let a: uint64x2_t = simd_cast(a);
        let b: uint64x2_t = simd_cast(b);
        simd_add(a, b)
    }
}
#[doc = "Signed Add Long (vector, high half)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddl_high_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uaddl2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddl_high_u8(a: uint8x16_t, b: uint8x16_t) -> uint16x8_t {
    unsafe {
        let a: uint8x8_t = simd_shuffle!(a, a, [8, 9, 10, 11, 12, 13, 14, 15]);
        let b: uint8x8_t = simd_shuffle!(b, b, [8, 9, 10, 11, 12, 13, 14, 15]);
        let a: uint16x8_t = simd_cast(a);
        let b: uint16x8_t = simd_cast(b);
        simd_add(a, b)
    }
}
#[doc = "Add Long (vector)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddl_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(saddl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddl_s16(a: int16x4_t, b: int16x4_t) -> int32x4_t {
    unsafe {
        let a: int32x4_t = simd_cast(a);
        let b: int32x4_t = simd_cast(b);
        simd_add(a, b)
    }
}
#[doc = "Add Long (vector)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddl_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(saddl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddl_s32(a: int32x2_t, b: int32x2_t) -> int64x2_t {
    unsafe {
        let a: int64x2_t = simd_cast(a);
        let b: int64x2_t = simd_cast(b);
        simd_add(a, b)
    }
}
#[doc = "Add Long (vector)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddl_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(saddl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddl_s8(a: int8x8_t, b: int8x8_t) -> int16x8_t {
    unsafe {
        let a: int16x8_t = simd_cast(a);
        let b: int16x8_t = simd_cast(b);
        simd_add(a, b)
    }
}
#[doc = "Add Long (vector)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddl_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uaddl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddl_u16(a: uint16x4_t, b: uint16x4_t) -> uint32x4_t {
    unsafe {
        let a: uint32x4_t = simd_cast(a);
        let b: uint32x4_t = simd_cast(b);
        simd_add(a, b)
    }
}
#[doc = "Add Long (vector)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddl_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uaddl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddl_u32(a: uint32x2_t, b: uint32x2_t) -> uint64x2_t {
    unsafe {
        let a: uint64x2_t = simd_cast(a);
        let b: uint64x2_t = simd_cast(b);
        simd_add(a, b)
    }
}
#[doc = "Add Long (vector)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddl_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uaddl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddl_u8(a: uint8x8_t, b: uint8x8_t) -> uint16x8_t {
    unsafe {
        let a: uint16x8_t = simd_cast(a);
        let b: uint16x8_t = simd_cast(b);
        simd_add(a, b)
    }
}
#[doc = "Bitwise exclusive OR"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddq_p128)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddq_p128(a: p128, b: p128) -> p128 {
    a ^ b
}
#[doc = "Add Wide (high half)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddw_high_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddw))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(saddw2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddw_high_s16(a: int32x4_t, b: int16x8_t) -> int32x4_t {
    unsafe {
        let b: int16x4_t = simd_shuffle!(b, b, [4, 5, 6, 7]);
        let b: int32x4_t = simd_cast(b);
        simd_add(a, b)
    }
}
#[doc = "Add Wide (high half)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddw_high_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddw))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(saddw2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddw_high_s32(a: int64x2_t, b: int32x4_t) -> int64x2_t {
    unsafe {
        let b: int32x2_t = simd_shuffle!(b, b, [2, 3]);
        let b: int64x2_t = simd_cast(b);
        simd_add(a, b)
    }
}
#[doc = "Add Wide (high half)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddw_high_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddw))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(saddw2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddw_high_s8(a: int16x8_t, b: int8x16_t) -> int16x8_t {
    unsafe {
        let b: int8x8_t = simd_shuffle!(b, b, [8, 9, 10, 11, 12, 13, 14, 15]);
        let b: int16x8_t = simd_cast(b);
        simd_add(a, b)
    }
}
#[doc = "Add Wide (high half)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddw_high_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddw))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uaddw2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddw_high_u16(a: uint32x4_t, b: uint16x8_t) -> uint32x4_t {
    unsafe {
        let b: uint16x4_t = simd_shuffle!(b, b, [4, 5, 6, 7]);
        let b: uint32x4_t = simd_cast(b);
        simd_add(a, b)
    }
}
#[doc = "Add Wide (high half)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddw_high_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddw))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uaddw2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddw_high_u32(a: uint64x2_t, b: uint32x4_t) -> uint64x2_t {
    unsafe {
        let b: uint32x2_t = simd_shuffle!(b, b, [2, 3]);
        let b: uint64x2_t = simd_cast(b);
        simd_add(a, b)
    }
}
#[doc = "Add Wide (high half)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddw_high_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddw))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uaddw2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddw_high_u8(a: uint16x8_t, b: uint8x16_t) -> uint16x8_t {
    unsafe {
        let b: uint8x8_t = simd_shuffle!(b, b, [8, 9, 10, 11, 12, 13, 14, 15]);
        let b: uint16x8_t = simd_cast(b);
        simd_add(a, b)
    }
}
#[doc = "Add Wide"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddw_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddw))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(saddw)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddw_s16(a: int32x4_t, b: int16x4_t) -> int32x4_t {
    unsafe {
        let b: int32x4_t = simd_cast(b);
        simd_add(a, b)
    }
}
#[doc = "Add Wide"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddw_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddw))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(saddw)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddw_s32(a: int64x2_t, b: int32x2_t) -> int64x2_t {
    unsafe {
        let b: int64x2_t = simd_cast(b);
        simd_add(a, b)
    }
}
#[doc = "Add Wide"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddw_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddw))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(saddw)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddw_s8(a: int16x8_t, b: int8x8_t) -> int16x8_t {
    unsafe {
        let b: int16x8_t = simd_cast(b);
        simd_add(a, b)
    }
}
#[doc = "Add Wide"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddw_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddw))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uaddw)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddw_u16(a: uint32x4_t, b: uint16x4_t) -> uint32x4_t {
    unsafe {
        let b: uint32x4_t = simd_cast(b);
        simd_add(a, b)
    }
}
#[doc = "Add Wide"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddw_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddw))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uaddw)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddw_u32(a: uint64x2_t, b: uint32x2_t) -> uint64x2_t {
    unsafe {
        let b: uint64x2_t = simd_cast(b);
        simd_add(a, b)
    }
}
#[doc = "Add Wide"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaddw_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vaddw))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uaddw)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vaddw_u8(a: uint16x8_t, b: uint8x8_t) -> uint16x8_t {
    unsafe {
        let b: uint16x8_t = simd_cast(b);
        simd_add(a, b)
    }
}
#[doc = "AES single round encryption."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaesdq_u8)"]
#[inline]
#[target_feature(enable = "aes")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(test, assert_instr(aesd))]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "aarch64_neon_crypto_intrinsics", since = "1.72.0")
)]
pub fn vaesdq_u8(data: uint8x16_t, key: uint8x16_t) -> uint8x16_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.aesd"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.aesd")]
        fn _vaesdq_u8(data: uint8x16_t, key: uint8x16_t) -> uint8x16_t;
    }
    unsafe { _vaesdq_u8(data, key) }
}
#[doc = "AES single round encryption."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaeseq_u8)"]
#[inline]
#[target_feature(enable = "aes")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(test, assert_instr(aese))]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "aarch64_neon_crypto_intrinsics", since = "1.72.0")
)]
pub fn vaeseq_u8(data: uint8x16_t, key: uint8x16_t) -> uint8x16_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.aese"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.aese")]
        fn _vaeseq_u8(data: uint8x16_t, key: uint8x16_t) -> uint8x16_t;
    }
    unsafe { _vaeseq_u8(data, key) }
}
#[doc = "AES inverse mix columns."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaesimcq_u8)"]
#[inline]
#[target_feature(enable = "aes")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(test, assert_instr(aesimc))]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "aarch64_neon_crypto_intrinsics", since = "1.72.0")
)]
pub fn vaesimcq_u8(data: uint8x16_t) -> uint8x16_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.aesimc"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.aesimc")]
        fn _vaesimcq_u8(data: uint8x16_t) -> uint8x16_t;
    }
    unsafe { _vaesimcq_u8(data) }
}
#[doc = "AES mix columns."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vaesmcq_u8)"]
#[inline]
#[target_feature(enable = "aes")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(test, assert_instr(aesmc))]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "aarch64_neon_crypto_intrinsics", since = "1.72.0")
)]
pub fn vaesmcq_u8(data: uint8x16_t) -> uint8x16_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.crypto.aesmc"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.aesmc")]
        fn _vaesmcq_u8(data: uint8x16_t) -> uint8x16_t;
    }
    unsafe { _vaesmcq_u8(data) }
}
#[doc = "Vector bitwise and"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vand_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vand))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(and)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vand_s8(a: int8x8_t, b: int8x8_t) -> int8x8_t {
    unsafe { simd_and(a, b) }
}
#[doc = "Vector bitwise and"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vandq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vand))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(and)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vandq_s8(a: int8x16_t, b: int8x16_t) -> int8x16_t {
    unsafe { simd_and(a, b) }
}
#[doc = "Vector bitwise and"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vand_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vand))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(and)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vand_s16(a: int16x4_t, b: int16x4_t) -> int16x4_t {
    unsafe { simd_and(a, b) }
}
#[doc = "Vector bitwise and"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vandq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vand))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(and)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vandq_s16(a: int16x8_t, b: int16x8_t) -> int16x8_t {
    unsafe { simd_and(a, b) }
}
#[doc = "Vector bitwise and"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vand_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vand))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(and)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vand_s32(a: int32x2_t, b: int32x2_t) -> int32x2_t {
    unsafe { simd_and(a, b) }
}
#[doc = "Vector bitwise and"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vandq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vand))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(and)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vandq_s32(a: int32x4_t, b: int32x4_t) -> int32x4_t {
    unsafe { simd_and(a, b) }
}
#[doc = "Vector bitwise and"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vand_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vand))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(and)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vand_s64(a: int64x1_t, b: int64x1_t) -> int64x1_t {
    unsafe { simd_and(a, b) }
}
#[doc = "Vector bitwise and"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vandq_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vand))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(and)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vandq_s64(a: int64x2_t, b: int64x2_t) -> int64x2_t {
    unsafe { simd_and(a, b) }
}
#[doc = "Vector bitwise and"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vand_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vand))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(and)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vand_u8(a: uint8x8_t, b: uint8x8_t) -> uint8x8_t {
    unsafe { simd_and(a, b) }
}
#[doc = "Vector bitwise and"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vandq_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vand))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(and)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vandq_u8(a: uint8x16_t, b: uint8x16_t) -> uint8x16_t {
    unsafe { simd_and(a, b) }
}
#[doc = "Vector bitwise and"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vand_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vand))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(and)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vand_u16(a: uint16x4_t, b: uint16x4_t) -> uint16x4_t {
    unsafe { simd_and(a, b) }
}
#[doc = "Vector bitwise and"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vandq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vand))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(and)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vandq_u16(a: uint16x8_t, b: uint16x8_t) -> uint16x8_t {
    unsafe { simd_and(a, b) }
}
#[doc = "Vector bitwise and"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vand_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vand))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(and)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vand_u32(a: uint32x2_t, b: uint32x2_t) -> uint32x2_t {
    unsafe { simd_and(a, b) }
}
#[doc = "Vector bitwise and"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vandq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vand))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(and)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vandq_u32(a: uint32x4_t, b: uint32x4_t) -> uint32x4_t {
    unsafe { simd_and(a, b) }
}
#[doc = "Vector bitwise and"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vand_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vand))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(and)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vand_u64(a: uint64x1_t, b: uint64x1_t) -> uint64x1_t {
    unsafe { simd_and(a, b) }
}
#[doc = "Vector bitwise and"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vandq_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vand))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(and)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vandq_u64(a: uint64x2_t, b: uint64x2_t) -> uint64x2_t {
    unsafe { simd_and(a, b) }
}
#[doc = "Vector bitwise bit clear."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbic_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbic))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bic)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbic_s16(a: int16x4_t, b: int16x4_t) -> int16x4_t {
    let c = int16x4_t::splat(-1);
    unsafe { simd_and(simd_xor(b, c), a) }
}
#[doc = "Vector bitwise bit clear."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbic_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbic))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bic)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbic_s32(a: int32x2_t, b: int32x2_t) -> int32x2_t {
    let c = int32x2_t::splat(-1);
    unsafe { simd_and(simd_xor(b, c), a) }
}
#[doc = "Vector bitwise bit clear."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbic_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbic))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bic)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbic_s64(a: int64x1_t, b: int64x1_t) -> int64x1_t {
    let c = int64x1_t::splat(-1);
    unsafe { simd_and(simd_xor(b, c), a) }
}
#[doc = "Vector bitwise bit clear."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbic_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbic))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bic)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbic_s8(a: int8x8_t, b: int8x8_t) -> int8x8_t {
    let c = int8x8_t::splat(-1);
    unsafe { simd_and(simd_xor(b, c), a) }
}
#[doc = "Vector bitwise bit clear."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbicq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbic))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bic)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbicq_s16(a: int16x8_t, b: int16x8_t) -> int16x8_t {
    let c = int16x8_t::splat(-1);
    unsafe { simd_and(simd_xor(b, c), a) }
}
#[doc = "Vector bitwise bit clear."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbicq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbic))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bic)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbicq_s32(a: int32x4_t, b: int32x4_t) -> int32x4_t {
    let c = int32x4_t::splat(-1);
    unsafe { simd_and(simd_xor(b, c), a) }
}
#[doc = "Vector bitwise bit clear."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbicq_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbic))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bic)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbicq_s64(a: int64x2_t, b: int64x2_t) -> int64x2_t {
    let c = int64x2_t::splat(-1);
    unsafe { simd_and(simd_xor(b, c), a) }
}
#[doc = "Vector bitwise bit clear."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbicq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbic))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bic)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbicq_s8(a: int8x16_t, b: int8x16_t) -> int8x16_t {
    let c = int8x16_t::splat(-1);
    unsafe { simd_and(simd_xor(b, c), a) }
}
#[doc = "Vector bitwise bit clear."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbic_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbic))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bic)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbic_u16(a: uint16x4_t, b: uint16x4_t) -> uint16x4_t {
    let c = int16x4_t::splat(-1);
    unsafe { simd_and(simd_xor(b, transmute(c)), a) }
}
#[doc = "Vector bitwise bit clear."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbic_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbic))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bic)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbic_u32(a: uint32x2_t, b: uint32x2_t) -> uint32x2_t {
    let c = int32x2_t::splat(-1);
    unsafe { simd_and(simd_xor(b, transmute(c)), a) }
}
#[doc = "Vector bitwise bit clear."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbic_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbic))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bic)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbic_u64(a: uint64x1_t, b: uint64x1_t) -> uint64x1_t {
    let c = int64x1_t::splat(-1);
    unsafe { simd_and(simd_xor(b, transmute(c)), a) }
}
#[doc = "Vector bitwise bit clear."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbic_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbic))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bic)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbic_u8(a: uint8x8_t, b: uint8x8_t) -> uint8x8_t {
    let c = int8x8_t::splat(-1);
    unsafe { simd_and(simd_xor(b, transmute(c)), a) }
}
#[doc = "Vector bitwise bit clear."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbicq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbic))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bic)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbicq_u16(a: uint16x8_t, b: uint16x8_t) -> uint16x8_t {
    let c = int16x8_t::splat(-1);
    unsafe { simd_and(simd_xor(b, transmute(c)), a) }
}
#[doc = "Vector bitwise bit clear."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbicq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbic))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bic)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbicq_u32(a: uint32x4_t, b: uint32x4_t) -> uint32x4_t {
    let c = int32x4_t::splat(-1);
    unsafe { simd_and(simd_xor(b, transmute(c)), a) }
}
#[doc = "Vector bitwise bit clear."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbicq_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbic))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bic)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbicq_u64(a: uint64x2_t, b: uint64x2_t) -> uint64x2_t {
    let c = int64x2_t::splat(-1);
    unsafe { simd_and(simd_xor(b, transmute(c)), a) }
}
#[doc = "Vector bitwise bit clear."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbicq_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbic))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bic)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbicq_u8(a: uint8x16_t, b: uint8x16_t) -> uint8x16_t {
    let c = int8x16_t::splat(-1);
    unsafe { simd_and(simd_xor(b, transmute(c)), a) }
}
#[doc = "Bitwise Select."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbsl_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbsl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bsl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vbsl_f16(a: uint16x4_t, b: float16x4_t, c: float16x4_t) -> float16x4_t {
    let not = int16x4_t::splat(-1);
    unsafe {
        transmute(simd_or(
            simd_and(a, transmute(b)),
            simd_and(simd_xor(a, transmute(not)), transmute(c)),
        ))
    }
}
#[doc = "Bitwise Select."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbslq_f16)"]
#[inline]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbsl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bsl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vbslq_f16(a: uint16x8_t, b: float16x8_t, c: float16x8_t) -> float16x8_t {
    let not = int16x8_t::splat(-1);
    unsafe {
        transmute(simd_or(
            simd_and(a, transmute(b)),
            simd_and(simd_xor(a, transmute(not)), transmute(c)),
        ))
    }
}
#[doc = "Bitwise Select."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbsl_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbsl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bsl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbsl_f32(a: uint32x2_t, b: float32x2_t, c: float32x2_t) -> float32x2_t {
    let not = int32x2_t::splat(-1);
    unsafe {
        transmute(simd_or(
            simd_and(a, transmute(b)),
            simd_and(simd_xor(a, transmute(not)), transmute(c)),
        ))
    }
}
#[doc = "Bitwise Select."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbsl_p16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbsl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bsl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbsl_p16(a: uint16x4_t, b: poly16x4_t, c: poly16x4_t) -> poly16x4_t {
    let not = int16x4_t::splat(-1);
    unsafe {
        transmute(simd_or(
            simd_and(a, transmute(b)),
            simd_and(simd_xor(a, transmute(not)), transmute(c)),
        ))
    }
}
#[doc = "Bitwise Select."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbsl_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbsl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bsl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbsl_p8(a: uint8x8_t, b: poly8x8_t, c: poly8x8_t) -> poly8x8_t {
    let not = int8x8_t::splat(-1);
    unsafe {
        transmute(simd_or(
            simd_and(a, transmute(b)),
            simd_and(simd_xor(a, transmute(not)), transmute(c)),
        ))
    }
}
#[doc = "Bitwise Select."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbsl_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbsl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bsl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbsl_s16(a: uint16x4_t, b: int16x4_t, c: int16x4_t) -> int16x4_t {
    let not = int16x4_t::splat(-1);
    unsafe {
        transmute(simd_or(
            simd_and(a, transmute(b)),
            simd_and(simd_xor(a, transmute(not)), transmute(c)),
        ))
    }
}
#[doc = "Bitwise Select."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbsl_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbsl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bsl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbsl_s32(a: uint32x2_t, b: int32x2_t, c: int32x2_t) -> int32x2_t {
    let not = int32x2_t::splat(-1);
    unsafe {
        transmute(simd_or(
            simd_and(a, transmute(b)),
            simd_and(simd_xor(a, transmute(not)), transmute(c)),
        ))
    }
}
#[doc = "Bitwise Select."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbsl_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbsl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bsl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbsl_s64(a: uint64x1_t, b: int64x1_t, c: int64x1_t) -> int64x1_t {
    let not = int64x1_t::splat(-1);
    unsafe {
        transmute(simd_or(
            simd_and(a, transmute(b)),
            simd_and(simd_xor(a, transmute(not)), transmute(c)),
        ))
    }
}
#[doc = "Bitwise Select."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbsl_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbsl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bsl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbsl_s8(a: uint8x8_t, b: int8x8_t, c: int8x8_t) -> int8x8_t {
    let not = int8x8_t::splat(-1);
    unsafe {
        transmute(simd_or(
            simd_and(a, transmute(b)),
            simd_and(simd_xor(a, transmute(not)), transmute(c)),
        ))
    }
}
#[doc = "Bitwise Select."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbslq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbsl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bsl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbslq_f32(a: uint32x4_t, b: float32x4_t, c: float32x4_t) -> float32x4_t {
    let not = int32x4_t::splat(-1);
    unsafe {
        transmute(simd_or(
            simd_and(a, transmute(b)),
            simd_and(simd_xor(a, transmute(not)), transmute(c)),
        ))
    }
}
#[doc = "Bitwise Select."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbslq_p16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbsl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bsl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbslq_p16(a: uint16x8_t, b: poly16x8_t, c: poly16x8_t) -> poly16x8_t {
    let not = int16x8_t::splat(-1);
    unsafe {
        transmute(simd_or(
            simd_and(a, transmute(b)),
            simd_and(simd_xor(a, transmute(not)), transmute(c)),
        ))
    }
}
#[doc = "Bitwise Select."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbslq_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbsl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bsl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbslq_p8(a: uint8x16_t, b: poly8x16_t, c: poly8x16_t) -> poly8x16_t {
    let not = int8x16_t::splat(-1);
    unsafe {
        transmute(simd_or(
            simd_and(a, transmute(b)),
            simd_and(simd_xor(a, transmute(not)), transmute(c)),
        ))
    }
}
#[doc = "Bitwise Select."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbslq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbsl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bsl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbslq_s16(a: uint16x8_t, b: int16x8_t, c: int16x8_t) -> int16x8_t {
    let not = int16x8_t::splat(-1);
    unsafe {
        transmute(simd_or(
            simd_and(a, transmute(b)),
            simd_and(simd_xor(a, transmute(not)), transmute(c)),
        ))
    }
}
#[doc = "Bitwise Select."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbslq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbsl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bsl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbslq_s32(a: uint32x4_t, b: int32x4_t, c: int32x4_t) -> int32x4_t {
    let not = int32x4_t::splat(-1);
    unsafe {
        transmute(simd_or(
            simd_and(a, transmute(b)),
            simd_and(simd_xor(a, transmute(not)), transmute(c)),
        ))
    }
}
#[doc = "Bitwise Select."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbslq_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbsl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bsl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbslq_s64(a: uint64x2_t, b: int64x2_t, c: int64x2_t) -> int64x2_t {
    let not = int64x2_t::splat(-1);
    unsafe {
        transmute(simd_or(
            simd_and(a, transmute(b)),
            simd_and(simd_xor(a, transmute(not)), transmute(c)),
        ))
    }
}
#[doc = "Bitwise Select."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbslq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbsl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bsl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbslq_s8(a: uint8x16_t, b: int8x16_t, c: int8x16_t) -> int8x16_t {
    let not = int8x16_t::splat(-1);
    unsafe {
        transmute(simd_or(
            simd_and(a, transmute(b)),
            simd_and(simd_xor(a, transmute(not)), transmute(c)),
        ))
    }
}
#[doc = "Bitwise Select."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbsl_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbsl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bsl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbsl_u16(a: uint16x4_t, b: uint16x4_t, c: uint16x4_t) -> uint16x4_t {
    let not = int16x4_t::splat(-1);
    unsafe {
        transmute(simd_or(
            simd_and(a, b),
            simd_and(simd_xor(a, transmute(not)), c),
        ))
    }
}
#[doc = "Bitwise Select."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbsl_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbsl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bsl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbsl_u32(a: uint32x2_t, b: uint32x2_t, c: uint32x2_t) -> uint32x2_t {
    let not = int32x2_t::splat(-1);
    unsafe {
        transmute(simd_or(
            simd_and(a, b),
            simd_and(simd_xor(a, transmute(not)), c),
        ))
    }
}
#[doc = "Bitwise Select."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbsl_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbsl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bsl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbsl_u64(a: uint64x1_t, b: uint64x1_t, c: uint64x1_t) -> uint64x1_t {
    let not = int64x1_t::splat(-1);
    unsafe {
        transmute(simd_or(
            simd_and(a, b),
            simd_and(simd_xor(a, transmute(not)), c),
        ))
    }
}
#[doc = "Bitwise Select."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbsl_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbsl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bsl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbsl_u8(a: uint8x8_t, b: uint8x8_t, c: uint8x8_t) -> uint8x8_t {
    let not = int8x8_t::splat(-1);
    unsafe {
        transmute(simd_or(
            simd_and(a, b),
            simd_and(simd_xor(a, transmute(not)), c),
        ))
    }
}
#[doc = "Bitwise Select."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbslq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbsl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bsl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbslq_u16(a: uint16x8_t, b: uint16x8_t, c: uint16x8_t) -> uint16x8_t {
    let not = int16x8_t::splat(-1);
    unsafe {
        transmute(simd_or(
            simd_and(a, b),
            simd_and(simd_xor(a, transmute(not)), c),
        ))
    }
}
#[doc = "Bitwise Select."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbslq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbsl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bsl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbslq_u32(a: uint32x4_t, b: uint32x4_t, c: uint32x4_t) -> uint32x4_t {
    let not = int32x4_t::splat(-1);
    unsafe {
        transmute(simd_or(
            simd_and(a, b),
            simd_and(simd_xor(a, transmute(not)), c),
        ))
    }
}
#[doc = "Bitwise Select."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbslq_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbsl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bsl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbslq_u64(a: uint64x2_t, b: uint64x2_t, c: uint64x2_t) -> uint64x2_t {
    let not = int64x2_t::splat(-1);
    unsafe {
        transmute(simd_or(
            simd_and(a, b),
            simd_and(simd_xor(a, transmute(not)), c),
        ))
    }
}
#[doc = "Bitwise Select."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vbslq_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vbsl))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(bsl)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vbslq_u8(a: uint8x16_t, b: uint8x16_t, c: uint8x16_t) -> uint8x16_t {
    let not = int8x16_t::splat(-1);
    unsafe {
        transmute(simd_or(
            simd_and(a, b),
            simd_and(simd_xor(a, transmute(not)), c),
        ))
    }
}
#[doc = "Floating-point absolute compare greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcage_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vacge.f16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(facge)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcage_f16(a: float16x4_t, b: float16x4_t) -> uint16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vacge.v4i16.v4f16")]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.facge.v4i16.v4f16"
        )]
        fn _vcage_f16(a: float16x4_t, b: float16x4_t) -> uint16x4_t;
    }
    unsafe { _vcage_f16(a, b) }
}
#[doc = "Floating-point absolute compare greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcageq_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vacge.f16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(facge)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcageq_f16(a: float16x8_t, b: float16x8_t) -> uint16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vacge.v8i16.v8f16")]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.facge.v8i16.v8f16"
        )]
        fn _vcageq_f16(a: float16x8_t, b: float16x8_t) -> uint16x8_t;
    }
    unsafe { _vcageq_f16(a, b) }
}
#[doc = "Floating-point absolute compare greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcage_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vacge.f32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(facge)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcage_f32(a: float32x2_t, b: float32x2_t) -> uint32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vacge.v2i32.v2f32")]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.facge.v2i32.v2f32"
        )]
        fn _vcage_f32(a: float32x2_t, b: float32x2_t) -> uint32x2_t;
    }
    unsafe { _vcage_f32(a, b) }
}
#[doc = "Floating-point absolute compare greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcageq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vacge.f32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(facge)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcageq_f32(a: float32x4_t, b: float32x4_t) -> uint32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vacge.v4i32.v4f32")]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.facge.v4i32.v4f32"
        )]
        fn _vcageq_f32(a: float32x4_t, b: float32x4_t) -> uint32x4_t;
    }
    unsafe { _vcageq_f32(a, b) }
}
#[doc = "Floating-point absolute compare greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcagt_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vacgt.f16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(facgt)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcagt_f16(a: float16x4_t, b: float16x4_t) -> uint16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vacgt.v4i16.v4f16")]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.facgt.v4i16.v4f16"
        )]
        fn _vcagt_f16(a: float16x4_t, b: float16x4_t) -> uint16x4_t;
    }
    unsafe { _vcagt_f16(a, b) }
}
#[doc = "Floating-point absolute compare greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcagtq_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vacgt.f16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(facgt)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcagtq_f16(a: float16x8_t, b: float16x8_t) -> uint16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vacgt.v8i16.v8f16")]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.facgt.v8i16.v8f16"
        )]
        fn _vcagtq_f16(a: float16x8_t, b: float16x8_t) -> uint16x8_t;
    }
    unsafe { _vcagtq_f16(a, b) }
}
#[doc = "Floating-point absolute compare greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcagt_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vacgt.f32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(facgt)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcagt_f32(a: float32x2_t, b: float32x2_t) -> uint32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vacgt.v2i32.v2f32")]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.facgt.v2i32.v2f32"
        )]
        fn _vcagt_f32(a: float32x2_t, b: float32x2_t) -> uint32x2_t;
    }
    unsafe { _vcagt_f32(a, b) }
}
#[doc = "Floating-point absolute compare greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcagtq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vacgt.f32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(facgt)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcagtq_f32(a: float32x4_t, b: float32x4_t) -> uint32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vacgt.v4i32.v4f32")]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.facgt.v4i32.v4f32"
        )]
        fn _vcagtq_f32(a: float32x4_t, b: float32x4_t) -> uint32x4_t;
    }
    unsafe { _vcagtq_f32(a, b) }
}
#[doc = "Floating-point absolute compare less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcale_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vacge.f16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(facge)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcale_f16(a: float16x4_t, b: float16x4_t) -> uint16x4_t {
    vcage_f16(b, a)
}
#[doc = "Floating-point absolute compare less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcaleq_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vacge.f16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(facge)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcaleq_f16(a: float16x8_t, b: float16x8_t) -> uint16x8_t {
    vcageq_f16(b, a)
}
#[doc = "Floating-point absolute compare less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcale_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vacge.f32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(facge)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcale_f32(a: float32x2_t, b: float32x2_t) -> uint32x2_t {
    vcage_f32(b, a)
}
#[doc = "Floating-point absolute compare less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcaleq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vacge.f32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(facge)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcaleq_f32(a: float32x4_t, b: float32x4_t) -> uint32x4_t {
    vcageq_f32(b, a)
}
#[doc = "Floating-point absolute compare less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcalt_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vacgt.f16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(facgt)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcalt_f16(a: float16x4_t, b: float16x4_t) -> uint16x4_t {
    vcagt_f16(b, a)
}
#[doc = "Floating-point absolute compare less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcaltq_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vacgt.f16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(facgt)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcaltq_f16(a: float16x8_t, b: float16x8_t) -> uint16x8_t {
    vcagtq_f16(b, a)
}
#[doc = "Floating-point absolute compare less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcalt_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vacgt.f32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(facgt)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcalt_f32(a: float32x2_t, b: float32x2_t) -> uint32x2_t {
    vcagt_f32(b, a)
}
#[doc = "Floating-point absolute compare less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcaltq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vacgt.f32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(facgt)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcaltq_f32(a: float32x4_t, b: float32x4_t) -> uint32x4_t {
    vcagtq_f32(b, a)
}
#[doc = "Floating-point compare equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceq_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vceq.f16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcmeq)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vceq_f16(a: float16x4_t, b: float16x4_t) -> uint16x4_t {
    unsafe { simd_eq(a, b) }
}
#[doc = "Floating-point compare equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqq_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vceq.f16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcmeq)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vceqq_f16(a: float16x8_t, b: float16x8_t) -> uint16x8_t {
    unsafe { simd_eq(a, b) }
}
#[doc = "Floating-point compare equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vceq.f32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcmeq)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vceq_f32(a: float32x2_t, b: float32x2_t) -> uint32x2_t {
    unsafe { simd_eq(a, b) }
}
#[doc = "Floating-point compare equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vceq.f32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcmeq)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vceqq_f32(a: float32x4_t, b: float32x4_t) -> uint32x4_t {
    unsafe { simd_eq(a, b) }
}
#[doc = "Compare bitwise Equal (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vceq.i8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmeq)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vceq_s8(a: int8x8_t, b: int8x8_t) -> uint8x8_t {
    unsafe { simd_eq(a, b) }
}
#[doc = "Compare bitwise Equal (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vceq.i8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmeq)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vceqq_s8(a: int8x16_t, b: int8x16_t) -> uint8x16_t {
    unsafe { simd_eq(a, b) }
}
#[doc = "Compare bitwise Equal (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vceq.i16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmeq)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vceq_s16(a: int16x4_t, b: int16x4_t) -> uint16x4_t {
    unsafe { simd_eq(a, b) }
}
#[doc = "Compare bitwise Equal (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vceq.i16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmeq)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vceqq_s16(a: int16x8_t, b: int16x8_t) -> uint16x8_t {
    unsafe { simd_eq(a, b) }
}
#[doc = "Compare bitwise Equal (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vceq.i32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmeq)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vceq_s32(a: int32x2_t, b: int32x2_t) -> uint32x2_t {
    unsafe { simd_eq(a, b) }
}
#[doc = "Compare bitwise Equal (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vceq.i32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmeq)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vceqq_s32(a: int32x4_t, b: int32x4_t) -> uint32x4_t {
    unsafe { simd_eq(a, b) }
}
#[doc = "Compare bitwise Equal (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceq_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vceq.i8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmeq)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vceq_u8(a: uint8x8_t, b: uint8x8_t) -> uint8x8_t {
    unsafe { simd_eq(a, b) }
}
#[doc = "Compare bitwise Equal (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqq_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vceq.i8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmeq)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vceqq_u8(a: uint8x16_t, b: uint8x16_t) -> uint8x16_t {
    unsafe { simd_eq(a, b) }
}
#[doc = "Compare bitwise Equal (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vceq.i16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmeq)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vceq_u16(a: uint16x4_t, b: uint16x4_t) -> uint16x4_t {
    unsafe { simd_eq(a, b) }
}
#[doc = "Compare bitwise Equal (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vceq.i16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmeq)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vceqq_u16(a: uint16x8_t, b: uint16x8_t) -> uint16x8_t {
    unsafe { simd_eq(a, b) }
}
#[doc = "Compare bitwise Equal (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vceq.i32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmeq)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vceq_u32(a: uint32x2_t, b: uint32x2_t) -> uint32x2_t {
    unsafe { simd_eq(a, b) }
}
#[doc = "Compare bitwise Equal (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vceq.i32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmeq)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vceqq_u32(a: uint32x4_t, b: uint32x4_t) -> uint32x4_t {
    unsafe { simd_eq(a, b) }
}
#[doc = "Compare bitwise Equal (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceq_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vceq.i8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmeq)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vceq_p8(a: poly8x8_t, b: poly8x8_t) -> uint8x8_t {
    unsafe { simd_eq(a, b) }
}
#[doc = "Compare bitwise Equal (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vceqq_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vceq.i8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmeq)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vceqq_p8(a: poly8x16_t, b: poly8x16_t) -> uint8x16_t {
    unsafe { simd_eq(a, b) }
}
#[doc = "Floating-point compare greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcge_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.f16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcmge)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcge_f16(a: float16x4_t, b: float16x4_t) -> uint16x4_t {
    unsafe { simd_ge(a, b) }
}
#[doc = "Floating-point compare greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgeq_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.f16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcmge)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcgeq_f16(a: float16x8_t, b: float16x8_t) -> uint16x8_t {
    unsafe { simd_ge(a, b) }
}
#[doc = "Floating-point compare greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcge_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.f32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcmge)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcge_f32(a: float32x2_t, b: float32x2_t) -> uint32x2_t {
    unsafe { simd_ge(a, b) }
}
#[doc = "Floating-point compare greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgeq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.f32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcmge)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcgeq_f32(a: float32x4_t, b: float32x4_t) -> uint32x4_t {
    unsafe { simd_ge(a, b) }
}
#[doc = "Compare signed greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcge_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.s8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmge)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcge_s8(a: int8x8_t, b: int8x8_t) -> uint8x8_t {
    unsafe { simd_ge(a, b) }
}
#[doc = "Compare signed greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgeq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.s8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmge)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcgeq_s8(a: int8x16_t, b: int8x16_t) -> uint8x16_t {
    unsafe { simd_ge(a, b) }
}
#[doc = "Compare signed greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcge_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.s16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmge)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcge_s16(a: int16x4_t, b: int16x4_t) -> uint16x4_t {
    unsafe { simd_ge(a, b) }
}
#[doc = "Compare signed greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgeq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.s16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmge)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcgeq_s16(a: int16x8_t, b: int16x8_t) -> uint16x8_t {
    unsafe { simd_ge(a, b) }
}
#[doc = "Compare signed greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcge_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.s32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmge)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcge_s32(a: int32x2_t, b: int32x2_t) -> uint32x2_t {
    unsafe { simd_ge(a, b) }
}
#[doc = "Compare signed greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgeq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.s32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmge)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcgeq_s32(a: int32x4_t, b: int32x4_t) -> uint32x4_t {
    unsafe { simd_ge(a, b) }
}
#[doc = "Compare unsigned greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcge_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.u8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmhs)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcge_u8(a: uint8x8_t, b: uint8x8_t) -> uint8x8_t {
    unsafe { simd_ge(a, b) }
}
#[doc = "Compare unsigned greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgeq_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.u8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmhs)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcgeq_u8(a: uint8x16_t, b: uint8x16_t) -> uint8x16_t {
    unsafe { simd_ge(a, b) }
}
#[doc = "Compare unsigned greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcge_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.u16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmhs)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcge_u16(a: uint16x4_t, b: uint16x4_t) -> uint16x4_t {
    unsafe { simd_ge(a, b) }
}
#[doc = "Compare unsigned greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgeq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.u16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmhs)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcgeq_u16(a: uint16x8_t, b: uint16x8_t) -> uint16x8_t {
    unsafe { simd_ge(a, b) }
}
#[doc = "Compare unsigned greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcge_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.u32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmhs)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcge_u32(a: uint32x2_t, b: uint32x2_t) -> uint32x2_t {
    unsafe { simd_ge(a, b) }
}
#[doc = "Compare unsigned greater than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgeq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.u32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmhs)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcgeq_u32(a: uint32x4_t, b: uint32x4_t) -> uint32x4_t {
    unsafe { simd_ge(a, b) }
}
#[doc = "Floating-point compare greater than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgez_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.f16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcmge)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcgez_f16(a: float16x4_t) -> uint16x4_t {
    let b: f16x4 = f16x4::new(0.0, 0.0, 0.0, 0.0);
    unsafe { simd_ge(a, transmute(b)) }
}
#[doc = "Floating-point compare greater than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgezq_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.f16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcmge)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcgezq_f16(a: float16x8_t) -> uint16x8_t {
    let b: f16x8 = f16x8::new(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    unsafe { simd_ge(a, transmute(b)) }
}
#[doc = "Floating-point compare greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgt_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.f16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcmgt)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcgt_f16(a: float16x4_t, b: float16x4_t) -> uint16x4_t {
    unsafe { simd_gt(a, b) }
}
#[doc = "Floating-point compare greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgtq_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.f16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcmgt)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcgtq_f16(a: float16x8_t, b: float16x8_t) -> uint16x8_t {
    unsafe { simd_gt(a, b) }
}
#[doc = "Floating-point compare greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgt_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.f32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcmgt)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcgt_f32(a: float32x2_t, b: float32x2_t) -> uint32x2_t {
    unsafe { simd_gt(a, b) }
}
#[doc = "Floating-point compare greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgtq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.f32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcmgt)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcgtq_f32(a: float32x4_t, b: float32x4_t) -> uint32x4_t {
    unsafe { simd_gt(a, b) }
}
#[doc = "Compare signed greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgt_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.s8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmgt)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcgt_s8(a: int8x8_t, b: int8x8_t) -> uint8x8_t {
    unsafe { simd_gt(a, b) }
}
#[doc = "Compare signed greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgtq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.s8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmgt)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcgtq_s8(a: int8x16_t, b: int8x16_t) -> uint8x16_t {
    unsafe { simd_gt(a, b) }
}
#[doc = "Compare signed greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgt_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.s16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmgt)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcgt_s16(a: int16x4_t, b: int16x4_t) -> uint16x4_t {
    unsafe { simd_gt(a, b) }
}
#[doc = "Compare signed greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgtq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.s16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmgt)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcgtq_s16(a: int16x8_t, b: int16x8_t) -> uint16x8_t {
    unsafe { simd_gt(a, b) }
}
#[doc = "Compare signed greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgt_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.s32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmgt)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcgt_s32(a: int32x2_t, b: int32x2_t) -> uint32x2_t {
    unsafe { simd_gt(a, b) }
}
#[doc = "Compare signed greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgtq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.s32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmgt)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcgtq_s32(a: int32x4_t, b: int32x4_t) -> uint32x4_t {
    unsafe { simd_gt(a, b) }
}
#[doc = "Compare unsigned greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgt_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.u8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmhi)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcgt_u8(a: uint8x8_t, b: uint8x8_t) -> uint8x8_t {
    unsafe { simd_gt(a, b) }
}
#[doc = "Compare unsigned greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgtq_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.u8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmhi)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcgtq_u8(a: uint8x16_t, b: uint8x16_t) -> uint8x16_t {
    unsafe { simd_gt(a, b) }
}
#[doc = "Compare unsigned greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgt_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.u16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmhi)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcgt_u16(a: uint16x4_t, b: uint16x4_t) -> uint16x4_t {
    unsafe { simd_gt(a, b) }
}
#[doc = "Compare unsigned greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgtq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.u16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmhi)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcgtq_u16(a: uint16x8_t, b: uint16x8_t) -> uint16x8_t {
    unsafe { simd_gt(a, b) }
}
#[doc = "Compare unsigned greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgt_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.u32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmhi)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcgt_u32(a: uint32x2_t, b: uint32x2_t) -> uint32x2_t {
    unsafe { simd_gt(a, b) }
}
#[doc = "Compare unsigned greater than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgtq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.u32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmhi)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcgtq_u32(a: uint32x4_t, b: uint32x4_t) -> uint32x4_t {
    unsafe { simd_gt(a, b) }
}
#[doc = "Floating-point compare greater than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgtz_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.f16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcmgt)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcgtz_f16(a: float16x4_t) -> uint16x4_t {
    let b: f16x4 = f16x4::new(0.0, 0.0, 0.0, 0.0);
    unsafe { simd_gt(a, transmute(b)) }
}
#[doc = "Floating-point compare greater than zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcgtzq_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.f16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcmgt)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcgtzq_f16(a: float16x8_t) -> uint16x8_t {
    let b: f16x8 = f16x8::new(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    unsafe { simd_gt(a, transmute(b)) }
}
#[doc = "Floating-point compare less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcle_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.f16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcmge)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcle_f16(a: float16x4_t, b: float16x4_t) -> uint16x4_t {
    unsafe { simd_le(a, b) }
}
#[doc = "Floating-point compare less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcleq_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.f16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcmge)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcleq_f16(a: float16x8_t, b: float16x8_t) -> uint16x8_t {
    unsafe { simd_le(a, b) }
}
#[doc = "Floating-point compare less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcle_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.f32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcmge)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcle_f32(a: float32x2_t, b: float32x2_t) -> uint32x2_t {
    unsafe { simd_le(a, b) }
}
#[doc = "Floating-point compare less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcleq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.f32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcmge)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcleq_f32(a: float32x4_t, b: float32x4_t) -> uint32x4_t {
    unsafe { simd_le(a, b) }
}
#[doc = "Compare signed less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcle_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.s8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmge)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcle_s8(a: int8x8_t, b: int8x8_t) -> uint8x8_t {
    unsafe { simd_le(a, b) }
}
#[doc = "Compare signed less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcleq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.s8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmge)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcleq_s8(a: int8x16_t, b: int8x16_t) -> uint8x16_t {
    unsafe { simd_le(a, b) }
}
#[doc = "Compare signed less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcle_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.s16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmge)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcle_s16(a: int16x4_t, b: int16x4_t) -> uint16x4_t {
    unsafe { simd_le(a, b) }
}
#[doc = "Compare signed less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcleq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.s16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmge)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcleq_s16(a: int16x8_t, b: int16x8_t) -> uint16x8_t {
    unsafe { simd_le(a, b) }
}
#[doc = "Compare signed less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcle_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.s32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmge)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcle_s32(a: int32x2_t, b: int32x2_t) -> uint32x2_t {
    unsafe { simd_le(a, b) }
}
#[doc = "Compare signed less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcleq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.s32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmge)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcleq_s32(a: int32x4_t, b: int32x4_t) -> uint32x4_t {
    unsafe { simd_le(a, b) }
}
#[doc = "Compare unsigned less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcle_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.u8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmhs)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcle_u8(a: uint8x8_t, b: uint8x8_t) -> uint8x8_t {
    unsafe { simd_le(a, b) }
}
#[doc = "Compare unsigned less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcleq_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.u8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmhs)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcleq_u8(a: uint8x16_t, b: uint8x16_t) -> uint8x16_t {
    unsafe { simd_le(a, b) }
}
#[doc = "Compare unsigned less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcle_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.u16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmhs)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcle_u16(a: uint16x4_t, b: uint16x4_t) -> uint16x4_t {
    unsafe { simd_le(a, b) }
}
#[doc = "Compare unsigned less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcleq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.u16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmhs)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcleq_u16(a: uint16x8_t, b: uint16x8_t) -> uint16x8_t {
    unsafe { simd_le(a, b) }
}
#[doc = "Compare unsigned less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcle_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.u32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmhs)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcle_u32(a: uint32x2_t, b: uint32x2_t) -> uint32x2_t {
    unsafe { simd_le(a, b) }
}
#[doc = "Compare unsigned less than or equal"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcleq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcge.u32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmhs)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcleq_u32(a: uint32x4_t, b: uint32x4_t) -> uint32x4_t {
    unsafe { simd_le(a, b) }
}
#[doc = "Floating-point compare less than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclez_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcle.f16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcmle)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vclez_f16(a: float16x4_t) -> uint16x4_t {
    let b: f16x4 = f16x4::new(0.0, 0.0, 0.0, 0.0);
    unsafe { simd_le(a, transmute(b)) }
}
#[doc = "Floating-point compare less than or equal to zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclezq_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcle.f16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcmle)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vclezq_f16(a: float16x8_t) -> uint16x8_t {
    let b: f16x8 = f16x8::new(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    unsafe { simd_le(a, transmute(b)) }
}
#[doc = "Count leading sign bits"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcls_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcls.s8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cls)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcls_s8(a: int8x8_t) -> int8x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vcls.v8i8")]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.cls.v8i8"
        )]
        fn _vcls_s8(a: int8x8_t) -> int8x8_t;
    }
    unsafe { _vcls_s8(a) }
}
#[doc = "Count leading sign bits"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclsq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcls.s8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cls)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vclsq_s8(a: int8x16_t) -> int8x16_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vcls.v16i8")]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.cls.v16i8"
        )]
        fn _vclsq_s8(a: int8x16_t) -> int8x16_t;
    }
    unsafe { _vclsq_s8(a) }
}
#[doc = "Count leading sign bits"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcls_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcls.s16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cls)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcls_s16(a: int16x4_t) -> int16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vcls.v4i16")]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.cls.v4i16"
        )]
        fn _vcls_s16(a: int16x4_t) -> int16x4_t;
    }
    unsafe { _vcls_s16(a) }
}
#[doc = "Count leading sign bits"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclsq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcls.s16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cls)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vclsq_s16(a: int16x8_t) -> int16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vcls.v8i16")]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.cls.v8i16"
        )]
        fn _vclsq_s16(a: int16x8_t) -> int16x8_t;
    }
    unsafe { _vclsq_s16(a) }
}
#[doc = "Count leading sign bits"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcls_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcls.s32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cls)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcls_s32(a: int32x2_t) -> int32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vcls.v2i32")]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.cls.v2i32"
        )]
        fn _vcls_s32(a: int32x2_t) -> int32x2_t;
    }
    unsafe { _vcls_s32(a) }
}
#[doc = "Count leading sign bits"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclsq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcls.s32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cls)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vclsq_s32(a: int32x4_t) -> int32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vcls.v4i32")]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.cls.v4i32"
        )]
        fn _vclsq_s32(a: int32x4_t) -> int32x4_t;
    }
    unsafe { _vclsq_s32(a) }
}
#[doc = "Count leading sign bits"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcls_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcls))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cls)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcls_u8(a: uint8x8_t) -> int8x8_t {
    unsafe { vcls_s8(transmute(a)) }
}
#[doc = "Count leading sign bits"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclsq_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcls))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cls)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vclsq_u8(a: uint8x16_t) -> int8x16_t {
    unsafe { vclsq_s8(transmute(a)) }
}
#[doc = "Count leading sign bits"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcls_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcls))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cls)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcls_u16(a: uint16x4_t) -> int16x4_t {
    unsafe { vcls_s16(transmute(a)) }
}
#[doc = "Count leading sign bits"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclsq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcls))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cls)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vclsq_u16(a: uint16x8_t) -> int16x8_t {
    unsafe { vclsq_s16(transmute(a)) }
}
#[doc = "Count leading sign bits"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcls_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcls))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cls)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcls_u32(a: uint32x2_t) -> int32x2_t {
    unsafe { vcls_s32(transmute(a)) }
}
#[doc = "Count leading sign bits"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclsq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcls))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cls)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vclsq_u32(a: uint32x4_t) -> int32x4_t {
    unsafe { vclsq_s32(transmute(a)) }
}
#[doc = "Floating-point compare less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclt_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.f16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcmgt)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vclt_f16(a: float16x4_t, b: float16x4_t) -> uint16x4_t {
    unsafe { simd_lt(a, b) }
}
#[doc = "Floating-point compare less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcltq_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.f16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcmgt)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcltq_f16(a: float16x8_t, b: float16x8_t) -> uint16x8_t {
    unsafe { simd_lt(a, b) }
}
#[doc = "Floating-point compare less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclt_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.f32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcmgt)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vclt_f32(a: float32x2_t, b: float32x2_t) -> uint32x2_t {
    unsafe { simd_lt(a, b) }
}
#[doc = "Floating-point compare less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcltq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.f32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcmgt)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcltq_f32(a: float32x4_t, b: float32x4_t) -> uint32x4_t {
    unsafe { simd_lt(a, b) }
}
#[doc = "Compare signed less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclt_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.s8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmgt)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vclt_s8(a: int8x8_t, b: int8x8_t) -> uint8x8_t {
    unsafe { simd_lt(a, b) }
}
#[doc = "Compare signed less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcltq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.s8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmgt)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcltq_s8(a: int8x16_t, b: int8x16_t) -> uint8x16_t {
    unsafe { simd_lt(a, b) }
}
#[doc = "Compare signed less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclt_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.s16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmgt)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vclt_s16(a: int16x4_t, b: int16x4_t) -> uint16x4_t {
    unsafe { simd_lt(a, b) }
}
#[doc = "Compare signed less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcltq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.s16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmgt)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcltq_s16(a: int16x8_t, b: int16x8_t) -> uint16x8_t {
    unsafe { simd_lt(a, b) }
}
#[doc = "Compare signed less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclt_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.s32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmgt)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vclt_s32(a: int32x2_t, b: int32x2_t) -> uint32x2_t {
    unsafe { simd_lt(a, b) }
}
#[doc = "Compare signed less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcltq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.s32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmgt)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcltq_s32(a: int32x4_t, b: int32x4_t) -> uint32x4_t {
    unsafe { simd_lt(a, b) }
}
#[doc = "Compare unsigned less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclt_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.u8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmhi)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vclt_u8(a: uint8x8_t, b: uint8x8_t) -> uint8x8_t {
    unsafe { simd_lt(a, b) }
}
#[doc = "Compare unsigned less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcltq_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.u8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmhi)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcltq_u8(a: uint8x16_t, b: uint8x16_t) -> uint8x16_t {
    unsafe { simd_lt(a, b) }
}
#[doc = "Compare unsigned less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclt_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.u16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmhi)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vclt_u16(a: uint16x4_t, b: uint16x4_t) -> uint16x4_t {
    unsafe { simd_lt(a, b) }
}
#[doc = "Compare unsigned less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcltq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.u16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmhi)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcltq_u16(a: uint16x8_t, b: uint16x8_t) -> uint16x8_t {
    unsafe { simd_lt(a, b) }
}
#[doc = "Compare unsigned less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclt_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.u32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmhi)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vclt_u32(a: uint32x2_t, b: uint32x2_t) -> uint32x2_t {
    unsafe { simd_lt(a, b) }
}
#[doc = "Compare unsigned less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcltq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcgt.u32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cmhi)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcltq_u32(a: uint32x4_t, b: uint32x4_t) -> uint32x4_t {
    unsafe { simd_lt(a, b) }
}
#[doc = "Floating-point compare less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcltz_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vclt.f16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcmlt)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcltz_f16(a: float16x4_t) -> uint16x4_t {
    let b: f16x4 = f16x4::new(0.0, 0.0, 0.0, 0.0);
    unsafe { simd_lt(a, transmute(b)) }
}
#[doc = "Floating-point compare less than"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcltzq_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vclt.f16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcmlt)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcltzq_f16(a: float16x8_t) -> uint16x8_t {
    let b: f16x8 = f16x8::new(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    unsafe { simd_lt(a, transmute(b)) }
}
#[doc = "Count leading zero bits"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclz_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vclz.i8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(clz)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vclz_s8(a: int8x8_t) -> int8x8_t {
    unsafe { simd_ctlz(a) }
}
#[doc = "Count leading zero bits"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclzq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vclz.i8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(clz)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vclzq_s8(a: int8x16_t) -> int8x16_t {
    unsafe { simd_ctlz(a) }
}
#[doc = "Count leading zero bits"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclz_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vclz.i16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(clz)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vclz_s16(a: int16x4_t) -> int16x4_t {
    unsafe { simd_ctlz(a) }
}
#[doc = "Count leading zero bits"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclzq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vclz.i16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(clz)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vclzq_s16(a: int16x8_t) -> int16x8_t {
    unsafe { simd_ctlz(a) }
}
#[doc = "Count leading zero bits"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclz_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vclz.i32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(clz)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vclz_s32(a: int32x2_t) -> int32x2_t {
    unsafe { simd_ctlz(a) }
}
#[doc = "Count leading zero bits"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclzq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vclz.i32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(clz)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vclzq_s32(a: int32x4_t) -> int32x4_t {
    unsafe { simd_ctlz(a) }
}
#[doc = "Count leading zero bits"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclz_u16)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vclz.i16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(clz)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vclz_u16(a: uint16x4_t) -> uint16x4_t {
    unsafe { transmute(vclz_s16(transmute(a))) }
}
#[doc = "Count leading zero bits"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclz_u16)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vclz.i16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(clz)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vclz_u16(a: uint16x4_t) -> uint16x4_t {
    let a: uint16x4_t = unsafe { simd_shuffle!(a, a, [3, 2, 1, 0]) };
    unsafe {
        let ret_val: uint16x4_t = transmute(vclz_s16(transmute(a)));
        simd_shuffle!(ret_val, ret_val, [3, 2, 1, 0])
    }
}
#[doc = "Count leading zero bits"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclzq_u16)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vclz.i16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(clz)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vclzq_u16(a: uint16x8_t) -> uint16x8_t {
    unsafe { transmute(vclzq_s16(transmute(a))) }
}
#[doc = "Count leading zero bits"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclzq_u16)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vclz.i16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(clz)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vclzq_u16(a: uint16x8_t) -> uint16x8_t {
    let a: uint16x8_t = unsafe { simd_shuffle!(a, a, [7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: uint16x8_t = transmute(vclzq_s16(transmute(a)));
        simd_shuffle!(ret_val, ret_val, [7, 6, 5, 4, 3, 2, 1, 0])
    }
}
#[doc = "Count leading zero bits"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclz_u32)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vclz.i32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(clz)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vclz_u32(a: uint32x2_t) -> uint32x2_t {
    unsafe { transmute(vclz_s32(transmute(a))) }
}
#[doc = "Count leading zero bits"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclz_u32)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vclz.i32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(clz)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vclz_u32(a: uint32x2_t) -> uint32x2_t {
    let a: uint32x2_t = unsafe { simd_shuffle!(a, a, [1, 0]) };
    unsafe {
        let ret_val: uint32x2_t = transmute(vclz_s32(transmute(a)));
        simd_shuffle!(ret_val, ret_val, [1, 0])
    }
}
#[doc = "Count leading zero bits"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclzq_u32)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vclz.i32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(clz)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vclzq_u32(a: uint32x4_t) -> uint32x4_t {
    unsafe { transmute(vclzq_s32(transmute(a))) }
}
#[doc = "Count leading zero bits"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclzq_u32)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vclz.i32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(clz)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vclzq_u32(a: uint32x4_t) -> uint32x4_t {
    let a: uint32x4_t = unsafe { simd_shuffle!(a, a, [3, 2, 1, 0]) };
    unsafe {
        let ret_val: uint32x4_t = transmute(vclzq_s32(transmute(a)));
        simd_shuffle!(ret_val, ret_val, [3, 2, 1, 0])
    }
}
#[doc = "Count leading zero bits"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclz_u8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vclz.i8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(clz)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vclz_u8(a: uint8x8_t) -> uint8x8_t {
    unsafe { transmute(vclz_s8(transmute(a))) }
}
#[doc = "Count leading zero bits"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclz_u8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vclz.i8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(clz)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vclz_u8(a: uint8x8_t) -> uint8x8_t {
    let a: uint8x8_t = unsafe { simd_shuffle!(a, a, [7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: uint8x8_t = transmute(vclz_s8(transmute(a)));
        simd_shuffle!(ret_val, ret_val, [7, 6, 5, 4, 3, 2, 1, 0])
    }
}
#[doc = "Count leading zero bits"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclzq_u8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vclz.i8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(clz)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vclzq_u8(a: uint8x16_t) -> uint8x16_t {
    unsafe { transmute(vclzq_s8(transmute(a))) }
}
#[doc = "Count leading zero bits"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vclzq_u8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vclz.i8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(clz)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vclzq_u8(a: uint8x16_t) -> uint8x16_t {
    let a: uint8x16_t =
        unsafe { simd_shuffle!(a, a, [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: uint8x16_t = transmute(vclzq_s8(transmute(a)));
        simd_shuffle!(
            ret_val,
            ret_val,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    }
}
#[doc = "Population count per byte."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcnt_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcnt))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cnt)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcnt_s8(a: int8x8_t) -> int8x8_t {
    unsafe { simd_ctpop(a) }
}
#[doc = "Population count per byte."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcntq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcnt))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cnt)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcntq_s8(a: int8x16_t) -> int8x16_t {
    unsafe { simd_ctpop(a) }
}
#[doc = "Population count per byte."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcnt_u8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcnt))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cnt)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcnt_u8(a: uint8x8_t) -> uint8x8_t {
    unsafe { transmute(vcnt_s8(transmute(a))) }
}
#[doc = "Population count per byte."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcnt_u8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcnt))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cnt)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcnt_u8(a: uint8x8_t) -> uint8x8_t {
    let a: uint8x8_t = unsafe { simd_shuffle!(a, a, [7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: uint8x8_t = transmute(vcnt_s8(transmute(a)));
        simd_shuffle!(ret_val, ret_val, [7, 6, 5, 4, 3, 2, 1, 0])
    }
}
#[doc = "Population count per byte."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcntq_u8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcnt))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cnt)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcntq_u8(a: uint8x16_t) -> uint8x16_t {
    unsafe { transmute(vcntq_s8(transmute(a))) }
}
#[doc = "Population count per byte."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcntq_u8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcnt))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cnt)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcntq_u8(a: uint8x16_t) -> uint8x16_t {
    let a: uint8x16_t =
        unsafe { simd_shuffle!(a, a, [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: uint8x16_t = transmute(vcntq_s8(transmute(a)));
        simd_shuffle!(
            ret_val,
            ret_val,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    }
}
#[doc = "Population count per byte."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcnt_p8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcnt))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cnt)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcnt_p8(a: poly8x8_t) -> poly8x8_t {
    unsafe { transmute(vcnt_s8(transmute(a))) }
}
#[doc = "Population count per byte."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcnt_p8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcnt))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cnt)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcnt_p8(a: poly8x8_t) -> poly8x8_t {
    let a: poly8x8_t = unsafe { simd_shuffle!(a, a, [7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: poly8x8_t = transmute(vcnt_s8(transmute(a)));
        simd_shuffle!(ret_val, ret_val, [7, 6, 5, 4, 3, 2, 1, 0])
    }
}
#[doc = "Population count per byte."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcntq_p8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcnt))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cnt)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcntq_p8(a: poly8x16_t) -> poly8x16_t {
    unsafe { transmute(vcntq_s8(transmute(a))) }
}
#[doc = "Population count per byte."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcntq_p8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcnt))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(cnt)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcntq_p8(a: poly8x16_t) -> poly8x16_t {
    let a: poly8x16_t =
        unsafe { simd_shuffle!(a, a, [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let ret_val: poly8x16_t = transmute(vcntq_s8(transmute(a)));
        simd_shuffle!(
            ret_val,
            ret_val,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    }
}
#[doc = "Join two smaller vectors into a single larger vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcombine_f16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
#[cfg_attr(test, assert_instr(nop))]
pub fn vcombine_f16(a: float16x4_t, b: float16x4_t) -> float16x8_t {
    unsafe { simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 6, 7]) }
}
#[doc = "Join two smaller vectors into a single larger vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcombine_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcombine_f32(a: float32x2_t, b: float32x2_t) -> float32x4_t {
    unsafe { simd_shuffle!(a, b, [0, 1, 2, 3]) }
}
#[doc = "Join two smaller vectors into a single larger vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcombine_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcombine_s8(a: int8x8_t, b: int8x8_t) -> int8x16_t {
    unsafe { simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]) }
}
#[doc = "Join two smaller vectors into a single larger vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcombine_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcombine_s16(a: int16x4_t, b: int16x4_t) -> int16x8_t {
    unsafe { simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 6, 7]) }
}
#[doc = "Join two smaller vectors into a single larger vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcombine_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcombine_s32(a: int32x2_t, b: int32x2_t) -> int32x4_t {
    unsafe { simd_shuffle!(a, b, [0, 1, 2, 3]) }
}
#[doc = "Join two smaller vectors into a single larger vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcombine_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcombine_s64(a: int64x1_t, b: int64x1_t) -> int64x2_t {
    unsafe { simd_shuffle!(a, b, [0, 1]) }
}
#[doc = "Join two smaller vectors into a single larger vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcombine_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcombine_u8(a: uint8x8_t, b: uint8x8_t) -> uint8x16_t {
    unsafe { simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]) }
}
#[doc = "Join two smaller vectors into a single larger vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcombine_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcombine_u16(a: uint16x4_t, b: uint16x4_t) -> uint16x8_t {
    unsafe { simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 6, 7]) }
}
#[doc = "Join two smaller vectors into a single larger vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcombine_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcombine_u32(a: uint32x2_t, b: uint32x2_t) -> uint32x4_t {
    unsafe { simd_shuffle!(a, b, [0, 1, 2, 3]) }
}
#[doc = "Join two smaller vectors into a single larger vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcombine_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcombine_u64(a: uint64x1_t, b: uint64x1_t) -> uint64x2_t {
    unsafe { simd_shuffle!(a, b, [0, 1]) }
}
#[doc = "Join two smaller vectors into a single larger vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcombine_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcombine_p8(a: poly8x8_t, b: poly8x8_t) -> poly8x16_t {
    unsafe { simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]) }
}
#[doc = "Join two smaller vectors into a single larger vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcombine_p16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcombine_p16(a: poly16x4_t, b: poly16x4_t) -> poly16x8_t {
    unsafe { simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 6, 7]) }
}
#[doc = "Join two smaller vectors into a single larger vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcombine_p64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcombine_p64(a: poly64x1_t, b: poly64x1_t) -> poly64x2_t {
    unsafe { simd_shuffle!(a, b, [0, 1]) }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcreate_f16)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcreate_f16(a: u64) -> float16x4_t {
    unsafe { transmute(a) }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcreate_f16)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcreate_f16(a: u64) -> float16x4_t {
    unsafe {
        let ret_val: float16x4_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [3, 2, 1, 0])
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcreate_f32)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcreate_f32(a: u64) -> float32x2_t {
    unsafe { transmute(a) }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcreate_f32)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcreate_f32(a: u64) -> float32x2_t {
    unsafe {
        let ret_val: float32x2_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [1, 0])
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcreate_s8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcreate_s8(a: u64) -> int8x8_t {
    unsafe { transmute(a) }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcreate_s8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcreate_s8(a: u64) -> int8x8_t {
    unsafe {
        let ret_val: int8x8_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [7, 6, 5, 4, 3, 2, 1, 0])
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcreate_s16)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcreate_s16(a: u64) -> int16x4_t {
    unsafe { transmute(a) }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcreate_s16)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcreate_s16(a: u64) -> int16x4_t {
    unsafe {
        let ret_val: int16x4_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [3, 2, 1, 0])
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcreate_s32)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcreate_s32(a: u64) -> int32x2_t {
    unsafe { transmute(a) }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcreate_s32)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcreate_s32(a: u64) -> int32x2_t {
    unsafe {
        let ret_val: int32x2_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [1, 0])
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcreate_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcreate_s64(a: u64) -> int64x1_t {
    unsafe { transmute(a) }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcreate_u8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcreate_u8(a: u64) -> uint8x8_t {
    unsafe { transmute(a) }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcreate_u8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcreate_u8(a: u64) -> uint8x8_t {
    unsafe {
        let ret_val: uint8x8_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [7, 6, 5, 4, 3, 2, 1, 0])
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcreate_u16)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcreate_u16(a: u64) -> uint16x4_t {
    unsafe { transmute(a) }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcreate_u16)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcreate_u16(a: u64) -> uint16x4_t {
    unsafe {
        let ret_val: uint16x4_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [3, 2, 1, 0])
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcreate_u32)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcreate_u32(a: u64) -> uint32x2_t {
    unsafe { transmute(a) }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcreate_u32)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcreate_u32(a: u64) -> uint32x2_t {
    unsafe {
        let ret_val: uint32x2_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [1, 0])
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcreate_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcreate_u64(a: u64) -> uint64x1_t {
    unsafe { transmute(a) }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcreate_p8)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcreate_p8(a: u64) -> poly8x8_t {
    unsafe { transmute(a) }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcreate_p8)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcreate_p8(a: u64) -> poly8x8_t {
    unsafe {
        let ret_val: poly8x8_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [7, 6, 5, 4, 3, 2, 1, 0])
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcreate_p16)"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcreate_p16(a: u64) -> poly16x4_t {
    unsafe { transmute(a) }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcreate_p16)"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcreate_p16(a: u64) -> poly16x4_t {
    unsafe {
        let ret_val: poly16x4_t = transmute(a);
        simd_shuffle!(ret_val, ret_val, [3, 2, 1, 0])
    }
}
#[doc = "Insert vector element from another vector element"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcreate_p64)"]
#[inline]
#[target_feature(enable = "neon,aes")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcreate_p64(a: u64) -> poly64x1_t {
    unsafe { transmute(a) }
}
#[doc = "Floating-point convert to lower precision narrow"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_f16_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcvt))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcvtn)
)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcvt_f16_f32(a: float32x4_t) -> float16x4_t {
    unsafe { simd_cast(a) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_f16_s16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcvt))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(scvtf)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcvt_f16_s16(a: int16x4_t) -> float16x4_t {
    unsafe { simd_cast(a) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtq_f16_s16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcvt))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(scvtf)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcvtq_f16_s16(a: int16x8_t) -> float16x8_t {
    unsafe { simd_cast(a) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_f16_u16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcvt))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ucvtf)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcvt_f16_u16(a: uint16x4_t) -> float16x4_t {
    unsafe { simd_cast(a) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtq_f16_u16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcvt))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ucvtf)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcvtq_f16_u16(a: uint16x8_t) -> float16x8_t {
    unsafe { simd_cast(a) }
}
#[doc = "Floating-point convert to higher precision long"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_f32_f16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcvt))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcvtl)
)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcvt_f32_f16(a: float16x4_t) -> float32x4_t {
    unsafe { simd_cast(a) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_f32_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcvt))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(scvtf)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcvt_f32_s32(a: int32x2_t) -> float32x2_t {
    unsafe { simd_cast(a) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtq_f32_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcvt))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(scvtf)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcvtq_f32_s32(a: int32x4_t) -> float32x4_t {
    unsafe { simd_cast(a) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_f32_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcvt))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ucvtf)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcvt_f32_u32(a: uint32x2_t) -> float32x2_t {
    unsafe { simd_cast(a) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtq_f32_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcvt))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ucvtf)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcvtq_f32_u32(a: uint32x4_t) -> float32x4_t {
    unsafe { simd_cast(a) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_n_f16_s16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcvt", N = 1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(scvtf, N = 1)
)]
#[rustc_legacy_const_generics(1)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcvt_n_f16_s16<const N: i32>(a: int16x4_t) -> float16x4_t {
    static_assert!(N >= 1 && N <= 16);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            target_arch = "arm",
            link_name = "llvm.arm.neon.vcvtfxs2fp.v4f16.v4i16"
        )]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfxs2fp.v4f16.v4i16"
        )]
        fn _vcvt_n_f16_s16(a: int16x4_t, n: i32) -> float16x4_t;
    }
    unsafe { _vcvt_n_f16_s16(a, N) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtq_n_f16_s16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcvt", N = 1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(scvtf, N = 1)
)]
#[rustc_legacy_const_generics(1)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcvtq_n_f16_s16<const N: i32>(a: int16x8_t) -> float16x8_t {
    static_assert!(N >= 1 && N <= 16);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            target_arch = "arm",
            link_name = "llvm.arm.neon.vcvtfxs2fp.v8f16.v8i16"
        )]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfxs2fp.v8f16.v8i16"
        )]
        fn _vcvtq_n_f16_s16(a: int16x8_t, n: i32) -> float16x8_t;
    }
    unsafe { _vcvtq_n_f16_s16(a, N) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_n_f16_u16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcvt", N = 1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ucvtf, N = 1)
)]
#[rustc_legacy_const_generics(1)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcvt_n_f16_u16<const N: i32>(a: uint16x4_t) -> float16x4_t {
    static_assert!(N >= 1 && N <= 16);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            target_arch = "arm",
            link_name = "llvm.arm.neon.vcvtfxu2fp.v4f16.v4i16"
        )]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfxu2fp.v4f16.v4i16"
        )]
        fn _vcvt_n_f16_u16(a: uint16x4_t, n: i32) -> float16x4_t;
    }
    unsafe { _vcvt_n_f16_u16(a, N) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtq_n_f16_u16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcvt", N = 1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ucvtf, N = 1)
)]
#[rustc_legacy_const_generics(1)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcvtq_n_f16_u16<const N: i32>(a: uint16x8_t) -> float16x8_t {
    static_assert!(N >= 1 && N <= 16);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            target_arch = "arm",
            link_name = "llvm.arm.neon.vcvtfxu2fp.v8f16.v8i16"
        )]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfxu2fp.v8f16.v8i16"
        )]
        fn _vcvtq_n_f16_u16(a: uint16x8_t, n: i32) -> float16x8_t;
    }
    unsafe { _vcvtq_n_f16_u16(a, N) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_n_f32_s32)"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(test, assert_instr(vcvt, N = 2))]
#[rustc_legacy_const_generics(1)]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
pub fn vcvt_n_f32_s32<const N: i32>(a: int32x2_t) -> float32x2_t {
    static_assert!(N >= 1 && N <= 32);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            target_arch = "arm",
            link_name = "llvm.arm.neon.vcvtfxs2fp.v2f32.v2i32"
        )]
        fn _vcvt_n_f32_s32(a: int32x2_t, n: i32) -> float32x2_t;
    }
    unsafe { _vcvt_n_f32_s32(a, N) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtq_n_f32_s32)"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(test, assert_instr(vcvt, N = 2))]
#[rustc_legacy_const_generics(1)]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
pub fn vcvtq_n_f32_s32<const N: i32>(a: int32x4_t) -> float32x4_t {
    static_assert!(N >= 1 && N <= 32);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            target_arch = "arm",
            link_name = "llvm.arm.neon.vcvtfxs2fp.v4f32.v4i32"
        )]
        fn _vcvtq_n_f32_s32(a: int32x4_t, n: i32) -> float32x4_t;
    }
    unsafe { _vcvtq_n_f32_s32(a, N) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_n_f32_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(scvtf, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvt_n_f32_s32<const N: i32>(a: int32x2_t) -> float32x2_t {
    static_assert!(N >= 1 && N <= 32);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfxs2fp.v2f32.v2i32"
        )]
        fn _vcvt_n_f32_s32(a: int32x2_t, n: i32) -> float32x2_t;
    }
    unsafe { _vcvt_n_f32_s32(a, N) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtq_n_f32_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(scvtf, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtq_n_f32_s32<const N: i32>(a: int32x4_t) -> float32x4_t {
    static_assert!(N >= 1 && N <= 32);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfxs2fp.v4f32.v4i32"
        )]
        fn _vcvtq_n_f32_s32(a: int32x4_t, n: i32) -> float32x4_t;
    }
    unsafe { _vcvtq_n_f32_s32(a, N) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_n_f32_u32)"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(test, assert_instr(vcvt, N = 2))]
#[rustc_legacy_const_generics(1)]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
pub fn vcvt_n_f32_u32<const N: i32>(a: uint32x2_t) -> float32x2_t {
    static_assert!(N >= 1 && N <= 32);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            target_arch = "arm",
            link_name = "llvm.arm.neon.vcvtfxu2fp.v2f32.v2i32"
        )]
        fn _vcvt_n_f32_u32(a: uint32x2_t, n: i32) -> float32x2_t;
    }
    unsafe { _vcvt_n_f32_u32(a, N) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtq_n_f32_u32)"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(test, assert_instr(vcvt, N = 2))]
#[rustc_legacy_const_generics(1)]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
pub fn vcvtq_n_f32_u32<const N: i32>(a: uint32x4_t) -> float32x4_t {
    static_assert!(N >= 1 && N <= 32);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            target_arch = "arm",
            link_name = "llvm.arm.neon.vcvtfxu2fp.v4f32.v4i32"
        )]
        fn _vcvtq_n_f32_u32(a: uint32x4_t, n: i32) -> float32x4_t;
    }
    unsafe { _vcvtq_n_f32_u32(a, N) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_n_f32_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(ucvtf, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvt_n_f32_u32<const N: i32>(a: uint32x2_t) -> float32x2_t {
    static_assert!(N >= 1 && N <= 32);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfxu2fp.v2f32.v2i32"
        )]
        fn _vcvt_n_f32_u32(a: uint32x2_t, n: i32) -> float32x2_t;
    }
    unsafe { _vcvt_n_f32_u32(a, N) }
}
#[doc = "Fixed-point convert to floating-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtq_n_f32_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(ucvtf, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtq_n_f32_u32<const N: i32>(a: uint32x4_t) -> float32x4_t {
    static_assert!(N >= 1 && N <= 32);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfxu2fp.v4f32.v4i32"
        )]
        fn _vcvtq_n_f32_u32(a: uint32x4_t, n: i32) -> float32x4_t;
    }
    unsafe { _vcvtq_n_f32_u32(a, N) }
}
#[doc = "Floating-point convert to signed fixed-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_n_s16_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcvt", N = 1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcvtzs, N = 1)
)]
#[rustc_legacy_const_generics(1)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcvt_n_s16_f16<const N: i32>(a: float16x4_t) -> int16x4_t {
    static_assert!(N >= 1 && N <= 16);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            target_arch = "arm",
            link_name = "llvm.arm.neon.vcvtfp2fxs.v4i16.v4f16"
        )]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfp2fxs.v4i16.v4f16"
        )]
        fn _vcvt_n_s16_f16(a: float16x4_t, n: i32) -> int16x4_t;
    }
    unsafe { _vcvt_n_s16_f16(a, N) }
}
#[doc = "Floating-point convert to signed fixed-point"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtq_n_s16_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcvt", N = 1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcvtzs, N = 1)
)]
#[rustc_legacy_const_generics(1)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcvtq_n_s16_f16<const N: i32>(a: float16x8_t) -> int16x8_t {
    static_assert!(N >= 1 && N <= 16);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            target_arch = "arm",
            link_name = "llvm.arm.neon.vcvtfp2fxs.v8i16.v8f16"
        )]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfp2fxs.v8i16.v8f16"
        )]
        fn _vcvtq_n_s16_f16(a: float16x8_t, n: i32) -> int16x8_t;
    }
    unsafe { _vcvtq_n_s16_f16(a, N) }
}
#[doc = "Floating-point convert to fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_n_s32_f32)"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(test, assert_instr(vcvt, N = 2))]
#[rustc_legacy_const_generics(1)]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
pub fn vcvt_n_s32_f32<const N: i32>(a: float32x2_t) -> int32x2_t {
    static_assert!(N >= 1 && N <= 32);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            target_arch = "arm",
            link_name = "llvm.arm.neon.vcvtfp2fxs.v2i32.v2f32"
        )]
        fn _vcvt_n_s32_f32(a: float32x2_t, n: i32) -> int32x2_t;
    }
    unsafe { _vcvt_n_s32_f32(a, N) }
}
#[doc = "Floating-point convert to fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtq_n_s32_f32)"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(test, assert_instr(vcvt, N = 2))]
#[rustc_legacy_const_generics(1)]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
pub fn vcvtq_n_s32_f32<const N: i32>(a: float32x4_t) -> int32x4_t {
    static_assert!(N >= 1 && N <= 32);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            target_arch = "arm",
            link_name = "llvm.arm.neon.vcvtfp2fxs.v4i32.v4f32"
        )]
        fn _vcvtq_n_s32_f32(a: float32x4_t, n: i32) -> int32x4_t;
    }
    unsafe { _vcvtq_n_s32_f32(a, N) }
}
#[doc = "Floating-point convert to fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_n_s32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(fcvtzs, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvt_n_s32_f32<const N: i32>(a: float32x2_t) -> int32x2_t {
    static_assert!(N >= 1 && N <= 32);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfp2fxs.v2i32.v2f32"
        )]
        fn _vcvt_n_s32_f32(a: float32x2_t, n: i32) -> int32x2_t;
    }
    unsafe { _vcvt_n_s32_f32(a, N) }
}
#[doc = "Floating-point convert to fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtq_n_s32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(fcvtzs, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtq_n_s32_f32<const N: i32>(a: float32x4_t) -> int32x4_t {
    static_assert!(N >= 1 && N <= 32);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfp2fxs.v4i32.v4f32"
        )]
        fn _vcvtq_n_s32_f32(a: float32x4_t, n: i32) -> int32x4_t;
    }
    unsafe { _vcvtq_n_s32_f32(a, N) }
}
#[doc = "Fixed-point convert to unsigned fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_n_u16_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcvt", N = 1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcvtzu, N = 1)
)]
#[rustc_legacy_const_generics(1)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcvt_n_u16_f16<const N: i32>(a: float16x4_t) -> uint16x4_t {
    static_assert!(N >= 1 && N <= 16);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            target_arch = "arm",
            link_name = "llvm.arm.neon.vcvtfp2fxu.v4i16.v4f16"
        )]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfp2fxu.v4i16.v4f16"
        )]
        fn _vcvt_n_u16_f16(a: float16x4_t, n: i32) -> uint16x4_t;
    }
    unsafe { _vcvt_n_u16_f16(a, N) }
}
#[doc = "Fixed-point convert to unsigned fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtq_n_u16_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vcvt", N = 1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcvtzu, N = 1)
)]
#[rustc_legacy_const_generics(1)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcvtq_n_u16_f16<const N: i32>(a: float16x8_t) -> uint16x8_t {
    static_assert!(N >= 1 && N <= 16);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            target_arch = "arm",
            link_name = "llvm.arm.neon.vcvtfp2fxu.v8i16.v8f16"
        )]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfp2fxu.v8i16.v8f16"
        )]
        fn _vcvtq_n_u16_f16(a: float16x8_t, n: i32) -> uint16x8_t;
    }
    unsafe { _vcvtq_n_u16_f16(a, N) }
}
#[doc = "Floating-point convert to fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_n_u32_f32)"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(test, assert_instr(vcvt, N = 2))]
#[rustc_legacy_const_generics(1)]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
pub fn vcvt_n_u32_f32<const N: i32>(a: float32x2_t) -> uint32x2_t {
    static_assert!(N >= 1 && N <= 32);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            target_arch = "arm",
            link_name = "llvm.arm.neon.vcvtfp2fxu.v2i32.v2f32"
        )]
        fn _vcvt_n_u32_f32(a: float32x2_t, n: i32) -> uint32x2_t;
    }
    unsafe { _vcvt_n_u32_f32(a, N) }
}
#[doc = "Floating-point convert to fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtq_n_u32_f32)"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(test, assert_instr(vcvt, N = 2))]
#[rustc_legacy_const_generics(1)]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
pub fn vcvtq_n_u32_f32<const N: i32>(a: float32x4_t) -> uint32x4_t {
    static_assert!(N >= 1 && N <= 32);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            target_arch = "arm",
            link_name = "llvm.arm.neon.vcvtfp2fxu.v4i32.v4f32"
        )]
        fn _vcvtq_n_u32_f32(a: float32x4_t, n: i32) -> uint32x4_t;
    }
    unsafe { _vcvtq_n_u32_f32(a, N) }
}
#[doc = "Floating-point convert to fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_n_u32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(fcvtzu, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvt_n_u32_f32<const N: i32>(a: float32x2_t) -> uint32x2_t {
    static_assert!(N >= 1 && N <= 32);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfp2fxu.v2i32.v2f32"
        )]
        fn _vcvt_n_u32_f32(a: float32x2_t, n: i32) -> uint32x2_t;
    }
    unsafe { _vcvt_n_u32_f32(a, N) }
}
#[doc = "Floating-point convert to fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtq_n_u32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(fcvtzu, N = 2))]
#[rustc_legacy_const_generics(1)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub fn vcvtq_n_u32_f32<const N: i32>(a: float32x4_t) -> uint32x4_t {
    static_assert!(N >= 1 && N <= 32);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.vcvtfp2fxu.v4i32.v4f32"
        )]
        fn _vcvtq_n_u32_f32(a: float32x4_t, n: i32) -> uint32x4_t;
    }
    unsafe { _vcvtq_n_u32_f32(a, N) }
}
#[doc = "Floating-point convert to signed fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_s16_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcvt))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcvtzs)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcvt_s16_f16(a: float16x4_t) -> int16x4_t {
    unsafe { simd_cast(a) }
}
#[doc = "Floating-point convert to signed fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtq_s16_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcvt))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcvtzs)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcvtq_s16_f16(a: float16x8_t) -> int16x8_t {
    unsafe { simd_cast(a) }
}
#[doc = "Floating-point convert to signed fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_s32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcvt))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcvtzs)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcvt_s32_f32(a: float32x2_t) -> int32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.fptosi.sat.v2i32.v2f32")]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.fptosi.sat.v2i32.v2f32"
        )]
        fn _vcvt_s32_f32(a: float32x2_t) -> int32x2_t;
    }
    unsafe { _vcvt_s32_f32(a) }
}
#[doc = "Floating-point convert to signed fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtq_s32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcvt))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcvtzs)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcvtq_s32_f32(a: float32x4_t) -> int32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.fptosi.sat.v4i32.v4f32")]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.fptosi.sat.v4i32.v4f32"
        )]
        fn _vcvtq_s32_f32(a: float32x4_t) -> int32x4_t;
    }
    unsafe { _vcvtq_s32_f32(a) }
}
#[doc = "Floating-point convert to unsigned fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_u16_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcvt))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcvtzu)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcvt_u16_f16(a: float16x4_t) -> uint16x4_t {
    unsafe { simd_cast(a) }
}
#[doc = "Floating-point convert to unsigned fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtq_u16_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcvt))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcvtzu)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vcvtq_u16_f16(a: float16x8_t) -> uint16x8_t {
    unsafe { simd_cast(a) }
}
#[doc = "Floating-point convert to unsigned fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvt_u32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcvt))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcvtzu)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcvt_u32_f32(a: float32x2_t) -> uint32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.fptoui.sat.v2i32.v2f32")]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.fptoui.sat.v2i32.v2f32"
        )]
        fn _vcvt_u32_f32(a: float32x2_t) -> uint32x2_t;
    }
    unsafe { _vcvt_u32_f32(a) }
}
#[doc = "Floating-point convert to unsigned fixed-point, rounding toward zero"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vcvtq_u32_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vcvt))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fcvtzu)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vcvtq_u32_f32(a: float32x4_t) -> uint32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.fptoui.sat.v4i32.v4f32")]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.fptoui.sat.v4i32.v4f32"
        )]
        fn _vcvtq_u32_f32(a: float32x4_t) -> uint32x4_t;
    }
    unsafe { _vcvtq_u32_f32(a) }
}
#[doc = "Dot product arithmetic (indexed)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdot_lane_s32)"]
#[inline]
#[cfg(target_endian = "little")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[target_feature(enable = "neon,dotprod")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vsdot, LANE = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(sdot, LANE = 0)
)]
#[rustc_legacy_const_generics(3)]
#[cfg_attr(
    not(target_arch = "arm"),
    unstable(feature = "stdarch_neon_dotprod", issue = "117224")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdot_lane_s32<const LANE: i32>(a: int32x2_t, b: int8x8_t, c: int8x8_t) -> int32x2_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        let c: int32x2_t = transmute(c);
        let c: int32x2_t = simd_shuffle!(c, c, [LANE as u32, LANE as u32]);
        vdot_s32(a, b, transmute(c))
    }
}
#[doc = "Dot product arithmetic (indexed)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdot_lane_s32)"]
#[inline]
#[cfg(target_endian = "big")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[target_feature(enable = "neon,dotprod")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vsdot, LANE = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(sdot, LANE = 0)
)]
#[rustc_legacy_const_generics(3)]
#[cfg_attr(
    not(target_arch = "arm"),
    unstable(feature = "stdarch_neon_dotprod", issue = "117224")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdot_lane_s32<const LANE: i32>(a: int32x2_t, b: int8x8_t, c: int8x8_t) -> int32x2_t {
    static_assert_uimm_bits!(LANE, 1);
    let a: int32x2_t = unsafe { simd_shuffle!(a, a, [1, 0]) };
    let b: int8x8_t = unsafe { simd_shuffle!(b, b, [7, 6, 5, 4, 3, 2, 1, 0]) };
    let c: int8x8_t = unsafe { simd_shuffle!(c, c, [7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let c: int32x2_t = transmute(c);
        let c: int32x2_t = simd_shuffle!(c, c, [LANE as u32, LANE as u32]);
        let ret_val: int32x2_t = vdot_s32(a, b, transmute(c));
        simd_shuffle!(ret_val, ret_val, [1, 0])
    }
}
#[doc = "Dot product arithmetic (indexed)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdotq_lane_s32)"]
#[inline]
#[cfg(target_endian = "little")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[target_feature(enable = "neon,dotprod")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vsdot, LANE = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(sdot, LANE = 0)
)]
#[rustc_legacy_const_generics(3)]
#[cfg_attr(
    not(target_arch = "arm"),
    unstable(feature = "stdarch_neon_dotprod", issue = "117224")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdotq_lane_s32<const LANE: i32>(a: int32x4_t, b: int8x16_t, c: int8x8_t) -> int32x4_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        let c: int32x2_t = transmute(c);
        let c: int32x4_t =
            simd_shuffle!(c, c, [LANE as u32, LANE as u32, LANE as u32, LANE as u32]);
        vdotq_s32(a, b, transmute(c))
    }
}
#[doc = "Dot product arithmetic (indexed)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdotq_lane_s32)"]
#[inline]
#[cfg(target_endian = "big")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[target_feature(enable = "neon,dotprod")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vsdot, LANE = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(sdot, LANE = 0)
)]
#[rustc_legacy_const_generics(3)]
#[cfg_attr(
    not(target_arch = "arm"),
    unstable(feature = "stdarch_neon_dotprod", issue = "117224")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdotq_lane_s32<const LANE: i32>(a: int32x4_t, b: int8x16_t, c: int8x8_t) -> int32x4_t {
    static_assert_uimm_bits!(LANE, 1);
    let a: int32x4_t = unsafe { simd_shuffle!(a, a, [3, 2, 1, 0]) };
    let b: int8x16_t =
        unsafe { simd_shuffle!(b, b, [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]) };
    let c: int8x8_t = unsafe { simd_shuffle!(c, c, [7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let c: int32x2_t = transmute(c);
        let c: int32x4_t =
            simd_shuffle!(c, c, [LANE as u32, LANE as u32, LANE as u32, LANE as u32]);
        let ret_val: int32x4_t = vdotq_s32(a, b, transmute(c));
        simd_shuffle!(ret_val, ret_val, [3, 2, 1, 0])
    }
}
#[doc = "Dot product arithmetic (indexed)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdot_lane_u32)"]
#[inline]
#[cfg(target_endian = "little")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[target_feature(enable = "neon,dotprod")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vudot, LANE = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(udot, LANE = 0)
)]
#[rustc_legacy_const_generics(3)]
#[cfg_attr(
    not(target_arch = "arm"),
    unstable(feature = "stdarch_neon_dotprod", issue = "117224")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdot_lane_u32<const LANE: i32>(a: uint32x2_t, b: uint8x8_t, c: uint8x8_t) -> uint32x2_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        let c: uint32x2_t = transmute(c);
        let c: uint32x2_t = simd_shuffle!(c, c, [LANE as u32, LANE as u32]);
        vdot_u32(a, b, transmute(c))
    }
}
#[doc = "Dot product arithmetic (indexed)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdot_lane_u32)"]
#[inline]
#[cfg(target_endian = "big")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[target_feature(enable = "neon,dotprod")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vudot, LANE = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(udot, LANE = 0)
)]
#[rustc_legacy_const_generics(3)]
#[cfg_attr(
    not(target_arch = "arm"),
    unstable(feature = "stdarch_neon_dotprod", issue = "117224")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdot_lane_u32<const LANE: i32>(a: uint32x2_t, b: uint8x8_t, c: uint8x8_t) -> uint32x2_t {
    static_assert_uimm_bits!(LANE, 1);
    let a: uint32x2_t = unsafe { simd_shuffle!(a, a, [1, 0]) };
    let b: uint8x8_t = unsafe { simd_shuffle!(b, b, [7, 6, 5, 4, 3, 2, 1, 0]) };
    let c: uint8x8_t = unsafe { simd_shuffle!(c, c, [7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let c: uint32x2_t = transmute(c);
        let c: uint32x2_t = simd_shuffle!(c, c, [LANE as u32, LANE as u32]);
        let ret_val: uint32x2_t = vdot_u32(a, b, transmute(c));
        simd_shuffle!(ret_val, ret_val, [1, 0])
    }
}
#[doc = "Dot product arithmetic (indexed)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdotq_lane_u32)"]
#[inline]
#[cfg(target_endian = "little")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[target_feature(enable = "neon,dotprod")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vudot, LANE = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(udot, LANE = 0)
)]
#[rustc_legacy_const_generics(3)]
#[cfg_attr(
    not(target_arch = "arm"),
    unstable(feature = "stdarch_neon_dotprod", issue = "117224")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdotq_lane_u32<const LANE: i32>(a: uint32x4_t, b: uint8x16_t, c: uint8x8_t) -> uint32x4_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe {
        let c: uint32x2_t = transmute(c);
        let c: uint32x4_t =
            simd_shuffle!(c, c, [LANE as u32, LANE as u32, LANE as u32, LANE as u32]);
        vdotq_u32(a, b, transmute(c))
    }
}
#[doc = "Dot product arithmetic (indexed)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdotq_lane_u32)"]
#[inline]
#[cfg(target_endian = "big")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[target_feature(enable = "neon,dotprod")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vudot, LANE = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(udot, LANE = 0)
)]
#[rustc_legacy_const_generics(3)]
#[cfg_attr(
    not(target_arch = "arm"),
    unstable(feature = "stdarch_neon_dotprod", issue = "117224")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdotq_lane_u32<const LANE: i32>(a: uint32x4_t, b: uint8x16_t, c: uint8x8_t) -> uint32x4_t {
    static_assert_uimm_bits!(LANE, 1);
    let a: uint32x4_t = unsafe { simd_shuffle!(a, a, [3, 2, 1, 0]) };
    let b: uint8x16_t =
        unsafe { simd_shuffle!(b, b, [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]) };
    let c: uint8x8_t = unsafe { simd_shuffle!(c, c, [7, 6, 5, 4, 3, 2, 1, 0]) };
    unsafe {
        let c: uint32x2_t = transmute(c);
        let c: uint32x4_t =
            simd_shuffle!(c, c, [LANE as u32, LANE as u32, LANE as u32, LANE as u32]);
        let ret_val: uint32x4_t = vdotq_u32(a, b, transmute(c));
        simd_shuffle!(ret_val, ret_val, [3, 2, 1, 0])
    }
}
#[doc = "Dot product arithmetic (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdot_s32)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[target_feature(enable = "neon,dotprod")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vsdot))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(sdot)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    unstable(feature = "stdarch_neon_dotprod", issue = "117224")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdot_s32(a: int32x2_t, b: int8x8_t, c: int8x8_t) -> int32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.sdot.v2i32.v8i8")]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sdot.v2i32.v8i8"
        )]
        fn _vdot_s32(a: int32x2_t, b: int8x8_t, c: int8x8_t) -> int32x2_t;
    }
    unsafe { _vdot_s32(a, b, c) }
}
#[doc = "Dot product arithmetic (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdotq_s32)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[target_feature(enable = "neon,dotprod")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vsdot))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(sdot)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    unstable(feature = "stdarch_neon_dotprod", issue = "117224")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdotq_s32(a: int32x4_t, b: int8x16_t, c: int8x16_t) -> int32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.sdot.v4i32.v16i8")]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.sdot.v4i32.v16i8"
        )]
        fn _vdotq_s32(a: int32x4_t, b: int8x16_t, c: int8x16_t) -> int32x4_t;
    }
    unsafe { _vdotq_s32(a, b, c) }
}
#[doc = "Dot product arithmetic (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdot_u32)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[target_feature(enable = "neon,dotprod")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vudot))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(udot)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    unstable(feature = "stdarch_neon_dotprod", issue = "117224")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdot_u32(a: uint32x2_t, b: uint8x8_t, c: uint8x8_t) -> uint32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.udot.v2i32.v8i8")]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.udot.v2i32.v8i8"
        )]
        fn _vdot_u32(a: uint32x2_t, b: uint8x8_t, c: uint8x8_t) -> uint32x2_t;
    }
    unsafe { _vdot_u32(a, b, c) }
}
#[doc = "Dot product arithmetic (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdotq_u32)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[target_feature(enable = "neon,dotprod")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vudot))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(udot)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    unstable(feature = "stdarch_neon_dotprod", issue = "117224")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdotq_u32(a: uint32x4_t, b: uint8x16_t, c: uint8x16_t) -> uint32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.udot.v4i32.v16i8")]
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.udot.v4i32.v16i8"
        )]
        fn _vdotq_u32(a: uint32x4_t, b: uint8x16_t, c: uint8x16_t) -> uint32x4_t;
    }
    unsafe { _vdotq_u32(a, b, c) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_lane_f16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.16", N = 2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 2)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vdup_lane_f16<const N: i32>(a: float16x4_t) -> float16x4_t {
    static_assert_uimm_bits!(N, 2);
    unsafe { simd_shuffle!(a, a, [N as u32, N as u32, N as u32, N as u32]) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_lane_f16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.16", N = 2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 2)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vdupq_lane_f16<const N: i32>(a: float16x4_t) -> float16x8_t {
    static_assert_uimm_bits!(N, 2);
    unsafe {
        simd_shuffle!(
            a,
            a,
            [N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32]
        )
    }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_lane_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.32", N = 1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 1)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdup_lane_f32<const N: i32>(a: float32x2_t) -> float32x2_t {
    static_assert_uimm_bits!(N, 1);
    unsafe { simd_shuffle!(a, a, [N as u32, N as u32]) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_lane_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.32", N = 1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 1)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdup_lane_s32<const N: i32>(a: int32x2_t) -> int32x2_t {
    static_assert_uimm_bits!(N, 1);
    unsafe { simd_shuffle!(a, a, [N as u32, N as u32]) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_lane_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.32", N = 1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 1)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdup_lane_u32<const N: i32>(a: uint32x2_t) -> uint32x2_t {
    static_assert_uimm_bits!(N, 1);
    unsafe { simd_shuffle!(a, a, [N as u32, N as u32]) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_lane_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.32", N = 1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 1)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdupq_lane_f32<const N: i32>(a: float32x2_t) -> float32x4_t {
    static_assert_uimm_bits!(N, 1);
    unsafe { simd_shuffle!(a, a, [N as u32, N as u32, N as u32, N as u32]) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_lane_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.32", N = 1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 1)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdupq_lane_s32<const N: i32>(a: int32x2_t) -> int32x4_t {
    static_assert_uimm_bits!(N, 1);
    unsafe { simd_shuffle!(a, a, [N as u32, N as u32, N as u32, N as u32]) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_lane_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.32", N = 1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 1)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdupq_lane_u32<const N: i32>(a: uint32x2_t) -> uint32x4_t {
    static_assert_uimm_bits!(N, 1);
    unsafe { simd_shuffle!(a, a, [N as u32, N as u32, N as u32, N as u32]) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_lane_p16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.16", N = 2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 2)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdup_lane_p16<const N: i32>(a: poly16x4_t) -> poly16x4_t {
    static_assert_uimm_bits!(N, 2);
    unsafe { simd_shuffle!(a, a, [N as u32, N as u32, N as u32, N as u32]) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_lane_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.16", N = 2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 2)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdup_lane_s16<const N: i32>(a: int16x4_t) -> int16x4_t {
    static_assert_uimm_bits!(N, 2);
    unsafe { simd_shuffle!(a, a, [N as u32, N as u32, N as u32, N as u32]) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_lane_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.16", N = 2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 2)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdup_lane_u16<const N: i32>(a: uint16x4_t) -> uint16x4_t {
    static_assert_uimm_bits!(N, 2);
    unsafe { simd_shuffle!(a, a, [N as u32, N as u32, N as u32, N as u32]) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_lane_p16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.16", N = 2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 2)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdupq_lane_p16<const N: i32>(a: poly16x4_t) -> poly16x8_t {
    static_assert_uimm_bits!(N, 2);
    unsafe {
        simd_shuffle!(
            a,
            a,
            [N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32]
        )
    }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_lane_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.16", N = 2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 2)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdupq_lane_s16<const N: i32>(a: int16x4_t) -> int16x8_t {
    static_assert_uimm_bits!(N, 2);
    unsafe {
        simd_shuffle!(
            a,
            a,
            [N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32]
        )
    }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_lane_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.16", N = 2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 2)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdupq_lane_u16<const N: i32>(a: uint16x4_t) -> uint16x8_t {
    static_assert_uimm_bits!(N, 2);
    unsafe {
        simd_shuffle!(
            a,
            a,
            [N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32]
        )
    }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_lane_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.8", N = 4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 4)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdup_lane_p8<const N: i32>(a: poly8x8_t) -> poly8x8_t {
    static_assert_uimm_bits!(N, 3);
    unsafe {
        simd_shuffle!(
            a,
            a,
            [N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32]
        )
    }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_lane_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.8", N = 4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 4)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdup_lane_s8<const N: i32>(a: int8x8_t) -> int8x8_t {
    static_assert_uimm_bits!(N, 3);
    unsafe {
        simd_shuffle!(
            a,
            a,
            [N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32]
        )
    }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_lane_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.8", N = 4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 4)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdup_lane_u8<const N: i32>(a: uint8x8_t) -> uint8x8_t {
    static_assert_uimm_bits!(N, 3);
    unsafe {
        simd_shuffle!(
            a,
            a,
            [N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32]
        )
    }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_lane_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.8", N = 4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 4)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdupq_lane_p8<const N: i32>(a: poly8x8_t) -> poly8x16_t {
    static_assert_uimm_bits!(N, 3);
    unsafe {
        simd_shuffle!(
            a,
            a,
            [
                N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32,
                N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32
            ]
        )
    }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_lane_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.8", N = 4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 4)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdupq_lane_s8<const N: i32>(a: int8x8_t) -> int8x16_t {
    static_assert_uimm_bits!(N, 3);
    unsafe {
        simd_shuffle!(
            a,
            a,
            [
                N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32,
                N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32
            ]
        )
    }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_lane_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.8", N = 4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 4)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdupq_lane_u8<const N: i32>(a: uint8x8_t) -> uint8x16_t {
    static_assert_uimm_bits!(N, 3);
    unsafe {
        simd_shuffle!(
            a,
            a,
            [
                N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32,
                N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32
            ]
        )
    }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_lane_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop, N = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop, N = 0)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdup_lane_s64<const N: i32>(a: int64x1_t) -> int64x1_t {
    static_assert!(N == 0);
    a
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_lane_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop, N = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop, N = 0)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdup_lane_u64<const N: i32>(a: uint64x1_t) -> uint64x1_t {
    static_assert!(N == 0);
    a
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_laneq_f16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.16", N = 4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 4)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vdup_laneq_f16<const N: i32>(a: float16x8_t) -> float16x4_t {
    static_assert_uimm_bits!(N, 3);
    unsafe { simd_shuffle!(a, a, [N as u32, N as u32, N as u32, N as u32]) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_laneq_f16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.16", N = 4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 4)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vdupq_laneq_f16<const N: i32>(a: float16x8_t) -> float16x8_t {
    static_assert_uimm_bits!(N, 3);
    unsafe {
        simd_shuffle!(
            a,
            a,
            [N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32]
        )
    }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_laneq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.32", N = 2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 2)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdup_laneq_f32<const N: i32>(a: float32x4_t) -> float32x2_t {
    static_assert_uimm_bits!(N, 2);
    unsafe { simd_shuffle!(a, a, [N as u32, N as u32]) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_laneq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.32", N = 2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 2)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdup_laneq_s32<const N: i32>(a: int32x4_t) -> int32x2_t {
    static_assert_uimm_bits!(N, 2);
    unsafe { simd_shuffle!(a, a, [N as u32, N as u32]) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_laneq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.32", N = 2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 2)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdup_laneq_u32<const N: i32>(a: uint32x4_t) -> uint32x2_t {
    static_assert_uimm_bits!(N, 2);
    unsafe { simd_shuffle!(a, a, [N as u32, N as u32]) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_laneq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.32", N = 2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 2)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdupq_laneq_f32<const N: i32>(a: float32x4_t) -> float32x4_t {
    static_assert_uimm_bits!(N, 2);
    unsafe { simd_shuffle!(a, a, [N as u32, N as u32, N as u32, N as u32]) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_laneq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.32", N = 2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 2)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdupq_laneq_s32<const N: i32>(a: int32x4_t) -> int32x4_t {
    static_assert_uimm_bits!(N, 2);
    unsafe { simd_shuffle!(a, a, [N as u32, N as u32, N as u32, N as u32]) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_laneq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.32", N = 2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 2)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdupq_laneq_u32<const N: i32>(a: uint32x4_t) -> uint32x4_t {
    static_assert_uimm_bits!(N, 2);
    unsafe { simd_shuffle!(a, a, [N as u32, N as u32, N as u32, N as u32]) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_laneq_p16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.16", N = 4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 4)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdup_laneq_p16<const N: i32>(a: poly16x8_t) -> poly16x4_t {
    static_assert_uimm_bits!(N, 3);
    unsafe { simd_shuffle!(a, a, [N as u32, N as u32, N as u32, N as u32]) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_laneq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.16", N = 4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 4)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdup_laneq_s16<const N: i32>(a: int16x8_t) -> int16x4_t {
    static_assert_uimm_bits!(N, 3);
    unsafe { simd_shuffle!(a, a, [N as u32, N as u32, N as u32, N as u32]) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_laneq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.16", N = 4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 4)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdup_laneq_u16<const N: i32>(a: uint16x8_t) -> uint16x4_t {
    static_assert_uimm_bits!(N, 3);
    unsafe { simd_shuffle!(a, a, [N as u32, N as u32, N as u32, N as u32]) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_laneq_p16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.16", N = 4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 4)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdupq_laneq_p16<const N: i32>(a: poly16x8_t) -> poly16x8_t {
    static_assert_uimm_bits!(N, 3);
    unsafe {
        simd_shuffle!(
            a,
            a,
            [N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32]
        )
    }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_laneq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.16", N = 4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 4)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdupq_laneq_s16<const N: i32>(a: int16x8_t) -> int16x8_t {
    static_assert_uimm_bits!(N, 3);
    unsafe {
        simd_shuffle!(
            a,
            a,
            [N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32]
        )
    }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_laneq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.16", N = 4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 4)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdupq_laneq_u16<const N: i32>(a: uint16x8_t) -> uint16x8_t {
    static_assert_uimm_bits!(N, 3);
    unsafe {
        simd_shuffle!(
            a,
            a,
            [N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32]
        )
    }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_laneq_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.8", N = 8))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 8)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdup_laneq_p8<const N: i32>(a: poly8x16_t) -> poly8x8_t {
    static_assert_uimm_bits!(N, 4);
    unsafe {
        simd_shuffle!(
            a,
            a,
            [N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32]
        )
    }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_laneq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.8", N = 8))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 8)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdup_laneq_s8<const N: i32>(a: int8x16_t) -> int8x8_t {
    static_assert_uimm_bits!(N, 4);
    unsafe {
        simd_shuffle!(
            a,
            a,
            [N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32]
        )
    }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_laneq_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.8", N = 8))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 8)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdup_laneq_u8<const N: i32>(a: uint8x16_t) -> uint8x8_t {
    static_assert_uimm_bits!(N, 4);
    unsafe {
        simd_shuffle!(
            a,
            a,
            [N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32]
        )
    }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_laneq_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.8", N = 8))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 8)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdupq_laneq_p8<const N: i32>(a: poly8x16_t) -> poly8x16_t {
    static_assert_uimm_bits!(N, 4);
    unsafe {
        simd_shuffle!(
            a,
            a,
            [
                N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32,
                N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32
            ]
        )
    }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_laneq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.8", N = 8))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 8)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdupq_laneq_s8<const N: i32>(a: int8x16_t) -> int8x16_t {
    static_assert_uimm_bits!(N, 4);
    unsafe {
        simd_shuffle!(
            a,
            a,
            [
                N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32,
                N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32
            ]
        )
    }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_laneq_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.8", N = 8))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 8)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdupq_laneq_u8<const N: i32>(a: uint8x16_t) -> uint8x16_t {
    static_assert_uimm_bits!(N, 4);
    unsafe {
        simd_shuffle!(
            a,
            a,
            [
                N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32,
                N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32, N as u32
            ]
        )
    }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_laneq_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vmov, N = 1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop, N = 1)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdup_laneq_s64<const N: i32>(a: int64x2_t) -> int64x1_t {
    static_assert_uimm_bits!(N, 1);
    unsafe { transmute::<i64, _>(simd_extract!(a, N as u32)) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_laneq_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vmov, N = 1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop, N = 1)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdup_laneq_u64<const N: i32>(a: uint64x2_t) -> uint64x1_t {
    static_assert_uimm_bits!(N, 1);
    unsafe { transmute::<u64, _>(simd_extract!(a, N as u32)) }
}
#[doc = "Create a new vector with all lanes set to a value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_n_f16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup)
)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vdup_n_f16(a: f16) -> float16x4_t {
    float16x4_t::splat(a)
}
#[doc = "Create a new vector with all lanes set to a value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_n_f16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup)
)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vdupq_n_f16(a: f16) -> float16x8_t {
    float16x8_t::splat(a)
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_n_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdup_n_f32(value: f32) -> float32x2_t {
    float32x2_t::splat(value)
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_n_p16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdup_n_p16(value: p16) -> poly16x4_t {
    poly16x4_t::splat(value)
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_n_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdup_n_p8(value: p8) -> poly8x8_t {
    poly8x8_t::splat(value)
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_n_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdup_n_s16(value: i16) -> int16x4_t {
    int16x4_t::splat(value)
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_n_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdup_n_s32(value: i32) -> int32x2_t {
    int32x2_t::splat(value)
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_n_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vmov"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fmov)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdup_n_s64(value: i64) -> int64x1_t {
    int64x1_t::splat(value)
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_n_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdup_n_s8(value: i8) -> int8x8_t {
    int8x8_t::splat(value)
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_n_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdup_n_u16(value: u16) -> uint16x4_t {
    uint16x4_t::splat(value)
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_n_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdup_n_u32(value: u32) -> uint32x2_t {
    uint32x2_t::splat(value)
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_n_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vmov"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fmov)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdup_n_u64(value: u64) -> uint64x1_t {
    uint64x1_t::splat(value)
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_n_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdup_n_u8(value: u8) -> uint8x8_t {
    uint8x8_t::splat(value)
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_n_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdupq_n_f32(value: f32) -> float32x4_t {
    float32x4_t::splat(value)
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_n_p16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdupq_n_p16(value: p16) -> poly16x8_t {
    poly16x8_t::splat(value)
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_n_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdupq_n_p8(value: p8) -> poly8x16_t {
    poly8x16_t::splat(value)
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_n_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdupq_n_s16(value: i16) -> int16x8_t {
    int16x8_t::splat(value)
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_n_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdupq_n_s32(value: i32) -> int32x4_t {
    int32x4_t::splat(value)
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_n_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vmov"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdupq_n_s64(value: i64) -> int64x2_t {
    int64x2_t::splat(value)
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_n_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdupq_n_s8(value: i8) -> int8x16_t {
    int8x16_t::splat(value)
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_n_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdupq_n_u16(value: u16) -> uint16x8_t {
    uint16x8_t::splat(value)
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_n_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdupq_n_u32(value: u32) -> uint32x4_t {
    uint32x4_t::splat(value)
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_n_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vmov"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdupq_n_u64(value: u64) -> uint64x2_t {
    uint64x2_t::splat(value)
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_n_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdupq_n_u8(value: u8) -> uint8x16_t {
    uint8x16_t::splat(value)
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdup_n_f32_vfp4)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "vfp4"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
fn vdup_n_f32_vfp4(value: f32) -> float32x2_t {
    float32x2_t::splat(value)
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_n_f32_vfp4)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "vfp4"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vdup.32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
fn vdupq_n_f32_vfp4(value: f32) -> float32x4_t {
    float32x4_t::splat(value)
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_lane_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vmov, N = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 0)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdupq_lane_s64<const N: i32>(a: int64x1_t) -> int64x2_t {
    static_assert!(N == 0);
    unsafe { simd_shuffle!(a, a, [N as u32, N as u32]) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_lane_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vmov, N = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 0)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdupq_lane_u64<const N: i32>(a: uint64x1_t) -> uint64x2_t {
    static_assert!(N == 0);
    unsafe { simd_shuffle!(a, a, [N as u32, N as u32]) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_laneq_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vmov, N = 1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 1)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdupq_laneq_s64<const N: i32>(a: int64x2_t) -> int64x2_t {
    static_assert_uimm_bits!(N, 1);
    unsafe { simd_shuffle!(a, a, [N as u32, N as u32]) }
}
#[doc = "Set all vector lanes to the same value"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vdupq_laneq_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vmov, N = 1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(dup, N = 1)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vdupq_laneq_u64<const N: i32>(a: uint64x2_t) -> uint64x2_t {
    static_assert_uimm_bits!(N, 1);
    unsafe { simd_shuffle!(a, a, [N as u32, N as u32]) }
}
#[doc = "Vector bitwise exclusive or (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/veor_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(veor))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(eor)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn veor_s8(a: int8x8_t, b: int8x8_t) -> int8x8_t {
    unsafe { simd_xor(a, b) }
}
#[doc = "Vector bitwise exclusive or (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/veorq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(veor))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(eor)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn veorq_s8(a: int8x16_t, b: int8x16_t) -> int8x16_t {
    unsafe { simd_xor(a, b) }
}
#[doc = "Vector bitwise exclusive or (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/veor_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(veor))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(eor)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn veor_s16(a: int16x4_t, b: int16x4_t) -> int16x4_t {
    unsafe { simd_xor(a, b) }
}
#[doc = "Vector bitwise exclusive or (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/veorq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(veor))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(eor)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn veorq_s16(a: int16x8_t, b: int16x8_t) -> int16x8_t {
    unsafe { simd_xor(a, b) }
}
#[doc = "Vector bitwise exclusive or (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/veor_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(veor))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(eor)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn veor_s32(a: int32x2_t, b: int32x2_t) -> int32x2_t {
    unsafe { simd_xor(a, b) }
}
#[doc = "Vector bitwise exclusive or (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/veorq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(veor))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(eor)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn veorq_s32(a: int32x4_t, b: int32x4_t) -> int32x4_t {
    unsafe { simd_xor(a, b) }
}
#[doc = "Vector bitwise exclusive or (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/veor_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(veor))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(eor)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn veor_s64(a: int64x1_t, b: int64x1_t) -> int64x1_t {
    unsafe { simd_xor(a, b) }
}
#[doc = "Vector bitwise exclusive or (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/veorq_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(veor))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(eor)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn veorq_s64(a: int64x2_t, b: int64x2_t) -> int64x2_t {
    unsafe { simd_xor(a, b) }
}
#[doc = "Vector bitwise exclusive or (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/veor_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(veor))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(eor)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn veor_u8(a: uint8x8_t, b: uint8x8_t) -> uint8x8_t {
    unsafe { simd_xor(a, b) }
}
#[doc = "Vector bitwise exclusive or (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/veorq_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(veor))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(eor)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn veorq_u8(a: uint8x16_t, b: uint8x16_t) -> uint8x16_t {
    unsafe { simd_xor(a, b) }
}
#[doc = "Vector bitwise exclusive or (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/veor_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(veor))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(eor)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn veor_u16(a: uint16x4_t, b: uint16x4_t) -> uint16x4_t {
    unsafe { simd_xor(a, b) }
}
#[doc = "Vector bitwise exclusive or (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/veorq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(veor))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(eor)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn veorq_u16(a: uint16x8_t, b: uint16x8_t) -> uint16x8_t {
    unsafe { simd_xor(a, b) }
}
#[doc = "Vector bitwise exclusive or (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/veor_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(veor))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(eor)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn veor_u32(a: uint32x2_t, b: uint32x2_t) -> uint32x2_t {
    unsafe { simd_xor(a, b) }
}
#[doc = "Vector bitwise exclusive or (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/veorq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(veor))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(eor)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn veorq_u32(a: uint32x4_t, b: uint32x4_t) -> uint32x4_t {
    unsafe { simd_xor(a, b) }
}
#[doc = "Vector bitwise exclusive or (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/veor_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(veor))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(eor)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn veor_u64(a: uint64x1_t, b: uint64x1_t) -> uint64x1_t {
    unsafe { simd_xor(a, b) }
}
#[doc = "Vector bitwise exclusive or (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/veorq_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(veor))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(eor)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn veorq_u64(a: uint64x2_t, b: uint64x2_t) -> uint64x2_t {
    unsafe { simd_xor(a, b) }
}
#[doc = "Extract vector from pair of vectors"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vext_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vext.8", N = 3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ext, N = 3)
)]
#[rustc_legacy_const_generics(2)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vext_f16<const N: i32>(a: float16x4_t, b: float16x4_t) -> float16x4_t {
    static_assert_uimm_bits!(N, 2);
    unsafe {
        match N & 0b11 {
            0 => simd_shuffle!(a, b, [0, 1, 2, 3]),
            1 => simd_shuffle!(a, b, [1, 2, 3, 4]),
            2 => simd_shuffle!(a, b, [2, 3, 4, 5]),
            3 => simd_shuffle!(a, b, [3, 4, 5, 6]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Extract vector from pair of vectors"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vext_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vext.8", N = 1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ext, N = 1)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vext_f32<const N: i32>(a: float32x2_t, b: float32x2_t) -> float32x2_t {
    static_assert_uimm_bits!(N, 1);
    unsafe {
        match N & 0b1 {
            0 => simd_shuffle!(a, b, [0, 1]),
            1 => simd_shuffle!(a, b, [1, 2]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Extract vector from pair of vectors"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vext_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vext.8", N = 1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ext, N = 1)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vext_s32<const N: i32>(a: int32x2_t, b: int32x2_t) -> int32x2_t {
    static_assert_uimm_bits!(N, 1);
    unsafe {
        match N & 0b1 {
            0 => simd_shuffle!(a, b, [0, 1]),
            1 => simd_shuffle!(a, b, [1, 2]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Extract vector from pair of vectors"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vext_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vext.8", N = 1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ext, N = 1)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vext_u32<const N: i32>(a: uint32x2_t, b: uint32x2_t) -> uint32x2_t {
    static_assert_uimm_bits!(N, 1);
    unsafe {
        match N & 0b1 {
            0 => simd_shuffle!(a, b, [0, 1]),
            1 => simd_shuffle!(a, b, [1, 2]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Extract vector from pair of vectors"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vext_s64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop, N = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop, N = 0)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vext_s64<const N: i32>(a: int64x1_t, _b: int64x1_t) -> int64x1_t {
    static_assert!(N == 0);
    a
}
#[doc = "Extract vector from pair of vectors"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vext_u64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop, N = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop, N = 0)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vext_u64<const N: i32>(a: uint64x1_t, _b: uint64x1_t) -> uint64x1_t {
    static_assert!(N == 0);
    a
}
#[doc = "Extract vector from pair of vectors"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vext_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vext.8", N = 7))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ext, N = 7)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vext_s8<const N: i32>(a: int8x8_t, b: int8x8_t) -> int8x8_t {
    static_assert_uimm_bits!(N, 3);
    unsafe {
        match N & 0b111 {
            0 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 6, 7]),
            1 => simd_shuffle!(a, b, [1, 2, 3, 4, 5, 6, 7, 8]),
            2 => simd_shuffle!(a, b, [2, 3, 4, 5, 6, 7, 8, 9]),
            3 => simd_shuffle!(a, b, [3, 4, 5, 6, 7, 8, 9, 10]),
            4 => simd_shuffle!(a, b, [4, 5, 6, 7, 8, 9, 10, 11]),
            5 => simd_shuffle!(a, b, [5, 6, 7, 8, 9, 10, 11, 12]),
            6 => simd_shuffle!(a, b, [6, 7, 8, 9, 10, 11, 12, 13]),
            7 => simd_shuffle!(a, b, [7, 8, 9, 10, 11, 12, 13, 14]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Extract vector from pair of vectors"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vextq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vext.8", N = 7))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ext, N = 7)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vextq_s16<const N: i32>(a: int16x8_t, b: int16x8_t) -> int16x8_t {
    static_assert_uimm_bits!(N, 3);
    unsafe {
        match N & 0b111 {
            0 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 6, 7]),
            1 => simd_shuffle!(a, b, [1, 2, 3, 4, 5, 6, 7, 8]),
            2 => simd_shuffle!(a, b, [2, 3, 4, 5, 6, 7, 8, 9]),
            3 => simd_shuffle!(a, b, [3, 4, 5, 6, 7, 8, 9, 10]),
            4 => simd_shuffle!(a, b, [4, 5, 6, 7, 8, 9, 10, 11]),
            5 => simd_shuffle!(a, b, [5, 6, 7, 8, 9, 10, 11, 12]),
            6 => simd_shuffle!(a, b, [6, 7, 8, 9, 10, 11, 12, 13]),
            7 => simd_shuffle!(a, b, [7, 8, 9, 10, 11, 12, 13, 14]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Extract vector from pair of vectors"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vext_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vext.8", N = 7))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ext, N = 7)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vext_u8<const N: i32>(a: uint8x8_t, b: uint8x8_t) -> uint8x8_t {
    static_assert_uimm_bits!(N, 3);
    unsafe {
        match N & 0b111 {
            0 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 6, 7]),
            1 => simd_shuffle!(a, b, [1, 2, 3, 4, 5, 6, 7, 8]),
            2 => simd_shuffle!(a, b, [2, 3, 4, 5, 6, 7, 8, 9]),
            3 => simd_shuffle!(a, b, [3, 4, 5, 6, 7, 8, 9, 10]),
            4 => simd_shuffle!(a, b, [4, 5, 6, 7, 8, 9, 10, 11]),
            5 => simd_shuffle!(a, b, [5, 6, 7, 8, 9, 10, 11, 12]),
            6 => simd_shuffle!(a, b, [6, 7, 8, 9, 10, 11, 12, 13]),
            7 => simd_shuffle!(a, b, [7, 8, 9, 10, 11, 12, 13, 14]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Extract vector from pair of vectors"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vextq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vext.8", N = 7))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ext, N = 7)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vextq_u16<const N: i32>(a: uint16x8_t, b: uint16x8_t) -> uint16x8_t {
    static_assert_uimm_bits!(N, 3);
    unsafe {
        match N & 0b111 {
            0 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 6, 7]),
            1 => simd_shuffle!(a, b, [1, 2, 3, 4, 5, 6, 7, 8]),
            2 => simd_shuffle!(a, b, [2, 3, 4, 5, 6, 7, 8, 9]),
            3 => simd_shuffle!(a, b, [3, 4, 5, 6, 7, 8, 9, 10]),
            4 => simd_shuffle!(a, b, [4, 5, 6, 7, 8, 9, 10, 11]),
            5 => simd_shuffle!(a, b, [5, 6, 7, 8, 9, 10, 11, 12]),
            6 => simd_shuffle!(a, b, [6, 7, 8, 9, 10, 11, 12, 13]),
            7 => simd_shuffle!(a, b, [7, 8, 9, 10, 11, 12, 13, 14]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Extract vector from pair of vectors"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vext_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vext.8", N = 7))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ext, N = 7)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vext_p8<const N: i32>(a: poly8x8_t, b: poly8x8_t) -> poly8x8_t {
    static_assert_uimm_bits!(N, 3);
    unsafe {
        match N & 0b111 {
            0 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 6, 7]),
            1 => simd_shuffle!(a, b, [1, 2, 3, 4, 5, 6, 7, 8]),
            2 => simd_shuffle!(a, b, [2, 3, 4, 5, 6, 7, 8, 9]),
            3 => simd_shuffle!(a, b, [3, 4, 5, 6, 7, 8, 9, 10]),
            4 => simd_shuffle!(a, b, [4, 5, 6, 7, 8, 9, 10, 11]),
            5 => simd_shuffle!(a, b, [5, 6, 7, 8, 9, 10, 11, 12]),
            6 => simd_shuffle!(a, b, [6, 7, 8, 9, 10, 11, 12, 13]),
            7 => simd_shuffle!(a, b, [7, 8, 9, 10, 11, 12, 13, 14]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Extract vector from pair of vectors"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vextq_p16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vext.8", N = 7))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ext, N = 7)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vextq_p16<const N: i32>(a: poly16x8_t, b: poly16x8_t) -> poly16x8_t {
    static_assert_uimm_bits!(N, 3);
    unsafe {
        match N & 0b111 {
            0 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 6, 7]),
            1 => simd_shuffle!(a, b, [1, 2, 3, 4, 5, 6, 7, 8]),
            2 => simd_shuffle!(a, b, [2, 3, 4, 5, 6, 7, 8, 9]),
            3 => simd_shuffle!(a, b, [3, 4, 5, 6, 7, 8, 9, 10]),
            4 => simd_shuffle!(a, b, [4, 5, 6, 7, 8, 9, 10, 11]),
            5 => simd_shuffle!(a, b, [5, 6, 7, 8, 9, 10, 11, 12]),
            6 => simd_shuffle!(a, b, [6, 7, 8, 9, 10, 11, 12, 13]),
            7 => simd_shuffle!(a, b, [7, 8, 9, 10, 11, 12, 13, 14]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Extract vector from pair of vectors"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vextq_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vext.8", N = 7))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ext, N = 7)
)]
#[rustc_legacy_const_generics(2)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vextq_f16<const N: i32>(a: float16x8_t, b: float16x8_t) -> float16x8_t {
    static_assert_uimm_bits!(N, 3);
    unsafe {
        match N & 0b111 {
            0 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 6, 7]),
            1 => simd_shuffle!(a, b, [1, 2, 3, 4, 5, 6, 7, 8]),
            2 => simd_shuffle!(a, b, [2, 3, 4, 5, 6, 7, 8, 9]),
            3 => simd_shuffle!(a, b, [3, 4, 5, 6, 7, 8, 9, 10]),
            4 => simd_shuffle!(a, b, [4, 5, 6, 7, 8, 9, 10, 11]),
            5 => simd_shuffle!(a, b, [5, 6, 7, 8, 9, 10, 11, 12]),
            6 => simd_shuffle!(a, b, [6, 7, 8, 9, 10, 11, 12, 13]),
            7 => simd_shuffle!(a, b, [7, 8, 9, 10, 11, 12, 13, 14]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Extract vector from pair of vectors"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vextq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vext.8", N = 3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ext, N = 3)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vextq_f32<const N: i32>(a: float32x4_t, b: float32x4_t) -> float32x4_t {
    static_assert_uimm_bits!(N, 2);
    unsafe {
        match N & 0b11 {
            0 => simd_shuffle!(a, b, [0, 1, 2, 3]),
            1 => simd_shuffle!(a, b, [1, 2, 3, 4]),
            2 => simd_shuffle!(a, b, [2, 3, 4, 5]),
            3 => simd_shuffle!(a, b, [3, 4, 5, 6]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Extract vector from pair of vectors"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vext_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vext.8", N = 3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ext, N = 3)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vext_s16<const N: i32>(a: int16x4_t, b: int16x4_t) -> int16x4_t {
    static_assert_uimm_bits!(N, 2);
    unsafe {
        match N & 0b11 {
            0 => simd_shuffle!(a, b, [0, 1, 2, 3]),
            1 => simd_shuffle!(a, b, [1, 2, 3, 4]),
            2 => simd_shuffle!(a, b, [2, 3, 4, 5]),
            3 => simd_shuffle!(a, b, [3, 4, 5, 6]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Extract vector from pair of vectors"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vextq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vext.8", N = 3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ext, N = 3)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vextq_s32<const N: i32>(a: int32x4_t, b: int32x4_t) -> int32x4_t {
    static_assert_uimm_bits!(N, 2);
    unsafe {
        match N & 0b11 {
            0 => simd_shuffle!(a, b, [0, 1, 2, 3]),
            1 => simd_shuffle!(a, b, [1, 2, 3, 4]),
            2 => simd_shuffle!(a, b, [2, 3, 4, 5]),
            3 => simd_shuffle!(a, b, [3, 4, 5, 6]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Extract vector from pair of vectors"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vext_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vext.8", N = 3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ext, N = 3)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vext_u16<const N: i32>(a: uint16x4_t, b: uint16x4_t) -> uint16x4_t {
    static_assert_uimm_bits!(N, 2);
    unsafe {
        match N & 0b11 {
            0 => simd_shuffle!(a, b, [0, 1, 2, 3]),
            1 => simd_shuffle!(a, b, [1, 2, 3, 4]),
            2 => simd_shuffle!(a, b, [2, 3, 4, 5]),
            3 => simd_shuffle!(a, b, [3, 4, 5, 6]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Extract vector from pair of vectors"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vextq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vext.8", N = 3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ext, N = 3)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vextq_u32<const N: i32>(a: uint32x4_t, b: uint32x4_t) -> uint32x4_t {
    static_assert_uimm_bits!(N, 2);
    unsafe {
        match N & 0b11 {
            0 => simd_shuffle!(a, b, [0, 1, 2, 3]),
            1 => simd_shuffle!(a, b, [1, 2, 3, 4]),
            2 => simd_shuffle!(a, b, [2, 3, 4, 5]),
            3 => simd_shuffle!(a, b, [3, 4, 5, 6]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Extract vector from pair of vectors"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vext_p16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vext.8", N = 3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ext, N = 3)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vext_p16<const N: i32>(a: poly16x4_t, b: poly16x4_t) -> poly16x4_t {
    static_assert_uimm_bits!(N, 2);
    unsafe {
        match N & 0b11 {
            0 => simd_shuffle!(a, b, [0, 1, 2, 3]),
            1 => simd_shuffle!(a, b, [1, 2, 3, 4]),
            2 => simd_shuffle!(a, b, [2, 3, 4, 5]),
            3 => simd_shuffle!(a, b, [3, 4, 5, 6]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Extract vector from pair of vectors"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vextq_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vmov, N = 1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ext, N = 1)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vextq_s64<const N: i32>(a: int64x2_t, b: int64x2_t) -> int64x2_t {
    static_assert_uimm_bits!(N, 1);
    unsafe {
        match N & 0b1 {
            0 => simd_shuffle!(a, b, [0, 1]),
            1 => simd_shuffle!(a, b, [1, 2]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Extract vector from pair of vectors"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vextq_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vmov, N = 1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ext, N = 1)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vextq_u64<const N: i32>(a: uint64x2_t, b: uint64x2_t) -> uint64x2_t {
    static_assert_uimm_bits!(N, 1);
    unsafe {
        match N & 0b1 {
            0 => simd_shuffle!(a, b, [0, 1]),
            1 => simd_shuffle!(a, b, [1, 2]),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Extract vector from pair of vectors"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vextq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vext.8", N = 15))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ext, N = 15)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vextq_s8<const N: i32>(a: int8x16_t, b: int8x16_t) -> int8x16_t {
    static_assert_uimm_bits!(N, 4);
    unsafe {
        match N & 0b1111 {
            0 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]),
            1 => simd_shuffle!(
                a,
                b,
                [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16]
            ),
            2 => simd_shuffle!(
                a,
                b,
                [2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17]
            ),
            3 => simd_shuffle!(
                a,
                b,
                [3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18]
            ),
            4 => simd_shuffle!(
                a,
                b,
                [4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19]
            ),
            5 => simd_shuffle!(
                a,
                b,
                [5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20]
            ),
            6 => simd_shuffle!(
                a,
                b,
                [6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21]
            ),
            7 => simd_shuffle!(
                a,
                b,
                [7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22]
            ),
            8 => simd_shuffle!(
                a,
                b,
                [8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23]
            ),
            9 => simd_shuffle!(
                a,
                b,
                [9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24]
            ),
            10 => simd_shuffle!(
                a,
                b,
                [10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25]
            ),
            11 => simd_shuffle!(
                a,
                b,
                [11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26]
            ),
            12 => simd_shuffle!(
                a,
                b,
                [12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27]
            ),
            13 => simd_shuffle!(
                a,
                b,
                [13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28]
            ),
            14 => simd_shuffle!(
                a,
                b,
                [14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29]
            ),
            15 => simd_shuffle!(
                a,
                b,
                [15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30]
            ),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Extract vector from pair of vectors"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vextq_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vext.8", N = 15))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ext, N = 15)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vextq_u8<const N: i32>(a: uint8x16_t, b: uint8x16_t) -> uint8x16_t {
    static_assert_uimm_bits!(N, 4);
    unsafe {
        match N & 0b1111 {
            0 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]),
            1 => simd_shuffle!(
                a,
                b,
                [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16]
            ),
            2 => simd_shuffle!(
                a,
                b,
                [2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17]
            ),
            3 => simd_shuffle!(
                a,
                b,
                [3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18]
            ),
            4 => simd_shuffle!(
                a,
                b,
                [4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19]
            ),
            5 => simd_shuffle!(
                a,
                b,
                [5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20]
            ),
            6 => simd_shuffle!(
                a,
                b,
                [6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21]
            ),
            7 => simd_shuffle!(
                a,
                b,
                [7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22]
            ),
            8 => simd_shuffle!(
                a,
                b,
                [8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23]
            ),
            9 => simd_shuffle!(
                a,
                b,
                [9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24]
            ),
            10 => simd_shuffle!(
                a,
                b,
                [10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25]
            ),
            11 => simd_shuffle!(
                a,
                b,
                [11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26]
            ),
            12 => simd_shuffle!(
                a,
                b,
                [12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27]
            ),
            13 => simd_shuffle!(
                a,
                b,
                [13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28]
            ),
            14 => simd_shuffle!(
                a,
                b,
                [14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29]
            ),
            15 => simd_shuffle!(
                a,
                b,
                [15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30]
            ),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Extract vector from pair of vectors"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vextq_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vext.8", N = 15))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ext, N = 15)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vextq_p8<const N: i32>(a: poly8x16_t, b: poly8x16_t) -> poly8x16_t {
    static_assert_uimm_bits!(N, 4);
    unsafe {
        match N & 0b1111 {
            0 => simd_shuffle!(a, b, [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]),
            1 => simd_shuffle!(
                a,
                b,
                [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16]
            ),
            2 => simd_shuffle!(
                a,
                b,
                [2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17]
            ),
            3 => simd_shuffle!(
                a,
                b,
                [3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18]
            ),
            4 => simd_shuffle!(
                a,
                b,
                [4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19]
            ),
            5 => simd_shuffle!(
                a,
                b,
                [5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20]
            ),
            6 => simd_shuffle!(
                a,
                b,
                [6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21]
            ),
            7 => simd_shuffle!(
                a,
                b,
                [7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22]
            ),
            8 => simd_shuffle!(
                a,
                b,
                [8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23]
            ),
            9 => simd_shuffle!(
                a,
                b,
                [9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24]
            ),
            10 => simd_shuffle!(
                a,
                b,
                [10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25]
            ),
            11 => simd_shuffle!(
                a,
                b,
                [11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26]
            ),
            12 => simd_shuffle!(
                a,
                b,
                [12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27]
            ),
            13 => simd_shuffle!(
                a,
                b,
                [13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28]
            ),
            14 => simd_shuffle!(
                a,
                b,
                [14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29]
            ),
            15 => simd_shuffle!(
                a,
                b,
                [15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30]
            ),
            _ => unreachable_unchecked(),
        }
    }
}
#[doc = "Floating-point fused Multiply-Add to accumulator (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfma_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "vfp4"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vfma))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fmla)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vfma_f16(a: float16x4_t, b: float16x4_t, c: float16x4_t) -> float16x4_t {
    unsafe { simd_fma(b, c, a) }
}
#[doc = "Floating-point fused Multiply-Add to accumulator (vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmaq_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "vfp4"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vfma))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fmla)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vfmaq_f16(a: float16x8_t, b: float16x8_t, c: float16x8_t) -> float16x8_t {
    unsafe { simd_fma(b, c, a) }
}
#[doc = "Floating-point fused Multiply-Add to accumulator(vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfma_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "vfp4"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vfma))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fmla)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vfma_f32(a: float32x2_t, b: float32x2_t, c: float32x2_t) -> float32x2_t {
    unsafe { simd_fma(b, c, a) }
}
#[doc = "Floating-point fused Multiply-Add to accumulator(vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmaq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "vfp4"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vfma))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fmla)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vfmaq_f32(a: float32x4_t, b: float32x4_t, c: float32x4_t) -> float32x4_t {
    unsafe { simd_fma(b, c, a) }
}
#[doc = "Floating-point fused Multiply-Add to accumulator(vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfma_n_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "vfp4"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vfma))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fmla)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vfma_n_f32(a: float32x2_t, b: float32x2_t, c: f32) -> float32x2_t {
    vfma_f32(a, b, vdup_n_f32_vfp4(c))
}
#[doc = "Floating-point fused Multiply-Add to accumulator(vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmaq_n_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "vfp4"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vfma))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fmla)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vfmaq_n_f32(a: float32x4_t, b: float32x4_t, c: f32) -> float32x4_t {
    vfmaq_f32(a, b, vdupq_n_f32_vfp4(c))
}
#[doc = "Floating-point fused multiply-subtract from accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfms_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(target_arch = "arm", target_feature(enable = "vfp4"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fmls)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vfms_f16(a: float16x4_t, b: float16x4_t, c: float16x4_t) -> float16x4_t {
    unsafe {
        let b: float16x4_t = simd_neg(b);
        vfma_f16(a, b, c)
    }
}
#[doc = "Floating-point fused multiply-subtract from accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmsq_f16)"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(target_arch = "arm", target_feature(enable = "vfp4"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fmls)
)]
#[target_feature(enable = "neon,fp16")]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vfmsq_f16(a: float16x8_t, b: float16x8_t, c: float16x8_t) -> float16x8_t {
    unsafe {
        let b: float16x8_t = simd_neg(b);
        vfmaq_f16(a, b, c)
    }
}
#[doc = "Floating-point fused multiply-subtract from accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfms_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "vfp4"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vfms))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fmls)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vfms_f32(a: float32x2_t, b: float32x2_t, c: float32x2_t) -> float32x2_t {
    unsafe {
        let b: float32x2_t = simd_neg(b);
        vfma_f32(a, b, c)
    }
}
#[doc = "Floating-point fused multiply-subtract from accumulator"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmsq_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "vfp4"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vfms))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fmls)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vfmsq_f32(a: float32x4_t, b: float32x4_t, c: float32x4_t) -> float32x4_t {
    unsafe {
        let b: float32x4_t = simd_neg(b);
        vfmaq_f32(a, b, c)
    }
}
#[doc = "Floating-point fused Multiply-subtract to accumulator(vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfms_n_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "vfp4"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vfms))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fmls)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vfms_n_f32(a: float32x2_t, b: float32x2_t, c: f32) -> float32x2_t {
    vfms_f32(a, b, vdup_n_f32_vfp4(c))
}
#[doc = "Floating-point fused Multiply-subtract to accumulator(vector)"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vfmsq_n_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "vfp4"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vfms))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(fmls)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vfmsq_n_f32(a: float32x4_t, b: float32x4_t, c: f32) -> float32x4_t {
    vfmsq_f32(a, b, vdupq_n_f32_vfp4(c))
}
#[doc = "Duplicate vector element to vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_high_f16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
#[cfg_attr(test, assert_instr(nop))]
pub fn vget_high_f16(a: float16x8_t) -> float16x4_t {
    unsafe { simd_shuffle!(a, a, [4, 5, 6, 7]) }
}
#[doc = "Duplicate vector element to vector"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_low_f16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "stdarch_neon_fp16", since = "CURRENT_RUSTC_VERSION")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
#[cfg(not(target_arch = "arm64ec"))]
#[cfg_attr(test, assert_instr(nop))]
pub fn vget_low_f16(a: float16x8_t) -> float16x4_t {
    unsafe { simd_shuffle!(a, a, [0, 1, 2, 3]) }
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_high_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vmov"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ext)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_high_f32(a: float32x4_t) -> float32x2_t {
    unsafe { simd_shuffle!(a, a, [2, 3]) }
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_high_p16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vmov"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ext)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_high_p16(a: poly16x8_t) -> poly16x4_t {
    unsafe { simd_shuffle!(a, a, [4, 5, 6, 7]) }
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_high_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vmov"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ext)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_high_p8(a: poly8x16_t) -> poly8x8_t {
    unsafe { simd_shuffle!(a, a, [8, 9, 10, 11, 12, 13, 14, 15]) }
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_high_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vmov"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ext)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_high_s16(a: int16x8_t) -> int16x4_t {
    unsafe { simd_shuffle!(a, a, [4, 5, 6, 7]) }
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_high_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vmov"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ext)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_high_s32(a: int32x4_t) -> int32x2_t {
    unsafe { simd_shuffle!(a, a, [2, 3]) }
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_high_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vmov"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ext)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_high_s8(a: int8x16_t) -> int8x8_t {
    unsafe { simd_shuffle!(a, a, [8, 9, 10, 11, 12, 13, 14, 15]) }
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_high_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vmov"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ext)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_high_u16(a: uint16x8_t) -> uint16x4_t {
    unsafe { simd_shuffle!(a, a, [4, 5, 6, 7]) }
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_high_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vmov"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ext)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_high_u32(a: uint32x4_t) -> uint32x2_t {
    unsafe { simd_shuffle!(a, a, [2, 3]) }
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_high_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vmov"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ext)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_high_u8(a: uint8x16_t) -> uint8x8_t {
    unsafe { simd_shuffle!(a, a, [8, 9, 10, 11, 12, 13, 14, 15]) }
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_high_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vmov"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ext)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_high_s64(a: int64x2_t) -> int64x1_t {
    unsafe { int64x1_t([simd_extract!(a, 1)]) }
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_high_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vmov"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ext)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_high_u64(a: uint64x2_t) -> uint64x1_t {
    unsafe { uint64x1_t([simd_extract!(a, 1)]) }
}
#[doc = "Duplicate vector element to scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_lane_f16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop, LANE = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop, LANE = 0)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vget_lane_f16<const LANE: i32>(a: float16x4_t) -> f16 {
    static_assert_uimm_bits!(LANE, 2);
    unsafe { simd_extract!(a, LANE as u32) }
}
#[doc = "Duplicate vector element to scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vgetq_lane_f16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop, LANE = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop, LANE = 0)
)]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub fn vgetq_lane_f16<const LANE: i32>(a: float16x8_t) -> f16 {
    static_assert_uimm_bits!(LANE, 3);
    unsafe { simd_extract!(a, LANE as u32) }
}
#[doc = "Move vector element to general-purpose register"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_lane_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(test, assert_instr(nop, IMM5 = 1))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_lane_f32<const IMM5: i32>(v: float32x2_t) -> f32 {
    static_assert_uimm_bits!(IMM5, 1);
    unsafe { simd_extract!(v, IMM5 as u32) }
}
#[doc = "Move vector element to general-purpose register"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_lane_p16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(test, assert_instr(nop, IMM5 = 2))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_lane_p16<const IMM5: i32>(v: poly16x4_t) -> p16 {
    static_assert_uimm_bits!(IMM5, 2);
    unsafe { simd_extract!(v, IMM5 as u32) }
}
#[doc = "Move vector element to general-purpose register"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_lane_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(test, assert_instr(nop, IMM5 = 2))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_lane_p8<const IMM5: i32>(v: poly8x8_t) -> p8 {
    static_assert_uimm_bits!(IMM5, 3);
    unsafe { simd_extract!(v, IMM5 as u32) }
}
#[doc = "Move vector element to general-purpose register"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_lane_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(test, assert_instr(nop, IMM5 = 2))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_lane_s16<const IMM5: i32>(v: int16x4_t) -> i16 {
    static_assert_uimm_bits!(IMM5, 2);
    unsafe { simd_extract!(v, IMM5 as u32) }
}
#[doc = "Move vector element to general-purpose register"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_lane_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(test, assert_instr(nop, IMM5 = 1))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_lane_s32<const IMM5: i32>(v: int32x2_t) -> i32 {
    static_assert_uimm_bits!(IMM5, 1);
    unsafe { simd_extract!(v, IMM5 as u32) }
}
#[doc = "Move vector element to general-purpose register"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_lane_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(test, assert_instr(nop, IMM5 = 2))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_lane_s8<const IMM5: i32>(v: int8x8_t) -> i8 {
    static_assert_uimm_bits!(IMM5, 3);
    unsafe { simd_extract!(v, IMM5 as u32) }
}
#[doc = "Move vector element to general-purpose register"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_lane_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(test, assert_instr(nop, IMM5 = 2))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_lane_u16<const IMM5: i32>(v: uint16x4_t) -> u16 {
    static_assert_uimm_bits!(IMM5, 2);
    unsafe { simd_extract!(v, IMM5 as u32) }
}
#[doc = "Move vector element to general-purpose register"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_lane_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(test, assert_instr(nop, IMM5 = 1))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_lane_u32<const IMM5: i32>(v: uint32x2_t) -> u32 {
    static_assert_uimm_bits!(IMM5, 1);
    unsafe { simd_extract!(v, IMM5 as u32) }
}
#[doc = "Move vector element to general-purpose register"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_lane_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(test, assert_instr(nop, IMM5 = 2))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_lane_u8<const IMM5: i32>(v: uint8x8_t) -> u8 {
    static_assert_uimm_bits!(IMM5, 3);
    unsafe { simd_extract!(v, IMM5 as u32) }
}
#[doc = "Move vector element to general-purpose register"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vgetq_lane_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(test, assert_instr(nop, IMM5 = 1))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vgetq_lane_f32<const IMM5: i32>(v: float32x4_t) -> f32 {
    static_assert_uimm_bits!(IMM5, 2);
    unsafe { simd_extract!(v, IMM5 as u32) }
}
#[doc = "Move vector element to general-purpose register"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vgetq_lane_p16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(test, assert_instr(nop, IMM5 = 2))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vgetq_lane_p16<const IMM5: i32>(v: poly16x8_t) -> p16 {
    static_assert_uimm_bits!(IMM5, 3);
    unsafe { simd_extract!(v, IMM5 as u32) }
}
#[doc = "Move vector element to general-purpose register"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vgetq_lane_p64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(test, assert_instr(nop, IMM5 = 1))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vgetq_lane_p64<const IMM5: i32>(v: poly64x2_t) -> p64 {
    static_assert_uimm_bits!(IMM5, 1);
    unsafe { simd_extract!(v, IMM5 as u32) }
}
#[doc = "Move vector element to general-purpose register"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vgetq_lane_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(test, assert_instr(nop, IMM5 = 2))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vgetq_lane_p8<const IMM5: i32>(v: poly8x16_t) -> p8 {
    static_assert_uimm_bits!(IMM5, 4);
    unsafe { simd_extract!(v, IMM5 as u32) }
}
#[doc = "Move vector element to general-purpose register"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vgetq_lane_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(test, assert_instr(nop, IMM5 = 2))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vgetq_lane_s16<const IMM5: i32>(v: int16x8_t) -> i16 {
    static_assert_uimm_bits!(IMM5, 3);
    unsafe { simd_extract!(v, IMM5 as u32) }
}
#[doc = "Move vector element to general-purpose register"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vgetq_lane_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(test, assert_instr(nop, IMM5 = 2))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vgetq_lane_s32<const IMM5: i32>(v: int32x4_t) -> i32 {
    static_assert_uimm_bits!(IMM5, 2);
    unsafe { simd_extract!(v, IMM5 as u32) }
}
#[doc = "Move vector element to general-purpose register"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vgetq_lane_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(test, assert_instr(nop, IMM5 = 1))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vgetq_lane_s64<const IMM5: i32>(v: int64x2_t) -> i64 {
    static_assert_uimm_bits!(IMM5, 1);
    unsafe { simd_extract!(v, IMM5 as u32) }
}
#[doc = "Move vector element to general-purpose register"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vgetq_lane_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(test, assert_instr(nop, IMM5 = 2))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vgetq_lane_s8<const IMM5: i32>(v: int8x16_t) -> i8 {
    static_assert_uimm_bits!(IMM5, 4);
    unsafe { simd_extract!(v, IMM5 as u32) }
}
#[doc = "Move vector element to general-purpose register"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vgetq_lane_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(test, assert_instr(nop, IMM5 = 2))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vgetq_lane_u16<const IMM5: i32>(v: uint16x8_t) -> u16 {
    static_assert_uimm_bits!(IMM5, 3);
    unsafe { simd_extract!(v, IMM5 as u32) }
}
#[doc = "Move vector element to general-purpose register"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vgetq_lane_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(test, assert_instr(nop, IMM5 = 2))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vgetq_lane_u32<const IMM5: i32>(v: uint32x4_t) -> u32 {
    static_assert_uimm_bits!(IMM5, 2);
    unsafe { simd_extract!(v, IMM5 as u32) }
}
#[doc = "Move vector element to general-purpose register"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vgetq_lane_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(test, assert_instr(nop, IMM5 = 1))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vgetq_lane_u64<const IMM5: i32>(v: uint64x2_t) -> u64 {
    static_assert_uimm_bits!(IMM5, 2);
    unsafe { simd_extract!(v, IMM5 as u32) }
}
#[doc = "Move vector element to general-purpose register"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vgetq_lane_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(test, assert_instr(nop, IMM5 = 2))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vgetq_lane_u8<const IMM5: i32>(v: uint8x16_t) -> u8 {
    static_assert_uimm_bits!(IMM5, 4);
    unsafe { simd_extract!(v, IMM5 as u32) }
}
#[doc = "Move vector element to general-purpose register"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_lane_p64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(test, assert_instr(nop, IMM5 = 0))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_lane_p64<const IMM5: i32>(v: poly64x1_t) -> p64 {
    static_assert!(IMM5 == 0);
    unsafe { simd_extract!(v, IMM5 as u32) }
}
#[doc = "Move vector element to general-purpose register"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_lane_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(test, assert_instr(nop, IMM5 = 0))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_lane_s64<const IMM5: i32>(v: int64x1_t) -> i64 {
    static_assert!(IMM5 == 0);
    unsafe { simd_extract!(v, IMM5 as u32) }
}
#[doc = "Move vector element to general-purpose register"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_lane_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(1)]
#[cfg_attr(test, assert_instr(nop, IMM5 = 0))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_lane_u64<const IMM5: i32>(v: uint64x1_t) -> u64 {
    static_assert!(IMM5 == 0);
    unsafe { simd_extract!(v, 0) }
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_low_f32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(test, assert_instr(nop))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_low_f32(a: float32x4_t) -> float32x2_t {
    unsafe { simd_shuffle!(a, a, [0, 1]) }
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_low_p16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(test, assert_instr(nop))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_low_p16(a: poly16x8_t) -> poly16x4_t {
    unsafe { simd_shuffle!(a, a, [0, 1, 2, 3]) }
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_low_p8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(test, assert_instr(nop))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_low_p8(a: poly8x16_t) -> poly8x8_t {
    unsafe { simd_shuffle!(a, a, [0, 1, 2, 3, 4, 5, 6, 7]) }
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_low_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(test, assert_instr(nop))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_low_s16(a: int16x8_t) -> int16x4_t {
    unsafe { simd_shuffle!(a, a, [0, 1, 2, 3]) }
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_low_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(test, assert_instr(nop))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_low_s32(a: int32x4_t) -> int32x2_t {
    unsafe { simd_shuffle!(a, a, [0, 1]) }
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_low_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(test, assert_instr(nop))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_low_s8(a: int8x16_t) -> int8x8_t {
    unsafe { simd_shuffle!(a, a, [0, 1, 2, 3, 4, 5, 6, 7]) }
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_low_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(test, assert_instr(nop))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_low_u16(a: uint16x8_t) -> uint16x4_t {
    unsafe { simd_shuffle!(a, a, [0, 1, 2, 3]) }
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_low_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(test, assert_instr(nop))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_low_u32(a: uint32x4_t) -> uint32x2_t {
    unsafe { simd_shuffle!(a, a, [0, 1]) }
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_low_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(test, assert_instr(nop))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_low_u8(a: uint8x16_t) -> uint8x8_t {
    unsafe { simd_shuffle!(a, a, [0, 1, 2, 3, 4, 5, 6, 7]) }
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_low_s64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(test, assert_instr(nop))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_low_s64(a: int64x2_t) -> int64x1_t {
    unsafe { int64x1_t([simd_extract!(a, 0)]) }
}
#[doc = "Duplicate vector element to vector or scalar"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vget_low_u64)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(test, assert_instr(nop))]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vget_low_u64(a: uint64x2_t) -> uint64x1_t {
    unsafe { uint64x1_t([simd_extract!(a, 0)]) }
}
#[doc = "Halving add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vhadd_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vhadd.s8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(shadd)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vhadd_s8(a: int8x8_t, b: int8x8_t) -> int8x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.shadd.v8i8"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vhadds.v8i8")]
        fn _vhadd_s8(a: int8x8_t, b: int8x8_t) -> int8x8_t;
    }
    unsafe { _vhadd_s8(a, b) }
}
#[doc = "Halving add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vhaddq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vhadd.s8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(shadd)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vhaddq_s8(a: int8x16_t, b: int8x16_t) -> int8x16_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.shadd.v16i8"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vhadds.v16i8")]
        fn _vhaddq_s8(a: int8x16_t, b: int8x16_t) -> int8x16_t;
    }
    unsafe { _vhaddq_s8(a, b) }
}
#[doc = "Halving add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vhadd_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vhadd.s16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(shadd)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vhadd_s16(a: int16x4_t, b: int16x4_t) -> int16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.shadd.v4i16"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vhadds.v4i16")]
        fn _vhadd_s16(a: int16x4_t, b: int16x4_t) -> int16x4_t;
    }
    unsafe { _vhadd_s16(a, b) }
}
#[doc = "Halving add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vhaddq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vhadd.s16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(shadd)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vhaddq_s16(a: int16x8_t, b: int16x8_t) -> int16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.shadd.v8i16"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vhadds.v8i16")]
        fn _vhaddq_s16(a: int16x8_t, b: int16x8_t) -> int16x8_t;
    }
    unsafe { _vhaddq_s16(a, b) }
}
#[doc = "Halving add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vhadd_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vhadd.s32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(shadd)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vhadd_s32(a: int32x2_t, b: int32x2_t) -> int32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.shadd.v2i32"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vhadds.v2i32")]
        fn _vhadd_s32(a: int32x2_t, b: int32x2_t) -> int32x2_t;
    }
    unsafe { _vhadd_s32(a, b) }
}
#[doc = "Halving add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vhaddq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vhadd.s32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(shadd)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vhaddq_s32(a: int32x4_t, b: int32x4_t) -> int32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.shadd.v4i32"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vhadds.v4i32")]
        fn _vhaddq_s32(a: int32x4_t, b: int32x4_t) -> int32x4_t;
    }
    unsafe { _vhaddq_s32(a, b) }
}
#[doc = "Halving add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vhadd_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vhadd.u8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uhadd)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vhadd_u8(a: uint8x8_t, b: uint8x8_t) -> uint8x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uhadd.v8i8"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vhaddu.v8i8")]
        fn _vhadd_u8(a: uint8x8_t, b: uint8x8_t) -> uint8x8_t;
    }
    unsafe { _vhadd_u8(a, b) }
}
#[doc = "Halving add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vhaddq_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vhadd.u8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uhadd)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vhaddq_u8(a: uint8x16_t, b: uint8x16_t) -> uint8x16_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uhadd.v16i8"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vhaddu.v16i8")]
        fn _vhaddq_u8(a: uint8x16_t, b: uint8x16_t) -> uint8x16_t;
    }
    unsafe { _vhaddq_u8(a, b) }
}
#[doc = "Halving add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vhadd_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vhadd.u16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uhadd)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vhadd_u16(a: uint16x4_t, b: uint16x4_t) -> uint16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uhadd.v4i16"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vhaddu.v4i16")]
        fn _vhadd_u16(a: uint16x4_t, b: uint16x4_t) -> uint16x4_t;
    }
    unsafe { _vhadd_u16(a, b) }
}
#[doc = "Halving add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vhaddq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vhadd.u16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uhadd)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vhaddq_u16(a: uint16x8_t, b: uint16x8_t) -> uint16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uhadd.v8i16"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vhaddu.v8i16")]
        fn _vhaddq_u16(a: uint16x8_t, b: uint16x8_t) -> uint16x8_t;
    }
    unsafe { _vhaddq_u16(a, b) }
}
#[doc = "Halving add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vhadd_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vhadd.u32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uhadd)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vhadd_u32(a: uint32x2_t, b: uint32x2_t) -> uint32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uhadd.v2i32"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vhaddu.v2i32")]
        fn _vhadd_u32(a: uint32x2_t, b: uint32x2_t) -> uint32x2_t;
    }
    unsafe { _vhadd_u32(a, b) }
}
#[doc = "Halving add"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vhaddq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vhadd.u32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uhadd)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vhaddq_u32(a: uint32x4_t, b: uint32x4_t) -> uint32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uhadd.v4i32"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vhaddu.v4i32")]
        fn _vhaddq_u32(a: uint32x4_t, b: uint32x4_t) -> uint32x4_t;
    }
    unsafe { _vhaddq_u32(a, b) }
}
#[doc = "Signed halving subtract"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vhsub_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vhsub.s16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(shsub)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vhsub_s16(a: int16x4_t, b: int16x4_t) -> int16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.shsub.v4i16"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vhsubs.v4i16")]
        fn _vhsub_s16(a: int16x4_t, b: int16x4_t) -> int16x4_t;
    }
    unsafe { _vhsub_s16(a, b) }
}
#[doc = "Signed halving subtract"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vhsubq_s16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vhsub.s16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(shsub)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vhsubq_s16(a: int16x8_t, b: int16x8_t) -> int16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.shsub.v8i16"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vhsubs.v8i16")]
        fn _vhsubq_s16(a: int16x8_t, b: int16x8_t) -> int16x8_t;
    }
    unsafe { _vhsubq_s16(a, b) }
}
#[doc = "Signed halving subtract"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vhsub_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vhsub.s32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(shsub)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vhsub_s32(a: int32x2_t, b: int32x2_t) -> int32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.shsub.v2i32"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vhsubs.v2i32")]
        fn _vhsub_s32(a: int32x2_t, b: int32x2_t) -> int32x2_t;
    }
    unsafe { _vhsub_s32(a, b) }
}
#[doc = "Signed halving subtract"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vhsubq_s32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vhsub.s32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(shsub)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vhsubq_s32(a: int32x4_t, b: int32x4_t) -> int32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.shsub.v4i32"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vhsubs.v4i32")]
        fn _vhsubq_s32(a: int32x4_t, b: int32x4_t) -> int32x4_t;
    }
    unsafe { _vhsubq_s32(a, b) }
}
#[doc = "Signed halving subtract"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vhsub_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vhsub.s8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(shsub)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vhsub_s8(a: int8x8_t, b: int8x8_t) -> int8x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.shsub.v8i8"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vhsubs.v8i8")]
        fn _vhsub_s8(a: int8x8_t, b: int8x8_t) -> int8x8_t;
    }
    unsafe { _vhsub_s8(a, b) }
}
#[doc = "Signed halving subtract"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vhsubq_s8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vhsub.s8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(shsub)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vhsubq_s8(a: int8x16_t, b: int8x16_t) -> int8x16_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.shsub.v16i8"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vhsubs.v16i8")]
        fn _vhsubq_s8(a: int8x16_t, b: int8x16_t) -> int8x16_t;
    }
    unsafe { _vhsubq_s8(a, b) }
}
#[doc = "Signed halving subtract"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vhsub_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vhsub.u8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uhsub)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vhsub_u8(a: uint8x8_t, b: uint8x8_t) -> uint8x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uhsub.v8i8"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vhsubu.v8i8")]
        fn _vhsub_u8(a: uint8x8_t, b: uint8x8_t) -> uint8x8_t;
    }
    unsafe { _vhsub_u8(a, b) }
}
#[doc = "Signed halving subtract"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vhsubq_u8)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vhsub.u8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uhsub)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vhsubq_u8(a: uint8x16_t, b: uint8x16_t) -> uint8x16_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uhsub.v16i8"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vhsubu.v16i8")]
        fn _vhsubq_u8(a: uint8x16_t, b: uint8x16_t) -> uint8x16_t;
    }
    unsafe { _vhsubq_u8(a, b) }
}
#[doc = "Signed halving subtract"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vhsub_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vhsub.u16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uhsub)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vhsub_u16(a: uint16x4_t, b: uint16x4_t) -> uint16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uhsub.v4i16"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vhsubu.v4i16")]
        fn _vhsub_u16(a: uint16x4_t, b: uint16x4_t) -> uint16x4_t;
    }
    unsafe { _vhsub_u16(a, b) }
}
#[doc = "Signed halving subtract"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vhsubq_u16)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vhsub.u16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uhsub)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vhsubq_u16(a: uint16x8_t, b: uint16x8_t) -> uint16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uhsub.v8i16"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vhsubu.v8i16")]
        fn _vhsubq_u16(a: uint16x8_t, b: uint16x8_t) -> uint16x8_t;
    }
    unsafe { _vhsubq_u16(a, b) }
}
#[doc = "Signed halving subtract"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vhsub_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vhsub.u32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uhsub)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vhsub_u32(a: uint32x2_t, b: uint32x2_t) -> uint32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uhsub.v2i32"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vhsubu.v2i32")]
        fn _vhsub_u32(a: uint32x2_t, b: uint32x2_t) -> uint32x2_t;
    }
    unsafe { _vhsub_u32(a, b) }
}
#[doc = "Signed halving subtract"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vhsubq_u32)"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vhsub.u32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(uhsub)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub fn vhsubq_u32(a: uint32x4_t, b: uint32x4_t) -> uint32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.uhsub.v4i32"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vhsubu.v4i32")]
        fn _vhsubq_u32(a: uint32x4_t, b: uint32x4_t) -> uint32x4_t;
    }
    unsafe { _vhsubq_u32(a, b) }
}
#[doc = "Load one single-element structure and replicate to all lanes of one register"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_dup_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1r)
)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld1_dup_f16(ptr: *const f16) -> float16x4_t {
    let x: float16x4_t = vld1_lane_f16::<0>(ptr, transmute(f16x4::splat(0.0)));
    simd_shuffle!(x, x, [0, 0, 0, 0])
}
#[doc = "Load one single-element structure and replicate to all lanes of one register"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_dup_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1r)
)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld1q_dup_f16(ptr: *const f16) -> float16x8_t {
    let x: float16x8_t = vld1q_lane_f16::<0>(ptr, transmute(f16x8::splat(0.0)));
    simd_shuffle!(x, x, [0, 0, 0, 0, 0, 0, 0, 0])
}
#[doc = "Load one single-element structure and Replicate to all lanes (of one register)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_dup_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_dup_f32(ptr: *const f32) -> float32x2_t {
    transmute(f32x2::splat(*ptr))
}
#[doc = "Load one single-element structure and Replicate to all lanes (of one register)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_dup_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_dup_p16(ptr: *const p16) -> poly16x4_t {
    transmute(u16x4::splat(*ptr))
}
#[doc = "Load one single-element structure and Replicate to all lanes (of one register)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_dup_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_dup_p8(ptr: *const p8) -> poly8x8_t {
    transmute(u8x8::splat(*ptr))
}
#[doc = "Load one single-element structure and Replicate to all lanes (of one register)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_dup_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_dup_s16(ptr: *const i16) -> int16x4_t {
    transmute(i16x4::splat(*ptr))
}
#[doc = "Load one single-element structure and Replicate to all lanes (of one register)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_dup_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_dup_s32(ptr: *const i32) -> int32x2_t {
    transmute(i32x2::splat(*ptr))
}
#[doc = "Load one single-element structure and Replicate to all lanes (of one register)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_dup_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_dup_s8(ptr: *const i8) -> int8x8_t {
    transmute(i8x8::splat(*ptr))
}
#[doc = "Load one single-element structure and Replicate to all lanes (of one register)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_dup_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_dup_u16(ptr: *const u16) -> uint16x4_t {
    transmute(u16x4::splat(*ptr))
}
#[doc = "Load one single-element structure and Replicate to all lanes (of one register)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_dup_u32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_dup_u32(ptr: *const u32) -> uint32x2_t {
    transmute(u32x2::splat(*ptr))
}
#[doc = "Load one single-element structure and Replicate to all lanes (of one register)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_dup_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_dup_u8(ptr: *const u8) -> uint8x8_t {
    transmute(u8x8::splat(*ptr))
}
#[doc = "Load one single-element structure and Replicate to all lanes (of one register)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_dup_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_dup_f32(ptr: *const f32) -> float32x4_t {
    transmute(f32x4::splat(*ptr))
}
#[doc = "Load one single-element structure and Replicate to all lanes (of one register)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_dup_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_dup_p16(ptr: *const p16) -> poly16x8_t {
    transmute(u16x8::splat(*ptr))
}
#[doc = "Load one single-element structure and Replicate to all lanes (of one register)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_dup_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_dup_p8(ptr: *const p8) -> poly8x16_t {
    transmute(u8x16::splat(*ptr))
}
#[doc = "Load one single-element structure and Replicate to all lanes (of one register)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_dup_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_dup_s16(ptr: *const i16) -> int16x8_t {
    transmute(i16x8::splat(*ptr))
}
#[doc = "Load one single-element structure and Replicate to all lanes (of one register)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_dup_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_dup_s32(ptr: *const i32) -> int32x4_t {
    transmute(i32x4::splat(*ptr))
}
#[doc = "Load one single-element structure and Replicate to all lanes (of one register)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_dup_s64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vldr"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_dup_s64(ptr: *const i64) -> int64x2_t {
    transmute(i64x2::splat(*ptr))
}
#[doc = "Load one single-element structure and Replicate to all lanes (of one register)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_dup_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_dup_s8(ptr: *const i8) -> int8x16_t {
    transmute(i8x16::splat(*ptr))
}
#[doc = "Load one single-element structure and Replicate to all lanes (of one register)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_dup_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.16"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_dup_u16(ptr: *const u16) -> uint16x8_t {
    transmute(u16x8::splat(*ptr))
}
#[doc = "Load one single-element structure and Replicate to all lanes (of one register)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_dup_u32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.32"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_dup_u32(ptr: *const u32) -> uint32x4_t {
    transmute(u32x4::splat(*ptr))
}
#[doc = "Load one single-element structure and Replicate to all lanes (of one register)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_dup_u64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vldr"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_dup_u64(ptr: *const u64) -> uint64x2_t {
    transmute(u64x2::splat(*ptr))
}
#[doc = "Load one single-element structure and Replicate to all lanes (of one register)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_dup_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.8"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_dup_u8(ptr: *const u8) -> uint8x16_t {
    transmute(u8x16::splat(*ptr))
}
#[doc = "Load one single-element structure and Replicate to all lanes (of one register)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_dup_p64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,aes")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vldr))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ldr)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_dup_p64(ptr: *const p64) -> poly64x1_t {
    let x: poly64x1_t;
    #[cfg(any(target_arch = "aarch64", target_arch = "arm64ec"))]
    {
        x = crate::core_arch::aarch64::vld1_p64(ptr);
    }
    #[cfg(target_arch = "arm")]
    {
        x = crate::core_arch::arm::vld1_p64(ptr);
    };
    x
}
#[doc = "Load one single-element structure and Replicate to all lanes (of one register)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_dup_s64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vldr))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ldr)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_dup_s64(ptr: *const i64) -> int64x1_t {
    let x: int64x1_t;
    #[cfg(any(target_arch = "aarch64", target_arch = "arm64ec"))]
    {
        x = crate::core_arch::aarch64::vld1_s64(ptr);
    }
    #[cfg(target_arch = "arm")]
    {
        x = crate::core_arch::arm::vld1_s64(ptr);
    };
    x
}
#[doc = "Load one single-element structure and Replicate to all lanes (of one register)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_dup_u64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vldr))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ldr)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_dup_u64(ptr: *const u64) -> uint64x1_t {
    let x: uint64x1_t;
    #[cfg(any(target_arch = "aarch64", target_arch = "arm64ec"))]
    {
        x = crate::core_arch::aarch64::vld1_u64(ptr);
    }
    #[cfg(target_arch = "arm")]
    {
        x = crate::core_arch::arm::vld1_u64(ptr);
    };
    x
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.16"))]
pub unsafe fn vld1_f16(ptr: *const f16) -> float16x4_t {
    transmute(vld1_v4f16(
        ptr as *const i8,
        crate::mem::align_of::<f16>() as i32,
    ))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.16"))]
pub unsafe fn vld1_f16(ptr: *const f16) -> float16x4_t {
    let ret_val: float16x4_t = transmute(vld1_v4f16(
        ptr as *const i8,
        crate::mem::align_of::<f16>() as i32,
    ));
    simd_shuffle!(ret_val, ret_val, [3, 2, 1, 0])
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.16"))]
pub unsafe fn vld1q_f16(ptr: *const f16) -> float16x8_t {
    transmute(vld1q_v8f16(
        ptr as *const i8,
        crate::mem::align_of::<f16>() as i32,
    ))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.16"))]
pub unsafe fn vld1q_f16(ptr: *const f16) -> float16x8_t {
    let ret_val: float16x8_t = transmute(vld1q_v8f16(
        ptr as *const i8,
        crate::mem::align_of::<f16>() as i32,
    ));
    simd_shuffle!(ret_val, ret_val, [7, 6, 5, 4, 3, 2, 1, 0])
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_f16_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld1_f16_x2(a: *const f16) -> float16x4x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x2.v4f16.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x2.v4f16.p0")]
        fn _vld1_f16_x2(a: *const f16) -> float16x4x2_t;
    }
    _vld1_f16_x2(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_f16_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld1_f16_x3(a: *const f16) -> float16x4x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x3.v4f16.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x3.v4f16.p0")]
        fn _vld1_f16_x3(a: *const f16) -> float16x4x3_t;
    }
    _vld1_f16_x3(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_f16_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld1_f16_x4(a: *const f16) -> float16x4x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x4.v4f16.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x4.v4f16.p0")]
        fn _vld1_f16_x4(a: *const f16) -> float16x4x4_t;
    }
    _vld1_f16_x4(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_f16_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld1q_f16_x2(a: *const f16) -> float16x8x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x2.v8f16.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x2.v8f16.p0")]
        fn _vld1q_f16_x2(a: *const f16) -> float16x8x2_t;
    }
    _vld1q_f16_x2(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_f16_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld1q_f16_x3(a: *const f16) -> float16x8x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x3.v8f16.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x3.v8f16.p0")]
        fn _vld1q_f16_x3(a: *const f16) -> float16x8x3_t;
    }
    _vld1q_f16_x3(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_f16_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld1q_f16_x4(a: *const f16) -> float16x8x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x4.v8f16.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x4.v8f16.p0")]
        fn _vld1q_f16_x4(a: *const f16) -> float16x8x4_t;
    }
    _vld1q_f16_x4(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vldr))]
pub unsafe fn vld1_f32(ptr: *const f32) -> float32x2_t {
    const ALIGN: i32 = crate::mem::align_of::<f32>() as i32;
    transmute(vld1_v2f32::<ALIGN>(ptr as *const i8))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.32"))]
pub unsafe fn vld1q_f32(ptr: *const f32) -> float32x4_t {
    const ALIGN: i32 = crate::mem::align_of::<f32>() as i32;
    transmute(vld1q_v4f32::<ALIGN>(ptr as *const i8))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.8"))]
pub unsafe fn vld1_u8(ptr: *const u8) -> uint8x8_t {
    const ALIGN: i32 = crate::mem::align_of::<u8>() as i32;
    transmute(vld1_v8i8::<ALIGN>(ptr as *const i8))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.8"))]
pub unsafe fn vld1q_u8(ptr: *const u8) -> uint8x16_t {
    const ALIGN: i32 = crate::mem::align_of::<u8>() as i32;
    transmute(vld1q_v16i8::<ALIGN>(ptr as *const i8))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.16"))]
pub unsafe fn vld1_u16(ptr: *const u16) -> uint16x4_t {
    const ALIGN: i32 = crate::mem::align_of::<u16>() as i32;
    transmute(vld1_v4i16::<ALIGN>(ptr as *const i8))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.16"))]
pub unsafe fn vld1q_u16(ptr: *const u16) -> uint16x8_t {
    const ALIGN: i32 = crate::mem::align_of::<u16>() as i32;
    transmute(vld1q_v8i16::<ALIGN>(ptr as *const i8))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_u32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vldr))]
pub unsafe fn vld1_u32(ptr: *const u32) -> uint32x2_t {
    const ALIGN: i32 = crate::mem::align_of::<u32>() as i32;
    transmute(vld1_v2i32::<ALIGN>(ptr as *const i8))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_u32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.32"))]
pub unsafe fn vld1q_u32(ptr: *const u32) -> uint32x4_t {
    const ALIGN: i32 = crate::mem::align_of::<u32>() as i32;
    transmute(vld1q_v4i32::<ALIGN>(ptr as *const i8))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_u64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vldr))]
pub unsafe fn vld1_u64(ptr: *const u64) -> uint64x1_t {
    const ALIGN: i32 = crate::mem::align_of::<u64>() as i32;
    transmute(vld1_v1i64::<ALIGN>(ptr as *const i8))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_u64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.64"))]
pub unsafe fn vld1q_u64(ptr: *const u64) -> uint64x2_t {
    const ALIGN: i32 = crate::mem::align_of::<u64>() as i32;
    transmute(vld1q_v2i64::<ALIGN>(ptr as *const i8))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.8"))]
pub unsafe fn vld1_p8(ptr: *const p8) -> poly8x8_t {
    const ALIGN: i32 = crate::mem::align_of::<p8>() as i32;
    transmute(vld1_v8i8::<ALIGN>(ptr as *const i8))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.8"))]
pub unsafe fn vld1q_p8(ptr: *const p8) -> poly8x16_t {
    const ALIGN: i32 = crate::mem::align_of::<p8>() as i32;
    transmute(vld1q_v16i8::<ALIGN>(ptr as *const i8))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.16"))]
pub unsafe fn vld1_p16(ptr: *const p16) -> poly16x4_t {
    const ALIGN: i32 = crate::mem::align_of::<p16>() as i32;
    transmute(vld1_v4i16::<ALIGN>(ptr as *const i8))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.16"))]
pub unsafe fn vld1q_p16(ptr: *const p16) -> poly16x8_t {
    const ALIGN: i32 = crate::mem::align_of::<p16>() as i32;
    transmute(vld1q_v8i16::<ALIGN>(ptr as *const i8))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_p64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,aes")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.64"))]
pub unsafe fn vld1q_p64(ptr: *const p64) -> poly64x2_t {
    const ALIGN: i32 = crate::mem::align_of::<p64>() as i32;
    transmute(vld1q_v2i64::<ALIGN>(ptr as *const i8))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_f32_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_f32_x2(a: *const f32) -> float32x2x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x2.v2f32.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x2.v2f32.p0")]
        fn _vld1_f32_x2(a: *const f32) -> float32x2x2_t;
    }
    _vld1_f32_x2(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_f32_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_f32_x3(a: *const f32) -> float32x2x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x3.v2f32.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x3.v2f32.p0")]
        fn _vld1_f32_x3(a: *const f32) -> float32x2x3_t;
    }
    _vld1_f32_x3(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_f32_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_f32_x4(a: *const f32) -> float32x2x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x4.v2f32.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x4.v2f32.p0")]
        fn _vld1_f32_x4(a: *const f32) -> float32x2x4_t;
    }
    _vld1_f32_x4(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_f32_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_f32_x2(a: *const f32) -> float32x4x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x2.v4f32.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x2.v4f32.p0")]
        fn _vld1q_f32_x2(a: *const f32) -> float32x4x2_t;
    }
    _vld1q_f32_x2(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_f32_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_f32_x3(a: *const f32) -> float32x4x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x3.v4f32.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x3.v4f32.p0")]
        fn _vld1q_f32_x3(a: *const f32) -> float32x4x3_t;
    }
    _vld1q_f32_x3(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_f32_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_f32_x4(a: *const f32) -> float32x4x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x4.v4f32.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x4.v4f32.p0")]
        fn _vld1q_f32_x4(a: *const f32) -> float32x4x4_t;
    }
    _vld1q_f32_x4(a)
}
#[doc = "Load one single-element structure to one lane of one register"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_lane_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1, LANE = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1, LANE = 0)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld1_lane_f16<const LANE: i32>(ptr: *const f16, src: float16x4_t) -> float16x4_t {
    static_assert_uimm_bits!(LANE, 2);
    simd_insert!(src, LANE as u32, *ptr)
}
#[doc = "Load one single-element structure to one lane of one register"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_lane_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1, LANE = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1, LANE = 0)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld1q_lane_f16<const LANE: i32>(ptr: *const f16, src: float16x8_t) -> float16x8_t {
    static_assert_uimm_bits!(LANE, 3);
    simd_insert!(src, LANE as u32, *ptr)
}
#[doc = "Load one single-element structure to one lane of one register."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_lane_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.32", LANE = 1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1, LANE = 1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_lane_f32<const LANE: i32>(ptr: *const f32, src: float32x2_t) -> float32x2_t {
    static_assert_uimm_bits!(LANE, 1);
    simd_insert!(src, LANE as u32, *ptr)
}
#[doc = "Load one single-element structure to one lane of one register."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_lane_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.16", LANE = 3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1, LANE = 3)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_lane_p16<const LANE: i32>(ptr: *const p16, src: poly16x4_t) -> poly16x4_t {
    static_assert_uimm_bits!(LANE, 2);
    simd_insert!(src, LANE as u32, *ptr)
}
#[doc = "Load one single-element structure to one lane of one register."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_lane_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.8", LANE = 7))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1, LANE = 7)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_lane_p8<const LANE: i32>(ptr: *const p8, src: poly8x8_t) -> poly8x8_t {
    static_assert_uimm_bits!(LANE, 3);
    simd_insert!(src, LANE as u32, *ptr)
}
#[doc = "Load one single-element structure to one lane of one register."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_lane_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.16", LANE = 3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1, LANE = 3)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_lane_s16<const LANE: i32>(ptr: *const i16, src: int16x4_t) -> int16x4_t {
    static_assert_uimm_bits!(LANE, 2);
    simd_insert!(src, LANE as u32, *ptr)
}
#[doc = "Load one single-element structure to one lane of one register."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_lane_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.32", LANE = 1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1, LANE = 1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_lane_s32<const LANE: i32>(ptr: *const i32, src: int32x2_t) -> int32x2_t {
    static_assert_uimm_bits!(LANE, 1);
    simd_insert!(src, LANE as u32, *ptr)
}
#[doc = "Load one single-element structure to one lane of one register."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_lane_s64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vldr, LANE = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ldr, LANE = 0)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_lane_s64<const LANE: i32>(ptr: *const i64, src: int64x1_t) -> int64x1_t {
    static_assert!(LANE == 0);
    simd_insert!(src, LANE as u32, *ptr)
}
#[doc = "Load one single-element structure to one lane of one register."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_lane_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.8", LANE = 7))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1, LANE = 7)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_lane_s8<const LANE: i32>(ptr: *const i8, src: int8x8_t) -> int8x8_t {
    static_assert_uimm_bits!(LANE, 3);
    simd_insert!(src, LANE as u32, *ptr)
}
#[doc = "Load one single-element structure to one lane of one register."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_lane_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.16", LANE = 3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1, LANE = 3)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_lane_u16<const LANE: i32>(ptr: *const u16, src: uint16x4_t) -> uint16x4_t {
    static_assert_uimm_bits!(LANE, 2);
    simd_insert!(src, LANE as u32, *ptr)
}
#[doc = "Load one single-element structure to one lane of one register."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_lane_u32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.32", LANE = 1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1, LANE = 1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_lane_u32<const LANE: i32>(ptr: *const u32, src: uint32x2_t) -> uint32x2_t {
    static_assert_uimm_bits!(LANE, 1);
    simd_insert!(src, LANE as u32, *ptr)
}
#[doc = "Load one single-element structure to one lane of one register."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_lane_u64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vldr, LANE = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ldr, LANE = 0)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_lane_u64<const LANE: i32>(ptr: *const u64, src: uint64x1_t) -> uint64x1_t {
    static_assert!(LANE == 0);
    simd_insert!(src, LANE as u32, *ptr)
}
#[doc = "Load one single-element structure to one lane of one register."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_lane_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.8", LANE = 7))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1, LANE = 7)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_lane_u8<const LANE: i32>(ptr: *const u8, src: uint8x8_t) -> uint8x8_t {
    static_assert_uimm_bits!(LANE, 3);
    simd_insert!(src, LANE as u32, *ptr)
}
#[doc = "Load one single-element structure to one lane of one register."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_lane_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.32", LANE = 3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1, LANE = 3)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_lane_f32<const LANE: i32>(ptr: *const f32, src: float32x4_t) -> float32x4_t {
    static_assert_uimm_bits!(LANE, 2);
    simd_insert!(src, LANE as u32, *ptr)
}
#[doc = "Load one single-element structure to one lane of one register."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_lane_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.16", LANE = 7))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1, LANE = 7)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_lane_p16<const LANE: i32>(ptr: *const p16, src: poly16x8_t) -> poly16x8_t {
    static_assert_uimm_bits!(LANE, 3);
    simd_insert!(src, LANE as u32, *ptr)
}
#[doc = "Load one single-element structure to one lane of one register."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_lane_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.8", LANE = 15))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1, LANE = 15)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_lane_p8<const LANE: i32>(ptr: *const p8, src: poly8x16_t) -> poly8x16_t {
    static_assert_uimm_bits!(LANE, 4);
    simd_insert!(src, LANE as u32, *ptr)
}
#[doc = "Load one single-element structure to one lane of one register."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_lane_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.16", LANE = 7))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1, LANE = 7)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_lane_s16<const LANE: i32>(ptr: *const i16, src: int16x8_t) -> int16x8_t {
    static_assert_uimm_bits!(LANE, 3);
    simd_insert!(src, LANE as u32, *ptr)
}
#[doc = "Load one single-element structure to one lane of one register."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_lane_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.32", LANE = 3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1, LANE = 3)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_lane_s32<const LANE: i32>(ptr: *const i32, src: int32x4_t) -> int32x4_t {
    static_assert_uimm_bits!(LANE, 2);
    simd_insert!(src, LANE as u32, *ptr)
}
#[doc = "Load one single-element structure to one lane of one register."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_lane_s64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vldr, LANE = 1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1, LANE = 1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_lane_s64<const LANE: i32>(ptr: *const i64, src: int64x2_t) -> int64x2_t {
    static_assert_uimm_bits!(LANE, 1);
    simd_insert!(src, LANE as u32, *ptr)
}
#[doc = "Load one single-element structure to one lane of one register."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_lane_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.8", LANE = 15))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1, LANE = 15)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_lane_s8<const LANE: i32>(ptr: *const i8, src: int8x16_t) -> int8x16_t {
    static_assert_uimm_bits!(LANE, 4);
    simd_insert!(src, LANE as u32, *ptr)
}
#[doc = "Load one single-element structure to one lane of one register."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_lane_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.16", LANE = 7))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1, LANE = 7)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_lane_u16<const LANE: i32>(ptr: *const u16, src: uint16x8_t) -> uint16x8_t {
    static_assert_uimm_bits!(LANE, 3);
    simd_insert!(src, LANE as u32, *ptr)
}
#[doc = "Load one single-element structure to one lane of one register."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_lane_u32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.32", LANE = 3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1, LANE = 3)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_lane_u32<const LANE: i32>(ptr: *const u32, src: uint32x4_t) -> uint32x4_t {
    static_assert_uimm_bits!(LANE, 2);
    simd_insert!(src, LANE as u32, *ptr)
}
#[doc = "Load one single-element structure to one lane of one register."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_lane_u64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vldr, LANE = 1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1, LANE = 1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_lane_u64<const LANE: i32>(ptr: *const u64, src: uint64x2_t) -> uint64x2_t {
    static_assert_uimm_bits!(LANE, 1);
    simd_insert!(src, LANE as u32, *ptr)
}
#[doc = "Load one single-element structure to one lane of one register."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_lane_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.8", LANE = 15))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1, LANE = 15)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_lane_u8<const LANE: i32>(ptr: *const u8, src: uint8x16_t) -> uint8x16_t {
    static_assert_uimm_bits!(LANE, 4);
    simd_insert!(src, LANE as u32, *ptr)
}
#[doc = "Load one single-element structure to one lane of one register."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_lane_p64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,aes")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vldr, LANE = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ldr, LANE = 0)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_lane_p64<const LANE: i32>(ptr: *const p64, src: poly64x1_t) -> poly64x1_t {
    static_assert!(LANE == 0);
    simd_insert!(src, LANE as u32, *ptr)
}
#[doc = "Load one single-element structure to one lane of one register."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_lane_p64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,aes")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vldr, LANE = 1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1, LANE = 1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_lane_p64<const LANE: i32>(ptr: *const p64, src: poly64x2_t) -> poly64x2_t {
    static_assert_uimm_bits!(LANE, 1);
    simd_insert!(src, LANE as u32, *ptr)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_p64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,aes")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vldr))]
pub unsafe fn vld1_p64(ptr: *const p64) -> poly64x1_t {
    let a: *const i8 = ptr as *const i8;
    let b: i32 = crate::mem::align_of::<p64>() as i32;
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1.v1i64")]
        fn _vld1_v1i64(a: *const i8, b: i32) -> int64x1_t;
    }
    transmute(_vld1_v1i64(a, b))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_p64_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,aes")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_p64_x2(a: *const p64) -> poly64x1x2_t {
    transmute(vld1_s64_x2(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_p64_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,aes")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_p64_x3(a: *const p64) -> poly64x1x3_t {
    transmute(vld1_s64_x3(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_p64_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,aes")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_p64_x4(a: *const p64) -> poly64x1x4_t {
    transmute(vld1_s64_x4(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_p64_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon,aes")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_p64_x2(a: *const p64) -> poly64x2x2_t {
    transmute(vld1q_s64_x2(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_p64_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon,aes")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_p64_x2(a: *const p64) -> poly64x2x2_t {
    let mut ret_val: poly64x2x2_t = transmute(vld1q_s64_x2(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [1, 0]) };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_p64_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon,aes")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_p64_x3(a: *const p64) -> poly64x2x3_t {
    transmute(vld1q_s64_x3(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_p64_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon,aes")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_p64_x3(a: *const p64) -> poly64x2x3_t {
    let mut ret_val: poly64x2x3_t = transmute(vld1q_s64_x3(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [1, 0]) };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_p64_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon,aes")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_p64_x4(a: *const p64) -> poly64x2x4_t {
    transmute(vld1q_s64_x4(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_p64_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon,aes")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_p64_x4(a: *const p64) -> poly64x2x4_t {
    let mut ret_val: poly64x2x4_t = transmute(vld1q_s64_x4(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [1, 0]) };
    ret_val.3 = unsafe { simd_shuffle!(ret_val.3, ret_val.3, [1, 0]) };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.8"))]
pub unsafe fn vld1_s8(ptr: *const i8) -> int8x8_t {
    const ALIGN: i32 = crate::mem::align_of::<i8>() as i32;
    vld1_v8i8::<ALIGN>(ptr as *const i8)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.8"))]
pub unsafe fn vld1q_s8(ptr: *const i8) -> int8x16_t {
    const ALIGN: i32 = crate::mem::align_of::<i8>() as i32;
    vld1q_v16i8::<ALIGN>(ptr as *const i8)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.16"))]
pub unsafe fn vld1_s16(ptr: *const i16) -> int16x4_t {
    const ALIGN: i32 = crate::mem::align_of::<i16>() as i32;
    vld1_v4i16::<ALIGN>(ptr as *const i8)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.16"))]
pub unsafe fn vld1q_s16(ptr: *const i16) -> int16x8_t {
    const ALIGN: i32 = crate::mem::align_of::<i16>() as i32;
    vld1q_v8i16::<ALIGN>(ptr as *const i8)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vldr))]
pub unsafe fn vld1_s32(ptr: *const i32) -> int32x2_t {
    const ALIGN: i32 = crate::mem::align_of::<i32>() as i32;
    vld1_v2i32::<ALIGN>(ptr as *const i8)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.32"))]
pub unsafe fn vld1q_s32(ptr: *const i32) -> int32x4_t {
    const ALIGN: i32 = crate::mem::align_of::<i32>() as i32;
    vld1q_v4i32::<ALIGN>(ptr as *const i8)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_s64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vldr))]
pub unsafe fn vld1_s64(ptr: *const i64) -> int64x1_t {
    const ALIGN: i32 = crate::mem::align_of::<i64>() as i32;
    vld1_v1i64::<ALIGN>(ptr as *const i8)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_s64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.64"))]
pub unsafe fn vld1q_s64(ptr: *const i64) -> int64x2_t {
    const ALIGN: i32 = crate::mem::align_of::<i64>() as i32;
    vld1q_v2i64::<ALIGN>(ptr as *const i8)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_s8_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_s8_x2(a: *const i8) -> int8x8x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x2.v8i8.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x2.v8i8.p0")]
        fn _vld1_s8_x2(a: *const i8) -> int8x8x2_t;
    }
    _vld1_s8_x2(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_s8_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_s8_x3(a: *const i8) -> int8x8x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x3.v8i8.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x3.v8i8.p0")]
        fn _vld1_s8_x3(a: *const i8) -> int8x8x3_t;
    }
    _vld1_s8_x3(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_s8_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_s8_x4(a: *const i8) -> int8x8x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x4.v8i8.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x4.v8i8.p0")]
        fn _vld1_s8_x4(a: *const i8) -> int8x8x4_t;
    }
    _vld1_s8_x4(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_s8_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_s8_x2(a: *const i8) -> int8x16x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x2.v16i8.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x2.v16i8.p0")]
        fn _vld1q_s8_x2(a: *const i8) -> int8x16x2_t;
    }
    _vld1q_s8_x2(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_s8_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_s8_x3(a: *const i8) -> int8x16x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x3.v16i8.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x3.v16i8.p0")]
        fn _vld1q_s8_x3(a: *const i8) -> int8x16x3_t;
    }
    _vld1q_s8_x3(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_s8_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_s8_x4(a: *const i8) -> int8x16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x4.v16i8.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x4.v16i8.p0")]
        fn _vld1q_s8_x4(a: *const i8) -> int8x16x4_t;
    }
    _vld1q_s8_x4(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_s16_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_s16_x2(a: *const i16) -> int16x4x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x2.v4i16.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x2.v4i16.p0")]
        fn _vld1_s16_x2(a: *const i16) -> int16x4x2_t;
    }
    _vld1_s16_x2(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_s16_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_s16_x3(a: *const i16) -> int16x4x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x3.v4i16.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x3.v4i16.p0")]
        fn _vld1_s16_x3(a: *const i16) -> int16x4x3_t;
    }
    _vld1_s16_x3(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_s16_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_s16_x4(a: *const i16) -> int16x4x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x4.v4i16.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x4.v4i16.p0")]
        fn _vld1_s16_x4(a: *const i16) -> int16x4x4_t;
    }
    _vld1_s16_x4(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_s16_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_s16_x2(a: *const i16) -> int16x8x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x2.v8i16.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x2.v8i16.p0")]
        fn _vld1q_s16_x2(a: *const i16) -> int16x8x2_t;
    }
    _vld1q_s16_x2(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_s16_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_s16_x3(a: *const i16) -> int16x8x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x3.v8i16.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x3.v8i16.p0")]
        fn _vld1q_s16_x3(a: *const i16) -> int16x8x3_t;
    }
    _vld1q_s16_x3(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_s16_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_s16_x4(a: *const i16) -> int16x8x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x4.v8i16.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x4.v8i16.p0")]
        fn _vld1q_s16_x4(a: *const i16) -> int16x8x4_t;
    }
    _vld1q_s16_x4(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_s32_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_s32_x2(a: *const i32) -> int32x2x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x2.v2i32.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x2.v2i32.p0")]
        fn _vld1_s32_x2(a: *const i32) -> int32x2x2_t;
    }
    _vld1_s32_x2(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_s32_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_s32_x3(a: *const i32) -> int32x2x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x3.v2i32.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x3.v2i32.p0")]
        fn _vld1_s32_x3(a: *const i32) -> int32x2x3_t;
    }
    _vld1_s32_x3(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_s32_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_s32_x4(a: *const i32) -> int32x2x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x4.v2i32.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x4.v2i32.p0")]
        fn _vld1_s32_x4(a: *const i32) -> int32x2x4_t;
    }
    _vld1_s32_x4(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_s32_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_s32_x2(a: *const i32) -> int32x4x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x2.v4i32.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x2.v4i32.p0")]
        fn _vld1q_s32_x2(a: *const i32) -> int32x4x2_t;
    }
    _vld1q_s32_x2(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_s32_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_s32_x3(a: *const i32) -> int32x4x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x3.v4i32.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x3.v4i32.p0")]
        fn _vld1q_s32_x3(a: *const i32) -> int32x4x3_t;
    }
    _vld1q_s32_x3(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_s32_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_s32_x4(a: *const i32) -> int32x4x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x4.v4i32.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x4.v4i32.p0")]
        fn _vld1q_s32_x4(a: *const i32) -> int32x4x4_t;
    }
    _vld1q_s32_x4(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_s64_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_s64_x2(a: *const i64) -> int64x1x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x2.v1i64.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x2.v1i64.p0")]
        fn _vld1_s64_x2(a: *const i64) -> int64x1x2_t;
    }
    _vld1_s64_x2(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_s64_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_s64_x3(a: *const i64) -> int64x1x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x3.v1i64.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x3.v1i64.p0")]
        fn _vld1_s64_x3(a: *const i64) -> int64x1x3_t;
    }
    _vld1_s64_x3(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_s64_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_s64_x4(a: *const i64) -> int64x1x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x4.v1i64.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x4.v1i64.p0")]
        fn _vld1_s64_x4(a: *const i64) -> int64x1x4_t;
    }
    _vld1_s64_x4(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_s64_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_s64_x2(a: *const i64) -> int64x2x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x2.v2i64.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x2.v2i64.p0")]
        fn _vld1q_s64_x2(a: *const i64) -> int64x2x2_t;
    }
    _vld1q_s64_x2(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_s64_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_s64_x3(a: *const i64) -> int64x2x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x3.v2i64.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x3.v2i64.p0")]
        fn _vld1q_s64_x3(a: *const i64) -> int64x2x3_t;
    }
    _vld1q_s64_x3(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_s64_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_s64_x4(a: *const i64) -> int64x2x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld1x4.v2i64.p0"
        )]
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1x4.v2i64.p0")]
        fn _vld1q_s64_x4(a: *const i64) -> int64x2x4_t;
    }
    _vld1q_s64_x4(a)
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_u8_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_u8_x2(a: *const u8) -> uint8x8x2_t {
    transmute(vld1_s8_x2(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_u8_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_u8_x2(a: *const u8) -> uint8x8x2_t {
    let mut ret_val: uint8x8x2_t = transmute(vld1_s8_x2(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_u8_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_u8_x3(a: *const u8) -> uint8x8x3_t {
    transmute(vld1_s8_x3(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_u8_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_u8_x3(a: *const u8) -> uint8x8x3_t {
    let mut ret_val: uint8x8x3_t = transmute(vld1_s8_x3(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_u8_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_u8_x4(a: *const u8) -> uint8x8x4_t {
    transmute(vld1_s8_x4(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_u8_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_u8_x4(a: *const u8) -> uint8x8x4_t {
    let mut ret_val: uint8x8x4_t = transmute(vld1_s8_x4(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.3 = unsafe { simd_shuffle!(ret_val.3, ret_val.3, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_u8_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_u8_x2(a: *const u8) -> uint8x16x2_t {
    transmute(vld1q_s8_x2(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_u8_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_u8_x2(a: *const u8) -> uint8x16x2_t {
    let mut ret_val: uint8x16x2_t = transmute(vld1q_s8_x2(transmute(a)));
    ret_val.0 = unsafe {
        simd_shuffle!(
            ret_val.0,
            ret_val.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val.1 = unsafe {
        simd_shuffle!(
            ret_val.1,
            ret_val.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_u8_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_u8_x3(a: *const u8) -> uint8x16x3_t {
    transmute(vld1q_s8_x3(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_u8_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_u8_x3(a: *const u8) -> uint8x16x3_t {
    let mut ret_val: uint8x16x3_t = transmute(vld1q_s8_x3(transmute(a)));
    ret_val.0 = unsafe {
        simd_shuffle!(
            ret_val.0,
            ret_val.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val.1 = unsafe {
        simd_shuffle!(
            ret_val.1,
            ret_val.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val.2 = unsafe {
        simd_shuffle!(
            ret_val.2,
            ret_val.2,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_u8_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_u8_x4(a: *const u8) -> uint8x16x4_t {
    transmute(vld1q_s8_x4(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_u8_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_u8_x4(a: *const u8) -> uint8x16x4_t {
    let mut ret_val: uint8x16x4_t = transmute(vld1q_s8_x4(transmute(a)));
    ret_val.0 = unsafe {
        simd_shuffle!(
            ret_val.0,
            ret_val.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val.1 = unsafe {
        simd_shuffle!(
            ret_val.1,
            ret_val.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val.2 = unsafe {
        simd_shuffle!(
            ret_val.2,
            ret_val.2,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val.3 = unsafe {
        simd_shuffle!(
            ret_val.3,
            ret_val.3,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_u16_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_u16_x2(a: *const u16) -> uint16x4x2_t {
    transmute(vld1_s16_x2(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_u16_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_u16_x2(a: *const u16) -> uint16x4x2_t {
    let mut ret_val: uint16x4x2_t = transmute(vld1_s16_x2(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_u16_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_u16_x3(a: *const u16) -> uint16x4x3_t {
    transmute(vld1_s16_x3(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_u16_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_u16_x3(a: *const u16) -> uint16x4x3_t {
    let mut ret_val: uint16x4x3_t = transmute(vld1_s16_x3(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_u16_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_u16_x4(a: *const u16) -> uint16x4x4_t {
    transmute(vld1_s16_x4(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_u16_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_u16_x4(a: *const u16) -> uint16x4x4_t {
    let mut ret_val: uint16x4x4_t = transmute(vld1_s16_x4(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [3, 2, 1, 0]) };
    ret_val.3 = unsafe { simd_shuffle!(ret_val.3, ret_val.3, [3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_u16_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_u16_x2(a: *const u16) -> uint16x8x2_t {
    transmute(vld1q_s16_x2(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_u16_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_u16_x2(a: *const u16) -> uint16x8x2_t {
    let mut ret_val: uint16x8x2_t = transmute(vld1q_s16_x2(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_u16_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_u16_x3(a: *const u16) -> uint16x8x3_t {
    transmute(vld1q_s16_x3(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_u16_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_u16_x3(a: *const u16) -> uint16x8x3_t {
    let mut ret_val: uint16x8x3_t = transmute(vld1q_s16_x3(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_u16_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_u16_x4(a: *const u16) -> uint16x8x4_t {
    transmute(vld1q_s16_x4(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_u16_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_u16_x4(a: *const u16) -> uint16x8x4_t {
    let mut ret_val: uint16x8x4_t = transmute(vld1q_s16_x4(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.3 = unsafe { simd_shuffle!(ret_val.3, ret_val.3, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_u32_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_u32_x2(a: *const u32) -> uint32x2x2_t {
    transmute(vld1_s32_x2(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_u32_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_u32_x2(a: *const u32) -> uint32x2x2_t {
    let mut ret_val: uint32x2x2_t = transmute(vld1_s32_x2(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [1, 0]) };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_u32_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_u32_x3(a: *const u32) -> uint32x2x3_t {
    transmute(vld1_s32_x3(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_u32_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_u32_x3(a: *const u32) -> uint32x2x3_t {
    let mut ret_val: uint32x2x3_t = transmute(vld1_s32_x3(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [1, 0]) };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_u32_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_u32_x4(a: *const u32) -> uint32x2x4_t {
    transmute(vld1_s32_x4(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_u32_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_u32_x4(a: *const u32) -> uint32x2x4_t {
    let mut ret_val: uint32x2x4_t = transmute(vld1_s32_x4(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [1, 0]) };
    ret_val.3 = unsafe { simd_shuffle!(ret_val.3, ret_val.3, [1, 0]) };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_u32_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_u32_x2(a: *const u32) -> uint32x4x2_t {
    transmute(vld1q_s32_x2(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_u32_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_u32_x2(a: *const u32) -> uint32x4x2_t {
    let mut ret_val: uint32x4x2_t = transmute(vld1q_s32_x2(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_u32_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_u32_x3(a: *const u32) -> uint32x4x3_t {
    transmute(vld1q_s32_x3(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_u32_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_u32_x3(a: *const u32) -> uint32x4x3_t {
    let mut ret_val: uint32x4x3_t = transmute(vld1q_s32_x3(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_u32_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_u32_x4(a: *const u32) -> uint32x4x4_t {
    transmute(vld1q_s32_x4(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_u32_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_u32_x4(a: *const u32) -> uint32x4x4_t {
    let mut ret_val: uint32x4x4_t = transmute(vld1q_s32_x4(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [3, 2, 1, 0]) };
    ret_val.3 = unsafe { simd_shuffle!(ret_val.3, ret_val.3, [3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_u64_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_u64_x2(a: *const u64) -> uint64x1x2_t {
    transmute(vld1_s64_x2(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_u64_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_u64_x3(a: *const u64) -> uint64x1x3_t {
    transmute(vld1_s64_x3(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_u64_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_u64_x4(a: *const u64) -> uint64x1x4_t {
    transmute(vld1_s64_x4(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_u64_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_u64_x2(a: *const u64) -> uint64x2x2_t {
    transmute(vld1q_s64_x2(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_u64_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_u64_x2(a: *const u64) -> uint64x2x2_t {
    let mut ret_val: uint64x2x2_t = transmute(vld1q_s64_x2(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [1, 0]) };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_u64_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_u64_x3(a: *const u64) -> uint64x2x3_t {
    transmute(vld1q_s64_x3(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_u64_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_u64_x3(a: *const u64) -> uint64x2x3_t {
    let mut ret_val: uint64x2x3_t = transmute(vld1q_s64_x3(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [1, 0]) };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_u64_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_u64_x4(a: *const u64) -> uint64x2x4_t {
    transmute(vld1q_s64_x4(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_u64_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_u64_x4(a: *const u64) -> uint64x2x4_t {
    let mut ret_val: uint64x2x4_t = transmute(vld1q_s64_x4(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [1, 0]) };
    ret_val.3 = unsafe { simd_shuffle!(ret_val.3, ret_val.3, [1, 0]) };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_p8_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_p8_x2(a: *const p8) -> poly8x8x2_t {
    transmute(vld1_s8_x2(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_p8_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_p8_x2(a: *const p8) -> poly8x8x2_t {
    let mut ret_val: poly8x8x2_t = transmute(vld1_s8_x2(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_p8_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_p8_x3(a: *const p8) -> poly8x8x3_t {
    transmute(vld1_s8_x3(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_p8_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_p8_x3(a: *const p8) -> poly8x8x3_t {
    let mut ret_val: poly8x8x3_t = transmute(vld1_s8_x3(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_p8_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_p8_x4(a: *const p8) -> poly8x8x4_t {
    transmute(vld1_s8_x4(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_p8_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_p8_x4(a: *const p8) -> poly8x8x4_t {
    let mut ret_val: poly8x8x4_t = transmute(vld1_s8_x4(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.3 = unsafe { simd_shuffle!(ret_val.3, ret_val.3, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_p8_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_p8_x2(a: *const p8) -> poly8x16x2_t {
    transmute(vld1q_s8_x2(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_p8_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_p8_x2(a: *const p8) -> poly8x16x2_t {
    let mut ret_val: poly8x16x2_t = transmute(vld1q_s8_x2(transmute(a)));
    ret_val.0 = unsafe {
        simd_shuffle!(
            ret_val.0,
            ret_val.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val.1 = unsafe {
        simd_shuffle!(
            ret_val.1,
            ret_val.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_p8_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_p8_x3(a: *const p8) -> poly8x16x3_t {
    transmute(vld1q_s8_x3(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_p8_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_p8_x3(a: *const p8) -> poly8x16x3_t {
    let mut ret_val: poly8x16x3_t = transmute(vld1q_s8_x3(transmute(a)));
    ret_val.0 = unsafe {
        simd_shuffle!(
            ret_val.0,
            ret_val.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val.1 = unsafe {
        simd_shuffle!(
            ret_val.1,
            ret_val.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val.2 = unsafe {
        simd_shuffle!(
            ret_val.2,
            ret_val.2,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_p8_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_p8_x4(a: *const p8) -> poly8x16x4_t {
    transmute(vld1q_s8_x4(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_p8_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_p8_x4(a: *const p8) -> poly8x16x4_t {
    let mut ret_val: poly8x16x4_t = transmute(vld1q_s8_x4(transmute(a)));
    ret_val.0 = unsafe {
        simd_shuffle!(
            ret_val.0,
            ret_val.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val.1 = unsafe {
        simd_shuffle!(
            ret_val.1,
            ret_val.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val.2 = unsafe {
        simd_shuffle!(
            ret_val.2,
            ret_val.2,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val.3 = unsafe {
        simd_shuffle!(
            ret_val.3,
            ret_val.3,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_p16_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_p16_x2(a: *const p16) -> poly16x4x2_t {
    transmute(vld1_s16_x2(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_p16_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_p16_x2(a: *const p16) -> poly16x4x2_t {
    let mut ret_val: poly16x4x2_t = transmute(vld1_s16_x2(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_p16_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_p16_x3(a: *const p16) -> poly16x4x3_t {
    transmute(vld1_s16_x3(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_p16_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_p16_x3(a: *const p16) -> poly16x4x3_t {
    let mut ret_val: poly16x4x3_t = transmute(vld1_s16_x3(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_p16_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_p16_x4(a: *const p16) -> poly16x4x4_t {
    transmute(vld1_s16_x4(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1_p16_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1_p16_x4(a: *const p16) -> poly16x4x4_t {
    let mut ret_val: poly16x4x4_t = transmute(vld1_s16_x4(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [3, 2, 1, 0]) };
    ret_val.3 = unsafe { simd_shuffle!(ret_val.3, ret_val.3, [3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_p16_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_p16_x2(a: *const p16) -> poly16x8x2_t {
    transmute(vld1q_s16_x2(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_p16_x2)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_p16_x2(a: *const p16) -> poly16x8x2_t {
    let mut ret_val: poly16x8x2_t = transmute(vld1q_s16_x2(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_p16_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_p16_x3(a: *const p16) -> poly16x8x3_t {
    transmute(vld1q_s16_x3(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_p16_x3)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_p16_x3(a: *const p16) -> poly16x8x3_t {
    let mut ret_val: poly16x8x3_t = transmute(vld1q_s16_x3(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_p16_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_p16_x4(a: *const p16) -> poly16x8x4_t {
    transmute(vld1q_s16_x4(transmute(a)))
}
#[doc = "Load multiple single-element structures to one, two, three, or four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_p16_x4)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld1))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_p16_x4(a: *const p16) -> poly16x8x4_t {
    let mut ret_val: poly16x8x4_t = transmute(vld1q_s16_x4(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.3 = unsafe { simd_shuffle!(ret_val.3, ret_val.3, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val
}
#[inline]
#[rustc_legacy_const_generics(1)]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.8", ALIGN = 0))]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
unsafe fn vld1_v1i64<const ALIGN: i32>(a: *const i8) -> int64x1_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1.v1i64")]
        fn _vld1_v1i64(a: *const i8, b: i32) -> int64x1_t;
    }
    _vld1_v1i64(a, ALIGN)
}
#[inline]
#[rustc_legacy_const_generics(1)]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.8", ALIGN = 0))]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
unsafe fn vld1_v2f32<const ALIGN: i32>(a: *const i8) -> float32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1.v2f32")]
        fn _vld1_v2f32(a: *const i8, b: i32) -> float32x2_t;
    }
    _vld1_v2f32(a, ALIGN)
}
#[inline]
#[rustc_legacy_const_generics(1)]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.8", ALIGN = 0))]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
unsafe fn vld1_v2i32<const ALIGN: i32>(a: *const i8) -> int32x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1.v2i32")]
        fn _vld1_v2i32(a: *const i8, b: i32) -> int32x2_t;
    }
    _vld1_v2i32(a, ALIGN)
}
#[inline]
#[rustc_legacy_const_generics(1)]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.8", ALIGN = 0))]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
unsafe fn vld1_v4i16<const ALIGN: i32>(a: *const i8) -> int16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1.v4i16")]
        fn _vld1_v4i16(a: *const i8, b: i32) -> int16x4_t;
    }
    _vld1_v4i16(a, ALIGN)
}
#[inline]
#[rustc_legacy_const_generics(1)]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.8", ALIGN = 0))]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
unsafe fn vld1_v8i8<const ALIGN: i32>(a: *const i8) -> int8x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1.v8i8")]
        fn _vld1_v8i8(a: *const i8, b: i32) -> int8x8_t;
    }
    _vld1_v8i8(a, ALIGN)
}
#[inline]
#[rustc_legacy_const_generics(1)]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.8", ALIGN = 0))]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
unsafe fn vld1q_v16i8<const ALIGN: i32>(a: *const i8) -> int8x16_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1.v16i8")]
        fn _vld1q_v16i8(a: *const i8, b: i32) -> int8x16_t;
    }
    _vld1q_v16i8(a, ALIGN)
}
#[inline]
#[rustc_legacy_const_generics(1)]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.8", ALIGN = 0))]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
unsafe fn vld1q_v2i64<const ALIGN: i32>(a: *const i8) -> int64x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1.v2i64")]
        fn _vld1q_v2i64(a: *const i8, b: i32) -> int64x2_t;
    }
    _vld1q_v2i64(a, ALIGN)
}
#[inline]
#[rustc_legacy_const_generics(1)]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.8", ALIGN = 0))]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
unsafe fn vld1q_v4f32<const ALIGN: i32>(a: *const i8) -> float32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1.v4f32")]
        fn _vld1q_v4f32(a: *const i8, b: i32) -> float32x4_t;
    }
    _vld1q_v4f32(a, ALIGN)
}
#[inline]
#[rustc_legacy_const_generics(1)]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.8", ALIGN = 0))]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
unsafe fn vld1q_v4i32<const ALIGN: i32>(a: *const i8) -> int32x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1.v4i32")]
        fn _vld1q_v4i32(a: *const i8, b: i32) -> int32x4_t;
    }
    _vld1q_v4i32(a, ALIGN)
}
#[inline]
#[rustc_legacy_const_generics(1)]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr("vld1.8", ALIGN = 0))]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
unsafe fn vld1q_v8i16<const ALIGN: i32>(a: *const i8) -> int16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1.v8i16")]
        fn _vld1q_v8i16(a: *const i8, b: i32) -> int16x8_t;
    }
    _vld1q_v8i16(a, ALIGN)
}
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg(not(target_arch = "arm64ec"))]
unsafe fn vld1_v4f16(a: *const i8, b: i32) -> float16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1.v4f16")]
        fn _vld1_v4f16(a: *const i8, b: i32) -> float16x4_t;
    }
    _vld1_v4f16(a, b)
}
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg(not(target_arch = "arm64ec"))]
unsafe fn vld1q_v8f16(a: *const i8, b: i32) -> float16x8_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld1.v8f16")]
        fn _vld1q_v8f16(a: *const i8, b: i32) -> float16x8_t;
    }
    _vld1q_v8f16(a, b)
}
#[doc = "Load one single-element structure and Replicate to all lanes (of one register)."]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld1q_dup_p64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,aes")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vldr))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld1r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld1q_dup_p64(ptr: *const p64) -> poly64x2_t {
    let x = vld1q_lane_p64::<0>(ptr, transmute(u64x2::splat(0)));
    simd_shuffle!(x, x, [0, 0])
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_dup_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg(target_arch = "arm")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld2_dup_f16(a: *const f16) -> float16x4x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld2dup.v4f16.p0")]
        fn _vld2_dup_f16(ptr: *const f16, size: i32) -> float16x4x2_t;
    }
    _vld2_dup_f16(a as _, 2)
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_dup_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg(target_arch = "arm")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld2q_dup_f16(a: *const f16) -> float16x8x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld2dup.v8f16.p0")]
        fn _vld2q_dup_f16(ptr: *const f16, size: i32) -> float16x8x2_t;
    }
    _vld2q_dup_f16(a as _, 2)
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_dup_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2r)
)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld2_dup_f16(a: *const f16) -> float16x4x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2r.v4f16.p0"
        )]
        fn _vld2_dup_f16(ptr: *const f16) -> float16x4x2_t;
    }
    _vld2_dup_f16(a as _)
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_dup_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2r)
)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld2q_dup_f16(a: *const f16) -> float16x8x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2r.v8f16.p0"
        )]
        fn _vld2q_dup_f16(ptr: *const f16) -> float16x8x2_t;
    }
    _vld2q_dup_f16(a as _)
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_dup_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(vld2))]
pub unsafe fn vld2_dup_f32(a: *const f32) -> float32x2x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld2dup.v2f32.p0")]
        fn _vld2_dup_f32(ptr: *const i8, size: i32) -> float32x2x2_t;
    }
    _vld2_dup_f32(a as *const i8, 4)
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_dup_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(vld2))]
pub unsafe fn vld2q_dup_f32(a: *const f32) -> float32x4x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld2dup.v4f32.p0")]
        fn _vld2q_dup_f32(ptr: *const i8, size: i32) -> float32x4x2_t;
    }
    _vld2q_dup_f32(a as *const i8, 4)
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_dup_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(vld2))]
pub unsafe fn vld2_dup_s8(a: *const i8) -> int8x8x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld2dup.v8i8.p0")]
        fn _vld2_dup_s8(ptr: *const i8, size: i32) -> int8x8x2_t;
    }
    _vld2_dup_s8(a as *const i8, 1)
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_dup_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(vld2))]
pub unsafe fn vld2q_dup_s8(a: *const i8) -> int8x16x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld2dup.v16i8.p0")]
        fn _vld2q_dup_s8(ptr: *const i8, size: i32) -> int8x16x2_t;
    }
    _vld2q_dup_s8(a as *const i8, 1)
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_dup_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(vld2))]
pub unsafe fn vld2_dup_s16(a: *const i16) -> int16x4x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld2dup.v4i16.p0")]
        fn _vld2_dup_s16(ptr: *const i8, size: i32) -> int16x4x2_t;
    }
    _vld2_dup_s16(a as *const i8, 2)
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_dup_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(vld2))]
pub unsafe fn vld2q_dup_s16(a: *const i16) -> int16x8x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld2dup.v8i16.p0")]
        fn _vld2q_dup_s16(ptr: *const i8, size: i32) -> int16x8x2_t;
    }
    _vld2q_dup_s16(a as *const i8, 2)
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_dup_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(vld2))]
pub unsafe fn vld2_dup_s32(a: *const i32) -> int32x2x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld2dup.v2i32.p0")]
        fn _vld2_dup_s32(ptr: *const i8, size: i32) -> int32x2x2_t;
    }
    _vld2_dup_s32(a as *const i8, 4)
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_dup_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(vld2))]
pub unsafe fn vld2q_dup_s32(a: *const i32) -> int32x4x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld2dup.v4i32.p0")]
        fn _vld2q_dup_s32(ptr: *const i8, size: i32) -> int32x4x2_t;
    }
    _vld2q_dup_s32(a as *const i8, 4)
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_dup_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld2r))]
pub unsafe fn vld2_dup_f32(a: *const f32) -> float32x2x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2r.v2f32.p0"
        )]
        fn _vld2_dup_f32(ptr: *const f32) -> float32x2x2_t;
    }
    _vld2_dup_f32(a as _)
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_dup_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld2r))]
pub unsafe fn vld2q_dup_f32(a: *const f32) -> float32x4x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2r.v4f32.p0"
        )]
        fn _vld2q_dup_f32(ptr: *const f32) -> float32x4x2_t;
    }
    _vld2q_dup_f32(a as _)
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_dup_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld2r))]
pub unsafe fn vld2_dup_s8(a: *const i8) -> int8x8x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2r.v8i8.p0"
        )]
        fn _vld2_dup_s8(ptr: *const i8) -> int8x8x2_t;
    }
    _vld2_dup_s8(a as _)
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_dup_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld2r))]
pub unsafe fn vld2q_dup_s8(a: *const i8) -> int8x16x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2r.v16i8.p0"
        )]
        fn _vld2q_dup_s8(ptr: *const i8) -> int8x16x2_t;
    }
    _vld2q_dup_s8(a as _)
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_dup_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld2r))]
pub unsafe fn vld2_dup_s16(a: *const i16) -> int16x4x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2r.v4i16.p0"
        )]
        fn _vld2_dup_s16(ptr: *const i16) -> int16x4x2_t;
    }
    _vld2_dup_s16(a as _)
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_dup_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld2r))]
pub unsafe fn vld2q_dup_s16(a: *const i16) -> int16x8x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2r.v8i16.p0"
        )]
        fn _vld2q_dup_s16(ptr: *const i16) -> int16x8x2_t;
    }
    _vld2q_dup_s16(a as _)
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_dup_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld2r))]
pub unsafe fn vld2_dup_s32(a: *const i32) -> int32x2x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2r.v2i32.p0"
        )]
        fn _vld2_dup_s32(ptr: *const i32) -> int32x2x2_t;
    }
    _vld2_dup_s32(a as _)
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_dup_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld2r))]
pub unsafe fn vld2q_dup_s32(a: *const i32) -> int32x4x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2r.v4i32.p0"
        )]
        fn _vld2q_dup_s32(ptr: *const i32) -> int32x4x2_t;
    }
    _vld2q_dup_s32(a as _)
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_dup_p64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,aes")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2_dup_p64(a: *const p64) -> poly64x1x2_t {
    transmute(vld2_dup_s64(transmute(a)))
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_dup_s64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(nop))]
pub unsafe fn vld2_dup_s64(a: *const i64) -> int64x1x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld2dup.v1i64.p0")]
        fn _vld2_dup_s64(ptr: *const i8, size: i32) -> int64x1x2_t;
    }
    _vld2_dup_s64(a as *const i8, 8)
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_dup_s64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld2r))]
pub unsafe fn vld2_dup_s64(a: *const i64) -> int64x1x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2r.v1i64.p0"
        )]
        fn _vld2_dup_s64(ptr: *const i64) -> int64x1x2_t;
    }
    _vld2_dup_s64(a as _)
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_dup_u64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2_dup_u64(a: *const u64) -> uint64x1x2_t {
    transmute(vld2_dup_s64(transmute(a)))
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_dup_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2_dup_u8(a: *const u8) -> uint8x8x2_t {
    transmute(vld2_dup_s8(transmute(a)))
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_dup_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2_dup_u8(a: *const u8) -> uint8x8x2_t {
    let mut ret_val: uint8x8x2_t = transmute(vld2_dup_s8(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_dup_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2q_dup_u8(a: *const u8) -> uint8x16x2_t {
    transmute(vld2q_dup_s8(transmute(a)))
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_dup_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2q_dup_u8(a: *const u8) -> uint8x16x2_t {
    let mut ret_val: uint8x16x2_t = transmute(vld2q_dup_s8(transmute(a)));
    ret_val.0 = unsafe {
        simd_shuffle!(
            ret_val.0,
            ret_val.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val.1 = unsafe {
        simd_shuffle!(
            ret_val.1,
            ret_val.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_dup_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2_dup_u16(a: *const u16) -> uint16x4x2_t {
    transmute(vld2_dup_s16(transmute(a)))
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_dup_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2_dup_u16(a: *const u16) -> uint16x4x2_t {
    let mut ret_val: uint16x4x2_t = transmute(vld2_dup_s16(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_dup_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2q_dup_u16(a: *const u16) -> uint16x8x2_t {
    transmute(vld2q_dup_s16(transmute(a)))
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_dup_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2q_dup_u16(a: *const u16) -> uint16x8x2_t {
    let mut ret_val: uint16x8x2_t = transmute(vld2q_dup_s16(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_dup_u32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2_dup_u32(a: *const u32) -> uint32x2x2_t {
    transmute(vld2_dup_s32(transmute(a)))
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_dup_u32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2_dup_u32(a: *const u32) -> uint32x2x2_t {
    let mut ret_val: uint32x2x2_t = transmute(vld2_dup_s32(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [1, 0]) };
    ret_val
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_dup_u32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2q_dup_u32(a: *const u32) -> uint32x4x2_t {
    transmute(vld2q_dup_s32(transmute(a)))
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_dup_u32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2q_dup_u32(a: *const u32) -> uint32x4x2_t {
    let mut ret_val: uint32x4x2_t = transmute(vld2q_dup_s32(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_dup_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2_dup_p8(a: *const p8) -> poly8x8x2_t {
    transmute(vld2_dup_s8(transmute(a)))
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_dup_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2_dup_p8(a: *const p8) -> poly8x8x2_t {
    let mut ret_val: poly8x8x2_t = transmute(vld2_dup_s8(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_dup_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2q_dup_p8(a: *const p8) -> poly8x16x2_t {
    transmute(vld2q_dup_s8(transmute(a)))
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_dup_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2q_dup_p8(a: *const p8) -> poly8x16x2_t {
    let mut ret_val: poly8x16x2_t = transmute(vld2q_dup_s8(transmute(a)));
    ret_val.0 = unsafe {
        simd_shuffle!(
            ret_val.0,
            ret_val.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val.1 = unsafe {
        simd_shuffle!(
            ret_val.1,
            ret_val.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_dup_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2_dup_p16(a: *const p16) -> poly16x4x2_t {
    transmute(vld2_dup_s16(transmute(a)))
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_dup_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2_dup_p16(a: *const p16) -> poly16x4x2_t {
    let mut ret_val: poly16x4x2_t = transmute(vld2_dup_s16(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_dup_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2q_dup_p16(a: *const p16) -> poly16x8x2_t {
    transmute(vld2q_dup_s16(transmute(a)))
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_dup_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2q_dup_p16(a: *const p16) -> poly16x8x2_t {
    let mut ret_val: poly16x8x2_t = transmute(vld2q_dup_s16(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg(target_arch = "arm")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld2_f16(a: *const f16) -> float16x4x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld2.v4f16.p0")]
        fn _vld2_f16(ptr: *const f16, size: i32) -> float16x4x2_t;
    }
    _vld2_f16(a as _, 2)
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg(target_arch = "arm")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld2q_f16(a: *const f16) -> float16x8x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld2.v8f16.p0")]
        fn _vld2q_f16(ptr: *const f16, size: i32) -> float16x8x2_t;
    }
    _vld2q_f16(a as _, 2)
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2)
)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld2_f16(a: *const f16) -> float16x4x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2.v4f16.p0"
        )]
        fn _vld2_f16(ptr: *const f16) -> float16x4x2_t;
    }
    _vld2_f16(a as _)
}
#[doc = "Load single 2-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2)
)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld2q_f16(a: *const f16) -> float16x8x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2.v8f16.p0"
        )]
        fn _vld2q_f16(ptr: *const f16) -> float16x8x2_t;
    }
    _vld2q_f16(a as _)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(vld2))]
pub unsafe fn vld2_f32(a: *const f32) -> float32x2x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld2.v2f32")]
        fn _vld2_f32(ptr: *const i8, size: i32) -> float32x2x2_t;
    }
    _vld2_f32(a as *const i8, 4)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(vld2))]
pub unsafe fn vld2q_f32(a: *const f32) -> float32x4x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld2.v4f32")]
        fn _vld2q_f32(ptr: *const i8, size: i32) -> float32x4x2_t;
    }
    _vld2q_f32(a as *const i8, 4)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(vld2))]
pub unsafe fn vld2_s8(a: *const i8) -> int8x8x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld2.v8i8")]
        fn _vld2_s8(ptr: *const i8, size: i32) -> int8x8x2_t;
    }
    _vld2_s8(a as *const i8, 1)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(vld2))]
pub unsafe fn vld2q_s8(a: *const i8) -> int8x16x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld2.v16i8")]
        fn _vld2q_s8(ptr: *const i8, size: i32) -> int8x16x2_t;
    }
    _vld2q_s8(a as *const i8, 1)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(vld2))]
pub unsafe fn vld2_s16(a: *const i16) -> int16x4x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld2.v4i16")]
        fn _vld2_s16(ptr: *const i8, size: i32) -> int16x4x2_t;
    }
    _vld2_s16(a as *const i8, 2)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(vld2))]
pub unsafe fn vld2q_s16(a: *const i16) -> int16x8x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld2.v8i16")]
        fn _vld2q_s16(ptr: *const i8, size: i32) -> int16x8x2_t;
    }
    _vld2q_s16(a as *const i8, 2)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(vld2))]
pub unsafe fn vld2_s32(a: *const i32) -> int32x2x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld2.v2i32")]
        fn _vld2_s32(ptr: *const i8, size: i32) -> int32x2x2_t;
    }
    _vld2_s32(a as *const i8, 4)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(vld2))]
pub unsafe fn vld2q_s32(a: *const i32) -> int32x4x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld2.v4i32")]
        fn _vld2q_s32(ptr: *const i8, size: i32) -> int32x4x2_t;
    }
    _vld2q_s32(a as *const i8, 4)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld2))]
pub unsafe fn vld2_f32(a: *const f32) -> float32x2x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2.v2f32.p0"
        )]
        fn _vld2_f32(ptr: *const float32x2_t) -> float32x2x2_t;
    }
    _vld2_f32(a as _)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld2))]
pub unsafe fn vld2q_f32(a: *const f32) -> float32x4x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2.v4f32.p0"
        )]
        fn _vld2q_f32(ptr: *const float32x4_t) -> float32x4x2_t;
    }
    _vld2q_f32(a as _)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld2))]
pub unsafe fn vld2_s8(a: *const i8) -> int8x8x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2.v8i8.p0"
        )]
        fn _vld2_s8(ptr: *const int8x8_t) -> int8x8x2_t;
    }
    _vld2_s8(a as _)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld2))]
pub unsafe fn vld2q_s8(a: *const i8) -> int8x16x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2.v16i8.p0"
        )]
        fn _vld2q_s8(ptr: *const int8x16_t) -> int8x16x2_t;
    }
    _vld2q_s8(a as _)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld2))]
pub unsafe fn vld2_s16(a: *const i16) -> int16x4x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2.v4i16.p0"
        )]
        fn _vld2_s16(ptr: *const int16x4_t) -> int16x4x2_t;
    }
    _vld2_s16(a as _)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld2))]
pub unsafe fn vld2q_s16(a: *const i16) -> int16x8x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2.v8i16.p0"
        )]
        fn _vld2q_s16(ptr: *const int16x8_t) -> int16x8x2_t;
    }
    _vld2q_s16(a as _)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld2))]
pub unsafe fn vld2_s32(a: *const i32) -> int32x2x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2.v2i32.p0"
        )]
        fn _vld2_s32(ptr: *const int32x2_t) -> int32x2x2_t;
    }
    _vld2_s32(a as _)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld2))]
pub unsafe fn vld2q_s32(a: *const i32) -> int32x4x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2.v4i32.p0"
        )]
        fn _vld2q_s32(ptr: *const int32x4_t) -> int32x4x2_t;
    }
    _vld2q_s32(a as _)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_lane_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld2_lane_f16<const LANE: i32>(a: *const f16, b: float16x4x2_t) -> float16x4x2_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld2lane.v4f16.p0")]
        fn _vld2_lane_f16(
            ptr: *const f16,
            a: float16x4_t,
            b: float16x4_t,
            n: i32,
            size: i32,
        ) -> float16x4x2_t;
    }
    _vld2_lane_f16(a as _, b.0, b.1, LANE, 2)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_lane_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld2q_lane_f16<const LANE: i32>(a: *const f16, b: float16x8x2_t) -> float16x8x2_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld2lane.v8f16.p0")]
        fn _vld2q_lane_f16(
            ptr: *const f16,
            a: float16x8_t,
            b: float16x8_t,
            n: i32,
            size: i32,
        ) -> float16x8x2_t;
    }
    _vld2q_lane_f16(a as _, b.0, b.1, LANE, 2)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_lane_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2, LANE = 0)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld2_lane_f16<const LANE: i32>(a: *const f16, b: float16x4x2_t) -> float16x4x2_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2lane.v4f16.p0"
        )]
        fn _vld2_lane_f16(a: float16x4_t, b: float16x4_t, n: i64, ptr: *const f16)
            -> float16x4x2_t;
    }
    _vld2_lane_f16(b.0, b.1, LANE as i64, a as _)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_lane_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2, LANE = 0)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld2q_lane_f16<const LANE: i32>(a: *const f16, b: float16x8x2_t) -> float16x8x2_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2lane.v8f16.p0"
        )]
        fn _vld2q_lane_f16(
            a: float16x8_t,
            b: float16x8_t,
            n: i64,
            ptr: *const f16,
        ) -> float16x8x2_t;
    }
    _vld2q_lane_f16(b.0, b.1, LANE as i64, a as _)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_lane_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(ld2, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld2_lane_f32<const LANE: i32>(a: *const f32, b: float32x2x2_t) -> float32x2x2_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2lane.v2f32.p0"
        )]
        fn _vld2_lane_f32(a: float32x2_t, b: float32x2_t, n: i64, ptr: *const i8) -> float32x2x2_t;
    }
    _vld2_lane_f32(b.0, b.1, LANE as i64, a as _)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_lane_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(ld2, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld2q_lane_f32<const LANE: i32>(a: *const f32, b: float32x4x2_t) -> float32x4x2_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2lane.v4f32.p0"
        )]
        fn _vld2q_lane_f32(a: float32x4_t, b: float32x4_t, n: i64, ptr: *const i8)
            -> float32x4x2_t;
    }
    _vld2q_lane_f32(b.0, b.1, LANE as i64, a as _)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_lane_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(ld2, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld2_lane_s8<const LANE: i32>(a: *const i8, b: int8x8x2_t) -> int8x8x2_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2lane.v8i8.p0"
        )]
        fn _vld2_lane_s8(a: int8x8_t, b: int8x8_t, n: i64, ptr: *const i8) -> int8x8x2_t;
    }
    _vld2_lane_s8(b.0, b.1, LANE as i64, a as _)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_lane_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(ld2, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld2_lane_s16<const LANE: i32>(a: *const i16, b: int16x4x2_t) -> int16x4x2_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2lane.v4i16.p0"
        )]
        fn _vld2_lane_s16(a: int16x4_t, b: int16x4_t, n: i64, ptr: *const i8) -> int16x4x2_t;
    }
    _vld2_lane_s16(b.0, b.1, LANE as i64, a as _)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_lane_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(ld2, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld2q_lane_s16<const LANE: i32>(a: *const i16, b: int16x8x2_t) -> int16x8x2_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2lane.v8i16.p0"
        )]
        fn _vld2q_lane_s16(a: int16x8_t, b: int16x8_t, n: i64, ptr: *const i8) -> int16x8x2_t;
    }
    _vld2q_lane_s16(b.0, b.1, LANE as i64, a as _)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_lane_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(ld2, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld2_lane_s32<const LANE: i32>(a: *const i32, b: int32x2x2_t) -> int32x2x2_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2lane.v2i32.p0"
        )]
        fn _vld2_lane_s32(a: int32x2_t, b: int32x2_t, n: i64, ptr: *const i8) -> int32x2x2_t;
    }
    _vld2_lane_s32(b.0, b.1, LANE as i64, a as _)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_lane_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(ld2, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld2q_lane_s32<const LANE: i32>(a: *const i32, b: int32x4x2_t) -> int32x4x2_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2lane.v4i32.p0"
        )]
        fn _vld2q_lane_s32(a: int32x4_t, b: int32x4_t, n: i64, ptr: *const i8) -> int32x4x2_t;
    }
    _vld2q_lane_s32(b.0, b.1, LANE as i64, a as _)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_lane_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[cfg_attr(test, assert_instr(vld2, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
pub unsafe fn vld2_lane_f32<const LANE: i32>(a: *const f32, b: float32x2x2_t) -> float32x2x2_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld2lane.v2f32.p0")]
        fn _vld2_lane_f32(
            ptr: *const i8,
            a: float32x2_t,
            b: float32x2_t,
            n: i32,
            size: i32,
        ) -> float32x2x2_t;
    }
    _vld2_lane_f32(a as _, b.0, b.1, LANE, 4)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_lane_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[cfg_attr(test, assert_instr(vld2, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
pub unsafe fn vld2q_lane_f32<const LANE: i32>(a: *const f32, b: float32x4x2_t) -> float32x4x2_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld2lane.v4f32.p0")]
        fn _vld2q_lane_f32(
            ptr: *const i8,
            a: float32x4_t,
            b: float32x4_t,
            n: i32,
            size: i32,
        ) -> float32x4x2_t;
    }
    _vld2q_lane_f32(a as _, b.0, b.1, LANE, 4)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_lane_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[cfg_attr(test, assert_instr(vld2, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
pub unsafe fn vld2q_lane_s16<const LANE: i32>(a: *const i16, b: int16x8x2_t) -> int16x8x2_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld2lane.v8i16.p0")]
        fn _vld2q_lane_s16(
            ptr: *const i8,
            a: int16x8_t,
            b: int16x8_t,
            n: i32,
            size: i32,
        ) -> int16x8x2_t;
    }
    _vld2q_lane_s16(a as _, b.0, b.1, LANE, 2)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_lane_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[cfg_attr(test, assert_instr(vld2, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
pub unsafe fn vld2q_lane_s32<const LANE: i32>(a: *const i32, b: int32x4x2_t) -> int32x4x2_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld2lane.v4i32.p0")]
        fn _vld2q_lane_s32(
            ptr: *const i8,
            a: int32x4_t,
            b: int32x4_t,
            n: i32,
            size: i32,
        ) -> int32x4x2_t;
    }
    _vld2q_lane_s32(a as _, b.0, b.1, LANE, 4)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_lane_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[cfg_attr(test, assert_instr(vld2, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
pub unsafe fn vld2_lane_s8<const LANE: i32>(a: *const i8, b: int8x8x2_t) -> int8x8x2_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld2lane.v8i8.p0")]
        fn _vld2_lane_s8(ptr: *const i8, a: int8x8_t, b: int8x8_t, n: i32, size: i32)
            -> int8x8x2_t;
    }
    _vld2_lane_s8(a as _, b.0, b.1, LANE, 1)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_lane_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[cfg_attr(test, assert_instr(vld2, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
pub unsafe fn vld2_lane_s16<const LANE: i32>(a: *const i16, b: int16x4x2_t) -> int16x4x2_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld2lane.v4i16.p0")]
        fn _vld2_lane_s16(
            ptr: *const i8,
            a: int16x4_t,
            b: int16x4_t,
            n: i32,
            size: i32,
        ) -> int16x4x2_t;
    }
    _vld2_lane_s16(a as _, b.0, b.1, LANE, 2)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_lane_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[cfg_attr(test, assert_instr(vld2, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
pub unsafe fn vld2_lane_s32<const LANE: i32>(a: *const i32, b: int32x2x2_t) -> int32x2x2_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld2lane.v2i32.p0")]
        fn _vld2_lane_s32(
            ptr: *const i8,
            a: int32x2_t,
            b: int32x2_t,
            n: i32,
            size: i32,
        ) -> int32x2x2_t;
    }
    _vld2_lane_s32(a as _, b.0, b.1, LANE, 4)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_lane_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2, LANE = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2, LANE = 0)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2_lane_u8<const LANE: i32>(a: *const u8, b: uint8x8x2_t) -> uint8x8x2_t {
    static_assert_uimm_bits!(LANE, 3);
    transmute(vld2_lane_s8::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_lane_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2, LANE = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2, LANE = 0)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2_lane_u16<const LANE: i32>(a: *const u16, b: uint16x4x2_t) -> uint16x4x2_t {
    static_assert_uimm_bits!(LANE, 2);
    transmute(vld2_lane_s16::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_lane_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2, LANE = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2, LANE = 0)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2q_lane_u16<const LANE: i32>(a: *const u16, b: uint16x8x2_t) -> uint16x8x2_t {
    static_assert_uimm_bits!(LANE, 3);
    transmute(vld2q_lane_s16::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_lane_u32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2, LANE = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2, LANE = 0)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2_lane_u32<const LANE: i32>(a: *const u32, b: uint32x2x2_t) -> uint32x2x2_t {
    static_assert_uimm_bits!(LANE, 1);
    transmute(vld2_lane_s32::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_lane_u32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2, LANE = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2, LANE = 0)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2q_lane_u32<const LANE: i32>(a: *const u32, b: uint32x4x2_t) -> uint32x4x2_t {
    static_assert_uimm_bits!(LANE, 2);
    transmute(vld2q_lane_s32::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_lane_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2, LANE = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2, LANE = 0)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2_lane_p8<const LANE: i32>(a: *const p8, b: poly8x8x2_t) -> poly8x8x2_t {
    static_assert_uimm_bits!(LANE, 3);
    transmute(vld2_lane_s8::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_lane_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2, LANE = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2, LANE = 0)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2_lane_p16<const LANE: i32>(a: *const p16, b: poly16x4x2_t) -> poly16x4x2_t {
    static_assert_uimm_bits!(LANE, 2);
    transmute(vld2_lane_s16::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_lane_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2, LANE = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2, LANE = 0)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2q_lane_p16<const LANE: i32>(a: *const p16, b: poly16x8x2_t) -> poly16x8x2_t {
    static_assert_uimm_bits!(LANE, 3);
    transmute(vld2q_lane_s16::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_p64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,aes")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2_p64(a: *const p64) -> poly64x1x2_t {
    transmute(vld2_s64(transmute(a)))
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_s64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(nop))]
pub unsafe fn vld2_s64(a: *const i64) -> int64x1x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld2.v1i64")]
        fn _vld2_s64(ptr: *const i8, size: i32) -> int64x1x2_t;
    }
    _vld2_s64(a as *const i8, 8)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_s64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(nop))]
pub unsafe fn vld2_s64(a: *const i64) -> int64x1x2_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld2.v1i64.p0"
        )]
        fn _vld2_s64(ptr: *const int64x1_t) -> int64x1x2_t;
    }
    _vld2_s64(a as _)
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_u64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2_u64(a: *const u64) -> uint64x1x2_t {
    transmute(vld2_s64(transmute(a)))
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2_u8(a: *const u8) -> uint8x8x2_t {
    transmute(vld2_s8(transmute(a)))
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2_u8(a: *const u8) -> uint8x8x2_t {
    let mut ret_val: uint8x8x2_t = transmute(vld2_s8(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2q_u8(a: *const u8) -> uint8x16x2_t {
    transmute(vld2q_s8(transmute(a)))
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2q_u8(a: *const u8) -> uint8x16x2_t {
    let mut ret_val: uint8x16x2_t = transmute(vld2q_s8(transmute(a)));
    ret_val.0 = unsafe {
        simd_shuffle!(
            ret_val.0,
            ret_val.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val.1 = unsafe {
        simd_shuffle!(
            ret_val.1,
            ret_val.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2_u16(a: *const u16) -> uint16x4x2_t {
    transmute(vld2_s16(transmute(a)))
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2_u16(a: *const u16) -> uint16x4x2_t {
    let mut ret_val: uint16x4x2_t = transmute(vld2_s16(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2q_u16(a: *const u16) -> uint16x8x2_t {
    transmute(vld2q_s16(transmute(a)))
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2q_u16(a: *const u16) -> uint16x8x2_t {
    let mut ret_val: uint16x8x2_t = transmute(vld2q_s16(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_u32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2_u32(a: *const u32) -> uint32x2x2_t {
    transmute(vld2_s32(transmute(a)))
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_u32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2_u32(a: *const u32) -> uint32x2x2_t {
    let mut ret_val: uint32x2x2_t = transmute(vld2_s32(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [1, 0]) };
    ret_val
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_u32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2q_u32(a: *const u32) -> uint32x4x2_t {
    transmute(vld2q_s32(transmute(a)))
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_u32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2q_u32(a: *const u32) -> uint32x4x2_t {
    let mut ret_val: uint32x4x2_t = transmute(vld2q_s32(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2_p8(a: *const p8) -> poly8x8x2_t {
    transmute(vld2_s8(transmute(a)))
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2_p8(a: *const p8) -> poly8x8x2_t {
    let mut ret_val: poly8x8x2_t = transmute(vld2_s8(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2q_p8(a: *const p8) -> poly8x16x2_t {
    transmute(vld2q_s8(transmute(a)))
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2q_p8(a: *const p8) -> poly8x16x2_t {
    let mut ret_val: poly8x16x2_t = transmute(vld2q_s8(transmute(a)));
    ret_val.0 = unsafe {
        simd_shuffle!(
            ret_val.0,
            ret_val.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val.1 = unsafe {
        simd_shuffle!(
            ret_val.1,
            ret_val.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2_p16(a: *const p16) -> poly16x4x2_t {
    transmute(vld2_s16(transmute(a)))
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2_p16(a: *const p16) -> poly16x4x2_t {
    let mut ret_val: poly16x4x2_t = transmute(vld2_s16(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2q_p16(a: *const p16) -> poly16x8x2_t {
    transmute(vld2q_s16(transmute(a)))
}
#[doc = "Load multiple 2-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld2q_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld2))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld2)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld2q_p16(a: *const p16) -> poly16x8x2_t {
    let mut ret_val: poly16x8x2_t = transmute(vld2q_s16(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load single 3-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_dup_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg(target_arch = "arm")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld3_dup_f16(a: *const f16) -> float16x4x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld3dup.v4f16.p0")]
        fn _vld3_dup_f16(ptr: *const f16, size: i32) -> float16x4x3_t;
    }
    _vld3_dup_f16(a as _, 2)
}
#[doc = "Load single 3-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_dup_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg(target_arch = "arm")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld3q_dup_f16(a: *const f16) -> float16x8x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld3dup.v8f16.p0")]
        fn _vld3q_dup_f16(ptr: *const f16, size: i32) -> float16x8x3_t;
    }
    _vld3q_dup_f16(a as _, 2)
}
#[doc = "Load single 3-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_dup_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3r)
)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld3_dup_f16(a: *const f16) -> float16x4x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3r.v4f16.p0"
        )]
        fn _vld3_dup_f16(ptr: *const f16) -> float16x4x3_t;
    }
    _vld3_dup_f16(a as _)
}
#[doc = "Load single 3-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_dup_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3r)
)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld3q_dup_f16(a: *const f16) -> float16x8x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3r.v8f16.p0"
        )]
        fn _vld3q_dup_f16(ptr: *const f16) -> float16x8x3_t;
    }
    _vld3q_dup_f16(a as _)
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_dup_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld3r))]
pub unsafe fn vld3_dup_f32(a: *const f32) -> float32x2x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3r.v2f32.p0"
        )]
        fn _vld3_dup_f32(ptr: *const f32) -> float32x2x3_t;
    }
    _vld3_dup_f32(a as _)
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_dup_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld3r))]
pub unsafe fn vld3q_dup_f32(a: *const f32) -> float32x4x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3r.v4f32.p0"
        )]
        fn _vld3q_dup_f32(ptr: *const f32) -> float32x4x3_t;
    }
    _vld3q_dup_f32(a as _)
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_dup_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld3r))]
pub unsafe fn vld3_dup_s8(a: *const i8) -> int8x8x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3r.v8i8.p0"
        )]
        fn _vld3_dup_s8(ptr: *const i8) -> int8x8x3_t;
    }
    _vld3_dup_s8(a as _)
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_dup_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld3r))]
pub unsafe fn vld3q_dup_s8(a: *const i8) -> int8x16x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3r.v16i8.p0"
        )]
        fn _vld3q_dup_s8(ptr: *const i8) -> int8x16x3_t;
    }
    _vld3q_dup_s8(a as _)
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_dup_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld3r))]
pub unsafe fn vld3_dup_s16(a: *const i16) -> int16x4x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3r.v4i16.p0"
        )]
        fn _vld3_dup_s16(ptr: *const i16) -> int16x4x3_t;
    }
    _vld3_dup_s16(a as _)
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_dup_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld3r))]
pub unsafe fn vld3q_dup_s16(a: *const i16) -> int16x8x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3r.v8i16.p0"
        )]
        fn _vld3q_dup_s16(ptr: *const i16) -> int16x8x3_t;
    }
    _vld3q_dup_s16(a as _)
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_dup_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld3r))]
pub unsafe fn vld3_dup_s32(a: *const i32) -> int32x2x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3r.v2i32.p0"
        )]
        fn _vld3_dup_s32(ptr: *const i32) -> int32x2x3_t;
    }
    _vld3_dup_s32(a as _)
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_dup_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld3r))]
pub unsafe fn vld3q_dup_s32(a: *const i32) -> int32x4x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3r.v4i32.p0"
        )]
        fn _vld3q_dup_s32(ptr: *const i32) -> int32x4x3_t;
    }
    _vld3q_dup_s32(a as _)
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_dup_s64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld3r))]
pub unsafe fn vld3_dup_s64(a: *const i64) -> int64x1x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3r.v1i64.p0"
        )]
        fn _vld3_dup_s64(ptr: *const i64) -> int64x1x3_t;
    }
    _vld3_dup_s64(a as _)
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_dup_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(vld3))]
pub unsafe fn vld3_dup_f32(a: *const f32) -> float32x2x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld3dup.v2f32.p0")]
        fn _vld3_dup_f32(ptr: *const i8, size: i32) -> float32x2x3_t;
    }
    _vld3_dup_f32(a as *const i8, 4)
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_dup_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(vld3))]
pub unsafe fn vld3q_dup_f32(a: *const f32) -> float32x4x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld3dup.v4f32.p0")]
        fn _vld3q_dup_f32(ptr: *const i8, size: i32) -> float32x4x3_t;
    }
    _vld3q_dup_f32(a as *const i8, 4)
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_dup_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(vld3))]
pub unsafe fn vld3_dup_s8(a: *const i8) -> int8x8x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld3dup.v8i8.p0")]
        fn _vld3_dup_s8(ptr: *const i8, size: i32) -> int8x8x3_t;
    }
    _vld3_dup_s8(a as *const i8, 1)
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_dup_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(vld3))]
pub unsafe fn vld3q_dup_s8(a: *const i8) -> int8x16x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld3dup.v16i8.p0")]
        fn _vld3q_dup_s8(ptr: *const i8, size: i32) -> int8x16x3_t;
    }
    _vld3q_dup_s8(a as *const i8, 1)
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_dup_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(vld3))]
pub unsafe fn vld3_dup_s16(a: *const i16) -> int16x4x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld3dup.v4i16.p0")]
        fn _vld3_dup_s16(ptr: *const i8, size: i32) -> int16x4x3_t;
    }
    _vld3_dup_s16(a as *const i8, 2)
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_dup_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(vld3))]
pub unsafe fn vld3q_dup_s16(a: *const i16) -> int16x8x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld3dup.v8i16.p0")]
        fn _vld3q_dup_s16(ptr: *const i8, size: i32) -> int16x8x3_t;
    }
    _vld3q_dup_s16(a as *const i8, 2)
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_dup_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(vld3))]
pub unsafe fn vld3_dup_s32(a: *const i32) -> int32x2x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld3dup.v2i32.p0")]
        fn _vld3_dup_s32(ptr: *const i8, size: i32) -> int32x2x3_t;
    }
    _vld3_dup_s32(a as *const i8, 4)
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_dup_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(vld3))]
pub unsafe fn vld3q_dup_s32(a: *const i32) -> int32x4x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld3dup.v4i32.p0")]
        fn _vld3q_dup_s32(ptr: *const i8, size: i32) -> int32x4x3_t;
    }
    _vld3q_dup_s32(a as *const i8, 4)
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_dup_p64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,aes")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3_dup_p64(a: *const p64) -> poly64x1x3_t {
    transmute(vld3_dup_s64(transmute(a)))
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_dup_s64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(nop))]
pub unsafe fn vld3_dup_s64(a: *const i64) -> int64x1x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld3dup.v1i64.p0")]
        fn _vld3_dup_s64(ptr: *const i8, size: i32) -> int64x1x3_t;
    }
    _vld3_dup_s64(a as *const i8, 8)
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_dup_u64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3_dup_u64(a: *const u64) -> uint64x1x3_t {
    transmute(vld3_dup_s64(transmute(a)))
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_dup_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3_dup_u8(a: *const u8) -> uint8x8x3_t {
    transmute(vld3_dup_s8(transmute(a)))
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_dup_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3_dup_u8(a: *const u8) -> uint8x8x3_t {
    let mut ret_val: uint8x8x3_t = transmute(vld3_dup_s8(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_dup_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3q_dup_u8(a: *const u8) -> uint8x16x3_t {
    transmute(vld3q_dup_s8(transmute(a)))
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_dup_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3q_dup_u8(a: *const u8) -> uint8x16x3_t {
    let mut ret_val: uint8x16x3_t = transmute(vld3q_dup_s8(transmute(a)));
    ret_val.0 = unsafe {
        simd_shuffle!(
            ret_val.0,
            ret_val.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val.1 = unsafe {
        simd_shuffle!(
            ret_val.1,
            ret_val.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val.2 = unsafe {
        simd_shuffle!(
            ret_val.2,
            ret_val.2,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_dup_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3_dup_u16(a: *const u16) -> uint16x4x3_t {
    transmute(vld3_dup_s16(transmute(a)))
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_dup_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3_dup_u16(a: *const u16) -> uint16x4x3_t {
    let mut ret_val: uint16x4x3_t = transmute(vld3_dup_s16(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_dup_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3q_dup_u16(a: *const u16) -> uint16x8x3_t {
    transmute(vld3q_dup_s16(transmute(a)))
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_dup_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3q_dup_u16(a: *const u16) -> uint16x8x3_t {
    let mut ret_val: uint16x8x3_t = transmute(vld3q_dup_s16(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_dup_u32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3_dup_u32(a: *const u32) -> uint32x2x3_t {
    transmute(vld3_dup_s32(transmute(a)))
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_dup_u32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3_dup_u32(a: *const u32) -> uint32x2x3_t {
    let mut ret_val: uint32x2x3_t = transmute(vld3_dup_s32(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [1, 0]) };
    ret_val
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_dup_u32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3q_dup_u32(a: *const u32) -> uint32x4x3_t {
    transmute(vld3q_dup_s32(transmute(a)))
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_dup_u32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3q_dup_u32(a: *const u32) -> uint32x4x3_t {
    let mut ret_val: uint32x4x3_t = transmute(vld3q_dup_s32(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_dup_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3_dup_p8(a: *const p8) -> poly8x8x3_t {
    transmute(vld3_dup_s8(transmute(a)))
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_dup_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3_dup_p8(a: *const p8) -> poly8x8x3_t {
    let mut ret_val: poly8x8x3_t = transmute(vld3_dup_s8(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_dup_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3q_dup_p8(a: *const p8) -> poly8x16x3_t {
    transmute(vld3q_dup_s8(transmute(a)))
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_dup_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3q_dup_p8(a: *const p8) -> poly8x16x3_t {
    let mut ret_val: poly8x16x3_t = transmute(vld3q_dup_s8(transmute(a)));
    ret_val.0 = unsafe {
        simd_shuffle!(
            ret_val.0,
            ret_val.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val.1 = unsafe {
        simd_shuffle!(
            ret_val.1,
            ret_val.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val.2 = unsafe {
        simd_shuffle!(
            ret_val.2,
            ret_val.2,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_dup_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3_dup_p16(a: *const p16) -> poly16x4x3_t {
    transmute(vld3_dup_s16(transmute(a)))
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_dup_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3_dup_p16(a: *const p16) -> poly16x4x3_t {
    let mut ret_val: poly16x4x3_t = transmute(vld3_dup_s16(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_dup_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3q_dup_p16(a: *const p16) -> poly16x8x3_t {
    transmute(vld3q_dup_s16(transmute(a)))
}
#[doc = "Load single 3-element structure and replicate to all lanes of three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_dup_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3q_dup_p16(a: *const p16) -> poly16x8x3_t {
    let mut ret_val: poly16x8x3_t = transmute(vld3q_dup_s16(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load single 3-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg(target_arch = "arm")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld3_f16(a: *const f16) -> float16x4x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld3.v4f16.p0")]
        fn _vld3_f16(ptr: *const f16, size: i32) -> float16x4x3_t;
    }
    _vld3_f16(a as _, 2)
}
#[doc = "Load single 3-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg(target_arch = "arm")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld3q_f16(a: *const f16) -> float16x8x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld3.v8f16.p0")]
        fn _vld3q_f16(ptr: *const f16, size: i32) -> float16x8x3_t;
    }
    _vld3q_f16(a as _, 2)
}
#[doc = "Load single 3-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3)
)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld3_f16(a: *const f16) -> float16x4x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3.v4f16.p0"
        )]
        fn _vld3_f16(ptr: *const f16) -> float16x4x3_t;
    }
    _vld3_f16(a as _)
}
#[doc = "Load single 3-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3)
)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld3q_f16(a: *const f16) -> float16x8x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3.v8f16.p0"
        )]
        fn _vld3q_f16(ptr: *const f16) -> float16x8x3_t;
    }
    _vld3q_f16(a as _)
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(ld3))]
pub unsafe fn vld3_f32(a: *const f32) -> float32x2x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3.v2f32.p0"
        )]
        fn _vld3_f32(ptr: *const float32x2_t) -> float32x2x3_t;
    }
    _vld3_f32(a as _)
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(ld3))]
pub unsafe fn vld3q_f32(a: *const f32) -> float32x4x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3.v4f32.p0"
        )]
        fn _vld3q_f32(ptr: *const float32x4_t) -> float32x4x3_t;
    }
    _vld3q_f32(a as _)
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(ld3))]
pub unsafe fn vld3_s8(a: *const i8) -> int8x8x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3.v8i8.p0"
        )]
        fn _vld3_s8(ptr: *const int8x8_t) -> int8x8x3_t;
    }
    _vld3_s8(a as _)
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(ld3))]
pub unsafe fn vld3q_s8(a: *const i8) -> int8x16x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3.v16i8.p0"
        )]
        fn _vld3q_s8(ptr: *const int8x16_t) -> int8x16x3_t;
    }
    _vld3q_s8(a as _)
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(ld3))]
pub unsafe fn vld3_s16(a: *const i16) -> int16x4x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3.v4i16.p0"
        )]
        fn _vld3_s16(ptr: *const int16x4_t) -> int16x4x3_t;
    }
    _vld3_s16(a as _)
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(ld3))]
pub unsafe fn vld3q_s16(a: *const i16) -> int16x8x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3.v8i16.p0"
        )]
        fn _vld3q_s16(ptr: *const int16x8_t) -> int16x8x3_t;
    }
    _vld3q_s16(a as _)
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(ld3))]
pub unsafe fn vld3_s32(a: *const i32) -> int32x2x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3.v2i32.p0"
        )]
        fn _vld3_s32(ptr: *const int32x2_t) -> int32x2x3_t;
    }
    _vld3_s32(a as _)
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(ld3))]
pub unsafe fn vld3q_s32(a: *const i32) -> int32x4x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3.v4i32.p0"
        )]
        fn _vld3q_s32(ptr: *const int32x4_t) -> int32x4x3_t;
    }
    _vld3q_s32(a as _)
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(vld3))]
pub unsafe fn vld3_f32(a: *const f32) -> float32x2x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld3.v2f32.p0")]
        fn _vld3_f32(ptr: *const i8, size: i32) -> float32x2x3_t;
    }
    _vld3_f32(a as *const i8, 4)
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(vld3))]
pub unsafe fn vld3q_f32(a: *const f32) -> float32x4x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld3.v4f32.p0")]
        fn _vld3q_f32(ptr: *const i8, size: i32) -> float32x4x3_t;
    }
    _vld3q_f32(a as *const i8, 4)
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(vld3))]
pub unsafe fn vld3_s8(a: *const i8) -> int8x8x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld3.v8i8.p0")]
        fn _vld3_s8(ptr: *const i8, size: i32) -> int8x8x3_t;
    }
    _vld3_s8(a as *const i8, 1)
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(vld3))]
pub unsafe fn vld3q_s8(a: *const i8) -> int8x16x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld3.v16i8.p0")]
        fn _vld3q_s8(ptr: *const i8, size: i32) -> int8x16x3_t;
    }
    _vld3q_s8(a as *const i8, 1)
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(vld3))]
pub unsafe fn vld3_s16(a: *const i16) -> int16x4x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld3.v4i16.p0")]
        fn _vld3_s16(ptr: *const i8, size: i32) -> int16x4x3_t;
    }
    _vld3_s16(a as *const i8, 2)
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(vld3))]
pub unsafe fn vld3q_s16(a: *const i16) -> int16x8x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld3.v8i16.p0")]
        fn _vld3q_s16(ptr: *const i8, size: i32) -> int16x8x3_t;
    }
    _vld3q_s16(a as *const i8, 2)
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(vld3))]
pub unsafe fn vld3_s32(a: *const i32) -> int32x2x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld3.v2i32.p0")]
        fn _vld3_s32(ptr: *const i8, size: i32) -> int32x2x3_t;
    }
    _vld3_s32(a as *const i8, 4)
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(vld3))]
pub unsafe fn vld3q_s32(a: *const i32) -> int32x4x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld3.v4i32.p0")]
        fn _vld3q_s32(ptr: *const i8, size: i32) -> int32x4x3_t;
    }
    _vld3q_s32(a as *const i8, 4)
}
#[doc = "Load multiple 3-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_lane_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld3_lane_f16<const LANE: i32>(a: *const f16, b: float16x4x3_t) -> float16x4x3_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld3lane.v4f16.p0")]
        fn _vld3_lane_f16(
            ptr: *const f16,
            a: float16x4_t,
            b: float16x4_t,
            c: float16x4_t,
            n: i32,
            size: i32,
        ) -> float16x4x3_t;
    }
    _vld3_lane_f16(a as _, b.0, b.1, b.2, LANE, 2)
}
#[doc = "Load multiple 3-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_lane_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,v7")]
#[cfg(target_arch = "arm")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld3q_lane_f16<const LANE: i32>(a: *const f16, b: float16x8x3_t) -> float16x8x3_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld3lane.v8f16.p0")]
        fn _vld3q_lane_f16(
            ptr: *const f16,
            a: float16x8_t,
            b: float16x8_t,
            c: float16x8_t,
            n: i32,
            size: i32,
        ) -> float16x8x3_t;
    }
    _vld3q_lane_f16(a as _, b.0, b.1, b.2, LANE, 2)
}
#[doc = "Load multiple 3-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_lane_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3, LANE = 0)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld3_lane_f16<const LANE: i32>(a: *const f16, b: float16x4x3_t) -> float16x4x3_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3lane.v4f16.p0"
        )]
        fn _vld3_lane_f16(
            a: float16x4_t,
            b: float16x4_t,
            c: float16x4_t,
            n: i64,
            ptr: *const f16,
        ) -> float16x4x3_t;
    }
    _vld3_lane_f16(b.0, b.1, b.2, LANE as i64, a as _)
}
#[doc = "Load multiple 3-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_lane_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3, LANE = 0)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(target_arch = "arm", target_feature(enable = "fp16"))]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld3q_lane_f16<const LANE: i32>(a: *const f16, b: float16x8x3_t) -> float16x8x3_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3lane.v8f16.p0"
        )]
        fn _vld3q_lane_f16(
            a: float16x8_t,
            b: float16x8_t,
            c: float16x8_t,
            n: i64,
            ptr: *const f16,
        ) -> float16x8x3_t;
    }
    _vld3q_lane_f16(b.0, b.1, b.2, LANE as i64, a as _)
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_lane_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(ld3, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld3_lane_f32<const LANE: i32>(a: *const f32, b: float32x2x3_t) -> float32x2x3_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3lane.v2f32.p0"
        )]
        fn _vld3_lane_f32(
            a: float32x2_t,
            b: float32x2_t,
            c: float32x2_t,
            n: i64,
            ptr: *const i8,
        ) -> float32x2x3_t;
    }
    _vld3_lane_f32(b.0, b.1, b.2, LANE as i64, a as _)
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_lane_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(ld3, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld3q_lane_f32<const LANE: i32>(a: *const f32, b: float32x4x3_t) -> float32x4x3_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3lane.v4f32.p0"
        )]
        fn _vld3q_lane_f32(
            a: float32x4_t,
            b: float32x4_t,
            c: float32x4_t,
            n: i64,
            ptr: *const i8,
        ) -> float32x4x3_t;
    }
    _vld3q_lane_f32(b.0, b.1, b.2, LANE as i64, a as _)
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_lane_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(test, assert_instr(vld3, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
pub unsafe fn vld3_lane_f32<const LANE: i32>(a: *const f32, b: float32x2x3_t) -> float32x2x3_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld3lane.v2f32.p0")]
        fn _vld3_lane_f32(
            ptr: *const i8,
            a: float32x2_t,
            b: float32x2_t,
            c: float32x2_t,
            n: i32,
            size: i32,
        ) -> float32x2x3_t;
    }
    _vld3_lane_f32(a as _, b.0, b.1, b.2, LANE, 4)
}
#[doc = "Load multiple 3-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_lane_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(ld3, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld3_lane_s8<const LANE: i32>(a: *const i8, b: int8x8x3_t) -> int8x8x3_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3lane.v8i8.p0"
        )]
        fn _vld3_lane_s8(
            a: int8x8_t,
            b: int8x8_t,
            c: int8x8_t,
            n: i64,
            ptr: *const i8,
        ) -> int8x8x3_t;
    }
    _vld3_lane_s8(b.0, b.1, b.2, LANE as i64, a as _)
}
#[doc = "Load multiple 3-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_lane_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(ld3, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld3_lane_s16<const LANE: i32>(a: *const i16, b: int16x4x3_t) -> int16x4x3_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3lane.v4i16.p0"
        )]
        fn _vld3_lane_s16(
            a: int16x4_t,
            b: int16x4_t,
            c: int16x4_t,
            n: i64,
            ptr: *const i8,
        ) -> int16x4x3_t;
    }
    _vld3_lane_s16(b.0, b.1, b.2, LANE as i64, a as _)
}
#[doc = "Load multiple 3-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_lane_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(ld3, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld3q_lane_s16<const LANE: i32>(a: *const i16, b: int16x8x3_t) -> int16x8x3_t {
    static_assert_uimm_bits!(LANE, 4);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3lane.v8i16.p0"
        )]
        fn _vld3q_lane_s16(
            a: int16x8_t,
            b: int16x8_t,
            c: int16x8_t,
            n: i64,
            ptr: *const i8,
        ) -> int16x8x3_t;
    }
    _vld3q_lane_s16(b.0, b.1, b.2, LANE as i64, a as _)
}
#[doc = "Load multiple 3-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_lane_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(ld3, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld3_lane_s32<const LANE: i32>(a: *const i32, b: int32x2x3_t) -> int32x2x3_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3lane.v2i32.p0"
        )]
        fn _vld3_lane_s32(
            a: int32x2_t,
            b: int32x2_t,
            c: int32x2_t,
            n: i64,
            ptr: *const i8,
        ) -> int32x2x3_t;
    }
    _vld3_lane_s32(b.0, b.1, b.2, LANE as i64, a as _)
}
#[doc = "Load multiple 3-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_lane_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(ld3, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld3q_lane_s32<const LANE: i32>(a: *const i32, b: int32x4x3_t) -> int32x4x3_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3lane.v4i32.p0"
        )]
        fn _vld3q_lane_s32(
            a: int32x4_t,
            b: int32x4_t,
            c: int32x4_t,
            n: i64,
            ptr: *const i8,
        ) -> int32x4x3_t;
    }
    _vld3q_lane_s32(b.0, b.1, b.2, LANE as i64, a as _)
}
#[doc = "Load multiple 3-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_lane_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(test, assert_instr(vld3, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
pub unsafe fn vld3_lane_s8<const LANE: i32>(a: *const i8, b: int8x8x3_t) -> int8x8x3_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld3lane.v8i8.p0")]
        fn _vld3_lane_s8(
            ptr: *const i8,
            a: int8x8_t,
            b: int8x8_t,
            c: int8x8_t,
            n: i32,
            size: i32,
        ) -> int8x8x3_t;
    }
    _vld3_lane_s8(a as _, b.0, b.1, b.2, LANE, 1)
}
#[doc = "Load multiple 3-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_lane_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(test, assert_instr(vld3, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
pub unsafe fn vld3_lane_s16<const LANE: i32>(a: *const i16, b: int16x4x3_t) -> int16x4x3_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld3lane.v4i16.p0")]
        fn _vld3_lane_s16(
            ptr: *const i8,
            a: int16x4_t,
            b: int16x4_t,
            c: int16x4_t,
            n: i32,
            size: i32,
        ) -> int16x4x3_t;
    }
    _vld3_lane_s16(a as _, b.0, b.1, b.2, LANE, 2)
}
#[doc = "Load multiple 3-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_lane_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(test, assert_instr(vld3, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
pub unsafe fn vld3q_lane_s16<const LANE: i32>(a: *const i16, b: int16x8x3_t) -> int16x8x3_t {
    static_assert_uimm_bits!(LANE, 3);
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld3lane.v8i16.p0")]
        fn _vld3q_lane_s16(
            ptr: *const i8,
            a: int16x8_t,
            b: int16x8_t,
            c: int16x8_t,
            n: i32,
            size: i32,
        ) -> int16x8x3_t;
    }
    _vld3q_lane_s16(a as _, b.0, b.1, b.2, LANE, 2)
}
#[doc = "Load multiple 3-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_lane_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(test, assert_instr(vld3, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
pub unsafe fn vld3_lane_s32<const LANE: i32>(a: *const i32, b: int32x2x3_t) -> int32x2x3_t {
    static_assert_uimm_bits!(LANE, 1);
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld3lane.v2i32.p0")]
        fn _vld3_lane_s32(
            ptr: *const i8,
            a: int32x2_t,
            b: int32x2_t,
            c: int32x2_t,
            n: i32,
            size: i32,
        ) -> int32x2x3_t;
    }
    _vld3_lane_s32(a as _, b.0, b.1, b.2, LANE, 4)
}
#[doc = "Load multiple 3-element structures to two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_lane_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(test, assert_instr(vld3, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
pub unsafe fn vld3q_lane_s32<const LANE: i32>(a: *const i32, b: int32x4x3_t) -> int32x4x3_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld3lane.v4i32.p0")]
        fn _vld3q_lane_s32(
            ptr: *const i8,
            a: int32x4_t,
            b: int32x4_t,
            c: int32x4_t,
            n: i32,
            size: i32,
        ) -> int32x4x3_t;
    }
    _vld3q_lane_s32(a as _, b.0, b.1, b.2, LANE, 4)
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_lane_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3, LANE = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3, LANE = 0)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3_lane_u8<const LANE: i32>(a: *const u8, b: uint8x8x3_t) -> uint8x8x3_t {
    static_assert_uimm_bits!(LANE, 3);
    transmute(vld3_lane_s8::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_lane_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3, LANE = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3, LANE = 0)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3_lane_u16<const LANE: i32>(a: *const u16, b: uint16x4x3_t) -> uint16x4x3_t {
    static_assert_uimm_bits!(LANE, 2);
    transmute(vld3_lane_s16::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_lane_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3, LANE = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3, LANE = 0)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3q_lane_u16<const LANE: i32>(a: *const u16, b: uint16x8x3_t) -> uint16x8x3_t {
    static_assert_uimm_bits!(LANE, 3);
    transmute(vld3q_lane_s16::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_lane_u32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3, LANE = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3, LANE = 0)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3_lane_u32<const LANE: i32>(a: *const u32, b: uint32x2x3_t) -> uint32x2x3_t {
    static_assert_uimm_bits!(LANE, 1);
    transmute(vld3_lane_s32::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_lane_u32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3, LANE = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3, LANE = 0)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3q_lane_u32<const LANE: i32>(a: *const u32, b: uint32x4x3_t) -> uint32x4x3_t {
    static_assert_uimm_bits!(LANE, 2);
    transmute(vld3q_lane_s32::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_lane_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3, LANE = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3, LANE = 0)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3_lane_p8<const LANE: i32>(a: *const p8, b: poly8x8x3_t) -> poly8x8x3_t {
    static_assert_uimm_bits!(LANE, 3);
    transmute(vld3_lane_s8::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_lane_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3, LANE = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3, LANE = 0)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3_lane_p16<const LANE: i32>(a: *const p16, b: poly16x4x3_t) -> poly16x4x3_t {
    static_assert_uimm_bits!(LANE, 2);
    transmute(vld3_lane_s16::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_lane_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3, LANE = 0))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3, LANE = 0)
)]
#[rustc_legacy_const_generics(2)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3q_lane_p16<const LANE: i32>(a: *const p16, b: poly16x8x3_t) -> poly16x8x3_t {
    static_assert_uimm_bits!(LANE, 3);
    transmute(vld3q_lane_s16::<LANE>(transmute(a), transmute(b)))
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_p64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,aes")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3_p64(a: *const p64) -> poly64x1x3_t {
    transmute(vld3_s64(transmute(a)))
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_s64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(nop))]
pub unsafe fn vld3_s64(a: *const i64) -> int64x1x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld3.v1i64.p0"
        )]
        fn _vld3_s64(ptr: *const int64x1_t) -> int64x1x3_t;
    }
    _vld3_s64(a as _)
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_s64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
#[cfg_attr(test, assert_instr(nop))]
pub unsafe fn vld3_s64(a: *const i64) -> int64x1x3_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld3.v1i64.p0")]
        fn _vld3_s64(ptr: *const i8, size: i32) -> int64x1x3_t;
    }
    _vld3_s64(a as *const i8, 8)
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_u64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(nop)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3_u64(a: *const u64) -> uint64x1x3_t {
    transmute(vld3_s64(transmute(a)))
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3_u8(a: *const u8) -> uint8x8x3_t {
    transmute(vld3_s8(transmute(a)))
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3_u8(a: *const u8) -> uint8x8x3_t {
    let mut ret_val: uint8x8x3_t = transmute(vld3_s8(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3q_u8(a: *const u8) -> uint8x16x3_t {
    transmute(vld3q_s8(transmute(a)))
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3q_u8(a: *const u8) -> uint8x16x3_t {
    let mut ret_val: uint8x16x3_t = transmute(vld3q_s8(transmute(a)));
    ret_val.0 = unsafe {
        simd_shuffle!(
            ret_val.0,
            ret_val.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val.1 = unsafe {
        simd_shuffle!(
            ret_val.1,
            ret_val.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val.2 = unsafe {
        simd_shuffle!(
            ret_val.2,
            ret_val.2,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3_u16(a: *const u16) -> uint16x4x3_t {
    transmute(vld3_s16(transmute(a)))
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3_u16(a: *const u16) -> uint16x4x3_t {
    let mut ret_val: uint16x4x3_t = transmute(vld3_s16(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3q_u16(a: *const u16) -> uint16x8x3_t {
    transmute(vld3q_s16(transmute(a)))
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3q_u16(a: *const u16) -> uint16x8x3_t {
    let mut ret_val: uint16x8x3_t = transmute(vld3q_s16(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_u32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3_u32(a: *const u32) -> uint32x2x3_t {
    transmute(vld3_s32(transmute(a)))
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_u32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3_u32(a: *const u32) -> uint32x2x3_t {
    let mut ret_val: uint32x2x3_t = transmute(vld3_s32(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [1, 0]) };
    ret_val
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_u32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3q_u32(a: *const u32) -> uint32x4x3_t {
    transmute(vld3q_s32(transmute(a)))
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_u32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3q_u32(a: *const u32) -> uint32x4x3_t {
    let mut ret_val: uint32x4x3_t = transmute(vld3q_s32(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3_p8(a: *const p8) -> poly8x8x3_t {
    transmute(vld3_s8(transmute(a)))
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3_p8(a: *const p8) -> poly8x8x3_t {
    let mut ret_val: poly8x8x3_t = transmute(vld3_s8(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3q_p8(a: *const p8) -> poly8x16x3_t {
    transmute(vld3q_s8(transmute(a)))
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3q_p8(a: *const p8) -> poly8x16x3_t {
    let mut ret_val: poly8x16x3_t = transmute(vld3q_s8(transmute(a)));
    ret_val.0 = unsafe {
        simd_shuffle!(
            ret_val.0,
            ret_val.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val.1 = unsafe {
        simd_shuffle!(
            ret_val.1,
            ret_val.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val.2 = unsafe {
        simd_shuffle!(
            ret_val.2,
            ret_val.2,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3_p16(a: *const p16) -> poly16x4x3_t {
    transmute(vld3_s16(transmute(a)))
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3_p16(a: *const p16) -> poly16x4x3_t {
    let mut ret_val: poly16x4x3_t = transmute(vld3_s16(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3q_p16(a: *const p16) -> poly16x8x3_t {
    transmute(vld3q_s16(transmute(a)))
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld3))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld3)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld3q_p16(a: *const p16) -> poly16x8x3_t {
    let mut ret_val: poly16x8x3_t = transmute(vld3q_s16(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load multiple 3-element structures to three registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld3q_lane_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(test, assert_instr(vld3, LANE = 0))]
#[rustc_legacy_const_generics(2)]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
pub unsafe fn vld3q_lane_f32<const LANE: i32>(a: *const f32, b: float32x4x3_t) -> float32x4x3_t {
    static_assert_uimm_bits!(LANE, 2);
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld3lane.v4f32.p0")]
        fn _vld3q_lane_f32(
            ptr: *const i8,
            a: float32x4_t,
            b: float32x4_t,
            c: float32x4_t,
            n: i32,
            size: i32,
        ) -> float32x4x3_t;
    }
    _vld3q_lane_f32(a as _, b.0, b.1, b.2, LANE, 4)
}
#[doc = "Load single 4-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_dup_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg(target_arch = "arm")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld4))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld4_dup_f16(a: *const f16) -> float16x4x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld4dup.v4f16.p0")]
        fn _vld4_dup_f16(ptr: *const f16, size: i32) -> float16x4x4_t;
    }
    _vld4_dup_f16(a as _, 2)
}
#[doc = "Load single 4-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_dup_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg(target_arch = "arm")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld4))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld4q_dup_f16(a: *const f16) -> float16x8x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld4dup.v8f16.p0")]
        fn _vld4q_dup_f16(ptr: *const f16, size: i32) -> float16x8x4_t;
    }
    _vld4q_dup_f16(a as _, 2)
}
#[doc = "Load single 4-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_dup_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld4r)
)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld4_dup_f16(a: *const f16) -> float16x4x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld4r.v4f16.p0"
        )]
        fn _vld4_dup_f16(ptr: *const f16) -> float16x4x4_t;
    }
    _vld4_dup_f16(a as _)
}
#[doc = "Load single 4-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_dup_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld4r)
)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld4q_dup_f16(a: *const f16) -> float16x8x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld4r.v8f16.p0"
        )]
        fn _vld4q_dup_f16(ptr: *const f16) -> float16x8x4_t;
    }
    _vld4q_dup_f16(a as _)
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_dup_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(test, assert_instr(vld4))]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
pub unsafe fn vld4_dup_f32(a: *const f32) -> float32x2x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld4dup.v2f32.p0")]
        fn _vld4_dup_f32(ptr: *const i8, size: i32) -> float32x2x4_t;
    }
    _vld4_dup_f32(a as *const i8, 4)
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_dup_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(test, assert_instr(vld4))]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
pub unsafe fn vld4q_dup_f32(a: *const f32) -> float32x4x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld4dup.v4f32.p0")]
        fn _vld4q_dup_f32(ptr: *const i8, size: i32) -> float32x4x4_t;
    }
    _vld4q_dup_f32(a as *const i8, 4)
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_dup_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(test, assert_instr(vld4))]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
pub unsafe fn vld4_dup_s8(a: *const i8) -> int8x8x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld4dup.v8i8.p0")]
        fn _vld4_dup_s8(ptr: *const i8, size: i32) -> int8x8x4_t;
    }
    _vld4_dup_s8(a as *const i8, 1)
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_dup_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(test, assert_instr(vld4))]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
pub unsafe fn vld4q_dup_s8(a: *const i8) -> int8x16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld4dup.v16i8.p0")]
        fn _vld4q_dup_s8(ptr: *const i8, size: i32) -> int8x16x4_t;
    }
    _vld4q_dup_s8(a as *const i8, 1)
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_dup_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(test, assert_instr(vld4))]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
pub unsafe fn vld4_dup_s16(a: *const i16) -> int16x4x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld4dup.v4i16.p0")]
        fn _vld4_dup_s16(ptr: *const i8, size: i32) -> int16x4x4_t;
    }
    _vld4_dup_s16(a as *const i8, 2)
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_dup_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(test, assert_instr(vld4))]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
pub unsafe fn vld4q_dup_s16(a: *const i16) -> int16x8x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld4dup.v8i16.p0")]
        fn _vld4q_dup_s16(ptr: *const i8, size: i32) -> int16x8x4_t;
    }
    _vld4q_dup_s16(a as *const i8, 2)
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_dup_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(test, assert_instr(vld4))]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
pub unsafe fn vld4_dup_s32(a: *const i32) -> int32x2x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld4dup.v2i32.p0")]
        fn _vld4_dup_s32(ptr: *const i8, size: i32) -> int32x2x4_t;
    }
    _vld4_dup_s32(a as *const i8, 4)
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_dup_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(test, assert_instr(vld4))]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
pub unsafe fn vld4q_dup_s32(a: *const i32) -> int32x4x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld4dup.v4i32.p0")]
        fn _vld4q_dup_s32(ptr: *const i8, size: i32) -> int32x4x4_t;
    }
    _vld4q_dup_s32(a as *const i8, 4)
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_dup_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(ld4r))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld4_dup_f32(a: *const f32) -> float32x2x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld4r.v2f32.p0.p0"
        )]
        fn _vld4_dup_f32(ptr: *const f32) -> float32x2x4_t;
    }
    _vld4_dup_f32(a as _)
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_dup_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(ld4r))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld4q_dup_f32(a: *const f32) -> float32x4x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld4r.v4f32.p0.p0"
        )]
        fn _vld4q_dup_f32(ptr: *const f32) -> float32x4x4_t;
    }
    _vld4q_dup_f32(a as _)
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_dup_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(ld4r))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld4_dup_s8(a: *const i8) -> int8x8x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld4r.v8i8.p0.p0"
        )]
        fn _vld4_dup_s8(ptr: *const i8) -> int8x8x4_t;
    }
    _vld4_dup_s8(a as _)
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_dup_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(ld4r))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld4q_dup_s8(a: *const i8) -> int8x16x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld4r.v16i8.p0.p0"
        )]
        fn _vld4q_dup_s8(ptr: *const i8) -> int8x16x4_t;
    }
    _vld4q_dup_s8(a as _)
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_dup_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(ld4r))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld4_dup_s16(a: *const i16) -> int16x4x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld4r.v4i16.p0.p0"
        )]
        fn _vld4_dup_s16(ptr: *const i16) -> int16x4x4_t;
    }
    _vld4_dup_s16(a as _)
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_dup_s16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(ld4r))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld4q_dup_s16(a: *const i16) -> int16x8x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld4r.v8i16.p0.p0"
        )]
        fn _vld4q_dup_s16(ptr: *const i16) -> int16x8x4_t;
    }
    _vld4q_dup_s16(a as _)
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_dup_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(ld4r))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld4_dup_s32(a: *const i32) -> int32x2x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld4r.v2i32.p0.p0"
        )]
        fn _vld4_dup_s32(ptr: *const i32) -> int32x2x4_t;
    }
    _vld4_dup_s32(a as _)
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_dup_s32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(ld4r))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld4q_dup_s32(a: *const i32) -> int32x4x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld4r.v4i32.p0.p0"
        )]
        fn _vld4q_dup_s32(ptr: *const i32) -> int32x4x4_t;
    }
    _vld4q_dup_s32(a as _)
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_dup_s64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(test, assert_instr(ld4r))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
pub unsafe fn vld4_dup_s64(a: *const i64) -> int64x1x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld4r.v1i64.p0.p0"
        )]
        fn _vld4_dup_s64(ptr: *const i64) -> int64x1x4_t;
    }
    _vld4_dup_s64(a as _)
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_dup_p64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon,aes")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v8"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld4r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld4_dup_p64(a: *const p64) -> poly64x1x4_t {
    transmute(vld4_dup_s64(transmute(a)))
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_dup_s64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_arch = "arm")]
#[target_feature(enable = "neon,v7")]
#[cfg_attr(test, assert_instr(nop))]
#[unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")]
pub unsafe fn vld4_dup_s64(a: *const i64) -> int64x1x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld4dup.v1i64.p0")]
        fn _vld4_dup_s64(ptr: *const i8, size: i32) -> int64x1x4_t;
    }
    _vld4_dup_s64(a as *const i8, 8)
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_dup_u64)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(nop))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld4r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld4_dup_u64(a: *const u64) -> uint64x1x4_t {
    transmute(vld4_dup_s64(transmute(a)))
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_dup_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld4r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld4_dup_u8(a: *const u8) -> uint8x8x4_t {
    transmute(vld4_dup_s8(transmute(a)))
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_dup_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld4r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld4_dup_u8(a: *const u8) -> uint8x8x4_t {
    let mut ret_val: uint8x8x4_t = transmute(vld4_dup_s8(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.3 = unsafe { simd_shuffle!(ret_val.3, ret_val.3, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_dup_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld4r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld4q_dup_u8(a: *const u8) -> uint8x16x4_t {
    transmute(vld4q_dup_s8(transmute(a)))
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_dup_u8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld4r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld4q_dup_u8(a: *const u8) -> uint8x16x4_t {
    let mut ret_val: uint8x16x4_t = transmute(vld4q_dup_s8(transmute(a)));
    ret_val.0 = unsafe {
        simd_shuffle!(
            ret_val.0,
            ret_val.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val.1 = unsafe {
        simd_shuffle!(
            ret_val.1,
            ret_val.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val.2 = unsafe {
        simd_shuffle!(
            ret_val.2,
            ret_val.2,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val.3 = unsafe {
        simd_shuffle!(
            ret_val.3,
            ret_val.3,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_dup_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld4r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld4_dup_u16(a: *const u16) -> uint16x4x4_t {
    transmute(vld4_dup_s16(transmute(a)))
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_dup_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld4r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld4_dup_u16(a: *const u16) -> uint16x4x4_t {
    let mut ret_val: uint16x4x4_t = transmute(vld4_dup_s16(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [3, 2, 1, 0]) };
    ret_val.3 = unsafe { simd_shuffle!(ret_val.3, ret_val.3, [3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_dup_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld4r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld4q_dup_u16(a: *const u16) -> uint16x8x4_t {
    transmute(vld4q_dup_s16(transmute(a)))
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_dup_u16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld4r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld4q_dup_u16(a: *const u16) -> uint16x8x4_t {
    let mut ret_val: uint16x8x4_t = transmute(vld4q_dup_s16(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.3 = unsafe { simd_shuffle!(ret_val.3, ret_val.3, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_dup_u32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld4r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld4_dup_u32(a: *const u32) -> uint32x2x4_t {
    transmute(vld4_dup_s32(transmute(a)))
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_dup_u32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld4r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld4_dup_u32(a: *const u32) -> uint32x2x4_t {
    let mut ret_val: uint32x2x4_t = transmute(vld4_dup_s32(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [1, 0]) };
    ret_val.3 = unsafe { simd_shuffle!(ret_val.3, ret_val.3, [1, 0]) };
    ret_val
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_dup_u32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld4r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld4q_dup_u32(a: *const u32) -> uint32x4x4_t {
    transmute(vld4q_dup_s32(transmute(a)))
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_dup_u32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld4r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld4q_dup_u32(a: *const u32) -> uint32x4x4_t {
    let mut ret_val: uint32x4x4_t = transmute(vld4q_dup_s32(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [3, 2, 1, 0]) };
    ret_val.3 = unsafe { simd_shuffle!(ret_val.3, ret_val.3, [3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_dup_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld4r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld4_dup_p8(a: *const p8) -> poly8x8x4_t {
    transmute(vld4_dup_s8(transmute(a)))
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_dup_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld4r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld4_dup_p8(a: *const p8) -> poly8x8x4_t {
    let mut ret_val: poly8x8x4_t = transmute(vld4_dup_s8(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.3 = unsafe { simd_shuffle!(ret_val.3, ret_val.3, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_dup_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld4r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld4q_dup_p8(a: *const p8) -> poly8x16x4_t {
    transmute(vld4q_dup_s8(transmute(a)))
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_dup_p8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld4r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld4q_dup_p8(a: *const p8) -> poly8x16x4_t {
    let mut ret_val: poly8x16x4_t = transmute(vld4q_dup_s8(transmute(a)));
    ret_val.0 = unsafe {
        simd_shuffle!(
            ret_val.0,
            ret_val.0,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val.1 = unsafe {
        simd_shuffle!(
            ret_val.1,
            ret_val.1,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val.2 = unsafe {
        simd_shuffle!(
            ret_val.2,
            ret_val.2,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val.3 = unsafe {
        simd_shuffle!(
            ret_val.3,
            ret_val.3,
            [15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0]
        )
    };
    ret_val
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_dup_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld4r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld4_dup_p16(a: *const p16) -> poly16x4x4_t {
    transmute(vld4_dup_s16(transmute(a)))
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_dup_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld4r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld4_dup_p16(a: *const p16) -> poly16x4x4_t {
    let mut ret_val: poly16x4x4_t = transmute(vld4_dup_s16(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [3, 2, 1, 0]) };
    ret_val.3 = unsafe { simd_shuffle!(ret_val.3, ret_val.3, [3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_dup_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "little")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld4r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld4q_dup_p16(a: *const p16) -> poly16x8x4_t {
    transmute(vld4q_dup_s16(transmute(a)))
}
#[doc = "Load single 4-element structure and replicate to all lanes of four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_dup_p16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(target_endian = "big")]
#[target_feature(enable = "neon")]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld4))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld4r)
)]
#[cfg_attr(
    not(target_arch = "arm"),
    stable(feature = "neon_intrinsics", since = "1.59.0")
)]
#[cfg_attr(
    target_arch = "arm",
    unstable(feature = "stdarch_arm_neon_intrinsics", issue = "111800")
)]
pub unsafe fn vld4q_dup_p16(a: *const p16) -> poly16x8x4_t {
    let mut ret_val: poly16x8x4_t = transmute(vld4q_dup_s16(transmute(a)));
    ret_val.0 = unsafe { simd_shuffle!(ret_val.0, ret_val.0, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.1 = unsafe { simd_shuffle!(ret_val.1, ret_val.1, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.2 = unsafe { simd_shuffle!(ret_val.2, ret_val.2, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val.3 = unsafe { simd_shuffle!(ret_val.3, ret_val.3, [7, 6, 5, 4, 3, 2, 1, 0]) };
    ret_val
}
#[doc = "Load single 4-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg(target_arch = "arm")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld4))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld4_f16(a: *const f16) -> float16x4x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld4.v4f16.p0")]
        fn _vld4_f16(ptr: *const f16, size: i32) -> float16x4x4_t;
    }
    _vld4_f16(a as _, 2)
}
#[doc = "Load single 4-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg_attr(target_arch = "arm", target_feature(enable = "v7"))]
#[cfg(target_arch = "arm")]
#[cfg_attr(all(test, target_arch = "arm"), assert_instr(vld4))]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld4q_f16(a: *const f16) -> float16x8x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(target_arch = "arm", link_name = "llvm.arm.neon.vld4.v8f16.p0")]
        fn _vld4q_f16(ptr: *const f16, size: i32) -> float16x8x4_t;
    }
    _vld4q_f16(a as _, 2)
}
#[doc = "Load single 4-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld4)
)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld4_f16(a: *const f16) -> float16x4x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld4.v4f16.p0"
        )]
        fn _vld4_f16(ptr: *const f16) -> float16x4x4_t;
    }
    _vld4_f16(a as _)
}
#[doc = "Load single 4-element structure and replicate to all lanes of two registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_f16)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[cfg(not(target_arch = "arm"))]
#[cfg_attr(
    all(test, any(target_arch = "aarch64", target_arch = "arm64ec")),
    assert_instr(ld4)
)]
#[target_feature(enable = "neon,fp16")]
#[unstable(feature = "stdarch_neon_f16", issue = "136306")]
#[cfg(not(target_arch = "arm64ec"))]
pub unsafe fn vld4q_f16(a: *const f16) -> float16x8x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld4.v8f16.p0"
        )]
        fn _vld4q_f16(ptr: *const f16) -> float16x8x4_t;
    }
    _vld4q_f16(a as _)
}
#[doc = "Load multiple 4-element structures to four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld4))]
pub unsafe fn vld4_f32(a: *const f32) -> float32x2x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld4.v2f32.p0"
        )]
        fn _vld4_f32(ptr: *const float32x2_t) -> float32x2x4_t;
    }
    _vld4_f32(a as _)
}
#[doc = "Load multiple 4-element structures to four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4q_f32)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld4))]
pub unsafe fn vld4q_f32(a: *const f32) -> float32x4x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld4.v4f32.p0"
        )]
        fn _vld4q_f32(ptr: *const float32x4_t) -> float32x4x4_t;
    }
    _vld4q_f32(a as _)
}
#[doc = "Load multiple 4-element structures to four registers"]
#[doc = "[Arm's documentation](https://developer.arm.com/architectures/instruction-sets/intrinsics/vld4_s8)"]
#[doc = "## Safety"]
#[doc = "  * Neon instrinsic unsafe"]
#[inline]
#[target_feature(enable = "neon")]
#[cfg(not(target_arch = "arm"))]
#[stable(feature = "neon_intrinsics", since = "1.59.0")]
#[cfg_attr(test, assert_instr(ld4))]
pub unsafe fn vld4_s8(a: *const i8) -> int8x8x4_t {
    unsafe extern "unadjusted" {
        #[cfg_attr(
            any(target_arch = "aarch64", target_arch = "arm64ec"),
            link_name = "llvm.aarch64.neon.ld4.v8i8.p0"
        )]
        fn _vld4_s8(ptr: *const int8x8_t) -> int8x8x4_t;
    }
    _vld4_s8(a as _)
}
#[doc = "Load multiple 4-element structures to four registers"]
#[doc = "[Arm's documentation](https://de