package dom

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"fmt"

	"github.com/chromedp/cdproto/cdp"
	"github.com/mailru/easyjson"
	"github.com/mailru/easyjson/jlexer"
	"github.com/mailru/easyjson/jwriter"
)

// PhysicalAxes containerSelector physical axes.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DOM#type-PhysicalAxes
type PhysicalAxes string

// String returns the PhysicalAxes as string value.
func (t PhysicalAxes) String() string {
	return string(t)
}

// PhysicalAxes values.
const (
	PhysicalAxesHorizontal PhysicalAxes = "Horizontal"
	PhysicalAxesVertical   PhysicalAxes = "Vertical"
	PhysicalAxesBoth       PhysicalAxes = "Both"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t PhysicalAxes) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t PhysicalAxes) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *PhysicalAxes) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch PhysicalAxes(v) {
	case PhysicalAxesHorizontal:
		*t = PhysicalAxesHorizontal
	case PhysicalAxesVertical:
		*t = PhysicalAxesVertical
	case PhysicalAxesBoth:
		*t = PhysicalAxesBoth

	default:
		in.AddError(fmt.Errorf("unknown PhysicalAxes value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *PhysicalAxes) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// LogicalAxes containerSelector logical axes.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DOM#type-LogicalAxes
type LogicalAxes string

// String returns the LogicalAxes as string value.
func (t LogicalAxes) String() string {
	return string(t)
}

// LogicalAxes values.
const (
	LogicalAxesInline LogicalAxes = "Inline"
	LogicalAxesBlock  LogicalAxes = "Block"
	LogicalAxesBoth   LogicalAxes = "Both"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t LogicalAxes) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t LogicalAxes) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *LogicalAxes) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch LogicalAxes(v) {
	case LogicalAxesInline:
		*t = LogicalAxesInline
	case LogicalAxesBlock:
		*t = LogicalAxesBlock
	case LogicalAxesBoth:
		*t = LogicalAxesBoth

	default:
		in.AddError(fmt.Errorf("unknown LogicalAxes value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *LogicalAxes) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// ScrollOrientation physical scroll orientation.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DOM#type-ScrollOrientation
type ScrollOrientation string

// String returns the ScrollOrientation as string value.
func (t ScrollOrientation) String() string {
	return string(t)
}

// ScrollOrientation values.
const (
	ScrollOrientationHorizontal ScrollOrientation = "horizontal"
	ScrollOrientationVertical   ScrollOrientation = "vertical"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t ScrollOrientation) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t ScrollOrientation) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *ScrollOrientation) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch ScrollOrientation(v) {
	case ScrollOrientationHorizontal:
		*t = ScrollOrientationHorizontal
	case ScrollOrientationVertical:
		*t = ScrollOrientationVertical

	default:
		in.AddError(fmt.Errorf("unknown ScrollOrientation value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *ScrollOrientation) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// DetachedElementInfo a structure to hold the top-level node of a detached
// tree and an array of its retained descendants.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DOM#type-DetachedElementInfo
type DetachedElementInfo struct {
	TreeNode        *cdp.Node    `json:"treeNode"`
	RetainedNodeIDs []cdp.NodeID `json:"retainedNodeIds"`
}

// Quad an array of quad vertices, x immediately followed by y for each
// point, points clock-wise.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DOM#type-Quad
type Quad []float64

// BoxModel box model.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DOM#type-BoxModel
type BoxModel struct {
	Content      Quad              `json:"content"`                // Content box
	Padding      Quad              `json:"padding"`                // Padding box
	Border       Quad              `json:"border"`                 // Border box
	Margin       Quad              `json:"margin"`                 // Margin box
	Width        int64             `json:"width"`                  // Node width
	Height       int64             `json:"height"`                 // Node height
	ShapeOutside *ShapeOutsideInfo `json:"shapeOutside,omitempty"` // Shape outside coordinates
}

// ShapeOutsideInfo CSS Shape Outside details.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DOM#type-ShapeOutsideInfo
type ShapeOutsideInfo struct {
	Bounds      Quad                  `json:"bounds"`      // Shape bounds
	Shape       []easyjson.RawMessage `json:"shape"`       // Shape coordinate details
	MarginShape []easyjson.RawMessage `json:"marginShape"` // Margin shape bounds
}

// Rect Rectangle.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DOM#type-Rect
type Rect struct {
	X      float64 `json:"x"`      // X coordinate
	Y      float64 `json:"y"`      // Y coordinate
	Width  float64 `json:"width"`  // Rectangle width
	Height float64 `json:"height"` // Rectangle height
}

// CSSComputedStyleProperty [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DOM#type-CSSComputedStyleProperty
type CSSComputedStyleProperty struct {
	Name  string `json:"name"`  // Computed style property name.
	Value string `json:"value"` // Computed style property value.
}

// EnableIncludeWhitespace whether to include whitespaces in the children
// array of returned Nodes.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DOM#method-enable
type EnableIncludeWhitespace string

// String returns the EnableIncludeWhitespace as string value.
func (t EnableIncludeWhitespace) String() string {
	return string(t)
}

// EnableIncludeWhitespace values.
const (
	EnableIncludeWhitespaceNone EnableIncludeWhitespace = "none"
	EnableIncludeWhitespaceAll  EnableIncludeWhitespace = "all"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t EnableIncludeWhitespace) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t EnableIncludeWhitespace) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *EnableIncludeWhitespace) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch EnableIncludeWhitespace(v) {
	case EnableIncludeWhitespaceNone:
		*t = EnableIncludeWhitespaceNone
	case EnableIncludeWhitespaceAll:
		*t = EnableIncludeWhitespaceAll

	default:
		in.AddError(fmt.Errorf("unknown EnableIncludeWhitespace value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *EnableIncludeWhitespace) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// GetElementByRelationRelation type of relation to get.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/DOM#method-getElementByRelation
type GetElementByRelationRelation string

// String returns the GetElementByRelationRelation as string value.
func (t GetElementByRelationRelation) String() string {
	return string(t)
}

// GetElementByRelationRelation values.
const (
	GetElementByRelationRelationPopoverTarget GetElementByRelationRelation = "PopoverTarget"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t GetElementByRelationRelation) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t GetElementByRelationRelation) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *GetElementByRelationRelation) UnmarshalEasyJSON(in *jlexer.Lexer) {
	v := in.String()
	switch GetElementByRelationRelation(v) {
	case GetElementByRelationRelationPopoverTarget:
		*t = GetElementByRelationRelationPopoverTarget

	default:
		in.AddError(fmt.Errorf("unknown GetElementByRelationRelation value: %v", v))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *GetElementByRelationRelation) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}
