/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ditaa.graphics;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class FontMeasurer {
    private final Font baseFont;
    private final boolean fixedFontSize;
    private FontRenderContext fakeRenderContext;
    private Graphics2D fakeGraphics;

    public FontMeasurer(Font font, boolean fixedFontSize) {
        this.baseFont = font;
        this.fixedFontSize = fixedFontSize;
        BufferedImage image = new BufferedImage(1, 1, 1);
        this.fakeGraphics = image.createGraphics();
        this.fakeRenderContext = this.fakeGraphics.getFontRenderContext();
    }

    public int getWidthFor(String str, int pixelHeight) {
        Font font = this.getFontFor(pixelHeight);
        Rectangle2D rectangle = font.getStringBounds(str, this.fakeRenderContext);
        return (int)rectangle.getWidth();
    }

    public int getHeightFor(String str, int pixelHeight) {
        Font font = this.getFontFor(pixelHeight);
        Rectangle2D rectangle = font.getStringBounds(str, this.fakeRenderContext);
        return (int)rectangle.getHeight();
    }

    public int getWidthFor(String str, Font font) {
        Rectangle2D rectangle = font.getStringBounds(str, this.fakeRenderContext);
        return (int)rectangle.getWidth();
    }

    public int getHeightFor(String str, Font font) {
        Rectangle2D rectangle = font.getStringBounds(str, this.fakeRenderContext);
        return (int)rectangle.getHeight();
    }

    public Rectangle2D getBoundsFor(String str, Font font) {
        return font.getStringBounds(str, this.fakeRenderContext);
    }

    public int getAscent(Font font) {
        this.fakeGraphics.setFont(font);
        FontMetrics metrics = this.fakeGraphics.getFontMetrics();
        return metrics.getAscent();
    }

    public int getZHeight(Font font) {
        return (int)font.createGlyphVector(this.fakeRenderContext, "Z").getOutline().getBounds().getHeight();
    }

    public Font getFontFor(final int maxWidth, final String string) {
        FontPredicate predicate = new FontPredicate(){

            @Override
            public boolean test(Font font) {
                int width = FontMeasurer.this.getWidthFor(string, font);
                return width > maxWidth;
            }
        };
        return this.deriveFont(predicate, 1.0f);
    }

    public Font getFontFor(final int pixelHeight) {
        if (this.fixedFontSize) {
            return this.baseFont;
        }
        FontPredicate predicate = new FontPredicate(){

            @Override
            public boolean test(Font font) {
                int ascent = FontMeasurer.this.getAscent(font);
                return ascent > pixelHeight;
            }
        };
        return this.deriveFont(predicate, 0.5f);
    }

    private Font deriveFont(FontPredicate predicate, float sizeDelta) {
        int direction;
        if (this.fixedFontSize) {
            return this.baseFont;
        }
        Font currentFont = this.baseFont;
        float size = this.baseFont.getSize2D();
        if (predicate.test(currentFont)) {
            currentFont = currentFont.deriveFont(size - 1.0f);
            size -= 1.0f;
            direction = -1;
        } else {
            currentFont = currentFont.deriveFont(size + 1.0f);
            size += 1.0f;
            direction = 1;
        }
        while (size > 0.0f) {
            currentFont = currentFont.deriveFont(size);
            if (direction == 1) {
                if (predicate.test(currentFont)) {
                    return currentFont.deriveFont(size -= sizeDelta);
                }
                size += sizeDelta;
                continue;
            }
            if (!predicate.test(currentFont)) {
                return currentFont;
            }
            size -= sizeDelta;
        }
        return null;
    }

    private static interface FontPredicate {
        public boolean test(Font var1);
    }
}

