/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.diagram;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.asciidoctor.diagram.MimeType;

public class MultipartWriter {
    private static final byte[] CRLF = "\r\n".getBytes(StandardCharsets.US_ASCII);
    private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
    private final MimeType format;
    private final byte[] startBoundary;
    private final byte[] endBoundary;

    public MultipartWriter() {
        String boundary = UUID.randomUUID().toString();
        this.format = MimeType.MULTIPART_FORM_DATA.withParameter("boundary", boundary);
        this.startBoundary = ("--" + boundary).getBytes(StandardCharsets.US_ASCII);
        this.endBoundary = ("--" + boundary + "--").getBytes(StandardCharsets.US_ASCII);
    }

    public MimeType getFormat() {
        return this.format;
    }

    public void addPart(String name, MimeType contentType, byte[] content) throws IOException {
        this.outputStream.write(CRLF);
        this.outputStream.write(this.startBoundary);
        this.outputStream.write(CRLF);
        this.outputStream.write("Content-Disposition: form-data; name=\"".getBytes(StandardCharsets.US_ASCII));
        this.outputStream.write(name.getBytes(StandardCharsets.US_ASCII));
        this.outputStream.write("\"".getBytes(StandardCharsets.US_ASCII));
        this.outputStream.write(CRLF);
        this.outputStream.write("Content-Type: ".getBytes(StandardCharsets.US_ASCII));
        this.outputStream.write(contentType.toString().getBytes(StandardCharsets.US_ASCII));
        this.outputStream.write(CRLF);
        this.outputStream.write("Content-Length: ".getBytes(StandardCharsets.US_ASCII));
        this.outputStream.write(Integer.toString(content.length).getBytes(StandardCharsets.US_ASCII));
        this.outputStream.write(CRLF);
        this.outputStream.write(CRLF);
        this.outputStream.write(content);
    }

    public byte[] finish() throws IOException {
        this.outputStream.write(CRLF);
        this.outputStream.write(this.endBoundary);
        this.outputStream.write(CRLF);
        return this.outputStream.toByteArray();
    }
}

