/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.lang.reflect.Constructor;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.patterns.RuleFilter;

public class RuleFilterCreator {
    public RuleFilter getFilter(String className) {
        try {
            Class<?> aClass = JLanguageTool.getClassBroker().forName(className);
            Constructor<?>[] constructors = aClass.getConstructors();
            if (constructors.length != 1) {
                throw new RuntimeException("Constructor of filter class '" + className + "' must have exactly one constructor, but it has " + constructors.length);
            }
            Constructor<?> constructor = constructors[0];
            try {
                if (constructor.getParameterTypes().length != 0) {
                    throw new RuntimeException("Constructor of filter class '" + className + "' must not have arguments: " + constructor);
                }
                Object filter2 = constructor.newInstance(new Object[0]);
                if (filter2 instanceof RuleFilter) {
                    return (RuleFilter)filter2;
                }
                throw new RuntimeException("Filter class '" + className + "' must implement interface " + RuleFilter.class.getSimpleName());
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create filter class using constructor " + constructor, e);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find filter class: '" + className + "' - make sure to use a fully qualified class name like 'org.languagetool.rules.MyFilter'");
        }
    }
}

