/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.Assert;

public class InteriorPointArea {
    private Coordinate interiorPoint = null;
    private double maxWidth = -1.0;

    public static Coordinate getInteriorPoint(Geometry geom) {
        InteriorPointArea intPt = new InteriorPointArea(geom);
        return intPt.getInteriorPoint();
    }

    private static double avg(double a, double b) {
        return (a + b) / 2.0;
    }

    public InteriorPointArea(Geometry g) {
        this.process(g);
    }

    public Coordinate getInteriorPoint() {
        return this.interiorPoint;
    }

    private void process(Geometry geom) {
        if (geom.isEmpty()) {
            return;
        }
        if (geom instanceof Polygon) {
            this.processPolygon((Polygon)geom);
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)geom;
            for (int i2 = 0; i2 < gc.getNumGeometries(); ++i2) {
                this.process(gc.getGeometryN(i2));
            }
        }
    }

    private void processPolygon(Polygon polygon) {
        InteriorPointPolygon intPtPoly = new InteriorPointPolygon(polygon);
        intPtPoly.process();
        double width = intPtPoly.getWidth();
        if (width > this.maxWidth) {
            this.maxWidth = width;
            this.interiorPoint = intPtPoly.getInteriorPoint();
        }
    }

    private static class ScanLineYOrdinateFinder {
        private Polygon poly;
        private double centreY;
        private double hiY = Double.MAX_VALUE;
        private double loY = -1.7976931348623157E308;

        public static double getScanLineY(Polygon poly) {
            ScanLineYOrdinateFinder finder = new ScanLineYOrdinateFinder(poly);
            return finder.getScanLineY();
        }

        public ScanLineYOrdinateFinder(Polygon poly) {
            this.poly = poly;
            this.hiY = poly.getEnvelopeInternal().getMaxY();
            this.loY = poly.getEnvelopeInternal().getMinY();
            this.centreY = InteriorPointArea.avg(this.loY, this.hiY);
        }

        public double getScanLineY() {
            this.process(this.poly.getExteriorRing());
            for (int i2 = 0; i2 < this.poly.getNumInteriorRing(); ++i2) {
                this.process(this.poly.getInteriorRingN(i2));
            }
            double scanLineY = InteriorPointArea.avg(this.hiY, this.loY);
            return scanLineY;
        }

        private void process(LineString line) {
            CoordinateSequence seq = line.getCoordinateSequence();
            for (int i2 = 0; i2 < seq.size(); ++i2) {
                double y = seq.getY(i2);
                this.updateInterval(y);
            }
        }

        private void updateInterval(double y) {
            if (y <= this.centreY) {
                if (y > this.loY) {
                    this.loY = y;
                }
            } else if (y > this.centreY && y < this.hiY) {
                this.hiY = y;
            }
        }
    }

    private static class InteriorPointPolygon {
        private Polygon polygon;
        private double interiorPointY;
        private double interiorSectionWidth = 0.0;
        private Coordinate interiorPoint = null;

        public InteriorPointPolygon(Polygon polygon) {
            this.polygon = polygon;
            this.interiorPointY = ScanLineYOrdinateFinder.getScanLineY(polygon);
        }

        public Coordinate getInteriorPoint() {
            return this.interiorPoint;
        }

        public double getWidth() {
            return this.interiorSectionWidth;
        }

        public void process() {
            if (this.polygon.isEmpty()) {
                return;
            }
            this.interiorPoint = new Coordinate(this.polygon.getCoordinate());
            ArrayList<Double> crossings = new ArrayList<Double>();
            this.scanRing(this.polygon.getExteriorRing(), crossings);
            for (int i2 = 0; i2 < this.polygon.getNumInteriorRing(); ++i2) {
                this.scanRing(this.polygon.getInteriorRingN(i2), crossings);
            }
            this.findBestMidpoint(crossings);
        }

        private void scanRing(LinearRing ring, List<Double> crossings) {
            if (!InteriorPointPolygon.intersectsHorizontalLine(ring.getEnvelopeInternal(), this.interiorPointY)) {
                return;
            }
            CoordinateSequence seq = ring.getCoordinateSequence();
            for (int i2 = 1; i2 < seq.size(); ++i2) {
                Coordinate ptPrev = seq.getCoordinate(i2 - 1);
                Coordinate pt = seq.getCoordinate(i2);
                this.addEdgeCrossing(ptPrev, pt, this.interiorPointY, crossings);
            }
        }

        private void addEdgeCrossing(Coordinate p0, Coordinate p1, double scanY, List<Double> crossings) {
            if (!InteriorPointPolygon.intersectsHorizontalLine(p0, p1, scanY)) {
                return;
            }
            if (!InteriorPointPolygon.isEdgeCrossingCounted(p0, p1, scanY)) {
                return;
            }
            double xInt = InteriorPointPolygon.intersection(p0, p1, scanY);
            crossings.add(xInt);
        }

        private void findBestMidpoint(List<Double> crossings) {
            if (crossings.size() == 0) {
                return;
            }
            Assert.isTrue(0 == crossings.size() % 2, "Interior Point robustness failure: odd number of scanline crossings");
            crossings.sort(Double::compare);
            for (int i2 = 0; i2 < crossings.size(); i2 += 2) {
                double x1 = crossings.get(i2);
                double x2 = crossings.get(i2 + 1);
                double width = x2 - x1;
                if (!(width > this.interiorSectionWidth)) continue;
                this.interiorSectionWidth = width;
                double interiorPointX = InteriorPointArea.avg(x1, x2);
                this.interiorPoint = new Coordinate(interiorPointX, this.interiorPointY);
            }
        }

        private static boolean isEdgeCrossingCounted(Coordinate p0, Coordinate p1, double scanY) {
            double y1;
            double y0 = p0.getY();
            if (y0 == (y1 = p1.getY())) {
                return false;
            }
            if (y0 == scanY && y1 < scanY) {
                return false;
            }
            return y1 != scanY || !(y0 < scanY);
        }

        private static double intersection(Coordinate p0, Coordinate p1, double Y) {
            double x1;
            double x0 = p0.getX();
            if (x0 == (x1 = p1.getX())) {
                return x0;
            }
            double segDX = x1 - x0;
            double segDY = p1.getY() - p0.getY();
            double m = segDY / segDX;
            double x = x0 + (Y - p0.getY()) / m;
            return x;
        }

        private static boolean intersectsHorizontalLine(Envelope env, double y) {
            if (y < env.getMinY()) {
                return false;
            }
            return !(y > env.getMaxY());
        }

        private static boolean intersectsHorizontalLine(Coordinate p0, Coordinate p1, double y) {
            if (p0.getY() > y && p1.getY() > y) {
                return false;
            }
            return !(p0.getY() < y) || !(p1.getY() < y);
        }
    }
}

