/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.psi.SqlSelectModifierClause;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlClauseImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NotNull;

public final class SqlSelectRegexFilterClause
extends SqlClauseImpl
implements SqlSelectModifierClause {
    public SqlSelectRegexFilterClause(@NotNull IElementType elementType) {
        if (elementType == null) {
            SqlSelectRegexFilterClause.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @NotNull
    public SqlTableType adjustQueryType(@NotNull SqlTableType type) {
        Pattern compiled;
        if (type == null) {
            SqlSelectRegexFilterClause.$$$reportNull$$$0(1);
        }
        if (type.getColumnCount() == 0) {
            SqlTableType sqlTableType = type;
            if (sqlTableType == null) {
                SqlSelectRegexFilterClause.$$$reportNull$$$0(2);
            }
            return sqlTableType;
        }
        PsiElement psiElement = this.getLastChild();
        if (!(psiElement instanceof SqlStringLiteralExpression)) {
            SqlTableType sqlTableType = type;
            if (sqlTableType == null) {
                SqlSelectRegexFilterClause.$$$reportNull$$$0(3);
            }
            return sqlTableType;
        }
        SqlStringLiteralExpression literal = (SqlStringLiteralExpression)psiElement;
        String pattern = literal.getValue();
        if (pattern == null) {
            SqlTableType sqlTableType = type;
            if (sqlTableType == null) {
                SqlSelectRegexFilterClause.$$$reportNull$$$0(4);
            }
            return sqlTableType;
        }
        String javaPattern = StringUtil.escapeToRegexp((String)pattern).replace('_', '.').replace("\\%", ".*");
        try {
            compiled = Pattern.compile(javaPattern, 2);
        }
        catch (PatternSyntaxException e) {
            SqlTableType sqlTableType = type;
            if (sqlTableType == null) {
                SqlSelectRegexFilterClause.$$$reportNull$$$0(5);
            }
            return sqlTableType;
        }
        ArrayList<SqlImplUtil.Column> columns = new ArrayList<SqlImplUtil.Column>();
        for (int i2 = 0; i2 < type.getColumnCount(); ++i2) {
            String columnName = type.getColumnName(i2);
            Matcher matcher = compiled.matcher(columnName);
            if (!matcher.matches()) continue;
            columns.add(new SqlImplUtil.Column(columnName, type.getColumnDasType(i2), type.getColumnElement(i2), type.getSourceColumnElement(i2)));
        }
        PsiElement qualifier = type.getColumnQualifier(0);
        SqlTableType sqlTableType = SqlImplUtil.createType(null, ":", columns, qualifier);
        if (sqlTableType == null) {
            SqlSelectRegexFilterClause.$$$reportNull$$$0(6);
        }
        return sqlTableType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlSelectRegexFilterClause";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlSelectRegexFilterClause";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustQueryType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "adjustQueryType";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

