/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.DbmsExtension;
import com.intellij.lang.InjectableLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@Service
public final class SqlDialects {
    private static final Logger LOG = Logger.getInstance(SqlDialects.class);

    private SqlDialects() {
        long t = System.currentTimeMillis();
        SqlDialects.initSqlDialects();
        LOG.info("SQL dialects initialized in " + StringUtil.formatDuration((long)(System.currentTimeMillis() - t)));
    }

    @NotNull
    public static SqlDialects getInstance() {
        SqlDialects sqlDialects = (SqlDialects)ApplicationManager.getApplication().getService(SqlDialects.class);
        if (sqlDialects == null) {
            SqlDialects.$$$reportNull$$$0(0);
        }
        return sqlDialects;
    }

    private static void initSqlDialects() {
        List extensions = SqlLanguageDialect.EP.allExtensions();
        if (extensions.isEmpty()) {
            LOG.error("No sql dialects found");
            return;
        }
        HashSet<String> dialects = new HashSet<String>();
        for (DbmsExtension.Bean bean : extensions) {
            try {
                bean.getInstance();
                dialects.add(StringUtil.trimEnd((String)StringUtil.getShortName((String)StringUtil.notNullize((String)bean.implementationClass)), (String)"Dialect"));
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        if (!dialects.containsAll(Arrays.asList("Sql92", "Generic"))) {
            LOG.error("Required SQL dialects not found among: " + String.valueOf(dialects));
        }
    }

    @Nullable
    public static SqlLanguageDialect findDialectById(@NotNull String id) {
        if (id == null) {
            SqlDialects.$$$reportNull$$$0(1);
        }
        SqlDialects.ensureSqlDialectsLoaded();
        Language result2 = Language.findLanguageByID((String)id);
        return result2 instanceof SqlLanguageDialect ? (SqlLanguageDialect)result2 : null;
    }

    @NotNull
    public static List<SqlLanguageDialect> getSqlDialects() {
        return SqlDialects.getInstance().getSqlDialectsImpl();
    }

    private @Unmodifiable @NotNull List<SqlLanguageDialect> getSqlDialectsImpl() {
        List list = ContainerUtil.filterIsInstance((Collection)SqlLanguage.INSTANCE.getTransitiveDialects(), SqlLanguageDialect.class);
        if (list == null) {
            SqlDialects.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public static List<SqlLanguageDialect> getTopLevelSqlDialects() {
        List<SqlLanguageDialect> list = SqlDialects.getInstance().getSqlDialectsImpl().stream().filter(o -> !(o instanceof InjectableLanguage)).sorted(Comparator.comparing(Language::getDisplayName)).toList();
        if (list == null) {
            SqlDialects.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public static SqlLanguageDialect getGenericDialect() {
        SqlLanguageDialect sqlLanguageDialect = SqlLanguageDialect.getGenericDialect();
        if (sqlLanguageDialect == null) {
            SqlDialects.$$$reportNull$$$0(4);
        }
        return sqlLanguageDialect;
    }

    public static boolean isGenericDialect(@NotNull SqlLanguageDialect dialect) {
        if (dialect == null) {
            SqlDialects.$$$reportNull$$$0(5);
        }
        return dialect.getID().equals("GenericSQL");
    }

    public static void ensureSqlDialectsLoaded() {
        SqlDialects.getInstance();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/SqlDialects";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/SqlDialects";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialectsImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelSqlDialects";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericDialect";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findDialectById";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isGenericDialect";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 5 -> new IllegalArgumentException(string);
        };
    }
}

