/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script.generator;

import com.intellij.database.model.DasModel;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.MemoryTextStorage;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelLightCopier;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.serialization.ModelImporter;
import com.intellij.database.model.serialization.ModelSerializerKt;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptingAlterTask;
import com.intellij.database.script.generator.ScriptingAlterTaskBuilder;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingSingleModelTask;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.script.generator.ScriptingTaskBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.util.Version;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.JBIterable;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppReader;
import io.github.xstream.mxparser.MXParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScriptingTaskSerialisation {
    @NotNull
    public static ScriptingTaskBuilder loadTask(File dumpDir) throws IOException {
        ScriptingTaskBuilder scriptingTaskBuilder = (ScriptingTaskBuilder)ScriptingTaskSerialisation.readFromFile(new File(dumpDir, "task.xml"), reader -> {
            ScriptingTaskBuilder builder;
            String type = reader.getAttribute("type");
            if ("alter".equals(type)) {
                BasicModModel sourceModel = ScriptingTaskSerialisation.readModel(new File(dumpDir, "sourceModel.xml"));
                BasicModModel targetModel = ScriptingTaskSerialisation.readModel(new File(dumpDir, "targetModel.xml"));
                builder = new ScriptingAlterTaskBuilder((BasicModel)sourceModel, targetModel);
            } else if ("single".equals(type)) {
                BasicModModel model = ScriptingTaskSerialisation.readModel(new File(dumpDir, "model.xml"));
                String categoryCode = reader.getAttribute("category");
                ScriptCategory category = ScriptCategory.Companion.of(categoryCode);
                if (category == null) {
                    throw new IOException("Unknown category " + categoryCode);
                }
                builder = new ScriptingSingleModelTaskBuilder((BasicModel)model, category);
            } else {
                throw new IOException("Unknown type " + type);
            }
            builder.setVersion((Version)ObjectUtils.chooseNotNull((Object)Version.parse(reader.getAttribute("version")), (Object)Version.INFINITY));
            builder.setCurrentNamespace(ScriptingTaskSerialisation.recoverObject(builder.getModel(), reader.getAttribute("currentNamespace"), BasicNamespace.class));
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                if ("options".equals(reader.getNodeName())) {
                    LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
                    while (reader.hasMoreChildren()) {
                        reader.moveDown();
                        options.put(reader.getNodeName(), reader.getValue());
                        reader.moveUp();
                    }
                    builder.setOptions(ScriptingOptionStatic.importScriptingOptions(options));
                } else if ("correspondence".equals(reader.getNodeName()) && builder instanceof ScriptingAlterTaskBuilder) {
                    ScriptingAlterTaskBuilder alterTask = (ScriptingAlterTaskBuilder)builder;
                    while (reader.hasMoreChildren()) {
                        reader.moveDown();
                        BasicElement srcObj = ScriptingTaskSerialisation.recoverObject(alterTask.getModel(), reader.getAttribute("src"), BasicElement.class);
                        BasicElement tgtObj = ScriptingTaskSerialisation.recoverObject(alterTask.getTargetModel(), reader.getAttribute("tgt"), BasicElement.class);
                        alterTask.getCorrespondence().add(ElementDelta.create(srcObj, tgtObj));
                        reader.moveUp();
                    }
                } else if ("elements".equals(reader.getNodeName()) && builder instanceof ScriptingSingleModelTaskBuilder) {
                    ScriptingSingleModelTaskBuilder singleTask = (ScriptingSingleModelTaskBuilder)builder;
                    while (reader.hasMoreChildren()) {
                        reader.moveDown();
                        BasicElement obj2 = ScriptingTaskSerialisation.recoverObject(singleTask.getModel(), reader.getAttribute("path"), BasicElement.class);
                        singleTask.getElements().add(obj2);
                        reader.moveUp();
                    }
                }
                reader.moveUp();
            }
            return builder;
        });
        if (scriptingTaskBuilder == null) {
            ScriptingTaskSerialisation.$$$reportNull$$$0(0);
        }
        return scriptingTaskBuilder;
    }

    @Nullable
    private static <T extends BasicElement> T recoverObject(BasicModel model, String pathStr, Class<T> clazz) throws IOException {
        if (pathStr == null) {
            return null;
        }
        ObjectPath path = ObjectPath.deserialize(pathStr);
        if (path == null) {
            throw new IOException("Failed to deserialize path: " + pathStr);
        }
        T res2 = ScriptingTaskSerialisation.recoverObject(model, path, clazz);
        if (res2 == null) {
            throw new IOException("Failed to recover object " + path.getDisplayName());
        }
        return res2;
    }

    private static <T extends BasicElement> T recoverObject(BasicModel model, ObjectPath path, Class<T> clazz) {
        if (path == null) {
            return null;
        }
        if (path.kind == ObjectKind.ROOT) {
            return (T)((BasicElement)ObjectUtils.tryCast((Object)model.getRoot(), clazz));
        }
        return (T)((BasicElement)QNameUtil.findByPath(model, path).filter(clazz).first());
    }

    private static BasicModModel readModel(File file) throws IOException {
        return (BasicModModel)ScriptingTaskSerialisation.readFromFile(file, r -> new ModelImporter(new ModelFactory(new MemoryTextStorage())).deserialize((HierarchicalStreamReader)r, null));
    }

    @NotNull
    public static File dumpTask(File dumpDir, ScriptingTask task) throws IOException {
        File file = new File(dumpDir, "task.xml");
        ScriptingTaskSerialisation.writeToFile(file, (ThrowableConsumer<HierarchicalStreamWriter, IOException>)((ThrowableConsumer)writer -> {
            writer.startNode("task");
            writer.addAttribute("type", task instanceof ScriptingAlterTask ? "alter" : "single");
            writer.addAttribute("category", task.getCategory().getCode());
            writer.addAttribute("version", task.getVersion().toString());
            BasicNamespace namespace = (BasicNamespace)ObjectUtils.chooseNotNull((Object)task.getCurrentSchema(), (Object)task.getCurrentDatabase());
            if (namespace != null) {
                writer.addAttribute("currentNamespace", ObjectPaths.of(namespace).serialize());
            }
            LinkedHashMap<String, String> exported = new LinkedHashMap<String, String>();
            task.getOptions().export(exported);
            writer.startNode("options");
            for (Map.Entry entry : exported.entrySet()) {
                writer.startNode((String)entry.getKey());
                writer.setValue((String)entry.getValue());
                writer.endNode();
            }
            writer.endNode();
            if (task instanceof ScriptingAlterTask) {
                ScriptingAlterTask alterTask = (ScriptingAlterTask)task;
                writer.startNode("correspondence");
                for (ElementDelta<?> delta : alterTask.getCorrespondence()) {
                    writer.startNode("delta");
                    ObjectPath src = ObjectPaths.of(delta.getSourceElement());
                    ObjectPath tgt = ObjectPaths.of(delta.getTargetElement());
                    if (src != null) {
                        writer.addAttribute("src", src.serialize());
                    }
                    if (tgt != null) {
                        writer.addAttribute("tgt", tgt.serialize());
                    }
                    writer.endNode();
                }
                writer.endNode();
                ScriptingTaskSerialisation.dumpModel(new File(dumpDir, "sourceModel.xml"), alterTask.getSourceModel());
                ScriptingTaskSerialisation.dumpModel(new File(dumpDir, "targetModel.xml"), alterTask.getTargetModel());
            } else if (task instanceof ScriptingSingleModelTask) {
                ScriptingSingleModelTask singleTask = (ScriptingSingleModelTask)task;
                writer.startNode("elements");
                for (BasicElement element : singleTask.getElements()) {
                    writer.startNode("element");
                    ObjectPath path = ObjectPaths.of(element);
                    writer.addAttribute("path", path.serialize());
                    writer.endNode();
                }
                writer.endNode();
                ScriptingTaskSerialisation.dumpModel(new File(dumpDir, "model.xml"), singleTask.getModel());
            }
            writer.endNode();
        }));
        File file2 = file;
        if (file2 == null) {
            ScriptingTaskSerialisation.$$$reportNull$$$0(1);
        }
        return file2;
    }

    private static void dumpModel(@NotNull File file, @NotNull DasModel model) throws IOException {
        if (file == null) {
            ScriptingTaskSerialisation.$$$reportNull$$$0(2);
        }
        if (model == null) {
            ScriptingTaskSerialisation.$$$reportNull$$$0(3);
        }
        ScriptingTaskSerialisation.writeToFile(file, (ThrowableConsumer<HierarchicalStreamWriter, IOException>)((ThrowableConsumer)writer -> ModelSerializerKt.serialize(model, writer, null)));
    }

    private static void writeToFile(@NotNull File file, @NotNull ThrowableConsumer<HierarchicalStreamWriter, IOException> writer) throws IOException {
        if (file == null) {
            ScriptingTaskSerialisation.$$$reportNull$$$0(4);
        }
        if (writer == null) {
            ScriptingTaskSerialisation.$$$reportNull$$$0(5);
        }
        try (PrintWriter printWriter = new PrintWriter(new FileWriter(file, StandardCharsets.UTF_8));){
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.consume((Object)new PrettyPrintWriter(printWriter));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T readFromFile(@NotNull File file, @NotNull ThrowableConvertor<HierarchicalStreamReader, T, IOException> convertor) throws IOException {
        if (file == null) {
            ScriptingTaskSerialisation.$$$reportNull$$$0(6);
        }
        if (convertor == null) {
            ScriptingTaskSerialisation.$$$reportNull$$$0(7);
        }
        try (XppReader reader = new XppReader((Reader)new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8), new MXParser());){
            Object object = convertor.convert((Object)reader);
            return (T)object;
        }
    }

    public static ScriptingTask snapshot(@NotNull ScriptingTask task) {
        ScriptingTaskBuilder res2;
        if (task == null) {
            ScriptingTaskSerialisation.$$$reportNull$$$0(8);
        }
        return (res2 = ScriptingTaskSerialisation.copyTask(task, true)) == null ? task : res2.build();
    }

    public static ScriptingTaskBuilder copyTask(@NotNull ScriptingTask task, boolean copyModels) {
        ScriptingTaskBuilder builder;
        if (task == null) {
            ScriptingTaskSerialisation.$$$reportNull$$$0(9);
        }
        if (task instanceof ScriptingSingleModelTask) {
            ScriptingSingleModelTask singleModelTask = (ScriptingSingleModelTask)task;
            BasicModel model = copyModels ? ModelLightCopier.snapshot(ModelFactory.BLACK_HOLE, singleModelTask.getModel()) : singleModelTask.getModel();
            ScriptingSingleModelTaskBuilder singleBuilder = new ScriptingSingleModelTaskBuilder(model, task.getCategory());
            if (copyModels) {
                JBIterable.from(singleModelTask.getElements()).filterMap(e -> ScriptingTaskSerialisation.portObject(model, e)).addAllTo(singleBuilder.getElements());
            } else {
                singleBuilder.getElements().addAll(singleModelTask.getElements());
            }
            builder = singleBuilder;
        } else if (task instanceof ScriptingAlterTask) {
            ScriptingAlterTask alterTask = (ScriptingAlterTask)task;
            BasicModel sourceModel = copyModels ? ModelLightCopier.snapshot(ModelFactory.BLACK_HOLE, alterTask.getSourceModel()) : alterTask.getSourceModel();
            BasicModel targetModel = copyModels ? ModelLightCopier.snapshot(ModelFactory.BLACK_HOLE, alterTask.getTargetModel()) : alterTask.getTargetModel();
            ScriptingAlterTaskBuilder alterBuilder = new ScriptingAlterTaskBuilder(sourceModel, targetModel);
            if (copyModels) {
                JBIterable.from(alterTask.getCorrespondence()).filterMap(d -> ElementDelta.create(ScriptingTaskSerialisation.portObject(sourceModel, d.getSourceElement()), ScriptingTaskSerialisation.portObject(targetModel, d.getTargetElement()))).addAllTo(alterBuilder.getCorrespondence());
            } else {
                alterBuilder.getCorrespondence().addAll(alterTask.getCorrespondence());
            }
            builder = alterBuilder;
        } else {
            return null;
        }
        builder.setOptions(task.getOptions());
        builder.setVersion(task.getVersion());
        builder.setCurrentNamespace(copyModels ? ScriptingTaskSerialisation.portObject(builder.getModel(), task.getCurrentNamespace()) : task.getCurrentNamespace());
        return builder;
    }

    @Nullable
    private static <T extends BasicElement> T portObject(BasicModel model, T obj2) {
        if (obj2 == null) {
            return null;
        }
        return (T)ScriptingTaskSerialisation.recoverObject(model, ObjectPaths.of(obj2), obj2.getClass());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/script/generator/ScriptingTaskSerialisation";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertor";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "loadTask";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpTask";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/script/generator/ScriptingTaskSerialisation";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "dumpModel";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeToFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "readFromFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "snapshot";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "copyTask";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

