/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.script.translator.ToDatabaseScriptTranslator;
import com.intellij.database.script.translator.TranslateException;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ToDatabaseScriptTranslationAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ToDatabaseScriptTranslationAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    @Nullable
    private static Editor getEditor(AnActionEvent e) {
        Editor editor2 = (Editor)e.getData(CommonDataKeys.EDITOR);
        Project project = e.getProject();
        if (editor2 != null && project != null) {
            return (Editor)ObjectUtils.chooseNotNull((Object)BaseCodeInsightAction.getInjectedEditor((Project)project, (Editor)editor2, (boolean)false), (Object)editor2);
        }
        return editor2;
    }

    @Nullable
    private static PsiElement getQueryRootPsiElement(@NotNull Editor editor2, @NotNull PsiFile psiFile) {
        int queryOffset;
        PsiElement caretPsiElement;
        if (editor2 == null) {
            ToDatabaseScriptTranslationAction.$$$reportNull$$$0(1);
        }
        if (psiFile == null) {
            ToDatabaseScriptTranslationAction.$$$reportNull$$$0(2);
        }
        if ((caretPsiElement = psiFile.findElementAt(queryOffset = editor2.getCaretModel().getOffset())) == null) {
            return null;
        }
        return PsiTreeUtil.getTopmostParentOfType((PsiElement)caretPsiElement, SqlStatement.class);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ToDatabaseScriptTranslationAction.$$$reportNull$$$0(3);
        }
        Project project = e.getProject();
        Editor editor2 = ToDatabaseScriptTranslationAction.getEditor(e);
        PsiFile psiFile = project == null || editor2 == null ? null : PsiUtilBase.getPsiFileInEditor((Editor)editor2, (Project)project);
        SqlLanguageDialect sqlLanguageDialect = psiFile == null || !(psiFile.getLanguage() instanceof SqlLanguageDialect) ? null : (SqlLanguageDialect)psiFile.getLanguage();
        boolean isSupported = sqlLanguageDialect != null && ToDatabaseScriptTranslator.Companion.getEP().forLanguage((Language)sqlLanguageDialect) != null;
        boolean isSqlStatement = editor2 != null && psiFile != null && ToDatabaseScriptTranslationAction.getQueryRootPsiElement(editor2, psiFile) != null;
        Presentation presentation = e.getPresentation();
        boolean enabledAndVisible = isSupported && isSqlStatement;
        presentation.setEnabledAndVisible(enabledAndVisible);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        SqlLanguageDialect sqlLanguageDialect;
        Project project;
        if (e == null) {
            ToDatabaseScriptTranslationAction.$$$reportNull$$$0(4);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        Editor editor2 = ToDatabaseScriptTranslationAction.getEditor(e);
        if (editor2 == null) {
            return;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode() && !editor2.getContentComponent().isShowing()) {
            return;
        }
        PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor2, (Project)project);
        if (psiFile == null) {
            return;
        }
        Language language = psiFile.getLanguage();
        SqlLanguageDialect sqlLanguageDialect2 = sqlLanguageDialect = !(language instanceof SqlLanguageDialect) ? null : (SqlLanguageDialect)language;
        if (sqlLanguageDialect == null) {
            return;
        }
        ToDatabaseScriptTranslator translator = (ToDatabaseScriptTranslator)ToDatabaseScriptTranslator.Companion.getEP().forLanguage((Language)sqlLanguageDialect);
        if (translator == null) {
            return;
        }
        DatabaseErrorHandler errorHandler = DatabaseErrorHandler.EP.forDbms(sqlLanguageDialect.getDbms());
        if (errorHandler == null) {
            return;
        }
        PsiElement psiRootElement = ToDatabaseScriptTranslationAction.getQueryRootPsiElement(editor2, psiFile);
        if (psiRootElement == null) {
            return;
        }
        try {
            String translatedText = translator.translate(psiRootElement);
            PsiFile globalPsiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
            if (globalPsiFile == null) {
                return;
            }
            Language translatedLanguage = globalPsiFile.getLanguage();
            this.handleTranslatedQueryText(e, project, translatedLanguage, translatedText);
        }
        catch (TranslateException exception) {
            ApplicationManager.getApplication().invokeLater(() -> HintManager.getInstance().showErrorHint(editor2, exception.getMessage()));
        }
    }

    abstract void handleTranslatedQueryText(@NotNull AnActionEvent var1, @NotNull Project var2, @NotNull Language var3, @NotNull String var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/ToDatabaseScriptTranslationAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/ToDatabaseScriptTranslationAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getQueryRootPsiElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

