/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.console.RunSqlScriptAction;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dbimport.ImportUtil;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.MetaModel;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportFromSqlAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ImportFromSqlAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        JBIterable dataSource;
        DataContext dataContext;
        JBIterable<DbElement> elements;
        if (e == null) {
            ImportFromSqlAction.$$$reportNull$$$0(1);
        }
        if ((elements = DatabaseContextFun.getSelectedDbElementsWithParentsForGroups(dataContext = e.getDataContext())).processEach(ImportFromSqlAction::isSuitableElement) && (dataSource = elements.map(DbElement::getDataSource).unique()).processEach(ImportUtil::canConnectToAndModify)) {
            e.getPresentation().setEnabledAndVisible(true);
            return;
        }
        e.getPresentation().setEnabledAndVisible(false);
    }

    private static boolean isSuitableElement(@NotNull DbElement element) {
        if (element == null) {
            ImportFromSqlAction.$$$reportNull$$$0(2);
        }
        DatabaseDialectEx dialect = DbImplUtilCore.getDatabaseDialect(element);
        ObjectKind searchPathObjectKind = dialect.getSearchPathObjectKind();
        MetaModel model = DbImplUtilCore.getMetaModel(element);
        ObjectKind kind = element.getKind();
        return searchPathObjectKind == null && Holder.GENERIC_KINDS.contains(kind) || ImportFromSqlAction.isOnTheWayFromRootToSearchPathObject(model, searchPathObjectKind, kind);
    }

    private static boolean isOnTheWayFromRootToSearchPathObject(@NotNull MetaModel model, @Nullable ObjectKind searchPathObjectKind, @NotNull ObjectKind elementKind) {
        if (model == null) {
            ImportFromSqlAction.$$$reportNull$$$0(3);
        }
        if (elementKind == null) {
            ImportFromSqlAction.$$$reportNull$$$0(4);
        }
        if (searchPathObjectKind == null) {
            return false;
        }
        List path = (List)model.getPathsToRoot(searchPathObjectKind).first();
        return path != null && path.contains(elementKind);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ImportFromSqlAction.$$$reportNull$$$0(5);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        JBIterable<DbElement> elements = DatabaseContextFun.getSelectedDbElementsWithParentsForGroups(e.getDataContext());
        FileDocumentManager.getInstance().saveAllDocuments();
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(true, false, false, false, false, true);
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, (Project)project, null, files2 -> {
            List paths = elements.map(it -> {
                LocalDataSource dataSource = DbImplUtil.getLocalDataSource(it.getDataSource());
                Object delegate = it.getDelegate();
                return RunSqlScriptAction.makeTargetPair(dataSource, delegate);
            }).filter(Conditions.notNull()).toList();
            List result2 = JBIterable.from((Iterable)paths).filter(it -> !ContainerUtil.exists((Iterable)paths, pair -> ImportFromSqlAction.isAncestor((Pair<LocalDataSource, ObjectPath>)it, (Pair<LocalDataSource, ObjectPath>)pair))).toList();
            RunSqlScriptAction.INSTANCE.perform(project, (JBIterable<VirtualFile>)JBIterable.from((Iterable)files2), result2);
        });
    }

    private static boolean isAncestor(@NotNull Pair<LocalDataSource, ObjectPath> possibleAncestor, @NotNull Pair<LocalDataSource, ObjectPath> possibleChild) {
        if (possibleAncestor == null) {
            ImportFromSqlAction.$$$reportNull$$$0(6);
        }
        if (possibleChild == null) {
            ImportFromSqlAction.$$$reportNull$$$0(7);
        }
        ObjectPath ancestorPath = (ObjectPath)possibleAncestor.second;
        ObjectPath childPath = (ObjectPath)possibleChild.second;
        if (childPath == null) {
            return false;
        }
        if (ancestorPath == null) {
            return possibleAncestor.first == possibleChild.first;
        }
        return ancestorPath.isAncestorOf(childPath, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/actions/ImportFromSqlAction";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementKind";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleAncestor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleChild";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/actions/ImportFromSqlAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isOnTheWayFromRootToSearchPathObject";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAncestor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    private static class Holder {
        private static final List<ObjectKind> GENERIC_KINDS = Arrays.asList(ObjectKind.ROOT, ObjectKind.DATABASE, ObjectKind.SCHEMA);

        private Holder() {
        }
    }
}

