/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.config.mappings;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurable;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableTab;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableTabProvider;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableTabStub;
import com.jetbrains.plugins.webDeployment.ui.config.SettingsDeployable;
import com.jetbrains.plugins.webDeployment.ui.config.SettingsGroupedDeployable;
import com.jetbrains.plugins.webDeployment.ui.config.mappings.MappingsConfigurableTab;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MappingsConfigurableTabProvider
implements DeploymentConfigurableTabProvider {
    private static final Key<Map<String, List<DeploymentPathMapping>>> MAPPINGS = Key.create((String)"mappings");

    @Override
    public DeploymentConfigurableTab createTab(Project project, DeploymentConfigurableTabProvider.ServerStateProvider serverStateProvider, @NotNull UserDataHolder sharedData) {
        if (sharedData == null) {
            MappingsConfigurableTabProvider.$$$reportNull$$$0(0);
        }
        if (project != null && !project.isDefault()) {
            return new MappingsConfigurableTab(project, serverStateProvider, sharedData);
        }
        return new DeploymentConfigurableTabStub(MappingsConfigurableTab.getText(), 1, WDBundle.message("mappings.tab.stub.text", new Object[0]));
    }

    @Override
    public void reset(Project project, @NotNull UserDataHolder sharedData) {
        if (sharedData == null) {
            MappingsConfigurableTabProvider.$$$reportNull$$$0(1);
        }
        if (project == null || project.isDefault()) {
            return;
        }
        PublishConfig publishConfig = PublishConfig.getInstance(project);
        HashMap<String, List<DeploymentPathMapping>> mappings = new HashMap<String, List<DeploymentPathMapping>>();
        for (WebServerConfig server : GroupedServersConfigManager.getInstance(project).getFlattenedServers()) {
            mappings.put(server.getId(), publishConfig.getPathMappings(server.getId()));
        }
        MappingsConfigurableTabProvider.setMappings(mappings, sharedData);
    }

    @Override
    public void apply(Project project, List<SettingsGroupedDeployable> currentGroups, @NotNull UserDataHolder sharedData) {
        if (sharedData == null) {
            MappingsConfigurableTabProvider.$$$reportNull$$$0(2);
        }
        if (project == null || project.isDefault()) {
            return;
        }
        PublishConfig config = PublishConfig.getInstance(project);
        config.setPathMappings(DeploymentConfigurable.filterExistingServers(MappingsConfigurableTabProvider.getMappings(sharedData), currentGroups));
    }

    @Override
    public boolean dataIsEqual(Project project, SettingsDeployable o1, SettingsDeployable o2, @NotNull UserDataHolder sharedData) {
        if (sharedData == null) {
            MappingsConfigurableTabProvider.$$$reportNull$$$0(3);
        }
        if (project == null || project.isDefault()) {
            return true;
        }
        List<DeploymentPathMapping> m1 = MappingsConfigurableTabProvider.getMappings(sharedData, o1.getId());
        List<DeploymentPathMapping> m2 = MappingsConfigurableTabProvider.getMappings(sharedData, o2.getId());
        return Comparing.equal(m1, m2);
    }

    @Override
    public void onItemCreated(Project project, SettingsDeployable newItem, @NotNull UserDataHolder sharedData) {
        if (sharedData == null) {
            MappingsConfigurableTabProvider.$$$reportNull$$$0(4);
        }
        if (project == null || project.isDefault()) {
            return;
        }
        ArrayList<DeploymentPathMapping> mappings = new ArrayList<DeploymentPathMapping>();
        PublishConfig.addDefaultMappings(project, mappings);
        MappingsConfigurableTabProvider.putMappings(newItem.getId(), mappings, sharedData);
    }

    @Override
    public void onItemDeleted(Project project, SettingsDeployable item, @NotNull UserDataHolder sharedData) {
        if (sharedData == null) {
            MappingsConfigurableTabProvider.$$$reportNull$$$0(5);
        }
        if (project == null || project.isDefault()) {
            return;
        }
        MappingsConfigurableTabProvider.removeMappings(sharedData, item.getId());
    }

    @NotNull
    private static Map<String, List<DeploymentPathMapping>> getMappings(@NotNull UserDataHolder sharedData) {
        Map data;
        if (sharedData == null) {
            MappingsConfigurableTabProvider.$$$reportNull$$$0(6);
        }
        if ((data = (Map)sharedData.getUserData(MAPPINGS)) == null) {
            MappingsConfigurableTabProvider.setMappings(new HashMap<String, List<DeploymentPathMapping>>(), sharedData);
            return MappingsConfigurableTabProvider.getMappings(sharedData);
        }
        Map map = data;
        if (map == null) {
            MappingsConfigurableTabProvider.$$$reportNull$$$0(7);
        }
        return map;
    }

    @Nullable
    static List<DeploymentPathMapping> getMappings(@NotNull UserDataHolder sharedData, String serverId) {
        if (sharedData == null) {
            MappingsConfigurableTabProvider.$$$reportNull$$$0(8);
        }
        return MappingsConfigurableTabProvider.getMappings(sharedData).get(serverId);
    }

    static void removeMappings(@NotNull UserDataHolder sharedData, String serverId) {
        if (sharedData == null) {
            MappingsConfigurableTabProvider.$$$reportNull$$$0(9);
        }
        MappingsConfigurableTabProvider.getMappings(sharedData).remove(serverId);
    }

    static void putMappings(String serverId, List<DeploymentPathMapping> mappings, @NotNull UserDataHolder sharedData) {
        if (sharedData == null) {
            MappingsConfigurableTabProvider.$$$reportNull$$$0(10);
        }
        MappingsConfigurableTabProvider.getMappings(sharedData).put(serverId, mappings);
    }

    private static void setMappings(Map<String, List<DeploymentPathMapping>> mappings, @NotNull UserDataHolder sharedData) {
        if (sharedData == null) {
            MappingsConfigurableTabProvider.$$$reportNull$$$0(11);
        }
        sharedData.putUserData(MAPPINGS, mappings);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sharedData";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/config/mappings/MappingsConfigurableTabProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/config/mappings/MappingsConfigurableTabProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTab";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "dataIsEqual";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onItemCreated";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onItemDeleted";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMappings";
                break;
            }
            case 7: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeMappings";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "putMappings";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setMappings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

