/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowser;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesBrowserUseCase;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.CommittedChangeListPanel;
import com.intellij.openapi.vcs.changes.ui.browser.LoadingChangesPanel;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoadingCommittedChangeListPanel
implements Disposable {
    private final CommittedChangeListPanel myChangesPanel;
    private final LoadingChangesPanel myLoadingPanel;

    public LoadingCommittedChangeListPanel(@NotNull Project project) {
        if (project == null) {
            LoadingCommittedChangeListPanel.$$$reportNull$$$0(0);
        }
        this.myChangesPanel = new CommittedChangeListPanel(project);
        this.myLoadingPanel = new LoadingChangesPanel(this.myChangesPanel, this);
    }

    public void dispose() {
        this.myChangesPanel.getChangesBrowser().shutdown();
    }

    @NotNull
    public JComponent getContent() {
        LoadingChangesPanel loadingChangesPanel = this.myLoadingPanel;
        if (loadingChangesPanel == null) {
            LoadingCommittedChangeListPanel.$$$reportNull$$$0(1);
        }
        return loadingChangesPanel;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.myChangesPanel.getPreferredFocusedComponent();
        if (jComponent == null) {
            LoadingCommittedChangeListPanel.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    @NotNull
    public ChangesBrowserBase getChangesBrowser() {
        CommittedChangesBrowser committedChangesBrowser = this.myChangesPanel.getChangesBrowser();
        if (committedChangesBrowser == null) {
            LoadingCommittedChangeListPanel.$$$reportNull$$$0(3);
        }
        return committedChangesBrowser;
    }

    public void hideCommitMessage() {
        this.myChangesPanel.setShowCommitMessage(false);
    }

    public void hideSideBorders() {
        this.myChangesPanel.setShowSideBorders(false);
    }

    public void markChangesInAir(boolean inAir) {
        this.myChangesPanel.getChangesBrowser().setUseCase(inAir ? CommittedChangesBrowserUseCase.IN_AIR : null);
    }

    public void setDescription(@Nullable @NlsContexts.Label String description) {
        this.myChangesPanel.setDescription(description);
    }

    public void setChangeList(@NotNull CommittedChangeList changeList, @Nullable FilePath toSelect) {
        if (changeList == null) {
            LoadingCommittedChangeListPanel.$$$reportNull$$$0(4);
        }
        this.myChangesPanel.setChangeList(changeList);
        this.myChangesPanel.getChangesBrowser().getViewer().invokeAfterRefresh(() -> this.myChangesPanel.getChangesBrowser().getViewer().selectFile(toSelect));
    }

    public void setChanges(@NotNull Collection<Change> changes, @Nullable FilePath toSelect) {
        if (changes == null) {
            LoadingCommittedChangeListPanel.$$$reportNull$$$0(5);
        }
        this.hideCommitMessage();
        this.setChangeList((CommittedChangeList)CommittedChangeListPanel.createChangeList(changes), toSelect);
    }

    public void loadChangesInBackground(@NotNull ThrowableComputable<? extends ChangelistData, ? extends VcsException> computable) {
        if (computable == null) {
            LoadingCommittedChangeListPanel.$$$reportNull$$$0(6);
        }
        this.myLoadingPanel.loadChangesInBackground(computable, result2 -> {
            if (result2 != null) {
                this.setChangeList(result2.changeList, result2.toSelect);
            } else {
                this.setChangeList((CommittedChangeList)CommittedChangeListPanel.createChangeList(Collections.emptySet()), null);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ui/LoadingCommittedChangeListPanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeList";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/LoadingCommittedChangeListPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesBrowser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setChangeList";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setChanges";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadChangesInBackground";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }

    public static class ChangelistData {
        @NotNull
        public final CommittedChangeList changeList;
        @Nullable
        public final FilePath toSelect;

        public ChangelistData(@NotNull CommittedChangeList changeList, @Nullable FilePath toSelect) {
            if (changeList == null) {
                ChangelistData.$$$reportNull$$$0(0);
            }
            this.changeList = changeList;
            this.toSelect = toSelect;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeList", "com/intellij/openapi/vcs/changes/ui/LoadingCommittedChangeListPanel$ChangelistData", "<init>"));
        }
    }
}

