/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnostic;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnosticDumper;
import com.intellij.util.indexing.diagnostic.dump.paths.IndexedFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePath;
import com.intellij.util.indexing.diagnostic.dump.paths.PortableFilePathsKt;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.commands.StoreIndices;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import com.jetbrains.performancePlugin.utils.errors.ErrorCollector;
import com.jetbrains.performancePlugin.utils.errors.ToDirectoryWritingErrorCollector;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/performancePlugin/commands/CompareProjectFiles;", "Lcom/intellij/openapi/ui/playback/commands/AbstractCommand;", "text", "", "line", "", "<init>", "(Ljava/lang/String;I)V", "_execute", "Lorg/jetbrains/concurrency/Promise;", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "getFailureDiagnosticDirectory", "Ljava/nio/file/Path;", "Companion", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nCompareProjectFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompareProjectFiles.kt\ncom/jetbrains/performancePlugin/commands/CompareProjectFiles\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,230:1\n1557#2:231\n1628#2,3:232\n827#2:235\n855#2,2:236\n15#3:238\n*S KotlinDebug\n*F\n+ 1 CompareProjectFiles.kt\ncom/jetbrains/performancePlugin/commands/CompareProjectFiles\n*L\n182#1:231\n182#1:232,3\n182#1:235\n182#1:236,2\n30#1:238\n*E\n"})
public final class CompareProjectFiles
extends AbstractCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PREFIX = "%compareProjectFiles";
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final List<String> meaningfulDebugNames;
    @NotNull
    private static final Lazy<List<String>> ignoredFilesPatterns$delegate;

    public CompareProjectFiles(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        String property;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        String string = this.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = string;
        int n = 20;
        String string3 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String input = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        String[] stringArray = new String[]{" "};
        List index = StringsKt.split$default((CharSequence)input, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String string4 = property = System.getProperty("dump.project.files.directory");
        if (string4 == null) {
            actionCallback.reject("dump.project.files.directory property must be specified");
            return Promises.toPromise((ActionCallback)actionCallback);
        }
        Path expectedDirectory = Paths.get(string4, new String[0]);
        Path actualDirectory = Paths.get((String)index.get(0), new String[0]);
        Path failureDiagnosticDirectory = this.getFailureDiagnosticDirectory();
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        DumbService.Companion.getInstance(project2).smartInvokeLater(() -> CompareProjectFiles._execute$lambda$0(project2, expectedDirectory, actualDirectory, failureDiagnosticDirectory, actionCallback));
        return Promises.toPromise((ActionCallback)actionCallback);
    }

    private final Path getFailureDiagnosticDirectory() {
        String property = System.getProperty("compare.project.files.command.failure.diagnostic.directory");
        if (property != null) {
            Path path = Paths.get(property, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return path;
        }
        Path path = FileUtil.createTempDirectory((String)"compare-project-files", (String)"failure").toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return path;
    }

    private static final void _execute$lambda$0(Project $project, Path $expectedDirectory, Path $actualDirectory, Path $failureDiagnosticDirectory, ActionCallbackProfilerStopper $actionCallback) {
        String string = PerformanceTestingBundle.message("comparing.project.files", new Object[0]);
        new Task.Modal($project, $expectedDirectory, $actualDirectory, $failureDiagnosticDirectory, $actionCallback, string){
            final /* synthetic */ Path $expectedDirectory;
            final /* synthetic */ Path $actualDirectory;
            final /* synthetic */ Path $failureDiagnosticDirectory;
            final /* synthetic */ ActionCallbackProfilerStopper $actionCallback;
            {
                this.$expectedDirectory = $expectedDirectory;
                this.$actualDirectory = $actualDirectory;
                this.$failureDiagnosticDirectory = $failureDiagnosticDirectory;
                this.$actionCallback = $actionCallback;
                super($project, $super_call_param$1, false);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                try {
                    FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
                    Intrinsics.checkNotNull((Object)fileBasedIndex, (String)"null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
                    ((FileBasedIndexImpl)fileBasedIndex).flushIndexes();
                    Path path = this.$expectedDirectory;
                    Intrinsics.checkNotNull((Object)path);
                    Path path2 = path;
                    path = this.$actualDirectory;
                    Intrinsics.checkNotNull((Object)path);
                    com.jetbrains.performancePlugin.commands.CompareProjectFiles$Companion.access$compareProjectFiles(CompareProjectFiles.Companion, path2, path, this.$failureDiagnosticDirectory, indicator);
                    this.$actionCallback.setDone();
                }
                catch (Throwable e) {
                    CompareProjectFiles.access$getLOG$cp().error(e);
                    ActionCallback actionCallback = this.$actionCallback.reject(e.getMessage());
                    Intrinsics.checkNotNull((Object)actionCallback);
                }
            }
        }.queue();
    }

    /*
     * WARNING - void declaration
     */
    private static final List ignoredFilesPatterns_delegate$lambda$3() {
        void $this$filterNotTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        String string = System.getProperty("compare.project.files.list.of.files.to.ignore.from.comparison");
        if (string == null) {
            return CollectionsKt.emptyList();
        }
        String listPath = string;
        Path path = Paths.get(listPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Iterable $this$map$iv = StringsKt.lines((CharSequence)PathsKt.readText$default((Path)path, null, (int)1, null));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (((CharSequence)it).length() == 0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List patterns = (List)destination$iv$iv;
        LOG.info("The following files will be ignored from project files comparison:\n" + CollectionsKt.joinToString$default((Iterable)patterns, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        return patterns;
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CompareProjectFiles.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Object[] objectArray = new String[]{"Module", "Library", "SDK", "JDK", "Synthetic library", "Go SDK module"};
        meaningfulDebugNames = CollectionsKt.listOf((Object[])objectArray);
        ignoredFilesPatterns$delegate = LazyKt.lazy(CompareProjectFiles::ignoredFilesPatterns_delegate$lambda$3);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bH\u0007\u00a2\u0006\u0002\u0010\fJ(\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\\\u0010\u0016\u001a\u00020\t2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0005H\u0002J$\u0010\"\u001a\u00020\t2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050\u00152\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b&\u0010'\u00a8\u0006*"}, d2={"Lcom/jetbrains/performancePlugin/commands/CompareProjectFiles$Companion;", "", "<init>", "()V", "PREFIX", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "main", "", "args", "", "([Ljava/lang/String;)V", "compareProjectFiles", "expectedDirectory", "Ljava/nio/file/Path;", "actualDirectory", "failureDiagnosticDirectory", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "meaningfulDebugNames", "", "compareSetsOfFiles", "expectedIds", "", "", "expectedFileIdToFile", "", "Lcom/intellij/util/indexing/diagnostic/dump/paths/IndexedFilePath;", "actualIds", "actualFileIdToFile", "errorCollector", "Lcom/jetbrains/performancePlugin/utils/errors/ToDirectoryWritingErrorCollector;", "iteratorName", "compareSetsOfIndexableIterators", "expectedIteratorNames", "actualIteratorNames", "ignoredFilesPatterns", "getIgnoredFilesPatterns", "()Ljava/util/List;", "ignoredFilesPatterns$delegate", "Lkotlin/Lazy;", "intellij.performanceTesting"})
    @SourceDebugExtension(value={"SMAP\nCompareProjectFiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompareProjectFiles.kt\ncom/jetbrains/performancePlugin/commands/CompareProjectFiles$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,230:1\n3193#2,4:231\n1755#2,3:235\n3197#2,6:238\n3193#2,4:244\n1755#2,3:248\n3197#2,6:251\n1202#2,2:257\n1230#2,4:259\n1202#2,2:263\n1230#2,4:265\n1368#2:269\n1454#2,5:270\n1368#2:275\n1454#2,5:276\n1755#2,3:281\n1611#2,9:284\n1863#2:293\n1864#2:295\n1620#2:296\n1202#2,2:297\n1230#2,4:299\n2632#2,3:306\n1611#2,9:313\n1863#2:322\n1864#2:324\n1620#2:325\n1202#2,2:326\n1230#2,4:328\n2632#2,3:335\n1863#2,2:342\n1863#2,2:344\n1#3:294\n1#3:323\n487#4,3:303\n490#4,4:309\n487#4,3:332\n490#4,4:338\n*S KotlinDebug\n*F\n+ 1 CompareProjectFiles.kt\ncom/jetbrains/performancePlugin/commands/CompareProjectFiles$Companion\n*L\n48#1:231,4\n49#1:235,3\n48#1:238,6\n51#1:244,4\n52#1:248,3\n51#1:251,6\n65#1:257,2\n65#1:259,4\n66#1:263,2\n66#1:265,4\n83#1:269\n83#1:270,5\n86#1:275\n86#1:276,5\n99#1:281,3\n119#1:284,9\n119#1:293\n119#1:295\n119#1:296\n120#1:297,2\n120#1:299,4\n121#1:306,3\n124#1:313,9\n124#1:322\n124#1:324\n124#1:325\n125#1:326,2\n125#1:328,4\n126#1:335,3\n135#1:342,2\n137#1:344,2\n119#1:294\n124#1:323\n121#1:303,3\n121#1:309,4\n126#1:332,3\n126#1:338,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Path expectedPath = Paths.get(args[0], new String[0]);
            Path actualPath = Paths.get(args[1], new String[0]);
            Intrinsics.checkNotNull((Object)expectedPath);
            Intrinsics.checkNotNull((Object)actualPath);
            Path path = actualPath.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
            this.compareProjectFiles(expectedPath, actualPath, path, (ProgressIndicator)new ProgressIndicatorBase());
        }

        /*
         * WARNING - void declaration
         */
        private final void compareProjectFiles(Path expectedDirectory, Path actualDirectory, Path failureDiagnosticDirectory, ProgressIndicator indicator) {
            boolean bl;
            block21: {
                void $this$flatMapTo$iv$iv;
                void $this$flatMapTo$iv$iv2;
                Iterable expectedIds;
                Object[] $this$associateByTo$iv$iv;
                Map map;
                void $this$associateByTo$iv$iv2;
                Iterable $this$any$iv;
                IndexContentDiagnostic expectedContentDiagnostic = IndexContentDiagnosticDumper.INSTANCE.readFrom(StoreIndices.Companion.getFileForDiagnostic(expectedDirectory));
                IndexContentDiagnostic actualContentDiagnostic = IndexContentDiagnosticDumper.INSTANCE.readFrom(StoreIndices.Companion.getFileForDiagnostic(actualDirectory));
                Iterable $this$partition$iv = expectedContentDiagnostic.getProjectIndexedFileProviderDebugNameToFileIds().keySet();
                boolean $i$f$partition = false;
                ArrayList first$iv = new ArrayList();
                ArrayList second$iv = new ArrayList();
                for (Object element$iv : $this$partition$iv) {
                    boolean bl2;
                    block19: {
                        String name = (String)element$iv;
                        boolean bl3 = false;
                        Iterable $this$any$iv2 = meaningfulDebugNames;
                        boolean $i$f$any = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                String it = (String)element$iv2;
                                boolean bl4 = false;
                                if (!StringsKt.startsWith$default((String)name, (String)it, (boolean)false, (int)2, null)) continue;
                                bl2 = true;
                                break block19;
                            }
                            bl2 = false;
                        }
                    }
                    boolean bl3 = bl2 ? first$iv.add(element$iv) : second$iv.add(element$iv);
                }
                Pair pair = new Pair(first$iv, second$iv);
                List expectedIteratorNames = (List)pair.component1();
                List expectedUnstableNames = (List)pair.component2();
                Iterable $this$partition$iv2 = actualContentDiagnostic.getProjectIndexedFileProviderDebugNameToFileIds().keySet();
                boolean $i$f$partition2 = false;
                ArrayList first$iv2 = new ArrayList();
                ArrayList second$iv2 = new ArrayList();
                for (Object element$iv : $this$partition$iv2) {
                    boolean bl4;
                    block20: {
                        String name = (String)element$iv;
                        boolean bl7 = false;
                        $this$any$iv = meaningfulDebugNames;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl4 = false;
                        } else {
                            for (Object element$iv3 : $this$any$iv) {
                                String it = (String)element$iv3;
                                boolean bl5 = false;
                                if (!StringsKt.startsWith$default((String)name, (String)it, (boolean)false, (int)2, null)) continue;
                                bl4 = true;
                                break block20;
                            }
                            bl4 = false;
                        }
                    }
                    boolean bl6 = bl4 ? first$iv2.add(element$iv) : second$iv2.add(element$iv);
                }
                Pair pair2 = new Pair(first$iv2, second$iv2);
                List actualIteratorNames = (List)pair2.component1();
                List actualUnstableNames = (List)pair2.component2();
                ArrayList<ToDirectoryWritingErrorCollector> errorCollectors = new ArrayList<ToDirectoryWritingErrorCollector>();
                Path path = failureDiagnosticDirectory.resolve("errors-for-set-of-iterators");
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                ToDirectoryWritingErrorCollector collector = new ToDirectoryWritingErrorCollector("set-of-iterators", path, 100);
                errorCollectors.add(collector);
                collector.runCatchingError(() -> Companion.compareProjectFiles$lambda$4(expectedIteratorNames, actualIteratorNames));
                Iterable $this$associateBy$iv = expectedContentDiagnostic.getAllIndexedFilePaths();
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                $this$any$iv = $this$associateBy$iv;
                Object destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv2) {
                    IndexedFilePath indexedFilePath = (IndexedFilePath)element$iv$iv;
                    map = destination$iv$iv;
                    boolean bl10 = false;
                    map.put(indexedFilePath.getOriginalFileSystemId(), element$iv$iv);
                }
                Map expectedFileIdToFile = destination$iv$iv;
                Iterable $this$associateBy$iv2 = actualContentDiagnostic.getAllIndexedFilePaths();
                boolean $i$f$associateBy2 = false;
                int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv2, (int)10)), (int)16);
                destination$iv$iv = $this$associateBy$iv2;
                Map destination$iv$iv2 = new LinkedHashMap(capacity$iv2);
                boolean $i$f$associateByTo2 = false;
                for (Object e : $this$associateByTo$iv$iv) {
                    void it;
                    IndexedFilePath bl10 = (IndexedFilePath)e;
                    map = destination$iv$iv2;
                    boolean bl11 = false;
                    map.put(it.getOriginalFileSystemId(), e);
                }
                Map actualFileIdToFile = destination$iv$iv2;
                for (String iteratorName : expectedIteratorNames) {
                    Set set;
                    Path path2 = failureDiagnosticDirectory.resolve("errors-for-" + FileUtil.sanitizeFileName((String)iteratorName));
                    Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
                    ToDirectoryWritingErrorCollector errorCollector = new ToDirectoryWritingErrorCollector(iteratorName, path2, 100);
                    ((Collection)errorCollectors).add(errorCollector);
                    $this$associateByTo$iv$iv = new Object[]{iteratorName};
                    indicator.setText(PerformanceTestingBundle.message("comparing.project.files.for.0", $this$associateByTo$iv$iv));
                    Iterable iterable = (Set)expectedContentDiagnostic.getProjectIndexedFileProviderDebugNameToFileIds().get(iteratorName);
                    if (iterable == null) {
                        iterable = expectedIds = SetsKt.emptySet();
                    }
                    if ((set = (Set)actualContentDiagnostic.getProjectIndexedFileProviderDebugNameToFileIds().get(iteratorName)) == null) {
                        set = SetsKt.emptySet();
                    }
                    Set actualIds = set;
                    this.compareSetsOfFiles(expectedIds, expectedFileIdToFile, actualIds, actualFileIdToFile, errorCollector, iteratorName);
                }
                Iterable $this$flatMap$iv = expectedUnstableNames;
                boolean $i$f$flatMap = false;
                expectedIds = $this$flatMap$iv;
                Iterable destination$iv$iv3 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object e : $this$flatMapTo$iv$iv2) {
                    String it = (String)e;
                    boolean bl12 = false;
                    Iterable list$iv$iv = (Iterable)MapsKt.getValue((Map)expectedContentDiagnostic.getProjectIndexedFileProviderDebugNameToFileIds(), (Object)it);
                    CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
                }
                List expectedUnstableIds = (List)destination$iv$iv3;
                Iterable $this$flatMap$iv2 = actualUnstableNames;
                boolean $i$f$flatMap2 = false;
                destination$iv$iv3 = $this$flatMap$iv2;
                Collection destination$iv$iv32 = new ArrayList();
                boolean $i$f$flatMapTo2 = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl13 = false;
                    Iterable list$iv$iv = (Iterable)MapsKt.getValue((Map)actualContentDiagnostic.getProjectIndexedFileProviderDebugNameToFileIds(), (Object)it);
                    CollectionsKt.addAll((Collection)destination$iv$iv32, (Iterable)list$iv$iv);
                }
                List actualUnstableIds = (List)destination$iv$iv32;
                String unstableIteratorsName = "iterators-with-unstable-names";
                Path path3 = failureDiagnosticDirectory.resolve("errors-for-" + unstableIteratorsName);
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
                ToDirectoryWritingErrorCollector errorCollector = new ToDirectoryWritingErrorCollector(unstableIteratorsName, path3, 100);
                ((Collection)errorCollectors).add(errorCollector);
                this.compareSetsOfFiles(expectedUnstableIds, expectedFileIdToFile, actualUnstableIds, actualFileIdToFile, errorCollector, unstableIteratorsName);
                Iterable $this$any$iv3 = errorCollectors;
                boolean $i$f$any = false;
                if ($this$any$iv3 instanceof Collection && ((Collection)$this$any$iv3).isEmpty()) {
                    bl = false;
                } else {
                    for (Object t : $this$any$iv3) {
                        ErrorCollector it = (ErrorCollector)t;
                        boolean bl14 = false;
                        if (!(it.getNumberOfErrors() > 0)) continue;
                        bl = true;
                        break block21;
                    }
                    bl = false;
                }
            }
            if (bl) {
                throw new RuntimeException("Some errors during files comparison have been collected. See details in " + failureDiagnosticDirectory);
            }
            LOG.info("Success. Project files are equal");
        }

        /*
         * WARNING - void declaration
         */
        private final void compareSetsOfFiles(Iterable<Integer> expectedIds, Map<Integer, IndexedFilePath> expectedFileIdToFile, Iterable<Integer> actualIds, Map<Integer, IndexedFilePath> actualFileIdToFile, ToDirectoryWritingErrorCollector errorCollector, String iteratorName) {
            void $this$filterKeys$iv;
            Object $this$associateByTo$iv$iv;
            Map $this$associateBy$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            void $this$filterKeys$iv2;
            Object object;
            Iterator $this$associateByTo$iv$iv2;
            Map $this$associateBy$iv2;
            Object element$iv$iv$iv;
            void $this$mapNotNullTo$iv$iv2;
            Iterable $this$mapNotNull$iv2;
            Iterable<Integer> iterable = expectedIds;
            boolean $i$f$mapNotNull = false;
            void var10_10 = $this$mapNotNull$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach22 = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                IndexedFilePath it$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                int it = ((Number)element$iv$iv).intValue();
                boolean bl2 = false;
                if (expectedFileIdToFile.get(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv2 = (List)destination$iv$iv;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associateBy$iv2), (int)10)), (int)16);
            destination$iv$iv = $this$associateBy$iv2;
            Object destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            Iterator $i$f$forEach22 = $this$associateByTo$iv$iv2.iterator();
            while ($i$f$forEach22.hasNext()) {
                void it;
                Object element$iv$iv = $i$f$forEach22.next();
                element$iv$iv$iv = (IndexedFilePath)element$iv$iv;
                object = destination$iv$iv2;
                boolean bl = false;
                object.put(it.getPortableFilePath(), element$iv$iv);
            }
            $this$associateBy$iv2 = destination$iv$iv2;
            boolean $i$f$filterKeys22 = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterKeys$iv2.entrySet()) {
                boolean bl;
                block18: {
                    PortableFilePath file = (PortableFilePath)entry$iv.getKey();
                    boolean bl4 = false;
                    Iterable $this$none$iv = Companion.getIgnoredFilesPatterns();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            String it = (String)element$iv;
                            boolean bl5 = false;
                            if (!PortableFilePathsKt.hasPresentablePathMatching((PortableFilePath)file, (String)it)) continue;
                            bl = false;
                            break block18;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Map expectedFiles = result$iv;
            Iterable<Integer> $i$f$filterKeys22 = actualIds;
            boolean $i$f$mapNotNull2 = false;
            $this$associateByTo$iv$iv2 = $this$mapNotNull$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach32 = false;
            Iterator $i$f$none = $this$forEach$iv$iv$iv2.iterator();
            while ($i$f$none.hasNext()) {
                IndexedFilePath it$iv$iv;
                Object element$iv$iv$iv2;
                Object element$iv$iv = element$iv$iv$iv2 = $i$f$none.next();
                boolean bl = false;
                int it = ((Number)element$iv$iv).intValue();
                boolean bl6 = false;
                if (actualFileIdToFile.get(it) == null) continue;
                boolean bl7 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv2;
            boolean $i$f$associateBy2 = false;
            int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$associateBy$iv), (int)10)), (int)16);
            destination$iv$iv2 = $this$associateBy$iv;
            Map destination$iv$iv3 = new LinkedHashMap(capacity$iv2);
            boolean $i$f$associateByTo2 = false;
            Iterator $i$f$forEach32 = $this$associateByTo$iv$iv.iterator();
            while ($i$f$forEach32.hasNext()) {
                void it;
                Object element$iv$iv = $i$f$forEach32.next();
                IndexedFilePath element$iv$iv$iv2 = (IndexedFilePath)element$iv$iv;
                object = destination$iv$iv3;
                boolean bl9 = false;
                object.put(it.getPortableFilePath(), element$iv$iv);
            }
            $this$associateBy$iv = destination$iv$iv3;
            boolean $i$f$filterKeys = false;
            LinkedHashMap result$iv2 = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
                boolean bl;
                block19: {
                    PortableFilePath file = (PortableFilePath)entry$iv.getKey();
                    boolean bl8 = false;
                    Iterator $this$none$iv = Companion.getIgnoredFilesPatterns();
                    boolean $i$f$none2 = false;
                    if ($this$none$iv instanceof Collection && ((Collection)((Object)$this$none$iv)).isEmpty()) {
                        bl = true;
                    } else {
                        Iterator bl9 = $this$none$iv.iterator();
                        while (bl9.hasNext()) {
                            Object element$iv = bl9.next();
                            String it = (String)element$iv;
                            boolean bl10 = false;
                            if (!PortableFilePathsKt.hasPresentablePathMatching((PortableFilePath)file, (String)it)) continue;
                            bl = false;
                            break block19;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                result$iv2.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Map actualFiles = result$iv2;
            Set missingFilePaths = SetsKt.minus(expectedFiles.keySet(), (Iterable)actualFiles.keySet());
            Set redundantFilePaths = SetsKt.minus(actualFiles.keySet(), (Iterable)expectedFiles.keySet());
            if (!((Collection)missingFilePaths).isEmpty() || !((Collection)redundantFilePaths).isEmpty()) {
                void $this$compareSetsOfFiles_u24lambda_u2420;
                Object object2;
                $this$associateByTo$iv$iv = object2 = new StringBuilder();
                object = errorCollector;
                boolean bl = false;
                $this$compareSetsOfFiles_u24lambda_u2420.append("The sets of indexed files for " + iteratorName + " do not match").append('\n');
                $this$compareSetsOfFiles_u24lambda_u2420.append("  Missing file paths:").append('\n');
                Iterable $this$forEach$iv = missingFilePaths;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PortableFilePath it = (PortableFilePath)element$iv;
                    boolean bl11 = false;
                    $this$compareSetsOfFiles_u24lambda_u2420.append("    " + it.getPresentablePath()).append('\n');
                }
                $this$compareSetsOfFiles_u24lambda_u2420.append("  Redundant file paths:").append('\n');
                $this$forEach$iv = redundantFilePaths;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PortableFilePath it = (PortableFilePath)element$iv;
                    boolean bl12 = false;
                    $this$compareSetsOfFiles_u24lambda_u2420.append("    " + it.getPresentablePath()).append('\n');
                }
                String string = ((StringBuilder)object2).toString();
                ((ToDirectoryWritingErrorCollector)object).addError(new RuntimeException(string));
            }
            if (errorCollector.getNumberOfErrors() > 0) {
                return;
            }
            for (PortableFilePath filePath : expectedFiles.keySet()) {
                IndexedFilePath actualData;
                IndexedFilePath expectedIndexedFile = (IndexedFilePath)MapsKt.getValue((Map)expectedFiles, (Object)filePath);
                IndexedFilePath actualIndexedFile = (IndexedFilePath)MapsKt.getValue((Map)actualFiles, (Object)filePath);
                IndexedFilePath expectedData = IndexedFilePath.copy$default((IndexedFilePath)expectedIndexedFile, (int)0, null, null, null, (String)"", null, null, null, null, (int)494, null);
                if (!Intrinsics.areEqual((Object)expectedData, (Object)(actualData = IndexedFilePath.copy$default((IndexedFilePath)actualIndexedFile, (int)0, null, null, null, (String)"", null, null, null, null, (int)494, null)))) {
                    void $this$compareSetsOfFiles_u24lambda_u2423;
                    StringBuilder stringBuilder;
                    StringBuilder it = stringBuilder = new StringBuilder();
                    object = errorCollector;
                    boolean bl = false;
                    $this$compareSetsOfFiles_u24lambda_u2423.append("Indexed file " + filePath.getPresentablePath() + " data mismatch").append('\n');
                    $this$compareSetsOfFiles_u24lambda_u2423.append("  Expected:").append('\n');
                    $this$compareSetsOfFiles_u24lambda_u2423.append(SequencesKt.joinToString$default((Sequence)StringsKt.lineSequence((CharSequence)expectedIndexedFile.toString()), (CharSequence)"\n", null, null, (int)0, null, Companion::compareSetsOfFiles$lambda$23$lambda$21, (int)30, null)).append('\n');
                    $this$compareSetsOfFiles_u24lambda_u2423.append("  Actual:").append('\n');
                    $this$compareSetsOfFiles_u24lambda_u2423.append(SequencesKt.joinToString$default((Sequence)StringsKt.lineSequence((CharSequence)actualIndexedFile.toString()), (CharSequence)"\n", null, null, (int)0, null, Companion::compareSetsOfFiles$lambda$23$lambda$22, (int)30, null)).append('\n');
                    String string = stringBuilder.toString();
                    ((ToDirectoryWritingErrorCollector)object).addError(new RuntimeException(string));
                }
                if (errorCollector.getNumberOfErrors() <= 100) continue;
                break;
            }
        }

        private final void compareSetsOfIndexableIterators(List<String> expectedIteratorNames, List<String> actualIteratorNames) {
            List missingIteratorNames = CollectionsKt.minus((Iterable)expectedIteratorNames, (Iterable)actualIteratorNames);
            List redundantIteratorNames = CollectionsKt.minus((Iterable)actualIteratorNames, (Iterable)expectedIteratorNames);
            if (!((Collection)missingIteratorNames).isEmpty() || !((Collection)redundantIteratorNames).isEmpty()) {
                CharSequence charSequence = new StringBuilder();
                StringBuilder $this$compareSetsOfIndexableIterators_u24lambda_u2424 = charSequence;
                boolean bl = false;
                $this$compareSetsOfIndexableIterators_u24lambda_u2424.append("The sets of indexable file iterators do not match").append('\n');
                $this$compareSetsOfIndexableIterators_u24lambda_u2424.append("  Missing iterators: [" + CollectionsKt.joinToString$default((Iterable)missingIteratorNames, null, null, null, (int)0, null, null, (int)63, null) + "]").append('\n');
                $this$compareSetsOfIndexableIterators_u24lambda_u2424.append("  Redundant iterators: [" + CollectionsKt.joinToString$default((Iterable)redundantIteratorNames, null, null, null, (int)0, null, null, (int)63, null) + "]").append('\n');
                charSequence = ((StringBuilder)charSequence).toString();
                throw new IllegalStateException(((Object)charSequence).toString());
            }
        }

        private final List<String> getIgnoredFilesPatterns() {
            Lazy lazy = ignoredFilesPatterns$delegate;
            return (List)lazy.getValue();
        }

        private static final Unit compareProjectFiles$lambda$4(List $expectedIteratorNames, List $actualIteratorNames) {
            Companion.compareSetsOfIndexableIterators($expectedIteratorNames, $actualIteratorNames);
            return Unit.INSTANCE;
        }

        private static final CharSequence compareSetsOfFiles$lambda$23$lambda$21(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return "    " + it;
        }

        private static final CharSequence compareSetsOfFiles$lambda$23$lambda$22(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return "    " + it;
        }

        public static final /* synthetic */ void access$compareProjectFiles(Companion $this, Path expectedDirectory, Path actualDirectory, Path failureDiagnosticDirectory, ProgressIndicator indicator) {
            $this.compareProjectFiles(expectedDirectory, actualDirectory, failureDiagnosticDirectory, indicator);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

