/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.nextjs.inspections;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.frameworks.nextjs.UtilKt;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016R\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u0012j\b\u0012\u0004\u0012\u00020\u0013`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u0012j\b\u0012\u0004\u0012\u00020\u0013`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u0012j\b\u0012\u0004\u0012\u00020\u0013`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u0012\u0012\u0004\u0012\u00020\u00130\u0012j\b\u0012\u0004\u0012\u00020\u0013`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/lang/javascript/frameworks/nextjs/inspections/NextJsImplicitUsageProvider;", "Lcom/intellij/codeInsight/daemon/ImplicitUsageProvider;", "<init>", "()V", "isImplicitUsage", "", "element", "Lcom/intellij/psi/PsiElement;", "isKnownFunctionName", "isKnownObjectName", "isExportDefault", "isInAppDir", "isRouteSegmentOption", "isHttpMethod", "isMiddlewareFunctionOrItsConfig", "isImplicitRead", "isImplicitWrite", "KNOWN_FUNCTIONS", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "KNOWN_OBJECTS", "ROUTE_SEGMENT_OPTIONS", "HTTP_METHOD_FUNCTIONS", "intellij.nextjs"})
public final class NextJsImplicitUsageProvider
implements ImplicitUsageProvider {
    @NotNull
    private final HashSet<String> KNOWN_FUNCTIONS;
    @NotNull
    private final HashSet<String> KNOWN_OBJECTS;
    @NotNull
    private final HashSet<String> ROUTE_SEGMENT_OPTIONS;
    @NotNull
    private final HashSet<String> HTTP_METHOD_FUNCTIONS;

    public NextJsImplicitUsageProvider() {
        Object[] objectArray = new String[]{"getServerSideProps", "getStaticPaths", "getStaticProps", "generateStaticParams", "generateMetadata", "generateImageMetadata", "generateViewport"};
        this.KNOWN_FUNCTIONS = SetsKt.hashSetOf((Object[])objectArray);
        objectArray = new String[]{"metadata", "viewport"};
        this.KNOWN_OBJECTS = SetsKt.hashSetOf((Object[])objectArray);
        objectArray = new String[]{"dynamic", "dynamicParams", "revalidate", "fetchCache", "runtime", "preferredRegion", "maxDuration"};
        this.ROUTE_SEGMENT_OPTIONS = SetsKt.hashSetOf((Object[])objectArray);
        objectArray = new String[]{"GET", "HEAD", "POST", "PUT", "DELETE", "PATCH", "OPTIONS"};
        this.HTTP_METHOD_FUNCTIONS = SetsKt.hashSetOf((Object[])objectArray);
    }

    public boolean isImplicitUsage(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return UtilKt.isNextJsContext(element) && (this.isKnownFunctionName(element) || this.isKnownObjectName(element) || this.isExportDefault(element) || this.isInAppDir(element) && this.isRouteSegmentOption(element) || this.isHttpMethod(element) || this.isMiddlewareFunctionOrItsConfig(element));
    }

    private final boolean isKnownFunctionName(PsiElement element) {
        return element instanceof JSElementBase && ((JSElementBase)element).isExported() && (element instanceof JSFunction || element instanceof JSVariable) && CollectionsKt.contains((Iterable)this.KNOWN_FUNCTIONS, (Object)((JSQualifiedNamedElement)element).getName());
    }

    private final boolean isKnownObjectName(PsiElement element) {
        return element instanceof JSVariable && ((JSVariable)element).isExported() && CollectionsKt.contains((Iterable)this.KNOWN_OBJECTS, (Object)((JSVariable)element).getName());
    }

    private final boolean isExportDefault(PsiElement element) {
        return element instanceof ES6ExportDefaultAssignment;
    }

    private final boolean isInAppDir(PsiElement element) {
        boolean bl;
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element);
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl2 = false;
            bl = JSLibraryUtil.hasDirectoryInPath((VirtualFile)it, (String)"app", null);
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isRouteSegmentOption(PsiElement element) {
        return element instanceof JSVariable && ((JSVariable)element).isExported() && CollectionsKt.contains((Iterable)this.ROUTE_SEGMENT_OPTIONS, (Object)((JSVariable)element).getName());
    }

    private final boolean isHttpMethod(PsiElement element) {
        Object object = element.getContainingFile();
        return (object != null && (object = object.getName()) != null ? StringsKt.startsWith$default((String)object, (String)"route.", (boolean)false, (int)2, null) : false) && element instanceof JSElementBase && ((JSElementBase)element).isExported() && (element instanceof JSFunction || element instanceof JSVariable) && CollectionsKt.contains((Iterable)this.HTTP_METHOD_FUNCTIONS, (Object)((JSQualifiedNamedElement)element).getName());
    }

    private final boolean isMiddlewareFunctionOrItsConfig(PsiElement element) {
        Object object = element.getContainingFile();
        return (object != null && (object = object.getName()) != null ? StringsKt.startsWith$default((String)object, (String)"middleware.", (boolean)false, (int)2, null) : false) && element instanceof JSElementBase && ((JSElementBase)element).isExported() && ((element instanceof JSFunction || element instanceof JSVariable) && Intrinsics.areEqual((Object)((JSQualifiedNamedElement)element).getName(), (Object)"middleware") || element instanceof JSVariable && Intrinsics.areEqual((Object)((JSVariable)element).getName(), (Object)"config"));
    }

    public boolean isImplicitRead(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return false;
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return false;
    }
}

