/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core;

import com.intellij.history.core.ChangeProcessor;
import com.intellij.history.core.ChangeProcessorBase;
import com.intellij.history.core.Content;
import com.intellij.history.core.HistoryPathFilter;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeSet;
import com.intellij.history.core.changes.CreateEntryChange;
import com.intellij.history.core.changes.DeleteChange;
import com.intellij.history.core.changes.PutLabelChange;
import com.intellij.history.core.changes.StructuralChange;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.core.tree.RootEntry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a<\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\tH\u0007\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0007\u001a(\u0010\r\u001a\u00020\u000e*\u00020\u000f2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u0000\u001aV\u0010\u0012\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u000e2\u001a\u0010\u000b\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0004\u0012\u00020\u000e0\u001bH\u0007\u00a8\u0006\u001c"}, d2={"collectChanges", "", "Lcom/intellij/history/core/LocalHistoryFacade;", "projectId", "", "startPath", "filter", "Lcom/intellij/history/core/HistoryPathFilter;", "consumer", "Lkotlin/Function1;", "Lcom/intellij/history/core/changes/ChangeSet;", "processor", "Lcom/intellij/history/core/ChangeProcessor;", "matches", "", "Lcom/intellij/history/core/changes/Change;", "path", "pathFilter", "processContents", "gateway", "Lcom/intellij/history/integration/IdeaGateway;", "root", "Lcom/intellij/history/core/tree/RootEntry;", "changeSets", "", "", "before", "Lkotlin/Function2;", "intellij.platform.lvcs.impl"})
@SourceDebugExtension(value={"SMAP\nLocalHistoryFacade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalHistoryFacade.kt\ncom/intellij/history/core/LocalHistoryFacadeKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,352:1\n1#2:353\n*E\n"})
public final class LocalHistoryFacadeKt {
    @ApiStatus.Experimental
    public static final void collectChanges(@NotNull LocalHistoryFacade $this$collectChanges, @Nullable String projectId, @NotNull String startPath, @Nullable HistoryPathFilter filter2, @NotNull Function1<? super ChangeSet, Unit> consumer) {
        Intrinsics.checkNotNullParameter((Object)$this$collectChanges, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)startPath, (String)"startPath");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        LocalHistoryFacadeKt.collectChanges($this$collectChanges, startPath, new ChangeProcessorBase(projectId, filter2, consumer));
    }

    @ApiStatus.Internal
    public static final void collectChanges(@NotNull LocalHistoryFacade $this$collectChanges, @NotNull String startPath, @NotNull ChangeProcessor processor) {
        Intrinsics.checkNotNullParameter((Object)$this$collectChanges, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)startPath, (String)"startPath");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        String path = startPath;
        boolean pathExists = true;
        for (ChangeSet changeSet : $this$collectChanges.getChanges$intellij_platform_lvcs_impl()) {
            PutLabelChange singleLabel;
            List<Change> changeSetChanges = changeSet.getChanges();
            Intrinsics.checkNotNull(changeSetChanges);
            Iterator iterator = CollectionsKt.singleOrNull(changeSetChanges);
            PutLabelChange putLabelChange = singleLabel = iterator instanceof PutLabelChange ? (PutLabelChange)((Object)iterator) : null;
            if (singleLabel != null) {
                if (!pathExists) continue;
                processor.process(changeSet, singleLabel, path);
                continue;
            }
            for (Change change : CollectionsKt.reversed((Iterable)changeSetChanges)) {
                if (change instanceof PutLabelChange) continue;
                if (!pathExists) {
                    if (change instanceof StructuralChange) {
                        path = ((StructuralChange)change).revertPath(path);
                    }
                    if (!(change instanceof DeleteChange) || !((DeleteChange)change).isDeletionOf(path)) continue;
                    processor.process(changeSet, change, path);
                    pathExists = true;
                    continue;
                }
                Intrinsics.checkNotNull((Object)change);
                processor.process(changeSet, change, path);
                if (change instanceof StructuralChange) {
                    path = ((StructuralChange)change).revertPath(path);
                }
                if (!(change instanceof CreateEntryChange) || !((CreateEntryChange)change).isCreationalFor(path)) continue;
                pathExists = false;
            }
        }
    }

    public static final boolean matches(@NotNull Change $this$matches, @Nullable String projectId, @NotNull String path, @Nullable HistoryPathFilter pathFilter) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$matches, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if ($this$matches.affectsPath(path) || $this$matches.affectsProject(projectId)) {
            HistoryPathFilter historyPathFilter = pathFilter;
            if (historyPathFilter != null) {
                HistoryPathFilter it = historyPathFilter;
                boolean bl2 = false;
                bl = $this$matches.affectsMatching(it);
            } else {
                bl = true;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    @ApiStatus.Internal
    public static final void processContents(@NotNull LocalHistoryFacade $this$processContents, @NotNull IdeaGateway gateway, @NotNull RootEntry root, @NotNull String startPath, @NotNull Set<Long> changeSets, boolean before, @NotNull Function2<? super Long, ? super String, Boolean> processor) {
        Intrinsics.checkNotNullParameter((Object)$this$processContents, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)gateway, (String)"gateway");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)startPath, (String)"startPath");
        Intrinsics.checkNotNullParameter(changeSets, (String)"changeSets");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Function2 processContents = (arg_0, arg_1) -> LocalHistoryFacadeKt.processContents$lambda$1(changeSets, root, processor, gateway, arg_0, arg_1);
        String path = startPath;
        for (ChangeSet changeSet : $this$processContents.getChanges$intellij_platform_lvcs_impl()) {
            ProgressManager.checkCanceled();
            if (Thread.currentThread().isInterrupted()) {
                throw new ProcessCanceledException();
            }
            if (!before && !((Boolean)processContents.invoke((Object)changeSet.getId(), (Object)path)).booleanValue()) break;
            List<Change> list = changeSet.getChanges();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getChanges(...)");
            for (Change change : CollectionsKt.reversed((Iterable)list)) {
                if (!(change instanceof StructuralChange) || !((StructuralChange)change).affectsPath(path)) continue;
                ((StructuralChange)change).revertOn(root, false);
                path = ((StructuralChange)change).revertPath(path);
            }
            if (!before || ((Boolean)processContents.invoke((Object)changeSet.getId(), (Object)path)).booleanValue()) continue;
            break;
        }
    }

    private static final boolean processContents$lambda$1(Set<Long> $changeSets, RootEntry $root, Function2<? super Long, ? super String, Boolean> $processor, IdeaGateway $gateway, long changeSetId, String path) {
        Object object;
        if (!$changeSets.contains(changeSetId)) {
            return true;
        }
        Entry entry = $root.findEntry(path);
        return (Boolean)$processor.invoke((Object)changeSetId, (object = entry) != null && (object = ((Entry)object).getContent()) != null ? ((Content)object).getString(entry, $gateway) : null);
    }
}

