/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts.settings.data;

import com.google.gson.JsonObject;
import com.intellij.charts.core.utils.GroupingResult;
import com.intellij.charts.core.utils.GroupingUtils;
import com.intellij.charts.dataframe.DataFrame;
import com.intellij.charts.dataframe.columns.Column;
import com.intellij.charts.settings.data.ColumnSettings;
import com.intellij.charts.settings.data.SeriesSettings;
import com.intellij.charts.settings.data.type.LineSeriesType;
import com.intellij.charts.style.ChartsConfig;
import com.intellij.charts.utils.ChartJsonUtilsKt;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.geom.geomLine;
import org.jetbrains.letsPlot.geom.geomPoint;
import org.jetbrains.letsPlot.geom.geomStep;
import org.jetbrains.letsPlot.intern.Feature;
import org.jetbrains.letsPlot.intern.layer.geom.LineMapping;
import org.jetbrains.letsPlot.intern.layer.geom.PointMapping;
import org.jetbrains.letsPlot.label.LabsKt;
import org.jetbrains.letsPlot.tooltips.layerTooltips;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001BW\b\u0016\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fB\u0011\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000b\u0010\u000fJ\b\u0010 \u001a\u00020\u000eH\u0016J\b\u0010!\u001a\u00020\bH\u0016J\u0013\u0010\"\u001a\u00020\b2\b\u0010#\u001a\u0004\u0018\u00010$H\u0096\u0002J\u0010\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020'H\u0016J\u001e\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u00032\u0006\u0010&\u001a\u00020'2\u0006\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020+H\u0016R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\t\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0019\"\u0004\b\u001d\u0010\u001bR\u001a\u0010\n\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0019\"\u0004\b\u001f\u0010\u001b\u00a8\u0006-"}, d2={"Lcom/intellij/charts/settings/data/LineSeriesSettings;", "Lcom/intellij/charts/settings/data/SeriesSettings;", "keys", "", "Lcom/intellij/charts/settings/data/ColumnSettings;", "groups", "values", "stepped", "", "showPoints", "showLegend", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;ZZZ)V", "json", "Lcom/google/gson/JsonObject;", "(Lcom/google/gson/JsonObject;)V", "type", "Lcom/intellij/charts/settings/data/type/LineSeriesType;", "getType", "()Lcom/intellij/charts/settings/data/type/LineSeriesType;", "getKeys", "()Ljava/util/List;", "getGroups", "getValues", "getStepped", "()Z", "setStepped", "(Z)V", "getShowPoints", "setShowPoints", "getShowLegend", "setShowLegend", "toJson", "isEmpty", "equals", "other", "", "filterByNewDataFrame", "dataFrame", "Lcom/intellij/charts/dataframe/DataFrame;", "getLetsPlotLayer", "Lorg/jetbrains/letsPlot/intern/Feature;", "chartIndex", "", "hashCode", "intellij.charts"})
@SourceDebugExtension(value={"SMAP\nLineSeriesSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineSeriesSettings.kt\ncom/intellij/charts/settings/data/LineSeriesSettings\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n25#2:150\n1863#3,2:151\n*S KotlinDebug\n*F\n+ 1 LineSeriesSettings.kt\ncom/intellij/charts/settings/data/LineSeriesSettings\n*L\n90#1:150\n103#1:151,2\n*E\n"})
public final class LineSeriesSettings
extends SeriesSettings {
    @NotNull
    private final LineSeriesType type;
    @NotNull
    private final List<ColumnSettings> keys;
    @NotNull
    private final List<ColumnSettings> groups;
    @NotNull
    private final List<ColumnSettings> values;
    private boolean stepped;
    private boolean showPoints;
    private boolean showLegend;

    @Override
    @NotNull
    public LineSeriesType getType() {
        return this.type;
    }

    @NotNull
    public final List<ColumnSettings> getKeys() {
        return this.keys;
    }

    @NotNull
    public final List<ColumnSettings> getGroups() {
        return this.groups;
    }

    @NotNull
    public final List<ColumnSettings> getValues() {
        return this.values;
    }

    public final boolean getStepped() {
        return this.stepped;
    }

    public final void setStepped(boolean bl) {
        this.stepped = bl;
    }

    public final boolean getShowPoints() {
        return this.showPoints;
    }

    public final void setShowPoints(boolean bl) {
        this.showPoints = bl;
    }

    public final boolean getShowLegend() {
        return this.showLegend;
    }

    public final void setShowLegend(boolean bl) {
        this.showLegend = bl;
    }

    public LineSeriesSettings(@NotNull List<ColumnSettings> keys, @NotNull List<ColumnSettings> groups2, @NotNull List<ColumnSettings> values2, boolean stepped, boolean showPoints, boolean showLegend) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter(groups2, (String)"groups");
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        this.type = LineSeriesType.Companion.getInstance();
        this.keys = keys;
        this.groups = groups2;
        this.values = values2;
        this.stepped = stepped;
        this.showPoints = showPoints;
        this.showLegend = showLegend;
    }

    public /* synthetic */ LineSeriesSettings(List list2, List list3, List list4, boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list4 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        if ((n & 0x20) != 0) {
            bl3 = false;
        }
        this(list2, list3, list4, bl, bl2, bl3);
    }

    public LineSeriesSettings(@NotNull JsonObject json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.type = LineSeriesType.Companion.getInstance();
        this.keys = ChartJsonUtilsKt.optColumnSettingsList(json, "keys");
        this.groups = ChartJsonUtilsKt.optColumnSettingsList(json, "groups");
        this.values = ChartJsonUtilsKt.optColumnSettingsList(json, "values");
        this.stepped = ChartJsonUtilsKt.optBoolean(json, "stepped");
        this.showPoints = ChartJsonUtilsKt.optBoolean(json, "showPoints");
        this.showLegend = ChartJsonUtilsKt.optBoolean(json, "showLegend");
    }

    @Override
    @NotNull
    public JsonObject toJson() {
        JsonObject jsonObject;
        JsonObject $this$toJson_u24lambda_u240 = jsonObject = new JsonObject();
        boolean bl = false;
        $this$toJson_u24lambda_u240.addProperty("type", this.getType().getId());
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u240, "keys", this.keys);
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u240, "groups", this.groups);
        ChartJsonUtilsKt.optSet($this$toJson_u24lambda_u240, "values", this.values);
        ChartJsonUtilsKt.optSetProperty($this$toJson_u24lambda_u240, "stepped", this.stepped);
        ChartJsonUtilsKt.optSetProperty($this$toJson_u24lambda_u240, "showPoints", this.showPoints);
        ChartJsonUtilsKt.optSetProperty($this$toJson_u24lambda_u240, "showLegend", this.showLegend);
        return jsonObject;
    }

    @Override
    public boolean isEmpty() {
        return this.keys.isEmpty() && this.groups.isEmpty() && this.values.isEmpty();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof LineSeriesSettings && Intrinsics.areEqual(((LineSeriesSettings)other).keys, this.keys) && Intrinsics.areEqual(((LineSeriesSettings)other).groups, this.groups) && Intrinsics.areEqual(((LineSeriesSettings)other).values, this.values) && ((LineSeriesSettings)other).stepped == this.stepped && ((LineSeriesSettings)other).showPoints == this.showPoints && ((LineSeriesSettings)other).showLegend == this.showLegend;
    }

    @Override
    @NotNull
    public LineSeriesSettings filterByNewDataFrame(@NotNull DataFrame dataFrame) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        return new LineSeriesSettings(SeriesSettings.Companion.filterByDataFrame(this.keys, dataFrame), SeriesSettings.Companion.filterByDataFrame(this.groups, dataFrame), SeriesSettings.Companion.filterByDataFrame(this.values, dataFrame), this.stepped, this.showPoints, this.showLegend);
    }

    @Override
    @NotNull
    public List<Feature> getLetsPlotLayer(@NotNull DataFrame dataFrame, int chartIndex) {
        Intrinsics.checkNotNullParameter((Object)dataFrame, (String)"dataFrame");
        if (this.keys.isEmpty() || this.values.isEmpty()) {
            LineSeriesSettings $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(LineSeriesSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.warn("Line series should have at least one X and one Y axis.");
            return CollectionsKt.emptyList();
        }
        List[] $this$thisLogger$iv = new List[]{this.keys, this.groups, this.values};
        if (!SeriesSettings.Companion.dataFrameHasAllColumns(dataFrame, $this$thisLogger$iv)) {
            return CollectionsKt.emptyList();
        }
        GroupingResult groupingResult = GroupingUtils.INSTANCE.get(dataFrame, this.keys, this.groups, this.values);
        if (groupingResult == null) {
            return CollectionsKt.emptyList();
        }
        GroupingResult res = groupingResult;
        List result2 = new ArrayList();
        Iterable $this$forEach$iv = res.getYColumns();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Column it = (Column)element$iv;
            boolean bl = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)res.getXColumn().getName(), res.getXColumn().toList()), TuplesKt.to((Object)it.getName(), it.toList())};
            Map data = MapsKt.mapOf((Pair[])pairArray);
            Color color = ChartsConfig.Companion.getInstance().getSettings().getPaletteColor(chartIndex + result2.size());
            layerTooltips tooltips = new layerTooltips(new String[0]).line(res.getXColumn().getName() + "|@{" + res.getXColumn().getName() + "}").line(it.getName() + "|@{" + it.getName() + "}");
            if (this.stepped) {
                var14_16 = result2;
                var15_17 = SeriesSettings.Companion.getSampling(res);
                var14_16.add(new geomStep(data, null, null, false, null, null, var15_17, tooltips, null, null, null, null, color, null, null, null, arg_0 -> LineSeriesSettings.getLetsPlotLayer$lambda$4$lambda$1(res, it, arg_0), 61238, null));
            } else {
                var14_16 = result2;
                var15_17 = SeriesSettings.Companion.getSampling(res);
                var14_16.add(new geomLine(data, null, null, false, null, null, var15_17, tooltips, null, null, null, color, null, null, null, arg_0 -> LineSeriesSettings.getLetsPlotLayer$lambda$4$lambda$2(res, it, arg_0), 30518, null));
            }
            if (!this.showPoints) continue;
            ((Collection)result2).add(new geomPoint(data, null, null, false, null, null, SeriesSettings.Companion.getSampling(res), null, null, null, null, null, null, null, null, color, null, null, null, null, null, null, null, null, arg_0 -> LineSeriesSettings.getLetsPlotLayer$lambda$4$lambda$3(res, it, arg_0), 16744374, null));
        }
        return CollectionsKt.plus((Collection)result2, (Object)LabsKt.ylab(SeriesSettings.Companion.getPresentableAxisText$default(SeriesSettings.Companion, this.values, null, 2, null)));
    }

    public int hashCode() {
        int result2 = this.getType().hashCode();
        result2 = 31 * result2 + ((Object)this.keys).hashCode();
        result2 = 31 * result2 + ((Object)this.groups).hashCode();
        result2 = 31 * result2 + ((Object)this.values).hashCode();
        result2 = 31 * result2 + Boolean.hashCode(this.stepped);
        result2 = 31 * result2 + Boolean.hashCode(this.showPoints);
        result2 = 31 * result2 + Boolean.hashCode(this.showLegend);
        return result2;
    }

    private static final Unit getLetsPlotLayer$lambda$4$lambda$1(GroupingResult $res, Column $it, LineMapping $this$geomStep) {
        Intrinsics.checkNotNullParameter((Object)$this$geomStep, (String)"$this$geomStep");
        $this$geomStep.setX($res.getXColumn().getName());
        $this$geomStep.setY($it.getName());
        return Unit.INSTANCE;
    }

    private static final Unit getLetsPlotLayer$lambda$4$lambda$2(GroupingResult $res, Column $it, LineMapping $this$geomLine) {
        Intrinsics.checkNotNullParameter((Object)$this$geomLine, (String)"$this$geomLine");
        $this$geomLine.setX($res.getXColumn().getName());
        $this$geomLine.setY($it.getName());
        return Unit.INSTANCE;
    }

    private static final Unit getLetsPlotLayer$lambda$4$lambda$3(GroupingResult $res, Column $it, PointMapping $this$geomPoint) {
        Intrinsics.checkNotNullParameter((Object)$this$geomPoint, (String)"$this$geomPoint");
        $this$geomPoint.setX($res.getXColumn().getName());
        $this$geomPoint.setY($it.getName());
        return Unit.INSTANCE;
    }
}

