/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.charts.dataframe.analyzing;

import com.intellij.charts.dataframe.analyzing.AnalysisPartialSuccess;
import com.intellij.charts.dataframe.analyzing.AnalyzerState;
import com.intellij.charts.dataframe.analyzing.CsvAnalysisSuccess;
import com.intellij.charts.dataframe.analyzing.CsvField;
import com.intellij.charts.dataframe.analyzing.CsvSuccessBase;
import com.intellij.charts.dataframe.analyzing.CsvTypeParser;
import com.intellij.charts.dataframe.analyzing.NextPartNeeded;
import com.intellij.charts.dataframe.analyzing.StructuredFileAnalyzer;
import com.intellij.charts.dataframe.columns.IntegerType;
import com.intellij.charts.dataframe.columns.StringType;
import com.intellij.charts.dataframe.columns.TableColumnType;
import com.intellij.openapi.util.InvalidDataException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010+\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u0001:\u0004DEFGBQ\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u0016H\u0016J\u0010\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020\u0016H\u0016J\u0006\u0010-\u001a\u00020.J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u000bH\u0002J\b\u00101\u001a\u00020\u0007H\u0002J\b\u00102\u001a\u00020)H\u0002J\b\u00103\u001a\u000204H\u0002J\b\u00105\u001a\u000206H\u0002J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u0016H\u0002J\u0010\u0010:\u001a\u0002082\u0006\u0010;\u001a\u00020\u0016H\u0002J\u0010\u0010:\u001a\u0002082\u0006\u0010<\u001a\u00020\u0018H\u0002J\u0010\u0010=\u001a\u0002082\u0006\u0010>\u001a\u00020\u0016H\u0002J\u0010\u0010?\u001a\u0002082\u0006\u0010@\u001a\u00020\u0005H\u0002J\b\u0010A\u001a\u00020\u0005H\u0002J\u0010\u0010B\u001a\u0002082\u0006\u0010C\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0012\u0010\u0010\u001a\u00060\u0011R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u001d\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00030\u001fj\b\u0012\u0004\u0012\u00020\u0003` 0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010!\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lcom/intellij/charts/dataframe/analyzing/CsvFileAnalyzer;", "Lcom/intellij/charts/dataframe/analyzing/StructuredFileAnalyzer;", "rowsCount", "", "knownDelimiter", "", "strict", "", "fixedNoHeader", "knownQuote", "offsetMap", "", "<init>", "(ILjava/lang/Character;ZLjava/lang/Boolean;Ljava/lang/Character;Ljava/util/List;)V", "Ljava/lang/Character;", "Ljava/lang/Boolean;", "headerParser", "Lcom/intellij/charts/dataframe/analyzing/CsvFileAnalyzer$CsvHeaderParser;", "typeParser", "Lcom/intellij/charts/dataframe/analyzing/CsvTypeParser;", "parsedNames", "", "", "parsedTypes", "Lcom/intellij/charts/dataframe/columns/TableColumnType;", "parsedIterator", "", "rowsProcessed", "noHeader", "delimiters", "", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "expectedQuote", "getExpectedQuote", "()Ljava/lang/Character;", "setExpectedQuote", "(Ljava/lang/Character;)V", "lastDelimiter", "headerOver", "continueAnalysis", "Lcom/intellij/charts/dataframe/analyzing/AnalyzerState;", "nextPart", "startAnalysis", "startPart", "getCurrentResult", "Lcom/intellij/charts/dataframe/analyzing/CsvAnalysisSuccess;", "extractData", "Lcom/intellij/charts/dataframe/analyzing/CsvField;", "shouldContinue", "analyzeImpl", "parserRun", "Lcom/intellij/charts/dataframe/analyzing/CsvFileAnalyzer$CsvParserState;", "nextSampleRequest", "Lcom/intellij/charts/dataframe/analyzing/NextPartNeeded;", "addName", "", "name", "addType", "typeString", "newType", "addField", "text", "countDelimiter", "d", "findDelimiter", "reportError", "msg", "PartialSuccessImpl", "NextPartNeededImpl", "CsvParserState", "CsvHeaderParser", "intellij.charts"})
@SourceDebugExtension(value={"SMAP\nCsvAnalyzers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CsvAnalyzers.kt\ncom/intellij/charts/dataframe/analyzing/CsvFileAnalyzer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,445:1\n1557#2:446\n1628#2,3:447\n1557#2:450\n1628#2,3:451\n1557#2:454\n1628#2,3:455\n1734#2,3:458\n1782#2,4:461\n535#3:465\n520#3,6:466\n*S KotlinDebug\n*F\n+ 1 CsvAnalyzers.kt\ncom/intellij/charts/dataframe/analyzing/CsvFileAnalyzer\n*L\n137#1:446\n137#1:447,3\n142#1:450\n142#1:451,3\n158#1:454\n158#1:455,3\n231#1:458,3\n233#1:461,4\n235#1:465\n235#1:466,6\n*E\n"})
public final class CsvFileAnalyzer
extends StructuredFileAnalyzer {
    private final int rowsCount;
    @Nullable
    private final Character knownDelimiter;
    private final boolean strict;
    @Nullable
    private final Boolean fixedNoHeader;
    @NotNull
    private final CsvHeaderParser headerParser;
    @NotNull
    private final CsvTypeParser typeParser;
    @NotNull
    private final List<String> parsedNames;
    @NotNull
    private final List<TableColumnType> parsedTypes;
    @Nullable
    private ListIterator<TableColumnType> parsedIterator;
    private int rowsProcessed;
    private boolean noHeader;
    @NotNull
    private final Map<Character, ArrayList<Integer>> delimiters;
    @Nullable
    private Character expectedQuote;
    private char lastDelimiter;
    private boolean headerOver;

    public CsvFileAnalyzer(int rowsCount, @Nullable Character knownDelimiter, boolean strict, @Nullable Boolean fixedNoHeader, @Nullable Character knownQuote, @Nullable List<Integer> offsetMap) {
        this.rowsCount = rowsCount;
        this.knownDelimiter = knownDelimiter;
        this.strict = strict;
        this.fixedNoHeader = fixedNoHeader;
        this.headerParser = new CsvHeaderParser(offsetMap);
        this.typeParser = new CsvTypeParser();
        this.parsedNames = new ArrayList();
        this.parsedTypes = new ArrayList();
        Boolean bl = this.fixedNoHeader;
        this.noHeader = bl != null ? bl : false;
        this.delimiters = new LinkedHashMap();
        this.expectedQuote = knownQuote;
        this.lastDelimiter = (char)44;
    }

    public /* synthetic */ CsvFileAnalyzer(int n, Character c, boolean bl, Boolean bl2, Character c2, List list2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        if ((n2 & 2) != 0) {
            c = null;
        }
        if ((n2 & 4) != 0) {
            bl = false;
        }
        if ((n2 & 8) != 0) {
            bl2 = null;
        }
        if ((n2 & 0x10) != 0) {
            c2 = null;
        }
        if ((n2 & 0x20) != 0) {
            list2 = null;
        }
        this(n, c, bl, bl2, c2, list2);
    }

    @Nullable
    public final Character getExpectedQuote() {
        return this.expectedQuote;
    }

    public final void setExpectedQuote(@Nullable Character c) {
        this.expectedQuote = c;
    }

    @Override
    @NotNull
    public AnalyzerState continueAnalysis(@NotNull String nextPart) {
        Intrinsics.checkNotNullParameter((Object)nextPart, (String)"nextPart");
        this.headerParser.addText(nextPart);
        return this.analyzeImpl();
    }

    @Override
    @NotNull
    public AnalyzerState startAnalysis(@NotNull String startPart) {
        Intrinsics.checkNotNullParameter((Object)startPart, (String)"startPart");
        this.headerParser.setText(startPart);
        return this.analyzeImpl();
    }

    @NotNull
    public final CsvAnalysisSuccess getCurrentResult() {
        return new CsvAnalysisSuccess(this.extractData(), this.findDelimiter(), !this.noHeader, this.expectedQuote);
    }

    /*
     * WARNING - void declaration
     */
    private final List<CsvField> extractData() {
        List data;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        int $i$f$map;
        Iterable iterable;
        if (!this.noHeader && this.parsedTypes.size() == 0) {
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv = this.parsedNames;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void name;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(new CsvField((String)name, StringType.INSTANCE));
            }
            return (List)destination$iv$iv2;
        }
        if (this.noHeader) {
            void $this$map$iv;
            Iterable $i$f$map2 = (Iterable)RangesKt.until((int)0, (int)this.parsedNames.size());
            iterable = this.parsedTypes;
            $i$f$map = 0;
            void destination$iv$iv2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void i;
                int item$iv$iv;
                int bl = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add("Field #" + (int)(i + true));
            }
            v0 = CollectionsKt.zip((Iterable)iterable, (Iterable)((List)destination$iv$iv));
        } else {
            v0 = data = CollectionsKt.zip((Iterable)this.parsedTypes, (Iterable)this.parsedNames);
        }
        if (this.strict && this.parsedTypes.size() != this.parsedNames.size()) {
            throw new InvalidDataException("Column count mismatch, columns expected: " + this.parsedNames.size() + ", columns found: " + this.parsedTypes.size());
        }
        if (this.parsedTypes.size() > this.parsedNames.size()) {
            $i$f$map = this.parsedTypes.size() - this.parsedNames.size();
            for (int i = 0; i < $i$f$map; ++i) {
                this.parsedNames.add("Unnamed field #" + (i + 1));
            }
        } else if (this.parsedTypes.size() < this.parsedNames.size()) {
            List needed = CollectionsKt.take((Iterable)this.parsedNames, (int)this.parsedTypes.size());
            this.parsedNames.clear();
            this.parsedNames.addAll(needed);
        }
        Iterable $this$map$iv = data;
        $i$f$map = 0;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair pair2 = (Pair)item$iv$iv;
            iterable = destination$iv$iv;
            boolean bl = false;
            TableColumnType tpe = (TableColumnType)pair2.component1();
            String name = (String)pair2.component2();
            iterable.add(new CsvField(name, tpe));
        }
        return (List)destination$iv$iv;
    }

    private final boolean shouldContinue() {
        return this.rowsCount < 0 || this.rowsProcessed < this.rowsCount;
    }

    private final AnalyzerState analyzeImpl() {
        while (this.shouldContinue()) {
            if (WhenMappings.$EnumSwitchMapping$0[this.parserRun().ordinal()] == 1) {
                ++this.rowsProcessed;
                if (!this.noHeader && this.rowsProcessed == 1) {
                    this.parsedTypes.clear();
                } else {
                    this.parsedIterator = this.parsedTypes.listIterator();
                }
                this.headerParser.reset();
                continue;
            }
            return this.nextSampleRequest();
        }
        return this.getCurrentResult();
    }

    private final CsvParserState parserRun() {
        this.headerParser.parse();
        return this.headerParser.getState();
    }

    private final NextPartNeeded nextSampleRequest() {
        return !((Collection)this.parsedTypes).isEmpty() ? (NextPartNeeded)new PartialSuccessImpl(this.extractData()) : (NextPartNeeded)new NextPartNeededImpl();
    }

    private final void addName(String name) {
        if (!this.headerOver) {
            this.parsedNames.add(name);
        }
    }

    private final void addType(String typeString) {
        this.addType(CsvTypeParser.parse$default(this.typeParser, typeString, 0, 2, null));
    }

    private final void addType(TableColumnType newType) {
        ListIterator<TableColumnType> it = this.parsedIterator;
        if (it == null) {
            this.parsedTypes.add(newType);
            if (!Intrinsics.areEqual((Object)newType, (Object)StringType.INSTANCE) && this.rowsProcessed == 0 && this.fixedNoHeader == null) {
                this.noHeader = true;
            }
            return;
        }
        if (!it.hasNext()) {
            this.reportError("Lines size mismatch");
            return;
        }
        TableColumnType oldType = it.next();
        it.set(oldType.union(newType));
    }

    private final void addField(String text2) {
        this.addName(text2);
        this.addType(text2);
    }

    private final void countDelimiter(char d) {
        if (this.knownDelimiter != null) {
            return;
        }
        ArrayList arrayList = this.delimiters.computeIfAbsent(Character.valueOf(d), arg_0 -> CsvFileAnalyzer.countDelimiter$lambda$4(CsvFileAnalyzer::countDelimiter$lambda$3, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"computeIfAbsent(...)");
        ArrayList counter = arrayList;
        if (counter.size() <= this.rowsProcessed) {
            int n;
            int i = counter.size();
            if (i <= (n = this.rowsProcessed)) {
                while (true) {
                    counter.add(i, 0);
                    if (i != n) {
                        ++i;
                        continue;
                    }
                    break;
                }
            }
        } else {
            int n = this.rowsProcessed;
            counter.set(n, ((Number)counter.get(n)).intValue() + 1);
        }
        this.lastDelimiter = d;
    }

    /*
     * WARNING - void declaration
     */
    private final char findDelimiter() {
        void $this$filterTo$iv$iv;
        ArrayList<Integer> list2;
        char c;
        if (this.knownDelimiter != null) {
            return this.knownDelimiter.charValue();
        }
        for (Map.Entry<Character, ArrayList<Integer>> entry : this.delimiters.entrySet()) {
            boolean bl;
            block11: {
                c = entry.getKey().charValue();
                list2 = entry.getValue();
                if (!(!((Collection)list2).isEmpty()) || ((Number)list2.get(0)).intValue() <= 0) continue;
                Iterable $this$all$iv = list2;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        int it = ((Number)element$iv).intValue();
                        boolean bl2 = false;
                        Integer n = list2.get(0);
                        if (n != null && it == n) continue;
                        bl = false;
                        break block11;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            return c;
        }
        for (Map.Entry<Character, ArrayList<Integer>> entry : this.delimiters.entrySet()) {
            int n;
            c = entry.getKey().charValue();
            list2 = entry.getValue();
            if (!(!((Collection)list2).isEmpty()) || ((Number)list2.get(0)).intValue() <= 0) continue;
            Iterable $this$count$iv = list2;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    int a2 = ((Number)element$iv).intValue();
                    boolean bl = false;
                    Integer n2 = list2.get(0);
                    if (!(n2 != null && a2 == n2) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            if (n <= list2.size() / 2 + 1) continue;
            return c;
        }
        Map<Character, ArrayList<Integer>> $this$filter$iv = this.delimiters;
        boolean $i$f$filter = false;
        list2 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator2.next();
            boolean bl = false;
            ArrayList list3 = (ArrayList)entry.getValue();
            if (!(!((Collection)list3).isEmpty() && list3.size() >= this.rowsProcessed - 3 && !list3.contains(0))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map onEveryLine = destination$iv$iv;
        if (onEveryLine.size() == 1) {
            return ((Character)((Pair)CollectionsKt.first((List)MapsKt.toList((Map)onEveryLine))).getFirst()).charValue();
        }
        return this.lastDelimiter;
    }

    private final void reportError(String msg) {
    }

    private static final ArrayList countDelimiter$lambda$3(Character it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    private static final ArrayList countDelimiter$lambda$4(Function1 $tmp0, Object p0) {
        return (ArrayList)$tmp0.invoke(p0);
    }

    public CsvFileAnalyzer() {
        this(0, null, false, null, null, null, 63, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010*\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\b\u0010\u001d\u001a\u00020\u001bH\u0002J\u0017\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020#H\u0002J\u0006\u0010%\u001a\u00020\u001bJ\u000e\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u000fJ\u0006\u0010(\u001a\u00020\u001bR\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/charts/dataframe/analyzing/CsvFileAnalyzer$CsvHeaderParser;", "", "offsetMap", "", "", "<init>", "(Lcom/intellij/charts/dataframe/analyzing/CsvFileAnalyzer;Ljava/util/List;)V", "currentField", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "offsetsIterator", "", "currentDelOffset", "Ljava/lang/Integer;", "text", "", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "value", "Lcom/intellij/charts/dataframe/analyzing/CsvFileAnalyzer$CsvParserState;", "state", "getState", "()Lcom/intellij/charts/dataframe/analyzing/CsvFileAnalyzer$CsvParserState;", "offset", "addEmptyField", "", "addCurrentField", "afterNewField", "lookUp", "", "i", "(I)Ljava/lang/Character;", "isDelimiterOffset", "", "isNewLineOffset", "reset", "addText", "newText", "parse", "intellij.charts"})
    private final class CsvHeaderParser {
        @NotNull
        private final StringBuilder currentField = new StringBuilder();
        @Nullable
        private final ListIterator<Integer> offsetsIterator;
        @Nullable
        private Integer currentDelOffset;
        @NotNull
        private String text;
        @NotNull
        private CsvParserState state;
        private int offset;

        public CsvHeaderParser(List<Integer> offsetMap) {
            List<Integer> list2 = offsetMap;
            this.offsetsIterator = list2 != null ? list2.listIterator() : null;
            this.currentDelOffset = this.offsetsIterator != null && this.offsetsIterator.hasNext() ? this.offsetsIterator.next() : null;
            this.text = "";
            this.state = CsvParserState.START_ENTRY;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public final void setText(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.text = string;
        }

        @NotNull
        public final CsvParserState getState() {
            return this.state;
        }

        private final void addEmptyField() {
            CsvFileAnalyzer.this.addName("");
            CsvFileAnalyzer.this.addType(IntegerType.INSTANCE);
            this.afterNewField();
        }

        private final void addCurrentField() {
            String string = this.currentField.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            CsvFileAnalyzer.this.addField(string);
            this.afterNewField();
        }

        private final void afterNewField() {
            this.currentField.setLength(0);
            this.state = CsvParserState.AFTER_ENTRY;
        }

        private final Character lookUp(int i) {
            int j = i + this.offset;
            if (j >= this.text.length()) {
                return null;
            }
            return Character.valueOf(this.text.charAt(j));
        }

        private final boolean isDelimiterOffset() {
            if (this.currentDelOffset == null || this.offsetsIterator == null) {
                return false;
            }
            Integer n = this.currentDelOffset;
            if (n != null && this.offset == n) {
                this.currentDelOffset = this.offsetsIterator.hasNext() ? this.offsetsIterator.next() : null;
                return true;
            }
            return false;
        }

        private final boolean isNewLineOffset() {
            if (this.currentDelOffset == null || this.offsetsIterator == null) {
                return false;
            }
            Integer n = this.currentDelOffset;
            Intrinsics.checkNotNull((Object)n);
            int cdo = n;
            if (this.offset == Math.abs(cdo) && cdo < 0) {
                this.currentDelOffset = this.offsetsIterator.hasNext() ? this.offsetsIterator.next() : null;
                return true;
            }
            return false;
        }

        public final void reset() {
            this.state = CsvParserState.START_ENTRY;
        }

        public final void addText(@NotNull String newText) {
            String string;
            Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
            if (this.offset < this.text.length()) {
                String string2 = this.text.substring(this.offset, this.text.length() - 1);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = "";
            }
            this.text = string + newText;
        }

        public final void parse() {
            Ref.IntRef quoteCount = new Ref.IntRef();
            while (this.offset < this.text.length() && this.state != CsvParserState.FINISHED) {
                char c = this.text.charAt(this.offset);
                if (this.isDelimiterOffset()) {
                    switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                        case 1: 
                        case 2: {
                            this.addEmptyField();
                            break;
                        }
                        default: {
                            this.addCurrentField();
                            break;
                        }
                    }
                } else if (this.isNewLineOffset()) {
                    CsvHeaderParser.parse$processLineFeed(this, quoteCount, CsvFileAnalyzer.this, c);
                } else {
                    Character c2 = CsvFileAnalyzer.this.knownDelimiter;
                    char c3 = c;
                    if (c2 != null && c2.charValue() == c3) {
                        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                            case 1: 
                            case 2: {
                                this.addEmptyField();
                                break;
                            }
                            case 3: 
                            case 4: 
                            case 5: {
                                this.addCurrentField();
                                break;
                            }
                            case 6: {
                                this.currentField.append(c);
                            }
                        }
                    } else {
                        block8 : switch (c) {
                            case '\t': 
                            case ',': 
                            case ';': {
                                if (CsvFileAnalyzer.this.knownDelimiter == null && this.offsetsIterator == null) {
                                    switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                                        case 1: 
                                        case 2: {
                                            this.addEmptyField();
                                            CsvFileAnalyzer.this.countDelimiter(c);
                                            break block8;
                                        }
                                        case 3: {
                                            this.addCurrentField();
                                            CsvFileAnalyzer.this.countDelimiter(c);
                                            break block8;
                                        }
                                        case 4: 
                                        case 5: {
                                            if (quoteCount.element % 2 == 0) {
                                                this.addCurrentField();
                                                CsvFileAnalyzer.this.countDelimiter(c);
                                                quoteCount.element = 0;
                                                break block8;
                                            }
                                            this.currentField.append(c);
                                            break block8;
                                        }
                                        case 6: {
                                            this.currentField.append(c);
                                            break block8;
                                        }
                                        case 7: {
                                            CsvFileAnalyzer.this.reportError("Wrong token: [ , ] after parsing has been finished");
                                            break block8;
                                        }
                                    }
                                    throw new NoWhenBranchMatchedException();
                                }
                                if (this.state == CsvParserState.START_ENTRY || this.state == CsvParserState.AFTER_ENTRY) {
                                    this.state = CsvParserState.INSIDE_ENTRY;
                                }
                                this.currentField.append(c);
                                break;
                            }
                            case '\"': 
                            case '\'': {
                                switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
                                    case 1: 
                                    case 2: {
                                        this.state = CsvParserState.INSIDE_QUOTED;
                                        Character c4 = CsvFileAnalyzer.this.getExpectedQuote();
                                        if (c4 == null) {
                                            c4 = Character.valueOf(c);
                                        }
                                        CsvFileAnalyzer.this.setExpectedQuote(c4);
                                        int n = quoteCount.element;
                                        quoteCount.element = n + 1;
                                        this.currentField.append(c);
                                        break block8;
                                    }
                                    case 3: {
                                        int n;
                                        Character c5 = CsvFileAnalyzer.this.getExpectedQuote();
                                        if (c5 != null && c == c5.charValue()) {
                                            CsvFileAnalyzer.this.reportError("Wrong token [ \" ] inside field not enclosed with double quotes");
                                            this.currentField.append(c);
                                            n = quoteCount.element;
                                            quoteCount.element = n + 1;
                                            this.state = CsvParserState.INSIDE_QUOTED;
                                            break block8;
                                        }
                                        this.currentField.append(c);
                                        n = quoteCount.element;
                                        quoteCount.element = n + 1;
                                        break block8;
                                    }
                                    case 4: 
                                    case 5: {
                                        this.currentField.append(c);
                                        int n = quoteCount.element;
                                        quoteCount.element = n + 1;
                                        break block8;
                                    }
                                    case 6: {
                                        this.state = CsvParserState.INSIDE_QUOTED_QUOTE;
                                        break block8;
                                    }
                                    case 7: {
                                        CsvFileAnalyzer.this.reportError("Wrong token: [ \" ] after parsing has been finished");
                                        break block8;
                                    }
                                }
                                throw new NoWhenBranchMatchedException();
                            }
                            case '\n': {
                                if (this.offsetsIterator == null) {
                                    CsvHeaderParser.parse$processLineFeed(this, quoteCount, CsvFileAnalyzer.this, c);
                                    break;
                                }
                                CsvHeaderParser.parse$addOtherChar(this, c);
                                break;
                            }
                            case '\r': {
                                Character nc = this.lookUp(1);
                                if (nc == null) break;
                                char c6 = '\n';
                                if (nc.charValue() == c6) break;
                                CsvHeaderParser.parse$processLineFeed(this, quoteCount, CsvFileAnalyzer.this, c);
                                break;
                            }
                            default: {
                                CsvHeaderParser.parse$addOtherChar(this, c);
                            }
                        }
                    }
                }
                ++this.offset;
            }
            if (((CharSequence)this.currentField).length() > 0) {
                this.addCurrentField();
            }
        }

        private static final void parse$addOtherChar(CsvHeaderParser this$0, char c) {
            if (this$0.state == CsvParserState.START_ENTRY || this$0.state == CsvParserState.AFTER_ENTRY) {
                this$0.state = CsvParserState.INSIDE_ENTRY;
            }
            this$0.currentField.append(c);
        }

        private static final void parse$processLineFeed(CsvHeaderParser this$0, Ref.IntRef quoteCount, CsvFileAnalyzer this$1, char c) {
            switch (WhenMappings.$EnumSwitchMapping$0[this$0.state.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    this$0.addEmptyField();
                    this$0.state = CsvParserState.FINISHED;
                    break;
                }
                case 3: {
                    this$0.addCurrentField();
                    this$0.state = CsvParserState.FINISHED;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    if (quoteCount.element % 2 == 0) {
                        this$0.addCurrentField();
                        this$0.state = CsvParserState.FINISHED;
                        quoteCount.element = 0;
                        break;
                    }
                    this$0.currentField.append(c);
                    break;
                }
                case 7: {
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this$1.headerOver = true;
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[CsvParserState.values().length];
                try {
                    nArray[CsvParserState.START_ENTRY.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CsvParserState.AFTER_ENTRY.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CsvParserState.INSIDE_ENTRY.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CsvParserState.INSIDE_QUOTED.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CsvParserState.INSIDE_QUOTED_QUOTE.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CsvParserState.INSIDE_ENTRY_QUOTE.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CsvParserState.FINISHED.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/charts/dataframe/analyzing/CsvFileAnalyzer$CsvParserState;", "", "<init>", "(Ljava/lang/String;I)V", "START_ENTRY", "AFTER_ENTRY", "INSIDE_ENTRY", "INSIDE_QUOTED", "INSIDE_ENTRY_QUOTE", "INSIDE_QUOTED_QUOTE", "FINISHED", "intellij.charts"})
    private static final class CsvParserState
    extends Enum<CsvParserState> {
        public static final /* enum */ CsvParserState START_ENTRY = new CsvParserState();
        public static final /* enum */ CsvParserState AFTER_ENTRY = new CsvParserState();
        public static final /* enum */ CsvParserState INSIDE_ENTRY = new CsvParserState();
        public static final /* enum */ CsvParserState INSIDE_QUOTED = new CsvParserState();
        public static final /* enum */ CsvParserState INSIDE_ENTRY_QUOTE = new CsvParserState();
        public static final /* enum */ CsvParserState INSIDE_QUOTED_QUOTE = new CsvParserState();
        public static final /* enum */ CsvParserState FINISHED = new CsvParserState();
        private static final /* synthetic */ CsvParserState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CsvParserState[] values() {
            return (CsvParserState[])$VALUES.clone();
        }

        public static CsvParserState valueOf(String value) {
            return Enum.valueOf(CsvParserState.class, value);
        }

        @NotNull
        public static EnumEntries<CsvParserState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = csvParserStateArray = new CsvParserState[]{CsvParserState.START_ENTRY, CsvParserState.AFTER_ENTRY, CsvParserState.INSIDE_ENTRY, CsvParserState.INSIDE_QUOTED, CsvParserState.INSIDE_ENTRY_QUOTE, CsvParserState.INSIDE_QUOTED_QUOTE, CsvParserState.FINISHED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/charts/dataframe/analyzing/CsvFileAnalyzer$NextPartNeededImpl;", "Lcom/intellij/charts/dataframe/analyzing/NextPartNeeded;", "<init>", "(Lcom/intellij/charts/dataframe/analyzing/CsvFileAnalyzer;)V", "providePart", "Lcom/intellij/charts/dataframe/analyzing/AnalyzerState;", "part", "", "intellij.charts"})
    private final class NextPartNeededImpl
    implements NextPartNeeded {
        @Override
        @NotNull
        public AnalyzerState providePart(@NotNull String part) {
            Intrinsics.checkNotNullParameter((Object)part, (String)"part");
            return CsvFileAnalyzer.this.continueAnalysis(part);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/intellij/charts/dataframe/analyzing/CsvFileAnalyzer$PartialSuccessImpl;", "Lcom/intellij/charts/dataframe/analyzing/AnalysisPartialSuccess;", "Lcom/intellij/charts/dataframe/analyzing/NextPartNeeded;", "Lcom/intellij/charts/dataframe/analyzing/CsvSuccessBase;", "result", "", "Lcom/intellij/charts/dataframe/analyzing/CsvField;", "<init>", "(Lcom/intellij/charts/dataframe/analyzing/CsvFileAnalyzer;Ljava/util/List;)V", "getResult", "()Ljava/util/List;", "providePart", "Lcom/intellij/charts/dataframe/analyzing/AnalyzerState;", "part", "", "intellij.charts"})
    private final class PartialSuccessImpl
    extends CsvSuccessBase
    implements AnalysisPartialSuccess,
    NextPartNeeded {
        @NotNull
        private final List<CsvField> result;

        public PartialSuccessImpl(List<CsvField> result2) {
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            this.result = result2;
        }

        @Override
        @NotNull
        public List<CsvField> getResult() {
            return this.result;
        }

        @Override
        @NotNull
        public AnalyzerState providePart(@NotNull String part) {
            Intrinsics.checkNotNullParameter((Object)part, (String)"part");
            return CsvFileAnalyzer.this.continueAnalysis(part);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CsvParserState.values().length];
            try {
                nArray[CsvParserState.FINISHED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

