/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.variables;

import com.intellij.icons.AllIcons;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.variables.common.JupyterVarsToolWindowPanel;
import com.intellij.jupyter.py.editor.completion.JupyterRuntimeEnvService;
import com.intellij.jupyter.py.jupyterConsole.JupyterConsoleView;
import com.intellij.jupyter.py.variables.JupyterVarsFrameAccessor;
import com.intellij.jupyter.py.variables.PythonJupyterVarsManager;
import com.intellij.jupyter.py.variables.inline.JupyterInlineCallback;
import com.intellij.jupyter.py.variables.inline.JupyterInlinePainterKt;
import com.intellij.jupyter.py.variables.inline.JupyterInlineService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ClickListener;
import com.intellij.ui.ListenerUtil;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.impl.frame.XStandaloneVariablesView;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyStackFrame;
import com.jetbrains.python.debugger.PyStackFrameInfo;
import com.jetbrains.python.debugger.PyVariableViewSettings;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0014J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\b\u0010\u0014\u001a\u00020\u000fH\u0014J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"Lcom/intellij/jupyter/py/variables/PythonJupyterVarsToolWindowPanel;", "Lcom/intellij/jupyter/core/jupyter/variables/common/JupyterVarsToolWindowPanel;", "project", "Lcom/intellij/openapi/project/Project;", "notebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "consoleView", "Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleView;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleView;)V", "service", "Lcom/intellij/jupyter/py/editor/completion/JupyterRuntimeEnvService;", "getService", "()Lcom/intellij/jupyter/py/editor/completion/JupyterRuntimeEnvService;", "initVariablesView", "", "onVariablesViewRebuilt", "getInlineCallback", "Lcom/intellij/jupyter/py/variables/inline/JupyterInlineCallback;", "jupyterFile", "clearInlineValuesData", "createActionToolbar", "frameAccessor", "Lcom/intellij/jupyter/py/variables/JupyterVarsFrameAccessor;", "RefreshAction", "ToggleConsoleVisibilityAction", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nPythonJupyterVarsToolWindowPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonJupyterVarsToolWindowPanel.kt\ncom/intellij/jupyter/py/variables/PythonJupyterVarsToolWindowPanel\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,158:1\n31#2,2:159\n*S KotlinDebug\n*F\n+ 1 PythonJupyterVarsToolWindowPanel.kt\ncom/intellij/jupyter/py/variables/PythonJupyterVarsToolWindowPanel\n*L\n41#1:159,2\n*E\n"})
public final class PythonJupyterVarsToolWindowPanel
extends JupyterVarsToolWindowPanel {
    @Nullable
    private final JupyterConsoleView consoleView;

    public PythonJupyterVarsToolWindowPanel(@NotNull Project project, @NotNull BackedNotebookVirtualFile notebookFile, @Nullable JupyterConsoleView consoleView) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notebookFile, (String)"notebookFile");
        super(project, notebookFile);
        this.consoleView = consoleView;
    }

    private final JupyterRuntimeEnvService getService() {
        ComponentManager $this$service$iv = (ComponentManager)this.getProject();
        boolean $i$f$service = false;
        Class<JupyterRuntimeEnvService> serviceClass$iv = JupyterRuntimeEnvService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (JupyterRuntimeEnvService)object;
    }

    public void initVariablesView() {
        JupyterInlineCallback frameVarsCallback = this.getInlineCallback(this.getProject(), this.getNotebookFile());
        this.removeAll();
        JupyterVarsFrameAccessor jupyterVarsFrameAccessor = this.getService().getFrameAccessor(this.getNotebookFile().getFile());
        if (jupyterVarsFrameAccessor == null) {
            return;
        }
        JupyterVarsFrameAccessor frameAccessor = jupyterVarsFrameAccessor;
        PyStackFrame stackFrame = new PyStackFrame(this.getProject(), (PyFrameAccessor)frameAccessor, new PyStackFrameInfo("", "", "", null), null);
        this.removeClickListener();
        this.setVariablesView(this.getService().createVariablesView(this.getNotebookFile().getFile(), stackFrame));
        XValueChildrenList values = this.getService().getXValueChildrenList(this.getNotebookFile().getFile());
        if (values != null && frameVarsCallback != null) {
            PythonJupyterVarsManager.Companion.callJupyterInlineCallback(this.getProject(), this.getNotebookFile(), values, frameVarsCallback);
        }
        XStandaloneVariablesView xStandaloneVariablesView = this.getVariablesView();
        if (xStandaloneVariablesView != null) {
            XStandaloneVariablesView it = xStandaloneVariablesView;
            boolean bl = false;
            Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)it));
            this.add(it.getPanel(), "Center");
            this.setClickListener(new ClickListener(this){
                final /* synthetic */ PythonJupyterVarsToolWindowPanel this$0;
                {
                    this.this$0 = $receiver;
                }

                public boolean onClick(MouseEvent event, int clickCount) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.this$0.logViewUsage();
                    return false;
                }
            });
            ListenerUtil.addClickListener((Component)it.getPanel(), (ClickListener)this.getClickListener());
        }
        this.createActionToolbar(frameAccessor);
        this.validate();
        this.repaint();
    }

    protected void onVariablesViewRebuilt() {
        JupyterRuntimeEnvService jupyterRuntimeEnvService = this.getService();
        VirtualFile virtualFile = this.getNotebookFile().getFile();
        XStandaloneVariablesView xStandaloneVariablesView = this.getVariablesView();
        Intrinsics.checkNotNull((Object)xStandaloneVariablesView);
        jupyterRuntimeEnvService.updateVariablesView(virtualFile, xStandaloneVariablesView);
    }

    private final JupyterInlineCallback getInlineCallback(Project project, BackedNotebookVirtualFile jupyterFile) {
        return JupyterInlineService.Companion.getInstance(project).getInlineCallback(jupyterFile);
    }

    protected void clearInlineValuesData() {
        block1: {
            JupyterInlineCallback inlineCallback = this.getInlineCallback(this.getProject(), this.getNotebookFile());
            ScopeOwner scopeOwner = (ScopeOwner)ReadAction.compute(() -> PythonJupyterVarsToolWindowPanel.clearInlineValuesData$lambda$1(this));
            if (scopeOwner == null) break block1;
            ScopeOwner scopeOwner2 = scopeOwner;
            boolean bl = false;
            JupyterInlineCallback jupyterInlineCallback = inlineCallback;
            if (jupyterInlineCallback != null) {
                XValueChildrenList xValueChildrenList = XValueChildrenList.EMPTY;
                Intrinsics.checkNotNullExpressionValue((Object)xValueChildrenList, (String)"EMPTY");
                jupyterInlineCallback.frameChanged(xValueChildrenList, scopeOwner2);
            }
        }
    }

    private final void createActionToolbar(JupyterVarsFrameAccessor frameAccessor) {
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("PythonJupyterVarsToolWindowPanel", (ActionGroup)toolbarActions, false);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar actionToolbar2 = actionToolbar;
        actionToolbar2.setTargetComponent((JComponent)((Object)this));
        this.add(actionToolbar2.getComponent(), "West");
        toolbarActions.add((AnAction)new RefreshAction(this));
        DefaultActionGroup settings = new DefaultActionGroup(JupyterBundle.message((String)"jupyter.toolbar.variables.settings.short.name", (Object[])new Object[0]), true);
        settings.getTemplatePresentation().setIcon(AllIcons.General.GearPlain);
        settings.add((AnAction)new PyVariableViewSettings.SimplifiedView(null));
        PyVariableViewSettings.VariablesPolicyGroup variablesPolicyGroup = new PyVariableViewSettings.VariablesPolicyGroup();
        variablesPolicyGroup.addValuesPolicyListener(() -> PythonJupyterVarsToolWindowPanel.createActionToolbar$lambda$3(frameAccessor));
        settings.add((AnAction)variablesPolicyGroup);
        toolbarActions.add((AnAction)settings);
        JupyterConsoleView jupyterConsoleView = this.consoleView;
        if (jupyterConsoleView != null) {
            JupyterConsoleView it = jupyterConsoleView;
            boolean bl = false;
            ToggleConsoleVisibilityAction toggleConsoleAction = new ToggleConsoleVisibilityAction(it);
            toolbarActions.add((AnAction)toggleConsoleAction);
        }
        this.setToolbar(actionToolbar2.getComponent());
    }

    private static final ScopeOwner clearInlineValuesData$lambda$1(PythonJupyterVarsToolWindowPanel this$0) {
        PsiFile psiFile2 = JupyterInlinePainterKt.getPythonJupyterPsiFile(this$0.getProject(), this$0.getNotebookFile().getOriginFile());
        return psiFile2 instanceof ScopeOwner ? (ScopeOwner)psiFile2 : null;
    }

    private static final void createActionToolbar$lambda$3(JupyterVarsFrameAccessor $frameAccessor) {
        $frameAccessor.updateLoadingPolicy();
    }

    public static final /* synthetic */ JupyterInlineCallback access$getInlineCallback(PythonJupyterVarsToolWindowPanel $this, Project project, BackedNotebookVirtualFile jupyterFile) {
        return $this.getInlineCallback(project, jupyterFile);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/jupyter/py/variables/PythonJupyterVarsToolWindowPanel$RefreshAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "view", "Lcom/intellij/jupyter/py/variables/PythonJupyterVarsToolWindowPanel;", "<init>", "(Lcom/intellij/jupyter/py/variables/PythonJupyterVarsToolWindowPanel;)V", "getView", "()Lcom/intellij/jupyter/py/variables/PythonJupyterVarsToolWindowPanel;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.jupyter.py"})
    private static final class RefreshAction
    extends AnAction {
        @NotNull
        private final PythonJupyterVarsToolWindowPanel view;

        public RefreshAction(@NotNull PythonJupyterVarsToolWindowPanel view) {
            Intrinsics.checkNotNullParameter((Object)((Object)view), (String)"view");
            super(JupyterBundle.message((String)"jupyter.refresh.variables.title", (Object[])new Object[0]), JupyterBundle.message((String)"jupyter.refresh.variables.description", (Object[])new Object[0]), AllIcons.Actions.Refresh);
            this.view = view;
        }

        @NotNull
        public final PythonJupyterVarsToolWindowPanel getView() {
            return this.view;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            String string = JupyterBundle.message((String)"jupyter.refresh.variables.description", (Object[])new Object[0]);
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, project, string){
                final /* synthetic */ RefreshAction this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1, $super_call_param$2);
                }

                public void run(ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    ComponentManager $this$service$iv = (ComponentManager)this.this$0.getView().getProject();
                    boolean $i$f$service = false;
                    Class<JupyterRuntimeEnvService> serviceClass$iv = JupyterRuntimeEnvService.class;
                    Object object = $this$service$iv.getService(serviceClass$iv);
                    if (object == null) {
                        throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                    }
                    JupyterRuntimeEnvService service = (JupyterRuntimeEnvService)object;
                    service.refreshEnv(this.this$0.getView().getNotebookFile());
                    XValueChildrenList frameValues = service.getXValueChildrenList(this.this$0.getView().getNotebookFile().getFile());
                    JupyterInlineCallback inlineCallback = PythonJupyterVarsToolWindowPanel.access$getInlineCallback(this.this$0.getView(), this.this$0.getView().getProject(), this.this$0.getView().getNotebookFile());
                    if (frameValues != null && inlineCallback != null) {
                        PythonJupyterVarsManager.Companion.callJupyterInlineCallback(this.this$0.getView().getProject(), this.this$0.getView().getNotebookFile(), frameValues, inlineCallback);
                    }
                    this.this$0.getView().rebuildView();
                }
            });
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/jupyter/py/variables/PythonJupyterVarsToolWindowPanel$ToggleConsoleVisibilityAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "consoleView", "Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleView;", "<init>", "(Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleView;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.jupyter.py"})
    private static final class ToggleConsoleVisibilityAction
    extends AnAction {
        @NotNull
        private final JupyterConsoleView consoleView;

        public ToggleConsoleVisibilityAction(@NotNull JupyterConsoleView consoleView) {
            Intrinsics.checkNotNullParameter((Object)((Object)consoleView), (String)"consoleView");
            super(null, null, AllIcons.Debugger.Console);
            this.consoleView = consoleView;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.consoleView.setConsoleVisibility(!this.consoleView.isConsoleVisible());
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (this.consoleView.isConsoleVisible()) {
                e.getPresentation().setText(JupyterBundle.message((String)"jupyter.toggle.console.hide.title", (Object[])new Object[0]));
            } else {
                e.getPresentation().setText(JupyterBundle.message((String)"jupyter.toggle.console.show.title", (Object[])new Object[0]));
            }
        }
    }
}

