/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.docker.dockerFile.DockerPsiFile;
import com.intellij.docker.dockerFile.inspections.DockerFileInspectorBase;
import com.intellij.docker.dockerFile.parser.psi.DockerFileEntrypointCommand;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\n\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/docker/dockerFile/inspections/DockerFileEntrypointWithoutExecInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "EntrypointWithExecInspector", "EntrypointWithExecQuickFix", "intellij.clouds.docker.file"})
public final class DockerFileEntrypointWithoutExecInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiElementVisitor psiElementVisitor;
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (holder.getFile() instanceof DockerPsiFile) {
            psiElementVisitor = new EntrypointWithExecInspector(holder, isOnTheFly);
        } else {
            PsiElementVisitor psiElementVisitor2 = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNull((Object)psiElementVisitor2);
            psiElementVisitor = psiElementVisitor2;
        }
        return psiElementVisitor;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/docker/dockerFile/inspections/DockerFileEntrypointWithoutExecInspection$EntrypointWithExecInspector;", "Lcom/intellij/docker/dockerFile/inspections/DockerFileInspectorBase;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "onTheFly", "", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Z)V", "visitEntrypointCommand", "", "o", "Lcom/intellij/docker/dockerFile/parser/psi/DockerFileEntrypointCommand;", "intellij.clouds.docker.file"})
    private static final class EntrypointWithExecInspector
    extends DockerFileInspectorBase {
        public EntrypointWithExecInspector(@NotNull ProblemsHolder holder, boolean onTheFly) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            super(holder, onTheFly);
        }

        @Override
        public void visitEntrypointCommand(@NotNull DockerFileEntrypointCommand o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            PsiErrorElement error = (PsiErrorElement)PsiTreeUtil.findChildOfType((PsiElement)o, PsiErrorElement.class);
            if (error != null) {
                return;
            }
            if (o.getParametersInJsonForm() != null) {
                return;
            }
            PsiElement entrypointElem = o.getFirstChild();
            PsiElement psiElement = PsiTreeUtil.nextCodeLeaf((PsiElement)entrypointElem);
            if (psiElement == null) {
                return;
            }
            PsiElement firstArg = psiElement;
            if (!Intrinsics.areEqual((Object)firstArg.getText(), (Object)"exec")) {
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new EntrypointWithExecQuickFix()};
                this.registerProblem(CollectionsKt.listOf((Object)o), DockerBundle.message("DockerFileEntrypointWithoutExecInspection.problem", new Object[0]), ProblemHighlightType.WEAK_WARNING, localQuickFixArray);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/docker/dockerFile/inspections/DockerFileEntrypointWithoutExecInspection$EntrypointWithExecQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.clouds.docker.file"})
    private static final class EntrypointWithExecQuickFix
    implements LocalQuickFix {
        @NotNull
        public String getFamilyName() {
            String string = DockerBundle.message("DockerFileEntrypointWithoutExecInspection.quickfix", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement entrypointElem = descriptor2.getPsiElement().getFirstChild();
            Document document = entrypointElem.getContainingFile().getFileDocument();
            Intrinsics.checkNotNull((Object)entrypointElem);
            document.insertString(PsiTreeUtilKt.getEndOffset((PsiElement)entrypointElem), (CharSequence)" exec");
        }
    }
}

