/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.pipe;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.AsyncDockerCmd;
import com.github.dockerjava.api.model.Frame;
import com.github.dockerjava.api.model.StreamType;
import com.intellij.docker.agent.DockerAgentContext;
import com.intellij.docker.agent.i18n.DockerAgentBundle;
import com.intellij.docker.agent.progress.AgentResultCallbackTemplate;
import com.intellij.docker.agent.terminal.pipe.DockerTerminalPipe;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.ChannelsKt;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u0000 \u0016*\u0014\b\u0000\u0010\u0001*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004:\u0002\u0015\u0016B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\r\u0010\u0010\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0013H$J\u0006\u0010\u0014\u001a\u00020\rR\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/docker/agent/pipe/DockerAsyncCmdAbstractPipe;", "CMD_T", "Lcom/github/dockerjava/api/command/AsyncDockerCmd;", "Lcom/github/dockerjava/api/model/Frame;", "Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe$WithTty;", "context", "Lcom/intellij/docker/agent/DockerAgentContext;", "<init>", "(Lcom/intellij/docker/agent/DockerAgentContext;)V", "getContext", "()Lcom/intellij/docker/agent/DockerAgentContext;", "myCloseFunction", "Lkotlin/Function0;", "", "start", "Lcom/intellij/docker/agent/terminal/pipe/DockerTerminalPipe;", "cmd", "()Lcom/github/dockerjava/api/command/AsyncDockerCmd;", "callback", "Lcom/intellij/docker/agent/progress/AgentResultCallbackTemplate$Adapter;", "close", "MyDockerResultCallback", "Companion", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\nDockerAsyncCmdAbstractPipe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerAsyncCmdAbstractPipe.kt\ncom/intellij/docker/agent/pipe/DockerAsyncCmdAbstractPipe\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logging.kt\ncom/intellij/docker/agent/util/LoggingKt\n*L\n1#1,86:1\n1#2:87\n8#3:88\n*S KotlinDebug\n*F\n+ 1 DockerAsyncCmdAbstractPipe.kt\ncom/intellij/docker/agent/pipe/DockerAsyncCmdAbstractPipe\n*L\n84#1:88\n*E\n"})
public abstract class DockerAsyncCmdAbstractPipe<CMD_T extends AsyncDockerCmd<CMD_T, Frame>>
extends DockerTerminalPipe.WithTty {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DockerAgentContext context;
    @Nullable
    private volatile Function0<Unit> myCloseFunction;
    @NotNull
    private static final Logger logger;

    public DockerAsyncCmdAbstractPipe(@NotNull DockerAgentContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context.getAgent().getScope());
        this.context = context;
    }

    @NotNull
    protected final DockerAgentContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final DockerTerminalPipe start() {
        Closeable closeable = (Closeable)this.cmd();
        Throwable throwable = null;
        try {
            AsyncDockerCmd it = (AsyncDockerCmd)closeable;
            boolean bl = false;
            AgentResultCallbackTemplate.Adapter adapter = (AgentResultCallbackTemplate.Adapter)it.exec((ResultCallback)this.callback());
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return this;
    }

    @NotNull
    protected abstract CMD_T cmd();

    @NotNull
    protected abstract AgentResultCallbackTemplate.Adapter<Frame> callback();

    @Override
    public final void close() {
        Function0<Unit> function0 = this.myCloseFunction;
        if (function0 != null) {
            function0.invoke();
        }
        super.close();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(DockerAsyncCmdAbstractPipe.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        DockerAsyncCmdAbstractPipe.logger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/docker/agent/pipe/DockerAsyncCmdAbstractPipe$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "intellij.clouds.docker.agent"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0094\u0004\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\b\u0010\u0007\u001a\u00020\u0006H\u0014J\u0010\u0010\b\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0012\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0016J\u0006\u0010\r\u001a\u00020\u0006\u00a8\u0006\u000e"}, d2={"Lcom/intellij/docker/agent/pipe/DockerAsyncCmdAbstractPipe$MyDockerResultCallback;", "Lcom/intellij/docker/agent/progress/AgentResultCallbackTemplate$Adapter;", "Lcom/github/dockerjava/api/model/Frame;", "<init>", "(Lcom/intellij/docker/agent/pipe/DockerAsyncCmdAbstractPipe;)V", "beforeClose", "", "beforeStart", "onStart", "stream", "Ljava/io/Closeable;", "onNext", "frame", "close", "intellij.clouds.docker.agent"})
    protected class MyDockerResultCallback
    extends AgentResultCallbackTemplate.Adapter<Frame> {
        protected void beforeClose() {
            DockerAsyncCmdAbstractPipe.this.setShowCursor(false);
            DockerAsyncCmdAbstractPipe.this.printInfo(DockerAgentBundle.Companion.message("DockerAsyncCmdAbstractPipe.disconnected.from.container", new Object[0]));
        }

        protected void beforeStart() {
        }

        @Override
        public final void onStart(@Nullable Closeable stream) {
            this.beforeStart();
            DockerAsyncCmdAbstractPipe.this.myCloseFunction = () -> MyDockerResultCallback.onStart$lambda$0(this);
            super.onStart(stream);
        }

        @Override
        public void onNext(@Nullable Frame frame) {
            if (frame != null) {
                byte[] byArray = frame.getPayload();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getPayload(...)");
                byte[] byArray2 = byArray;
                Charset charset = Charsets.UTF_8;
                String payload = StringsKt.replace$default((String)new String(byArray2, charset), (String)"\n", (String)"\r\n", (boolean)false, (int)4, null);
                byte[] byArray3 = payload.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
                byte[] toPrint = byArray3;
                try {
                    StreamType streamType = frame.getStreamType();
                    charset = switch (streamType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[streamType.ordinal()]) {
                        case 1, 2, 3 -> ChannelResult.box-impl((Object)ChannelsKt.trySendBlocking((SendChannel)((SendChannel)DockerAsyncCmdAbstractPipe.this.getOutToTerminalChannel()), (Object)toPrint));
                        default -> {
                            LoggerFactory.getLogger(MyDockerResultCallback.class).error("unknown stream type:" + frame.getStreamType());
                            yield Unit.INSTANCE;
                        }
                    };
                }
                catch (IOException e) {
                    this.onError(e);
                    charset = Unit.INSTANCE;
                }
            }
        }

        @Override
        public final void close() {
            this.beforeClose();
            super.close();
            DockerAsyncCmdAbstractPipe.this.close();
        }

        private static final Unit onStart$lambda$0(MyDockerResultCallback this$0) {
            super.close();
            return Unit.INSTANCE;
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[StreamType.values().length];
                try {
                    nArray[StreamType.STDOUT.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StreamType.RAW.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[StreamType.STDERR.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

