/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.history.ActivityId;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.notification.Notification;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangeListUtil;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitResultHandler;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.util.VcsUserUtil;
import git4idea.GitApplyChangesConflictNotification;
import git4idea.GitApplyChangesNothingToDoNotification;
import git4idea.GitApplyChangesProcessKt;
import git4idea.GitUtil;
import git4idea.actions.GitAbortOperationAction;
import git4idea.applyChanges.GitApplyChangesLocalChangesDetectedNotification;
import git4idea.applyChanges.GitApplyChangesNotificationsHandler;
import git4idea.changes.GitChangeUtils;
import git4idea.cherrypick.GitLocalChangesConflictDetector;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineEventDetector;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.i18n.GitBundle;
import git4idea.index.GitStageContentProviderKt;
import git4idea.index.GitStageManagerKt;
import git4idea.merge.GitConflictResolver;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.stash.GitChangesSaver;
import git4idea.util.GitUntrackedFilesHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010$\n\u0002\b\u0007\b \u0018\u0000 ]2\u00020\u0001:\u0006XYZ[\\]BV\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u0012\b\b\u0001\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u000b\u0010\u000e\u001a\u00070\b\u00a2\u0006\u0002\b\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020%H$J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H$J\u001d\u0010*\u001a\u00070\b\u00a2\u0006\u0002\b+2\u0006\u0010(\u001a\u00020)2\u0006\u0010,\u001a\u00020\u0006H$J&\u0010-\u001a\u00020%2\u0006\u0010(\u001a\u00020)2\u0006\u0010,\u001a\u00020\u00062\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u0005H$J\u0006\u00100\u001a\u00020'J \u00100\u001a\u00020'2\b\u00101\u001a\u0004\u0018\u0001022\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u001c\u00103\u001a\u00020\r2\f\u00104\u001a\b\u0012\u0004\u0012\u0002050\u00052\u0006\u00101\u001a\u000202J4\u00106\u001a\u00020\r2\u0006\u0010(\u001a\u00020)2\u0006\u0010,\u001a\u00020\u00062\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u0006082\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u000608H\u0014J6\u0010:\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\b\u0010;\u001a\u0004\u0018\u00010\u00062\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u0006082\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u000608H\u0002JD\u0010<\u001a\u00020\r2\u0006\u0010(\u001a\u00020)2\u0006\u0010,\u001a\u00020\u00062\u0006\u0010=\u001a\u00020\b2\u0006\u0010>\u001a\u00020?2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u0006082\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u000608H\u0002J\u0016\u0010@\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\u001d\u001a\u00020AH\u0002J\u0010\u0010B\u001a\u00020'2\u0006\u0010C\u001a\u000205H\u0002J\u0016\u0010D\u001a\u00020'2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020G0FH\u0002J.\u0010H\u001a\u00020\r2\u0006\u0010(\u001a\u00020)2\u0006\u0010>\u001a\u00020?2\u0006\u0010=\u001a\u00020\b2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020G0FH\u0002J\u0010\u0010I\u001a\u00020J2\u0006\u0010,\u001a\u00020\u0006H\u0002J$\u0010K\u001a\u00020'2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J&\u0010M\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010,\u001a\u00020\u00062\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u001e\u0010N\u001a\u00020'2\u0006\u0010,\u001a\u00020\u00062\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J(\u0010O\u001a\u00020'2\b\b\u0001\u0010P\u001a\u00020\b2\u0006\u0010Q\u001a\u00020\u00062\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0016\u0010R\u001a\u00020\b2\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0003J\u001e\u0010S\u001a\u00020\b2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010T\u001a\u00020\rH\u0003J\"\u0010U\u001a\u00020\b2\u0018\u0010V\u001a\u0014\u0012\u0004\u0012\u00020)\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050WH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\b\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u0013\u0010\u001d\u001a\u00070\u001e\u00a2\u0006\u0002\b\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001f\u001a\u00070 \u00a2\u0006\u0002\b\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lgit4idea/GitApplyChangesProcess;", "", "project", "Lcom/intellij/openapi/project/Project;", "commits", "", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "operationName", "", "appliedWord", "abortCommand", "Lgit4idea/actions/GitAbortOperationAction;", "preserveCommitMetadata", "", "activityName", "Lcom/intellij/openapi/util/NlsContexts$Label;", "activityId", "Lcom/intellij/history/ActivityId;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Lgit4idea/actions/GitAbortOperationAction;ZLjava/lang/String;Lcom/intellij/history/ActivityId;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "repositoryManager", "Lgit4idea/repo/GitRepositoryManager;", "Lorg/jetbrains/annotations/NotNull;", "vcsNotifier", "Lcom/intellij/openapi/vcs/VcsNotifier;", "kotlin.jvm.PlatformType", "Lcom/intellij/openapi/vcs/VcsNotifier;", "changeListManager", "Lcom/intellij/openapi/vcs/changes/ChangeListManagerEx;", "vcsHelper", "Lcom/intellij/openapi/vcs/AbstractVcsHelper;", "notificationsHandler", "Lgit4idea/applyChanges/GitApplyChangesNotificationsHandler;", "isEmptyCommit", "result", "Lgit4idea/commands/GitCommandResult;", "cleanupBeforeCommit", "", "repository", "Lgit4idea/repo/GitRepository;", "generateDefaultMessage", "Lorg/jetbrains/annotations/NonNls;", "commit", "applyChanges", "listeners", "Lgit4idea/commands/GitLineHandlerListener;", "execute", "changesSaver", "Lgit4idea/stash/GitChangesSaver;", "trySaveChanges", "roots", "Lcom/intellij/openapi/vfs/VirtualFile;", "executeForCommit", "successfulCommits", "", "alreadyPicked", "handleLocalChangesDetected", "failedOnCommit", "commitChangelist", "commitMessage", "changeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "getAllChangesInLogFriendlyPresentation", "Lcom/intellij/openapi/vcs/changes/ChangeListManager;", "refreshStagedVfs", "root", "markDirty", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "showCommitDialogAndWaitForCommit", "createChangeListData", "Lcom/intellij/openapi/vcs/changes/ChangeListData;", "notifyResult", "skipped", "notifyConflictWarning", "notifyCommitCancelled", "notifyError", "content", "failedCommit", "getSuccessfulCommitDetailsIfAny", "formSkippedDescription", "but", "toString", "commitsInRoots", "", "CommitStrategy", "ChangeListCommit", "SimplifiedCommit", "StagingAreaCommit", "ConflictResolver", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitApplyChangesProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitApplyChangesProcess.kt\ngit4idea/GitApplyChangesProcess\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,577:1\n31#2,2:578\n126#3:580\n153#3,3:581\n1#4:584\n1557#5:585\n1628#5,3:586\n774#5:589\n865#5,2:590\n15#6:592\n*S KotlinDebug\n*F\n+ 1 GitApplyChangesProcess.kt\ngit4idea/GitApplyChangesProcess\n*L\n71#1:578,2\n100#1:580\n100#1:581,3\n358#1:585\n358#1:586,3\n236#1:589\n236#1:590,2\n514#1:592\n*E\n"})
public abstract class GitApplyChangesProcess {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final List<VcsCommitMetadata> commits;
    @NotNull
    private final String operationName;
    @NotNull
    private final String appliedWord;
    @NotNull
    private final GitAbortOperationAction abortCommand;
    private final boolean preserveCommitMetadata;
    @NotNull
    private final String activityName;
    @NotNull
    private final ActivityId activityId;
    @NotNull
    private final GitRepositoryManager repositoryManager;
    private final VcsNotifier vcsNotifier;
    @NotNull
    private final ChangeListManagerEx changeListManager;
    @NotNull
    private final AbstractVcsHelper vcsHelper;
    @NotNull
    private final GitApplyChangesNotificationsHandler notificationsHandler;
    @NotNull
    private static final Logger LOG;

    public GitApplyChangesProcess(@NotNull Project project, @NotNull List<? extends VcsCommitMetadata> commits, @Nls @NotNull String operationName, @Nls @NotNull String appliedWord, @NotNull GitAbortOperationAction abortCommand, boolean preserveCommitMetadata, @NotNull String activityName, @NotNull ActivityId activityId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(commits, (String)"commits");
        Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
        Intrinsics.checkNotNullParameter((Object)appliedWord, (String)"appliedWord");
        Intrinsics.checkNotNullParameter((Object)((Object)abortCommand), (String)"abortCommand");
        Intrinsics.checkNotNullParameter((Object)activityName, (String)"activityName");
        Intrinsics.checkNotNullParameter((Object)activityId, (String)"activityId");
        this.project = project;
        this.commits = commits;
        this.operationName = operationName;
        this.appliedWord = appliedWord;
        this.abortCommand = abortCommand;
        this.preserveCommitMetadata = preserveCommitMetadata;
        this.activityName = activityName;
        this.activityId = activityId;
        GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"getInstance(...)");
        this.repositoryManager = gitRepositoryManager;
        this.vcsNotifier = VcsNotifier.getInstance((Project)this.project);
        ChangeListManagerEx changeListManagerEx = ChangeListManagerEx.getInstanceEx((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManagerEx, (String)"getInstanceEx(...)");
        this.changeListManager = changeListManagerEx;
        AbstractVcsHelper abstractVcsHelper = AbstractVcsHelper.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)abstractVcsHelper, (String)"getInstance(...)");
        this.vcsHelper = abstractVcsHelper;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<GitApplyChangesNotificationsHandler> serviceClass$iv = GitApplyChangesNotificationsHandler.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.notificationsHandler = (GitApplyChangesNotificationsHandler)object;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    protected abstract boolean isEmptyCommit(@NotNull GitCommandResult var1);

    protected abstract void cleanupBeforeCommit(@NotNull GitRepository var1);

    @NotNull
    protected abstract String generateDefaultMessage(@NotNull GitRepository var1, @NotNull VcsCommitMetadata var2);

    @NotNull
    protected abstract GitCommandResult applyChanges(@NotNull GitRepository var1, @NotNull VcsCommitMetadata var2, @NotNull List<? extends GitLineHandlerListener> var3);

    public final void execute() {
        this.notificationsHandler.beforeApply();
        this.execute(null, this.commits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void execute(GitChangesSaver changesSaver, List<? extends VcsCommitMetadata> commits) {
        if (this.changeListManager.areChangeListsEnabled()) {
            this.changeListManager.waitForUpdate();
        }
        Map map2 = DvcsUtil.groupCommitsByRoots((RepositoryManager)((RepositoryManager)this.repositoryManager), commits);
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"groupCommitsByRoots(...)");
        Map commitsInRoots = map2;
        LOG.info(this.operationName + "ing commits: " + this.toString(commitsInRoots));
        if (changesSaver != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map map3 = commitsInRoots;
            GitApplyChangesProcess gitApplyChangesProcess = this;
            boolean $i$f$map = false;
            Iterator iterator = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                GitRepository repo2 = (GitRepository)entry.getKey();
                VirtualFile virtualFile = repo2.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                collection.add(virtualFile);
            }
            if (!gitApplyChangesProcess.trySaveChanges((List)destination$iv$iv, changesSaver)) {
                return;
            }
        }
        List successfulCommits = new ArrayList();
        List skippedCommits = new ArrayList();
        for (Map.Entry entry : commitsInRoots.entrySet()) {
            GitRepository repository = (GitRepository)entry.getKey();
            List repoCommits = (List)entry.getValue();
            try {
                for (VcsCommitMetadata commit : repoCommits) {
                    Intrinsics.checkNotNull((Object)repository);
                    Intrinsics.checkNotNull((Object)commit);
                    if (this.executeForCommit(repository, commit, successfulCommits, skippedCommits)) continue;
                    this.notificationsHandler.operationFailed(this.operationName, repository, changesSaver);
                    return;
                }
            }
            finally {
                repository.update();
            }
        }
        this.notifyResult(successfulCommits, skippedCommits);
        if (changesSaver != null) {
            LOG.info("Restoring saved changes after successful " + this.operationName);
            changesSaver.load();
        }
    }

    public final boolean trySaveChanges(@NotNull List<? extends VirtualFile> roots, @NotNull GitChangesSaver changesSaver) {
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)changesSaver, (String)"changesSaver");
        String string = changesSaver.saveLocalChangesOrError((Collection<? extends VirtualFile>)roots);
        if (string == null) {
            return true;
        }
        String errorMessage = string;
        VcsNotifier.getInstance((Project)this.project).notifyError("vcs.uncommitted.changes.saving.error", VcsBundle.message((String)"notification.title.couldn.t.save.uncommitted.changes", (Object[])new Object[0]), errorMessage);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeForCommit(@NotNull GitRepository repository, @NotNull VcsCommitMetadata commit, @NotNull List<VcsCommitMetadata> successfulCommits, @NotNull List<VcsCommitMetadata> alreadyPicked) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        Intrinsics.checkNotNullParameter(successfulCommits, (String)"successfulCommits");
        Intrinsics.checkNotNullParameter(alreadyPicked, (String)"alreadyPicked");
        GitSimpleEventDetector conflictDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.CHERRY_PICK_CONFLICT);
        GitLocalChangesConflictDetector localChangesOverwrittenDetector = new GitLocalChangesConflictDetector();
        GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector = new GitUntrackedFilesOverwrittenByOperationDetector(repository.getRoot());
        String commitMessage = this.generateDefaultMessage(repository, (VcsCommitMetadata)commit);
        CommitStrategy strategy = GitStageManagerKt.isStagingAreaAvailable(this.project) ? (CommitStrategy)new StagingAreaCommit(repository, (VcsCommitMetadata)commit, commitMessage) : (this.changeListManager.areChangeListsEnabled() && VcsApplicationSettings.getInstance().CREATE_CHANGELISTS_AUTOMATICALLY ? (CommitStrategy)new ChangeListCommit(repository, (VcsCommitMetadata)commit, commitMessage) : (CommitStrategy)new SimplifiedCommit(repository, (VcsCommitMetadata)commit, commitMessage));
        LocalHistoryAction action = LocalHistory.Companion.getInstance().startAction(this.activityName, this.activityId);
        strategy.start();
        try {
            Hash startHash = GitUtil.getHead(repository);
            GitLineEventDetector[] gitLineEventDetectorArray = new GitLineEventDetector[]{conflictDetector, localChangesOverwrittenDetector, untrackedFilesDetector};
            GitCommandResult result2 = this.applyChanges(repository, (VcsCommitMetadata)commit, CollectionsKt.listOf((Object[])gitLineEventDetectorArray));
            if (result2.success()) {
                GitUtil.refreshChangedVfs(repository, startHash);
                successfulCommits.add((VcsCommitMetadata)commit);
                boolean bl = true;
                return bl;
            }
            if (conflictDetector.isDetected()) {
                VirtualFile virtualFile = repository.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                String string = ((Hash)commit.getId()).toShortString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toShortString(...)");
                String string2 = VcsUserUtil.getShortPresentation((VcsUser)commit.getAuthor());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getShortPresentation(...)");
                String string3 = commit.getSubject();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getSubject(...)");
                boolean mergeCompleted = new ConflictResolver(this.project, virtualFile, string, string2, string3, this.operationName).merge();
                VirtualFile virtualFile2 = repository.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getRoot(...)");
                this.refreshStagedVfs(virtualFile2);
                VcsDirtyScopeManager.getInstance((Project)this.project).rootDirty(repository.getRoot());
                this.changeListManager.waitForUpdate();
                strategy.afterChangesRefreshed();
                if (mergeCompleted) {
                    LOG.debug("All conflicts resolved, will show commit dialog.");
                    boolean bl = strategy.doUserCommit(successfulCommits, alreadyPicked);
                    return bl;
                }
                this.notifyConflictWarning(repository, (VcsCommitMetadata)commit, successfulCommits);
                boolean bl = false;
                return bl;
            }
            if (untrackedFilesDetector.isDetected()) {
                String description = this.getSuccessfulCommitDetailsIfAny(successfulCommits);
                GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(this.project, repository.getRoot(), (Collection<String>)untrackedFilesDetector.getRelativeFilePaths(), this.operationName, description);
                boolean bl = false;
                return bl;
            }
            if (localChangesOverwrittenDetector.isDetected()) {
                GitLineEventDetector[] gitLineEventDetectorArray2 = gitLineEventDetectorArray = commit;
                GitRepository gitRepository = repository;
                GitApplyChangesProcess gitApplyChangesProcess = this;
                boolean bl = false;
                boolean bl2 = localChangesOverwrittenDetector.getByMerge();
                gitApplyChangesProcess.handleLocalChangesDetected(gitRepository, (VcsCommitMetadata)(bl2 ? gitLineEventDetectorArray : null), successfulCommits, alreadyPicked);
                boolean bl3 = false;
                return bl3;
            }
            if (this.isEmptyCommit(result2)) {
                alreadyPicked.add((VcsCommitMetadata)commit);
                boolean bl = true;
                return bl;
            }
            String string = result2.getErrorOutputAsHtmlString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getErrorOutputAsHtmlString(...)");
            this.notifyError(string, (VcsCommitMetadata)commit, successfulCommits);
            boolean bl = false;
            return bl;
        }
        finally {
            strategy.finish();
            action.finish();
        }
    }

    private final void handleLocalChangesDetected(GitRepository repository, VcsCommitMetadata failedOnCommit, List<VcsCommitMetadata> successfulCommits, List<VcsCommitMetadata> alreadyPicked) {
        GitApplyChangesLocalChangesDetectedNotification notification = new GitApplyChangesLocalChangesDetectedNotification(this.operationName, failedOnCommit, successfulCommits, repository, (Function1<? super GitChangesSaver, Unit>)((Function1)arg_0 -> GitApplyChangesProcess.handleLocalChangesDetected$lambda$4(this, alreadyPicked, successfulCommits, arg_0)));
        this.vcsNotifier.notify((Notification)notification);
    }

    private final boolean commitChangelist(GitRepository repository, VcsCommitMetadata commit, String commitMessage, LocalChangeList changeList, List<VcsCommitMetadata> successfulCommits, List<VcsCommitMetadata> alreadyPicked) {
        LocalChangeList actualList = this.changeListManager.getChangeList(changeList.getId());
        if (actualList == null) {
            String string = changeList.getId();
            String string2 = changeList.getName();
            List list = this.changeListManager.getChangeLists();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChangeLists(...)");
            LOG.error("Couldn't find the changelist with id " + string + " and name " + string2 + " among " + CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, GitApplyChangesProcess::commitChangelist$lambda$5, (int)31, null));
            return false;
        }
        Collection changes = actualList.getChanges();
        if (changes.isEmpty()) {
            LOG.debug("No changes in the " + actualList + ". All changes in the CLM: " + this.getAllChangesInLogFriendlyPresentation((ChangeListManager)this.changeListManager));
            alreadyPicked.add(commit);
            return true;
        }
        LOG.debug("Showing commit dialog for changes: " + changes);
        Intrinsics.checkNotNull((Object)changes);
        boolean committed = this.showCommitDialogAndWaitForCommit(repository, changeList, commitMessage, changes);
        if (committed) {
            this.markDirty(changes);
            this.changeListManager.waitForUpdate();
            successfulCommits.add(commit);
            return true;
        }
        this.notifyCommitCancelled(commit, successfulCommits);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getAllChangesInLogFriendlyPresentation(ChangeListManager changeListManager) {
        void $this$mapTo$iv$iv;
        List list = changeListManager.getChangeLists();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChangeLists(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LocalChangeList localChangeList = (LocalChangeList)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add("[" + it.getName() + "] " + it.getChanges());
        }
        return (List)destination$iv$iv;
    }

    private final void refreshStagedVfs(VirtualFile root) {
        Collection<GitChangeUtils.GitDiffChange> collection = GitChangeUtils.getStagedChanges(this.project, root);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getStagedChanges(...)");
        Collection<GitChangeUtils.GitDiffChange> staged2 = collection;
        RefreshVFsSynchronously.refresh$default((RefreshVFsSynchronously)RefreshVFsSynchronously.INSTANCE, staged2, (boolean)false, (int)2, null);
    }

    private final void markDirty(Collection<? extends Change> changes) {
        VcsDirtyScopeManager.getInstance((Project)this.project).filePathsDirty((Collection)ChangesUtil.getPaths(changes), null);
    }

    private final boolean showCommitDialogAndWaitForCommit(GitRepository repository, LocalChangeList changeList, String commitMessage, Collection<? extends Change> changes) {
        AtomicBoolean commitSucceeded = new AtomicBoolean();
        Semaphore sem = new Semaphore(0);
        ApplicationManager.getApplication().invokeAndWait(() -> GitApplyChangesProcess.showCommitDialogAndWaitForCommit$lambda$7(this, repository, changes, changeList, commitMessage, commitSucceeded, sem), ModalityState.nonModal());
        try {
            sem.acquire();
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e);
            return false;
        }
        return commitSucceeded.get();
    }

    private final ChangeListData createChangeListData(VcsCommitMetadata commit) {
        return new ChangeListData(commit.getAuthor(), new Date(commit.getAuthorTime()), true);
    }

    private final void notifyResult(List<? extends VcsCommitMetadata> successfulCommits, List<? extends VcsCommitMetadata> skipped) {
        if (skipped.isEmpty()) {
            Object[] objectArray = new Object[]{StringsKt.capitalize((String)this.operationName)};
            v0 = this.vcsNotifier.notifySuccess("git.apply.changes.success", GitBundle.message("apply.changes.operation.successful", objectArray), GitApplyChangesProcess.Companion.getCommitsDetails(successfulCommits));
        } else if (!((Collection)successfulCommits).isEmpty()) {
            Object[] objectArray = new Object[]{StringsKt.capitalize((String)this.appliedWord), successfulCommits.size(), successfulCommits.size() + skipped.size()};
            String string = GitBundle.message("apply.changes.applied.for.commits", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String title = string;
            String description = GitApplyChangesProcess.Companion.getCommitsDetails(successfulCommits) + "<hr/>" + this.formSkippedDescription(skipped, true);
            v0 = this.vcsNotifier.notifySuccess("git.apply.changes.success", title, description);
        } else {
            v0 = this.vcsNotifier.notify((Notification)new GitApplyChangesNothingToDoNotification(this.operationName, this.formSkippedDescription(skipped, false)));
        }
    }

    private final void notifyConflictWarning(GitRepository repository, VcsCommitMetadata commit, List<? extends VcsCommitMetadata> successfulCommits) {
        String description = Companion.commitDetails(commit) + "<br/>" + GitBundle.message("apply.changes.unresolved.conflicts.text", new Object[0]) + this.getSuccessfulCommitDetailsIfAny(successfulCommits);
        VcsNotifier.getInstance((Project)this.project).notify((Notification)new GitApplyChangesConflictNotification(this.operationName, description, commit, repository, this.abortCommand));
    }

    private final void notifyCommitCancelled(VcsCommitMetadata commit, List<? extends VcsCommitMetadata> successfulCommits) {
        if (successfulCommits.isEmpty()) {
            return;
        }
        Object description = Companion.commitDetails(commit);
        description = (String)description + this.getSuccessfulCommitDetailsIfAny(successfulCommits);
        Object[] objectArray = new Object[]{StringsKt.capitalize((String)this.operationName)};
        this.vcsNotifier.notifyMinorWarning("git.commit.cancelled", GitBundle.message("apply.changes.operation.canceled", objectArray), (String)description);
    }

    private final void notifyError(@Nls String content, VcsCommitMetadata failedCommit, List<? extends VcsCommitMetadata> successfulCommits) {
        String description = Companion.commitDetails(failedCommit) + "<br/>" + content;
        description = description + this.getSuccessfulCommitDetailsIfAny(successfulCommits);
        Object[] objectArray = new Object[]{StringsKt.capitalize((String)this.operationName)};
        this.vcsNotifier.notifyError("git.apply.changes.error", GitBundle.message("apply.changes.operation.failed", objectArray), description);
    }

    @Nls
    private final String getSuccessfulCommitDetailsIfAny(List<? extends VcsCommitMetadata> successfulCommits) {
        return Companion.getSuccessfulCommitDetailsIfAny(successfulCommits, this.operationName);
    }

    @Nls
    private final String formSkippedDescription(List<? extends VcsCommitMetadata> skipped, boolean but) {
        String string = StringUtil.join((Collection)skipped, arg_0 -> GitApplyChangesProcess.formSkippedDescription$lambda$9(GitApplyChangesProcess::formSkippedDescription$lambda$8, arg_0), (String)", ");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
        String hashes = string;
        if (but) {
            Object[] objectArray = new Object[]{hashes, skipped.size(), this.appliedWord};
            String string2 = GitBundle.message("apply.changes.skipped", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            return string2;
        }
        Object[] objectArray = new Object[]{hashes, this.appliedWord};
        String string3 = GitBundle.message("apply.changes.everything.applied", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        return string3;
    }

    private final String toString(Map<GitRepository, ? extends List<? extends VcsCommitMetadata>> commitsInRoots) {
        return CollectionsKt.joinToString$default((Iterable)commitsInRoots.entrySet(), (CharSequence)"; ", null, null, (int)0, null, GitApplyChangesProcess::toString$lambda$11, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit handleLocalChangesDetected$lambda$4(GitApplyChangesProcess this$0, List $alreadyPicked, List $successfulCommits, GitChangesSaver saver) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)saver, (String)"saver");
        Set $this$handleLocalChangesDetected_u24lambda_u244_u24lambda_u242 = iterable = SetsKt.createSetBuilder();
        boolean $i$a$-buildSet-GitApplyChangesProcess$handleLocalChangesDetected$notification$1$alreadyPickedSet$22 = false;
        $this$handleLocalChangesDetected_u24lambda_u244_u24lambda_u242.addAll($alreadyPicked);
        $this$handleLocalChangesDetected_u24lambda_u244_u24lambda_u242.addAll($successfulCommits);
        Set alreadyPickedSet = SetsKt.build((Set)iterable);
        LOG.info("Re-trying " + this$0.operationName + ", skipping " + alreadyPickedSet.size() + " already processed commits");
        iterable = this$0.commits;
        GitChangesSaver gitChangesSaver = saver;
        GitApplyChangesProcess gitApplyChangesProcess = this$0;
        boolean $i$f$filter = false;
        void $i$a$-buildSet-GitApplyChangesProcess$handleLocalChangesDetected$notification$1$alreadyPickedSet$22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VcsCommitMetadata commit = (VcsCommitMetadata)element$iv$iv;
            boolean bl = false;
            if (!(!alreadyPickedSet.contains(commit))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        gitApplyChangesProcess.execute(gitChangesSaver, list);
        return Unit.INSTANCE;
    }

    private static final CharSequence commitChangelist$lambda$5(LocalChangeList it) {
        return it.getId() + " " + it.getName();
    }

    private static final void showCommitDialogAndWaitForCommit$lambda$7(GitApplyChangesProcess this$0, GitRepository $repository, Collection $changes, LocalChangeList $changeList, String $commitMessage, AtomicBoolean $commitSucceeded, Semaphore $sem) {
        try {
            this$0.cleanupBeforeCommit($repository);
            boolean commitNotCancelled2 = this$0.vcsHelper.commitChanges($changes, $changeList, $commitMessage, new CommitResultHandler($commitSucceeded, $sem){
                final /* synthetic */ AtomicBoolean $commitSucceeded;
                final /* synthetic */ Semaphore $sem;
                {
                    this.$commitSucceeded = $commitSucceeded;
                    this.$sem = $sem;
                }

                public void onSuccess(String commitMessage1) {
                    Intrinsics.checkNotNullParameter((Object)commitMessage1, (String)"commitMessage1");
                    this.$commitSucceeded.set(true);
                    this.$sem.release();
                }

                public void onCancel() {
                    this.$commitSucceeded.set(false);
                    this.$sem.release();
                }

                public void onFailure(List<? extends VcsException> errors) {
                    Intrinsics.checkNotNullParameter(errors, (String)"errors");
                    this.$commitSucceeded.set(false);
                    this.$sem.release();
                }
            });
            if (!commitNotCancelled2) {
                $commitSucceeded.set(false);
                $sem.release();
            }
        }
        catch (Throwable t) {
            LOG.error(t);
            $commitSucceeded.set(false);
            $sem.release();
        }
    }

    private static final String formSkippedDescription$lambda$8(VcsCommitMetadata commit) {
        return ((Hash)commit.getId()).toShortString();
    }

    private static final String formSkippedDescription$lambda$9(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final CharSequence toString$lambda$11$lambda$10(VcsCommitMetadata it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = ((Hash)it.getId()).asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return string;
    }

    private static final CharSequence toString$lambda$11(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        String commits = CollectionsKt.joinToString$default((Iterable)((Iterable)entry.getValue()), null, null, null, (int)0, null, GitApplyChangesProcess::toString$lambda$11$lambda$10, (int)31, null);
        return DvcsUtil.getShortRepositoryName((Repository)((Repository)entry.getKey())) + ": [" + commits + "]";
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitApplyChangesProcess.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0016J$\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u001fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0011X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015\u00a8\u0006!"}, d2={"Lgit4idea/GitApplyChangesProcess$ChangeListCommit;", "Lgit4idea/GitApplyChangesProcess$CommitStrategy;", "repository", "Lgit4idea/repo/GitRepository;", "commit", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "commitMessage", "", "<init>", "(Lgit4idea/GitApplyChangesProcess;Lgit4idea/repo/GitRepository;Lcom/intellij/vcs/log/VcsCommitMetadata;Ljava/lang/String;)V", "getRepository", "()Lgit4idea/repo/GitRepository;", "getCommit", "()Lcom/intellij/vcs/log/VcsCommitMetadata;", "getCommitMessage", "()Ljava/lang/String;", "changeList", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "getChangeList", "()Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "setChangeList", "(Lcom/intellij/openapi/vcs/changes/LocalChangeList;)V", "previousDefaultChangelist", "getPreviousDefaultChangelist", "setPreviousDefaultChangelist", "start", "", "finish", "doUserCommit", "", "successfulCommits", "", "alreadyPicked", "intellij.vcs.git"})
    private final class ChangeListCommit
    extends CommitStrategy {
        @NotNull
        private final GitRepository repository;
        @NotNull
        private final VcsCommitMetadata commit;
        @NotNull
        private final String commitMessage;
        public LocalChangeList changeList;
        public LocalChangeList previousDefaultChangelist;

        public ChangeListCommit(@NotNull GitRepository repository, @NotNull VcsCommitMetadata commit, String commitMessage) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
            Intrinsics.checkNotNullParameter((Object)commitMessage, (String)"commitMessage");
            this.repository = repository;
            this.commit = commit;
            this.commitMessage = commitMessage;
        }

        @NotNull
        public final GitRepository getRepository() {
            return this.repository;
        }

        @NotNull
        public final VcsCommitMetadata getCommit() {
            return this.commit;
        }

        @NotNull
        public final String getCommitMessage() {
            return this.commitMessage;
        }

        @NotNull
        public final LocalChangeList getChangeList() {
            LocalChangeList localChangeList = this.changeList;
            if (localChangeList != null) {
                return localChangeList;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"changeList");
            return null;
        }

        public final void setChangeList(@NotNull LocalChangeList localChangeList) {
            Intrinsics.checkNotNullParameter((Object)localChangeList, (String)"<set-?>");
            this.changeList = localChangeList;
        }

        @NotNull
        public final LocalChangeList getPreviousDefaultChangelist() {
            LocalChangeList localChangeList = this.previousDefaultChangelist;
            if (localChangeList != null) {
                return localChangeList;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"previousDefaultChangelist");
            return null;
        }

        public final void setPreviousDefaultChangelist(@NotNull LocalChangeList localChangeList) {
            Intrinsics.checkNotNullParameter((Object)localChangeList, (String)"<set-?>");
            this.previousDefaultChangelist = localChangeList;
        }

        @Override
        public void start() {
            this.setPreviousDefaultChangelist(GitApplyChangesProcess.this.changeListManager.getDefaultChangeList());
            String changeListName = ChangeListUtil.createNameForChangeList((Project)GitApplyChangesProcess.this.getProject(), (String)this.commitMessage);
            ChangeListData changeListData = GitApplyChangesProcess.this.preserveCommitMetadata ? GitApplyChangesProcess.this.createChangeListData(this.commit) : null;
            this.setChangeList(GitApplyChangesProcess.this.changeListManager.addChangeList(changeListName, this.commitMessage, changeListData));
            GitApplyChangesProcess.this.changeListManager.setDefaultChangeList(this.getChangeList(), true);
        }

        @Override
        public void finish() {
            GitApplyChangesProcess.this.changeListManager.setDefaultChangeList(this.getPreviousDefaultChangelist(), true);
            GitApplyChangesProcess.this.changeListManager.scheduleAutomaticEmptyChangeListDeletion(this.getChangeList(), true);
        }

        @Override
        public boolean doUserCommit(@NotNull List<VcsCommitMetadata> successfulCommits, @NotNull List<VcsCommitMetadata> alreadyPicked) {
            Intrinsics.checkNotNullParameter(successfulCommits, (String)"successfulCommits");
            Intrinsics.checkNotNullParameter(alreadyPicked, (String)"alreadyPicked");
            return GitApplyChangesProcess.this.commitChangelist(this.repository, this.commit, this.commitMessage, this.getChangeList(), successfulCommits, alreadyPicked);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\b\"\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J$\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH&J\b\u0010\r\u001a\u00020\u0005H\u0016\u00a8\u0006\u000e"}, d2={"Lgit4idea/GitApplyChangesProcess$CommitStrategy;", "", "<init>", "()V", "start", "", "finish", "doUserCommit", "", "successfulCommits", "", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "alreadyPicked", "afterChangesRefreshed", "intellij.vcs.git"})
    private static abstract class CommitStrategy {
        public void start() {
        }

        public void finish() {
        }

        public abstract boolean doUserCommit(@NotNull List<VcsCommitMetadata> var1, @NotNull List<VcsCommitMetadata> var2);

        public void afterChangesRefreshed() {
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u001e\u0010\n\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\f2\u0006\u0010\r\u001a\u00020\u0007H\u0007J\u0016\u0010\u000e\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fH\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lgit4idea/GitApplyChangesProcess$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "commitDetails", "", "commit", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "getSuccessfulCommitDetailsIfAny", "successfulCommits", "", "operationName", "getCommitsDetails", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        @NlsSafe
        @NotNull
        public final String commitDetails(@NotNull VcsCommitMetadata commit) {
            Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
            return ((Hash)commit.getId()).toShortString() + " " + StringUtil.escapeXmlEntities((String)commit.getSubject());
        }

        @Nls
        @NotNull
        public final String getSuccessfulCommitDetailsIfAny(@NotNull List<? extends VcsCommitMetadata> successfulCommits, @NotNull String operationName) {
            Intrinsics.checkNotNullParameter(successfulCommits, (String)"successfulCommits");
            Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
            Object description = "";
            if (!((Collection)successfulCommits).isEmpty()) {
                Object[] objectArray = new Object[]{operationName, successfulCommits.size()};
                description = (String)description + "<hr/>" + GitBundle.message("apply.changes.operation.successful.for.commits", objectArray) + "<br/>";
                description = (String)description + this.getCommitsDetails(successfulCommits);
            }
            return description;
        }

        @NlsSafe
        private final String getCommitsDetails(List<? extends VcsCommitMetadata> successfulCommits) {
            Object description = "";
            for (VcsCommitMetadata vcsCommitMetadata : successfulCommits) {
                if (((CharSequence)description).length() > 0) {
                    description = (String)description + "<br/>";
                }
                description = (String)description + this.commitDetails(vcsCommitMetadata);
            }
            return description;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\b\b\u0001\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lgit4idea/GitApplyChangesProcess$ConflictResolver;", "Lgit4idea/merge/GitConflictResolver;", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "commitHash", "", "commitAuthor", "commitMessage", "operationName", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "notifyUnresolvedRemain", "", "intellij.vcs.git"})
    public static final class ConflictResolver
    extends GitConflictResolver {
        public ConflictResolver(@NotNull Project project, @NotNull VirtualFile root, @NotNull String commitHash, @NotNull String commitAuthor, @NotNull String commitMessage, @Nls @NotNull String operationName) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)commitHash, (String)"commitHash");
            Intrinsics.checkNotNullParameter((Object)commitAuthor, (String)"commitAuthor");
            Intrinsics.checkNotNullParameter((Object)commitMessage, (String)"commitMessage");
            Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
            super(project, SetsKt.setOf((Object)root), GitApplyChangesProcessKt.access$makeParams(project, commitHash, commitAuthor, commitMessage, operationName));
        }

        @Override
        protected void notifyUnresolvedRemain() {
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ$\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lgit4idea/GitApplyChangesProcess$SimplifiedCommit;", "Lgit4idea/GitApplyChangesProcess$CommitStrategy;", "repository", "Lgit4idea/repo/GitRepository;", "commit", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "commitMessage", "", "<init>", "(Lgit4idea/GitApplyChangesProcess;Lgit4idea/repo/GitRepository;Lcom/intellij/vcs/log/VcsCommitMetadata;Ljava/lang/String;)V", "getRepository", "()Lgit4idea/repo/GitRepository;", "getCommit", "()Lcom/intellij/vcs/log/VcsCommitMetadata;", "getCommitMessage", "()Ljava/lang/String;", "doUserCommit", "", "successfulCommits", "", "alreadyPicked", "afterChangesRefreshed", "", "intellij.vcs.git"})
    private final class SimplifiedCommit
    extends CommitStrategy {
        @NotNull
        private final GitRepository repository;
        @NotNull
        private final VcsCommitMetadata commit;
        @NotNull
        private final String commitMessage;

        public SimplifiedCommit(@NotNull GitRepository repository, @NotNull VcsCommitMetadata commit, String commitMessage) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
            Intrinsics.checkNotNullParameter((Object)commitMessage, (String)"commitMessage");
            this.repository = repository;
            this.commit = commit;
            this.commitMessage = commitMessage;
        }

        @NotNull
        public final GitRepository getRepository() {
            return this.repository;
        }

        @NotNull
        public final VcsCommitMetadata getCommit() {
            return this.commit;
        }

        @NotNull
        public final String getCommitMessage() {
            return this.commitMessage;
        }

        @Override
        public boolean doUserCommit(@NotNull List<VcsCommitMetadata> successfulCommits, @NotNull List<VcsCommitMetadata> alreadyPicked) {
            Intrinsics.checkNotNullParameter(successfulCommits, (String)"successfulCommits");
            Intrinsics.checkNotNullParameter(alreadyPicked, (String)"alreadyPicked");
            LocalChangeList localChangeList = GitApplyChangesProcess.this.changeListManager.getDefaultChangeList();
            Intrinsics.checkNotNullExpressionValue((Object)localChangeList, (String)"getDefaultChangeList(...)");
            LocalChangeList list = localChangeList;
            return GitApplyChangesProcess.this.commitChangelist(this.repository, this.commit, this.commitMessage, list, successfulCommits, alreadyPicked);
        }

        @Override
        public void afterChangesRefreshed() {
            LocalChangeList localChangeList = GitApplyChangesProcess.this.changeListManager.getDefaultChangeList();
            Intrinsics.checkNotNullExpressionValue((Object)localChangeList, (String)"getDefaultChangeList(...)");
            LocalChangeList list = localChangeList;
            if (GitApplyChangesProcess.this.preserveCommitMetadata && GitApplyChangesProcess.this.changeListManager.areChangeListsEnabled()) {
                Collection collection = list.getChanges();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getChanges(...)");
                if (!collection.isEmpty()) {
                    GitApplyChangesProcess.this.changeListManager.editChangeListData(list.getName(), GitApplyChangesProcess.this.createChangeListData(this.commit));
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ$\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lgit4idea/GitApplyChangesProcess$StagingAreaCommit;", "Lgit4idea/GitApplyChangesProcess$CommitStrategy;", "repository", "Lgit4idea/repo/GitRepository;", "commit", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "commitMessage", "", "<init>", "(Lgit4idea/repo/GitRepository;Lcom/intellij/vcs/log/VcsCommitMetadata;Ljava/lang/String;)V", "getRepository", "()Lgit4idea/repo/GitRepository;", "getCommit", "()Lcom/intellij/vcs/log/VcsCommitMetadata;", "getCommitMessage", "()Ljava/lang/String;", "doUserCommit", "", "successfulCommits", "", "alreadyPicked", "intellij.vcs.git"})
    private static final class StagingAreaCommit
    extends CommitStrategy {
        @NotNull
        private final GitRepository repository;
        @NotNull
        private final VcsCommitMetadata commit;
        @NotNull
        private final String commitMessage;

        public StagingAreaCommit(@NotNull GitRepository repository, @NotNull VcsCommitMetadata commit, @NotNull String commitMessage) {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
            Intrinsics.checkNotNullParameter((Object)commitMessage, (String)"commitMessage");
            this.repository = repository;
            this.commit = commit;
            this.commitMessage = commitMessage;
        }

        @NotNull
        public final GitRepository getRepository() {
            return this.repository;
        }

        @NotNull
        public final VcsCommitMetadata getCommit() {
            return this.commit;
        }

        @NotNull
        public final String getCommitMessage() {
            return this.commitMessage;
        }

        @Override
        public boolean doUserCommit(@NotNull List<VcsCommitMetadata> successfulCommits, @NotNull List<VcsCommitMetadata> alreadyPicked) {
            Intrinsics.checkNotNullParameter(successfulCommits, (String)"successfulCommits");
            Intrinsics.checkNotNullParameter(alreadyPicked, (String)"alreadyPicked");
            ActionsKt.runInEdt$default(null, () -> StagingAreaCommit.doUserCommit$lambda$0(this), (int)1, null);
            return false;
        }

        private static final Unit doUserCommit$lambda$0(StagingAreaCommit this$0) {
            Project project = this$0.repository.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            GitStageContentProviderKt.showStagingArea(project, this$0.commitMessage);
            return Unit.INSTANCE;
        }
    }
}

