/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.shadowed.com.ibm.icu.text;

import org.graalvm.shadowed.com.ibm.icu.text.Replaceable;
import org.graalvm.shadowed.com.ibm.icu.text.Transliterator;
import org.graalvm.shadowed.com.ibm.icu.text.UnicodeReplacer;
import org.graalvm.shadowed.com.ibm.icu.text.UnicodeSet;

class FunctionReplacer
implements UnicodeReplacer {
    private Transliterator translit;
    private UnicodeReplacer replacer;

    public FunctionReplacer(Transliterator theTranslit, UnicodeReplacer theReplacer) {
        this.translit = theTranslit;
        this.replacer = theReplacer;
    }

    @Override
    public int replace(Replaceable text2, int start2, int limit, int[] cursor) {
        int len = this.replacer.replace(text2, start2, limit, cursor);
        limit = start2 + len;
        limit = this.translit.transliterate(text2, start2, limit);
        return limit - start2;
    }

    @Override
    public String toReplacerPattern(boolean escapeUnprintable) {
        StringBuilder rule = new StringBuilder("&");
        rule.append(this.translit.getID());
        rule.append("( ");
        rule.append(this.replacer.toReplacerPattern(escapeUnprintable));
        rule.append(" )");
        return rule.toString();
    }

    @Override
    public void addReplacementSetTo(UnicodeSet toUnionTo) {
        toUnionTo.addAll(this.translit.getTargetSet());
    }
}

