/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.shadowed.com.ibm.icu.impl.breakiter;

import java.text.CharacterIterator;
import org.graalvm.shadowed.com.ibm.icu.impl.CharacterIteration;
import org.graalvm.shadowed.com.ibm.icu.impl.breakiter.DictionaryBreakEngine;
import org.graalvm.shadowed.com.ibm.icu.impl.breakiter.LanguageBreakEngine;
import org.graalvm.shadowed.com.ibm.icu.lang.UCharacter;
import org.graalvm.shadowed.com.ibm.icu.text.UnicodeSet;

public final class UnhandledBreakEngine
implements LanguageBreakEngine {
    volatile UnicodeSet fHandled = new UnicodeSet();

    @Override
    public boolean handles(int c) {
        return this.fHandled.contains(c);
    }

    @Override
    public int findBreaks(CharacterIterator text2, int startPos, int endPos, DictionaryBreakEngine.DequeI foundBreaks, boolean isPhraseBreaking) {
        UnicodeSet uniset = this.fHandled;
        int c = CharacterIteration.current32(text2);
        while (text2.getIndex() < endPos && uniset.contains(c)) {
            CharacterIteration.next32(text2);
            c = CharacterIteration.current32(text2);
        }
        return 0;
    }

    public void handleChar(int c) {
        UnicodeSet originalSet = this.fHandled;
        if (!originalSet.contains(c)) {
            int script = UCharacter.getIntPropertyValue(c, 4106);
            UnicodeSet newSet = new UnicodeSet();
            newSet.applyIntPropertyValue(4106, script);
            newSet.addAll(originalSet);
            this.fHandled = newSet;
        }
    }
}

