/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.temporal;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.List;

public abstract class JSTemporalBuiltinOperation
extends JSBuiltinNode {
    @Node.Child
    protected IsObjectNode isObjectNode = IsObjectNode.create();

    public JSTemporalBuiltinOperation(JSContext context2, JSBuiltin builtin) {
        super(context2, builtin);
    }

    protected JSDynamicObject getOptionsObject(Object options, Node node, InlinedBranchProfile errorBranch, InlinedConditionProfile optionUndefined) {
        if (optionUndefined.profile(node, options == Undefined.instance)) {
            return JSOrdinary.createWithNullPrototype(this.getContext());
        }
        if (this.isObject(options)) {
            return TemporalUtil.toJSDynamicObject(options, node, errorBranch);
        }
        errorBranch.enter(this);
        throw TemporalErrors.createTypeErrorOptions();
    }

    protected boolean isObject(Object obj) {
        return this.isObjectNode.executeBoolean(obj);
    }

    protected static TemporalUtil.Unit toLargestTemporalUnit(JSDynamicObject normalizedOptions, List<TruffleString> disallowedUnits, TruffleString fallback, TemporalUtil.Unit autoValue, TruffleString.EqualNode equalNode, TemporalGetOptionNode getOptionNode, Node node, InlinedBranchProfile errorBranch) {
        assert (fallback == null || !disallowedUnits.contains(fallback) && !disallowedUnits.contains(TemporalConstants.AUTO));
        TruffleString largestUnit = (TruffleString)getOptionNode.execute(normalizedOptions, TemporalConstants.LARGEST_UNIT, TemporalUtil.OptionType.STRING, TemporalUtil.listAllDateTimeAuto, fallback);
        if (largestUnit != null && largestUnit.equals(TemporalConstants.AUTO) && autoValue != null) {
            return autoValue;
        }
        if (largestUnit != null && Boundaries.setContains(TemporalUtil.pluralUnits, largestUnit)) {
            largestUnit = Boundaries.mapGet(TemporalUtil.pluralToSingular, largestUnit);
        }
        if (largestUnit != null && Boundaries.listContains(disallowedUnits, largestUnit)) {
            errorBranch.enter(node);
            throw Errors.createRangeError("Largest unit is not allowed.");
        }
        return TemporalUtil.toUnit(largestUnit, equalNode);
    }

    protected static TemporalUtil.Unit toSmallestTemporalUnit(JSDynamicObject normalizedOptions, List<TruffleString> disallowedUnits, TruffleString fallback, TruffleString.EqualNode equalNode, TemporalGetOptionNode getOptionNode, Node node, InlinedBranchProfile errorBranch) {
        TruffleString smallestUnit = (TruffleString)getOptionNode.execute(normalizedOptions, TemporalConstants.SMALLEST_UNIT, TemporalUtil.OptionType.STRING, TemporalUtil.listAllDateTime, fallback);
        if (smallestUnit != null && Boundaries.setContains(TemporalUtil.pluralUnits, smallestUnit)) {
            smallestUnit = Boundaries.mapGet(TemporalUtil.pluralToSingular, smallestUnit);
        }
        if (smallestUnit != null && Boundaries.listContains(disallowedUnits, smallestUnit)) {
            errorBranch.enter(node);
            throw Errors.createRangeError("Smallest unit not allowed.");
        }
        return TemporalUtil.toUnit(smallestUnit, equalNode);
    }

    protected static TemporalUtil.Unit toTemporalDurationTotalUnit(JSDynamicObject normalizedOptions, TruffleString.EqualNode equalNode, TemporalGetOptionNode getOptionNode) {
        TruffleString unit = (TruffleString)getOptionNode.execute(normalizedOptions, TemporalConstants.UNIT, TemporalUtil.OptionType.STRING, TemporalUtil.listAllDateTime, null);
        if (unit != null && Boundaries.setContains(TemporalUtil.pluralUnits, unit)) {
            unit = Boundaries.mapGet(TemporalUtil.pluralToSingular, unit);
        }
        return TemporalUtil.toUnit(unit, equalNode);
    }

    protected static TemporalUtil.RoundingMode toTemporalRoundingMode(JSDynamicObject options, TruffleString fallback, TruffleString.EqualNode equalNode, TemporalGetOptionNode getOptionNode) {
        return TemporalUtil.toRoundingMode((TruffleString)getOptionNode.execute(options, TemporalConstants.ROUNDING_MODE, TemporalUtil.OptionType.STRING, TemporalUtil.listRoundingMode, fallback), equalNode);
    }
}

