/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.PerformanceBuiltinsFactory;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.objects.JSAttributes;

public final class PerformanceBuiltins
extends JSBuiltinsContainer.Lambda {
    public static final JSBuiltinsContainer BUILTINS = new PerformanceBuiltins();

    protected PerformanceBuiltins() {
        super(JSRealm.PERFORMANCE_CLASS_NAME);
        this.defineFunction(Strings.NOW, 0, JSAttributes.getDefault(), (context2, builtin) -> PerformanceBuiltinsFactory.JSPerformanceNowNodeGen.create(context2, builtin, PerformanceBuiltins.args().fixedArgs(0).createArgumentNodes(context2)));
    }

    public static abstract class JSPerformanceNowNode
    extends JSBuiltinNode {
        public JSPerformanceNowNode(JSContext context2, JSBuiltin builtin) {
            super(context2, builtin);
        }

        @Specialization
        protected double now() {
            long ns = this.getRealm().nanoTime();
            return (double)ns / 1000000.0;
        }
    }
}

