/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.okhttp.minimal.builder.analysis;

import com.intellij.httpClient.okhttp.minimal.builder.analysis.httpUrl.HttpUrl;
import com.intellij.httpClient.okhttp.minimal.builder.analysis.httpUrl.HttpUrlBuilderEvaluatorKt;
import com.intellij.httpClient.okhttp.minimal.builder.analysis.httpUrl.HttpUrlEvaluationStrategy;
import com.intellij.httpClient.okhttp.minimal.builder.analysis.request.Request;
import com.intellij.httpClient.okhttp.minimal.builder.analysis.request.RequestBuilderEvaluatorKt;
import com.intellij.httpClient.okhttp.minimal.builder.analysis.request.RequestEvaluationStrategy;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PartiallyKnownString;
import com.intellij.psi.util.StringEntry;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.analysis.UNeDfaConfiguration;
import org.jetbrains.uast.analysis.UNeDfaValueEvaluator;
import org.jetbrains.uast.analysis.UStringEvaluationStrategy;
import org.jetbrains.uast.analysis.UStringEvaluatorKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u001a\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0000\u001a\u001a\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00072\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\u0018\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\tH\u0002\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0015"}, d2={"emptyUnknown", "Lcom/intellij/psi/util/StringEntry$Unknown;", "getEmptyUnknown", "()Lcom/intellij/psi/util/StringEntry$Unknown;", "collectUrlInformation", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "containingFile", "Lcom/intellij/psi/PsiFile;", "concat", "Lcom/intellij/psi/util/PartiallyKnownString;", "baseUrl", "url", "calculateStringParameter", "call", "parameterIndex", "", "stringEvaluationConfiguration", "Lorg/jetbrains/uast/analysis/UNeDfaConfiguration;", "file", "intellij.httpClient.okhttp.minimal"})
@SourceDebugExtension(value={"SMAP\nokHttpBuilderAnalysisUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 okHttpBuilderAnalysisUtils.kt\ncom/intellij/httpClient/okhttp/minimal/builder/analysis/OkHttpBuilderAnalysisUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,66:1\n1#2:67\n*E\n"})
public final class OkHttpBuilderAnalysisUtilsKt {
    @NotNull
    private static final StringEntry.Unknown emptyUnknown;

    @NotNull
    public static final StringEntry.Unknown getEmptyUnknown() {
        return emptyUnknown;
    }

    @ApiStatus.Internal
    @Nullable
    public static final Object collectUrlInformation(@NotNull UCallExpression node, @NotNull PsiFile containingFile) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)containingFile, (String)"containingFile");
        Request request = (Request)UNeDfaValueEvaluator.calculateContainingBuilderValue$default((UNeDfaValueEvaluator)new UNeDfaValueEvaluator((UNeDfaValueEvaluator.UValueEvaluatorStrategy)RequestEvaluationStrategy.INSTANCE), (UElement)((UElement)node), RequestBuilderEvaluatorKt.requestEvaluationConfiguration(containingFile), (boolean)false, (int)4, null);
        if (request != null) {
            return request;
        }
        HttpUrl url = (HttpUrl)UNeDfaValueEvaluator.calculateContainingBuilderValue$default((UNeDfaValueEvaluator)new UNeDfaValueEvaluator((UNeDfaValueEvaluator.UValueEvaluatorStrategy)HttpUrlEvaluationStrategy.INSTANCE), (UElement)((UElement)node), HttpUrlBuilderEvaluatorKt.httpUrlEvaluationConfiguration(containingFile), (boolean)false, (int)4, null);
        return url;
    }

    @NotNull
    public static final PartiallyKnownString concat(@NotNull PartiallyKnownString baseUrl, @NotNull PartiallyKnownString url) {
        PartiallyKnownString partiallyKnownString;
        StringEntry.Known lastUrlSegment;
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Object object = CollectionsKt.lastOrNull((List)baseUrl.getSegments());
        StringEntry.Known lastBaseUrlSegment = object instanceof StringEntry.Known ? (StringEntry.Known)object : null;
        Object object2 = CollectionsKt.lastOrNull((List)url.getSegments());
        StringEntry.Known known = lastUrlSegment = object2 instanceof StringEntry.Known ? (StringEntry.Known)object2 : null;
        if (lastBaseUrlSegment == null || lastUrlSegment == null) {
            return new PartiallyKnownString(CollectionsKt.plus((Collection)baseUrl.getSegments(), (Iterable)url.getSegments()));
        }
        if (StringsKt.startsWith$default((String)lastUrlSegment.getValue(), (String)"/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)lastBaseUrlSegment.getValue(), (String)"/", (boolean)false, (int)2, null)) {
            String string = StringsKt.removeSuffix((String)lastBaseUrlSegment.getValue(), (CharSequence)"/");
            PsiElement psiElement = lastBaseUrlSegment.getSourcePsi();
            TextRange textRange = lastBaseUrlSegment.getRange().grown(-1);
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"grown(...)");
            StringEntry.Known newLastBaseSegment = new StringEntry.Known(string, psiElement, textRange);
            partiallyKnownString = new PartiallyKnownString(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.dropLast((List)baseUrl.getSegments(), (int)1), (Object)newLastBaseSegment), (Iterable)url.getSegments()));
        } else if (!StringsKt.startsWith$default((String)lastUrlSegment.getValue(), (String)"/", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)lastBaseUrlSegment.getValue(), (String)"/", (boolean)false, (int)2, null)) {
            Collection collection = baseUrl.getSegments();
            TextRange textRange = TextRange.EMPTY_RANGE;
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"EMPTY_RANGE");
            partiallyKnownString = new PartiallyKnownString(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)collection, (Object)new StringEntry.Known("/", null, textRange)), (Iterable)url.getSegments()));
        } else {
            partiallyKnownString = new PartiallyKnownString(CollectionsKt.plus((Collection)baseUrl.getSegments(), (Iterable)url.getSegments()));
        }
        return partiallyKnownString;
    }

    @NotNull
    public static final PartiallyKnownString calculateStringParameter(@NotNull UCallExpression call2, int parameterIndex) {
        UExpression uExpression;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                uExpression = call2.getArgumentForParameter(parameterIndex);
                if (uExpression == null) break block4;
                UExpression argument = uExpression;
                boolean bl = false;
                PsiElement psiElement = argument.getSourcePsi();
                PartiallyKnownString partiallyKnownString = (PartiallyKnownString)UStringEvaluatorKt.UStringEvaluator().calculateValue((UElement)argument, OkHttpBuilderAnalysisUtilsKt.stringEvaluationConfiguration((PsiFile)(psiElement != null ? psiElement.getContainingFile() : null)));
                if (partiallyKnownString == null) {
                    partiallyKnownString = UStringEvaluationStrategy.INSTANCE.constructUnknownValue((UElement)argument);
                }
                uExpression = partiallyKnownString;
                if (partiallyKnownString != null) break block5;
            }
            uExpression = UStringEvaluationStrategy.INSTANCE.constructUnknownValue((UElement)call2);
        }
        return uExpression;
    }

    public static /* synthetic */ PartiallyKnownString calculateStringParameter$default(UCallExpression uCallExpression, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return OkHttpBuilderAnalysisUtilsKt.calculateStringParameter(uCallExpression, n);
    }

    private static final UNeDfaConfiguration<PartiallyKnownString> stringEvaluationConfiguration(PsiFile file) {
        LocalSearchScope localSearchScope;
        PsiFile psiFile = file;
        if (psiFile != null) {
            PsiFile it = psiFile;
            boolean bl = false;
            localSearchScope = new LocalSearchScope((PsiElement)file);
        } else {
            localSearchScope = LocalSearchScope.EMPTY;
        }
        LocalSearchScope localSearchScope2 = localSearchScope;
        Intrinsics.checkNotNull((Object)localSearchScope2);
        LocalSearchScope localSearchScope3 = localSearchScope2;
        return new UNeDfaConfiguration(0, 2, null, (SearchScope)localSearchScope3, null, null, null, false, 245, null);
    }

    static {
        TextRange textRange = TextRange.EMPTY_RANGE;
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"EMPTY_RANGE");
        emptyUnknown = new StringEntry.Unknown(null, textRange, null, 4, null);
    }
}

