/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.folding;

import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.executor.graphql.request.GraphQLPresentationKt;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocComment;
import com.intellij.httpClient.http.request.psi.HttpHeaderFieldValue;
import com.intellij.httpClient.http.request.psi.HttpMessageBody;
import com.intellij.httpClient.http.request.psi.HttpMultipartField;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestBody;
import com.intellij.httpClient.http.request.psi.HttpRequestElementTypes;
import com.intellij.httpClient.http.request.psi.HttpRequestMessage;
import com.intellij.httpClient.http.request.psi.HttpRequestMessagesGroup;
import com.intellij.httpClient.http.request.psi.impl.HttpRequestPsiImplUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestFoldingBuilder
implements FoldingBuilder,
DumbAware {
    public static final int DIFFERENCE_FILES_LIMIT = 3;
    private static final int GRAPHQL_PLACEHOLDER_LIMIT = 30;

    public FoldingDescriptor @NotNull [] buildFoldRegions(@NotNull ASTNode node, @NotNull Document document) {
        if (node == null) {
            HttpRequestFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (document == null) {
            HttpRequestFoldingBuilder.$$$reportNull$$$0(1);
        }
        ArrayList<FoldingDescriptor> descriptors = new ArrayList<FoldingDescriptor>();
        HttpRequestFoldingBuilder.collectDescriptors(node, descriptors);
        FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(FoldingDescriptor.EMPTY_ARRAY);
        if (foldingDescriptorArray == null) {
            HttpRequestFoldingBuilder.$$$reportNull$$$0(2);
        }
        return foldingDescriptorArray;
    }

    private static void collectDescriptors(@NotNull ASTNode node, @NotNull List<FoldingDescriptor> descriptors) {
        ASTNode[] requestBlocks;
        if (node == null) {
            HttpRequestFoldingBuilder.$$$reportNull$$$0(3);
        }
        if (descriptors == null) {
            HttpRequestFoldingBuilder.$$$reportNull$$$0(4);
        }
        for (ASTNode requestBlockNode : requestBlocks = node.getChildren(TokenSet.create((IElementType[])new IElementType[]{HttpRequestElementTypes.REQUEST_BLOCK}))) {
            ASTNode requestNode = requestBlockNode.findChildByType(HttpRequestElementTypes.REQUEST);
            if (requestNode == null) continue;
            HttpRequestFoldingBuilder.collectMultipartRequests(requestNode, descriptors);
            HttpRequestFoldingBuilder.collectScriptPart(requestNode, descriptors);
            HttpRequestFoldingBuilder.collectDifferenceFiles(requestNode, descriptors);
            HttpRequestFoldingBuilder.collectGraphQLQueryFolding(requestNode, descriptors);
            if (requestNode.findChildByType(HttpRequestElementTypes.METHOD) == null) continue;
            descriptors.add(new FoldingDescriptor(requestNode, requestNode.getTextRange()));
        }
    }

    private static void collectMultipartRequests(@NotNull ASTNode node, @NotNull List<FoldingDescriptor> descriptors) {
        ASTNode multipartMessageNode;
        if (node == null) {
            HttpRequestFoldingBuilder.$$$reportNull$$$0(5);
        }
        if (descriptors == null) {
            HttpRequestFoldingBuilder.$$$reportNull$$$0(6);
        }
        if ((multipartMessageNode = node.findChildByType(HttpRequestElementTypes.MULTIPART_MESSAGE)) != null) {
            ASTNode[] multipartFields;
            for (ASTNode multipartFieldNode : multipartFields = multipartMessageNode.getChildren(TokenSet.create((IElementType[])new IElementType[]{HttpRequestElementTypes.MULTIPART_FIELD}))) {
                ASTNode prevElement = HttpRequestFoldingBuilder.skipCommentsAndWhitespaces(multipartFieldNode);
                int startOffset = prevElement != null && prevElement.getElementType() == HttpRequestElementTypes.MESSAGE_BOUNDARY ? prevElement.getTextRange().getStartOffset() : multipartFieldNode.getTextRange().getStartOffset();
                descriptors.add(new FoldingDescriptor(multipartFieldNode, new TextRange(startOffset, multipartFieldNode.getTextRange().getEndOffset())));
            }
        }
    }

    private static void collectScriptPart(@NotNull ASTNode node, @NotNull List<FoldingDescriptor> descriptors) {
        ASTNode responseHandlerNode;
        if (node == null) {
            HttpRequestFoldingBuilder.$$$reportNull$$$0(7);
        }
        if (descriptors == null) {
            HttpRequestFoldingBuilder.$$$reportNull$$$0(8);
        }
        if ((responseHandlerNode = node.findChildByType(HttpRequestElementTypes.RESPONSE_HANDLER)) != null) {
            descriptors.add(new FoldingDescriptor(responseHandlerNode, responseHandlerNode.getTextRange()));
        }
    }

    private static void collectDifferenceFiles(@NotNull ASTNode node, @NotNull List<FoldingDescriptor> descriptors) {
        ASTNode[] differenceFiles;
        if (node == null) {
            HttpRequestFoldingBuilder.$$$reportNull$$$0(9);
        }
        if (descriptors == null) {
            HttpRequestFoldingBuilder.$$$reportNull$$$0(10);
        }
        if ((differenceFiles = node.getChildren(TokenSet.create((IElementType[])new IElementType[]{HttpRequestElementTypes.DIFFERENCE_FILE}))).length <= 3) {
            return;
        }
        descriptors.add(new DifferenceFilesFoldingDescriptor(node, differenceFiles, 3));
    }

    private static void collectGraphQLQueryFolding(@NotNull ASTNode node, @NotNull List<FoldingDescriptor> descriptors) {
        ASTNode method;
        if (node == null) {
            HttpRequestFoldingBuilder.$$$reportNull$$$0(11);
        }
        if (descriptors == null) {
            HttpRequestFoldingBuilder.$$$reportNull$$$0(12);
        }
        if ((method = node.findChildByType(HttpRequestElementTypes.METHOD)) == null) {
            return;
        }
        if (!method.getPsi().textMatches((CharSequence)"GRAPHQL")) {
            return;
        }
        PsiElement requestPsi = node.getPsi();
        if (!(requestPsi instanceof HttpRequest)) {
            return;
        }
        HttpRequestBody body2 = ((HttpRequest)requestPsi).getRequestBody();
        if (!(body2 instanceof HttpRequestMessagesGroup)) {
            return;
        }
        HttpRequestMessage messageBody = (HttpRequestMessage)ContainerUtil.getFirstItem(((HttpRequestMessagesGroup)body2).getRequestMessageList());
        if (!(messageBody instanceof HttpMessageBody)) {
            return;
        }
        TextRange contentRange = ((HttpMessageBody)messageBody).getContentRange();
        String messageText = contentRange.substring(messageBody.getText());
        int graphQLEnd = GraphQLPresentationKt.findGraphQLEnd(messageText);
        String graphQLText = messageText.substring(0, graphQLEnd);
        String placeholder = StringUtil.shortenTextWithEllipsis((String)StringUtil.collapseWhiteSpace((CharSequence)graphQLText), (int)30, (int)0);
        descriptors.add(new FoldingDescriptor(messageBody.getNode(), TextRange.create((int)0, (int)graphQLEnd).shiftRight(messageBody.getTextOffset() + contentRange.getStartOffset()), null, placeholder, Boolean.valueOf(false), Set.of()));
    }

    @Nullable
    private static ASTNode skipCommentsAndWhitespaces(@NotNull ASTNode node) {
        ASTNode curNode;
        if (node == null) {
            HttpRequestFoldingBuilder.$$$reportNull$$$0(13);
        }
        for (curNode = node.getTreePrev(); curNode != null && (curNode.getPsi() instanceof PsiWhiteSpace || curNode.getPsi() instanceof HttpDocComment); curNode = curNode.getTreePrev()) {
        }
        return curNode;
    }

    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        IElementType type;
        if (node == null) {
            HttpRequestFoldingBuilder.$$$reportNull$$$0(14);
        }
        if ((type = node.getElementType()) == HttpRequestElementTypes.REQUEST) {
            ASTNode httpMethodNode = node.findChildByType(HttpRequestElementTypes.METHOD);
            ASTNode httpRequestTargetNode = node.findChildByType(HttpRequestElementTypes.REQUEST_TARGET);
            if (httpMethodNode != null) {
                return httpMethodNode.getText() + (String)(httpRequestTargetNode != null ? " " + httpRequestTargetNode.getText() : "");
            }
        } else if (type == HttpRequestElementTypes.MULTIPART_FIELD) {
            ASTNode messagesGroupNode = node.findChildByType(HttpRequestElementTypes.REQUEST_MESSAGES_GROUP);
            String contentDispositionName = HttpRequestFoldingBuilder.getContentDispositionName(node);
            if (contentDispositionName != null) {
                if (messagesGroupNode != null) {
                    return contentDispositionName + ": " + messagesGroupNode.getText();
                }
                return contentDispositionName;
            }
            if (messagesGroupNode != null) {
                return messagesGroupNode.getText();
            }
            if (node.getFirstChildNode() != null) {
                return node.getFirstChildNode().getText();
            }
        } else if (type == HttpRequestElementTypes.RESPONSE_HANDLER) {
            return "{% ... %}";
        }
        return "...";
    }

    @Nullable
    private static String getContentDispositionName(@NotNull ASTNode node) {
        HttpHeaderFieldValue headerFieldValue;
        PsiElement psiElement;
        if (node == null) {
            HttpRequestFoldingBuilder.$$$reportNull$$$0(15);
        }
        if ((psiElement = node.getPsi()) instanceof HttpMultipartField && (headerFieldValue = HttpRequestPsiImplUtil.getMultipartFieldDescription((HttpMultipartField)node.getPsi())) != null) {
            return headerFieldValue.getHeaderFieldOption("name");
        }
        return null;
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            HttpRequestFoldingBuilder.$$$reportNull$$$0(16);
        }
        return false;
    }

    public boolean isCollapsedByDefault(@NotNull FoldingDescriptor foldingDescriptor) {
        if (foldingDescriptor == null) {
            HttpRequestFoldingBuilder.$$$reportNull$$$0(17);
        }
        return foldingDescriptor instanceof DifferenceFilesFoldingDescriptor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/folding/HttpRequestFoldingBuilder";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldingDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/folding/HttpRequestFoldingBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectDescriptors";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "collectMultipartRequests";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectScriptPart";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectDifferenceFiles";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectGraphQLQueryFolding";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "skipCommentsAndWhitespaces";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getContentDispositionName";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static class DifferenceFilesFoldingDescriptor
    extends FoldingDescriptor {
        DifferenceFilesFoldingDescriptor(@NotNull ASTNode parent, ASTNode @NotNull [] differenceFiles, int limit) {
            if (parent == null) {
                DifferenceFilesFoldingDescriptor.$$$reportNull$$$0(0);
            }
            if (differenceFiles == null) {
                DifferenceFilesFoldingDescriptor.$$$reportNull$$$0(1);
            }
            super(parent, DifferenceFilesFoldingDescriptor.getRange(differenceFiles, limit), null, RestClientBundle.message("http.request.difference.files.folding.placeholder.text", differenceFiles.length - limit), Boolean.valueOf(true), Set.of());
            this.setGutterMarkEnabledForSingleLine(true);
            this.setCanBeRemovedWhenCollapsed(true);
        }

        @NotNull
        private static TextRange getRange(ASTNode @NotNull [] differenceFiles, int limit) {
            if (differenceFiles == null) {
                DifferenceFilesFoldingDescriptor.$$$reportNull$$$0(2);
            }
            assert (differenceFiles.length > limit);
            ASTNode firstToHide = differenceFiles[limit];
            ASTNode lastToHide = differenceFiles[differenceFiles.length - 1];
            return new TextRange(firstToHide.getStartOffset(), lastToHide.getStartOffset() + lastToHide.getTextLength());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "differenceFiles";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/httpClient/http/request/folding/HttpRequestFoldingBuilder$DifferenceFilesFoldingDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

