/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.gitlab.ultimate.features.codeInsight.shell;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.FileContentUtil;
import com.intellij.vcs.gitlab.ultimate.features.codeInsight.shell.GitLabCiLanguageInjectionSettings;
import com.intellij.vcs.gitlab.ultimate.features.codeInsight.shell.GitLabCiShellLanguageInjectionUtilsKt;
import com.intellij.vcs.gitlab.ultimate.features.i18n.GitlabUltimateBundle;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.GitlabIcons;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J#\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096\u0002J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\r\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011H\u0016J\r\u0010\u0012\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016\u00a8\u0006\u001c"}, d2={"Lcom/intellij/vcs/gitlab/ultimate/features/codeInsight/shell/GitLabCiSwitchShellLanguageInjectionIntention;", "Lcom/intellij/codeInsight/intention/PsiElementBaseIntentionAction;", "Lcom/intellij/openapi/util/Iconable;", "<init>", "()V", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailable", "", "getText", "", "Lcom/intellij/codeInspection/util/IntentionName;", "getFamilyName", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "getIcon", "Ljavax/swing/Icon;", "flags", "", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "file", "Lcom/intellij/psi/PsiFile;", "intellij.vcs.gitlab.ultimate.features"})
public final class GitLabCiSwitchShellLanguageInjectionIntention
extends PsiElementBaseIntentionAction
implements Iconable {
    public void invoke(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiElement element) {
        GitLabCiLanguageInjectionSettings settings;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (editor2 instanceof ImaginaryEditor) {
            return;
        }
        settings.setLanguageInjectionEnabled(!(settings = GitLabCiLanguageInjectionSettings.Companion.getInstance(project)).getLanguageInjectionEnabled());
        FileContentUtil.reparseOpenedFiles();
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor2, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = element.getParent();
        if (psiElement == null) {
            return false;
        }
        PsiElement parent = psiElement;
        return GitLabCiShellLanguageInjectionUtilsKt.isAcceptableForShellScriptInjection(parent);
    }

    @NotNull
    public String getText() {
        return GitlabUltimateBundle.INSTANCE.message("intention.GitLabCiSwitchShellLanguageInjectionIntention.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    @Nullable
    public Icon getIcon(int flags) {
        return GitlabIcons.GitLabLogo;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }
}

