/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.reading;

import com.intellij.javascript.nodejs.NodeUIUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8CpuLogCall;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.CpuProfilingView;
import com.jetbrains.nodejs.run.profile.cpu.view.SearchInV8TreeAction;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfilingMainComponent;
import icons.NodeJSIcons;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class V8SwitchViewActionsFactory {
    private final V8ProfilingMainComponent.MyController myController;
    private CpuProfilingView myTopCalls;
    private CpuProfilingView myBottomUp;
    private CpuProfilingView myTopDown;
    private ToViewAction myToTopCalls;
    private ToViewAction myToBottomUp;
    private ToViewAction myToTopDown;

    public V8SwitchViewActionsFactory(V8ProfilingMainComponent.MyController controller) {
        this.myController = controller;
    }

    public void createActions() {
        this.myToTopCalls = new ToViewAction(NodeJSBundle.message("profile.cpu.navigate_in_top_calls.text", new Object[0]), this.myTopCalls, this.myController);
        this.myToBottomUp = new ToViewAction(NodeJSBundle.message("profile.cpu.navigate_in_bottom_up.text", new Object[0]), this.myBottomUp, this.myController);
        this.myToTopDown = new ToViewAction(NodeJSBundle.message("profile.cpu.navigate_in_top_down.text", new Object[0]), this.myTopDown, this.myController);
    }

    public void setTopCalls(CpuProfilingView topCalls) {
        this.myTopCalls = topCalls;
    }

    public void setBottomUp(CpuProfilingView bottomUp) {
        this.myBottomUp = bottomUp;
    }

    public void setTopDown(CpuProfilingView topDown) {
        this.myTopDown = topDown;
    }

    public ToViewAction getToTopCalls() {
        return this.myToTopCalls;
    }

    public ToViewAction getToBottomUp() {
        return this.myToBottomUp;
    }

    public ToViewAction getToTopDown() {
        return this.myToTopDown;
    }

    private static class ToViewAction
    extends DumbAwareAction {
        @NotNull
        private final CpuProfilingView myView;
        private final V8ProfilingMainComponent.MyController myController;

        ToViewAction(@NotNull @Nls String name, @NotNull CpuProfilingView view, V8ProfilingMainComponent.MyController controller) {
            if (name == null) {
                ToViewAction.$$$reportNull$$$0(0);
            }
            if (view == null) {
                ToViewAction.$$$reportNull$$$0(1);
            }
            super(name, name, NodeJSIcons.Navigate_inMainTree);
            this.myView = view;
            this.myController = controller;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ToViewAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ToViewAction.$$$reportNull$$$0(3);
            }
            e.getPresentation().setEnabled(e.getData(V8Utils.SELECTED_CALL) != null && e.getProject() != null);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ToViewAction.$$$reportNull$$$0(4);
            }
            V8CpuLogCall call = (V8CpuLogCall)e.getData(V8Utils.SELECTED_CALL);
            Project project = e.getProject();
            if (call == null || project == null) {
                return;
            }
            SearchInV8TreeAction.Searcher searcher = (SearchInV8TreeAction.Searcher)this.myView.getSearcherFactory().create();
            if (!searcher.search(call.getPresentation(false), false)) {
                NodeUIUtil.balloonInfo((Project)project, (String)NodeJSBundle.message("node.js.v8.cpu.navigation.not.found.error", new Object[0]), null, null);
                return;
            }
            this.myController.showTab(this.myView.getName());
            SearchInV8TreeAction.showCallsInTree(searcher, call, this.myView.getMasterDetails());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "view";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/nodejs/run/profile/cpu/v8log/reading/V8SwitchViewActionsFactory$ToViewAction";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/v8log/reading/V8SwitchViewActionsFactory$ToViewAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

