/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.model;

import com.google.common.collect.ImmutableSet;
import com.intellij.jinja.model.TemplateLanguageTagLibrary;
import com.intellij.jinja.tags.Jinja2TagLibrary;
import com.intellij.jinja.template.DjangoTemplateLanguage;
import com.intellij.jinja.template.tags.Jinja2LoadTag;
import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.django.lang.template.DjangoCustomTagsLoadingRecursiveVisitor;
import com.jetbrains.django.lang.template.ref.DjangoLoadedNameReference;
import com.jetbrains.django.model.modelApi.templates.DjangoTemplateEngineSettings;
import com.jetbrains.django.model.modelApi.templates.PyTemplateEngineSettings;
import com.jetbrains.django.util.DjangoFileUtil;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratable;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import com.jetbrains.python.pyi.PyiFile;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoTagLibrary
implements TemplateLanguageTagLibrary {
    @NonNls
    private static final String SIMPLE_TAG_METHOD = "simple_tag";
    @NonNls
    private static final String ASSIGNMENT_TAG_METHOD = "assignment_tag";
    @NonNls
    private static final String TAG_METHOD = "tag";
    @NonNls
    private static final String INCLUSION_TAG_METHOD = "inclusion_tag";
    @NonNls
    private static final String FILTER_METHOD = "filter";
    @NonNls
    private static final String STRINGFILTER_METHOD = "stringfilter";
    public static final String TAKES_CONTEXT = "takes_context";
    private Set<String> myTags;
    private final Set<String> myBlockTags = ImmutableSet.of((Object)"for", (Object)"block", (Object)"filter", (Object)"spaceless", (Object)"with", (Object)"autoescape", (Object[])new String[]{"comment", "blocktrans", "blocktranslate", "cache", "verbatim"});
    private static final String[] FOR_LOOP_ATTRIBUTES = new String[]{"counter", "counter0", "revcounter", "revcounter0", "first", "last", "parentloop"};
    private static final String[] IF_INNER_TAGS = new String[]{"else", "elif"};
    private static final String[] FOR_INNER_TAGS = new String[]{"empty"};
    private static final String[] BLOCKTRANS_INNER_TAGS = new String[]{"plural"};
    private static final String[] THUMBNAIL_INNER_TAGS = new String[]{"empty"};

    @Override
    public Set<String> getCoreTags() {
        if (this.myTags == null) {
            this.loadTags();
        }
        return this.myTags;
    }

    private void loadTags() {
        try {
            this.myTags = DjangoFileUtil.readFileLines(this.getClass(), "tags.txt");
        }
        catch (IOException e) {
            throw new RuntimeException("Can't read tag names");
        }
    }

    @Override
    public boolean isBlockTag(String name) {
        return this.myBlockTags.contains(name);
    }

    @Override
    public String[] getInnerTags(String tagName) {
        if (tagName.equals("if")) {
            return IF_INNER_TAGS;
        }
        if (tagName.equals("for")) {
            return FOR_INNER_TAGS;
        }
        if (tagName.equals("blocktrans") || tagName.equals("blocktranslate")) {
            return BLOCKTRANS_INNER_TAGS;
        }
        if (tagName.equals("thumbnail")) {
            return THUMBNAIL_INNER_TAGS;
        }
        if (tagName.equals("ifchanged") || tagName.equals("ifequal") || tagName.equals("ifnotequal")) {
            return new String[]{"else"};
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    @Override
    public String getForLoopIterator() {
        return "forloop";
    }

    @Override
    public String[] getForLoopAttributes() {
        return FOR_LOOP_ATTRIBUTES;
    }

    @Override
    public Collection<String> collectLoadedTags(PsiFile template) {
        final HashSet<String> result = new HashSet<String>();
        DjangoTagLibrary.processLoadedTags(template, new Jinja2TagLibrary.TagProcessor(){

            @Override
            public void processTag(String name, PyElement declaration) {
                result.add(name);
            }
        }, true);
        return result;
    }

    @Override
    public Collection<Pair<String, PyFunction>> collectLoadedFilters(PsiFile template) {
        final HashSet<Pair<String, PyFunction>> result = new HashSet<Pair<String, PyFunction>>();
        DjangoTagLibrary.processLoadedTags(template, new Jinja2TagLibrary.TagProcessor(){

            @Override
            public void processFilter(String name, PyElement declaration) {
                if (name != null && declaration instanceof PyFunction) {
                    result.add(Pair.create((Object)name, (Object)((PyFunction)declaration)));
                }
            }
        }, false);
        return result;
    }

    @Override
    public PsiElement resolveTag(PsiFile template, String tagName) {
        ResolveProcessor processor = new ResolveProcessor(tagName, true);
        DjangoTagLibrary.processLoadedTags(template, processor, true);
        return processor.myResult;
    }

    @Override
    public PsiElement resolveFilter(PsiFile template, String name) {
        ResolveProcessor processor = new ResolveProcessor(name, false);
        DjangoTagLibrary.processLoadedTags(template, processor, false);
        return processor.myResult;
    }

    static void processLoadedTags(PsiFile template, final Jinja2TagLibrary.TagProcessor processor, boolean isTag) {
        Module module;
        QualifiedName defaultsQName = QualifiedName.fromComponents((String[])new String[]{"django", "template", isTag ? "defaulttags" : "defaultfilters"});
        List elements = ResolveImportUtil.multiResolveModuleInRoots((QualifiedName)defaultsQName, (PsiElement)template);
        PsiElement defaultsFile = elements.stream().filter(file -> file instanceof PyFile && !(file instanceof PyiFile)).findFirst().orElseGet(() -> (PsiElement)ContainerUtil.getFirstItem((List)elements));
        if (defaultsFile instanceof PyFile) {
            DjangoTagLibrary.processRegisteredTags((PyFile)defaultsFile, processor);
        }
        if (processor.isDone()) {
            return;
        }
        PsiFile psi = template.getViewProvider().getPsi((Language)DjangoTemplateLanguage.INSTANCE);
        if (psi != null) {
            psi.acceptChildren((PsiElementVisitor)new DjangoCustomTagsLoadingRecursiveVisitor(){

                @Override
                public void visitLoadTag(Jinja2LoadTag loadTag) {
                    block4: {
                        super.visitLoadTag(loadTag);
                        if (processor.isDone()) break block4;
                        if (loadTag.getLoadedNames() != null) {
                            PsiReference[] references;
                            for (PsiReference ref : references = loadTag.getReferences()) {
                                DjangoLoadedNameReference.LoadedTag tag;
                                if (!(ref instanceof DjangoLoadedNameReference) || (tag = ((DjangoLoadedNameReference)ref).resolveLoadedTag()) == null || !tag.isTag()) continue;
                                processor.process(tag.getName(), tag.getDeclaration(), tag.isTag());
                            }
                        } else {
                            PsiReference[] references;
                            for (PsiReference reference : references = loadTag.getReferences()) {
                                PsiElement tagsFile = reference.resolve();
                                if (!(tagsFile instanceof PyFile)) continue;
                                DjangoTagLibrary.processRegisteredTags((PyFile)tagsFile, processor);
                            }
                        }
                    }
                }
            });
        }
        if ((module = ModuleUtilCore.findModuleForFile((PsiFile)template.getOriginalFile())) != null) {
            List builtins = StreamEx.of(PyTemplateEngineSettings.getSettings(module)).select(DjangoTemplateEngineSettings.class).flatMap(settings -> settings.getBuiltins().stream()).toList();
            builtins.forEach(location -> {
                List result = ResolveImportUtil.multiResolveModuleInRoots((QualifiedName)QualifiedName.fromDottedString((String)location), (PsiElement)template);
                PsiElement f = result.stream().filter(file -> file instanceof PyFile && !(file instanceof PyiFile)).findFirst().orElseGet(() -> (PsiElement)ContainerUtil.getFirstItem((List)result));
                if (f instanceof PyFile) {
                    DjangoTagLibrary.processRegisteredTags((PyFile)f, processor);
                }
            });
        }
    }

    public static void processRegisteredTags(PyFile file, Jinja2TagLibrary.TagProcessor processor) {
        file.acceptChildren((PsiElementVisitor)new RegisteredTagCollector(processor));
    }

    private static class ResolveProcessor
    extends Jinja2TagLibrary.TagProcessor {
        private final String myName;
        private final boolean myTag;
        private PsiElement myResult;

        ResolveProcessor(String name, boolean isTag) {
            this.myName = name;
            this.myTag = isTag;
        }

        @Override
        public void processTag(@Nullable String name, PyElement declaration) {
            if (name != null && name.equals(this.myName) && this.myTag) {
                this.myResult = declaration;
            }
        }

        @Override
        public void processFilter(@Nullable String name, PyElement declaration) {
            if (name != null && name.equals(this.myName) && !this.myTag) {
                this.myResult = declaration;
            }
        }

        @Override
        public boolean isDone() {
            return this.myResult != null;
        }
    }

    private static class RegisteredTagCollector
    extends PyRecursiveElementVisitor {
        private final Jinja2TagLibrary.TagProcessor myProcessor;

        RegisteredTagCollector(Jinja2TagLibrary.TagProcessor processor) {
            this.myProcessor = processor;
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                RegisteredTagCollector.$$$reportNull$$$0(0);
            }
            if (this.myProcessor.isDone()) {
                return;
            }
            super.visitElement(element);
        }

        public void visitPyFunction(@NotNull PyFunction node) {
            if (node == null) {
                RegisteredTagCollector.$$$reportNull$$$0(1);
            }
            this.processPossibleTagElement((PyDecoratable)node);
        }

        public void visitPyClass(@NotNull PyClass node) {
            if (node == null) {
                RegisteredTagCollector.$$$reportNull$$$0(2);
            }
            this.processPossibleTagElement((PyDecoratable)node);
        }

        private void processPossibleTagElement(@NotNull PyDecoratable node) {
            PyDecoratorList decoratorList;
            if (node == null) {
                RegisteredTagCollector.$$$reportNull$$$0(3);
            }
            if ((decoratorList = node.getDecoratorList()) != null) {
                PyDecorator[] decorators;
                for (PyDecorator decorator : decorators = decoratorList.getDecorators()) {
                    String methodName = RegisteredTagCollector.getRegisterMethodName((PyCallExpression)decorator);
                    if (DjangoTagLibrary.SIMPLE_TAG_METHOD.equals(methodName) || DjangoTagLibrary.ASSIGNMENT_TAG_METHOD.equals(methodName) || DjangoTagLibrary.TAG_METHOD.equals(methodName) || DjangoTagLibrary.INCLUSION_TAG_METHOD.equals(methodName)) {
                        this.processRegisterDecorator((PyElement)node, decorator, true);
                        continue;
                    }
                    if (!DjangoTagLibrary.FILTER_METHOD.equals(methodName)) continue;
                    this.processRegisterDecorator((PyElement)node, decorator, false);
                }
            }
        }

        @Nullable
        private static String getRegisterMethodName(PyCallExpression node) {
            PyReferenceExpression referenceExpression;
            PyExpression qualifier;
            PyExpression callee = node.getCallee();
            if (callee instanceof PyReferenceExpression && (qualifier = (referenceExpression = (PyReferenceExpression)callee).getQualifier()) != null && qualifier.getText().equals("register")) {
                return referenceExpression.getReferencedName();
            }
            return null;
        }

        public void visitPyCallExpression(@NotNull PyCallExpression node) {
            if (node == null) {
                RegisteredTagCollector.$$$reportNull$$$0(4);
            }
            super.visitPyCallExpression(node);
            String methodName = RegisteredTagCollector.getRegisterMethodName(node);
            PyExpression[] args = node.getArguments();
            if (DjangoTagLibrary.TAG_METHOD.equals(methodName) && args.length >= 1) {
                this.processRegisterCall(args, true);
            } else if ((DjangoTagLibrary.SIMPLE_TAG_METHOD.equals(methodName) || DjangoTagLibrary.ASSIGNMENT_TAG_METHOD.equals(methodName) || DjangoTagLibrary.INCLUSION_TAG_METHOD.equals(methodName)) && args.length >= 1) {
                PyKeywordArgument argument;
                PsiReference reference;
                PsiElement psiElement;
                PyCallExpression parent;
                PsiElement call;
                PsiElement psiElement2;
                PyExpression funcRef;
                PyExpression declaration = funcRef = args[0];
                if (DjangoTagLibrary.ASSIGNMENT_TAG_METHOD.equals(methodName)) {
                    PyKeywordArgument keywordArgument;
                    if (funcRef instanceof PyKeywordArgument && DjangoTagLibrary.TAKES_CONTEXT.equals((keywordArgument = (PyKeywordArgument)funcRef).getKeyword()) && (psiElement2 = node.getParent()) instanceof PyCallExpression && (call = (PyCallExpression)psiElement2).getArguments().length > 0) {
                        funcRef = call.getArguments()[0];
                    }
                } else if (DjangoTagLibrary.INCLUSION_TAG_METHOD.equals(methodName) && (call = node.getParent()) instanceof PyCallExpression && (parent = (PyCallExpression)call).getArguments().length > 0) {
                    funcRef = parent.getArguments()[0];
                }
                String name = null;
                if (funcRef instanceof PyReferenceExpression && (psiElement = (reference = funcRef.getReference()).resolve()) instanceof PyFunction) {
                    PyFunction func = (PyFunction)psiElement;
                    name = func.getName();
                    declaration = func;
                }
                if (args.length > 1 && (psiElement2 = args[1]) instanceof PyKeywordArgument && "name".equals((argument = (PyKeywordArgument)psiElement2).getKeyword())) {
                    name = PyPsiUtils.getStringValue((PsiElement)argument.getValueExpression());
                }
                if (!StringUtil.isEmpty(name)) {
                    this.foundTag(name, (PyElement)declaration);
                }
            } else if (DjangoTagLibrary.FILTER_METHOD.equals(methodName) && args.length >= 1) {
                this.processRegisterCall(args, false);
            }
        }

        private void processRegisterDecorator(PyElement node, PyDecorator decorator, boolean isTag) {
            String name = node.getName();
            PyArgumentList args = decorator.getArgumentList();
            if (args != null) {
                String val;
                PyKeywordArgument nameArg = args.getKeywordArgument("name");
                if (nameArg != null) {
                    name = PyPsiUtils.strValue((PyExpression)nameArg.getValueExpression());
                } else if (args.getArguments().length > 0 && !(args.getArguments()[0] instanceof PyKeywordArgument) && RegisteredTagCollector.isTagOrFilter(decorator.getName()) && !StringUtil.isEmpty((String)(val = PyPsiUtils.strValue((PyExpression)args.getArguments()[0])))) {
                    name = val;
                }
            }
            if (!StringUtil.isEmpty((String)name)) {
                if (isTag) {
                    this.foundTag(name, node);
                } else {
                    this.myProcessor.processFilter(name, node);
                }
            }
        }

        private static boolean isTagOrFilter(String name) {
            return DjangoTagLibrary.FILTER_METHOD.equals(name) || DjangoTagLibrary.TAG_METHOD.equals(name);
        }

        private void processRegisterCall(PyExpression[] args, boolean isTag) {
            PyExpression impl;
            PyExpression pyExpression = impl = args.length > 1 ? args[1] : args[0];
            if (impl instanceof PyReferenceExpression) {
                PyExpression[] stringfilterArgs;
                PyCallExpression call;
                PyTargetExpression target;
                PyExpression value2;
                PyReferenceExpression ref = (PyReferenceExpression)impl;
                PsiElement declaration = ref.getReference().resolve();
                String name = null;
                if (args.length > 1 && args[0] instanceof PyStringLiteralExpression) {
                    name = ((PyStringLiteralExpression)args[0]).getStringValue();
                }
                if (declaration instanceof PyTargetExpression && (value2 = (target = (PyTargetExpression)declaration).findAssignedValue()) instanceof PyCallExpression && (call = (PyCallExpression)value2).isCalleeText(new String[]{DjangoTagLibrary.STRINGFILTER_METHOD}) && (stringfilterArgs = call.getArguments()).length == 1 && (declaration = stringfilterArgs[0]) instanceof PyReferenceExpression) {
                    PyReferenceExpression declRef = (PyReferenceExpression)declaration;
                    declaration = declRef.getReference().resolve();
                }
                if (declaration instanceof PyFunction) {
                    PyFunction fn = (PyFunction)declaration;
                    if (name == null) {
                        name = fn.getName();
                    }
                }
                if (name != null && declaration != null) {
                    if (isTag) {
                        this.foundTag(name, (PyElement)declaration);
                    } else {
                        this.myProcessor.processFilter(name, (PyElement)declaration);
                    }
                }
            }
        }

        private void foundTag(String name, PyElement declaration) {
            this.myProcessor.processTag(name, declaration);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/django/model/DjangoTagLibrary$RegisteredTagCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyFunction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyClass";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processPossibleTagElement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyCallExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

